import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleworkspaceGroupSettingsConfig extends cdktf.TerraformMetaArguments {
    /**
    * The group's email address.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/d/group_settings#email DataGoogleworkspaceGroupSettings#email}
    */
    readonly email: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/googleworkspace/d/group_settings googleworkspace_group_settings}
*/
export declare class DataGoogleworkspaceGroupSettings extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "googleworkspace_group_settings";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/googleworkspace/d/group_settings googleworkspace_group_settings} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleworkspaceGroupSettingsConfig
    */
    constructor(scope: Construct, id: string, config: DataGoogleworkspaceGroupSettingsConfig);
    get allowExternalMembers(): cdktf.IResolvable;
    get allowWebPosting(): cdktf.IResolvable;
    get archiveOnly(): cdktf.IResolvable;
    get customFooterText(): string;
    get customReplyTo(): string;
    get customRolesEnabledForSettingsToBeMerged(): cdktf.IResolvable;
    get defaultMessageDenyNotificationText(): string;
    get description(): string;
    private _email?;
    get email(): string;
    set email(value: string);
    get emailInput(): string | undefined;
    get enableCollaborativeInbox(): cdktf.IResolvable;
    get id(): string;
    get includeCustomFooter(): cdktf.IResolvable;
    get includeInGlobalAddressList(): cdktf.IResolvable;
    get isArchived(): cdktf.IResolvable;
    get membersCanPostAsTheGroup(): cdktf.IResolvable;
    get messageModerationLevel(): string;
    get name(): string;
    get primaryLanguage(): string;
    get replyTo(): string;
    get sendMessageDenyNotification(): cdktf.IResolvable;
    get spamModerationLevel(): string;
    get whoCanAssistContent(): string;
    get whoCanContactOwner(): string;
    get whoCanDiscoverGroup(): string;
    get whoCanJoin(): string;
    get whoCanLeaveGroup(): string;
    get whoCanModerateContent(): string;
    get whoCanModerateMembers(): string;
    get whoCanPostMessage(): string;
    get whoCanViewGroup(): string;
    get whoCanViewMembership(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
