import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleworkspaceGroupMembersConfig extends cdktf.TerraformMetaArguments {
    /**
    * Identifies the group in the API request. The value can be the group's email address, group alias, or the unique group ID.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/d/group_members#group_id DataGoogleworkspaceGroupMembers#group_id}
    */
    readonly groupId: string;
    /**
    * If true, lists indirect group memberships
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/d/group_members#include_derived_membership DataGoogleworkspaceGroupMembers#include_derived_membership}
    */
    readonly includeDerivedMembership?: boolean | cdktf.IResolvable;
}
export interface DataGoogleworkspaceGroupMembersMembers {
}
export declare function dataGoogleworkspaceGroupMembersMembersToTerraform(struct?: DataGoogleworkspaceGroupMembersMembers): any;
export declare class DataGoogleworkspaceGroupMembersMembersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleworkspaceGroupMembersMembers | undefined;
    set internalValue(value: DataGoogleworkspaceGroupMembersMembers | undefined);
    get deliverySettings(): string;
    get email(): string;
    get id(): string;
    get role(): string;
    get status(): string;
    get type(): string;
}
export declare class DataGoogleworkspaceGroupMembersMembersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleworkspaceGroupMembersMembersOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/googleworkspace/d/group_members googleworkspace_group_members}
*/
export declare class DataGoogleworkspaceGroupMembers extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "googleworkspace_group_members";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/googleworkspace/d/group_members googleworkspace_group_members} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleworkspaceGroupMembersConfig
    */
    constructor(scope: Construct, id: string, config: DataGoogleworkspaceGroupMembersConfig);
    get etag(): string;
    private _groupId?;
    get groupId(): string;
    set groupId(value: string);
    get groupIdInput(): string | undefined;
    get id(): string;
    private _includeDerivedMembership?;
    get includeDerivedMembership(): boolean | cdktf.IResolvable;
    set includeDerivedMembership(value: boolean | cdktf.IResolvable);
    resetIncludeDerivedMembership(): void;
    get includeDerivedMembershipInput(): boolean | cdktf.IResolvable | undefined;
    private _members;
    get members(): DataGoogleworkspaceGroupMembersMembersList;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
