#ifndef HS_DATATYPE_H
#define HS_DATATYPE_H

/***
version: V1.1.2.3
note: HSDataType.h�汾����API��̬��汾���޹�
***/

#ifdef _WIN32

typedef char				int8;
typedef short				int16;
typedef int					int32;
typedef __int64				int64;
typedef unsigned char		uint8;
typedef unsigned short		uint16;
typedef unsigned int		uint32;
typedef unsigned __int64	uint64;

#else

#include <sys/types.h>

#if defined(__linux__)
#include <stdint.h>
#endif

typedef int8_t				int8;
typedef int16_t				int16;
typedef int32_t				int32;
typedef int64_t				int64;
typedef uint8_t				uint8;
typedef uint16_t			uint16;
typedef uint32_t			uint32;
typedef uint64_t			uint64;

#endif

//////////////////////////////////////////////////////////////////////////
/// HSInstrumentID����Լ����
//////////////////////////////////////////////////////////////////////////
typedef char HSInstrumentID[32];

//////////////////////////////////////////////////////////////////////////
/// HSOptionsType����Ȩ����
//////////////////////////////////////////////////////////////////////////
/// ���ǣ��Ϲ���
#define HS_OT_CallOptions  'C'
/// �������Ϲ���
#define HS_OT_PutOptions   'P'
typedef char HSOptionsType;

//////////////////////////////////////////////////////////////////////////
/// HSExerciseStyle����Ȩ��Ȩ��ʽ
//////////////////////////////////////////////////////////////////////////
/// ��ʽ��Ȩ 
#define HS_American_Options  'A'
/// ŷʽ��Ȩ
#define HS_European_Options   'E'
typedef char HSExerciseStyle;

//////////////////////////////////////////////////////////////////////////
/// HSExchangeID������������
//////////////////////////////////////////////////////////////////////////
/// �Ϻ�֤ȯ������
#define HS_EI_SSE                   "1"
/// ����֤ȯ������
#define HS_EI_SZSE                  "2"
/// ֣����Ʒ������
#define HS_EI_CZCE                  "F1"
/// ������Ʒ������
#define HS_EI_DCE                   "F2"
/// �Ϻ��ڻ�������
#define HS_EI_SHFE                  "F3"
/// �й������ڻ�������
#define HS_EI_CFFEX                 "F4"
/// �Ϻ�������Դ�������Ĺɷ����޹�˾
#define HS_EI_INE                   "F5"
typedef char HSExchangeID[5];

//////////////////////////////////////////////////////////////////////////
/// HSInstrumentName����Լ����
////////////////////////////////////////////////////////////////////////// 
typedef char HSInstrumentName[32];

//////////////////////////////////////////////////////////////////////////
/// HSVolume������(double)
////////////////////////////////////////////////////////////////////////// 
typedef double HSVolume;

//////////////////////////////////////////////////////////////////////////
/// HSIntVolume������(int64)
////////////////////////////////////////////////////////////////////////// 
typedef int64 HSIntVolume;

//////////////////////////////////////////////////////////////////////////
/// HSNum64������
////////////////////////////////////////////////////////////////////////// 
typedef int64 HSNum64;

//////////////////////////////////////////////////////////////////////////
/// HSArbitPositionID�������ֲֺ�
////////////////////////////////////////////////////////////////////////// 
typedef char HSArbitPositionID[32];

//////////////////////////////////////////////////////////////////////////
/// HSLegID���Ⱥ�
////////////////////////////////////////////////////////////////////////// 
typedef double HSLegID;

//////////////////////////////////////////////////////////////////////////
/// HSConfigNo�����ñ��
////////////////////////////////////////////////////////////////////////// 
typedef double HSConfigNo;

//////////////////////////////////////////////////////////////////////////
/// HSConfigValue�����ÿ���״̬
/// ���ݲ�ͬ�����ñ�ţ��в�ͬ���ֵ���
////////////////////////////////////////////////////////////////////////// 
typedef char HSConfigValue[128];

//////////////////////////////////////////////////////////////////////////
/// HSExerciseType����Ȩ��Ȩ����
//////////////////////////////////////////////////////////////////////////
/// ����
#define HS_ET_Abandon '0'
/// ִ��
#define HS_ET_Exec    '1'
typedef char HSExerciseType;

//////////////////////////////////////////////////////////////////////////
/// HSPrice���۸�
////////////////////////////////////////////////////////////////////////// 
typedef double HSPrice;

//////////////////////////////////////////////////////////////////////////
/// HSBalance�����
////////////////////////////////////////////////////////////////////////// 
typedef double HSBalance;

//////////////////////////////////////////////////////////////////////////
/// HSSeqNo�����
////////////////////////////////////////////////////////////////////////// 
typedef int64 HSSeqNo;

//////////////////////////////////////////////////////////////////////////
/// HSDate������ ��ʽYYYYMMDD
////////////////////////////////////////////////////////////////////////// 
typedef int32 HSDate;

//////////////////////////////////////////////////////////////////////////
/// HSMsgContent����Ϣ����
//////////////////////////////////////////////////////////////////////////
typedef char HSMsgContent[256];

//////////////////////////////////////////////////////////////////////////
/// HSCombStrategyID����ϲ��Ա���
//////////////////////////////////////////////////////////////////////////
/// �Ϲ�ţ�м۲�
#define HS_CSI_CNSJC  "CNSJC"
/// �Ϲ����м۲�
#define HS_CSI_PXSJC  "PXSJC"
/// �Ϲ�ţ�м۲�
#define HS_CSI_PNSJC  "PNSJC"
/// �Ϲ����м۲�
#define HS_CSI_CXSJC  "CXSJC"
/// ��ʽ��ͷ
#define HS_CSI_KS     "KS"
/// ����ʽ��ͷ
#define HS_CSI_KKS    "KKS"
/// ��ͨת����
#define HS_CSI_ZBD    "ZBD"
/// ����ת��ͨ
#define HS_CSI_ZXJ    "ZXJ"
typedef char HSCombStrategyID[9];

/////////////////////////////////////////////////////////////////////////
/// HSRemarks����ע
/////////////////////////////////////////////////////////////////////////
typedef char HSRemarks[256];

/////////////////////////////////////////////////////////////////////////
/// HSDirection��������������
/////////////////////////////////////////////////////////////////////////
/// ��
#define HS_DC_Buy     '1'
/// ��
#define HS_DC_Sell    '2'
/// ����
#define HS_DC_Loan    'F'
/// ����
#define HS_DC_Borrow  'G'
typedef char HSDirection;

/////////////////////////////////////////////////////////////////////////
/// HSOrderDirection��������������
/////////////////////////////////////////////////////////////////////////
/// ��
#define HS_OD_Buy            1
/// ��					    
#define HS_OD_Sell           2
/// �¹��깺(������������ծ�깺)			    
#define HS_OD_Apply          3
/// ���				      
#define HS_OD_MarthSecu      4
///ծȯת��
#define HS_OD_BondConv		 5
///ծȯ����
#define HS_OD_BondCall		 6
/// ��Ѻ���		        
#define HS_OD_PledgeIn       7
/// ��Ѻ����		        
#define HS_OD_PledgeOut      8
/// ���ع�				     
#define HS_OD_Repos          9
/// ��ع�				     
#define HS_OD_ReverseRepos   10
/// ETF�Ϲ�				     
#define HS_OD_EtfSubs        11
/// ETF�깺			  	    
#define HS_OD_EtfPur         12
/// ETF���			  	    
#define HS_OD_EtfRed         13
/// ծȯ���۳���
#define HS_OD_BondCallCan	 14
/// LOF�Ϲ�			  	    
#define HS_OD_LofSubs        16
/// LOF�깺			  	    
#define HS_OD_LofPur         17
/// LOF���			  	    
#define HS_OD_LofRed         18
/// LOFת�й�			  	    
#define HS_OD_LofTrams       19
/// �ּ�������		      
#define HS_OD_FundSplit      20
/// �ּ�����ϲ�		      
#define HS_OD_FundMerger     21
/// �ּ�����ת��		      
#define HS_OD_FundConv       22
/// ���һ����깺
#define HS_OD_CurrFundPur    23
/// ���һ������
#define HS_OD_CurrFundRed    24
/// ����Ʒ����		   	    
#define HS_OD_CreditBuy      33
/// ����Ʒ����		   	    
#define HS_OD_CreditSell     34
/// ����Ʒ�ύ			    
#define HS_OD_CollateralIn   35
/// ����Ʒ����			    
#define HS_OD_CollateralOut  36
/// ��������		        
#define HS_OD_MarginBuy      37
/// ��ȯ����		        
#define HS_OD_ShortSell      38
/// ��ȯ����		        
#define HS_OD_SellRepay      39
/// ��ȯ��ȯ		        
#define HS_OD_BuyRepay       40
/// ��ȯ��ȯ		        
#define HS_OD_HoldRepay      41
typedef int32 HSOrderDirection;

/////////////////////////////////////////////////////////////////////////
/// HSOffsetFlag����ƽ��־����
/////////////////////////////////////////////////////////////////////////
/// ����
#define HS_OF_Open       '1'
/// ƽ��
#define HS_OF_Close      '2'
/// ����
#define HS_OF_Delivery   '3'
/// ƽ���
#define HS_OF_CloseToday '4'
/// ��ϵ���ƽ��
#define HS_OF_CloseSingle '6'
typedef char HSOffsetFlag;

/////////////////////////////////////////////////////////////////////////
/// HSCombDirection�����ָ�������
/////////////////////////////////////////////////////////////////////////
/// ���
#define HS_CD_Comb            '1'
/// ���
#define HS_CD_UnComb          '2'
typedef char HSCombDirection;

//////////////////////////////////////////////////////////////////////////
/// HSRef������
//////////////////////////////////////////////////////////////////////////
typedef char HSRef[33];

//////////////////////////////////////////////////////////////////////////
/// HSTime��ʱ�� ��ʽHHMMSSFFF
//////////////////////////////////////////////////////////////////////////
typedef int32 HSTime;

//////////////////////////////////////////////////////////////////////////
/// HSDurationTime���ܺ�ʱ
//////////////////////////////////////////////////////////////////////////
typedef int32 HSDurationTime;

/////////////////////////////////////////////////////////////////////////
/// HSPositionType���ֲ���������
/// Ȩ����
#define HS_PT_Right                 '0'
/// ����
#define HS_PT_Voluntary             '1'
/// ���ҷ�
#define HS_PT_Covered               '2'
typedef char HSPositionType;

/////////////////////////////////////////////////////////////////////////
/// HSLockType��������������
/////////////////////////////////////////////////////////////////////////
/// ����
#define HS_LT_Lock           '1'
/// ����
#define HS_LT_Unlock         '2'
typedef char HSLockType;

/////////////////////////////////////////////////////////////////////////
/// HSOrderStatus������״̬����
/////////////////////////////////////////////////////////////////////////
/// δ��
#define HS_OS_NotReported                   '0'
/// ����
#define HS_OS_ToBeReported                  '1'
/// �ѱ�
#define HS_OS_Reported                      '2'
/// �ѱ�����
#define HS_OS_ReportedToBeCancel            '3'
/// ���ɴ���
#define HS_OS_PartsTradedToBeCancel         '4'
/// ����
#define HS_OS_CanceledWithPartsTraded       '5'
/// �ѳ�
#define HS_OS_Canceled                      '6'
/// ����
#define HS_OS_PartsTraded                   '7'
/// �ѳ�
#define HS_OS_Traded                        '8'
/// �ϵ�
#define HS_OS_Abandoned                     '9'
/// ����
#define HS_OS_CancelFailed                  'D'
///��ȷ�ϴ���
#define HS_OS_ConfirmedToBeCancel			'U'
/// ��ȷ��
#define HS_OS_Confirmed                     'V'
/// ��ȷ��
#define HS_OS_ToBeConfirmed                 'W'
typedef char HSOrderStatus;

//////////////////////////////////////////////////////////////////////////
/// HSErrorID���������
//////////////////////////////////////////////////////////////////////////
typedef int32 HSErrorID;

//////////////////////////////////////////////////////////////////////////
/// HSErrorMsg��������Ϣ
//////////////////////////////////////////////////////////////////////////
typedef char HSErrorMsg[256];

/////////////////////////////////////////////////////////////////////////
/// HSOrderSource��������������
/////////////////////////////////////////////////////////////////////////
/// ����Ͷ���߷���
#define HS_OSRC_Personal                '0'
/// ����������
#define HS_OSRC_Exchange                '1'
/// ��Ա����
#define HS_OSRC_Member                  '2'
/// ����Ͷ���߷���
#define HS_OSRC_Organization            '3'
/// ��Ӫ���׷���
#define HS_OSRC_Proprietary             '4'
/// �����Է����ṩ�̷���
#define HS_OSRC_MobileServiceProvider   '5'
typedef char HSOrderSource;

//////////////////////////////////////////////////////////////////////////
/// HSTradeID���ɽ�����
//////////////////////////////////////////////////////////////////////////
typedef char HSTradeID[32];

//////////////////////////////////////////////////////////////////////////
/// HSRiskDegree�����ն�
//////////////////////////////////////////////////////////////////////////
typedef double HSRiskDegree;

//////////////////////////////////////////////////////////////////////////
/// HSBankID�����б���
//////////////////////////////////////////////////////////////////////////
typedef char HSBankID[8];

//////////////////////////////////////////////////////////////////////////
/// HSTransferType��ת������
//////////////////////////////////////////////////////////////////////////
/// ����ת���͹�˾
#define HS_TT_BankToBroker '1'
/// ���͹�˾ת����
#define HS_TT_BrokerToBank '2'
typedef char HSTransferType;

//////////////////////////////////////////////////////////////////////////
/// HSBankName���������� 
//////////////////////////////////////////////////////////////////////////
typedef char HSBankName[64];

//////////////////////////////////////////////////////////////////////////
/// HSTransferSource��ת�˷���    
//////////////////////////////////////////////////////////////////////////
/// ���͹�˾
#define HS_TSRC_Broker   '0'
/// ����
#define HS_TSRC_Bank     '1'
/// ����
#define HS_TSRC_Each     '2'
/// ������
#define HS_TSRC_Third    '3'
typedef char HSTransferSource;

//////////////////////////////////////////////////////////////////////////
/// HSTransferStatus��ת��״̬    
//////////////////////////////////////////////////////////////////////////    
/// δ��
#define HS_TS_NotReported         '0'
/// �ѱ�
#define HS_TS_Reported            '1'
/// �ɹ�
#define HS_TS_Success             '2'
/// ����
#define HS_TS_Abandoned           '3'
/// ����
#define HS_TS_ReportedToBeCancel  '4'
/// ����
#define HS_TS_Canceled            '5'
/// ������
#define HS_TS_PendingReversal     '7'
///�ѳ���
#define HS_TS_Reversal            '8'
/// ����
#define HS_TS_ToBeReported        'A'
/// ����
#define HS_TS_Reporting           'P'
/// ��ȷ��
#define HS_TS_Confirmed           'Q'
/// ��ȷ��
#define HS_TS_PendingConfirm      'x'
typedef char HSTransferStatus;

//////////////////////////////////////////////////////////////////////////
/// HSBankAccountID�������˺ű���
//////////////////////////////////////////////////////////////////////////
typedef char HSBankAccountID[32];

//////////////////////////////////////////////////////////////////////////
/// HSAccountID���˺� 
//////////////////////////////////////////////////////////////////////////
typedef char HSAccountID[19];

//////////////////////////////////////////////////////////////////////////
/// HSUserID���ͻ����
//////////////////////////////////////////////////////////////////////////
typedef char HSUserID[32];

//////////////////////////////////////////////////////////////////////////
/// HSBillContent���˵����� 
//////////////////////////////////////////////////////////////////////////
typedef char HSBillContent[256];


//////////////////////////////////////////////////////////////////////////
/// HSHedgeType��Ͷ��(����)/�ױ�/��������
//////////////////////////////////////////////////////////////////////////
/// Ͷ��(����)
#define HS_HT_Speculation       '0'
/// �ױ�
#define HS_HT_Hedge             '1'
/// ����
#define HS_HT_Arbitrage         '2'
/// ������
#define HS_HT_MarketMaker       '3'
/// ����
#define HS_HT_Covered           '4'
typedef char HSHedgeType;

//////////////////////////////////////////////////////////////////////////
/// HSRate������
//////////////////////////////////////////////////////////////////////////
typedef double HSRate;

//////////////////////////////////////////////////////////////////////////
/// HSSessionID���Ự����
//////////////////////////////////////////////////////////////////////////
typedef int32 HSSessionID;

//////////////////////////////////////////////////////////////////////////
/// HSUserStationInfo���û�վ����Ϣ
//////////////////////////////////////////////////////////////////////////
typedef char HSUserStationInfo[256];

//////////////////////////////////////////////////////////////////////////
/// HSOrderSysID���������
//////////////////////////////////////////////////////////////////////////
typedef char HSOrderSysID[32];

//////////////////////////////////////////////////////////////////////////
/// HSCombPositionID����ϳֱֲ���
//////////////////////////////////////////////////////////////////////////
typedef char HSCombPositionID[32];

//////////////////////////////////////////////////////////////////////////
/// HSPassword������
//////////////////////////////////////////////////////////////////////////
typedef char HSPassword[16];

//////////////////////////////////////////////////////////////////////////
/// HSMacAddress��Mac��ַ
//////////////////////////////////////////////////////////////////////////
typedef char HSMacAddress[32];

//////////////////////////////////////////////////////////////////////////
/// HSIPAddress��IP��ַ
//////////////////////////////////////////////////////////////////////////
typedef char HSIPAddress[64];

//////////////////////////////////////////////////////////////////////////
/// HSBillConfirmFlag���Ƿ���Ҫȷ���ʵ��ı�־
//////////////////////////////////////////////////////////////////////////
/// ����Ҫȷ��
#define HS_BCF_NO  '0'
/// ��Ҫȷ��
#define HS_BCF_YES '1'
typedef char HSBillConfirmFlag;

//////////////////////////////////////////////////////////////////////////
/// HSBillConfirmStatus���˵�ȷ��״̬
//////////////////////////////////////////////////////////////////////////
/// δȷ��
#define HS_BCFD_NO  '0'
/// ��ȷ��
#define HS_BCFD_YES '1'
typedef char HSBillConfirmStatus;

//////////////////////////////////////////////////////////////////////////
/// HSDelta����ʵ��
//////////////////////////////////////////////////////////////////////////
typedef double HSDelta;

//////////////////////////////////////////////////////////////////////////
/// HSInstrumentTradeStatus����Լ����״̬
//////////////////////////////////////////////////////////////////////////
/// ����(��ʼǰ)
#define HS_IT_Init               'S'
/// ���Ͼ���
#define HS_IT_CallAuction        'C'
/// ��������
#define HS_IT_Trinding           'T'
/// ����
#define HS_IT_Pause              'B'
/// ����
#define HS_IT_Close              'E'
/// ���̼��Ͼ���
#define HS_IT_ClosingCallAuction 'U'
/// �������ж�
#define HS_IT_Fusing             'V'
/// ��ʱͣ��
#define HS_IT_Halt               'P'
/// ȫ��ͣ��
#define HS_IT_HaltAllDay         '1'
/// �۶�(���м��Ͼ���)
#define HS_IT_FuseToCallAuction  'M'
/// �۶�(��ͣ����������)
#define HS_IT_FuseToClose        'N'
/// �̺���
#define HS_IT_AfterCloseTrade    'A'
typedef char HSInstrumentTradeStatus;

//////////////////////////////////////////////////////////////////////////
/// HSOpenRestriction����Լʵʱ��������
//////////////////////////////////////////////////////////////////////////
/// �����ƿ���
#define HS_OR_NoLimitOpen                '0'
/// ���Ʊ��ҿ���
#define HS_OR_LimitCoveredOpen           '1'
/// ������������
#define HS_OR_LimitSellOpen              '2'
/// �����������֡����ҿ���
#define HS_OR_LimitSellAndCovOpen        '3'
/// �������뿪��
#define HS_OR_LimitBidOpen               '4'
/// �������뿪�֡����ҿ���
#define HS_OR_LimitBidAndCovOpen         '5'
/// �������뿪�֡���������
#define HS_OR_LimitBidAndSellOpen        '6'
/// �������뿪�֡����ҿ��֡���������
#define HS_OR_LimitBidAndSellAndCovOpen  '7'
typedef char HSOpenRestriction[64];

//////////////////////////////////////////////////////////////////////////
/// HSProductID����ԼƷ�����
//////////////////////////////////////////////////////////////////////////
typedef char HSProductID[4];

//////////////////////////////////////////////////////////////////////////
/// HSMaxMarginSideAlgorithm�����߱�֤���㷨����
//////////////////////////////////////////////////////////////////////////
/// ��ʹ�ô��߱�֤���㷨
#define HS_MMSA_NO  '0'
/// ʹ�ô��߱�֤���㷨
#define HS_MMSA_YES '1'
typedef char HSMaxMarginSideAlgorithm;

//////////////////////////////////////////////////////////////////////////
/// HSUserName���ͻ�����
//////////////////////////////////////////////////////////////////////////
typedef char HSUserName[32];

//////////////////////////////////////////////////////////////////////////
/// HSForceCloseReason��ǿƽԭ��
//////////////////////////////////////////////////////////////////////////
/// ��ǿƽ
#define HS_FCR_NotForceClose '0'
/// �ʽ���
#define HS_FCR_LackDeposit '1'
/// �ͻ�����
#define HS_FCR_ClientOverPositionLimit '2'
///��Ա����
#define HS_FCR_MemberOverPositionLimit '3'
/// �ֲַ�������
#define HS_FCR_NotMultiple '4'
/// Υ��
#define HS_FCR_Violation '5'
/// ����
#define HS_FCR_Other '6'
typedef char HSForceCloseReason;

//////////////////////////////////////////////////////////////////////////
/// HSTradingFlag���걨��־
//////////////////////////////////////////////////////////////////////////
/// ��ֹ�걨
#define HS_TF_No  '0'
/// �����걨
#define HS_TF_Yes '1'
typedef char HSTradingFlag;

//////////////////////////////////////////////////////////////////////////
/// HSSwapOrderFlag��������־
//////////////////////////////////////////////////////////////////////////
///�ǻ���
#define HS_SOF_Normal            '0'
/// ����
#define HS_SOF_Swap              '1'
typedef char HSSwapOrderFlag;

//////////////////////////////////////////////////////////////////////////
/// HSPasswordType����������
//////////////////////////////////////////////////////////////////////////
/// �ʽ�����
#define HS_PWDT_Fund             '1'
/// ��������
#define HS_PWDT_Trade            '2'
typedef char HSPasswordType;

//////////////////////////////////////////////////////////////////////////
/// HSOrderCommand������ָ��
//////////////////////////////////////////////////////////////////////////
/// �޼� 
#define HS_CT_Limit                                 1
/// �޼ۼ�ʱȫ���ɽ������� 
#define HS_CT_LimitFOK                              2
/// �޼�����������ʱ�ɽ�ʣ�೷�� 
#define HS_CT_LimitFAK                              3
/// �޼�ֹ�� 
#define HS_CT_LimitStopLoss                         4
/// �޼�ֹӯ 
#define HS_CT_LimitStopProfit                       5
/// �м� 
#define HS_CT_Market                                6
/// �мۼ�ʱȫ���ɽ������� 
#define HS_CT_MarketFOK                             7
/// �м�����������ʱ�ɽ�ʣ�೷�� 
#define HS_CT_MarketFAK                             8
/// �м�ָ���ɽ�������ʱ�ɽ�ʣ�೷�� 
#define HS_CT_MarketFAKV                            9
/// �м�ֹ�� 
#define HS_CT_MarketStopLoss                        10
/// �м�ֹӯ 
#define HS_CT_MarketStopProfit                      11
/// �мۼ�ʱ�ɽ�ʣ��ת�޼� 
#define HS_CT_MarketToLimit                         12
/// �嵵�мۼ�ʱ�ɽ�ʣ�೷�� 
#define HS_CT_Market5FAK                            13
/// �嵵�мۼ�ʱ�ɽ�ʣ��ת�޼� 
#define HS_CT_Market5ToLimit                        14
/// ���żۼ�ʱ�ɽ�ʣ��ת�޼� 
#define HS_CT_Market1ToLimit                        15
/// ���żۼ�ʱ�ɽ�ʣ�೷�� 
#define HS_CT_Market1FAK                            16
/// ���żۼ�ʱȫ���ɽ������� 
#define HS_CT_Market1FOK                            17
/// �������ż�ת�޼�
#define HS_CT_MarketSelfToLimit                     18
/// ���ַ����ż��걨
#define HS_CT_CounterPartyBest		                19
/// �޼�ָ��������ʱ�ɽ�ʣ�೷��
#define HS_CT_LimitFAKV                             20
/// �̺�̶��۸�
#define HS_CT_LimitPFP                              21
typedef int32 HSOrderCommand;

//////////////////////////////////////////////////////////////////////////
/// HSNum������ 
//////////////////////////////////////////////////////////////////////////
typedef int32 HSNum;

//////////////////////////////////////////////////////////////////////////
/// HSBrokerOrderID�����͹�˾�������� 
//////////////////////////////////////////////////////////////////////////
typedef char HSBrokerOrderID[32];

//////////////////////////////////////////////////////////////////////////
/// HSBusinessName��ҵ������
//////////////////////////////////////////////////////////////////////////
typedef char HSBusinessName[64];

//////////////////////////////////////////////////////////////////////////
/// HSUserApplicationType��Ͷ���߶�Ӧ�����
//////////////////////////////////////////////////////////////////////////
typedef char HSUserApplicationType;

//////////////////////////////////////////////////////////////////////////
/// HSUserApplicationInfo��Ͷ���߶�Ӧ����Ϣ
//////////////////////////////////////////////////////////////////////////
typedef char HSUserApplicationInfo[32];

//////////////////////////////////////////////////////////////////////////
/// HSSecurityType:�г�ҵ�����,Ŀǰֻ֧���������ֻ�ҵ������Ȩҵ��
//////////////////////////////////////////////////////////////////////////
///δ֪����
#define  HS_SET_UnKnown      '0'
///��Ʊ
#define  HS_SET_Stock        '1'
///ָ��
#define  HS_SET_Index        '2'
///����
#define  HS_SET_Fund         '3'
///ծȯ
#define  HS_SET_Bond         '4'
///������Ȩ
#define  HS_SET_Option       '5'
///ETF��Ȩ
#define  HS_SET_ETFOption    '6'
typedef char HSSecurityType;

//////////////////////////////////////////////////////////////////////////
/// HSOrdType:ί������
//////////////////////////////////////////////////////////////////////////
/// �м� 
#define HS_ORT_Market         '1'
/// �޼� 
#define HS_ORT_Limit          '2'
/// ��������
#define HS_ORT_MarketSelf     'U'
typedef char HSOrdType;

//////////////////////////////////////////////////////////////////////////
/// HSTrdType:�ɽ�����
//////////////////////////////////////////////////////////////////////////
/// �� 
#define HS_TRD_Inside      'S'
/// �� 
#define HS_TRD_Outside     'B'
/// δ֪
#define HS_TRD_UnKnown     'N'
/// ����
#define HS_TRD_Cancel      '4'
/// ��ͨ�ɽ�
#define HS_TRD_Execute     'F'
typedef char HSTrdType;

//////////////////////////////////////////////////////////////////////////
/// HSTransType:�����������
//////////////////////////////////////////////////////////////////////////
/// ��ʳɽ������ί��
#define HS_TRANS_All      '0'
/// ��ʳɽ�
#define HS_TRANS_Trade    '1'
/// ���ί��
#define HS_TRANS_Entrust  '2'
typedef char HSTransType;

//////////////////////////////////////////////////////////////////////////
/// HSInstrumentEngName����ԼӢ������
//////////////////////////////////////////////////////////////////////////
typedef char HSInstrumentEngName[32];

//////////////////////////////////////////////////////////////////////////
/// HSProductType����Ʒ����
//////////////////////////////////////////////////////////////////////////
/// �ڻ�
#define HS_PTYPE_Futures             '1'
/// �ڻ���Ȩ
#define HS_PTYPE_OptFutu             '2'
/// ���
#define HS_PTYPE_Combination         '3'
/// ����
#define HS_PTYPE_Spot                '4'
/// ��ת��
#define HS_PTYPE_FutuToSpot          '5'
/// ֤ȯ
#define HS_PTYPE_Securities          '6'
/// ��Ʊ��Ȩ
#define HS_PTYPE_OptStock            '7'
typedef char HSProductType;

//////////////////////////////////////////////////////////////////////////
/// HSCurrencyID������
//////////////////////////////////////////////////////////////////////////
/// �����
#define HS_CID_CNY                   '0'
/// ��Ԫ
#define HS_CID_USD                   '1'
/// �۱�
#define HS_CID_HKD                   '2'
typedef char HSCurrencyID;

//////////////////////////////////////////////////////////////////////////
/// HSCloseFlag����Ȩ��Ȩ�����ɵ�ͷ���Ƿ��Զ�ƽ�ֱ�־
//////////////////////////////////////////////////////////////////////////
/// ���Զ�ƽ��
#define HS_CF_NO                    '0'
/// �Զ�ƽ��
#define HS_CF_YES                   '1'
typedef char HSCloseFlag;

//////////////////////////////////////////////////////////////////////////
/// HSCombType���������
//////////////////////////////////////////////////////////////////////////
/// ��ͨ
#define HS_COMBT_PT                 '0'
/// ����
#define HS_COMBT_KQ                 '1'
/// ��Ʒ��
#define HS_COMBT_KPZ                '2'
typedef char HSCombType;

//////////////////////////////////////////////////////////////////////////
/// HSRiskLevel�����յȼ�
//////////////////////////////////////////////////////////////////////////
/// Ĭ����
#define HS_RL_Default               '0'
/// ������
#define HS_RL_Keep                  '1'
/// ������
#define HS_RL_Cautions              '2'
/// �Ƚ���
#define HS_RL_Steady                '3'
/// ������
#define HS_RL_Active                '4'
/// �ɳ���
#define HS_RL_Growth                '6'
/// רҵͶ����
#define HS_RL_Profession            '99'
/// �Զ�����յȼ�
#define HS_RL_Diy                   '100'
typedef char HSRiskLevel[4];

//////////////////////////////////////////////////////////////////////////
/// HSAppIDType���ͻ���ID����
//////////////////////////////////////////////////////////////////////////
///ֱ����Ͷ����
#define HS_AT_Investor					 '1'
///����Ͷ���߹���һ������Ա���ӵ��м�
#define HS_AT_OperatorRelay				 '2'
///Ϊÿ��Ͷ���߶��������ӵ��м�
#define HS_AT_InvestorRelay              '3'
///δ֪
#define HS_AT_UnKnown				     '0'
typedef char HSAppIDType;

//////////////////////////////////////////////////////////////////////////
/// HSAppID���ͻ���ID
//////////////////////////////////////////////////////////////////////////
typedef char HSAppID[32];

//////////////////////////////////////////////////////////////////////////
/// HSAuthCode����֤��
//////////////////////////////////////////////////////////////////////////
typedef char HSAuthCode[128];


//////////////////////////////////////////////////////////////////////////
/// HSAppSysInfo���ͻ���ϵͳ��Ϣ
//////////////////////////////////////////////////////////////////////////
typedef char HSAppSysInfo[2000];

//////////////////////////////////////////////////////////////////////////
/// HSAppSysInfoIntegrity���ͻ���ϵͳ��Ϣ�ɼ�������
//////////////////////////////////////////////////////////////////////////
typedef char HSAppSysInfoIntegrity[2000];

//////////////////////////////////////////////////////////////////////////
/// HSAppAbnormalType���ͻ��˿ͻ���ϵͳ��Ϣ�ɼ��쳣��ʶ����
//////////////////////////////////////////////////////////////////////////
typedef char HSAppAbnormalType;

//////////////////////////////////////////////////////////////////////////
/// HSTradeType���ɽ�����
//////////////////////////////////////////////////////////////////////////
///��ͨ�ɽ���������ϲ��
#define HS_TT_Common                '0'
///��Ȩִ��
#define HS_TT_OptionsExecution      '1'
///OTC�ɽ�
#define HS_TT_OTC                   '2'
///��ת�������ɽ�
#define HS_TT_EFPDerived            '3'
///��������ɽ�
#define HS_TT_CombinationDerived    '4'
typedef char HSTradeType;

//////////////////////////////////////////////////////////////////////////
/// HSTransDirection����������
//////////////////////////////////////////////////////////////////////////
/// ������������
#define HS_TD_In                    '0'
/// �ӽ������ĵ���
#define HS_TD_Out                   '1'
typedef char HSTransDirection;

//////////////////////////////////////////////////////////////////////////
/// HSExchangeRate������
//////////////////////////////////////////////////////////////////////////
typedef double HSExchangeRate;

//////////////////////////////////////////////////////////////////////////
/// HSOccasion������
//////////////////////////////////////////////////////////////////////////
typedef char HSOccasion[32];

//////////////////////////////////////////////////////////////////////////
/// �ر�����ģʽ
enum SUB_TERT_TYPE
{
	//////////////////////////////////////////////////////////////////////
	///�ӱ������տ�ʼ�ش�
	HS_TERT_RESTART = 0,
	///���ϴ��յ�������
	HS_TERT_RESUME,
	///�ӵ�¼�����µĿ�ʼ��
	HS_TERT_QUICK
};

//////////////////////////////////////////////////////////////////////////
/// HSStatus:״̬
//////////////////////////////////////////////////////////////////////////
typedef char HSStatus;

//////////////////////////////////////////////////////////////////////////
/// HSType:���
//////////////////////////////////////////////////////////////////////////
typedef char HSType;

//////////////////////////////////////////////////////////////////////////
/// HSFlag:��־
//////////////////////////////////////////////////////////////////////////
typedef char HSFlag;

//////////////////////////////////////////////////////////////////////////
/// HSRisk:����
//////////////////////////////////////////////////////////////////////////
typedef double HSRisk;               

//////////////////////////////////////////////////////////////////////////
/// HSStockType:֤ȯ���
//////////////////////////////////////////////////////////////////////////
///��Ʊ
#define HS_ST_Stock       "0"
///����
#define HS_ST_Fund        "1"
///���Ȩ֤
#define HS_ST_MarthSecu   "3"
///��ͨ�깺
#define HS_ST_Apply       "4"
///���˹�ծ
#define HS_ST_RegDebt     "9"
///��������
#define HS_ST_FundAppRed  "A"
///LOF����
#define HS_ST_LofFund     "L"
///ETF����
#define HS_ST_EtfFund     "T"
///ETF����
#define HS_ST_EtfAppRed   "N"
///��ҵ��
#define HS_ST_Gem         "c"
///�ƴ����Ʊ
#define HS_ST_Star        "e"
///�ƴ������ƾ֤
#define HS_ST_StarCdr     "g"
///ע���ƴ�ҵ��
#define HS_ST_RegGem      "p"
///ע���ƴ�ҵ�����ƾ֤
#define HS_ST_RegGemCdr   "q"
typedef char HSStockType[5];               

//////////////////////////////////////////////////////////////////////////
/// HSSubStockType:֤ȯ�����
//////////////////////////////////////////////////////////////////////////
///�������ȹ�
#define HS_SST_PublicPreferStock       "01"
///�ǹ������ȹ�
#define HS_SST_NonPublicPreferStock    "02"
///�¹���ֵ�깺
#define HS_SST_MarketValueApply		   "41"
///ծȯ�����깺
#define HS_SST_BondCreditApply		   "G1"
typedef char HSSubStockType[5];

//////////////////////////////////////////////////////////////////////////
/// HSStockCode:֤ȯ����
//////////////////////////////////////////////////////////////////////////
typedef char HSStockCode[7];               

//////////////////////////////////////////////////////////////////////////
/// HSStockAccount:֤ȯ�˻�
//////////////////////////////////////////////////////////////////////////
typedef char HSStockAccount[21];           

//////////////////////////////////////////////////////////////////////////
/// HSStockName:֤ȯ����
//////////////////////////////////////////////////////////////////////////
typedef char HSStockName[33];              

//////////////////////////////////////////////////////////////////////////
/// HSCompactID:��Լ���
//////////////////////////////////////////////////////////////////////////
typedef char HSCompactID[33];              

//////////////////////////////////////////////////////////////////////////
/// HSCashGroupProp:ͷ������
//////////////////////////////////////////////////////////////////////////
///��ͨͷ��
#define HS_CGP_Common       '1'
///ר��ͷ��
#define HS_CGP_Special      '2'
typedef char HSCashGroupProp;

//////////////////////////////////////////////////////////////////////////
/// HSTradeStatus���ɽ�״̬
//////////////////////////////////////////////////////////////////////////
/// �ɽ�
#define HS_TDS_Traded           '0'
/// �ϵ�
#define HS_TDS_Abandoned        '2'
/// ȷ��
#define HS_TDS_Confirmed        '4'
typedef char HSTradeStatus;

//////////////////////////////////////////////////////////////////////////
/// HSEtfStatus���깺���״̬
//////////////////////////////////////////////////////////////////////////
/// ȫ����ֹ
#define HS_ES_BothForbid       '0'
/// ȫ������
#define HS_ES_BothAllow        '1'
/// ֻ���깺
#define HS_ES_OnlyPurchase     '2'
/// ֻ�����
#define HS_ES_OnlyRedeem       '3'
typedef char HSEtfStatus;

//////////////////////////////////////////////////////////////////////////
/// HSEtfType��Etf���
//////////////////////////////////////////////////////////////////////////
/// ����ETF
#define HS_ET_SingelExchEtf       '1'
/// �羳ETF
#define HS_ET_CrossBorderEtf      '2'
/// ����ETF
#define HS_ET_CrossExchEtf        '3'
/// ����ETF
#define HS_ET_CurrencyEtf         '4'
/// ʵ��ծȯETF
#define HS_ET_PhysicalBondEtf     '5'
/// ��ƷETF
#define HS_ET_CommodityEtf        '6'
/// �ֽ�ծȯETF
#define HS_ET_CashBondEtf         '7'
typedef char HSEtfType;

//////////////////////////////////////////////////////////////////////////
/// HSCollateralStatus������״̬
//////////////////////////////////////////////////////////////////////////
/// ����
#define HS_COS_Normal             '0'
/// ��ͣ
#define HS_COS_Pause              '1'
/// ����
#define HS_COS_Cancel             '2'
typedef char HSCollateralStatus;

//////////////////////////////////////////////////////////////////////////
/// HSCreditRateType���������
//////////////////////////////////////////////////////////////////////////
/// ��ͨ��������
#define HS_CRT_MarginBuy	      '1'
/// ��ͨ��ȯ����
#define HS_CRT_ShortSell          '2'
/// ��ͨ���ʷ�Ϣ
#define HS_CRT_MarginBuyFine      '3'
/// ��ͨ��ȯ��Ϣ
#define HS_CRT_ShortSellFine      '4'
/// ר����������
#define HS_CRT_SpeMarginBuy	      '5'
/// ר����ȯ����
#define HS_CRT_SpeShortSell       '6'
/// ר�����ʷ�Ϣ
#define HS_CRT_SpeMarginBuyFine   '7'
/// ר����ȯ��Ϣ
#define HS_CRT_SpeShortSellFine   '8'
typedef char HSCreditRateType;

//////////////////////////////////////////////////////////////////////////
/// HSCompactType����Լ���
//////////////////////////////////////////////////////////////////////////
/// ���ʺ�Լ
#define HS_COT_MarginBuy	      '0'
/// ��ȯ��Լ
#define HS_COT_ShortSell          '1'
/// ������ծ
#define HS_COT_OtherDebit         '2'
typedef char HSCompactType;

//////////////////////////////////////////////////////////////////////////
/// HSCompactSource����Լ��Դ
//////////////////////////////////////////////////////////////////////////
/// ��ͨͷ��
#define HS_COS_Public	        '0'
/// ר��ͷ��
#define HS_COS_Special          '1'
typedef char HSCompactSource;

//////////////////////////////////////////////////////////////////////////
/// HSOrderPartition����������
//////////////////////////////////////////////////////////////////////////
/// ��ͨ����
#define HS_OP_Secu				1
/// ��ͨ�̺�
#define HS_OP_SecuAfof          2
/// ��ͨ�ۺϣ�֤ȯ��ҵ���̺�̶��۸�ҵ��ı��������Ǹ�ֵ��
#define HS_OP_SecuCbp           3
/// �۹�ͨ
#define HS_OP_SecuHk            4
/// ���þ���
#define HS_OP_Crdt              5
/// �����̺�
#define HS_OP_CrdtAfof          6
/// �����ۺϣ�������ȯ��ҵ���̺�̶��۸�ҵ��ı��������Ǹ�ֵ��
#define HS_OP_CrdtCbp           7
typedef int32 HSOrderPartition;

//////////////////////////////////////////////////////////////////////////
/// HSAssetProp���ʲ�����
//////////////////////////////////////////////////////////////////////////
typedef char HSAssetProp;

//////////////////////////////////////////////////////////////////////////
/// HSSessionNo���Ự���
//////////////////////////////////////////////////////////////////////////
typedef int32 HSSessionNo;

//////////////////////////////////////////////////////////////////////////
/// HSSysnodeID��ϵͳ�ڵ���
//////////////////////////////////////////////////////////////////////////
typedef int32 HSSysnodeID;

//////////////////////////////////////////////////////////////////////////
/// HSBatchNo�����κ�
//////////////////////////////////////////////////////////////////////////
typedef int32 HSBatchNo;

//////////////////////////////////////////////////////////////////////////
/// HSOrderID���������걨��� 
//////////////////////////////////////////////////////////////////////////
typedef char HSOrderID[11];

//////////////////////////////////////////////////////////////////////////
/// HSCompactIDStr����Լ��Ŵ�
//////////////////////////////////////////////////////////////////////////
typedef char HSCompactIDStr[2001];

//////////////////////////////////////////////////////////////////////////
/// HSDelistFlag�����б�־
//////////////////////////////////////////////////////////////////////////
/// ����
#define HS_DF_Normal				'0'
/// ����
#define HS_DF_Delist				'1'
typedef char HSDelistFlag;

//////////////////////////////////////////////////////////////////////////
/// HSChannelType��ͨ������
//////////////////////////////////////////////////////////////////////////
/// �޹�
#define HS_CNT_Normal			'0'
/// ��������
#define HS_CNT_Of				'1'
/// �̺�����
#define HS_CNT_Afof				'2'
typedef char HSChannelType;

//////////////////////////////////////////////////////////////////////////
/// HSRealActionType�����ױ䶯����
//////////////////////////////////////////////////////////////////////////
/// ��ܵ���
#define HS_RA_TodayAdjustment	'0'
/// ���׶���
#define HS_RA_Frozen			'1'
/// �ر��ⶳ
#define HS_RA_Unfrozen			'2'
/// ����
#define HS_RA_Deposit			'D'
/// ����
#define HS_RA_Withdrawal		'W'
/// ����
#define HS_RA_Lock				'L'
/// ����
#define HS_RA_Unlock			'U'
typedef char HSRealActionType;

//////////////////////////////////////////////////////////////////////////
/// HSBusinessFlag��ҵ���־
//////////////////////////////////////////////////////////////////////////
typedef int32 HSBusinessFlag;
/// �ͻ��ʽ����
#define HS_BF_FundTrans	        2034
/// �ͻ��ɷݵ���
#define HS_BF_StockTrans	    3005
/// �ͻ�ETF�ֲֵ���
#define HS_BF_EtfStockTrans		3006
/// ��������
#define HS_BF_FinBuy			31000
/// ��ȯ����
#define HS_BF_SellRepay		    31011
/// �Զ����ʸ�ծ�黹
#define HS_BF_AutoFinRepay		31014
/// �Զ����ʷ���֧��
#define HS_BF_PayOff_CashRepay	31016
/// ����ƽ��
#define HS_BF_PayOff_FinRepay	31017
/// ��ȯ����
#define HS_BF_SloSell			31100
/// ��ȯ��ȯ
#define HS_BF_BuyRepay			31101
/// ƽ����ȯ��ȯ
#define HS_BF_PayOff_BuyRepay	31102
/// ֱ�ӻ�ȯ
#define HS_BF_HoldRepay			31103
/// ƽ����ȯ��ȯ
#define HS_BF_PayOff_HoldRepay	31104
/// ��ȯ�ֽ��˽�
#define HS_BF_SloCashRepay	    31107
/// ������ȯ��չ��״̬���
#define HS_BF_CompactApply	    31118

/////////////////////////////////////////////////////////////////////////
/// HSOrderAssStatus����������״̬
/////////////////////////////////////////////////////////////////////////
/// ������¼��
#define HS_OCR_OrderInserted 		 '0'
/// �������걨
#define HS_OCR_OrderReported 		 '1'
/// �����ѱ�������ȷ��
#define HS_OCR_OrderConfirmed 		 '2'
/// ��������������ϳɽ�
#define HS_OCR_OrderTraded			 '3'
/// �������������ϵ�
#define HS_OCR_OrderAbandoned 		 '4'
/// ������¼��
#define HS_OCR_CancelInserted 		 '5' 
/// �������걨
#define HS_OCR_CancelReported		 '6'
/// �����ѱ�������ȷ��
#define HS_OCR_CancelConfirmed		 '7'
/// �������������ϵ�
#define HS_OCR_CancelFailed 		 '8'

typedef char HSOrderAssStatus;

/////////////////////////////////////////////////////////////////////////
/// HSStockProperty���ɷ�����
/////////////////////////////////////////////////////////////////////////
/// ��������ͨ��
#define HS_SP_Unlimited				"00"
/// IPO�����۹�
#define HS_SP_Limited				"01"
typedef char HSStockProperty[3];

//////////////////////////////////////////////////////////////////////////
/// HSMsgBody����Ϣ����
//////////////////////////////////////////////////////////////////////////
typedef char HSMsgBody[4000];

//////////////////////////////////////////////////////////////////////////
/// HSMsgTitle����Ϣ����
//////////////////////////////////////////////////////////////////////////
typedef char HSMsgTitle[256];

//////////////////////////////////////////////////////////////////////////
/// HSMsgType����Ϣ����
//////////////////////////////////////////////////////////////////////////
typedef char HSMsgType;

//////////////////////////////////////////////////////////////////////////
/// HSStrTime��ʱ�䣨�ַ�����ʽ��
//////////////////////////////////////////////////////////////////////////
typedef char HSStrTime[32];

#endif
