## Some notes about the compose functions

Behind the scenes, 
the [Go implementation of Docker compose](https://github.com/docker/compose-cli)
is called a.k.a. Compose v2, not the [Python implementation](https://github.com/docker/compose).

You can verify that `docker compose` is installed by running
```bash
docker compose --help
```
Be careful! it's different from `docker-compose --help`! Notice the `-` between 'docker' and 'compose'.
Compose v2 has no `-` in the command.

If that doesn't work, then [install the cli plugin](https://github.com/docker/compose-cli#compose-v2-aka-local-docker-compose).
it's just a single binary to download.

The Go implementation of compose is still experimental, so take the appropriate precautions.

If you don't need to set any project-wide options, like the project name or 
the compose file path, you can just import `docker` and start working.

```python
from pydock import docker

docker.compose.build()
docker.compose.up()
...
docker.compose.down()
```

Otherwise, you have to define your project-wide options only once, when creating the Docker client.

```python
from pydock import DockerClient

docker = DockerClient(compose_files=["./my-compose-file.yml"])

docker.compose.build()
docker.compose.up()
...
docker.compose.down()
```

You have multiple compose options available (like profiles, env_files, project name) when creating the Docker client. You can check them out 
in the `DockerClient` [documentation](https://duckietown.github.io/pydock/docker_client/#dockerclient).

#### About `docker.compose.images()`.

The Docker command line has a `docker compose images` command. Pydock doesn't have
an equivalent because it's trivial to do so with existing functions.

```
images = [docker.image.inspect(container.image) for container in docker.container.ps()]
```

* `docker.container.ps()` returns the list of all containers in the compose stack.
* `container.image` gives you the id of the Docker image of the container as a `str`.
* `docker.image.inspect()` gives you a `pydock.Image` from a `str`.


{{autogenerated}}
