from collections.abc import Mapping
from typing import Any, TypeVar, Union

from attrs import define as _attrs_define
from attrs import field as _attrs_field

from ..types import UNSET, Unset

T = TypeVar("T", bound="VulnerabilityMetrics")


@_attrs_define
class VulnerabilityMetrics:
    """
    Attributes:
        measured_at (int): UNIX epoch timestamp in milliseconds
        year (Union[Unset, int]):
        month (Union[Unset, int]):
        count (Union[Unset, int]):
    """

    measured_at: int
    year: Union[Unset, int] = UNSET
    month: Union[Unset, int] = UNSET
    count: Union[Unset, int] = UNSET
    additional_properties: dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> dict[str, Any]:
        measured_at = self.measured_at

        year = self.year

        month = self.month

        count = self.count

        field_dict: dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update(
            {
                "measuredAt": measured_at,
            }
        )
        if year is not UNSET:
            field_dict["year"] = year
        if month is not UNSET:
            field_dict["month"] = month
        if count is not UNSET:
            field_dict["count"] = count

        return field_dict

    @classmethod
    def from_dict(cls: type[T], src_dict: Mapping[str, Any]) -> T:
        d = dict(src_dict)
        measured_at = d.pop("measuredAt")

        year = d.pop("year", UNSET)

        month = d.pop("month", UNSET)

        count = d.pop("count", UNSET)

        vulnerability_metrics = cls(
            measured_at=measured_at,
            year=year,
            month=month,
            count=count,
        )

        vulnerability_metrics.additional_properties = d
        return vulnerability_metrics

    @property
    def additional_keys(self) -> list[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
