from collections.abc import Mapping
from typing import Any, TypeVar, Union
from uuid import UUID

from attrs import define as _attrs_define
from attrs import field as _attrs_field

from ..types import UNSET, Unset

T = TypeVar("T", bound="VulnerabilityAlias")


@_attrs_define
class VulnerabilityAlias:
    """
    Attributes:
        uuid (UUID):
        internal_id (Union[Unset, str]):
        cve_id (Union[Unset, str]):
        ghsa_id (Union[Unset, str]):
        sonatype_id (Union[Unset, str]):
        osv_id (Union[Unset, str]):
        snyk_id (Union[Unset, str]):
        gsd_id (Union[Unset, str]):
        vuln_db_id (Union[Unset, str]):
    """

    uuid: UUID
    internal_id: Union[Unset, str] = UNSET
    cve_id: Union[Unset, str] = UNSET
    ghsa_id: Union[Unset, str] = UNSET
    sonatype_id: Union[Unset, str] = UNSET
    osv_id: Union[Unset, str] = UNSET
    snyk_id: Union[Unset, str] = UNSET
    gsd_id: Union[Unset, str] = UNSET
    vuln_db_id: Union[Unset, str] = UNSET
    additional_properties: dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> dict[str, Any]:
        uuid = str(self.uuid)

        internal_id = self.internal_id

        cve_id = self.cve_id

        ghsa_id = self.ghsa_id

        sonatype_id = self.sonatype_id

        osv_id = self.osv_id

        snyk_id = self.snyk_id

        gsd_id = self.gsd_id

        vuln_db_id = self.vuln_db_id

        field_dict: dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update(
            {
                "uuid": uuid,
            }
        )
        if internal_id is not UNSET:
            field_dict["internalId"] = internal_id
        if cve_id is not UNSET:
            field_dict["cveId"] = cve_id
        if ghsa_id is not UNSET:
            field_dict["ghsaId"] = ghsa_id
        if sonatype_id is not UNSET:
            field_dict["sonatypeId"] = sonatype_id
        if osv_id is not UNSET:
            field_dict["osvId"] = osv_id
        if snyk_id is not UNSET:
            field_dict["snykId"] = snyk_id
        if gsd_id is not UNSET:
            field_dict["gsdId"] = gsd_id
        if vuln_db_id is not UNSET:
            field_dict["vulnDbId"] = vuln_db_id

        return field_dict

    @classmethod
    def from_dict(cls: type[T], src_dict: Mapping[str, Any]) -> T:
        d = dict(src_dict)
        uuid = UUID(d.pop("uuid"))

        internal_id = d.pop("internalId", UNSET)

        cve_id = d.pop("cveId", UNSET)

        ghsa_id = d.pop("ghsaId", UNSET)

        sonatype_id = d.pop("sonatypeId", UNSET)

        osv_id = d.pop("osvId", UNSET)

        snyk_id = d.pop("snykId", UNSET)

        gsd_id = d.pop("gsdId", UNSET)

        vuln_db_id = d.pop("vulnDbId", UNSET)

        vulnerability_alias = cls(
            uuid=uuid,
            internal_id=internal_id,
            cve_id=cve_id,
            ghsa_id=ghsa_id,
            sonatype_id=sonatype_id,
            osv_id=osv_id,
            snyk_id=snyk_id,
            gsd_id=gsd_id,
            vuln_db_id=vuln_db_id,
        )

        vulnerability_alias.additional_properties = d
        return vulnerability_alias

    @property
    def additional_keys(self) -> list[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
