from collections.abc import Mapping
from typing import TYPE_CHECKING, Any, TypeVar, Union

from attrs import define as _attrs_define
from attrs import field as _attrs_field

from ..types import UNSET, Unset

if TYPE_CHECKING:
    from ..models.tag_operation_problem_details_errors import (
        TagOperationProblemDetailsErrors,
    )


T = TypeVar("T", bound="TagOperationProblemDetails")


@_attrs_define
class TagOperationProblemDetails:
    """
    Attributes:
        status (int): HTTP status code generated by the origin server for this occurrence of the problem Example: 400.
        title (str): Short, human-readable summary of the problem type Example: Example title.
        detail (str): Human-readable explanation specific to this occurrence of the problem Example: Example detail.
        type_ (Union[Unset, str]): A URI reference that identifies the problem type Example:
            https://api.example.org/foo/bar/example-problem.
        instance (Union[Unset, str]): Reference URI that identifies the specific occurrence of the problem Example:
            https://api.example.org/foo/bar/example-instance.
        errors (Union[Unset, TagOperationProblemDetailsErrors]): Errors encountered during the operation, grouped by tag
            name
    """

    status: int
    title: str
    detail: str
    type_: Union[Unset, str] = UNSET
    instance: Union[Unset, str] = UNSET
    errors: Union[Unset, "TagOperationProblemDetailsErrors"] = UNSET
    additional_properties: dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> dict[str, Any]:
        status = self.status

        title = self.title

        detail = self.detail

        type_ = self.type_

        instance = self.instance

        errors: Union[Unset, dict[str, Any]] = UNSET
        if not isinstance(self.errors, Unset):
            errors = self.errors.to_dict()

        field_dict: dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update(
            {
                "status": status,
                "title": title,
                "detail": detail,
            }
        )
        if type_ is not UNSET:
            field_dict["type"] = type_
        if instance is not UNSET:
            field_dict["instance"] = instance
        if errors is not UNSET:
            field_dict["errors"] = errors

        return field_dict

    @classmethod
    def from_dict(cls: type[T], src_dict: Mapping[str, Any]) -> T:
        from ..models.tag_operation_problem_details_errors import (
            TagOperationProblemDetailsErrors,
        )

        d = dict(src_dict)
        status = d.pop("status")

        title = d.pop("title")

        detail = d.pop("detail")

        type_ = d.pop("type", UNSET)

        instance = d.pop("instance", UNSET)

        _errors = d.pop("errors", UNSET)
        errors: Union[Unset, TagOperationProblemDetailsErrors]
        if isinstance(_errors, Unset):
            errors = UNSET
        else:
            errors = TagOperationProblemDetailsErrors.from_dict(_errors)

        tag_operation_problem_details = cls(
            status=status,
            title=title,
            detail=detail,
            type_=type_,
            instance=instance,
            errors=errors,
        )

        tag_operation_problem_details.additional_properties = d
        return tag_operation_problem_details

    @property
    def additional_keys(self) -> list[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
