from enum import Enum


class ExternalReferenceType(str, Enum):
    ADVERSARY_MODEL = "adversary-model"
    ADVISORIES = "advisories"
    ATTESTATION = "attestation"
    BOM = "bom"
    BUILD_META = "build-meta"
    BUILD_SYSTEM = "build-system"
    CERTIFICATION_REPORT = "certification-report"
    CHAT = "chat"
    CODIFIED_INFRASTRUCTURE = "codified-infrastructure"
    COMPONENT_ANALYSIS_REPORT = "component-analysis-report"
    CONFIGURATION = "configuration"
    DIGITAL_SIGNATURE = "digital-signature"
    DISTRIBUTION = "distribution"
    DISTRIBUTION_INTAKE = "distribution-intake"
    DOCUMENTATION = "documentation"
    DYNAMIC_ANALYSIS_REPORT = "dynamic-analysis-report"
    ELECTRONIC_SIGNATURE = "electronic-signature"
    EVIDENCE = "evidence"
    EXPLOITABILITY_STATEMENT = "exploitability-statement"
    FORMULATION = "formulation"
    ISSUE_TRACKER = "issue-tracker"
    LICENSE = "license"
    LOG = "log"
    MAILING_LIST = "mailing-list"
    MATURITY_REPORT = "maturity-report"
    MODEL_CARD = "model_card"
    OTHER = "other"
    PENTEST_REPORT = "pentest-report"
    QUALITY_METRICS = "quality-metrics"
    RELEASE_NOTES = "release-notes"
    RFC_9116 = "rfc-9116"
    RISK_ASSESSMENT = "risk-assessment"
    RUNTIME_ANALYSIS_REPORT = "runtime-analysis-report"
    SECURITY_CONTACT = "security-contact"
    SOCIAL = "social"
    SOURCE_DISTRIBUTION = "source-distribution"
    STATIC_ANALYSIS_REPORT = "static-analysis-report"
    SUPPORT = "support"
    THREAT_MODEL = "threat-model"
    VCS = "vcs"
    VULNERABILITY_ASSERTION = "vulnerability-assertion"
    WEBSITE = "website"

    def __str__(self) -> str:
        return str(self.value)
