#!/usr/bin/env python
# setup.py generated by flit for tools that don't yet use PEP 517

from distutils.core import setup

packages = \
['pyprocessors_opennre',
 'pyprocessors_opennre.opennre',
 'pyprocessors_opennre.opennre.encoder',
 'pyprocessors_opennre.opennre.framework',
 'pyprocessors_opennre.opennre.model',
 'pyprocessors_opennre.opennre.module',
 'pyprocessors_opennre.opennre.module.nn',
 'pyprocessors_opennre.opennre.module.pool',
 'pyprocessors_opennre.opennre.tokenization']

package_data = \
{'': ['*']}

package_dir = \
{'': 'src'}

install_requires = \
['pymultirole-plugins>=0.5.0,<0.6.0',
 'collections-extended',
 'torch==1.7.1',
 'transformers',
 'scikit-learn',
 'scipy',
 'nltk',
 'pybel']

extras_require = \
{'dev': ['flit', 'pre-commit', 'bump2version'],
 'docs': ['sphinx',
          'sphinx-rtd-theme',
          'm2r2',
          'sphinxcontrib.apidoc',
          'jupyter_sphinx'],
 'test': ['pytest',
          'pytest-cov',
          'pytest-flake8',
          'pytest-black',
          'flake8==3.9.2',
          'tox',
          'pandas==1.2.3',
          'openpyxl==3.0.7']}

entry_points = \
{'pyprocessors.plugins': ['opennre = '
                          'pyprocessors_opennre.opennre_proc:OpenNREProcessor']}

setup(name='pyprocessors-opennre',
      version='0.5.34',
      description='Processor based on Huggingface transformers zero-shot classification pipeline',
      author='Olivier Terrier',
      author_email='olivier.terrier@kairntech.com',
      url='https://github.com/oterrier/pyprocessors_opennre/',
      packages=packages,
      package_data=package_data,
      package_dir=package_dir,
      install_requires=install_requires,
      extras_require=extras_require,
      entry_points=entry_points,
      python_requires='>=3.8',
     )
