/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0
 */
/**
 * Utility class for validating and converting the version number to or from a version string
 */
export declare class Version {
    static validateVersionString(versionString: string): boolean;
    static parseFromVersionString(versionString: string): RegExpExecArray | null;
    static convertToFullVersionString(major: string, minor: string, release: string, patch: string): string;
    private static readonly VALID_VERSION_REGEX;
}
