/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement;
import org.jetbrains.kotlin.com.intellij.psi.stubs.IStubElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.TokenSet;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.IfNotParsed;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtElementImplStub;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtValueArgumentName;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.psi.stubs.KotlinPlaceHolderStub;
import org.jetbrains.kotlin.psi.stubs.KotlinValueArgumentStub;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementTypes;

public class KtValueArgument
extends KtElementImplStub<KotlinValueArgumentStub<? extends KtValueArgument>>
implements ValueArgument {
    private static final TokenSet CONSTANT_EXPRESSIONS_TYPES = TokenSet.create(KtStubElementTypes.NULL, KtStubElementTypes.BOOLEAN_CONSTANT, KtStubElementTypes.FLOAT_CONSTANT, KtStubElementTypes.CHARACTER_CONSTANT, KtStubElementTypes.INTEGER_CONSTANT, KtStubElementTypes.REFERENCE_EXPRESSION, KtStubElementTypes.DOT_QUALIFIED_EXPRESSION, KtStubElementTypes.STRING_TEMPLATE);

    public KtValueArgument(@NotNull ASTNode node) {
        super(node);
    }

    public KtValueArgument(@NotNull KotlinValueArgumentStub<KtValueArgument> stub) {
        super(stub, KtStubElementTypes.VALUE_ARGUMENT);
    }

    protected KtValueArgument(KotlinValueArgumentStub<? extends KtValueArgument> stub, IStubElementType nodeType) {
        super(stub, nodeType);
    }

    @Override
    public <R, D> R accept(@NotNull KtVisitor<R, D> visitor2, D data2) {
        return visitor2.visitArgument(this, data2);
    }

    @Override
    @IfNotParsed
    @Nullable
    public KtExpression getArgumentExpression() {
        KtExpression[] constantExpressions;
        KotlinPlaceHolderStub stub = (KotlinPlaceHolderStub)this.getStub();
        if (stub != null && (constantExpressions = (KtExpression[])stub.getChildrenByType(CONSTANT_EXPRESSIONS_TYPES, KtExpression.EMPTY_ARRAY)).length != 0) {
            return constantExpressions[0];
        }
        return this.findChildByClass(KtExpression.class);
    }

    @Override
    @Nullable
    public KtValueArgumentName getArgumentName() {
        return (KtValueArgumentName)this.getStubOrPsiChild(KtStubElementTypes.VALUE_ARGUMENT_NAME);
    }

    @Nullable
    public PsiElement getEqualsToken() {
        return this.findChildByType(KtTokens.EQ);
    }

    @Override
    public boolean isNamed() {
        return this.getArgumentName() != null;
    }

    @Override
    @NotNull
    public KtElement asElement() {
        return this;
    }

    @Override
    public LeafPsiElement getSpreadElement() {
        KotlinValueArgumentStub stub = (KotlinValueArgumentStub)this.getStub();
        if (stub != null && !stub.isSpread()) {
            return null;
        }
        ASTNode node = this.getNode().findChildByType(KtTokens.MUL);
        return node == null ? null : (LeafPsiElement)node.getPsi();
    }

    public boolean isSpread() {
        KotlinValueArgumentStub stub = (KotlinValueArgumentStub)this.getStub();
        if (stub != null) {
            return stub.isSpread();
        }
        return this.getSpreadElement() != null;
    }

    @Override
    public boolean isExternal() {
        return false;
    }
}

