/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi;

import gnu.trove.THashMap;
import java.util.Collection;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.jvm.types.JvmPrimitiveType;
import org.jetbrains.kotlin.com.intellij.lang.jvm.types.JvmPrimitiveTypeKind;
import org.jetbrains.kotlin.com.intellij.pom.java.LanguageLevel;
import org.jetbrains.kotlin.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.kotlin.com.intellij.psi.PsiAnnotation;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassType;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementFactory;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiManager;
import org.jetbrains.kotlin.com.intellij.psi.PsiNameHelper;
import org.jetbrains.kotlin.com.intellij.psi.PsiSubstitutor;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeVisitor;
import org.jetbrains.kotlin.com.intellij.psi.TypeAnnotationProvider;
import org.jetbrains.kotlin.com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtil;

public class PsiPrimitiveType
extends PsiType.Stub
implements JvmPrimitiveType {
    private static final Map<String, PsiPrimitiveType> ourQNameToUnboxed = new THashMap<String, PsiPrimitiveType>();
    private final JvmPrimitiveTypeKind myKind;
    private final String myName;

    PsiPrimitiveType(@Nullable(value="for NULL type") JvmPrimitiveTypeKind kind) {
        super(PsiAnnotation.EMPTY_ARRAY);
        this.myKind = kind;
        if (kind != null) {
            ourQNameToUnboxed.put(kind.getBoxedFqn(), this);
        }
        this.myName = PsiPrimitiveType.getName(kind);
    }

    public PsiPrimitiveType(@Nullable(value="for NULL type") JvmPrimitiveTypeKind kind, @NotNull PsiAnnotation[] annotations2) {
        if (annotations2 == null) {
            PsiPrimitiveType.$$$reportNull$$$0(0);
        }
        super(annotations2);
        this.myKind = kind;
        this.myName = PsiPrimitiveType.getName(kind);
    }

    public PsiPrimitiveType(@Nullable(value="for NULL type") JvmPrimitiveTypeKind kind, @NotNull TypeAnnotationProvider provider) {
        if (provider == null) {
            PsiPrimitiveType.$$$reportNull$$$0(1);
        }
        super(provider);
        this.myKind = kind;
        this.myName = PsiPrimitiveType.getName(kind);
    }

    public PsiPrimitiveType(@NotNull String name, @NotNull TypeAnnotationProvider provider) {
        if (name == null) {
            PsiPrimitiveType.$$$reportNull$$$0(2);
        }
        if (provider == null) {
            PsiPrimitiveType.$$$reportNull$$$0(3);
        }
        super(provider);
        JvmPrimitiveTypeKind kind = JvmPrimitiveTypeKind.getKindByName(name);
        if (kind == null) {
            throw new NoSuchElementException("Cannot find primitive type: " + name);
        }
        this.myKind = kind;
        this.myName = name;
    }

    @Deprecated
    public PsiPrimitiveType(@NotNull String name, @NotNull PsiAnnotation[] annotations2) {
        if (name == null) {
            PsiPrimitiveType.$$$reportNull$$$0(4);
        }
        if (annotations2 == null) {
            PsiPrimitiveType.$$$reportNull$$$0(5);
        }
        super(annotations2);
        this.myKind = null;
        this.myName = name;
    }

    @NotNull
    @Contract(pure=true)
    private static String getName(@Nullable JvmPrimitiveTypeKind kind) {
        String string = kind == null ? "null" : kind.getName();
        if (string == null) {
            PsiPrimitiveType.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public final JvmPrimitiveTypeKind getKind() {
        JvmPrimitiveTypeKind jvmPrimitiveTypeKind = Objects.requireNonNull(this.myKind, "getKind() called on PsiType.NULL\nIf your code works with JvmElement API then this should not happen unless some implementation improperly returns PsiType.NULL from JvmMethod.getReturnType() (or any other available methods).\nIf your code works with PsiType-s then you must check if this type is PsiType.NULL type before calling this method");
        if (jvmPrimitiveTypeKind == null) {
            PsiPrimitiveType.$$$reportNull$$$0(7);
        }
        return jvmPrimitiveTypeKind;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            PsiPrimitiveType.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Override
    @NotNull
    public PsiPrimitiveType annotate(@NotNull TypeAnnotationProvider provider) {
        if (provider == null) {
            PsiPrimitiveType.$$$reportNull$$$0(9);
        }
        PsiPrimitiveType psiPrimitiveType = (PsiPrimitiveType)super.annotate(provider);
        if (psiPrimitiveType == null) {
            PsiPrimitiveType.$$$reportNull$$$0(10);
        }
        return psiPrimitiveType;
    }

    @Override
    @NotNull
    public String getPresentableText(boolean annotated) {
        String string = this.getText(false, annotated);
        if (string == null) {
            PsiPrimitiveType.$$$reportNull$$$0(11);
        }
        return string;
    }

    @Override
    @NotNull
    public String getCanonicalText(boolean annotated) {
        String string = this.getText(true, annotated);
        if (string == null) {
            PsiPrimitiveType.$$$reportNull$$$0(12);
        }
        return string;
    }

    @Override
    @NotNull
    public String getInternalCanonicalText() {
        String string = this.getCanonicalText(true);
        if (string == null) {
            PsiPrimitiveType.$$$reportNull$$$0(13);
        }
        return string;
    }

    private String getText(boolean qualified, boolean annotated) {
        PsiAnnotation[] annotations2;
        PsiAnnotation[] psiAnnotationArray = annotations2 = annotated ? this.getAnnotations() : PsiAnnotation.EMPTY_ARRAY;
        if (annotations2.length == 0) {
            return this.myName;
        }
        StringBuilder sb = new StringBuilder();
        PsiNameHelper.appendAnnotations(sb, annotations2, qualified);
        sb.append(this.myName);
        return sb.toString();
    }

    @Override
    public boolean isValid() {
        for (PsiAnnotation annotation2 : this.getAnnotations()) {
            if (annotation2.isValid()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equalsToText(@NotNull String text2) {
        if (text2 == null) {
            PsiPrimitiveType.$$$reportNull$$$0(14);
        }
        return this.myName.equals(text2);
    }

    @Override
    public <A> A accept(@NotNull PsiTypeVisitor<A> visitor2) {
        if (visitor2 == null) {
            PsiPrimitiveType.$$$reportNull$$$0(15);
        }
        return visitor2.visitPrimitiveType(this);
    }

    @Override
    public GlobalSearchScope getResolveScope() {
        return null;
    }

    @Override
    @NotNull
    public PsiType[] getSuperTypes() {
        if (EMPTY_ARRAY == null) {
            PsiPrimitiveType.$$$reportNull$$$0(16);
        }
        return EMPTY_ARRAY;
    }

    @Nullable
    public static PsiPrimitiveType getUnboxedType(PsiType type2) {
        if (!(type2 instanceof PsiClassType)) {
            return null;
        }
        PsiUtil.ensureValidType(type2);
        LanguageLevel languageLevel = ((PsiClassType)type2).getLanguageLevel();
        if (!languageLevel.isAtLeast(LanguageLevel.JDK_1_5)) {
            return null;
        }
        PsiClass psiClass = ((PsiClassType)type2).resolve();
        if (psiClass == null) {
            return null;
        }
        PsiPrimitiveType unboxed = ourQNameToUnboxed.get(psiClass.getQualifiedName());
        if (unboxed == null) {
            return null;
        }
        return unboxed.annotate(type2.getAnnotationProvider());
    }

    @Nullable
    public static PsiPrimitiveType getOptionallyUnboxedType(PsiType type2) {
        return type2 instanceof PsiPrimitiveType ? (PsiPrimitiveType)type2 : PsiPrimitiveType.getUnboxedType(type2);
    }

    @Nullable
    public String getBoxedTypeName() {
        return this.myKind == null ? null : this.myKind.getBoxedFqn();
    }

    @Nullable
    public PsiClassType getBoxedType(@NotNull PsiElement context) {
        PsiFile file2;
        if (context == null) {
            PsiPrimitiveType.$$$reportNull$$$0(17);
        }
        if ((file2 = context.getContainingFile()) == null) {
            return null;
        }
        LanguageLevel languageLevel = PsiUtil.getLanguageLevel(file2);
        if (!languageLevel.isAtLeast(LanguageLevel.JDK_1_5)) {
            return null;
        }
        String boxedQName = this.getBoxedTypeName();
        if (boxedQName == null) {
            return null;
        }
        JavaPsiFacade facade = JavaPsiFacade.getInstance(file2.getProject());
        PsiClass aClass2 = facade.findClass(boxedQName, file2.getResolveScope());
        if (aClass2 == null) {
            return null;
        }
        PsiElementFactory factory2 = facade.getElementFactory();
        return factory2.createType(aClass2, PsiSubstitutor.EMPTY, languageLevel).annotate(this.getAnnotationProvider());
    }

    @Nullable
    public PsiClassType getBoxedType(@NotNull PsiManager manager, @NotNull GlobalSearchScope resolveScope) {
        String boxedQName;
        if (manager == null) {
            PsiPrimitiveType.$$$reportNull$$$0(18);
        }
        if (resolveScope == null) {
            PsiPrimitiveType.$$$reportNull$$$0(19);
        }
        if ((boxedQName = this.getBoxedTypeName()) == null) {
            return null;
        }
        PsiClass aClass2 = JavaPsiFacade.getInstance(manager.getProject()).findClass(boxedQName, resolveScope);
        if (aClass2 == null) {
            return null;
        }
        return JavaPsiFacade.getElementFactory(manager.getProject()).createType(aClass2);
    }

    @Deprecated
    public static Collection<String> getAllBoxedTypeNames() {
        return JvmPrimitiveTypeKind.getBoxedFqns();
    }

    public int hashCode() {
        return this.myKind == null ? 0 : this.myKind.hashCode();
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof PsiPrimitiveType && this.myKind == ((PsiPrimitiveType)obj).myKind;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotations";
                break;
            }
            case 1: 
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/PsiPrimitiveType";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/PsiPrimitiveType";
                break;
            }
            case 6: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getKind";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "annotate";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableText";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getInternalCanonicalText";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuperTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "annotate";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "equalsToText";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getBoxedType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

