/*
 * Decompiled with CFR 0.152.
 */
package jInst.Instrumentation;

import AndroidProjectRepresentation.APICallUtil;
import jInst.Instrumentation.InstrumentHelper;
import jInst.JInst;
import jInst.util.FileUtils;
import jInst.util.PackageM;
import jInst.util.XMLParser;
import jInst.visitors.MethodChangerVisitor;
import java.io.File;

public class InstrumentGradleHelper
extends InstrumentHelper {
    public InstrumentGradleHelper() {
        this.manifest = "";
        this.manifestTest = "";
    }

    public InstrumentGradleHelper(APICallUtil apu, String tName, String work, String proj2, String tests, String manifSource, String manifTests, JInst.InstrumentationType type2, String approach) {
        super(apu, tName, work, proj2, tests, type2, approach);
        this.originalManifest = manifSource;
        this.manifest = this.transFolder + manifSource.replace("//", "/").replace(this.project.replace("//", "/"), "");
        this.manifestTest = manifTests.equals("-") ? "" : this.transTests + manifTests.replace(this.tests, "");
        this.setInstrumentationType(type2);
        this.setApproach(approach);
    }

    @Override
    public void generateTransformedProject() throws Exception {
        File[] listOfFiles;
        File fProject = new File(this.project);
        File fTransf = new File(this.transFolder);
        fTransf.mkdir();
        for (File f : listOfFiles = fProject.listFiles()) {
            if (f.isDirectory()) {
                if (f.getName().equals(this.tName)) continue;
                this.instrumentSource(f, new File(this.transFolder + f.getName()));
                continue;
            }
            if (!f.isFile()) continue;
            File ax = new File(this.transFolder + f.getName());
            ax.createNewFile();
            FileUtils.copyFile(f, ax);
        }
        String allMethods = "";
        FileUtils.copyAll(MethodChangerVisitor.getPackages(), this.packages);
        for (PackageM p : this.packages) {
            allMethods = allMethods + p.toString();
        }
        File auxF = new File(this.aux);
        auxF.mkdir();
        this.packages.clear();
        MethodChangerVisitor.restartPackages();
        this.changeRunner();
        XMLParser.addLibOverrideToManifests(this.findAllManifests());
    }

    @Override
    public void addPermission() {
        File ax = new File(this.manifest);
        if (!this.manifest.equals("") && ax.exists()) {
            XMLParser.editManifest(this.manifest);
        }
        if (this.type == JInst.InstrumentationType.ACTIVITY && this.isWhiteBox()) {
            XMLParser.insertReadWriteExternalPermissionsAndDebbugable(this.manifest);
        }
    }

    @Override
    protected void changeRunner() {
        File ax = new File(this.manifestTest);
        if (!this.manifestTest.equals("-") && ax.exists()) {
            XMLParser.editRunner(this.manifestTest);
        }
    }

    protected void justCopy(File src, File dest) throws Exception {
        if (src.isDirectory()) {
            String[] files2;
            if (!dest.exists()) {
                dest.mkdir();
            }
            for (String file2 : files2 = src.list()) {
                File srcFile = new File(src, file2);
                File destFile = new File(dest, file2);
                this.justCopy(srcFile, destFile);
            }
        } else {
            FileUtils.copyFile(src, dest);
        }
    }

    @Override
    protected void instrumentSource(File src, File dest) throws Exception {
        if (src.isDirectory()) {
            if (!dest.exists()) {
                dest.mkdir();
            }
            String[] files2 = src.list();
            if (src.isDirectory() && src.getName().equals("test")) {
                this.justCopy(src, dest);
            } else {
                for (String file2 : files2) {
                    if (!file2.endsWith("build.gradle")) continue;
                    this.setCompiledSdkVersion(new File(src, file2).getAbsolutePath());
                }
                for (String file2 : files2) {
                    File srcFile = new File(src, file2);
                    File destFile = new File(dest, file2);
                    this.instrumentSource(srcFile, destFile);
                }
            }
        } else if (src.getAbsolutePath().endsWith(".java")) {
            String res2 = "";
            if (this.isTestCase(src)) {
                if (InstrumentGradleHelper.hasToInstrumentProjectTests()) {
                    res2 = this.transformTest(src.getAbsolutePath());
                } else {
                    FileUtils.copyFile(src, dest);
                }
            } else if (!src.getAbsolutePath().contains("build/generated")) {
                if (this.isWhiteBox()) {
                    res2 = this.transform(src.getAbsolutePath());
                } else {
                    FileUtils.copyFile(src, dest);
                }
            } else {
                FileUtils.copyFile(src, dest);
            }
            if (!res2.equals("")) {
                dest.createNewFile();
                FileUtils.writeFile(dest, res2);
            }
        } else if (src.getAbsolutePath().endsWith(".kt")) {
            String res3 = "";
            res3 = this.transformKotlin(src.getAbsolutePath());
            if (!res3.equals("")) {
                dest.createNewFile();
                FileUtils.writeFile(dest, res3);
            }
        } else {
            FileUtils.copyFile(src, dest);
        }
    }

    private String transformTestKotlinTest(String absolutePath) {
        return absolutePath;
    }
}

