/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser;

import com.github.javaparser.CommentsInserter;
import com.github.javaparser.InstanceJavaParser;
import com.github.javaparser.ParseException;
import com.github.javaparser.SourcesHelper;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.ImportDeclaration;
import com.github.javaparser.ast.body.BodyDeclaration;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.Statement;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.List;

public final class JavaParser {
    private static final CommentsInserter commentsInserter = new CommentsInserter();

    private JavaParser() {
    }

    public static boolean getDoNotConsiderAnnotationsAsNodeStartForCodeAttribution() {
        return commentsInserter.getDoNotConsiderAnnotationsAsNodeStartForCodeAttribution();
    }

    public static void setDoNotConsiderAnnotationsAsNodeStartForCodeAttribution(boolean newValue) {
        commentsInserter.setDoNotConsiderAnnotationsAsNodeStartForCodeAttribution(newValue);
    }

    public static boolean getDoNotAssignCommentsPreceedingEmptyLines() {
        return commentsInserter.getDoNotAssignCommentsPreceedingEmptyLines();
    }

    public static void setDoNotAssignCommentsPreceedingEmptyLines(boolean newValue) {
        commentsInserter.setDoNotAssignCommentsPreceedingEmptyLines(newValue);
    }

    public static CompilationUnit parse(InputStream in, String encoding) throws ParseException {
        return JavaParser.parse(in, encoding, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CompilationUnit parse(InputStream in, String encoding, boolean considerComments) throws ParseException {
        CompilationUnit compilationUnit;
        InputStreamReader inputStreamReader = new InputStreamReader(in, encoding);
        try {
            compilationUnit = JavaParser.parse(inputStreamReader, considerComments);
        }
        catch (Throwable throwable) {
            try {
                inputStreamReader.close();
                throw throwable;
            }
            catch (IOException ioe) {
                throw new ParseException(ioe.getMessage());
            }
        }
        inputStreamReader.close();
        return compilationUnit;
    }

    public static CompilationUnit parse(InputStream in) throws ParseException {
        return JavaParser.parse(in, Charset.defaultCharset().name(), true);
    }

    public static CompilationUnit parse(File file2, String encoding) throws ParseException, IOException {
        return JavaParser.parse(file2, encoding, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CompilationUnit parse(File file2, String encoding, boolean considerComments) throws ParseException {
        CompilationUnit compilationUnit;
        FileInputStream in = new FileInputStream(file2);
        try {
            compilationUnit = JavaParser.parse(in, encoding, considerComments);
        }
        catch (Throwable throwable) {
            try {
                in.close();
                throw throwable;
            }
            catch (IOException ioe) {
                throw new ParseException(ioe.getMessage());
            }
        }
        in.close();
        return compilationUnit;
    }

    public static CompilationUnit parse(File file2) throws ParseException, IOException {
        return JavaParser.parse(file2, Charset.defaultCharset().name(), true);
    }

    public static CompilationUnit parse(Reader reader) throws ParseException {
        return JavaParser.parse(reader, true);
    }

    public static CompilationUnit parse(Reader reader, boolean considerComments) throws ParseException {
        try {
            String comments = SourcesHelper.readerToString(reader);
            CompilationUnit cu = new InstanceJavaParser(comments).parse();
            if (considerComments) {
                commentsInserter.insertComments(cu, comments);
            }
            return cu;
        }
        catch (IOException ioe) {
            throw new ParseException(ioe.getMessage());
        }
    }

    public static BlockStmt parseBlock(String blockStatement) throws ParseException {
        return new InstanceJavaParser(blockStatement).parseBlock();
    }

    public static Statement parseStatement(String statement2) throws ParseException {
        return new InstanceJavaParser(statement2).parseStatement();
    }

    public static List<Statement> parseStatements(String statements) throws ParseException {
        return new InstanceJavaParser(statements).parseStatements();
    }

    public static ImportDeclaration parseImport(String importDeclaration) throws ParseException {
        return new InstanceJavaParser(importDeclaration).parseImport();
    }

    public static Expression parseExpression(String expression2) throws ParseException {
        return new InstanceJavaParser(expression2).parseExpression();
    }

    public static AnnotationExpr parseAnnotation(String annotation2) throws ParseException {
        return new InstanceJavaParser(annotation2).parseAnnotation();
    }

    public static BodyDeclaration parseBodyDeclaration(String body) throws ParseException {
        return new InstanceJavaParser(body).parseBodyDeclaration();
    }

    public static BodyDeclaration parseClassBodyDeclaration(String body) throws ParseException {
        return new InstanceJavaParser(body).parseClassBodyDeclaration();
    }

    public static BodyDeclaration parseInterfaceBodyDeclaration(String body) throws ParseException {
        return new InstanceJavaParser(body).parseInterfaceBodyDeclaration();
    }
}

