/*
 * Decompiled with CFR 0.152.
 */
package com.univocity.parsers.common;

import com.univocity.parsers.common.fields.FieldSelector;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;

public class ArgumentUtils {
    public static final String[] EMPTY_STRING_ARRAY = new String[0];

    public static <T> void notEmpty(String argDescription, T ... args) {
        if (args == null) {
            throw new IllegalArgumentException(argDescription + " must not be null");
        }
        if (args.length == 0) {
            throw new IllegalArgumentException(argDescription + " must not be empty");
        }
    }

    public static <T> void noNulls(String argDescription, T ... args) {
        ArgumentUtils.notEmpty(argDescription, args);
        for (T arg : args) {
            if (arg != null) continue;
            if (args.length > 0) {
                throw new IllegalArgumentException(argDescription + " must not contain nulls");
            }
            throw new IllegalArgumentException(argDescription + " must not be null");
        }
    }

    public static int indexOf(String[] array, String element, FieldSelector fieldSelector) {
        int index = ArgumentUtils.indexOf(array, element);
        if (fieldSelector == null || index == -1) {
            return index;
        }
        int[] indexes = fieldSelector.getFieldIndexes(array);
        for (int i2 = 0; i2 < indexes.length; ++i2) {
            if (indexes[i2] != index) continue;
            return i2;
        }
        return -1;
    }

    public static int indexOf(Object[] array, Object element) {
        if (array == null) {
            throw new NullPointerException("Null array");
        }
        if (element == null) {
            for (int i2 = 0; i2 < array.length; ++i2) {
                if (array[i2] != null) continue;
                return i2;
            }
        } else {
            int i3;
            if (element instanceof String && array instanceof String[]) {
                for (i3 = 0; i3 < array.length; ++i3) {
                    String e = String.valueOf(array[i3]);
                    if (!element.toString().equalsIgnoreCase(e)) continue;
                    return i3;
                }
            }
            for (i3 = 0; i3 < array.length; ++i3) {
                if (!element.equals(array[i3])) continue;
                return i3;
            }
        }
        return -1;
    }

    public static Object[] findMissingElements(Object[] array, Collection<?> elements) {
        return ArgumentUtils.findMissingElements(array, elements.toArray());
    }

    public static Object[] findMissingElements(Object[] array, Object[] elements) {
        ArrayList<Object> out = new ArrayList<Object>();
        for (Object element : elements) {
            if (ArgumentUtils.indexOf(array, element) != -1) continue;
            out.add(element);
        }
        return out.toArray();
    }

    public static String[] normalize(String[] strings) {
        String[] out = new String[strings.length];
        for (int i2 = 0; i2 < strings.length; ++i2) {
            out[i2] = ArgumentUtils.normalize(strings[i2]);
        }
        return out;
    }

    public static String normalize(String string) {
        if (string == null) {
            return null;
        }
        return string.trim().toLowerCase();
    }

    public static void normalize(Collection<String> strings) {
        LinkedHashSet<String> normalized = new LinkedHashSet<String>(strings.size());
        for (String string : strings) {
            if (string == null) {
                normalized.add(null);
                continue;
            }
            normalized.add(string.trim().toLowerCase());
        }
        strings.clear();
        strings.addAll(normalized);
    }

    public static Writer newWriter(OutputStream output) {
        return ArgumentUtils.newWriter(output, (Charset)null);
    }

    public static Writer newWriter(OutputStream output, String encoding) {
        return ArgumentUtils.newWriter(output, Charset.forName(encoding));
    }

    public static Writer newWriter(OutputStream output, Charset encoding) {
        if (encoding != null) {
            return new OutputStreamWriter(output, encoding);
        }
        return new OutputStreamWriter(output);
    }

    public static Writer newWriter(File file) {
        return ArgumentUtils.newWriter(file, (Charset)null);
    }

    public static Writer newWriter(File file, String encoding) {
        return ArgumentUtils.newWriter(file, Charset.forName(encoding));
    }

    public static Writer newWriter(File file, Charset encoding) {
        FileOutputStream os;
        if (!file.exists()) {
            File parent = file.getParentFile();
            if (parent != null && !parent.exists()) {
                parent.mkdirs();
            }
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Unable to create file '" + file.getAbsolutePath() + "', please ensure your application has permission to create files in that path", e);
            }
        }
        try {
            os = new FileOutputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
        return ArgumentUtils.newWriter((OutputStream)os, encoding);
    }

    public static Reader newReader(InputStream input) {
        return ArgumentUtils.newReader(input, (Charset)null);
    }

    public static Reader newReader(InputStream input, String encoding) {
        return ArgumentUtils.newReader(input, Charset.forName(encoding));
    }

    public static Reader newReader(InputStream input, Charset encoding) {
        if (encoding != null) {
            return new InputStreamReader(input, encoding);
        }
        return new InputStreamReader(input);
    }

    public static Reader newReader(File file) {
        return ArgumentUtils.newReader(file, (Charset)null);
    }

    public static Reader newReader(File file, String encoding) {
        return ArgumentUtils.newReader(file, Charset.forName(encoding));
    }

    public static Reader newReader(File file, Charset encoding) {
        FileInputStream input;
        try {
            input = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
        return ArgumentUtils.newReader((InputStream)input, encoding);
    }

    public static String[] toArray(List<Enum> enums) {
        String[] out = new String[enums.size()];
        for (int i2 = 0; i2 < out.length; ++i2) {
            out[i2] = enums.get(i2).toString();
        }
        return out;
    }

    public static int[] toIntArray(Collection<Integer> ints) {
        int[] out = new int[ints.size()];
        int i2 = 0;
        for (Integer boxed : ints) {
            out[i2++] = boxed;
        }
        return out;
    }

    public static char[] toCharArray(Collection<Character> characters) {
        char[] out = new char[characters.size()];
        int i2 = 0;
        for (Character boxed : characters) {
            out[i2++] = boxed.charValue();
        }
        return out;
    }

    public static String restrictContent(int length, CharSequence content) {
        if (content == null) {
            return null;
        }
        if (length == 0) {
            return "<omitted>";
        }
        if (length == -1) {
            return ((Object)content).toString();
        }
        int errorMessageStart = content.length() - length;
        if (length > 0 && errorMessageStart > 0) {
            return "..." + ((Object)content.subSequence(errorMessageStart, content.length())).toString();
        }
        return ((Object)content).toString();
    }

    public static String restrictContent(int length, Object content) {
        if (content == null) {
            return null;
        }
        if (content instanceof Object[]) {
            return ArgumentUtils.restrictContent(length, Arrays.toString((Object[])content));
        }
        return ArgumentUtils.restrictContent(length, String.valueOf(content));
    }

    public static void throwUnchecked(Throwable error) {
        ArgumentUtils.throwsUnchecked(error);
    }

    private static <T extends Exception> void throwsUnchecked(Throwable toThrow) throws T {
        throw (Exception)toThrow;
    }
}

