/*
 * Decompiled with CFR 0.152.
 */
package AnaDroidAnalyzer.Results.Metrics;

import java.math.BigDecimal;
import java.util.Map;

public class MetricDistribution {
    public Number minimun = 0;
    public Number maximun = 0;
    public Number average = 0;

    public MetricDistribution() {
    }

    public String toString() {
        return "MetricDistribution{minimun=" + this.minimun + ", average=" + this.average + ", maximun=" + this.maximun + '}';
    }

    public Double[] asArray() {
        Double[] a = new Double[]{this.minimun.doubleValue(), this.average.doubleValue(), this.maximun.doubleValue()};
        return a;
    }

    public MetricDistribution(Map<? extends Number, ? extends Number> samples) {
        Number min = Integer.MAX_VALUE;
        Number max = Integer.MIN_VALUE;
        Integer totalSamples = samples.size();
        double total = 0.0;
        if (samples.isEmpty()) {
            this.average = 0;
            this.maximun = 0;
            this.minimun = 0;
        } else {
            for (Number number : samples.values()) {
                if (number.doubleValue() > ((Number)max).doubleValue()) {
                    max = number;
                } else if (number.doubleValue() < ((Number)min).doubleValue()) {
                    min = number;
                }
                total += number.doubleValue();
            }
            this.average = total / ((Number)totalSamples).doubleValue();
            this.maximun = ((Number)max).doubleValue();
            this.minimun = ((Number)min).doubleValue();
        }
    }

    public Object toInlineString() {
        return MetricDistribution.round(this.minimun.doubleValue(), 2) + "," + MetricDistribution.round(this.average.doubleValue(), 2) + "," + MetricDistribution.round(this.maximun.doubleValue(), 2);
    }

    public static BigDecimal round(Double d, int decimalPlace) {
        if (d.isNaN()) {
            d = 0.0;
        }
        BigDecimal bd = new BigDecimal(Double.toString(d));
        bd = bd.setScale(decimalPlace, 4);
        return bd;
    }
}

