/*
 * Decompiled with CFR 0.152.
 */
package AnaDroidAnalyzer.Results;

import AnaDroidAnalyzer.Utils.Utils;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.stream.Collectors;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class JSONsMerger {
    private JSONObject apkMethods = new JSONObject();
    private JSONObject sourceMethods = new JSONObject();
    private JSONObject merged = new JSONObject();
    private Set<JSONObject> ignoredMethods = new HashSet<JSONObject>();
    private int apkMethodsCount = -1;

    public JSONObject getSourceMethods() {
        return this.sourceMethods;
    }

    public JSONObject getMerged() {
        return this.merged;
    }

    public JSONObject getApkMethods() {
        return this.apkMethods;
    }

    public int getApkMethodCoverage() {
        if (this.apkMethodsCount >= 0) {
            return this.apkMethodsCount;
        }
        int method_count = 0;
        for (Object o : this.apkMethods.values()) {
            JSONObject jo = (JSONObject)o;
            if (!jo.containsKey("class_methods")) continue;
            method_count += ((JSONObject)jo.get("class_methods")).size();
        }
        this.apkMethodsCount = method_count;
        return method_count;
    }

    public int getSourceCoverage() {
        return this.merged.size();
    }

    public JSONsMerger() {
    }

    public JSONsMerger(String apkMethodsFile, String sourceMethodsFile) {
        this.apkMethods = Utils.loadJSONObj(apkMethodsFile);
        this.sourceMethods = Utils.loadJSONObj(sourceMethodsFile);
        this.merged = new JSONObject();
    }

    public void merge() {
        String separator = "->";
        String separator_of_hash = "|";
        if (this.sourceMethods.isEmpty()) {
            for (Object apkobj : this.apkMethods.values()) {
                JSONObject apko = (JSONObject)apkobj;
                if (!apko.containsKey("class_methods")) continue;
                this.merged.putAll((JSONObject)apko.get("class_methods"));
            }
        } else {
            Iterator it = this.sourceMethods.keySet().iterator();
            while (it.hasNext()) {
                String source_method_key = (String)it.next();
                JSONObject source_method_obj = (JSONObject)this.sourceMethods.get(source_method_key);
                String source_method_class = source_method_key.split("->")[0];
                String source_method_simple_name = source_method_key.split("->")[1].split("\\" + separator_of_hash)[0].replace("clinit", "init");
                JSONObject correspondant_apk_class = (JSONObject)this.apkMethods.get(source_method_class);
                if (correspondant_apk_class == null || !correspondant_apk_class.containsKey("class_methods")) {
                    this.ignoredMethods.add(source_method_obj);
                    continue;
                }
                JSONObject methods_of_class = (JSONObject)correspondant_apk_class.get("class_methods");
                Set<String> possible_methods = methods_of_class.keySet().stream().filter(x -> ((String)x).contains(source_method_simple_name)).map(x -> ((String)x).toString()).collect(Collectors.toSet());
                if (possible_methods.isEmpty()) {
                    this.ignoredMethods.add(source_method_obj);
                    continue;
                }
                if (possible_methods.size() == 1) {
                    this.foundMerged(source_method_key, (JSONObject)methods_of_class.get(possible_methods.toArray()[0]), source_method_obj);
                    it.remove();
                    continue;
                }
                HashSet possibleAPKObjs = new HashSet();
                possible_methods.forEach(x -> possibleAPKObjs.add((JSONObject)methods_of_class.get(x)));
                JSONArray source_method_args = (JSONArray)source_method_obj.get("args");
                int possibleMatches = possibleAPKObjs.size();
                for (JSONObject possible : possibleAPKObjs) {
                    boolean equals = true;
                    int possible_apk_nr_args = ((JSONArray)possible.get("method_args")).size();
                    if (possible_apk_nr_args == source_method_args.size()) {
                        for (int i2 = 0; i2 < ((JSONArray)possible.get("method_args")).size(); ++i2) {
                            String apkarg = ((String)((JSONArray)possible.get("method_args")).get(i2)).replaceAll("\\[", "");
                            String arg = ((String)source_method_args.get(i2)).replaceAll("\\[", "");
                            if (apkarg.toLowerCase().endsWith(arg.toLowerCase()) || apkarg.toLowerCase().replaceAll("$", "").endsWith(arg.toLowerCase())) continue;
                            equals = false;
                            --possibleMatches;
                            break;
                        }
                        if (!equals) continue;
                        this.foundMerged(source_method_key, possible, source_method_obj);
                        continue;
                    }
                    --possibleMatches;
                }
                if (possibleMatches > 0) continue;
                this.ignoredMethods.add(source_method_obj);
            }
        }
        for (JSONObject ignored : this.ignoredMethods) {
            ignored.put("method_apis", new JSONArray());
            ignored.put("method_nr_instructions", -1);
            ignored.put("method_locals", -1);
            ignored.put("method_length", -1);
            ignored.put("method_name", (String)ignored.get("name"));
            ignored.put("method_class", ((String)ignored.get("name")).split("->")[0]);
            ignored.remove((String)ignored.get("name"));
            ignored.put("method_args", ignored.get("args"));
            ignored.remove("args");
            this.merged.put(ignored.get("name"), ignored);
        }
    }

    private void foundMerged(String key, JSONObject apk_obj, JSONObject source_obj) {
        JSONObject mergedObj = new JSONObject();
        mergedObj.putAll(apk_obj);
        mergedObj.put("method_name", key.split("->")[1].split("\\|")[0]);
        mergedObj.put("method_hash", (String)source_obj.get("hash"));
        apk_obj.put("method_hash", (String)source_obj.get("hash"));
        this.merged.put(key, mergedObj);
    }
}

