# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['bhagavad_gita_api',
 'bhagavad_gita_api.api',
 'bhagavad_gita_api.api.api_v2',
 'bhagavad_gita_api.api.api_v2.endpoints',
 'bhagavad_gita_api.data',
 'bhagavad_gita_api.data.insert',
 'bhagavad_gita_api.db',
 'bhagavad_gita_api.models']

package_data = \
{'': ['*']}

install_requires = \
['SQLAlchemy>=1.4.19,<2.0.0',
 'fastapi>=0.65.2,<0.66.0',
 'graphene-elastic>=0.7,<0.8',
 'graphene-sqlalchemy-filter>=1.12.2,<2.0.0',
 'graphene-sqlalchemy>=2.3.0,<3.0.0',
 'graphene>=2.1.8,<3.0.0',
 'gunicorn>=20.1.0,<21.0.0',
 'psycopg2-pgevents>=0.2.2,<0.3.0',
 'python-dotenv>=0.18.0,<0.19.0',
 'pytz>=2021.1,<2022.0',
 'rich>=10.4.0,<11.0.0',
 'typer>=0.3.2,<0.4.0',
 'uvicorn>=0.14.0,<0.15.0']

entry_points = \
{'console_scripts': ['bhagavad-gita-api = bhagavad_gita_api.main:cli',
                     'gita-api = bhagavad_gita_api.main:cli']}

setup_kwargs = {
    'name': 'bhagavad-gita-api',
    'version': '2.0.2',
    'description': 'Bhagavad Gita API allows any developer to use content from Bhagavad Gita in their applications.',
    'long_description': '<!-- markdownlint-disable -->\n<p align="center">\n  <a href="https://bhagavadgita.io">\n    <img src="https://raw.githubusercontent.com/gita/bhagavad-gita-api/main/.github/gita.png" alt="Logo" width="300">\n  </a>\n\n  <h3 align="center">Bhagavad Gita API</h3>\n\n  <p align="center">\n    Code for the BhagavadGita.io API, which is an app built for Gita readers by Gita readers.\n    <br />\n    <br />\n    <img alt="GitHub issues" src="https://img.shields.io/github/issues/gita/bhagavad-gita-api">\n    <img alt="PyPI - Python Version" src="https://img.shields.io/pypi/pyversions/bhagavad-gita-api">\n      <a href="https://github.com/gita/bhagavad-gita-api/blob/master/LICENSE">\n    <img alt="LICENSE" src="https://img.shields.io/badge/License-MIT-yellow.svg?maxAge=43200">\n  </a>\n  <a href="https://github.com/gita/bhagavad-gita-api/actions/workflows/deploy.yml"><img alt="Stars" src="https://github.com/gita/bhagavad-gita-api/actions/workflows/deploy.yml/badge.svg"></a>\n  <a href="https://api.bhagavadgita.io/docs"><img src="https://img.shields.io/badge/docs-passing-green" alt="Docs"></a>\n  <a href="https://starcharts.herokuapp.com/gita/bhagavad-gita-api"><img alt="Stars" src="https://img.shields.io/github/stars/gita/bhagavad-gita-api.svg?style=social"></a>\n</p>\n\n\n## Usage\n\nThe Bhagavad Gita API allows any developer to use content from Gita in their apps.\nThis API is built with FastAPI which is based on (and fully compatible with) the open standards for APIs: OpenAPI (previously known as Swagger) and JSON Schema.\n\nDocumentation for this API is availaible in two interactive formats:\n- [Swagger UI](https://api.bhagavadgita.io/docs)\n- [Redoc](https://api.bhagavadgita.io/redoc)\n\nIf you are interested in using this API for your application, please\nregister an account at\n[RapidAPI](https://rapidapi.com/bhagavad-gita-bhagavad-gita-default/api/bhagavad-gita3)\nwhere you\'ll get both the credentials as well as sample code in your language of\nchoice. The API is 100% FREE to use.\n\n## Projects\n\nHere is a list of interesting projects using this API.\n\n- [BhagavadGita.io](https://bhagavadgita.io)\n- [Android App](https://play.google.com/store/apps/details?id=com.hanuman.bhagavadgita)\n\nHave you build something with this API ? Open a "Show and tell" discussion. The maintainers will feature your project on the README if they find it interesting.\n\n## Self Hosting\n<!-- markdownlint-enable -->\n\nThe official API is free to use for all.\nBut If you wish you can self host anywhere you want.\n\nIf you want to deploy your own instance,You can deploy\nthe API server on your system or VPS.\n\n- Using [`pipx`](https://pypa.github.io/pipx/installation/)\n  > **Note** If you dont have `pipx`, just `pip install pipx`\n\n    ```shell\n    pipx run bhagavad-gita-api\n    ```\n\n- Or using [`docker`](https://www.docker.com/)\n\n    ```shell\n    docker run -it -p 8081:8081 --env-file=.env bhagavadgita/bhagavad-gita-api\n    ```\n\n<!-- markdownlint-disable -->\nNow open http://localhost:8081/docs to see docs.\nTo stop the server press <kbd>Ctrl</kbd> + <kbd>C</kbd> on your keyboard.\n<!-- markdownlint-enable -->\n\nBy default an in-memory SQLite database is used.\nBut you configure to use any SQL database of your choice.\nThe official version uses PostgreSQL.\n\nLooking to deploy on a cloud platform ?\nWe have detailed docs to deploy to the following platforms:\n\n- [Heroku](https://github.com/gita/bhagavad-gita-api/wiki/Heroku)\n- [Deta](https://github.com/gita/bhagavad-gita-api/wiki/Deta)\n- [Digital Ocean](https://github.com/gita/bhagavad-gita-api/wiki/Digial-Ocean)\n\n## Configuration\n\nHere is the list of supported environment variables.\n\n<!-- markdownlint-disable -->\n| Name                      | Description                           | Default     |\n| ------------------------- | ------------------------------------- | ----------- |\n| `TESTER_API_KEY`          | The API key for testing.              | `None`      |\n| `SQLALCHEMY_DATABASE_URI` | The DSN for your database connection. | `sqlite://` (in memory SQLite db)|\n<!-- markdownlint-enable -->\n\nIf you want to configure your deployment even more,\nthen please take a look at module [`config.py`](bhagavad_gita_api/config.py).\n\nTo set the environment variables, you may simply use a `.env` file where you\nspecify the values in the format of `KEY=VALUE`.\n\n## Development\n\nFeel free to use the [issue tracker](https://github.com/gita/bhagavad-gita-api/issues)\nfor bugs and feature requests.\n\nLooking to contribute code ? PRs are most welcome!\nTo get started with developing this API, please read the [contributing guide](.github/CONTRIBUTING.md).\n\n## Community\n\nJoin the [Discord chat server](https://discord.gg/gX8dstApZX) and\nhang out with others in the community.\n\nYou can also use [GitHub Discussions](https://github.com/gita/bhagavad-gita-api/discussions)\nto ask questions or tell us about\nprojects you have built using this API.\n\n## Contributors ✨\n\nThanks goes to these wonderful people ([emoji key](https://allcontributors.org/docs/en/emoji-key)):\n\n<!-- ALL-CONTRIBUTORS-LIST:START - Do not remove or modify this section -->\n<!-- prettier-ignore-start -->\n<!-- markdownlint-disable -->\n<table>\n  <tr>\n    <td align="center"><a href="https://github.com/Gupta-Anubhav12"><img src="https://avatars.githubusercontent.com/u/64721638?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Anubhav Gupta</b></sub></a><br /><a href="https://github.com/gita/bhagavad-gita-api/commits?author=Gupta-Anubhav12" title="Code">💻</a></td>\n    <td align="center"><a href="https://github.com/sanujsood"><img src="https://avatars.githubusercontent.com/u/67072668?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Sanuj Sood</b></sub></a><br /><a href="https://github.com/gita/bhagavad-gita-api/commits?author=sanujsood" title="Code">💻</a></td>\n    <td align="center"><a href="http://aahnik.dev"><img src="https://avatars.githubusercontent.com/u/66209958?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Aahnik Daw</b></sub></a><br /><a href="https://github.com/gita/bhagavad-gita-api/commits?author=aahnik" title="Code">💻</a></td>\n    <td align="center"><a href="https://github.com/akshatj2209"><img src="https://avatars.githubusercontent.com/u/57488922?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Akshat Joshi</b></sub></a><br /><a href="https://github.com/gita/bhagavad-gita-api/commits?author=akshatj2209" title="Code">💻</a></td>\n    <td align="center"><a href="https://www.realdevils.com/"><img src="https://avatars.githubusercontent.com/u/60562606?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Amritpal Singh</b></sub></a><br /><a href="https://github.com/gita/bhagavad-gita-api/commits?author=Amritpal2001" title="Code">💻</a></td>\n    <td align="center"><a href="https://github.com/NIKU-SINGH"><img src="https://avatars.githubusercontent.com/u/72123526?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Niku Singh</b></sub></a><br /><a href="https://github.com/gita/bhagavad-gita-api/commits?author=NIKU-SINGH" title="Code">💻</a></td>\n    <td align="center"><a href="https://sreevardhanreddi.github.io/"><img src="https://avatars.githubusercontent.com/u/31174432?v=4?s=100" width="100px;" alt=""/><br /><sub><b>sreevardhanreddi</b></sub></a><br /><a href="https://github.com/gita/bhagavad-gita-api/commits?author=sreevardhanreddi" title="Code">💻</a> <a href="#infra-sreevardhanreddi" title="Infrastructure (Hosting, Build-Tools, etc)">🚇</a></td>\n  </tr>\n</table>\n\n<!-- markdownlint-restore -->\n<!-- prettier-ignore-end -->\n\n<!-- ALL-CONTRIBUTORS-LIST:END -->\n\nThis project follows the [all-contributors](https://github.com/all-contributors/all-contributors)\nspecification. Contributions of any kind welcome!\n',
    'author': 'The Gita Initiative',
    'author_email': 'contact@bhagavadgita.io',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://bhagavadgita.io/',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
