# coding: utf-8

"""
    Wavefront REST API

    <p>The Wavefront REST API enables you to interact with Wavefront servers using standard REST API tools. You can use the REST API to automate commonly executed operations such as automatically tagging sources.</p><p>When you make REST API calls outside the Wavefront REST API documentation you must add the header \"Authorization: Bearer &lt;&lt;API-TOKEN&gt;&gt;\" to your HTTP requests.</p>  # noqa: E501

    OpenAPI spec version: v2
    Contact: chitimba@wavefront.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class RawTimeseries(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'points': 'list[Point]',
        'tags': 'dict(str, str)'
    }

    attribute_map = {
        'points': 'points',
        'tags': 'tags'
    }

    def __init__(self, points=None, tags=None):  # noqa: E501
        """RawTimeseries - a model defined in Swagger"""  # noqa: E501

        self._points = None
        self._tags = None
        self.discriminator = None

        self.points = points
        if tags is not None:
            self.tags = tags

    @property
    def points(self):
        """Gets the points of this RawTimeseries.  # noqa: E501


        :return: The points of this RawTimeseries.  # noqa: E501
        :rtype: list[Point]
        """
        return self._points

    @points.setter
    def points(self, points):
        """Sets the points of this RawTimeseries.


        :param points: The points of this RawTimeseries.  # noqa: E501
        :type: list[Point]
        """
        if points is None:
            raise ValueError("Invalid value for `points`, must not be `None`")  # noqa: E501

        self._points = points

    @property
    def tags(self):
        """Gets the tags of this RawTimeseries.  # noqa: E501

        Associated tags of the time series  # noqa: E501

        :return: The tags of this RawTimeseries.  # noqa: E501
        :rtype: dict(str, str)
        """
        return self._tags

    @tags.setter
    def tags(self, tags):
        """Sets the tags of this RawTimeseries.

        Associated tags of the time series  # noqa: E501

        :param tags: The tags of this RawTimeseries.  # noqa: E501
        :type: dict(str, str)
        """

        self._tags = tags

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(RawTimeseries, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, RawTimeseries):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
