# coding: utf-8

"""
    Wavefront REST API

    <p>The Wavefront REST API enables you to interact with Wavefront servers using standard REST API tools. You can use the REST API to automate commonly executed operations such as automatically tagging sources.</p><p>When you make REST API calls outside the Wavefront REST API documentation you must add the header \"Authorization: Bearer &lt;&lt;API-TOKEN&gt;&gt;\" to your HTTP requests.</p>  # noqa: E501

    OpenAPI spec version: v2
    Contact: chitimba@wavefront.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class Anomaly(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'chart_hash': 'str',
        'chart_link': 'str',
        'col': 'int',
        'created_epoch_millis': 'int',
        'creator_id': 'str',
        'customer': 'str',
        'dashboard_id': 'str',
        'deleted': 'bool',
        'end_ms': 'int',
        'hosts_used': 'list[str]',
        'id': 'str',
        'image_link': 'str',
        'metrics_used': 'list[str]',
        'model': 'str',
        'original_stripes': 'list[Stripe]',
        'param_hash': 'str',
        'query_hash': 'str',
        '_query_params': 'dict(str, str)',
        'row': 'int',
        'section': 'int',
        'start_ms': 'int',
        'updated_epoch_millis': 'int',
        'updated_ms': 'int',
        'updater_id': 'str'
    }

    attribute_map = {
        'chart_hash': 'chartHash',
        'chart_link': 'chartLink',
        'col': 'col',
        'created_epoch_millis': 'createdEpochMillis',
        'creator_id': 'creatorId',
        'customer': 'customer',
        'dashboard_id': 'dashboardId',
        'deleted': 'deleted',
        'end_ms': 'endMs',
        'hosts_used': 'hostsUsed',
        'id': 'id',
        'image_link': 'imageLink',
        'metrics_used': 'metricsUsed',
        'model': 'model',
        'original_stripes': 'originalStripes',
        'param_hash': 'paramHash',
        'query_hash': 'queryHash',
        '_query_params': 'queryParams',
        'row': 'row',
        'section': 'section',
        'start_ms': 'startMs',
        'updated_epoch_millis': 'updatedEpochMillis',
        'updated_ms': 'updatedMs',
        'updater_id': 'updaterId'
    }

    def __init__(self, chart_hash=None, chart_link=None, col=None, created_epoch_millis=None, creator_id=None, customer=None, dashboard_id=None, deleted=None, end_ms=None, hosts_used=None, id=None, image_link=None, metrics_used=None, model=None, original_stripes=None, param_hash=None, query_hash=None, _query_params=None, row=None, section=None, start_ms=None, updated_epoch_millis=None, updated_ms=None, updater_id=None):  # noqa: E501
        """Anomaly - a model defined in Swagger"""  # noqa: E501

        self._chart_hash = None
        self._chart_link = None
        self._col = None
        self._created_epoch_millis = None
        self._creator_id = None
        self._customer = None
        self._dashboard_id = None
        self._deleted = None
        self._end_ms = None
        self._hosts_used = None
        self._id = None
        self._image_link = None
        self._metrics_used = None
        self._model = None
        self._original_stripes = None
        self._param_hash = None
        self._query_hash = None
        self.__query_params = None
        self._row = None
        self._section = None
        self._start_ms = None
        self._updated_epoch_millis = None
        self._updated_ms = None
        self._updater_id = None
        self.discriminator = None

        self.chart_hash = chart_hash
        if chart_link is not None:
            self.chart_link = chart_link
        self.col = col
        if created_epoch_millis is not None:
            self.created_epoch_millis = created_epoch_millis
        if creator_id is not None:
            self.creator_id = creator_id
        if customer is not None:
            self.customer = customer
        self.dashboard_id = dashboard_id
        if deleted is not None:
            self.deleted = deleted
        self.end_ms = end_ms
        if hosts_used is not None:
            self.hosts_used = hosts_used
        if id is not None:
            self.id = id
        if image_link is not None:
            self.image_link = image_link
        if metrics_used is not None:
            self.metrics_used = metrics_used
        if model is not None:
            self.model = model
        if original_stripes is not None:
            self.original_stripes = original_stripes
        self.param_hash = param_hash
        self.query_hash = query_hash
        self._query_params = _query_params
        self.row = row
        self.section = section
        self.start_ms = start_ms
        if updated_epoch_millis is not None:
            self.updated_epoch_millis = updated_epoch_millis
        self.updated_ms = updated_ms
        if updater_id is not None:
            self.updater_id = updater_id

    @property
    def chart_hash(self):
        """Gets the chart_hash of this Anomaly.  # noqa: E501

        chart hash(as unique identifier) for this anomaly  # noqa: E501

        :return: The chart_hash of this Anomaly.  # noqa: E501
        :rtype: str
        """
        return self._chart_hash

    @chart_hash.setter
    def chart_hash(self, chart_hash):
        """Sets the chart_hash of this Anomaly.

        chart hash(as unique identifier) for this anomaly  # noqa: E501

        :param chart_hash: The chart_hash of this Anomaly.  # noqa: E501
        :type: str
        """
        if chart_hash is None:
            raise ValueError("Invalid value for `chart_hash`, must not be `None`")  # noqa: E501

        self._chart_hash = chart_hash

    @property
    def chart_link(self):
        """Gets the chart_link of this Anomaly.  # noqa: E501

        chart link for this anomaly  # noqa: E501

        :return: The chart_link of this Anomaly.  # noqa: E501
        :rtype: str
        """
        return self._chart_link

    @chart_link.setter
    def chart_link(self, chart_link):
        """Sets the chart_link of this Anomaly.

        chart link for this anomaly  # noqa: E501

        :param chart_link: The chart_link of this Anomaly.  # noqa: E501
        :type: str
        """

        self._chart_link = chart_link

    @property
    def col(self):
        """Gets the col of this Anomaly.  # noqa: E501

        column number for this anomaly  # noqa: E501

        :return: The col of this Anomaly.  # noqa: E501
        :rtype: int
        """
        return self._col

    @col.setter
    def col(self, col):
        """Sets the col of this Anomaly.

        column number for this anomaly  # noqa: E501

        :param col: The col of this Anomaly.  # noqa: E501
        :type: int
        """
        if col is None:
            raise ValueError("Invalid value for `col`, must not be `None`")  # noqa: E501

        self._col = col

    @property
    def created_epoch_millis(self):
        """Gets the created_epoch_millis of this Anomaly.  # noqa: E501


        :return: The created_epoch_millis of this Anomaly.  # noqa: E501
        :rtype: int
        """
        return self._created_epoch_millis

    @created_epoch_millis.setter
    def created_epoch_millis(self, created_epoch_millis):
        """Sets the created_epoch_millis of this Anomaly.


        :param created_epoch_millis: The created_epoch_millis of this Anomaly.  # noqa: E501
        :type: int
        """

        self._created_epoch_millis = created_epoch_millis

    @property
    def creator_id(self):
        """Gets the creator_id of this Anomaly.  # noqa: E501


        :return: The creator_id of this Anomaly.  # noqa: E501
        :rtype: str
        """
        return self._creator_id

    @creator_id.setter
    def creator_id(self, creator_id):
        """Sets the creator_id of this Anomaly.


        :param creator_id: The creator_id of this Anomaly.  # noqa: E501
        :type: str
        """

        self._creator_id = creator_id

    @property
    def customer(self):
        """Gets the customer of this Anomaly.  # noqa: E501

        id of the customer to which this anomaly belongs  # noqa: E501

        :return: The customer of this Anomaly.  # noqa: E501
        :rtype: str
        """
        return self._customer

    @customer.setter
    def customer(self, customer):
        """Sets the customer of this Anomaly.

        id of the customer to which this anomaly belongs  # noqa: E501

        :param customer: The customer of this Anomaly.  # noqa: E501
        :type: str
        """

        self._customer = customer

    @property
    def dashboard_id(self):
        """Gets the dashboard_id of this Anomaly.  # noqa: E501

        dashboard id for this anomaly  # noqa: E501

        :return: The dashboard_id of this Anomaly.  # noqa: E501
        :rtype: str
        """
        return self._dashboard_id

    @dashboard_id.setter
    def dashboard_id(self, dashboard_id):
        """Sets the dashboard_id of this Anomaly.

        dashboard id for this anomaly  # noqa: E501

        :param dashboard_id: The dashboard_id of this Anomaly.  # noqa: E501
        :type: str
        """
        if dashboard_id is None:
            raise ValueError("Invalid value for `dashboard_id`, must not be `None`")  # noqa: E501

        self._dashboard_id = dashboard_id

    @property
    def deleted(self):
        """Gets the deleted of this Anomaly.  # noqa: E501


        :return: The deleted of this Anomaly.  # noqa: E501
        :rtype: bool
        """
        return self._deleted

    @deleted.setter
    def deleted(self, deleted):
        """Sets the deleted of this Anomaly.


        :param deleted: The deleted of this Anomaly.  # noqa: E501
        :type: bool
        """

        self._deleted = deleted

    @property
    def end_ms(self):
        """Gets the end_ms of this Anomaly.  # noqa: E501

        endMs for this anomaly  # noqa: E501

        :return: The end_ms of this Anomaly.  # noqa: E501
        :rtype: int
        """
        return self._end_ms

    @end_ms.setter
    def end_ms(self, end_ms):
        """Sets the end_ms of this Anomaly.

        endMs for this anomaly  # noqa: E501

        :param end_ms: The end_ms of this Anomaly.  # noqa: E501
        :type: int
        """
        if end_ms is None:
            raise ValueError("Invalid value for `end_ms`, must not be `None`")  # noqa: E501

        self._end_ms = end_ms

    @property
    def hosts_used(self):
        """Gets the hosts_used of this Anomaly.  # noqa: E501

        list of hosts affected of this anomaly  # noqa: E501

        :return: The hosts_used of this Anomaly.  # noqa: E501
        :rtype: list[str]
        """
        return self._hosts_used

    @hosts_used.setter
    def hosts_used(self, hosts_used):
        """Sets the hosts_used of this Anomaly.

        list of hosts affected of this anomaly  # noqa: E501

        :param hosts_used: The hosts_used of this Anomaly.  # noqa: E501
        :type: list[str]
        """

        self._hosts_used = hosts_used

    @property
    def id(self):
        """Gets the id of this Anomaly.  # noqa: E501

        unique id that defines this anomaly  # noqa: E501

        :return: The id of this Anomaly.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this Anomaly.

        unique id that defines this anomaly  # noqa: E501

        :param id: The id of this Anomaly.  # noqa: E501
        :type: str
        """

        self._id = id

    @property
    def image_link(self):
        """Gets the image_link of this Anomaly.  # noqa: E501

        image link for this anomaly  # noqa: E501

        :return: The image_link of this Anomaly.  # noqa: E501
        :rtype: str
        """
        return self._image_link

    @image_link.setter
    def image_link(self, image_link):
        """Sets the image_link of this Anomaly.

        image link for this anomaly  # noqa: E501

        :param image_link: The image_link of this Anomaly.  # noqa: E501
        :type: str
        """

        self._image_link = image_link

    @property
    def metrics_used(self):
        """Gets the metrics_used of this Anomaly.  # noqa: E501

        list of metrics used of this anomaly  # noqa: E501

        :return: The metrics_used of this Anomaly.  # noqa: E501
        :rtype: list[str]
        """
        return self._metrics_used

    @metrics_used.setter
    def metrics_used(self, metrics_used):
        """Sets the metrics_used of this Anomaly.

        list of metrics used of this anomaly  # noqa: E501

        :param metrics_used: The metrics_used of this Anomaly.  # noqa: E501
        :type: list[str]
        """

        self._metrics_used = metrics_used

    @property
    def model(self):
        """Gets the model of this Anomaly.  # noqa: E501

        model for this anomaly  # noqa: E501

        :return: The model of this Anomaly.  # noqa: E501
        :rtype: str
        """
        return self._model

    @model.setter
    def model(self, model):
        """Sets the model of this Anomaly.

        model for this anomaly  # noqa: E501

        :param model: The model of this Anomaly.  # noqa: E501
        :type: str
        """

        self._model = model

    @property
    def original_stripes(self):
        """Gets the original_stripes of this Anomaly.  # noqa: E501

        list of originalStripe belongs to this anomaly  # noqa: E501

        :return: The original_stripes of this Anomaly.  # noqa: E501
        :rtype: list[Stripe]
        """
        return self._original_stripes

    @original_stripes.setter
    def original_stripes(self, original_stripes):
        """Sets the original_stripes of this Anomaly.

        list of originalStripe belongs to this anomaly  # noqa: E501

        :param original_stripes: The original_stripes of this Anomaly.  # noqa: E501
        :type: list[Stripe]
        """

        self._original_stripes = original_stripes

    @property
    def param_hash(self):
        """Gets the param_hash of this Anomaly.  # noqa: E501

        param hash for this anomaly  # noqa: E501

        :return: The param_hash of this Anomaly.  # noqa: E501
        :rtype: str
        """
        return self._param_hash

    @param_hash.setter
    def param_hash(self, param_hash):
        """Sets the param_hash of this Anomaly.

        param hash for this anomaly  # noqa: E501

        :param param_hash: The param_hash of this Anomaly.  # noqa: E501
        :type: str
        """
        if param_hash is None:
            raise ValueError("Invalid value for `param_hash`, must not be `None`")  # noqa: E501

        self._param_hash = param_hash

    @property
    def query_hash(self):
        """Gets the query_hash of this Anomaly.  # noqa: E501

        query hash for this anomaly  # noqa: E501

        :return: The query_hash of this Anomaly.  # noqa: E501
        :rtype: str
        """
        return self._query_hash

    @query_hash.setter
    def query_hash(self, query_hash):
        """Sets the query_hash of this Anomaly.

        query hash for this anomaly  # noqa: E501

        :param query_hash: The query_hash of this Anomaly.  # noqa: E501
        :type: str
        """
        if query_hash is None:
            raise ValueError("Invalid value for `query_hash`, must not be `None`")  # noqa: E501

        self._query_hash = query_hash

    @property
    def _query_params(self):
        """Gets the _query_params of this Anomaly.  # noqa: E501

        map of query params belongs to this anomaly  # noqa: E501

        :return: The _query_params of this Anomaly.  # noqa: E501
        :rtype: dict(str, str)
        """
        return self.__query_params

    @_query_params.setter
    def _query_params(self, _query_params):
        """Sets the _query_params of this Anomaly.

        map of query params belongs to this anomaly  # noqa: E501

        :param _query_params: The _query_params of this Anomaly.  # noqa: E501
        :type: dict(str, str)
        """
        if _query_params is None:
            raise ValueError("Invalid value for `_query_params`, must not be `None`")  # noqa: E501

        self.__query_params = _query_params

    @property
    def row(self):
        """Gets the row of this Anomaly.  # noqa: E501

        row number for this anomaly  # noqa: E501

        :return: The row of this Anomaly.  # noqa: E501
        :rtype: int
        """
        return self._row

    @row.setter
    def row(self, row):
        """Sets the row of this Anomaly.

        row number for this anomaly  # noqa: E501

        :param row: The row of this Anomaly.  # noqa: E501
        :type: int
        """
        if row is None:
            raise ValueError("Invalid value for `row`, must not be `None`")  # noqa: E501

        self._row = row

    @property
    def section(self):
        """Gets the section of this Anomaly.  # noqa: E501

        section number for this anomaly  # noqa: E501

        :return: The section of this Anomaly.  # noqa: E501
        :rtype: int
        """
        return self._section

    @section.setter
    def section(self, section):
        """Sets the section of this Anomaly.

        section number for this anomaly  # noqa: E501

        :param section: The section of this Anomaly.  # noqa: E501
        :type: int
        """
        if section is None:
            raise ValueError("Invalid value for `section`, must not be `None`")  # noqa: E501

        self._section = section

    @property
    def start_ms(self):
        """Gets the start_ms of this Anomaly.  # noqa: E501

        startMs for this anomaly  # noqa: E501

        :return: The start_ms of this Anomaly.  # noqa: E501
        :rtype: int
        """
        return self._start_ms

    @start_ms.setter
    def start_ms(self, start_ms):
        """Sets the start_ms of this Anomaly.

        startMs for this anomaly  # noqa: E501

        :param start_ms: The start_ms of this Anomaly.  # noqa: E501
        :type: int
        """
        if start_ms is None:
            raise ValueError("Invalid value for `start_ms`, must not be `None`")  # noqa: E501

        self._start_ms = start_ms

    @property
    def updated_epoch_millis(self):
        """Gets the updated_epoch_millis of this Anomaly.  # noqa: E501


        :return: The updated_epoch_millis of this Anomaly.  # noqa: E501
        :rtype: int
        """
        return self._updated_epoch_millis

    @updated_epoch_millis.setter
    def updated_epoch_millis(self, updated_epoch_millis):
        """Sets the updated_epoch_millis of this Anomaly.


        :param updated_epoch_millis: The updated_epoch_millis of this Anomaly.  # noqa: E501
        :type: int
        """

        self._updated_epoch_millis = updated_epoch_millis

    @property
    def updated_ms(self):
        """Gets the updated_ms of this Anomaly.  # noqa: E501

        updateMs for this anomaly  # noqa: E501

        :return: The updated_ms of this Anomaly.  # noqa: E501
        :rtype: int
        """
        return self._updated_ms

    @updated_ms.setter
    def updated_ms(self, updated_ms):
        """Sets the updated_ms of this Anomaly.

        updateMs for this anomaly  # noqa: E501

        :param updated_ms: The updated_ms of this Anomaly.  # noqa: E501
        :type: int
        """
        if updated_ms is None:
            raise ValueError("Invalid value for `updated_ms`, must not be `None`")  # noqa: E501

        self._updated_ms = updated_ms

    @property
    def updater_id(self):
        """Gets the updater_id of this Anomaly.  # noqa: E501


        :return: The updater_id of this Anomaly.  # noqa: E501
        :rtype: str
        """
        return self._updater_id

    @updater_id.setter
    def updater_id(self, updater_id):
        """Sets the updater_id of this Anomaly.


        :param updater_id: The updater_id of this Anomaly.  # noqa: E501
        :type: str
        """

        self._updater_id = updater_id

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(Anomaly, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Anomaly):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
