# coding: utf-8

"""
    Wavefront REST API

    <p>The Wavefront REST API enables you to interact with Wavefront servers using standard REST API tools. You can use the REST API to automate commonly executed operations such as automatically tagging sources.</p><p>When you make REST API calls outside the Wavefront REST API documentation you must add the header \"Authorization: Bearer &lt;&lt;API-TOKEN&gt;&gt;\" to your HTTP requests.</p>  # noqa: E501

    OpenAPI spec version: v2
    Contact: chitimba@wavefront.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from wavefront_api_client.models.access_control_element import AccessControlElement  # noqa: F401,E501


class ACL(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'entity_id': 'str',
        'modify_acl': 'list[AccessControlElement]',
        'view_acl': 'list[AccessControlElement]'
    }

    attribute_map = {
        'entity_id': 'entityId',
        'modify_acl': 'modifyAcl',
        'view_acl': 'viewAcl'
    }

    def __init__(self, entity_id=None, modify_acl=None, view_acl=None):  # noqa: E501
        """ACL - a model defined in Swagger"""  # noqa: E501

        self._entity_id = None
        self._modify_acl = None
        self._view_acl = None
        self.discriminator = None

        self.entity_id = entity_id
        self.modify_acl = modify_acl
        self.view_acl = view_acl

    @property
    def entity_id(self):
        """Gets the entity_id of this ACL.  # noqa: E501

        The entity Id  # noqa: E501

        :return: The entity_id of this ACL.  # noqa: E501
        :rtype: str
        """
        return self._entity_id

    @entity_id.setter
    def entity_id(self, entity_id):
        """Sets the entity_id of this ACL.

        The entity Id  # noqa: E501

        :param entity_id: The entity_id of this ACL.  # noqa: E501
        :type: str
        """
        if entity_id is None:
            raise ValueError("Invalid value for `entity_id`, must not be `None`")  # noqa: E501

        self._entity_id = entity_id

    @property
    def modify_acl(self):
        """Gets the modify_acl of this ACL.  # noqa: E501

        List of users and user groups ids that have modify permission  # noqa: E501

        :return: The modify_acl of this ACL.  # noqa: E501
        :rtype: list[AccessControlElement]
        """
        return self._modify_acl

    @modify_acl.setter
    def modify_acl(self, modify_acl):
        """Sets the modify_acl of this ACL.

        List of users and user groups ids that have modify permission  # noqa: E501

        :param modify_acl: The modify_acl of this ACL.  # noqa: E501
        :type: list[AccessControlElement]
        """
        if modify_acl is None:
            raise ValueError("Invalid value for `modify_acl`, must not be `None`")  # noqa: E501

        self._modify_acl = modify_acl

    @property
    def view_acl(self):
        """Gets the view_acl of this ACL.  # noqa: E501

        List of users and user group ids that have view permission  # noqa: E501

        :return: The view_acl of this ACL.  # noqa: E501
        :rtype: list[AccessControlElement]
        """
        return self._view_acl

    @view_acl.setter
    def view_acl(self, view_acl):
        """Sets the view_acl of this ACL.

        List of users and user group ids that have view permission  # noqa: E501

        :param view_acl: The view_acl of this ACL.  # noqa: E501
        :type: list[AccessControlElement]
        """
        if view_acl is None:
            raise ValueError("Invalid value for `view_acl`, must not be `None`")  # noqa: E501

        self._view_acl = view_acl

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(ACL, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ACL):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
