"""
Themes/Icon Definitions
=======================

.. seealso::

   `Material Design Icons <https://materialdesignicons.com/>`_

.. image:: https://github.com/HeaTTheatR/KivyMD-data/raw/master/gallery/kivymddoc/material-icons.png
    :align: center

List of icons from materialdesignicons.com. These expanded material design
icons are maintained by Austin Andrews (Templarian on Github).

LAST UPDATED: Version 6.9.96

To preview the icons and their names, you can use the following application:
----------------------------------------------------------------------------

.. code-block:: python

    from kivy.lang import Builder
    from kivy.properties import StringProperty
    from kivy.uix.screenmanager import Screen

    from kivymd.icon_definitions import md_icons
    from kivymd.app import MDApp
    from kivymd.uix.list import OneLineIconListItem


    Builder.load_string(
        '''
    #:import images_path kivymd.images_path


    <CustomOneLineIconListItem>

        IconLeftWidget:
            icon: root.icon


    <PreviousMDIcons>

        MDBoxLayout:
            orientation: 'vertical'
            spacing: dp(10)
            padding: dp(20)

            MDBoxLayout:
                adaptive_height: True

                MDIconButton:
                    icon: 'magnify'

                MDTextField:
                    id: search_field
                    hint_text: 'Search icon'
                    on_text: root.set_list_md_icons(self.text, True)

            RecycleView:
                id: rv
                key_viewclass: 'viewclass'
                key_size: 'height'

                RecycleBoxLayout:
                    padding: dp(10)
                    default_size: None, dp(48)
                    default_size_hint: 1, None
                    size_hint_y: None
                    height: self.minimum_height
                    orientation: 'vertical'
    '''
    )


    class CustomOneLineIconListItem(OneLineIconListItem):
        icon = StringProperty()


    class PreviousMDIcons(Screen):

        def set_list_md_icons(self, text="", search=False):
            '''Builds a list of icons for the screen MDIcons.'''

            def add_icon_item(name_icon):
                self.ids.rv.data.append(
                    {
                        "viewclass": "CustomOneLineIconListItem",
                        "icon": name_icon,
                        "text": name_icon,
                        "callback": lambda x: x,
                    }
                )

            self.ids.rv.data = []
            for name_icon in md_icons.keys():
                if search:
                    if text in name_icon:
                        add_icon_item(name_icon)
                else:
                    add_icon_item(name_icon)


    class MainApp(MDApp):
        def __init__(self, **kwargs):
            super().__init__(**kwargs)
            self.screen = PreviousMDIcons()

        def build(self):
            return self.screen

        def on_start(self):
            self.screen.set_list_md_icons()


    MainApp().run()

.. image:: https://github.com/HeaTTheatR/KivyMD-data/raw/master/gallery/kivymddoc/md-icons-previous.gif
    :align: center

"""

md_icons = {
    "ab-testing": "\U000F01C9",
    "abacus": "\U000F16E0",
    "abjad-arabic": "\U000F1328",
    "abjad-hebrew": "\U000F1329",
    "abugida-devanagari": "\U000F132A",
    "abugida-thai": "\U000F132B",
    "access-point": "\U000F0003",
    "access-point-check": "\U000F1538",
    "access-point-minus": "\U000F1539",
    "access-point-network": "\U000F0002",
    "access-point-network-off": "\U000F0BE1",
    "access-point-off": "\U000F1511",
    "access-point-plus": "\U000F153A",
    "access-point-remove": "\U000F153B",
    "account": "\U000F0004",
    "account-alert": "\U000F0005",
    "account-alert-outline": "\U000F0B50",
    "account-arrow-down": "\U000F1868",
    "account-arrow-down-outline": "\U000F1869",
    "account-arrow-left": "\U000F0B51",
    "account-arrow-left-outline": "\U000F0B52",
    "account-arrow-right": "\U000F0B53",
    "account-arrow-right-outline": "\U000F0B54",
    "account-arrow-up": "\U000F1867",
    "account-arrow-up-outline": "\U000F186A",
    "account-badge": "\U000F1B0A",
    "account-badge-outline": "\U000F1B0B",
    "account-box": "\U000F0006",
    "account-box-multiple": "\U000F0934",
    "account-box-multiple-outline": "\U000F100A",
    "account-box-outline": "\U000F0007",
    "account-cancel": "\U000F12DF",
    "account-cancel-outline": "\U000F12E0",
    "account-cash": "\U000F1097",
    "account-cash-outline": "\U000F1098",
    "account-check": "\U000F0008",
    "account-check-outline": "\U000F0BE2",
    "account-child": "\U000F0A89",
    "account-child-circle": "\U000F0A8A",
    "account-child-outline": "\U000F10C8",
    "account-circle": "\U000F0009",
    "account-circle-outline": "\U000F0B55",
    "account-clock": "\U000F0B56",
    "account-clock-outline": "\U000F0B57",
    "account-cog": "\U000F1370",
    "account-cog-outline": "\U000F1371",
    "account-convert": "\U000F000A",
    "account-convert-outline": "\U000F1301",
    "account-cowboy-hat": "\U000F0E9B",
    "account-cowboy-hat-outline": "\U000F17F3",
    "account-details": "\U000F0631",
    "account-details-outline": "\U000F1372",
    "account-edit": "\U000F06BC",
    "account-edit-outline": "\U000F0FFB",
    "account-eye": "\U000F0420",
    "account-eye-outline": "\U000F127B",
    "account-filter": "\U000F0936",
    "account-filter-outline": "\U000F0F9D",
    "account-group": "\U000F0849",
    "account-group-outline": "\U000F0B58",
    "account-hard-hat": "\U000F05B5",
    "account-hard-hat-outline": "\U000F1A1F",
    "account-heart": "\U000F0899",
    "account-heart-outline": "\U000F0BE3",
    "account-injury": "\U000F1815",
    "account-injury-outline": "\U000F1816",
    "account-key": "\U000F000B",
    "account-key-outline": "\U000F0BE4",
    "account-lock": "\U000F115E",
    "account-lock-open": "\U000F1960",
    "account-lock-open-outline": "\U000F1961",
    "account-lock-outline": "\U000F115F",
    "account-minus": "\U000F000D",
    "account-minus-outline": "\U000F0AEC",
    "account-multiple": "\U000F000E",
    "account-multiple-check": "\U000F08C5",
    "account-multiple-check-outline": "\U000F11FE",
    "account-multiple-minus": "\U000F05D3",
    "account-multiple-minus-outline": "\U000F0BE5",
    "account-multiple-outline": "\U000F000F",
    "account-multiple-plus": "\U000F0010",
    "account-multiple-plus-outline": "\U000F0800",
    "account-multiple-remove": "\U000F120A",
    "account-multiple-remove-outline": "\U000F120B",
    "account-music": "\U000F0803",
    "account-music-outline": "\U000F0CE9",
    "account-network": "\U000F0011",
    "account-network-off": "\U000F1AF1",
    "account-network-off-outline": "\U000F1AF2",
    "account-network-outline": "\U000F0BE6",
    "account-off": "\U000F0012",
    "account-off-outline": "\U000F0BE7",
    "account-outline": "\U000F0013",
    "account-plus": "\U000F0014",
    "account-plus-outline": "\U000F0801",
    "account-question": "\U000F0B59",
    "account-question-outline": "\U000F0B5A",
    "account-reactivate": "\U000F152B",
    "account-reactivate-outline": "\U000F152C",
    "account-remove": "\U000F0015",
    "account-remove-outline": "\U000F0AED",
    "account-school": "\U000F1A20",
    "account-school-outline": "\U000F1A21",
    "account-search": "\U000F0016",
    "account-search-outline": "\U000F0935",
    "account-settings": "\U000F0630",
    "account-settings-outline": "\U000F10C9",
    "account-star": "\U000F0017",
    "account-star-outline": "\U000F0BE8",
    "account-supervisor": "\U000F0A8B",
    "account-supervisor-circle": "\U000F0A8C",
    "account-supervisor-circle-outline": "\U000F14EC",
    "account-supervisor-outline": "\U000F112D",
    "account-switch": "\U000F0019",
    "account-switch-outline": "\U000F04CB",
    "account-sync": "\U000F191B",
    "account-sync-outline": "\U000F191C",
    "account-tie": "\U000F0CE3",
    "account-tie-hat": "\U000F1898",
    "account-tie-hat-outline": "\U000F1899",
    "account-tie-outline": "\U000F10CA",
    "account-tie-voice": "\U000F1308",
    "account-tie-voice-off": "\U000F130A",
    "account-tie-voice-off-outline": "\U000F130B",
    "account-tie-voice-outline": "\U000F1309",
    "account-tie-woman": "\U000F1A8C",
    "account-voice": "\U000F05CB",
    "account-voice-off": "\U000F0ED4",
    "account-wrench": "\U000F189A",
    "account-wrench-outline": "\U000F189B",
    "adjust": "\U000F001A",
    "advertisements": "\U000F192A",
    "advertisements-off": "\U000F192B",
    "air-conditioner": "\U000F001B",
    "air-filter": "\U000F0D43",
    "air-horn": "\U000F0DAC",
    "air-humidifier": "\U000F1099",
    "air-humidifier-off": "\U000F1466",
    "air-purifier": "\U000F0D44",
    "airbag": "\U000F0BE9",
    "airballoon": "\U000F001C",
    "airballoon-outline": "\U000F100B",
    "airplane": "\U000F001D",
    "airplane-alert": "\U000F187A",
    "airplane-check": "\U000F187B",
    "airplane-clock": "\U000F187C",
    "airplane-cog": "\U000F187D",
    "airplane-edit": "\U000F187E",
    "airplane-landing": "\U000F05D4",
    "airplane-marker": "\U000F187F",
    "airplane-minus": "\U000F1880",
    "airplane-off": "\U000F001E",
    "airplane-plus": "\U000F1881",
    "airplane-remove": "\U000F1882",
    "airplane-search": "\U000F1883",
    "airplane-settings": "\U000F1884",
    "airplane-takeoff": "\U000F05D5",
    "airport": "\U000F084B",
    "alarm": "\U000F0020",
    "alarm-bell": "\U000F078E",
    "alarm-check": "\U000F0021",
    "alarm-light": "\U000F078F",
    "alarm-light-off": "\U000F171E",
    "alarm-light-off-outline": "\U000F171F",
    "alarm-light-outline": "\U000F0BEA",
    "alarm-multiple": "\U000F0022",
    "alarm-note": "\U000F0E71",
    "alarm-note-off": "\U000F0E72",
    "alarm-off": "\U000F0023",
    "alarm-panel": "\U000F15C4",
    "alarm-panel-outline": "\U000F15C5",
    "alarm-plus": "\U000F0024",
    "alarm-snooze": "\U000F068E",
    "album": "\U000F0025",
    "alert": "\U000F0026",
    "alert-box": "\U000F0027",
    "alert-box-outline": "\U000F0CE4",
    "alert-circle": "\U000F0028",
    "alert-circle-check": "\U000F11ED",
    "alert-circle-check-outline": "\U000F11EE",
    "alert-circle-outline": "\U000F05D6",
    "alert-decagram": "\U000F06BD",
    "alert-decagram-outline": "\U000F0CE5",
    "alert-minus": "\U000F14BB",
    "alert-minus-outline": "\U000F14BE",
    "alert-octagon": "\U000F0029",
    "alert-octagon-outline": "\U000F0CE6",
    "alert-octagram": "\U000F0767",
    "alert-octagram-outline": "\U000F0CE7",
    "alert-outline": "\U000F002A",
    "alert-plus": "\U000F14BA",
    "alert-plus-outline": "\U000F14BD",
    "alert-remove": "\U000F14BC",
    "alert-remove-outline": "\U000F14BF",
    "alert-rhombus": "\U000F11CE",
    "alert-rhombus-outline": "\U000F11CF",
    "alien": "\U000F089A",
    "alien-outline": "\U000F10CB",
    "align-horizontal-center": "\U000F11C3",
    "align-horizontal-distribute": "\U000F1962",
    "align-horizontal-left": "\U000F11C2",
    "align-horizontal-right": "\U000F11C4",
    "align-vertical-bottom": "\U000F11C5",
    "align-vertical-center": "\U000F11C6",
    "align-vertical-distribute": "\U000F1963",
    "align-vertical-top": "\U000F11C7",
    "all-inclusive": "\U000F06BE",
    "all-inclusive-box": "\U000F188D",
    "all-inclusive-box-outline": "\U000F188E",
    "allergy": "\U000F1258",
    "alpha": "\U000F002B",
    "alpha-a": "\U000F0AEE",
    "alpha-a-box": "\U000F0B08",
    "alpha-a-box-outline": "\U000F0BEB",
    "alpha-a-circle": "\U000F0BEC",
    "alpha-a-circle-outline": "\U000F0BED",
    "alpha-b": "\U000F0AEF",
    "alpha-b-box": "\U000F0B09",
    "alpha-b-box-outline": "\U000F0BEE",
    "alpha-b-circle": "\U000F0BEF",
    "alpha-b-circle-outline": "\U000F0BF0",
    "alpha-c": "\U000F0AF0",
    "alpha-c-box": "\U000F0B0A",
    "alpha-c-box-outline": "\U000F0BF1",
    "alpha-c-circle": "\U000F0BF2",
    "alpha-c-circle-outline": "\U000F0BF3",
    "alpha-d": "\U000F0AF1",
    "alpha-d-box": "\U000F0B0B",
    "alpha-d-box-outline": "\U000F0BF4",
    "alpha-d-circle": "\U000F0BF5",
    "alpha-d-circle-outline": "\U000F0BF6",
    "alpha-e": "\U000F0AF2",
    "alpha-e-box": "\U000F0B0C",
    "alpha-e-box-outline": "\U000F0BF7",
    "alpha-e-circle": "\U000F0BF8",
    "alpha-e-circle-outline": "\U000F0BF9",
    "alpha-f": "\U000F0AF3",
    "alpha-f-box": "\U000F0B0D",
    "alpha-f-box-outline": "\U000F0BFA",
    "alpha-f-circle": "\U000F0BFB",
    "alpha-f-circle-outline": "\U000F0BFC",
    "alpha-g": "\U000F0AF4",
    "alpha-g-box": "\U000F0B0E",
    "alpha-g-box-outline": "\U000F0BFD",
    "alpha-g-circle": "\U000F0BFE",
    "alpha-g-circle-outline": "\U000F0BFF",
    "alpha-h": "\U000F0AF5",
    "alpha-h-box": "\U000F0B0F",
    "alpha-h-box-outline": "\U000F0C00",
    "alpha-h-circle": "\U000F0C01",
    "alpha-h-circle-outline": "\U000F0C02",
    "alpha-i": "\U000F0AF6",
    "alpha-i-box": "\U000F0B10",
    "alpha-i-box-outline": "\U000F0C03",
    "alpha-i-circle": "\U000F0C04",
    "alpha-i-circle-outline": "\U000F0C05",
    "alpha-j": "\U000F0AF7",
    "alpha-j-box": "\U000F0B11",
    "alpha-j-box-outline": "\U000F0C06",
    "alpha-j-circle": "\U000F0C07",
    "alpha-j-circle-outline": "\U000F0C08",
    "alpha-k": "\U000F0AF8",
    "alpha-k-box": "\U000F0B12",
    "alpha-k-box-outline": "\U000F0C09",
    "alpha-k-circle": "\U000F0C0A",
    "alpha-k-circle-outline": "\U000F0C0B",
    "alpha-l": "\U000F0AF9",
    "alpha-l-box": "\U000F0B13",
    "alpha-l-box-outline": "\U000F0C0C",
    "alpha-l-circle": "\U000F0C0D",
    "alpha-l-circle-outline": "\U000F0C0E",
    "alpha-m": "\U000F0AFA",
    "alpha-m-box": "\U000F0B14",
    "alpha-m-box-outline": "\U000F0C0F",
    "alpha-m-circle": "\U000F0C10",
    "alpha-m-circle-outline": "\U000F0C11",
    "alpha-n": "\U000F0AFB",
    "alpha-n-box": "\U000F0B15",
    "alpha-n-box-outline": "\U000F0C12",
    "alpha-n-circle": "\U000F0C13",
    "alpha-n-circle-outline": "\U000F0C14",
    "alpha-o": "\U000F0AFC",
    "alpha-o-box": "\U000F0B16",
    "alpha-o-box-outline": "\U000F0C15",
    "alpha-o-circle": "\U000F0C16",
    "alpha-o-circle-outline": "\U000F0C17",
    "alpha-p": "\U000F0AFD",
    "alpha-p-box": "\U000F0B17",
    "alpha-p-box-outline": "\U000F0C18",
    "alpha-p-circle": "\U000F0C19",
    "alpha-p-circle-outline": "\U000F0C1A",
    "alpha-q": "\U000F0AFE",
    "alpha-q-box": "\U000F0B18",
    "alpha-q-box-outline": "\U000F0C1B",
    "alpha-q-circle": "\U000F0C1C",
    "alpha-q-circle-outline": "\U000F0C1D",
    "alpha-r": "\U000F0AFF",
    "alpha-r-box": "\U000F0B19",
    "alpha-r-box-outline": "\U000F0C1E",
    "alpha-r-circle": "\U000F0C1F",
    "alpha-r-circle-outline": "\U000F0C20",
    "alpha-s": "\U000F0B00",
    "alpha-s-box": "\U000F0B1A",
    "alpha-s-box-outline": "\U000F0C21",
    "alpha-s-circle": "\U000F0C22",
    "alpha-s-circle-outline": "\U000F0C23",
    "alpha-t": "\U000F0B01",
    "alpha-t-box": "\U000F0B1B",
    "alpha-t-box-outline": "\U000F0C24",
    "alpha-t-circle": "\U000F0C25",
    "alpha-t-circle-outline": "\U000F0C26",
    "alpha-u": "\U000F0B02",
    "alpha-u-box": "\U000F0B1C",
    "alpha-u-box-outline": "\U000F0C27",
    "alpha-u-circle": "\U000F0C28",
    "alpha-u-circle-outline": "\U000F0C29",
    "alpha-v": "\U000F0B03",
    "alpha-v-box": "\U000F0B1D",
    "alpha-v-box-outline": "\U000F0C2A",
    "alpha-v-circle": "\U000F0C2B",
    "alpha-v-circle-outline": "\U000F0C2C",
    "alpha-w": "\U000F0B04",
    "alpha-w-box": "\U000F0B1E",
    "alpha-w-box-outline": "\U000F0C2D",
    "alpha-w-circle": "\U000F0C2E",
    "alpha-w-circle-outline": "\U000F0C2F",
    "alpha-x": "\U000F0B05",
    "alpha-x-box": "\U000F0B1F",
    "alpha-x-box-outline": "\U000F0C30",
    "alpha-x-circle": "\U000F0C31",
    "alpha-x-circle-outline": "\U000F0C32",
    "alpha-y": "\U000F0B06",
    "alpha-y-box": "\U000F0B20",
    "alpha-y-box-outline": "\U000F0C33",
    "alpha-y-circle": "\U000F0C34",
    "alpha-y-circle-outline": "\U000F0C35",
    "alpha-z": "\U000F0B07",
    "alpha-z-box": "\U000F0B21",
    "alpha-z-box-outline": "\U000F0C36",
    "alpha-z-circle": "\U000F0C37",
    "alpha-z-circle-outline": "\U000F0C38",
    "alphabet-aurebesh": "\U000F132C",
    "alphabet-cyrillic": "\U000F132D",
    "alphabet-greek": "\U000F132E",
    "alphabet-latin": "\U000F132F",
    "alphabet-piqad": "\U000F1330",
    "alphabet-tengwar": "\U000F1337",
    "alphabetical": "\U000F002C",
    "alphabetical-off": "\U000F100C",
    "alphabetical-variant": "\U000F100D",
    "alphabetical-variant-off": "\U000F100E",
    "altimeter": "\U000F05D7",
    "ambulance": "\U000F002F",
    "ammunition": "\U000F0CE8",
    "ampersand": "\U000F0A8D",
    "amplifier": "\U000F0030",
    "amplifier-off": "\U000F11B5",
    "anchor": "\U000F0031",
    "android": "\U000F0032",
    "android-messages": "\U000F0D45",
    "android-studio": "\U000F0034",
    "angle-acute": "\U000F0937",
    "angle-obtuse": "\U000F0938",
    "angle-right": "\U000F0939",
    "angular": "\U000F06B2",
    "angularjs": "\U000F06BF",
    "animation": "\U000F05D8",
    "animation-outline": "\U000F0A8F",
    "animation-play": "\U000F093A",
    "animation-play-outline": "\U000F0A90",
    "ansible": "\U000F109A",
    "antenna": "\U000F1119",
    "anvil": "\U000F089B",
    "apache-kafka": "\U000F100F",
    "api": "\U000F109B",
    "api-off": "\U000F1257",
    "apple": "\U000F0035",
    "apple-finder": "\U000F0036",
    "apple-icloud": "\U000F0038",
    "apple-ios": "\U000F0037",
    "apple-keyboard-caps": "\U000F0632",
    "apple-keyboard-command": "\U000F0633",
    "apple-keyboard-control": "\U000F0634",
    "apple-keyboard-option": "\U000F0635",
    "apple-keyboard-shift": "\U000F0636",
    "apple-safari": "\U000F0039",
    "application": "\U000F08C6",
    "application-array": "\U000F10F5",
    "application-array-outline": "\U000F10F6",
    "application-braces": "\U000F10F7",
    "application-braces-outline": "\U000F10F8",
    "application-brackets": "\U000F0C8B",
    "application-brackets-outline": "\U000F0C8C",
    "application-cog": "\U000F0675",
    "application-cog-outline": "\U000F1577",
    "application-edit": "\U000F00AE",
    "application-edit-outline": "\U000F0619",
    "application-export": "\U000F0DAD",
    "application-import": "\U000F0DAE",
    "application-outline": "\U000F0614",
    "application-parentheses": "\U000F10F9",
    "application-parentheses-outline": "\U000F10FA",
    "application-settings": "\U000F0B60",
    "application-settings-outline": "\U000F1555",
    "application-variable": "\U000F10FB",
    "application-variable-outline": "\U000F10FC",
    "approximately-equal": "\U000F0F9E",
    "approximately-equal-box": "\U000F0F9F",
    "apps": "\U000F003B",
    "apps-box": "\U000F0D46",
    "arch": "\U000F08C7",
    "archive": "\U000F003C",
    "archive-alert": "\U000F14FD",
    "archive-alert-outline": "\U000F14FE",
    "archive-arrow-down": "\U000F1259",
    "archive-arrow-down-outline": "\U000F125A",
    "archive-arrow-up": "\U000F125B",
    "archive-arrow-up-outline": "\U000F125C",
    "archive-cancel": "\U000F174B",
    "archive-cancel-outline": "\U000F174C",
    "archive-check": "\U000F174D",
    "archive-check-outline": "\U000F174E",
    "archive-clock": "\U000F174F",
    "archive-clock-outline": "\U000F1750",
    "archive-cog": "\U000F1751",
    "archive-cog-outline": "\U000F1752",
    "archive-edit": "\U000F1753",
    "archive-edit-outline": "\U000F1754",
    "archive-eye": "\U000F1755",
    "archive-eye-outline": "\U000F1756",
    "archive-lock": "\U000F1757",
    "archive-lock-open": "\U000F1758",
    "archive-lock-open-outline": "\U000F1759",
    "archive-lock-outline": "\U000F175A",
    "archive-marker": "\U000F175B",
    "archive-marker-outline": "\U000F175C",
    "archive-minus": "\U000F175D",
    "archive-minus-outline": "\U000F175E",
    "archive-music": "\U000F175F",
    "archive-music-outline": "\U000F1760",
    "archive-off": "\U000F1761",
    "archive-off-outline": "\U000F1762",
    "archive-outline": "\U000F120E",
    "archive-plus": "\U000F1763",
    "archive-plus-outline": "\U000F1764",
    "archive-refresh": "\U000F1765",
    "archive-refresh-outline": "\U000F1766",
    "archive-remove": "\U000F1767",
    "archive-remove-outline": "\U000F1768",
    "archive-search": "\U000F1769",
    "archive-search-outline": "\U000F176A",
    "archive-settings": "\U000F176B",
    "archive-settings-outline": "\U000F176C",
    "archive-star": "\U000F176D",
    "archive-star-outline": "\U000F176E",
    "archive-sync": "\U000F176F",
    "archive-sync-outline": "\U000F1770",
    "arm-flex": "\U000F0FD7",
    "arm-flex-outline": "\U000F0FD6",
    "arrange-bring-forward": "\U000F003D",
    "arrange-bring-to-front": "\U000F003E",
    "arrange-send-backward": "\U000F003F",
    "arrange-send-to-back": "\U000F0040",
    "arrow-all": "\U000F0041",
    "arrow-bottom-left": "\U000F0042",
    "arrow-bottom-left-bold-box": "\U000F1964",
    "arrow-bottom-left-bold-box-outline": "\U000F1965",
    "arrow-bottom-left-bold-outline": "\U000F09B7",
    "arrow-bottom-left-thick": "\U000F09B8",
    "arrow-bottom-left-thin": "\U000F19B6",
    "arrow-bottom-left-thin-circle-outline": "\U000F1596",
    "arrow-bottom-right": "\U000F0043",
    "arrow-bottom-right-bold-box": "\U000F1966",
    "arrow-bottom-right-bold-box-outline": "\U000F1967",
    "arrow-bottom-right-bold-outline": "\U000F09B9",
    "arrow-bottom-right-thick": "\U000F09BA",
    "arrow-bottom-right-thin": "\U000F19B7",
    "arrow-bottom-right-thin-circle-outline": "\U000F1595",
    "arrow-collapse": "\U000F0615",
    "arrow-collapse-all": "\U000F0044",
    "arrow-collapse-down": "\U000F0792",
    "arrow-collapse-horizontal": "\U000F084C",
    "arrow-collapse-left": "\U000F0793",
    "arrow-collapse-right": "\U000F0794",
    "arrow-collapse-up": "\U000F0795",
    "arrow-collapse-vertical": "\U000F084D",
    "arrow-decision": "\U000F09BB",
    "arrow-decision-auto": "\U000F09BC",
    "arrow-decision-auto-outline": "\U000F09BD",
    "arrow-decision-outline": "\U000F09BE",
    "arrow-down": "\U000F0045",
    "arrow-down-bold": "\U000F072E",
    "arrow-down-bold-box": "\U000F072F",
    "arrow-down-bold-box-outline": "\U000F0730",
    "arrow-down-bold-circle": "\U000F0047",
    "arrow-down-bold-circle-outline": "\U000F0048",
    "arrow-down-bold-hexagon-outline": "\U000F0049",
    "arrow-down-bold-outline": "\U000F09BF",
    "arrow-down-box": "\U000F06C0",
    "arrow-down-circle": "\U000F0CDB",
    "arrow-down-circle-outline": "\U000F0CDC",
    "arrow-down-drop-circle": "\U000F004A",
    "arrow-down-drop-circle-outline": "\U000F004B",
    "arrow-down-left": "\U000F17A1",
    "arrow-down-left-bold": "\U000F17A2",
    "arrow-down-right": "\U000F17A3",
    "arrow-down-right-bold": "\U000F17A4",
    "arrow-down-thick": "\U000F0046",
    "arrow-down-thin": "\U000F19B3",
    "arrow-down-thin-circle-outline": "\U000F1599",
    "arrow-expand": "\U000F0616",
    "arrow-expand-all": "\U000F004C",
    "arrow-expand-down": "\U000F0796",
    "arrow-expand-horizontal": "\U000F084E",
    "arrow-expand-left": "\U000F0797",
    "arrow-expand-right": "\U000F0798",
    "arrow-expand-up": "\U000F0799",
    "arrow-expand-vertical": "\U000F084F",
    "arrow-horizontal-lock": "\U000F115B",
    "arrow-left": "\U000F004D",
    "arrow-left-bold": "\U000F0731",
    "arrow-left-bold-box": "\U000F0732",
    "arrow-left-bold-box-outline": "\U000F0733",
    "arrow-left-bold-circle": "\U000F004F",
    "arrow-left-bold-circle-outline": "\U000F0050",
    "arrow-left-bold-hexagon-outline": "\U000F0051",
    "arrow-left-bold-outline": "\U000F09C0",
    "arrow-left-bottom": "\U000F17A5",
    "arrow-left-bottom-bold": "\U000F17A6",
    "arrow-left-box": "\U000F06C1",
    "arrow-left-circle": "\U000F0CDD",
    "arrow-left-circle-outline": "\U000F0CDE",
    "arrow-left-drop-circle": "\U000F0052",
    "arrow-left-drop-circle-outline": "\U000F0053",
    "arrow-left-right": "\U000F0E73",
    "arrow-left-right-bold": "\U000F0E74",
    "arrow-left-right-bold-outline": "\U000F09C1",
    "arrow-left-thick": "\U000F004E",
    "arrow-left-thin": "\U000F19B1",
    "arrow-left-thin-circle-outline": "\U000F159A",
    "arrow-left-top": "\U000F17A7",
    "arrow-left-top-bold": "\U000F17A8",
    "arrow-projectile": "\U000F1840",
    "arrow-projectile-multiple": "\U000F183F",
    "arrow-right": "\U000F0054",
    "arrow-right-bold": "\U000F0734",
    "arrow-right-bold-box": "\U000F0735",
    "arrow-right-bold-box-outline": "\U000F0736",
    "arrow-right-bold-circle": "\U000F0056",
    "arrow-right-bold-circle-outline": "\U000F0057",
    "arrow-right-bold-hexagon-outline": "\U000F0058",
    "arrow-right-bold-outline": "\U000F09C2",
    "arrow-right-bottom": "\U000F17A9",
    "arrow-right-bottom-bold": "\U000F17AA",
    "arrow-right-box": "\U000F06C2",
    "arrow-right-circle": "\U000F0CDF",
    "arrow-right-circle-outline": "\U000F0CE0",
    "arrow-right-drop-circle": "\U000F0059",
    "arrow-right-drop-circle-outline": "\U000F005A",
    "arrow-right-thick": "\U000F0055",
    "arrow-right-thin": "\U000F19B0",
    "arrow-right-thin-circle-outline": "\U000F1598",
    "arrow-right-top": "\U000F17AB",
    "arrow-right-top-bold": "\U000F17AC",
    "arrow-split-horizontal": "\U000F093B",
    "arrow-split-vertical": "\U000F093C",
    "arrow-top-left": "\U000F005B",
    "arrow-top-left-bold-box": "\U000F1968",
    "arrow-top-left-bold-box-outline": "\U000F1969",
    "arrow-top-left-bold-outline": "\U000F09C3",
    "arrow-top-left-bottom-right": "\U000F0E75",
    "arrow-top-left-bottom-right-bold": "\U000F0E76",
    "arrow-top-left-thick": "\U000F09C4",
    "arrow-top-left-thin": "\U000F19B5",
    "arrow-top-left-thin-circle-outline": "\U000F1593",
    "arrow-top-right": "\U000F005C",
    "arrow-top-right-bold-box": "\U000F196A",
    "arrow-top-right-bold-box-outline": "\U000F196B",
    "arrow-top-right-bold-outline": "\U000F09C5",
    "arrow-top-right-bottom-left": "\U000F0E77",
    "arrow-top-right-bottom-left-bold": "\U000F0E78",
    "arrow-top-right-thick": "\U000F09C6",
    "arrow-top-right-thin": "\U000F19B4",
    "arrow-top-right-thin-circle-outline": "\U000F1594",
    "arrow-u-down-left": "\U000F17AD",
    "arrow-u-down-left-bold": "\U000F17AE",
    "arrow-u-down-right": "\U000F17AF",
    "arrow-u-down-right-bold": "\U000F17B0",
    "arrow-u-left-bottom": "\U000F17B1",
    "arrow-u-left-bottom-bold": "\U000F17B2",
    "arrow-u-left-top": "\U000F17B3",
    "arrow-u-left-top-bold": "\U000F17B4",
    "arrow-u-right-bottom": "\U000F17B5",
    "arrow-u-right-bottom-bold": "\U000F17B6",
    "arrow-u-right-top": "\U000F17B7",
    "arrow-u-right-top-bold": "\U000F17B8",
    "arrow-u-up-left": "\U000F17B9",
    "arrow-u-up-left-bold": "\U000F17BA",
    "arrow-u-up-right": "\U000F17BB",
    "arrow-u-up-right-bold": "\U000F17BC",
    "arrow-up": "\U000F005D",
    "arrow-up-bold": "\U000F0737",
    "arrow-up-bold-box": "\U000F0738",
    "arrow-up-bold-box-outline": "\U000F0739",
    "arrow-up-bold-circle": "\U000F005F",
    "arrow-up-bold-circle-outline": "\U000F0060",
    "arrow-up-bold-hexagon-outline": "\U000F0061",
    "arrow-up-bold-outline": "\U000F09C7",
    "arrow-up-box": "\U000F06C3",
    "arrow-up-circle": "\U000F0CE1",
    "arrow-up-circle-outline": "\U000F0CE2",
    "arrow-up-down": "\U000F0E79",
    "arrow-up-down-bold": "\U000F0E7A",
    "arrow-up-down-bold-outline": "\U000F09C8",
    "arrow-up-drop-circle": "\U000F0062",
    "arrow-up-drop-circle-outline": "\U000F0063",
    "arrow-up-left": "\U000F17BD",
    "arrow-up-left-bold": "\U000F17BE",
    "arrow-up-right": "\U000F17BF",
    "arrow-up-right-bold": "\U000F17C0",
    "arrow-up-thick": "\U000F005E",
    "arrow-up-thin": "\U000F19B2",
    "arrow-up-thin-circle-outline": "\U000F1597",
    "arrow-vertical-lock": "\U000F115C",
    "artstation": "\U000F0B5B",
    "aspect-ratio": "\U000F0A24",
    "assistant": "\U000F0064",
    "asterisk": "\U000F06C4",
    "asterisk-circle-outline": "\U000F1A27",
    "at": "\U000F0065",
    "atlassian": "\U000F0804",
    "atm": "\U000F0D47",
    "atom": "\U000F0768",
    "atom-variant": "\U000F0E7B",
    "attachment": "\U000F0066",
    "attachment-check": "\U000F1AC1",
    "attachment-lock": "\U000F19C4",
    "attachment-minus": "\U000F1AC2",
    "attachment-off": "\U000F1AC3",
    "attachment-plus": "\U000F1AC4",
    "attachment-remove": "\U000F1AC5",
    "audio-input-rca": "\U000F186B",
    "audio-input-stereo-minijack": "\U000F186C",
    "audio-input-xlr": "\U000F186D",
    "audio-video": "\U000F093D",
    "audio-video-off": "\U000F11B6",
    "augmented-reality": "\U000F0850",
    "auto-download": "\U000F137E",
    "auto-fix": "\U000F0068",
    "auto-upload": "\U000F0069",
    "autorenew": "\U000F006A",
    "autorenew-off": "\U000F19E7",
    "av-timer": "\U000F006B",
    "aws": "\U000F0E0F",
    "axe": "\U000F08C8",
    "axe-battle": "\U000F1842",
    "axis": "\U000F0D48",
    "axis-arrow": "\U000F0D49",
    "axis-arrow-info": "\U000F140E",
    "axis-arrow-lock": "\U000F0D4A",
    "axis-lock": "\U000F0D4B",
    "axis-x-arrow": "\U000F0D4C",
    "axis-x-arrow-lock": "\U000F0D4D",
    "axis-x-rotate-clockwise": "\U000F0D4E",
    "axis-x-rotate-counterclockwise": "\U000F0D4F",
    "axis-x-y-arrow-lock": "\U000F0D50",
    "axis-y-arrow": "\U000F0D51",
    "axis-y-arrow-lock": "\U000F0D52",
    "axis-y-rotate-clockwise": "\U000F0D53",
    "axis-y-rotate-counterclockwise": "\U000F0D54",
    "axis-z-arrow": "\U000F0D55",
    "axis-z-arrow-lock": "\U000F0D56",
    "axis-z-rotate-clockwise": "\U000F0D57",
    "axis-z-rotate-counterclockwise": "\U000F0D58",
    "babel": "\U000F0A25",
    "baby": "\U000F006C",
    "baby-bottle": "\U000F0F39",
    "baby-bottle-outline": "\U000F0F3A",
    "baby-buggy": "\U000F13E0",
    "baby-buggy-off": "\U000F1AF3",
    "baby-carriage": "\U000F068F",
    "baby-carriage-off": "\U000F0FA0",
    "baby-face": "\U000F0E7C",
    "baby-face-outline": "\U000F0E7D",
    "backburger": "\U000F006D",
    "backspace": "\U000F006E",
    "backspace-outline": "\U000F0B5C",
    "backspace-reverse": "\U000F0E7E",
    "backspace-reverse-outline": "\U000F0E7F",
    "backup-restore": "\U000F006F",
    "bacteria": "\U000F0ED5",
    "bacteria-outline": "\U000F0ED6",
    "badge-account": "\U000F0DA7",
    "badge-account-alert": "\U000F0DA8",
    "badge-account-alert-outline": "\U000F0DA9",
    "badge-account-horizontal": "\U000F0E0D",
    "badge-account-horizontal-outline": "\U000F0E0E",
    "badge-account-outline": "\U000F0DAA",
    "badminton": "\U000F0851",
    "bag-carry-on": "\U000F0F3B",
    "bag-carry-on-check": "\U000F0D65",
    "bag-carry-on-off": "\U000F0F3C",
    "bag-checked": "\U000F0F3D",
    "bag-personal": "\U000F0E10",
    "bag-personal-off": "\U000F0E11",
    "bag-personal-off-outline": "\U000F0E12",
    "bag-personal-outline": "\U000F0E13",
    "bag-personal-tag": "\U000F1B0C",
    "bag-personal-tag-outline": "\U000F1B0D",
    "bag-suitcase": "\U000F158B",
    "bag-suitcase-off": "\U000F158D",
    "bag-suitcase-off-outline": "\U000F158E",
    "bag-suitcase-outline": "\U000F158C",
    "baguette": "\U000F0F3E",
    "balcony": "\U000F1817",
    "balloon": "\U000F0A26",
    "ballot": "\U000F09C9",
    "ballot-outline": "\U000F09CA",
    "ballot-recount": "\U000F0C39",
    "ballot-recount-outline": "\U000F0C3A",
    "bandage": "\U000F0DAF",
    "bank": "\U000F0070",
    "bank-check": "\U000F1655",
    "bank-minus": "\U000F0DB0",
    "bank-off": "\U000F1656",
    "bank-off-outline": "\U000F1657",
    "bank-outline": "\U000F0E80",
    "bank-plus": "\U000F0DB1",
    "bank-remove": "\U000F0DB2",
    "bank-transfer": "\U000F0A27",
    "bank-transfer-in": "\U000F0A28",
    "bank-transfer-out": "\U000F0A29",
    "barcode": "\U000F0071",
    "barcode-off": "\U000F1236",
    "barcode-scan": "\U000F0072",
    "barley": "\U000F0073",
    "barley-off": "\U000F0B5D",
    "barn": "\U000F0B5E",
    "barrel": "\U000F0074",
    "barrel-outline": "\U000F1A28",
    "baseball": "\U000F0852",
    "baseball-bat": "\U000F0853",
    "baseball-diamond": "\U000F15EC",
    "baseball-diamond-outline": "\U000F15ED",
    "bash": "\U000F1183",
    "basket": "\U000F0076",
    "basket-check": "\U000F18E5",
    "basket-check-outline": "\U000F18E6",
    "basket-fill": "\U000F0077",
    "basket-minus": "\U000F1523",
    "basket-minus-outline": "\U000F1524",
    "basket-off": "\U000F1525",
    "basket-off-outline": "\U000F1526",
    "basket-outline": "\U000F1181",
    "basket-plus": "\U000F1527",
    "basket-plus-outline": "\U000F1528",
    "basket-remove": "\U000F1529",
    "basket-remove-outline": "\U000F152A",
    "basket-unfill": "\U000F0078",
    "basketball": "\U000F0806",
    "basketball-hoop": "\U000F0C3B",
    "basketball-hoop-outline": "\U000F0C3C",
    "bat": "\U000F0B5F",
    "bathtub": "\U000F1818",
    "bathtub-outline": "\U000F1819",
    "battery": "\U000F0079",
    "battery-10": "\U000F007A",
    "battery-10-bluetooth": "\U000F093E",
    "battery-20": "\U000F007B",
    "battery-20-bluetooth": "\U000F093F",
    "battery-30": "\U000F007C",
    "battery-30-bluetooth": "\U000F0940",
    "battery-40": "\U000F007D",
    "battery-40-bluetooth": "\U000F0941",
    "battery-50": "\U000F007E",
    "battery-50-bluetooth": "\U000F0942",
    "battery-60": "\U000F007F",
    "battery-60-bluetooth": "\U000F0943",
    "battery-70": "\U000F0080",
    "battery-70-bluetooth": "\U000F0944",
    "battery-80": "\U000F0081",
    "battery-80-bluetooth": "\U000F0945",
    "battery-90": "\U000F0082",
    "battery-90-bluetooth": "\U000F0946",
    "battery-alert": "\U000F0083",
    "battery-alert-bluetooth": "\U000F0947",
    "battery-alert-variant": "\U000F10CC",
    "battery-alert-variant-outline": "\U000F10CD",
    "battery-arrow-down": "\U000F17DE",
    "battery-arrow-down-outline": "\U000F17DF",
    "battery-arrow-up": "\U000F17E0",
    "battery-arrow-up-outline": "\U000F17E1",
    "battery-bluetooth": "\U000F0948",
    "battery-bluetooth-variant": "\U000F0949",
    "battery-charging": "\U000F0084",
    "battery-charging-10": "\U000F089C",
    "battery-charging-100": "\U000F0085",
    "battery-charging-20": "\U000F0086",
    "battery-charging-30": "\U000F0087",
    "battery-charging-40": "\U000F0088",
    "battery-charging-50": "\U000F089D",
    "battery-charging-60": "\U000F0089",
    "battery-charging-70": "\U000F089E",
    "battery-charging-80": "\U000F008A",
    "battery-charging-90": "\U000F008B",
    "battery-charging-high": "\U000F12A6",
    "battery-charging-low": "\U000F12A4",
    "battery-charging-medium": "\U000F12A5",
    "battery-charging-outline": "\U000F089F",
    "battery-charging-wireless": "\U000F0807",
    "battery-charging-wireless-10": "\U000F0808",
    "battery-charging-wireless-20": "\U000F0809",
    "battery-charging-wireless-30": "\U000F080A",
    "battery-charging-wireless-40": "\U000F080B",
    "battery-charging-wireless-50": "\U000F080C",
    "battery-charging-wireless-60": "\U000F080D",
    "battery-charging-wireless-70": "\U000F080E",
    "battery-charging-wireless-80": "\U000F080F",
    "battery-charging-wireless-90": "\U000F0810",
    "battery-charging-wireless-alert": "\U000F0811",
    "battery-charging-wireless-outline": "\U000F0812",
    "battery-check": "\U000F17E2",
    "battery-check-outline": "\U000F17E3",
    "battery-clock": "\U000F19E5",
    "battery-clock-outline": "\U000F19E6",
    "battery-heart": "\U000F120F",
    "battery-heart-outline": "\U000F1210",
    "battery-heart-variant": "\U000F1211",
    "battery-high": "\U000F12A3",
    "battery-lock": "\U000F179C",
    "battery-lock-open": "\U000F179D",
    "battery-low": "\U000F12A1",
    "battery-medium": "\U000F12A2",
    "battery-minus": "\U000F17E4",
    "battery-minus-outline": "\U000F17E5",
    "battery-minus-variant": "\U000F008C",
    "battery-negative": "\U000F008D",
    "battery-off": "\U000F125D",
    "battery-off-outline": "\U000F125E",
    "battery-outline": "\U000F008E",
    "battery-plus": "\U000F17E6",
    "battery-plus-outline": "\U000F17E7",
    "battery-plus-variant": "\U000F008F",
    "battery-positive": "\U000F0090",
    "battery-remove": "\U000F17E8",
    "battery-remove-outline": "\U000F17E9",
    "battery-sync": "\U000F1834",
    "battery-sync-outline": "\U000F1835",
    "battery-unknown": "\U000F0091",
    "battery-unknown-bluetooth": "\U000F094A",
    "beach": "\U000F0092",
    "beaker": "\U000F0CEA",
    "beaker-alert": "\U000F1229",
    "beaker-alert-outline": "\U000F122A",
    "beaker-check": "\U000F122B",
    "beaker-check-outline": "\U000F122C",
    "beaker-minus": "\U000F122D",
    "beaker-minus-outline": "\U000F122E",
    "beaker-outline": "\U000F0690",
    "beaker-plus": "\U000F122F",
    "beaker-plus-outline": "\U000F1230",
    "beaker-question": "\U000F1231",
    "beaker-question-outline": "\U000F1232",
    "beaker-remove": "\U000F1233",
    "beaker-remove-outline": "\U000F1234",
    "bed": "\U000F02E3",
    "bed-double": "\U000F0FD4",
    "bed-double-outline": "\U000F0FD3",
    "bed-empty": "\U000F08A0",
    "bed-king": "\U000F0FD2",
    "bed-king-outline": "\U000F0FD1",
    "bed-outline": "\U000F0099",
    "bed-queen": "\U000F0FD0",
    "bed-queen-outline": "\U000F0FDB",
    "bed-single": "\U000F106D",
    "bed-single-outline": "\U000F106E",
    "bee": "\U000F0FA1",
    "bee-flower": "\U000F0FA2",
    "beehive-off-outline": "\U000F13ED",
    "beehive-outline": "\U000F10CE",
    "beekeeper": "\U000F14E2",
    "beer": "\U000F0098",
    "beer-outline": "\U000F130C",
    "bell": "\U000F009A",
    "bell-alert": "\U000F0D59",
    "bell-alert-outline": "\U000F0E81",
    "bell-badge": "\U000F116B",
    "bell-badge-outline": "\U000F0178",
    "bell-cancel": "\U000F13E7",
    "bell-cancel-outline": "\U000F13E8",
    "bell-check": "\U000F11E5",
    "bell-check-outline": "\U000F11E6",
    "bell-circle": "\U000F0D5A",
    "bell-circle-outline": "\U000F0D5B",
    "bell-cog": "\U000F1A29",
    "bell-cog-outline": "\U000F1A2A",
    "bell-minus": "\U000F13E9",
    "bell-minus-outline": "\U000F13EA",
    "bell-off": "\U000F009B",
    "bell-off-outline": "\U000F0A91",
    "bell-outline": "\U000F009C",
    "bell-plus": "\U000F009D",
    "bell-plus-outline": "\U000F0A92",
    "bell-remove": "\U000F13EB",
    "bell-remove-outline": "\U000F13EC",
    "bell-ring": "\U000F009E",
    "bell-ring-outline": "\U000F009F",
    "bell-sleep": "\U000F00A0",
    "bell-sleep-outline": "\U000F0A93",
    "beta": "\U000F00A1",
    "betamax": "\U000F09CB",
    "biathlon": "\U000F0E14",
    "bicycle": "\U000F109C",
    "bicycle-basket": "\U000F1235",
    "bicycle-cargo": "\U000F189C",
    "bicycle-electric": "\U000F15B4",
    "bicycle-penny-farthing": "\U000F15E9",
    "bike": "\U000F00A3",
    "bike-fast": "\U000F111F",
    "billboard": "\U000F1010",
    "billiards": "\U000F0B61",
    "billiards-rack": "\U000F0B62",
    "binoculars": "\U000F00A5",
    "bio": "\U000F00A6",
    "biohazard": "\U000F00A7",
    "bird": "\U000F15C6",
    "bitbucket": "\U000F00A8",
    "bitcoin": "\U000F0813",
    "black-mesa": "\U000F00A9",
    "blender": "\U000F0CEB",
    "blender-outline": "\U000F181A",
    "blender-software": "\U000F00AB",
    "blinds": "\U000F00AC",
    "blinds-horizontal": "\U000F1A2B",
    "blinds-horizontal-closed": "\U000F1A2C",
    "blinds-open": "\U000F1011",
    "blinds-vertical": "\U000F1A2D",
    "blinds-vertical-closed": "\U000F1A2E",
    "block-helper": "\U000F00AD",
    "blood-bag": "\U000F0CEC",
    "bluetooth": "\U000F00AF",
    "bluetooth-audio": "\U000F00B0",
    "bluetooth-connect": "\U000F00B1",
    "bluetooth-off": "\U000F00B2",
    "bluetooth-settings": "\U000F00B3",
    "bluetooth-transfer": "\U000F00B4",
    "blur": "\U000F00B5",
    "blur-linear": "\U000F00B6",
    "blur-off": "\U000F00B7",
    "blur-radial": "\U000F00B8",
    "bolt": "\U000F0DB3",
    "bomb": "\U000F0691",
    "bomb-off": "\U000F06C5",
    "bone": "\U000F00B9",
    "bone-off": "\U000F19E0",
    "book": "\U000F00BA",
    "book-account": "\U000F13AD",
    "book-account-outline": "\U000F13AE",
    "book-alert": "\U000F167C",
    "book-alert-outline": "\U000F167D",
    "book-alphabet": "\U000F061D",
    "book-arrow-down": "\U000F167E",
    "book-arrow-down-outline": "\U000F167F",
    "book-arrow-left": "\U000F1680",
    "book-arrow-left-outline": "\U000F1681",
    "book-arrow-right": "\U000F1682",
    "book-arrow-right-outline": "\U000F1683",
    "book-arrow-up": "\U000F1684",
    "book-arrow-up-outline": "\U000F1685",
    "book-cancel": "\U000F1686",
    "book-cancel-outline": "\U000F1687",
    "book-check": "\U000F14F3",
    "book-check-outline": "\U000F14F4",
    "book-clock": "\U000F1688",
    "book-clock-outline": "\U000F1689",
    "book-cog": "\U000F168A",
    "book-cog-outline": "\U000F168B",
    "book-cross": "\U000F00A2",
    "book-edit": "\U000F168C",
    "book-edit-outline": "\U000F168D",
    "book-education": "\U000F16C9",
    "book-education-outline": "\U000F16CA",
    "book-heart": "\U000F1A1D",
    "book-heart-outline": "\U000F1A1E",
    "book-information-variant": "\U000F106F",
    "book-lock": "\U000F079A",
    "book-lock-open": "\U000F079B",
    "book-lock-open-outline": "\U000F168E",
    "book-lock-outline": "\U000F168F",
    "book-marker": "\U000F1690",
    "book-marker-outline": "\U000F1691",
    "book-minus": "\U000F05D9",
    "book-minus-multiple": "\U000F0A94",
    "book-minus-multiple-outline": "\U000F090B",
    "book-minus-outline": "\U000F1692",
    "book-multiple": "\U000F00BB",
    "book-multiple-outline": "\U000F0436",
    "book-music": "\U000F0067",
    "book-music-outline": "\U000F1693",
    "book-off": "\U000F1694",
    "book-off-outline": "\U000F1695",
    "book-open": "\U000F00BD",
    "book-open-blank-variant": "\U000F00BE",
    "book-open-outline": "\U000F0B63",
    "book-open-page-variant": "\U000F05DA",
    "book-open-page-variant-outline": "\U000F15D6",
    "book-open-variant": "\U000F14F7",
    "book-outline": "\U000F0B64",
    "book-play": "\U000F0E82",
    "book-play-outline": "\U000F0E83",
    "book-plus": "\U000F05DB",
    "book-plus-multiple": "\U000F0A95",
    "book-plus-multiple-outline": "\U000F0ADE",
    "book-plus-outline": "\U000F1696",
    "book-refresh": "\U000F1697",
    "book-refresh-outline": "\U000F1698",
    "book-remove": "\U000F0A97",
    "book-remove-multiple": "\U000F0A96",
    "book-remove-multiple-outline": "\U000F04CA",
    "book-remove-outline": "\U000F1699",
    "book-search": "\U000F0E84",
    "book-search-outline": "\U000F0E85",
    "book-settings": "\U000F169A",
    "book-settings-outline": "\U000F169B",
    "book-sync": "\U000F169C",
    "book-sync-outline": "\U000F16C8",
    "book-variant": "\U000F00BF",
    "book-variant-multiple": "\U000F00BC",
    "bookmark": "\U000F00C0",
    "bookmark-box-multiple": "\U000F196C",
    "bookmark-box-multiple-outline": "\U000F196D",
    "bookmark-check": "\U000F00C1",
    "bookmark-check-outline": "\U000F137B",
    "bookmark-minus": "\U000F09CC",
    "bookmark-minus-outline": "\U000F09CD",
    "bookmark-multiple": "\U000F0E15",
    "bookmark-multiple-outline": "\U000F0E16",
    "bookmark-music": "\U000F00C2",
    "bookmark-music-outline": "\U000F1379",
    "bookmark-off": "\U000F09CE",
    "bookmark-off-outline": "\U000F09CF",
    "bookmark-outline": "\U000F00C3",
    "bookmark-plus": "\U000F00C5",
    "bookmark-plus-outline": "\U000F00C4",
    "bookmark-remove": "\U000F00C6",
    "bookmark-remove-outline": "\U000F137A",
    "bookshelf": "\U000F125F",
    "boom-gate": "\U000F0E86",
    "boom-gate-alert": "\U000F0E87",
    "boom-gate-alert-outline": "\U000F0E88",
    "boom-gate-arrow-down": "\U000F0E89",
    "boom-gate-arrow-down-outline": "\U000F0E8A",
    "boom-gate-arrow-up": "\U000F0E8C",
    "boom-gate-arrow-up-outline": "\U000F0E8D",
    "boom-gate-outline": "\U000F0E8B",
    "boom-gate-up": "\U000F17F9",
    "boom-gate-up-outline": "\U000F17FA",
    "boombox": "\U000F05DC",
    "boomerang": "\U000F10CF",
    "bootstrap": "\U000F06C6",
    "border-all": "\U000F00C7",
    "border-all-variant": "\U000F08A1",
    "border-bottom": "\U000F00C8",
    "border-bottom-variant": "\U000F08A2",
    "border-color": "\U000F00C9",
    "border-horizontal": "\U000F00CA",
    "border-inside": "\U000F00CB",
    "border-left": "\U000F00CC",
    "border-left-variant": "\U000F08A3",
    "border-none": "\U000F00CD",
    "border-none-variant": "\U000F08A4",
    "border-outside": "\U000F00CE",
    "border-radius": "\U000F1AF4",
    "border-right": "\U000F00CF",
    "border-right-variant": "\U000F08A5",
    "border-style": "\U000F00D0",
    "border-top": "\U000F00D1",
    "border-top-variant": "\U000F08A6",
    "border-vertical": "\U000F00D2",
    "bottle-soda": "\U000F1070",
    "bottle-soda-classic": "\U000F1071",
    "bottle-soda-classic-outline": "\U000F1363",
    "bottle-soda-outline": "\U000F1072",
    "bottle-tonic": "\U000F112E",
    "bottle-tonic-outline": "\U000F112F",
    "bottle-tonic-plus": "\U000F1130",
    "bottle-tonic-plus-outline": "\U000F1131",
    "bottle-tonic-skull": "\U000F1132",
    "bottle-tonic-skull-outline": "\U000F1133",
    "bottle-wine": "\U000F0854",
    "bottle-wine-outline": "\U000F1310",
    "bow-arrow": "\U000F1841",
    "bow-tie": "\U000F0678",
    "bowl": "\U000F028E",
    "bowl-mix": "\U000F0617",
    "bowl-mix-outline": "\U000F02E4",
    "bowl-outline": "\U000F02A9",
    "bowling": "\U000F00D3",
    "box": "\U000F00D4",
    "box-cutter": "\U000F00D5",
    "box-cutter-off": "\U000F0B4A",
    "box-shadow": "\U000F0637",
    "boxing-glove": "\U000F0B65",
    "braille": "\U000F09D0",
    "brain": "\U000F09D1",
    "bread-slice": "\U000F0CEE",
    "bread-slice-outline": "\U000F0CEF",
    "bridge": "\U000F0618",
    "briefcase": "\U000F00D6",
    "briefcase-account": "\U000F0CF0",
    "briefcase-account-outline": "\U000F0CF1",
    "briefcase-arrow-left-right": "\U000F1A8D",
    "briefcase-arrow-left-right-outline": "\U000F1A8E",
    "briefcase-arrow-up-down": "\U000F1A8F",
    "briefcase-arrow-up-down-outline": "\U000F1A90",
    "briefcase-check": "\U000F00D7",
    "briefcase-check-outline": "\U000F131E",
    "briefcase-clock": "\U000F10D0",
    "briefcase-clock-outline": "\U000F10D1",
    "briefcase-download": "\U000F00D8",
    "briefcase-download-outline": "\U000F0C3D",
    "briefcase-edit": "\U000F0A98",
    "briefcase-edit-outline": "\U000F0C3E",
    "briefcase-eye": "\U000F17D9",
    "briefcase-eye-outline": "\U000F17DA",
    "briefcase-minus": "\U000F0A2A",
    "briefcase-minus-outline": "\U000F0C3F",
    "briefcase-off": "\U000F1658",
    "briefcase-off-outline": "\U000F1659",
    "briefcase-outline": "\U000F0814",
    "briefcase-plus": "\U000F0A2B",
    "briefcase-plus-outline": "\U000F0C40",
    "briefcase-remove": "\U000F0A2C",
    "briefcase-remove-outline": "\U000F0C41",
    "briefcase-search": "\U000F0A2D",
    "briefcase-search-outline": "\U000F0C42",
    "briefcase-upload": "\U000F00D9",
    "briefcase-upload-outline": "\U000F0C43",
    "briefcase-variant": "\U000F1494",
    "briefcase-variant-off": "\U000F165A",
    "briefcase-variant-off-outline": "\U000F165B",
    "briefcase-variant-outline": "\U000F1495",
    "brightness-1": "\U000F00DA",
    "brightness-2": "\U000F00DB",
    "brightness-3": "\U000F00DC",
    "brightness-4": "\U000F00DD",
    "brightness-5": "\U000F00DE",
    "brightness-6": "\U000F00DF",
    "brightness-7": "\U000F00E0",
    "brightness-auto": "\U000F00E1",
    "brightness-percent": "\U000F0CF2",
    "broadcast": "\U000F1720",
    "broadcast-off": "\U000F1721",
    "broom": "\U000F00E2",
    "brush": "\U000F00E3",
    "brush-off": "\U000F1771",
    "brush-outline": "\U000F1A0D",
    "brush-variant": "\U000F1813",
    "bucket": "\U000F1415",
    "bucket-outline": "\U000F1416",
    "buffet": "\U000F0578",
    "bug": "\U000F00E4",
    "bug-check": "\U000F0A2E",
    "bug-check-outline": "\U000F0A2F",
    "bug-outline": "\U000F0A30",
    "bug-pause": "\U000F1AF5",
    "bug-pause-outline": "\U000F1AF6",
    "bug-play": "\U000F1AF7",
    "bug-play-outline": "\U000F1AF8",
    "bug-stop": "\U000F1AF9",
    "bug-stop-outline": "\U000F1AFA",
    "bugle": "\U000F0DB4",
    "bulkhead-light": "\U000F1A2F",
    "bulldozer": "\U000F0B22",
    "bullet": "\U000F0CF3",
    "bulletin-board": "\U000F00E5",
    "bullhorn": "\U000F00E6",
    "bullhorn-outline": "\U000F0B23",
    "bullhorn-variant": "\U000F196E",
    "bullhorn-variant-outline": "\U000F196F",
    "bullseye": "\U000F05DD",
    "bullseye-arrow": "\U000F08C9",
    "bulma": "\U000F12E7",
    "bunk-bed": "\U000F1302",
    "bunk-bed-outline": "\U000F0097",
    "bus": "\U000F00E7",
    "bus-alert": "\U000F0A99",
    "bus-articulated-end": "\U000F079C",
    "bus-articulated-front": "\U000F079D",
    "bus-clock": "\U000F08CA",
    "bus-double-decker": "\U000F079E",
    "bus-electric": "\U000F191D",
    "bus-marker": "\U000F1212",
    "bus-multiple": "\U000F0F3F",
    "bus-school": "\U000F079F",
    "bus-side": "\U000F07A0",
    "bus-stop": "\U000F1012",
    "bus-stop-covered": "\U000F1013",
    "bus-stop-uncovered": "\U000F1014",
    "butterfly": "\U000F1589",
    "butterfly-outline": "\U000F158A",
    "button-cursor": "\U000F1B4F",
    "button-pointer": "\U000F1B50",
    "cabin-a-frame": "\U000F188C",
    "cable-data": "\U000F1394",
    "cached": "\U000F00E8",
    "cactus": "\U000F0DB5",
    "cake": "\U000F00E9",
    "cake-layered": "\U000F00EA",
    "cake-variant": "\U000F00EB",
    "cake-variant-outline": "\U000F17F0",
    "calculator": "\U000F00EC",
    "calculator-variant": "\U000F0A9A",
    "calculator-variant-outline": "\U000F15A6",
    "calendar": "\U000F00ED",
    "calendar-account": "\U000F0ED7",
    "calendar-account-outline": "\U000F0ED8",
    "calendar-alert": "\U000F0A31",
    "calendar-arrow-left": "\U000F1134",
    "calendar-arrow-right": "\U000F1135",
    "calendar-blank": "\U000F00EE",
    "calendar-blank-multiple": "\U000F1073",
    "calendar-blank-outline": "\U000F0B66",
    "calendar-check": "\U000F00EF",
    "calendar-check-outline": "\U000F0C44",
    "calendar-clock": "\U000F00F0",
    "calendar-clock-outline": "\U000F16E1",
    "calendar-collapse-horizontal": "\U000F189D",
    "calendar-cursor": "\U000F157B",
    "calendar-edit": "\U000F08A7",
    "calendar-end": "\U000F166C",
    "calendar-expand-horizontal": "\U000F189E",
    "calendar-export": "\U000F0B24",
    "calendar-filter": "\U000F1A32",
    "calendar-filter-outline": "\U000F1A33",
    "calendar-heart": "\U000F09D2",
    "calendar-import": "\U000F0B25",
    "calendar-lock": "\U000F1641",
    "calendar-lock-outline": "\U000F1642",
    "calendar-minus": "\U000F0D5C",
    "calendar-month": "\U000F0E17",
    "calendar-month-outline": "\U000F0E18",
    "calendar-multiple": "\U000F00F1",
    "calendar-multiple-check": "\U000F00F2",
    "calendar-multiselect": "\U000F0A32",
    "calendar-outline": "\U000F0B67",
    "calendar-plus": "\U000F00F3",
    "calendar-question": "\U000F0692",
    "calendar-range": "\U000F0679",
    "calendar-range-outline": "\U000F0B68",
    "calendar-refresh": "\U000F01E1",
    "calendar-refresh-outline": "\U000F0203",
    "calendar-remove": "\U000F00F4",
    "calendar-remove-outline": "\U000F0C45",
    "calendar-search": "\U000F094C",
    "calendar-star": "\U000F09D3",
    "calendar-star-outline": "\U000F1B53",
    "calendar-start": "\U000F166D",
    "calendar-sync": "\U000F0E8E",
    "calendar-sync-outline": "\U000F0E8F",
    "calendar-text": "\U000F00F5",
    "calendar-text-outline": "\U000F0C46",
    "calendar-today": "\U000F00F6",
    "calendar-today-outline": "\U000F1A30",
    "calendar-week": "\U000F0A33",
    "calendar-week-begin": "\U000F0A34",
    "calendar-week-begin-outline": "\U000F1A31",
    "calendar-week-outline": "\U000F1A34",
    "calendar-weekend": "\U000F0ED9",
    "calendar-weekend-outline": "\U000F0EDA",
    "call-made": "\U000F00F7",
    "call-merge": "\U000F00F8",
    "call-missed": "\U000F00F9",
    "call-received": "\U000F00FA",
    "call-split": "\U000F00FB",
    "camcorder": "\U000F00FC",
    "camcorder-off": "\U000F00FF",
    "camera": "\U000F0100",
    "camera-account": "\U000F08CB",
    "camera-burst": "\U000F0693",
    "camera-control": "\U000F0B69",
    "camera-document": "\U000F1871",
    "camera-document-off": "\U000F1872",
    "camera-enhance": "\U000F0101",
    "camera-enhance-outline": "\U000F0B6A",
    "camera-flip": "\U000F15D9",
    "camera-flip-outline": "\U000F15DA",
    "camera-front": "\U000F0102",
    "camera-front-variant": "\U000F0103",
    "camera-gopro": "\U000F07A1",
    "camera-image": "\U000F08CC",
    "camera-iris": "\U000F0104",
    "camera-lock": "\U000F1A14",
    "camera-lock-outline": "\U000F1A15",
    "camera-marker": "\U000F19A7",
    "camera-marker-outline": "\U000F19A8",
    "camera-metering-center": "\U000F07A2",
    "camera-metering-matrix": "\U000F07A3",
    "camera-metering-partial": "\U000F07A4",
    "camera-metering-spot": "\U000F07A5",
    "camera-off": "\U000F05DF",
    "camera-off-outline": "\U000F19BF",
    "camera-outline": "\U000F0D5D",
    "camera-party-mode": "\U000F0105",
    "camera-plus": "\U000F0EDB",
    "camera-plus-outline": "\U000F0EDC",
    "camera-rear": "\U000F0106",
    "camera-rear-variant": "\U000F0107",
    "camera-retake": "\U000F0E19",
    "camera-retake-outline": "\U000F0E1A",
    "camera-switch": "\U000F0108",
    "camera-switch-outline": "\U000F084A",
    "camera-timer": "\U000F0109",
    "camera-wireless": "\U000F0DB6",
    "camera-wireless-outline": "\U000F0DB7",
    "campfire": "\U000F0EDD",
    "cancel": "\U000F073A",
    "candelabra": "\U000F17D2",
    "candelabra-fire": "\U000F17D3",
    "candle": "\U000F05E2",
    "candy": "\U000F1970",
    "candy-off": "\U000F1971",
    "candy-off-outline": "\U000F1972",
    "candy-outline": "\U000F1973",
    "candycane": "\U000F010A",
    "cannabis": "\U000F07A6",
    "cannabis-off": "\U000F166E",
    "caps-lock": "\U000F0A9B",
    "car": "\U000F010B",
    "car-2-plus": "\U000F1015",
    "car-3-plus": "\U000F1016",
    "car-arrow-left": "\U000F13B2",
    "car-arrow-right": "\U000F13B3",
    "car-back": "\U000F0E1B",
    "car-battery": "\U000F010C",
    "car-brake-abs": "\U000F0C47",
    "car-brake-alert": "\U000F0C48",
    "car-brake-fluid-level": "\U000F1909",
    "car-brake-hold": "\U000F0D5E",
    "car-brake-low-pressure": "\U000F190A",
    "car-brake-parking": "\U000F0D5F",
    "car-brake-retarder": "\U000F1017",
    "car-brake-temperature": "\U000F190B",
    "car-brake-worn-linings": "\U000F190C",
    "car-child-seat": "\U000F0FA3",
    "car-clock": "\U000F1974",
    "car-clutch": "\U000F1018",
    "car-cog": "\U000F13CC",
    "car-connected": "\U000F010D",
    "car-convertible": "\U000F07A7",
    "car-coolant-level": "\U000F1019",
    "car-cruise-control": "\U000F0D60",
    "car-defrost-front": "\U000F0D61",
    "car-defrost-rear": "\U000F0D62",
    "car-door": "\U000F0B6B",
    "car-door-lock": "\U000F109D",
    "car-electric": "\U000F0B6C",
    "car-electric-outline": "\U000F15B5",
    "car-emergency": "\U000F160F",
    "car-esp": "\U000F0C49",
    "car-estate": "\U000F07A8",
    "car-hatchback": "\U000F07A9",
    "car-info": "\U000F11BE",
    "car-key": "\U000F0B6D",
    "car-lifted-pickup": "\U000F152D",
    "car-light-alert": "\U000F190D",
    "car-light-dimmed": "\U000F0C4A",
    "car-light-fog": "\U000F0C4B",
    "car-light-high": "\U000F0C4C",
    "car-limousine": "\U000F08CD",
    "car-multiple": "\U000F0B6E",
    "car-off": "\U000F0E1C",
    "car-outline": "\U000F14ED",
    "car-parking-lights": "\U000F0D63",
    "car-pickup": "\U000F07AA",
    "car-seat": "\U000F0FA4",
    "car-seat-cooler": "\U000F0FA5",
    "car-seat-heater": "\U000F0FA6",
    "car-select": "\U000F1879",
    "car-settings": "\U000F13CD",
    "car-shift-pattern": "\U000F0F40",
    "car-side": "\U000F07AB",
    "car-speed-limiter": "\U000F190E",
    "car-sports": "\U000F07AC",
    "car-tire-alert": "\U000F0C4D",
    "car-traction-control": "\U000F0D64",
    "car-turbocharger": "\U000F101A",
    "car-wash": "\U000F010E",
    "car-windshield": "\U000F101B",
    "car-windshield-outline": "\U000F101C",
    "car-wireless": "\U000F1878",
    "car-wrench": "\U000F1814",
    "carabiner": "\U000F14C0",
    "caravan": "\U000F07AD",
    "card": "\U000F0B6F",
    "card-account-details": "\U000F05D2",
    "card-account-details-outline": "\U000F0DAB",
    "card-account-details-star": "\U000F02A3",
    "card-account-details-star-outline": "\U000F06DB",
    "card-account-mail": "\U000F018E",
    "card-account-mail-outline": "\U000F0E98",
    "card-account-phone": "\U000F0E99",
    "card-account-phone-outline": "\U000F0E9A",
    "card-bulleted": "\U000F0B70",
    "card-bulleted-off": "\U000F0B71",
    "card-bulleted-off-outline": "\U000F0B72",
    "card-bulleted-outline": "\U000F0B73",
    "card-bulleted-settings": "\U000F0B74",
    "card-bulleted-settings-outline": "\U000F0B75",
    "card-minus": "\U000F1600",
    "card-minus-outline": "\U000F1601",
    "card-multiple": "\U000F17F1",
    "card-multiple-outline": "\U000F17F2",
    "card-off": "\U000F1602",
    "card-off-outline": "\U000F1603",
    "card-outline": "\U000F0B76",
    "card-plus": "\U000F11FF",
    "card-plus-outline": "\U000F1200",
    "card-remove": "\U000F1604",
    "card-remove-outline": "\U000F1605",
    "card-search": "\U000F1074",
    "card-search-outline": "\U000F1075",
    "card-text": "\U000F0B77",
    "card-text-outline": "\U000F0B78",
    "cards": "\U000F0638",
    "cards-club": "\U000F08CE",
    "cards-club-outline": "\U000F189F",
    "cards-diamond": "\U000F08CF",
    "cards-diamond-outline": "\U000F101D",
    "cards-heart": "\U000F08D0",
    "cards-heart-outline": "\U000F18A0",
    "cards-outline": "\U000F0639",
    "cards-playing": "\U000F18A1",
    "cards-playing-club": "\U000F18A2",
    "cards-playing-club-multiple": "\U000F18A3",
    "cards-playing-club-multiple-outline": "\U000F18A4",
    "cards-playing-club-outline": "\U000F18A5",
    "cards-playing-diamond": "\U000F18A6",
    "cards-playing-diamond-multiple": "\U000F18A7",
    "cards-playing-diamond-multiple-outline": "\U000F18A8",
    "cards-playing-diamond-outline": "\U000F18A9",
    "cards-playing-heart": "\U000F18AA",
    "cards-playing-heart-multiple": "\U000F18AB",
    "cards-playing-heart-multiple-outline": "\U000F18AC",
    "cards-playing-heart-outline": "\U000F18AD",
    "cards-playing-outline": "\U000F063A",
    "cards-playing-spade": "\U000F18AE",
    "cards-playing-spade-multiple": "\U000F18AF",
    "cards-playing-spade-multiple-outline": "\U000F18B0",
    "cards-playing-spade-outline": "\U000F18B1",
    "cards-spade": "\U000F08D1",
    "cards-spade-outline": "\U000F18B2",
    "cards-variant": "\U000F06C7",
    "carrot": "\U000F010F",
    "cart": "\U000F0110",
    "cart-arrow-down": "\U000F0D66",
    "cart-arrow-right": "\U000F0C4E",
    "cart-arrow-up": "\U000F0D67",
    "cart-check": "\U000F15EA",
    "cart-heart": "\U000F18E0",
    "cart-minus": "\U000F0D68",
    "cart-off": "\U000F066B",
    "cart-outline": "\U000F0111",
    "cart-plus": "\U000F0112",
    "cart-remove": "\U000F0D69",
    "cart-variant": "\U000F15EB",
    "case-sensitive-alt": "\U000F0113",
    "cash": "\U000F0114",
    "cash-100": "\U000F0115",
    "cash-check": "\U000F14EE",
    "cash-clock": "\U000F1A91",
    "cash-fast": "\U000F185C",
    "cash-lock": "\U000F14EA",
    "cash-lock-open": "\U000F14EB",
    "cash-marker": "\U000F0DB8",
    "cash-minus": "\U000F1260",
    "cash-multiple": "\U000F0116",
    "cash-plus": "\U000F1261",
    "cash-refund": "\U000F0A9C",
    "cash-register": "\U000F0CF4",
    "cash-remove": "\U000F1262",
    "cash-sync": "\U000F1A92",
    "cassette": "\U000F09D4",
    "cast": "\U000F0118",
    "cast-audio": "\U000F101E",
    "cast-audio-variant": "\U000F1749",
    "cast-connected": "\U000F0119",
    "cast-education": "\U000F0E1D",
    "cast-off": "\U000F078A",
    "cast-variant": "\U000F001F",
    "castle": "\U000F011A",
    "cat": "\U000F011B",
    "cctv": "\U000F07AE",
    "cctv-off": "\U000F185F",
    "ceiling-fan": "\U000F1797",
    "ceiling-fan-light": "\U000F1798",
    "ceiling-light": "\U000F0769",
    "ceiling-light-multiple": "\U000F18DD",
    "ceiling-light-multiple-outline": "\U000F18DE",
    "ceiling-light-outline": "\U000F17C7",
    "cellphone": "\U000F011C",
    "cellphone-arrow-down": "\U000F09D5",
    "cellphone-arrow-down-variant": "\U000F19C5",
    "cellphone-basic": "\U000F011E",
    "cellphone-charging": "\U000F1397",
    "cellphone-check": "\U000F17FD",
    "cellphone-cog": "\U000F0951",
    "cellphone-dock": "\U000F011F",
    "cellphone-information": "\U000F0F41",
    "cellphone-key": "\U000F094E",
    "cellphone-link": "\U000F0121",
    "cellphone-link-off": "\U000F0122",
    "cellphone-lock": "\U000F094F",
    "cellphone-marker": "\U000F183A",
    "cellphone-message": "\U000F08D3",
    "cellphone-message-off": "\U000F10D2",
    "cellphone-nfc": "\U000F0E90",
    "cellphone-nfc-off": "\U000F12D8",
    "cellphone-off": "\U000F0950",
    "cellphone-play": "\U000F101F",
    "cellphone-remove": "\U000F094D",
    "cellphone-screenshot": "\U000F0A35",
    "cellphone-settings": "\U000F0123",
    "cellphone-sound": "\U000F0952",
    "cellphone-text": "\U000F08D2",
    "cellphone-wireless": "\U000F0815",
    "centos": "\U000F111A",
    "certificate": "\U000F0124",
    "certificate-outline": "\U000F1188",
    "chair-rolling": "\U000F0F48",
    "chair-school": "\U000F0125",
    "chandelier": "\U000F1793",
    "charity": "\U000F0C4F",
    "chart-arc": "\U000F0126",
    "chart-areaspline": "\U000F0127",
    "chart-areaspline-variant": "\U000F0E91",
    "chart-bar": "\U000F0128",
    "chart-bar-stacked": "\U000F076A",
    "chart-bell-curve": "\U000F0C50",
    "chart-bell-curve-cumulative": "\U000F0FA7",
    "chart-box": "\U000F154D",
    "chart-box-outline": "\U000F154E",
    "chart-box-plus-outline": "\U000F154F",
    "chart-bubble": "\U000F05E3",
    "chart-donut": "\U000F07AF",
    "chart-donut-variant": "\U000F07B0",
    "chart-gantt": "\U000F066C",
    "chart-histogram": "\U000F0129",
    "chart-line": "\U000F012A",
    "chart-line-stacked": "\U000F076B",
    "chart-line-variant": "\U000F07B1",
    "chart-multiline": "\U000F08D4",
    "chart-multiple": "\U000F1213",
    "chart-pie": "\U000F012B",
    "chart-ppf": "\U000F1380",
    "chart-sankey": "\U000F11DF",
    "chart-sankey-variant": "\U000F11E0",
    "chart-scatter-plot": "\U000F0E92",
    "chart-scatter-plot-hexbin": "\U000F066D",
    "chart-timeline": "\U000F066E",
    "chart-timeline-variant": "\U000F0E93",
    "chart-timeline-variant-shimmer": "\U000F15B6",
    "chart-tree": "\U000F0E94",
    "chart-waterfall": "\U000F1918",
    "chat": "\U000F0B79",
    "chat-alert": "\U000F0B7A",
    "chat-alert-outline": "\U000F12C9",
    "chat-minus": "\U000F1410",
    "chat-minus-outline": "\U000F1413",
    "chat-outline": "\U000F0EDE",
    "chat-plus": "\U000F140F",
    "chat-plus-outline": "\U000F1412",
    "chat-processing": "\U000F0B7B",
    "chat-processing-outline": "\U000F12CA",
    "chat-question": "\U000F1738",
    "chat-question-outline": "\U000F1739",
    "chat-remove": "\U000F1411",
    "chat-remove-outline": "\U000F1414",
    "chat-sleep": "\U000F12D1",
    "chat-sleep-outline": "\U000F12D2",
    "check": "\U000F012C",
    "check-all": "\U000F012D",
    "check-bold": "\U000F0E1E",
    "check-circle": "\U000F05E0",
    "check-circle-outline": "\U000F05E1",
    "check-decagram": "\U000F0791",
    "check-decagram-outline": "\U000F1740",
    "check-network": "\U000F0C53",
    "check-network-outline": "\U000F0C54",
    "check-outline": "\U000F0855",
    "check-underline": "\U000F0E1F",
    "check-underline-circle": "\U000F0E20",
    "check-underline-circle-outline": "\U000F0E21",
    "checkbook": "\U000F0A9D",
    "checkbox-blank": "\U000F012E",
    "checkbox-blank-badge": "\U000F1176",
    "checkbox-blank-badge-outline": "\U000F0117",
    "checkbox-blank-circle": "\U000F012F",
    "checkbox-blank-circle-outline": "\U000F0130",
    "checkbox-blank-off": "\U000F12EC",
    "checkbox-blank-off-outline": "\U000F12ED",
    "checkbox-blank-outline": "\U000F0131",
    "checkbox-intermediate": "\U000F0856",
    "checkbox-intermediate-variant": "\U000F1B54",
    "checkbox-marked": "\U000F0132",
    "checkbox-marked-circle": "\U000F0133",
    "checkbox-marked-circle-outline": "\U000F0134",
    "checkbox-marked-circle-plus-outline": "\U000F1927",
    "checkbox-marked-outline": "\U000F0135",
    "checkbox-multiple-blank": "\U000F0136",
    "checkbox-multiple-blank-circle": "\U000F063B",
    "checkbox-multiple-blank-circle-outline": "\U000F063C",
    "checkbox-multiple-blank-outline": "\U000F0137",
    "checkbox-multiple-marked": "\U000F0138",
    "checkbox-multiple-marked-circle": "\U000F063D",
    "checkbox-multiple-marked-circle-outline": "\U000F063E",
    "checkbox-multiple-marked-outline": "\U000F0139",
    "checkbox-multiple-outline": "\U000F0C51",
    "checkbox-outline": "\U000F0C52",
    "checkerboard": "\U000F013A",
    "checkerboard-minus": "\U000F1202",
    "checkerboard-plus": "\U000F1201",
    "checkerboard-remove": "\U000F1203",
    "cheese": "\U000F12B9",
    "cheese-off": "\U000F13EE",
    "chef-hat": "\U000F0B7C",
    "chemical-weapon": "\U000F013B",
    "chess-bishop": "\U000F085C",
    "chess-king": "\U000F0857",
    "chess-knight": "\U000F0858",
    "chess-pawn": "\U000F0859",
    "chess-queen": "\U000F085A",
    "chess-rook": "\U000F085B",
    "chevron-double-down": "\U000F013C",
    "chevron-double-left": "\U000F013D",
    "chevron-double-right": "\U000F013E",
    "chevron-double-up": "\U000F013F",
    "chevron-down": "\U000F0140",
    "chevron-down-box": "\U000F09D6",
    "chevron-down-box-outline": "\U000F09D7",
    "chevron-down-circle": "\U000F0B26",
    "chevron-down-circle-outline": "\U000F0B27",
    "chevron-left": "\U000F0141",
    "chevron-left-box": "\U000F09D8",
    "chevron-left-box-outline": "\U000F09D9",
    "chevron-left-circle": "\U000F0B28",
    "chevron-left-circle-outline": "\U000F0B29",
    "chevron-right": "\U000F0142",
    "chevron-right-box": "\U000F09DA",
    "chevron-right-box-outline": "\U000F09DB",
    "chevron-right-circle": "\U000F0B2A",
    "chevron-right-circle-outline": "\U000F0B2B",
    "chevron-triple-down": "\U000F0DB9",
    "chevron-triple-left": "\U000F0DBA",
    "chevron-triple-right": "\U000F0DBB",
    "chevron-triple-up": "\U000F0DBC",
    "chevron-up": "\U000F0143",
    "chevron-up-box": "\U000F09DC",
    "chevron-up-box-outline": "\U000F09DD",
    "chevron-up-circle": "\U000F0B2C",
    "chevron-up-circle-outline": "\U000F0B2D",
    "chili-alert": "\U000F17EA",
    "chili-alert-outline": "\U000F17EB",
    "chili-hot": "\U000F07B2",
    "chili-hot-outline": "\U000F17EC",
    "chili-medium": "\U000F07B3",
    "chili-medium-outline": "\U000F17ED",
    "chili-mild": "\U000F07B4",
    "chili-mild-outline": "\U000F17EE",
    "chili-off": "\U000F1467",
    "chili-off-outline": "\U000F17EF",
    "chip": "\U000F061A",
    "church": "\U000F0144",
    "church-outline": "\U000F1B02",
    "cigar": "\U000F1189",
    "cigar-off": "\U000F141B",
    "circle": "\U000F0765",
    "circle-box": "\U000F15DC",
    "circle-box-outline": "\U000F15DD",
    "circle-double": "\U000F0E95",
    "circle-edit-outline": "\U000F08D5",
    "circle-expand": "\U000F0E96",
    "circle-half": "\U000F1395",
    "circle-half-full": "\U000F1396",
    "circle-medium": "\U000F09DE",
    "circle-multiple": "\U000F0B38",
    "circle-multiple-outline": "\U000F0695",
    "circle-off-outline": "\U000F10D3",
    "circle-opacity": "\U000F1853",
    "circle-outline": "\U000F0766",
    "circle-slice-1": "\U000F0A9E",
    "circle-slice-2": "\U000F0A9F",
    "circle-slice-3": "\U000F0AA0",
    "circle-slice-4": "\U000F0AA1",
    "circle-slice-5": "\U000F0AA2",
    "circle-slice-6": "\U000F0AA3",
    "circle-slice-7": "\U000F0AA4",
    "circle-slice-8": "\U000F0AA5",
    "circle-small": "\U000F09DF",
    "circular-saw": "\U000F0E22",
    "city": "\U000F0146",
    "city-variant": "\U000F0A36",
    "city-variant-outline": "\U000F0A37",
    "clipboard": "\U000F0147",
    "clipboard-account": "\U000F0148",
    "clipboard-account-outline": "\U000F0C55",
    "clipboard-alert": "\U000F0149",
    "clipboard-alert-outline": "\U000F0CF7",
    "clipboard-arrow-down": "\U000F014A",
    "clipboard-arrow-down-outline": "\U000F0C56",
    "clipboard-arrow-left": "\U000F014B",
    "clipboard-arrow-left-outline": "\U000F0CF8",
    "clipboard-arrow-right": "\U000F0CF9",
    "clipboard-arrow-right-outline": "\U000F0CFA",
    "clipboard-arrow-up": "\U000F0C57",
    "clipboard-arrow-up-outline": "\U000F0C58",
    "clipboard-check": "\U000F014E",
    "clipboard-check-multiple": "\U000F1263",
    "clipboard-check-multiple-outline": "\U000F1264",
    "clipboard-check-outline": "\U000F08A8",
    "clipboard-clock": "\U000F16E2",
    "clipboard-clock-outline": "\U000F16E3",
    "clipboard-edit": "\U000F14E5",
    "clipboard-edit-outline": "\U000F14E6",
    "clipboard-file": "\U000F1265",
    "clipboard-file-outline": "\U000F1266",
    "clipboard-flow": "\U000F06C8",
    "clipboard-flow-outline": "\U000F1117",
    "clipboard-list": "\U000F10D4",
    "clipboard-list-outline": "\U000F10D5",
    "clipboard-minus": "\U000F1618",
    "clipboard-minus-outline": "\U000F1619",
    "clipboard-multiple": "\U000F1267",
    "clipboard-multiple-outline": "\U000F1268",
    "clipboard-off": "\U000F161A",
    "clipboard-off-outline": "\U000F161B",
    "clipboard-outline": "\U000F014C",
    "clipboard-play": "\U000F0C59",
    "clipboard-play-multiple": "\U000F1269",
    "clipboard-play-multiple-outline": "\U000F126A",
    "clipboard-play-outline": "\U000F0C5A",
    "clipboard-plus": "\U000F0751",
    "clipboard-plus-outline": "\U000F131F",
    "clipboard-pulse": "\U000F085D",
    "clipboard-pulse-outline": "\U000F085E",
    "clipboard-remove": "\U000F161C",
    "clipboard-remove-outline": "\U000F161D",
    "clipboard-search": "\U000F161E",
    "clipboard-search-outline": "\U000F161F",
    "clipboard-text": "\U000F014D",
    "clipboard-text-clock": "\U000F18F9",
    "clipboard-text-clock-outline": "\U000F18FA",
    "clipboard-text-multiple": "\U000F126B",
    "clipboard-text-multiple-outline": "\U000F126C",
    "clipboard-text-off": "\U000F1620",
    "clipboard-text-off-outline": "\U000F1621",
    "clipboard-text-outline": "\U000F0A38",
    "clipboard-text-play": "\U000F0C5B",
    "clipboard-text-play-outline": "\U000F0C5C",
    "clipboard-text-search": "\U000F1622",
    "clipboard-text-search-outline": "\U000F1623",
    "clippy": "\U000F014F",
    "clock": "\U000F0954",
    "clock-alert": "\U000F0955",
    "clock-alert-outline": "\U000F05CE",
    "clock-check": "\U000F0FA8",
    "clock-check-outline": "\U000F0FA9",
    "clock-digital": "\U000F0E97",
    "clock-edit": "\U000F19BA",
    "clock-edit-outline": "\U000F19BB",
    "clock-end": "\U000F0151",
    "clock-fast": "\U000F0152",
    "clock-in": "\U000F0153",
    "clock-minus": "\U000F1863",
    "clock-minus-outline": "\U000F1864",
    "clock-out": "\U000F0154",
    "clock-outline": "\U000F0150",
    "clock-plus": "\U000F1861",
    "clock-plus-outline": "\U000F1862",
    "clock-remove": "\U000F1865",
    "clock-remove-outline": "\U000F1866",
    "clock-start": "\U000F0155",
    "clock-time-eight": "\U000F1446",
    "clock-time-eight-outline": "\U000F1452",
    "clock-time-eleven": "\U000F1449",
    "clock-time-eleven-outline": "\U000F1455",
    "clock-time-five": "\U000F1443",
    "clock-time-five-outline": "\U000F144F",
    "clock-time-four": "\U000F1442",
    "clock-time-four-outline": "\U000F144E",
    "clock-time-nine": "\U000F1447",
    "clock-time-nine-outline": "\U000F1453",
    "clock-time-one": "\U000F143F",
    "clock-time-one-outline": "\U000F144B",
    "clock-time-seven": "\U000F1445",
    "clock-time-seven-outline": "\U000F1451",
    "clock-time-six": "\U000F1444",
    "clock-time-six-outline": "\U000F1450",
    "clock-time-ten": "\U000F1448",
    "clock-time-ten-outline": "\U000F1454",
    "clock-time-three": "\U000F1441",
    "clock-time-three-outline": "\U000F144D",
    "clock-time-twelve": "\U000F144A",
    "clock-time-twelve-outline": "\U000F1456",
    "clock-time-two": "\U000F1440",
    "clock-time-two-outline": "\U000F144C",
    "close": "\U000F0156",
    "close-box": "\U000F0157",
    "close-box-multiple": "\U000F0C5D",
    "close-box-multiple-outline": "\U000F0C5E",
    "close-box-outline": "\U000F0158",
    "close-circle": "\U000F0159",
    "close-circle-multiple": "\U000F062A",
    "close-circle-multiple-outline": "\U000F0883",
    "close-circle-outline": "\U000F015A",
    "close-network": "\U000F015B",
    "close-network-outline": "\U000F0C5F",
    "close-octagon": "\U000F015C",
    "close-octagon-outline": "\U000F015D",
    "close-outline": "\U000F06C9",
    "close-thick": "\U000F1398",
    "closed-caption": "\U000F015E",
    "closed-caption-outline": "\U000F0DBD",
    "cloud": "\U000F015F",
    "cloud-alert": "\U000F09E0",
    "cloud-braces": "\U000F07B5",
    "cloud-check": "\U000F0160",
    "cloud-check-outline": "\U000F12CC",
    "cloud-circle": "\U000F0161",
    "cloud-download": "\U000F0162",
    "cloud-download-outline": "\U000F0B7D",
    "cloud-lock": "\U000F11F1",
    "cloud-lock-outline": "\U000F11F2",
    "cloud-off-outline": "\U000F0164",
    "cloud-outline": "\U000F0163",
    "cloud-percent": "\U000F1A35",
    "cloud-percent-outline": "\U000F1A36",
    "cloud-print": "\U000F0165",
    "cloud-print-outline": "\U000F0166",
    "cloud-question": "\U000F0A39",
    "cloud-refresh": "\U000F052A",
    "cloud-search": "\U000F0956",
    "cloud-search-outline": "\U000F0957",
    "cloud-sync": "\U000F063F",
    "cloud-sync-outline": "\U000F12D6",
    "cloud-tags": "\U000F07B6",
    "cloud-upload": "\U000F0167",
    "cloud-upload-outline": "\U000F0B7E",
    "clover": "\U000F0816",
    "coach-lamp": "\U000F1020",
    "coach-lamp-variant": "\U000F1A37",
    "coat-rack": "\U000F109E",
    "code-array": "\U000F0168",
    "code-braces": "\U000F0169",
    "code-braces-box": "\U000F10D6",
    "code-brackets": "\U000F016A",
    "code-equal": "\U000F016B",
    "code-greater-than": "\U000F016C",
    "code-greater-than-or-equal": "\U000F016D",
    "code-json": "\U000F0626",
    "code-less-than": "\U000F016E",
    "code-less-than-or-equal": "\U000F016F",
    "code-not-equal": "\U000F0170",
    "code-not-equal-variant": "\U000F0171",
    "code-parentheses": "\U000F0172",
    "code-parentheses-box": "\U000F10D7",
    "code-string": "\U000F0173",
    "code-tags": "\U000F0174",
    "code-tags-check": "\U000F0694",
    "codepen": "\U000F0175",
    "coffee": "\U000F0176",
    "coffee-maker": "\U000F109F",
    "coffee-maker-check": "\U000F1931",
    "coffee-maker-check-outline": "\U000F1932",
    "coffee-maker-outline": "\U000F181B",
    "coffee-off": "\U000F0FAA",
    "coffee-off-outline": "\U000F0FAB",
    "coffee-outline": "\U000F06CA",
    "coffee-to-go": "\U000F0177",
    "coffee-to-go-outline": "\U000F130E",
    "coffin": "\U000F0B7F",
    "cog": "\U000F0493",
    "cog-box": "\U000F0494",
    "cog-clockwise": "\U000F11DD",
    "cog-counterclockwise": "\U000F11DE",
    "cog-off": "\U000F13CE",
    "cog-off-outline": "\U000F13CF",
    "cog-outline": "\U000F08BB",
    "cog-pause": "\U000F1933",
    "cog-pause-outline": "\U000F1934",
    "cog-play": "\U000F1935",
    "cog-play-outline": "\U000F1936",
    "cog-refresh": "\U000F145E",
    "cog-refresh-outline": "\U000F145F",
    "cog-stop": "\U000F1937",
    "cog-stop-outline": "\U000F1938",
    "cog-sync": "\U000F1460",
    "cog-sync-outline": "\U000F1461",
    "cog-transfer": "\U000F105B",
    "cog-transfer-outline": "\U000F105C",
    "cogs": "\U000F08D6",
    "collage": "\U000F0640",
    "collapse-all": "\U000F0AA6",
    "collapse-all-outline": "\U000F0AA7",
    "color-helper": "\U000F0179",
    "comma": "\U000F0E23",
    "comma-box": "\U000F0E2B",
    "comma-box-outline": "\U000F0E24",
    "comma-circle": "\U000F0E25",
    "comma-circle-outline": "\U000F0E26",
    "comment": "\U000F017A",
    "comment-account": "\U000F017B",
    "comment-account-outline": "\U000F017C",
    "comment-alert": "\U000F017D",
    "comment-alert-outline": "\U000F017E",
    "comment-arrow-left": "\U000F09E1",
    "comment-arrow-left-outline": "\U000F09E2",
    "comment-arrow-right": "\U000F09E3",
    "comment-arrow-right-outline": "\U000F09E4",
    "comment-bookmark": "\U000F15AE",
    "comment-bookmark-outline": "\U000F15AF",
    "comment-check": "\U000F017F",
    "comment-check-outline": "\U000F0180",
    "comment-edit": "\U000F11BF",
    "comment-edit-outline": "\U000F12C4",
    "comment-eye": "\U000F0A3A",
    "comment-eye-outline": "\U000F0A3B",
    "comment-flash": "\U000F15B0",
    "comment-flash-outline": "\U000F15B1",
    "comment-minus": "\U000F15DF",
    "comment-minus-outline": "\U000F15E0",
    "comment-multiple": "\U000F085F",
    "comment-multiple-outline": "\U000F0181",
    "comment-off": "\U000F15E1",
    "comment-off-outline": "\U000F15E2",
    "comment-outline": "\U000F0182",
    "comment-plus": "\U000F09E5",
    "comment-plus-outline": "\U000F0183",
    "comment-processing": "\U000F0184",
    "comment-processing-outline": "\U000F0185",
    "comment-question": "\U000F0817",
    "comment-question-outline": "\U000F0186",
    "comment-quote": "\U000F1021",
    "comment-quote-outline": "\U000F1022",
    "comment-remove": "\U000F05DE",
    "comment-remove-outline": "\U000F0187",
    "comment-search": "\U000F0A3C",
    "comment-search-outline": "\U000F0A3D",
    "comment-text": "\U000F0188",
    "comment-text-multiple": "\U000F0860",
    "comment-text-multiple-outline": "\U000F0861",
    "comment-text-outline": "\U000F0189",
    "compare": "\U000F018A",
    "compare-horizontal": "\U000F1492",
    "compare-remove": "\U000F18B3",
    "compare-vertical": "\U000F1493",
    "compass": "\U000F018B",
    "compass-off": "\U000F0B80",
    "compass-off-outline": "\U000F0B81",
    "compass-outline": "\U000F018C",
    "compass-rose": "\U000F1382",
    "compost": "\U000F1A38",
    "cone": "\U000F194C",
    "cone-off": "\U000F194D",
    "connection": "\U000F1616",
    "console": "\U000F018D",
    "console-line": "\U000F07B7",
    "console-network": "\U000F08A9",
    "console-network-outline": "\U000F0C60",
    "consolidate": "\U000F10D8",
    "contactless-payment": "\U000F0D6A",
    "contactless-payment-circle": "\U000F0321",
    "contactless-payment-circle-outline": "\U000F0408",
    "contacts": "\U000F06CB",
    "contacts-outline": "\U000F05B8",
    "contain": "\U000F0A3E",
    "contain-end": "\U000F0A3F",
    "contain-start": "\U000F0A40",
    "content-copy": "\U000F018F",
    "content-cut": "\U000F0190",
    "content-duplicate": "\U000F0191",
    "content-paste": "\U000F0192",
    "content-save": "\U000F0193",
    "content-save-alert": "\U000F0F42",
    "content-save-alert-outline": "\U000F0F43",
    "content-save-all": "\U000F0194",
    "content-save-all-outline": "\U000F0F44",
    "content-save-check": "\U000F18EA",
    "content-save-check-outline": "\U000F18EB",
    "content-save-cog": "\U000F145B",
    "content-save-cog-outline": "\U000F145C",
    "content-save-edit": "\U000F0CFB",
    "content-save-edit-outline": "\U000F0CFC",
    "content-save-minus": "\U000F1B43",
    "content-save-minus-outline": "\U000F1B44",
    "content-save-move": "\U000F0E27",
    "content-save-move-outline": "\U000F0E28",
    "content-save-off": "\U000F1643",
    "content-save-off-outline": "\U000F1644",
    "content-save-outline": "\U000F0818",
    "content-save-plus": "\U000F1B41",
    "content-save-plus-outline": "\U000F1B42",
    "content-save-settings": "\U000F061B",
    "content-save-settings-outline": "\U000F0B2E",
    "contrast": "\U000F0195",
    "contrast-box": "\U000F0196",
    "contrast-circle": "\U000F0197",
    "controller-classic": "\U000F0B82",
    "controller-classic-outline": "\U000F0B83",
    "cookie": "\U000F0198",
    "cookie-alert": "\U000F16D0",
    "cookie-alert-outline": "\U000F16D1",
    "cookie-check": "\U000F16D2",
    "cookie-check-outline": "\U000F16D3",
    "cookie-clock": "\U000F16E4",
    "cookie-clock-outline": "\U000F16E5",
    "cookie-cog": "\U000F16D4",
    "cookie-cog-outline": "\U000F16D5",
    "cookie-edit": "\U000F16E6",
    "cookie-edit-outline": "\U000F16E7",
    "cookie-lock": "\U000F16E8",
    "cookie-lock-outline": "\U000F16E9",
    "cookie-minus": "\U000F16DA",
    "cookie-minus-outline": "\U000F16DB",
    "cookie-off": "\U000F16EA",
    "cookie-off-outline": "\U000F16EB",
    "cookie-outline": "\U000F16DE",
    "cookie-plus": "\U000F16D6",
    "cookie-plus-outline": "\U000F16D7",
    "cookie-refresh": "\U000F16EC",
    "cookie-refresh-outline": "\U000F16ED",
    "cookie-remove": "\U000F16D8",
    "cookie-remove-outline": "\U000F16D9",
    "cookie-settings": "\U000F16DC",
    "cookie-settings-outline": "\U000F16DD",
    "coolant-temperature": "\U000F03C8",
    "copyleft": "\U000F1939",
    "copyright": "\U000F05E6",
    "cordova": "\U000F0958",
    "corn": "\U000F07B8",
    "corn-off": "\U000F13EF",
    "cosine-wave": "\U000F1479",
    "counter": "\U000F0199",
    "countertop": "\U000F181C",
    "countertop-outline": "\U000F181D",
    "cow": "\U000F019A",
    "cow-off": "\U000F18FC",
    "cpu-32-bit": "\U000F0EDF",
    "cpu-64-bit": "\U000F0EE0",
    "cradle": "\U000F198B",
    "cradle-outline": "\U000F1991",
    "crane": "\U000F0862",
    "creation": "\U000F0674",
    "creative-commons": "\U000F0D6B",
    "credit-card": "\U000F0FEF",
    "credit-card-check": "\U000F13D0",
    "credit-card-check-outline": "\U000F13D1",
    "credit-card-chip": "\U000F190F",
    "credit-card-chip-outline": "\U000F1910",
    "credit-card-clock": "\U000F0EE1",
    "credit-card-clock-outline": "\U000F0EE2",
    "credit-card-edit": "\U000F17D7",
    "credit-card-edit-outline": "\U000F17D8",
    "credit-card-fast": "\U000F1911",
    "credit-card-fast-outline": "\U000F1912",
    "credit-card-lock": "\U000F18E7",
    "credit-card-lock-outline": "\U000F18E8",
    "credit-card-marker": "\U000F06A8",
    "credit-card-marker-outline": "\U000F0DBE",
    "credit-card-minus": "\U000F0FAC",
    "credit-card-minus-outline": "\U000F0FAD",
    "credit-card-multiple": "\U000F0FF0",
    "credit-card-multiple-outline": "\U000F019C",
    "credit-card-off": "\U000F0FF1",
    "credit-card-off-outline": "\U000F05E4",
    "credit-card-outline": "\U000F019B",
    "credit-card-plus": "\U000F0FF2",
    "credit-card-plus-outline": "\U000F0676",
    "credit-card-refresh": "\U000F1645",
    "credit-card-refresh-outline": "\U000F1646",
    "credit-card-refund": "\U000F0FF3",
    "credit-card-refund-outline": "\U000F0AA8",
    "credit-card-remove": "\U000F0FAE",
    "credit-card-remove-outline": "\U000F0FAF",
    "credit-card-scan": "\U000F0FF4",
    "credit-card-scan-outline": "\U000F019D",
    "credit-card-search": "\U000F1647",
    "credit-card-search-outline": "\U000F1648",
    "credit-card-settings": "\U000F0FF5",
    "credit-card-settings-outline": "\U000F08D7",
    "credit-card-sync": "\U000F1649",
    "credit-card-sync-outline": "\U000F164A",
    "credit-card-wireless": "\U000F0802",
    "credit-card-wireless-off": "\U000F057A",
    "credit-card-wireless-off-outline": "\U000F057B",
    "credit-card-wireless-outline": "\U000F0D6C",
    "cricket": "\U000F0D6D",
    "crop": "\U000F019E",
    "crop-free": "\U000F019F",
    "crop-landscape": "\U000F01A0",
    "crop-portrait": "\U000F01A1",
    "crop-rotate": "\U000F0696",
    "crop-square": "\U000F01A2",
    "cross": "\U000F0953",
    "cross-bolnisi": "\U000F0CED",
    "cross-celtic": "\U000F0CF5",
    "cross-outline": "\U000F0CF6",
    "crosshairs": "\U000F01A3",
    "crosshairs-gps": "\U000F01A4",
    "crosshairs-off": "\U000F0F45",
    "crosshairs-question": "\U000F1136",
    "crowd": "\U000F1975",
    "crown": "\U000F01A5",
    "crown-circle": "\U000F17DC",
    "crown-circle-outline": "\U000F17DD",
    "crown-outline": "\U000F11D0",
    "cryengine": "\U000F0959",
    "crystal-ball": "\U000F0B2F",
    "cube": "\U000F01A6",
    "cube-off": "\U000F141C",
    "cube-off-outline": "\U000F141D",
    "cube-outline": "\U000F01A7",
    "cube-scan": "\U000F0B84",
    "cube-send": "\U000F01A8",
    "cube-unfolded": "\U000F01A9",
    "cup": "\U000F01AA",
    "cup-off": "\U000F05E5",
    "cup-off-outline": "\U000F137D",
    "cup-outline": "\U000F130F",
    "cup-water": "\U000F01AB",
    "cupboard": "\U000F0F46",
    "cupboard-outline": "\U000F0F47",
    "cupcake": "\U000F095A",
    "curling": "\U000F0863",
    "currency-bdt": "\U000F0864",
    "currency-brl": "\U000F0B85",
    "currency-btc": "\U000F01AC",
    "currency-cny": "\U000F07BA",
    "currency-eth": "\U000F07BB",
    "currency-eur": "\U000F01AD",
    "currency-eur-off": "\U000F1315",
    "currency-fra": "\U000F1A39",
    "currency-gbp": "\U000F01AE",
    "currency-ils": "\U000F0C61",
    "currency-inr": "\U000F01AF",
    "currency-jpy": "\U000F07BC",
    "currency-krw": "\U000F07BD",
    "currency-kzt": "\U000F0865",
    "currency-mnt": "\U000F1512",
    "currency-ngn": "\U000F01B0",
    "currency-php": "\U000F09E6",
    "currency-rial": "\U000F0E9C",
    "currency-rub": "\U000F01B1",
    "currency-rupee": "\U000F1976",
    "currency-sign": "\U000F07BE",
    "currency-try": "\U000F01B2",
    "currency-twd": "\U000F07BF",
    "currency-usd": "\U000F01C1",
    "currency-usd-off": "\U000F067A",
    "current-ac": "\U000F1480",
    "current-dc": "\U000F095C",
    "cursor-default": "\U000F01C0",
    "cursor-default-click": "\U000F0CFD",
    "cursor-default-click-outline": "\U000F0CFE",
    "cursor-default-gesture": "\U000F1127",
    "cursor-default-gesture-outline": "\U000F1128",
    "cursor-default-outline": "\U000F01BF",
    "cursor-move": "\U000F01BE",
    "cursor-pointer": "\U000F01BD",
    "cursor-text": "\U000F05E7",
    "curtains": "\U000F1846",
    "curtains-closed": "\U000F1847",
    "cylinder": "\U000F194E",
    "cylinder-off": "\U000F194F",
    "dance-ballroom": "\U000F15FB",
    "dance-pole": "\U000F1578",
    "data-matrix": "\U000F153C",
    "data-matrix-edit": "\U000F153D",
    "data-matrix-minus": "\U000F153E",
    "data-matrix-plus": "\U000F153F",
    "data-matrix-remove": "\U000F1540",
    "data-matrix-scan": "\U000F1541",
    "database": "\U000F01BC",
    "database-alert": "\U000F163A",
    "database-alert-outline": "\U000F1624",
    "database-arrow-down": "\U000F163B",
    "database-arrow-down-outline": "\U000F1625",
    "database-arrow-left": "\U000F163C",
    "database-arrow-left-outline": "\U000F1626",
    "database-arrow-right": "\U000F163D",
    "database-arrow-right-outline": "\U000F1627",
    "database-arrow-up": "\U000F163E",
    "database-arrow-up-outline": "\U000F1628",
    "database-check": "\U000F0AA9",
    "database-check-outline": "\U000F1629",
    "database-clock": "\U000F163F",
    "database-clock-outline": "\U000F162A",
    "database-cog": "\U000F164B",
    "database-cog-outline": "\U000F164C",
    "database-edit": "\U000F0B86",
    "database-edit-outline": "\U000F162B",
    "database-export": "\U000F095E",
    "database-export-outline": "\U000F162C",
    "database-eye": "\U000F191F",
    "database-eye-off": "\U000F1920",
    "database-eye-off-outline": "\U000F1921",
    "database-eye-outline": "\U000F1922",
    "database-import": "\U000F095D",
    "database-import-outline": "\U000F162D",
    "database-lock": "\U000F0AAA",
    "database-lock-outline": "\U000F162E",
    "database-marker": "\U000F12F6",
    "database-marker-outline": "\U000F162F",
    "database-minus": "\U000F01BB",
    "database-minus-outline": "\U000F1630",
    "database-off": "\U000F1640",
    "database-off-outline": "\U000F1631",
    "database-outline": "\U000F1632",
    "database-plus": "\U000F01BA",
    "database-plus-outline": "\U000F1633",
    "database-refresh": "\U000F05C2",
    "database-refresh-outline": "\U000F1634",
    "database-remove": "\U000F0D00",
    "database-remove-outline": "\U000F1635",
    "database-search": "\U000F0866",
    "database-search-outline": "\U000F1636",
    "database-settings": "\U000F0D01",
    "database-settings-outline": "\U000F1637",
    "database-sync": "\U000F0CFF",
    "database-sync-outline": "\U000F1638",
    "death-star": "\U000F08D8",
    "death-star-variant": "\U000F08D9",
    "deathly-hallows": "\U000F0B87",
    "debian": "\U000F08DA",
    "debug-step-into": "\U000F01B9",
    "debug-step-out": "\U000F01B8",
    "debug-step-over": "\U000F01B7",
    "decagram": "\U000F076C",
    "decagram-outline": "\U000F076D",
    "decimal": "\U000F10A1",
    "decimal-comma": "\U000F10A2",
    "decimal-comma-decrease": "\U000F10A3",
    "decimal-comma-increase": "\U000F10A4",
    "decimal-decrease": "\U000F01B6",
    "decimal-increase": "\U000F01B5",
    "delete": "\U000F01B4",
    "delete-alert": "\U000F10A5",
    "delete-alert-outline": "\U000F10A6",
    "delete-circle": "\U000F0683",
    "delete-circle-outline": "\U000F0B88",
    "delete-clock": "\U000F1556",
    "delete-clock-outline": "\U000F1557",
    "delete-empty": "\U000F06CC",
    "delete-empty-outline": "\U000F0E9D",
    "delete-forever": "\U000F05E8",
    "delete-forever-outline": "\U000F0B89",
    "delete-off": "\U000F10A7",
    "delete-off-outline": "\U000F10A8",
    "delete-outline": "\U000F09E7",
    "delete-restore": "\U000F0819",
    "delete-sweep": "\U000F05E9",
    "delete-sweep-outline": "\U000F0C62",
    "delete-variant": "\U000F01B3",
    "delta": "\U000F01C2",
    "desk": "\U000F1239",
    "desk-lamp": "\U000F095F",
    "desk-lamp-off": "\U000F1B1F",
    "desk-lamp-on": "\U000F1B20",
    "deskphone": "\U000F01C3",
    "desktop-classic": "\U000F07C0",
    "desktop-mac": "\U000F01C4",
    "desktop-mac-dashboard": "\U000F09E8",
    "desktop-tower": "\U000F01C5",
    "desktop-tower-monitor": "\U000F0AAB",
    "details": "\U000F01C6",
    "dev-to": "\U000F0D6E",
    "developer-board": "\U000F0697",
    "deviantart": "\U000F01C7",
    "devices": "\U000F0FB0",
    "dharmachakra": "\U000F094B",
    "diabetes": "\U000F1126",
    "dialpad": "\U000F061C",
    "diameter": "\U000F0C63",
    "diameter-outline": "\U000F0C64",
    "diameter-variant": "\U000F0C65",
    "diamond": "\U000F0B8A",
    "diamond-outline": "\U000F0B8B",
    "diamond-stone": "\U000F01C8",
    "dice-1": "\U000F01CA",
    "dice-1-outline": "\U000F114A",
    "dice-2": "\U000F01CB",
    "dice-2-outline": "\U000F114B",
    "dice-3": "\U000F01CC",
    "dice-3-outline": "\U000F114C",
    "dice-4": "\U000F01CD",
    "dice-4-outline": "\U000F114D",
    "dice-5": "\U000F01CE",
    "dice-5-outline": "\U000F114E",
    "dice-6": "\U000F01CF",
    "dice-6-outline": "\U000F114F",
    "dice-d10": "\U000F1153",
    "dice-d10-outline": "\U000F076F",
    "dice-d12": "\U000F1154",
    "dice-d12-outline": "\U000F0867",
    "dice-d20": "\U000F1155",
    "dice-d20-outline": "\U000F05EA",
    "dice-d4": "\U000F1150",
    "dice-d4-outline": "\U000F05EB",
    "dice-d6": "\U000F1151",
    "dice-d6-outline": "\U000F05ED",
    "dice-d8": "\U000F1152",
    "dice-d8-outline": "\U000F05EC",
    "dice-multiple": "\U000F076E",
    "dice-multiple-outline": "\U000F1156",
    "digital-ocean": "\U000F1237",
    "dip-switch": "\U000F07C1",
    "directions": "\U000F01D0",
    "directions-fork": "\U000F0641",
    "disc": "\U000F05EE",
    "disc-alert": "\U000F01D1",
    "disc-player": "\U000F0960",
    "discord": "\U000F066F",
    "dishwasher": "\U000F0AAC",
    "dishwasher-alert": "\U000F11B8",
    "dishwasher-off": "\U000F11B9",
    "disqus": "\U000F01D2",
    "distribute-horizontal-center": "\U000F11C9",
    "distribute-horizontal-left": "\U000F11C8",
    "distribute-horizontal-right": "\U000F11CA",
    "distribute-vertical-bottom": "\U000F11CB",
    "distribute-vertical-center": "\U000F11CC",
    "distribute-vertical-top": "\U000F11CD",
    "diversify": "\U000F1877",
    "diving": "\U000F1977",
    "diving-flippers": "\U000F0DBF",
    "diving-helmet": "\U000F0DC0",
    "diving-scuba": "\U000F0DC1",
    "diving-scuba-flag": "\U000F0DC2",
    "diving-scuba-tank": "\U000F0DC3",
    "diving-scuba-tank-multiple": "\U000F0DC4",
    "diving-snorkel": "\U000F0DC5",
    "division": "\U000F01D4",
    "division-box": "\U000F01D5",
    "dlna": "\U000F0A41",
    "dna": "\U000F0684",
    "dns": "\U000F01D6",
    "dns-outline": "\U000F0B8C",
    "dock-bottom": "\U000F10A9",
    "dock-left": "\U000F10AA",
    "dock-right": "\U000F10AB",
    "dock-top": "\U000F1513",
    "dock-window": "\U000F10AC",
    "docker": "\U000F0868",
    "doctor": "\U000F0A42",
    "dog": "\U000F0A43",
    "dog-service": "\U000F0AAD",
    "dog-side": "\U000F0A44",
    "dog-side-off": "\U000F16EE",
    "dolby": "\U000F06B3",
    "dolly": "\U000F0E9E",
    "dolphin": "\U000F18B4",
    "domain": "\U000F01D7",
    "domain-off": "\U000F0D6F",
    "domain-plus": "\U000F10AD",
    "domain-remove": "\U000F10AE",
    "dome-light": "\U000F141E",
    "domino-mask": "\U000F1023",
    "donkey": "\U000F07C2",
    "door": "\U000F081A",
    "door-closed": "\U000F081B",
    "door-closed-lock": "\U000F10AF",
    "door-open": "\U000F081C",
    "door-sliding": "\U000F181E",
    "door-sliding-lock": "\U000F181F",
    "door-sliding-open": "\U000F1820",
    "doorbell": "\U000F12E6",
    "doorbell-video": "\U000F0869",
    "dot-net": "\U000F0AAE",
    "dots-circle": "\U000F1978",
    "dots-grid": "\U000F15FC",
    "dots-hexagon": "\U000F15FF",
    "dots-horizontal": "\U000F01D8",
    "dots-horizontal-circle": "\U000F07C3",
    "dots-horizontal-circle-outline": "\U000F0B8D",
    "dots-square": "\U000F15FD",
    "dots-triangle": "\U000F15FE",
    "dots-vertical": "\U000F01D9",
    "dots-vertical-circle": "\U000F07C4",
    "dots-vertical-circle-outline": "\U000F0B8E",
    "download": "\U000F01DA",
    "download-box": "\U000F1462",
    "download-box-outline": "\U000F1463",
    "download-circle": "\U000F1464",
    "download-circle-outline": "\U000F1465",
    "download-lock": "\U000F1320",
    "download-lock-outline": "\U000F1321",
    "download-multiple": "\U000F09E9",
    "download-network": "\U000F06F4",
    "download-network-outline": "\U000F0C66",
    "download-off": "\U000F10B0",
    "download-off-outline": "\U000F10B1",
    "download-outline": "\U000F0B8F",
    "drag": "\U000F01DB",
    "drag-horizontal": "\U000F01DC",
    "drag-horizontal-variant": "\U000F12F0",
    "drag-variant": "\U000F0B90",
    "drag-vertical": "\U000F01DD",
    "drag-vertical-variant": "\U000F12F1",
    "drama-masks": "\U000F0D02",
    "draw": "\U000F0F49",
    "draw-pen": "\U000F19B9",
    "drawing": "\U000F01DE",
    "drawing-box": "\U000F01DF",
    "dresser": "\U000F0F4A",
    "dresser-outline": "\U000F0F4B",
    "drone": "\U000F01E2",
    "dropbox": "\U000F01E3",
    "drupal": "\U000F01E4",
    "duck": "\U000F01E5",
    "dumbbell": "\U000F01E6",
    "dump-truck": "\U000F0C67",
    "ear-hearing": "\U000F07C5",
    "ear-hearing-loop": "\U000F1AEE",
    "ear-hearing-off": "\U000F0A45",
    "earbuds": "\U000F184F",
    "earbuds-off": "\U000F1850",
    "earbuds-off-outline": "\U000F1851",
    "earbuds-outline": "\U000F1852",
    "earth": "\U000F01E7",
    "earth-arrow-right": "\U000F1311",
    "earth-box": "\U000F06CD",
    "earth-box-minus": "\U000F1407",
    "earth-box-off": "\U000F06CE",
    "earth-box-plus": "\U000F1406",
    "earth-box-remove": "\U000F1408",
    "earth-minus": "\U000F1404",
    "earth-off": "\U000F01E8",
    "earth-plus": "\U000F1403",
    "earth-remove": "\U000F1405",
    "egg": "\U000F0AAF",
    "egg-easter": "\U000F0AB0",
    "egg-fried": "\U000F184A",
    "egg-off": "\U000F13F0",
    "egg-off-outline": "\U000F13F1",
    "egg-outline": "\U000F13F2",
    "eiffel-tower": "\U000F156B",
    "eight-track": "\U000F09EA",
    "eject": "\U000F01EA",
    "eject-circle": "\U000F1B23",
    "eject-circle-outline": "\U000F1B24",
    "eject-outline": "\U000F0B91",
    "electric-switch": "\U000F0E9F",
    "electric-switch-closed": "\U000F10D9",
    "electron-framework": "\U000F1024",
    "elephant": "\U000F07C6",
    "elevation-decline": "\U000F01EB",
    "elevation-rise": "\U000F01EC",
    "elevator": "\U000F01ED",
    "elevator-down": "\U000F12C2",
    "elevator-passenger": "\U000F1381",
    "elevator-passenger-off": "\U000F1979",
    "elevator-passenger-off-outline": "\U000F197A",
    "elevator-passenger-outline": "\U000F197B",
    "elevator-up": "\U000F12C1",
    "ellipse": "\U000F0EA0",
    "ellipse-outline": "\U000F0EA1",
    "email": "\U000F01EE",
    "email-alert": "\U000F06CF",
    "email-alert-outline": "\U000F0D42",
    "email-box": "\U000F0D03",
    "email-check": "\U000F0AB1",
    "email-check-outline": "\U000F0AB2",
    "email-edit": "\U000F0EE3",
    "email-edit-outline": "\U000F0EE4",
    "email-fast": "\U000F186F",
    "email-fast-outline": "\U000F1870",
    "email-lock": "\U000F01F1",
    "email-mark-as-unread": "\U000F0B92",
    "email-minus": "\U000F0EE5",
    "email-minus-outline": "\U000F0EE6",
    "email-multiple": "\U000F0EE7",
    "email-multiple-outline": "\U000F0EE8",
    "email-newsletter": "\U000F0FB1",
    "email-off": "\U000F13E3",
    "email-off-outline": "\U000F13E4",
    "email-open": "\U000F01EF",
    "email-open-multiple": "\U000F0EE9",
    "email-open-multiple-outline": "\U000F0EEA",
    "email-open-outline": "\U000F05EF",
    "email-outline": "\U000F01F0",
    "email-plus": "\U000F09EB",
    "email-plus-outline": "\U000F09EC",
    "email-receive": "\U000F10DA",
    "email-receive-outline": "\U000F10DB",
    "email-remove": "\U000F1661",
    "email-remove-outline": "\U000F1662",
    "email-seal": "\U000F195B",
    "email-seal-outline": "\U000F195C",
    "email-search": "\U000F0961",
    "email-search-outline": "\U000F0962",
    "email-send": "\U000F10DC",
    "email-send-outline": "\U000F10DD",
    "email-sync": "\U000F12C7",
    "email-sync-outline": "\U000F12C8",
    "email-variant": "\U000F05F0",
    "ember": "\U000F0B30",
    "emby": "\U000F06B4",
    "emoticon": "\U000F0C68",
    "emoticon-angry": "\U000F0C69",
    "emoticon-angry-outline": "\U000F0C6A",
    "emoticon-confused": "\U000F10DE",
    "emoticon-confused-outline": "\U000F10DF",
    "emoticon-cool": "\U000F0C6B",
    "emoticon-cool-outline": "\U000F01F3",
    "emoticon-cry": "\U000F0C6C",
    "emoticon-cry-outline": "\U000F0C6D",
    "emoticon-dead": "\U000F0C6E",
    "emoticon-dead-outline": "\U000F069B",
    "emoticon-devil": "\U000F0C6F",
    "emoticon-devil-outline": "\U000F01F4",
    "emoticon-excited": "\U000F0C70",
    "emoticon-excited-outline": "\U000F069C",
    "emoticon-frown": "\U000F0F4C",
    "emoticon-frown-outline": "\U000F0F4D",
    "emoticon-happy": "\U000F0C71",
    "emoticon-happy-outline": "\U000F01F5",
    "emoticon-kiss": "\U000F0C72",
    "emoticon-kiss-outline": "\U000F0C73",
    "emoticon-lol": "\U000F1214",
    "emoticon-lol-outline": "\U000F1215",
    "emoticon-neutral": "\U000F0C74",
    "emoticon-neutral-outline": "\U000F01F6",
    "emoticon-outline": "\U000F01F2",
    "emoticon-poop": "\U000F01F7",
    "emoticon-poop-outline": "\U000F0C75",
    "emoticon-sad": "\U000F0C76",
    "emoticon-sad-outline": "\U000F01F8",
    "emoticon-sick": "\U000F157C",
    "emoticon-sick-outline": "\U000F157D",
    "emoticon-tongue": "\U000F01F9",
    "emoticon-tongue-outline": "\U000F0C77",
    "emoticon-wink": "\U000F0C78",
    "emoticon-wink-outline": "\U000F0C79",
    "engine": "\U000F01FA",
    "engine-off": "\U000F0A46",
    "engine-off-outline": "\U000F0A47",
    "engine-outline": "\U000F01FB",
    "epsilon": "\U000F10E0",
    "equal": "\U000F01FC",
    "equal-box": "\U000F01FD",
    "equalizer": "\U000F0EA2",
    "equalizer-outline": "\U000F0EA3",
    "eraser": "\U000F01FE",
    "eraser-variant": "\U000F0642",
    "escalator": "\U000F01FF",
    "escalator-box": "\U000F1399",
    "escalator-down": "\U000F12C0",
    "escalator-up": "\U000F12BF",
    "eslint": "\U000F0C7A",
    "et": "\U000F0AB3",
    "ethereum": "\U000F086A",
    "ethernet": "\U000F0200",
    "ethernet-cable": "\U000F0201",
    "ethernet-cable-off": "\U000F0202",
    "ev-plug-ccs1": "\U000F1519",
    "ev-plug-ccs2": "\U000F151A",
    "ev-plug-chademo": "\U000F151B",
    "ev-plug-tesla": "\U000F151C",
    "ev-plug-type1": "\U000F151D",
    "ev-plug-type2": "\U000F151E",
    "ev-station": "\U000F05F1",
    "evernote": "\U000F0204",
    "excavator": "\U000F1025",
    "exclamation": "\U000F0205",
    "exclamation-thick": "\U000F1238",
    "exit-run": "\U000F0A48",
    "exit-to-app": "\U000F0206",
    "expand-all": "\U000F0AB4",
    "expand-all-outline": "\U000F0AB5",
    "expansion-card": "\U000F08AE",
    "expansion-card-variant": "\U000F0FB2",
    "exponent": "\U000F0963",
    "exponent-box": "\U000F0964",
    "export": "\U000F0207",
    "export-variant": "\U000F0B93",
    "eye": "\U000F0208",
    "eye-arrow-left": "\U000F18FD",
    "eye-arrow-left-outline": "\U000F18FE",
    "eye-arrow-right": "\U000F18FF",
    "eye-arrow-right-outline": "\U000F1900",
    "eye-check": "\U000F0D04",
    "eye-check-outline": "\U000F0D05",
    "eye-circle": "\U000F0B94",
    "eye-circle-outline": "\U000F0B95",
    "eye-minus": "\U000F1026",
    "eye-minus-outline": "\U000F1027",
    "eye-off": "\U000F0209",
    "eye-off-outline": "\U000F06D1",
    "eye-outline": "\U000F06D0",
    "eye-plus": "\U000F086B",
    "eye-plus-outline": "\U000F086C",
    "eye-refresh": "\U000F197C",
    "eye-refresh-outline": "\U000F197D",
    "eye-remove": "\U000F15E3",
    "eye-remove-outline": "\U000F15E4",
    "eye-settings": "\U000F086D",
    "eye-settings-outline": "\U000F086E",
    "eyedropper": "\U000F020A",
    "eyedropper-minus": "\U000F13DD",
    "eyedropper-off": "\U000F13DF",
    "eyedropper-plus": "\U000F13DC",
    "eyedropper-remove": "\U000F13DE",
    "eyedropper-variant": "\U000F020B",
    "face-agent": "\U000F0D70",
    "face-man": "\U000F0643",
    "face-man-outline": "\U000F0B96",
    "face-man-profile": "\U000F0644",
    "face-man-shimmer": "\U000F15CC",
    "face-man-shimmer-outline": "\U000F15CD",
    "face-mask": "\U000F1586",
    "face-mask-outline": "\U000F1587",
    "face-recognition": "\U000F0C7B",
    "face-woman": "\U000F1077",
    "face-woman-outline": "\U000F1078",
    "face-woman-profile": "\U000F1076",
    "face-woman-shimmer": "\U000F15CE",
    "face-woman-shimmer-outline": "\U000F15CF",
    "facebook": "\U000F020C",
    "facebook-gaming": "\U000F07DD",
    "facebook-messenger": "\U000F020E",
    "facebook-workplace": "\U000F0B31",
    "factory": "\U000F020F",
    "family-tree": "\U000F160E",
    "fan": "\U000F0210",
    "fan-alert": "\U000F146C",
    "fan-auto": "\U000F171D",
    "fan-chevron-down": "\U000F146D",
    "fan-chevron-up": "\U000F146E",
    "fan-clock": "\U000F1A3A",
    "fan-minus": "\U000F1470",
    "fan-off": "\U000F081D",
    "fan-plus": "\U000F146F",
    "fan-remove": "\U000F1471",
    "fan-speed-1": "\U000F1472",
    "fan-speed-2": "\U000F1473",
    "fan-speed-3": "\U000F1474",
    "fast-forward": "\U000F0211",
    "fast-forward-10": "\U000F0D71",
    "fast-forward-15": "\U000F193A",
    "fast-forward-30": "\U000F0D06",
    "fast-forward-45": "\U000F1B12",
    "fast-forward-5": "\U000F11F8",
    "fast-forward-60": "\U000F160B",
    "fast-forward-outline": "\U000F06D2",
    "faucet": "\U000F1B29",
    "faucet-variant": "\U000F1B2A",
    "fax": "\U000F0212",
    "feather": "\U000F06D3",
    "feature-search": "\U000F0A49",
    "feature-search-outline": "\U000F0A4A",
    "fedora": "\U000F08DB",
    "fence": "\U000F179A",
    "fence-electric": "\U000F17F6",
    "fencing": "\U000F14C1",
    "ferris-wheel": "\U000F0EA4",
    "ferry": "\U000F0213",
    "file": "\U000F0214",
    "file-account": "\U000F073B",
    "file-account-outline": "\U000F1028",
    "file-alert": "\U000F0A4B",
    "file-alert-outline": "\U000F0A4C",
    "file-arrow-left-right": "\U000F1A93",
    "file-arrow-left-right-outline": "\U000F1A94",
    "file-arrow-up-down": "\U000F1A95",
    "file-arrow-up-down-outline": "\U000F1A96",
    "file-cabinet": "\U000F0AB6",
    "file-cad": "\U000F0EEB",
    "file-cad-box": "\U000F0EEC",
    "file-cancel": "\U000F0DC6",
    "file-cancel-outline": "\U000F0DC7",
    "file-certificate": "\U000F1186",
    "file-certificate-outline": "\U000F1187",
    "file-chart": "\U000F0215",
    "file-chart-check": "\U000F19C6",
    "file-chart-check-outline": "\U000F19C7",
    "file-chart-outline": "\U000F1029",
    "file-check": "\U000F0216",
    "file-check-outline": "\U000F0E29",
    "file-clock": "\U000F12E1",
    "file-clock-outline": "\U000F12E2",
    "file-cloud": "\U000F0217",
    "file-cloud-outline": "\U000F102A",
    "file-code": "\U000F022E",
    "file-code-outline": "\U000F102B",
    "file-cog": "\U000F107B",
    "file-cog-outline": "\U000F107C",
    "file-compare": "\U000F08AA",
    "file-delimited": "\U000F0218",
    "file-delimited-outline": "\U000F0EA5",
    "file-document": "\U000F0219",
    "file-document-alert": "\U000F1A97",
    "file-document-alert-outline": "\U000F1A98",
    "file-document-check": "\U000F1A99",
    "file-document-check-outline": "\U000F1A9A",
    "file-document-edit": "\U000F0DC8",
    "file-document-edit-outline": "\U000F0DC9",
    "file-document-minus": "\U000F1A9B",
    "file-document-minus-outline": "\U000F1A9C",
    "file-document-multiple": "\U000F1517",
    "file-document-multiple-outline": "\U000F1518",
    "file-document-outline": "\U000F09EE",
    "file-document-plus": "\U000F1A9D",
    "file-document-plus-outline": "\U000F1A9E",
    "file-document-remove": "\U000F1A9F",
    "file-document-remove-outline": "\U000F1AA0",
    "file-download": "\U000F0965",
    "file-download-outline": "\U000F0966",
    "file-edit": "\U000F11E7",
    "file-edit-outline": "\U000F11E8",
    "file-excel": "\U000F021B",
    "file-excel-box": "\U000F021C",
    "file-excel-box-outline": "\U000F102C",
    "file-excel-outline": "\U000F102D",
    "file-export": "\U000F021D",
    "file-export-outline": "\U000F102E",
    "file-eye": "\U000F0DCA",
    "file-eye-outline": "\U000F0DCB",
    "file-find": "\U000F021E",
    "file-find-outline": "\U000F0B97",
    "file-gif-box": "\U000F0D78",
    "file-hidden": "\U000F0613",
    "file-image": "\U000F021F",
    "file-image-marker": "\U000F1772",
    "file-image-marker-outline": "\U000F1773",
    "file-image-minus": "\U000F193B",
    "file-image-minus-outline": "\U000F193C",
    "file-image-outline": "\U000F0EB0",
    "file-image-plus": "\U000F193D",
    "file-image-plus-outline": "\U000F193E",
    "file-image-remove": "\U000F193F",
    "file-image-remove-outline": "\U000F1940",
    "file-import": "\U000F0220",
    "file-import-outline": "\U000F102F",
    "file-jpg-box": "\U000F0225",
    "file-key": "\U000F1184",
    "file-key-outline": "\U000F1185",
    "file-link": "\U000F1177",
    "file-link-outline": "\U000F1178",
    "file-lock": "\U000F0221",
    "file-lock-open": "\U000F19C8",
    "file-lock-open-outline": "\U000F19C9",
    "file-lock-outline": "\U000F1030",
    "file-marker": "\U000F1774",
    "file-marker-outline": "\U000F1775",
    "file-minus": "\U000F1AA1",
    "file-minus-outline": "\U000F1AA2",
    "file-move": "\U000F0AB9",
    "file-move-outline": "\U000F1031",
    "file-multiple": "\U000F0222",
    "file-multiple-outline": "\U000F1032",
    "file-music": "\U000F0223",
    "file-music-outline": "\U000F0E2A",
    "file-outline": "\U000F0224",
    "file-pdf-box": "\U000F0226",
    "file-percent": "\U000F081E",
    "file-percent-outline": "\U000F1033",
    "file-phone": "\U000F1179",
    "file-phone-outline": "\U000F117A",
    "file-plus": "\U000F0752",
    "file-plus-outline": "\U000F0EED",
    "file-png-box": "\U000F0E2D",
    "file-powerpoint": "\U000F0227",
    "file-powerpoint-box": "\U000F0228",
    "file-powerpoint-box-outline": "\U000F1034",
    "file-powerpoint-outline": "\U000F1035",
    "file-presentation-box": "\U000F0229",
    "file-question": "\U000F086F",
    "file-question-outline": "\U000F1036",
    "file-refresh": "\U000F0918",
    "file-refresh-outline": "\U000F0541",
    "file-remove": "\U000F0B98",
    "file-remove-outline": "\U000F1037",
    "file-replace": "\U000F0B32",
    "file-replace-outline": "\U000F0B33",
    "file-restore": "\U000F0670",
    "file-restore-outline": "\U000F1038",
    "file-rotate-left": "\U000F1A3B",
    "file-rotate-left-outline": "\U000F1A3C",
    "file-rotate-right": "\U000F1A3D",
    "file-rotate-right-outline": "\U000F1A3E",
    "file-search": "\U000F0C7C",
    "file-search-outline": "\U000F0C7D",
    "file-send": "\U000F022A",
    "file-send-outline": "\U000F1039",
    "file-settings": "\U000F1079",
    "file-settings-outline": "\U000F107A",
    "file-sign": "\U000F19C3",
    "file-star": "\U000F103A",
    "file-star-outline": "\U000F103B",
    "file-swap": "\U000F0FB4",
    "file-swap-outline": "\U000F0FB5",
    "file-sync": "\U000F1216",
    "file-sync-outline": "\U000F1217",
    "file-table": "\U000F0C7E",
    "file-table-box": "\U000F10E1",
    "file-table-box-multiple": "\U000F10E2",
    "file-table-box-multiple-outline": "\U000F10E3",
    "file-table-box-outline": "\U000F10E4",
    "file-table-outline": "\U000F0C7F",
    "file-tree": "\U000F0645",
    "file-tree-outline": "\U000F13D2",
    "file-undo": "\U000F08DC",
    "file-undo-outline": "\U000F103C",
    "file-upload": "\U000F0A4D",
    "file-upload-outline": "\U000F0A4E",
    "file-video": "\U000F022B",
    "file-video-outline": "\U000F0E2C",
    "file-word": "\U000F022C",
    "file-word-box": "\U000F022D",
    "file-word-box-outline": "\U000F103D",
    "file-word-outline": "\U000F103E",
    "file-xml-box": "\U000F1B4B",
    "film": "\U000F022F",
    "filmstrip": "\U000F0230",
    "filmstrip-box": "\U000F0332",
    "filmstrip-box-multiple": "\U000F0D18",
    "filmstrip-off": "\U000F0231",
    "filter": "\U000F0232",
    "filter-check": "\U000F18EC",
    "filter-check-outline": "\U000F18ED",
    "filter-cog": "\U000F1AA3",
    "filter-cog-outline": "\U000F1AA4",
    "filter-menu": "\U000F10E5",
    "filter-menu-outline": "\U000F10E6",
    "filter-minus": "\U000F0EEE",
    "filter-minus-outline": "\U000F0EEF",
    "filter-multiple": "\U000F1A3F",
    "filter-multiple-outline": "\U000F1A40",
    "filter-off": "\U000F14EF",
    "filter-off-outline": "\U000F14F0",
    "filter-outline": "\U000F0233",
    "filter-plus": "\U000F0EF0",
    "filter-plus-outline": "\U000F0EF1",
    "filter-remove": "\U000F0234",
    "filter-remove-outline": "\U000F0235",
    "filter-settings": "\U000F1AA5",
    "filter-settings-outline": "\U000F1AA6",
    "filter-variant": "\U000F0236",
    "filter-variant-minus": "\U000F1112",
    "filter-variant-plus": "\U000F1113",
    "filter-variant-remove": "\U000F103F",
    "finance": "\U000F081F",
    "find-replace": "\U000F06D4",
    "fingerprint": "\U000F0237",
    "fingerprint-off": "\U000F0EB1",
    "fire": "\U000F0238",
    "fire-alert": "\U000F15D7",
    "fire-circle": "\U000F1807",
    "fire-extinguisher": "\U000F0EF2",
    "fire-hydrant": "\U000F1137",
    "fire-hydrant-alert": "\U000F1138",
    "fire-hydrant-off": "\U000F1139",
    "fire-off": "\U000F1722",
    "fire-truck": "\U000F08AB",
    "firebase": "\U000F0967",
    "firefox": "\U000F0239",
    "fireplace": "\U000F0E2E",
    "fireplace-off": "\U000F0E2F",
    "firewire": "\U000F05BE",
    "firework": "\U000F0E30",
    "firework-off": "\U000F1723",
    "fish": "\U000F023A",
    "fish-off": "\U000F13F3",
    "fishbowl": "\U000F0EF3",
    "fishbowl-outline": "\U000F0EF4",
    "fit-to-page": "\U000F0EF5",
    "fit-to-page-outline": "\U000F0EF6",
    "fit-to-screen": "\U000F18F4",
    "fit-to-screen-outline": "\U000F18F5",
    "flag": "\U000F023B",
    "flag-checkered": "\U000F023C",
    "flag-minus": "\U000F0B99",
    "flag-minus-outline": "\U000F10B2",
    "flag-off": "\U000F18EE",
    "flag-off-outline": "\U000F18EF",
    "flag-outline": "\U000F023D",
    "flag-plus": "\U000F0B9A",
    "flag-plus-outline": "\U000F10B3",
    "flag-remove": "\U000F0B9B",
    "flag-remove-outline": "\U000F10B4",
    "flag-triangle": "\U000F023F",
    "flag-variant": "\U000F0240",
    "flag-variant-outline": "\U000F023E",
    "flare": "\U000F0D72",
    "flash": "\U000F0241",
    "flash-alert": "\U000F0EF7",
    "flash-alert-outline": "\U000F0EF8",
    "flash-auto": "\U000F0242",
    "flash-off": "\U000F0243",
    "flash-off-outline": "\U000F1B45",
    "flash-outline": "\U000F06D5",
    "flash-red-eye": "\U000F067B",
    "flash-triangle": "\U000F1B1D",
    "flash-triangle-outline": "\U000F1B1E",
    "flashlight": "\U000F0244",
    "flashlight-off": "\U000F0245",
    "flask": "\U000F0093",
    "flask-empty": "\U000F0094",
    "flask-empty-minus": "\U000F123A",
    "flask-empty-minus-outline": "\U000F123B",
    "flask-empty-off": "\U000F13F4",
    "flask-empty-off-outline": "\U000F13F5",
    "flask-empty-outline": "\U000F0095",
    "flask-empty-plus": "\U000F123C",
    "flask-empty-plus-outline": "\U000F123D",
    "flask-empty-remove": "\U000F123E",
    "flask-empty-remove-outline": "\U000F123F",
    "flask-minus": "\U000F1240",
    "flask-minus-outline": "\U000F1241",
    "flask-off": "\U000F13F6",
    "flask-off-outline": "\U000F13F7",
    "flask-outline": "\U000F0096",
    "flask-plus": "\U000F1242",
    "flask-plus-outline": "\U000F1243",
    "flask-remove": "\U000F1244",
    "flask-remove-outline": "\U000F1245",
    "flask-round-bottom": "\U000F124B",
    "flask-round-bottom-empty": "\U000F124C",
    "flask-round-bottom-empty-outline": "\U000F124D",
    "flask-round-bottom-outline": "\U000F124E",
    "fleur-de-lis": "\U000F1303",
    "flip-horizontal": "\U000F10E7",
    "flip-to-back": "\U000F0247",
    "flip-to-front": "\U000F0248",
    "flip-vertical": "\U000F10E8",
    "floor-lamp": "\U000F08DD",
    "floor-lamp-dual": "\U000F1040",
    "floor-lamp-dual-outline": "\U000F17CE",
    "floor-lamp-outline": "\U000F17C8",
    "floor-lamp-torchiere": "\U000F1747",
    "floor-lamp-torchiere-outline": "\U000F17D6",
    "floor-lamp-torchiere-variant": "\U000F1041",
    "floor-lamp-torchiere-variant-outline": "\U000F17CF",
    "floor-plan": "\U000F0821",
    "floppy": "\U000F0249",
    "floppy-variant": "\U000F09EF",
    "flower": "\U000F024A",
    "flower-outline": "\U000F09F0",
    "flower-pollen": "\U000F1885",
    "flower-pollen-outline": "\U000F1886",
    "flower-poppy": "\U000F0D08",
    "flower-tulip": "\U000F09F1",
    "flower-tulip-outline": "\U000F09F2",
    "focus-auto": "\U000F0F4E",
    "focus-field": "\U000F0F4F",
    "focus-field-horizontal": "\U000F0F50",
    "focus-field-vertical": "\U000F0F51",
    "folder": "\U000F024B",
    "folder-account": "\U000F024C",
    "folder-account-outline": "\U000F0B9C",
    "folder-alert": "\U000F0DCC",
    "folder-alert-outline": "\U000F0DCD",
    "folder-arrow-down": "\U000F19E8",
    "folder-arrow-down-outline": "\U000F19E9",
    "folder-arrow-left": "\U000F19EA",
    "folder-arrow-left-outline": "\U000F19EB",
    "folder-arrow-left-right": "\U000F19EC",
    "folder-arrow-left-right-outline": "\U000F19ED",
    "folder-arrow-right": "\U000F19EE",
    "folder-arrow-right-outline": "\U000F19EF",
    "folder-arrow-up": "\U000F19F0",
    "folder-arrow-up-down": "\U000F19F1",
    "folder-arrow-up-down-outline": "\U000F19F2",
    "folder-arrow-up-outline": "\U000F19F3",
    "folder-cancel": "\U000F19F4",
    "folder-cancel-outline": "\U000F19F5",
    "folder-check": "\U000F197E",
    "folder-check-outline": "\U000F197F",
    "folder-clock": "\U000F0ABA",
    "folder-clock-outline": "\U000F0ABB",
    "folder-cog": "\U000F107F",
    "folder-cog-outline": "\U000F1080",
    "folder-download": "\U000F024D",
    "folder-download-outline": "\U000F10E9",
    "folder-edit": "\U000F08DE",
    "folder-edit-outline": "\U000F0DCE",
    "folder-eye": "\U000F178A",
    "folder-eye-outline": "\U000F178B",
    "folder-file": "\U000F19F6",
    "folder-file-outline": "\U000F19F7",
    "folder-google-drive": "\U000F024E",
    "folder-heart": "\U000F10EA",
    "folder-heart-outline": "\U000F10EB",
    "folder-hidden": "\U000F179E",
    "folder-home": "\U000F10B5",
    "folder-home-outline": "\U000F10B6",
    "folder-image": "\U000F024F",
    "folder-information": "\U000F10B7",
    "folder-information-outline": "\U000F10B8",
    "folder-key": "\U000F08AC",
    "folder-key-network": "\U000F08AD",
    "folder-key-network-outline": "\U000F0C80",
    "folder-key-outline": "\U000F10EC",
    "folder-lock": "\U000F0250",
    "folder-lock-open": "\U000F0251",
    "folder-lock-open-outline": "\U000F1AA7",
    "folder-lock-outline": "\U000F1AA8",
    "folder-marker": "\U000F126D",
    "folder-marker-outline": "\U000F126E",
    "folder-minus": "\U000F1B49",
    "folder-minus-outline": "\U000F1B4A",
    "folder-move": "\U000F0252",
    "folder-move-outline": "\U000F1246",
    "folder-multiple": "\U000F0253",
    "folder-multiple-image": "\U000F0254",
    "folder-multiple-outline": "\U000F0255",
    "folder-multiple-plus": "\U000F147E",
    "folder-multiple-plus-outline": "\U000F147F",
    "folder-music": "\U000F1359",
    "folder-music-outline": "\U000F135A",
    "folder-network": "\U000F0870",
    "folder-network-outline": "\U000F0C81",
    "folder-off": "\U000F19F8",
    "folder-off-outline": "\U000F19F9",
    "folder-open": "\U000F0770",
    "folder-open-outline": "\U000F0DCF",
    "folder-outline": "\U000F0256",
    "folder-play": "\U000F19FA",
    "folder-play-outline": "\U000F19FB",
    "folder-plus": "\U000F0257",
    "folder-plus-outline": "\U000F0B9D",
    "folder-pound": "\U000F0D09",
    "folder-pound-outline": "\U000F0D0A",
    "folder-question": "\U000F19CA",
    "folder-question-outline": "\U000F19CB",
    "folder-refresh": "\U000F0749",
    "folder-refresh-outline": "\U000F0542",
    "folder-remove": "\U000F0258",
    "folder-remove-outline": "\U000F0B9E",
    "folder-search": "\U000F0968",
    "folder-search-outline": "\U000F0969",
    "folder-settings": "\U000F107D",
    "folder-settings-outline": "\U000F107E",
    "folder-star": "\U000F069D",
    "folder-star-multiple": "\U000F13D3",
    "folder-star-multiple-outline": "\U000F13D4",
    "folder-star-outline": "\U000F0B9F",
    "folder-swap": "\U000F0FB6",
    "folder-swap-outline": "\U000F0FB7",
    "folder-sync": "\U000F0D0B",
    "folder-sync-outline": "\U000F0D0C",
    "folder-table": "\U000F12E3",
    "folder-table-outline": "\U000F12E4",
    "folder-text": "\U000F0C82",
    "folder-text-outline": "\U000F0C83",
    "folder-upload": "\U000F0259",
    "folder-upload-outline": "\U000F10ED",
    "folder-wrench": "\U000F19FC",
    "folder-wrench-outline": "\U000F19FD",
    "folder-zip": "\U000F06EB",
    "folder-zip-outline": "\U000F07B9",
    "font-awesome": "\U000F003A",
    "food": "\U000F025A",
    "food-apple": "\U000F025B",
    "food-apple-outline": "\U000F0C84",
    "food-croissant": "\U000F07C8",
    "food-drumstick": "\U000F141F",
    "food-drumstick-off": "\U000F1468",
    "food-drumstick-off-outline": "\U000F1469",
    "food-drumstick-outline": "\U000F1420",
    "food-fork-drink": "\U000F05F2",
    "food-halal": "\U000F1572",
    "food-hot-dog": "\U000F184B",
    "food-kosher": "\U000F1573",
    "food-off": "\U000F05F3",
    "food-off-outline": "\U000F1915",
    "food-outline": "\U000F1916",
    "food-steak": "\U000F146A",
    "food-steak-off": "\U000F146B",
    "food-takeout-box": "\U000F1836",
    "food-takeout-box-outline": "\U000F1837",
    "food-turkey": "\U000F171C",
    "food-variant": "\U000F025C",
    "food-variant-off": "\U000F13E5",
    "foot-print": "\U000F0F52",
    "football": "\U000F025D",
    "football-australian": "\U000F025E",
    "football-helmet": "\U000F025F",
    "forest": "\U000F1897",
    "forklift": "\U000F07C9",
    "form-dropdown": "\U000F1400",
    "form-select": "\U000F1401",
    "form-textarea": "\U000F1095",
    "form-textbox": "\U000F060E",
    "form-textbox-lock": "\U000F135D",
    "form-textbox-password": "\U000F07F5",
    "format-align-bottom": "\U000F0753",
    "format-align-center": "\U000F0260",
    "format-align-justify": "\U000F0261",
    "format-align-left": "\U000F0262",
    "format-align-middle": "\U000F0754",
    "format-align-right": "\U000F0263",
    "format-align-top": "\U000F0755",
    "format-annotation-minus": "\U000F0ABC",
    "format-annotation-plus": "\U000F0646",
    "format-bold": "\U000F0264",
    "format-clear": "\U000F0265",
    "format-color-fill": "\U000F0266",
    "format-color-highlight": "\U000F0E31",
    "format-color-marker-cancel": "\U000F1313",
    "format-color-text": "\U000F069E",
    "format-columns": "\U000F08DF",
    "format-float-center": "\U000F0267",
    "format-float-left": "\U000F0268",
    "format-float-none": "\U000F0269",
    "format-float-right": "\U000F026A",
    "format-font": "\U000F06D6",
    "format-font-size-decrease": "\U000F09F3",
    "format-font-size-increase": "\U000F09F4",
    "format-header-1": "\U000F026B",
    "format-header-2": "\U000F026C",
    "format-header-3": "\U000F026D",
    "format-header-4": "\U000F026E",
    "format-header-5": "\U000F026F",
    "format-header-6": "\U000F0270",
    "format-header-decrease": "\U000F0271",
    "format-header-equal": "\U000F0272",
    "format-header-increase": "\U000F0273",
    "format-header-pound": "\U000F0274",
    "format-horizontal-align-center": "\U000F061E",
    "format-horizontal-align-left": "\U000F061F",
    "format-horizontal-align-right": "\U000F0620",
    "format-indent-decrease": "\U000F0275",
    "format-indent-increase": "\U000F0276",
    "format-italic": "\U000F0277",
    "format-letter-case": "\U000F0B34",
    "format-letter-case-lower": "\U000F0B35",
    "format-letter-case-upper": "\U000F0B36",
    "format-letter-ends-with": "\U000F0FB8",
    "format-letter-matches": "\U000F0FB9",
    "format-letter-spacing": "\U000F1956",
    "format-letter-spacing-variant": "\U000F1AFB",
    "format-letter-starts-with": "\U000F0FBA",
    "format-line-height": "\U000F1AFC",
    "format-line-spacing": "\U000F0278",
    "format-line-style": "\U000F05C8",
    "format-line-weight": "\U000F05C9",
    "format-list-bulleted": "\U000F0279",
    "format-list-bulleted-square": "\U000F0DD0",
    "format-list-bulleted-triangle": "\U000F0EB2",
    "format-list-bulleted-type": "\U000F027A",
    "format-list-checkbox": "\U000F096A",
    "format-list-checks": "\U000F0756",
    "format-list-group": "\U000F1860",
    "format-list-numbered": "\U000F027B",
    "format-list-numbered-rtl": "\U000F0D0D",
    "format-list-text": "\U000F126F",
    "format-overline": "\U000F0EB3",
    "format-page-break": "\U000F06D7",
    "format-page-split": "\U000F1917",
    "format-paint": "\U000F027C",
    "format-paragraph": "\U000F027D",
    "format-paragraph-spacing": "\U000F1AFD",
    "format-pilcrow": "\U000F06D8",
    "format-quote-close": "\U000F027E",
    "format-quote-close-outline": "\U000F11A8",
    "format-quote-open": "\U000F0757",
    "format-quote-open-outline": "\U000F11A7",
    "format-rotate-90": "\U000F06AA",
    "format-section": "\U000F069F",
    "format-size": "\U000F027F",
    "format-strikethrough": "\U000F0280",
    "format-strikethrough-variant": "\U000F0281",
    "format-subscript": "\U000F0282",
    "format-superscript": "\U000F0283",
    "format-text": "\U000F0284",
    "format-text-rotation-angle-down": "\U000F0FBB",
    "format-text-rotation-angle-up": "\U000F0FBC",
    "format-text-rotation-down": "\U000F0D73",
    "format-text-rotation-down-vertical": "\U000F0FBD",
    "format-text-rotation-none": "\U000F0D74",
    "format-text-rotation-up": "\U000F0FBE",
    "format-text-rotation-vertical": "\U000F0FBF",
    "format-text-variant": "\U000F0E32",
    "format-text-variant-outline": "\U000F150F",
    "format-text-wrapping-clip": "\U000F0D0E",
    "format-text-wrapping-overflow": "\U000F0D0F",
    "format-text-wrapping-wrap": "\U000F0D10",
    "format-textbox": "\U000F0D11",
    "format-textdirection-l-to-r": "\U000F0285",
    "format-textdirection-r-to-l": "\U000F0286",
    "format-title": "\U000F05F4",
    "format-underline": "\U000F0287",
    "format-underline-wavy": "\U000F18E9",
    "format-vertical-align-bottom": "\U000F0621",
    "format-vertical-align-center": "\U000F0622",
    "format-vertical-align-top": "\U000F0623",
    "format-wrap-inline": "\U000F0288",
    "format-wrap-square": "\U000F0289",
    "format-wrap-tight": "\U000F028A",
    "format-wrap-top-bottom": "\U000F028B",
    "forum": "\U000F028C",
    "forum-minus": "\U000F1AA9",
    "forum-minus-outline": "\U000F1AAA",
    "forum-outline": "\U000F0822",
    "forum-plus": "\U000F1AAB",
    "forum-plus-outline": "\U000F1AAC",
    "forum-remove": "\U000F1AAD",
    "forum-remove-outline": "\U000F1AAE",
    "forward": "\U000F028D",
    "forwardburger": "\U000F0D75",
    "fountain": "\U000F096B",
    "fountain-pen": "\U000F0D12",
    "fountain-pen-tip": "\U000F0D13",
    "fraction-one-half": "\U000F1992",
    "freebsd": "\U000F08E0",
    "french-fries": "\U000F1957",
    "frequently-asked-questions": "\U000F0EB4",
    "fridge": "\U000F0290",
    "fridge-alert": "\U000F11B1",
    "fridge-alert-outline": "\U000F11B2",
    "fridge-bottom": "\U000F0292",
    "fridge-industrial": "\U000F15EE",
    "fridge-industrial-alert": "\U000F15EF",
    "fridge-industrial-alert-outline": "\U000F15F0",
    "fridge-industrial-off": "\U000F15F1",
    "fridge-industrial-off-outline": "\U000F15F2",
    "fridge-industrial-outline": "\U000F15F3",
    "fridge-off": "\U000F11AF",
    "fridge-off-outline": "\U000F11B0",
    "fridge-outline": "\U000F028F",
    "fridge-top": "\U000F0291",
    "fridge-variant": "\U000F15F4",
    "fridge-variant-alert": "\U000F15F5",
    "fridge-variant-alert-outline": "\U000F15F6",
    "fridge-variant-off": "\U000F15F7",
    "fridge-variant-off-outline": "\U000F15F8",
    "fridge-variant-outline": "\U000F15F9",
    "fruit-cherries": "\U000F1042",
    "fruit-cherries-off": "\U000F13F8",
    "fruit-citrus": "\U000F1043",
    "fruit-citrus-off": "\U000F13F9",
    "fruit-grapes": "\U000F1044",
    "fruit-grapes-outline": "\U000F1045",
    "fruit-pear": "\U000F1A0E",
    "fruit-pineapple": "\U000F1046",
    "fruit-watermelon": "\U000F1047",
    "fuel": "\U000F07CA",
    "fuel-cell": "\U000F18B5",
    "fullscreen": "\U000F0293",
    "fullscreen-exit": "\U000F0294",
    "function": "\U000F0295",
    "function-variant": "\U000F0871",
    "furigana-horizontal": "\U000F1081",
    "furigana-vertical": "\U000F1082",
    "fuse": "\U000F0C85",
    "fuse-alert": "\U000F142D",
    "fuse-blade": "\U000F0C86",
    "fuse-off": "\U000F142C",
    "gamepad": "\U000F0296",
    "gamepad-circle": "\U000F0E33",
    "gamepad-circle-down": "\U000F0E34",
    "gamepad-circle-left": "\U000F0E35",
    "gamepad-circle-outline": "\U000F0E36",
    "gamepad-circle-right": "\U000F0E37",
    "gamepad-circle-up": "\U000F0E38",
    "gamepad-down": "\U000F0E39",
    "gamepad-left": "\U000F0E3A",
    "gamepad-outline": "\U000F1919",
    "gamepad-right": "\U000F0E3B",
    "gamepad-round": "\U000F0E3C",
    "gamepad-round-down": "\U000F0E3D",
    "gamepad-round-left": "\U000F0E3E",
    "gamepad-round-outline": "\U000F0E3F",
    "gamepad-round-right": "\U000F0E40",
    "gamepad-round-up": "\U000F0E41",
    "gamepad-square": "\U000F0EB5",
    "gamepad-square-outline": "\U000F0EB6",
    "gamepad-up": "\U000F0E42",
    "gamepad-variant": "\U000F0297",
    "gamepad-variant-outline": "\U000F0EB7",
    "gamma": "\U000F10EE",
    "gantry-crane": "\U000F0DD1",
    "garage": "\U000F06D9",
    "garage-alert": "\U000F0872",
    "garage-alert-variant": "\U000F12D5",
    "garage-lock": "\U000F17FB",
    "garage-open": "\U000F06DA",
    "garage-open-variant": "\U000F12D4",
    "garage-variant": "\U000F12D3",
    "garage-variant-lock": "\U000F17FC",
    "gas-burner": "\U000F1A1B",
    "gas-cylinder": "\U000F0647",
    "gas-station": "\U000F0298",
    "gas-station-off": "\U000F1409",
    "gas-station-off-outline": "\U000F140A",
    "gas-station-outline": "\U000F0EB8",
    "gate": "\U000F0299",
    "gate-alert": "\U000F17F8",
    "gate-and": "\U000F08E1",
    "gate-arrow-left": "\U000F17F7",
    "gate-arrow-right": "\U000F1169",
    "gate-buffer": "\U000F1AFE",
    "gate-nand": "\U000F08E2",
    "gate-nor": "\U000F08E3",
    "gate-not": "\U000F08E4",
    "gate-open": "\U000F116A",
    "gate-or": "\U000F08E5",
    "gate-xnor": "\U000F08E6",
    "gate-xor": "\U000F08E7",
    "gatsby": "\U000F0E43",
    "gauge": "\U000F029A",
    "gauge-empty": "\U000F0873",
    "gauge-full": "\U000F0874",
    "gauge-low": "\U000F0875",
    "gavel": "\U000F029B",
    "gender-female": "\U000F029C",
    "gender-male": "\U000F029D",
    "gender-male-female": "\U000F029E",
    "gender-male-female-variant": "\U000F113F",
    "gender-non-binary": "\U000F1140",
    "gender-transgender": "\U000F029F",
    "gentoo": "\U000F08E8",
    "gesture": "\U000F07CB",
    "gesture-double-tap": "\U000F073C",
    "gesture-pinch": "\U000F0ABD",
    "gesture-spread": "\U000F0ABE",
    "gesture-swipe": "\U000F0D76",
    "gesture-swipe-down": "\U000F073D",
    "gesture-swipe-horizontal": "\U000F0ABF",
    "gesture-swipe-left": "\U000F073E",
    "gesture-swipe-right": "\U000F073F",
    "gesture-swipe-up": "\U000F0740",
    "gesture-swipe-vertical": "\U000F0AC0",
    "gesture-tap": "\U000F0741",
    "gesture-tap-box": "\U000F12A9",
    "gesture-tap-button": "\U000F12A8",
    "gesture-tap-hold": "\U000F0D77",
    "gesture-two-double-tap": "\U000F0742",
    "gesture-two-tap": "\U000F0743",
    "ghost": "\U000F02A0",
    "ghost-off": "\U000F09F5",
    "ghost-off-outline": "\U000F165C",
    "ghost-outline": "\U000F165D",
    "gift": "\U000F0E44",
    "gift-off": "\U000F16EF",
    "gift-off-outline": "\U000F16F0",
    "gift-open": "\U000F16F1",
    "gift-open-outline": "\U000F16F2",
    "gift-outline": "\U000F02A1",
    "git": "\U000F02A2",
    "github": "\U000F02A4",
    "gitlab": "\U000F0BA0",
    "glass-cocktail": "\U000F0356",
    "glass-cocktail-off": "\U000F15E6",
    "glass-flute": "\U000F02A5",
    "glass-fragile": "\U000F1873",
    "glass-mug": "\U000F02A6",
    "glass-mug-off": "\U000F15E7",
    "glass-mug-variant": "\U000F1116",
    "glass-mug-variant-off": "\U000F15E8",
    "glass-pint-outline": "\U000F130D",
    "glass-stange": "\U000F02A7",
    "glass-tulip": "\U000F02A8",
    "glass-wine": "\U000F0876",
    "glasses": "\U000F02AA",
    "globe-light": "\U000F12D7",
    "globe-model": "\U000F08E9",
    "gmail": "\U000F02AB",
    "gnome": "\U000F02AC",
    "go-kart": "\U000F0D79",
    "go-kart-track": "\U000F0D7A",
    "gog": "\U000F0BA1",
    "gold": "\U000F124F",
    "golf": "\U000F0823",
    "golf-cart": "\U000F11A4",
    "golf-tee": "\U000F1083",
    "gondola": "\U000F0686",
    "goodreads": "\U000F0D7B",
    "google": "\U000F02AD",
    "google-ads": "\U000F0C87",
    "google-analytics": "\U000F07CC",
    "google-assistant": "\U000F07CD",
    "google-cardboard": "\U000F02AE",
    "google-chrome": "\U000F02AF",
    "google-circles": "\U000F02B0",
    "google-circles-communities": "\U000F02B1",
    "google-circles-extended": "\U000F02B2",
    "google-circles-group": "\U000F02B3",
    "google-classroom": "\U000F02C0",
    "google-cloud": "\U000F11F6",
    "google-controller": "\U000F02B4",
    "google-controller-off": "\U000F02B5",
    "google-downasaur": "\U000F1362",
    "google-drive": "\U000F02B6",
    "google-earth": "\U000F02B7",
    "google-fit": "\U000F096C",
    "google-glass": "\U000F02B8",
    "google-hangouts": "\U000F02C9",
    "google-home": "\U000F0824",
    "google-keep": "\U000F06DC",
    "google-lens": "\U000F09F6",
    "google-maps": "\U000F05F5",
    "google-my-business": "\U000F1048",
    "google-nearby": "\U000F02B9",
    "google-play": "\U000F02BC",
    "google-plus": "\U000F02BD",
    "google-podcast": "\U000F0EB9",
    "google-spreadsheet": "\U000F09F7",
    "google-street-view": "\U000F0C88",
    "google-translate": "\U000F02BF",
    "gradient-horizontal": "\U000F174A",
    "gradient-vertical": "\U000F06A0",
    "grain": "\U000F0D7C",
    "graph": "\U000F1049",
    "graph-outline": "\U000F104A",
    "graphql": "\U000F0877",
    "grass": "\U000F1510",
    "grave-stone": "\U000F0BA2",
    "grease-pencil": "\U000F0648",
    "greater-than": "\U000F096D",
    "greater-than-or-equal": "\U000F096E",
    "greenhouse": "\U000F002D",
    "grid": "\U000F02C1",
    "grid-large": "\U000F0758",
    "grid-off": "\U000F02C2",
    "grill": "\U000F0E45",
    "grill-outline": "\U000F118A",
    "group": "\U000F02C3",
    "guitar-acoustic": "\U000F0771",
    "guitar-electric": "\U000F02C4",
    "guitar-pick": "\U000F02C5",
    "guitar-pick-outline": "\U000F02C6",
    "guy-fawkes-mask": "\U000F0825",
    "gymnastics": "\U000F1A41",
    "hail": "\U000F0AC1",
    "hair-dryer": "\U000F10EF",
    "hair-dryer-outline": "\U000F10F0",
    "halloween": "\U000F0BA3",
    "hamburger": "\U000F0685",
    "hamburger-check": "\U000F1776",
    "hamburger-minus": "\U000F1777",
    "hamburger-off": "\U000F1778",
    "hamburger-plus": "\U000F1779",
    "hamburger-remove": "\U000F177A",
    "hammer": "\U000F08EA",
    "hammer-screwdriver": "\U000F1322",
    "hammer-sickle": "\U000F1887",
    "hammer-wrench": "\U000F1323",
    "hand-back-left": "\U000F0E46",
    "hand-back-left-off": "\U000F1830",
    "hand-back-left-off-outline": "\U000F1832",
    "hand-back-left-outline": "\U000F182C",
    "hand-back-right": "\U000F0E47",
    "hand-back-right-off": "\U000F1831",
    "hand-back-right-off-outline": "\U000F1833",
    "hand-back-right-outline": "\U000F182D",
    "hand-clap": "\U000F194B",
    "hand-clap-off": "\U000F1A42",
    "hand-coin": "\U000F188F",
    "hand-coin-outline": "\U000F1890",
    "hand-extended": "\U000F18B6",
    "hand-extended-outline": "\U000F18B7",
    "hand-front-left": "\U000F182B",
    "hand-front-left-outline": "\U000F182E",
    "hand-front-right": "\U000F0A4F",
    "hand-front-right-outline": "\U000F182F",
    "hand-heart": "\U000F10F1",
    "hand-heart-outline": "\U000F157E",
    "hand-okay": "\U000F0A50",
    "hand-peace": "\U000F0A51",
    "hand-peace-variant": "\U000F0A52",
    "hand-pointing-down": "\U000F0A53",
    "hand-pointing-left": "\U000F0A54",
    "hand-pointing-right": "\U000F02C7",
    "hand-pointing-up": "\U000F0A55",
    "hand-saw": "\U000F0E48",
    "hand-wash": "\U000F157F",
    "hand-wash-outline": "\U000F1580",
    "hand-water": "\U000F139F",
    "hand-wave": "\U000F1821",
    "hand-wave-outline": "\U000F1822",
    "handball": "\U000F0F53",
    "handcuffs": "\U000F113E",
    "hands-pray": "\U000F0579",
    "handshake": "\U000F1218",
    "handshake-outline": "\U000F15A1",
    "hanger": "\U000F02C8",
    "hard-hat": "\U000F096F",
    "harddisk": "\U000F02CA",
    "harddisk-plus": "\U000F104B",
    "harddisk-remove": "\U000F104C",
    "hat-fedora": "\U000F0BA4",
    "hazard-lights": "\U000F0C89",
    "hdr": "\U000F0D7D",
    "hdr-off": "\U000F0D7E",
    "head": "\U000F135E",
    "head-alert": "\U000F1338",
    "head-alert-outline": "\U000F1339",
    "head-check": "\U000F133A",
    "head-check-outline": "\U000F133B",
    "head-cog": "\U000F133C",
    "head-cog-outline": "\U000F133D",
    "head-dots-horizontal": "\U000F133E",
    "head-dots-horizontal-outline": "\U000F133F",
    "head-flash": "\U000F1340",
    "head-flash-outline": "\U000F1341",
    "head-heart": "\U000F1342",
    "head-heart-outline": "\U000F1343",
    "head-lightbulb": "\U000F1344",
    "head-lightbulb-outline": "\U000F1345",
    "head-minus": "\U000F1346",
    "head-minus-outline": "\U000F1347",
    "head-outline": "\U000F135F",
    "head-plus": "\U000F1348",
    "head-plus-outline": "\U000F1349",
    "head-question": "\U000F134A",
    "head-question-outline": "\U000F134B",
    "head-remove": "\U000F134C",
    "head-remove-outline": "\U000F134D",
    "head-snowflake": "\U000F134E",
    "head-snowflake-outline": "\U000F134F",
    "head-sync": "\U000F1350",
    "head-sync-outline": "\U000F1351",
    "headphones": "\U000F02CB",
    "headphones-bluetooth": "\U000F0970",
    "headphones-box": "\U000F02CC",
    "headphones-off": "\U000F07CE",
    "headphones-settings": "\U000F02CD",
    "headset": "\U000F02CE",
    "headset-dock": "\U000F02CF",
    "headset-off": "\U000F02D0",
    "heart": "\U000F02D1",
    "heart-box": "\U000F02D2",
    "heart-box-outline": "\U000F02D3",
    "heart-broken": "\U000F02D4",
    "heart-broken-outline": "\U000F0D14",
    "heart-circle": "\U000F0971",
    "heart-circle-outline": "\U000F0972",
    "heart-cog": "\U000F1663",
    "heart-cog-outline": "\U000F1664",
    "heart-flash": "\U000F0EF9",
    "heart-half": "\U000F06DF",
    "heart-half-full": "\U000F06DE",
    "heart-half-outline": "\U000F06E0",
    "heart-minus": "\U000F142F",
    "heart-minus-outline": "\U000F1432",
    "heart-multiple": "\U000F0A56",
    "heart-multiple-outline": "\U000F0A57",
    "heart-off": "\U000F0759",
    "heart-off-outline": "\U000F1434",
    "heart-outline": "\U000F02D5",
    "heart-plus": "\U000F142E",
    "heart-plus-outline": "\U000F1431",
    "heart-pulse": "\U000F05F6",
    "heart-remove": "\U000F1430",
    "heart-remove-outline": "\U000F1433",
    "heart-settings": "\U000F1665",
    "heart-settings-outline": "\U000F1666",
    "heat-pump": "\U000F1A43",
    "heat-pump-outline": "\U000F1A44",
    "heat-wave": "\U000F1A45",
    "heating-coil": "\U000F1AAF",
    "helicopter": "\U000F0AC2",
    "help": "\U000F02D6",
    "help-box": "\U000F078B",
    "help-circle": "\U000F02D7",
    "help-circle-outline": "\U000F0625",
    "help-network": "\U000F06F5",
    "help-network-outline": "\U000F0C8A",
    "help-rhombus": "\U000F0BA5",
    "help-rhombus-outline": "\U000F0BA6",
    "hexadecimal": "\U000F12A7",
    "hexagon": "\U000F02D8",
    "hexagon-multiple": "\U000F06E1",
    "hexagon-multiple-outline": "\U000F10F2",
    "hexagon-outline": "\U000F02D9",
    "hexagon-slice-1": "\U000F0AC3",
    "hexagon-slice-2": "\U000F0AC4",
    "hexagon-slice-3": "\U000F0AC5",
    "hexagon-slice-4": "\U000F0AC6",
    "hexagon-slice-5": "\U000F0AC7",
    "hexagon-slice-6": "\U000F0AC8",
    "hexagram": "\U000F0AC9",
    "hexagram-outline": "\U000F0ACA",
    "high-definition": "\U000F07CF",
    "high-definition-box": "\U000F0878",
    "highway": "\U000F05F7",
    "hiking": "\U000F0D7F",
    "history": "\U000F02DA",
    "hockey-puck": "\U000F0879",
    "hockey-sticks": "\U000F087A",
    "hololens": "\U000F02DB",
    "home": "\U000F02DC",
    "home-account": "\U000F0826",
    "home-alert": "\U000F087B",
    "home-alert-outline": "\U000F15D0",
    "home-analytics": "\U000F0EBA",
    "home-assistant": "\U000F07D0",
    "home-automation": "\U000F07D1",
    "home-battery": "\U000F1901",
    "home-battery-outline": "\U000F1902",
    "home-circle": "\U000F07D2",
    "home-circle-outline": "\U000F104D",
    "home-city": "\U000F0D15",
    "home-city-outline": "\U000F0D16",
    "home-clock": "\U000F1A12",
    "home-clock-outline": "\U000F1A13",
    "home-edit": "\U000F1159",
    "home-edit-outline": "\U000F115A",
    "home-export-outline": "\U000F0F9B",
    "home-flood": "\U000F0EFA",
    "home-floor-0": "\U000F0DD2",
    "home-floor-1": "\U000F0D80",
    "home-floor-2": "\U000F0D81",
    "home-floor-3": "\U000F0D82",
    "home-floor-a": "\U000F0D83",
    "home-floor-b": "\U000F0D84",
    "home-floor-g": "\U000F0D85",
    "home-floor-l": "\U000F0D86",
    "home-floor-negative-1": "\U000F0DD3",
    "home-group": "\U000F0DD4",
    "home-group-minus": "\U000F19C1",
    "home-group-plus": "\U000F19C0",
    "home-group-remove": "\U000F19C2",
    "home-heart": "\U000F0827",
    "home-import-outline": "\U000F0F9C",
    "home-lightbulb": "\U000F1251",
    "home-lightbulb-outline": "\U000F1252",
    "home-lightning-bolt": "\U000F1903",
    "home-lightning-bolt-outline": "\U000F1904",
    "home-lock": "\U000F08EB",
    "home-lock-open": "\U000F08EC",
    "home-map-marker": "\U000F05F8",
    "home-minus": "\U000F0974",
    "home-minus-outline": "\U000F13D5",
    "home-modern": "\U000F02DD",
    "home-off": "\U000F1A46",
    "home-off-outline": "\U000F1A47",
    "home-outline": "\U000F06A1",
    "home-plus": "\U000F0975",
    "home-plus-outline": "\U000F13D6",
    "home-remove": "\U000F1247",
    "home-remove-outline": "\U000F13D7",
    "home-roof": "\U000F112B",
    "home-search": "\U000F13B0",
    "home-search-outline": "\U000F13B1",
    "home-switch": "\U000F1794",
    "home-switch-outline": "\U000F1795",
    "home-thermometer": "\U000F0F54",
    "home-thermometer-outline": "\U000F0F55",
    "home-variant": "\U000F02DE",
    "home-variant-outline": "\U000F0BA7",
    "hook": "\U000F06E2",
    "hook-off": "\U000F06E3",
    "hoop-house": "\U000F0E56",
    "hops": "\U000F02DF",
    "horizontal-rotate-clockwise": "\U000F10F3",
    "horizontal-rotate-counterclockwise": "\U000F10F4",
    "horse": "\U000F15BF",
    "horse-human": "\U000F15C0",
    "horse-variant": "\U000F15C1",
    "horse-variant-fast": "\U000F186E",
    "horseshoe": "\U000F0A58",
    "hospital": "\U000F0FF6",
    "hospital-box": "\U000F02E0",
    "hospital-box-outline": "\U000F0FF7",
    "hospital-building": "\U000F02E1",
    "hospital-marker": "\U000F02E2",
    "hot-tub": "\U000F0828",
    "hours-24": "\U000F1478",
    "hubspot": "\U000F0D17",
    "hulu": "\U000F0829",
    "human": "\U000F02E6",
    "human-baby-changing-table": "\U000F138B",
    "human-cane": "\U000F1581",
    "human-capacity-decrease": "\U000F159B",
    "human-capacity-increase": "\U000F159C",
    "human-child": "\U000F02E7",
    "human-dolly": "\U000F1980",
    "human-edit": "\U000F14E8",
    "human-female": "\U000F0649",
    "human-female-boy": "\U000F0A59",
    "human-female-dance": "\U000F15C9",
    "human-female-female": "\U000F0A5A",
    "human-female-girl": "\U000F0A5B",
    "human-greeting": "\U000F17C4",
    "human-greeting-proximity": "\U000F159D",
    "human-greeting-variant": "\U000F064A",
    "human-handsdown": "\U000F064B",
    "human-handsup": "\U000F064C",
    "human-male": "\U000F064D",
    "human-male-board": "\U000F0890",
    "human-male-board-poll": "\U000F0846",
    "human-male-boy": "\U000F0A5C",
    "human-male-child": "\U000F138C",
    "human-male-female": "\U000F02E8",
    "human-male-female-child": "\U000F1823",
    "human-male-girl": "\U000F0A5D",
    "human-male-height": "\U000F0EFB",
    "human-male-height-variant": "\U000F0EFC",
    "human-male-male": "\U000F0A5E",
    "human-non-binary": "\U000F1848",
    "human-pregnant": "\U000F05CF",
    "human-queue": "\U000F1571",
    "human-scooter": "\U000F11E9",
    "human-wheelchair": "\U000F138D",
    "human-white-cane": "\U000F1981",
    "humble-bundle": "\U000F0744",
    "hvac": "\U000F1352",
    "hvac-off": "\U000F159E",
    "hydraulic-oil-level": "\U000F1324",
    "hydraulic-oil-temperature": "\U000F1325",
    "hydro-power": "\U000F12E5",
    "hydrogen-station": "\U000F1894",
    "ice-cream": "\U000F082A",
    "ice-cream-off": "\U000F0E52",
    "ice-pop": "\U000F0EFD",
    "id-card": "\U000F0FC0",
    "identifier": "\U000F0EFE",
    "ideogram-cjk": "\U000F1331",
    "ideogram-cjk-variant": "\U000F1332",
    "image": "\U000F02E9",
    "image-album": "\U000F02EA",
    "image-area": "\U000F02EB",
    "image-area-close": "\U000F02EC",
    "image-auto-adjust": "\U000F0FC1",
    "image-broken": "\U000F02ED",
    "image-broken-variant": "\U000F02EE",
    "image-check": "\U000F1B25",
    "image-check-outline": "\U000F1B26",
    "image-edit": "\U000F11E3",
    "image-edit-outline": "\U000F11E4",
    "image-filter-black-white": "\U000F02F0",
    "image-filter-center-focus": "\U000F02F1",
    "image-filter-center-focus-strong": "\U000F0EFF",
    "image-filter-center-focus-strong-outline": "\U000F0F00",
    "image-filter-center-focus-weak": "\U000F02F2",
    "image-filter-drama": "\U000F02F3",
    "image-filter-frames": "\U000F02F4",
    "image-filter-hdr": "\U000F02F5",
    "image-filter-none": "\U000F02F6",
    "image-filter-tilt-shift": "\U000F02F7",
    "image-filter-vintage": "\U000F02F8",
    "image-frame": "\U000F0E49",
    "image-lock": "\U000F1AB0",
    "image-lock-outline": "\U000F1AB1",
    "image-marker": "\U000F177B",
    "image-marker-outline": "\U000F177C",
    "image-minus": "\U000F1419",
    "image-minus-outline": "\U000F1B47",
    "image-move": "\U000F09F8",
    "image-multiple": "\U000F02F9",
    "image-multiple-outline": "\U000F02EF",
    "image-off": "\U000F082B",
    "image-off-outline": "\U000F11D1",
    "image-outline": "\U000F0976",
    "image-plus": "\U000F087C",
    "image-plus-outline": "\U000F1B46",
    "image-refresh": "\U000F19FE",
    "image-refresh-outline": "\U000F19FF",
    "image-remove": "\U000F1418",
    "image-remove-outline": "\U000F1B48",
    "image-search": "\U000F0977",
    "image-search-outline": "\U000F0978",
    "image-size-select-actual": "\U000F0C8D",
    "image-size-select-large": "\U000F0C8E",
    "image-size-select-small": "\U000F0C8F",
    "image-sync": "\U000F1A00",
    "image-sync-outline": "\U000F1A01",
    "image-text": "\U000F160D",
    "import": "\U000F02FA",
    "inbox": "\U000F0687",
    "inbox-arrow-down": "\U000F02FB",
    "inbox-arrow-down-outline": "\U000F1270",
    "inbox-arrow-up": "\U000F03D1",
    "inbox-arrow-up-outline": "\U000F1271",
    "inbox-full": "\U000F1272",
    "inbox-full-outline": "\U000F1273",
    "inbox-multiple": "\U000F08B0",
    "inbox-multiple-outline": "\U000F0BA8",
    "inbox-outline": "\U000F1274",
    "inbox-remove": "\U000F159F",
    "inbox-remove-outline": "\U000F15A0",
    "incognito": "\U000F05F9",
    "incognito-circle": "\U000F1421",
    "incognito-circle-off": "\U000F1422",
    "incognito-off": "\U000F0075",
    "induction": "\U000F184C",
    "infinity": "\U000F06E4",
    "information": "\U000F02FC",
    "information-off": "\U000F178C",
    "information-off-outline": "\U000F178D",
    "information-outline": "\U000F02FD",
    "information-variant": "\U000F064E",
    "instagram": "\U000F02FE",
    "instrument-triangle": "\U000F104E",
    "integrated-circuit-chip": "\U000F1913",
    "invert-colors": "\U000F0301",
    "invert-colors-off": "\U000F0E4A",
    "iobroker": "\U000F12E8",
    "ip": "\U000F0A5F",
    "ip-network": "\U000F0A60",
    "ip-network-outline": "\U000F0C90",
    "ip-outline": "\U000F1982",
    "ipod": "\U000F0C91",
    "iron": "\U000F1824",
    "iron-board": "\U000F1838",
    "iron-outline": "\U000F1825",
    "island": "\U000F104F",
    "iv-bag": "\U000F10B9",
    "jabber": "\U000F0DD5",
    "jeepney": "\U000F0302",
    "jellyfish": "\U000F0F01",
    "jellyfish-outline": "\U000F0F02",
    "jira": "\U000F0303",
    "jquery": "\U000F087D",
    "jsfiddle": "\U000F0304",
    "jump-rope": "\U000F12FF",
    "kabaddi": "\U000F0D87",
    "kangaroo": "\U000F1558",
    "karate": "\U000F082C",
    "kayaking": "\U000F08AF",
    "keg": "\U000F0305",
    "kettle": "\U000F05FA",
    "kettle-alert": "\U000F1317",
    "kettle-alert-outline": "\U000F1318",
    "kettle-off": "\U000F131B",
    "kettle-off-outline": "\U000F131C",
    "kettle-outline": "\U000F0F56",
    "kettle-pour-over": "\U000F173C",
    "kettle-steam": "\U000F1319",
    "kettle-steam-outline": "\U000F131A",
    "kettlebell": "\U000F1300",
    "key": "\U000F0306",
    "key-alert": "\U000F1983",
    "key-alert-outline": "\U000F1984",
    "key-arrow-right": "\U000F1312",
    "key-chain": "\U000F1574",
    "key-chain-variant": "\U000F1575",
    "key-change": "\U000F0307",
    "key-link": "\U000F119F",
    "key-minus": "\U000F0308",
    "key-outline": "\U000F0DD6",
    "key-plus": "\U000F0309",
    "key-remove": "\U000F030A",
    "key-star": "\U000F119E",
    "key-variant": "\U000F030B",
    "key-wireless": "\U000F0FC2",
    "keyboard": "\U000F030C",
    "keyboard-backspace": "\U000F030D",
    "keyboard-caps": "\U000F030E",
    "keyboard-close": "\U000F030F",
    "keyboard-esc": "\U000F12B7",
    "keyboard-f1": "\U000F12AB",
    "keyboard-f10": "\U000F12B4",
    "keyboard-f11": "\U000F12B5",
    "keyboard-f12": "\U000F12B6",
    "keyboard-f2": "\U000F12AC",
    "keyboard-f3": "\U000F12AD",
    "keyboard-f4": "\U000F12AE",
    "keyboard-f5": "\U000F12AF",
    "keyboard-f6": "\U000F12B0",
    "keyboard-f7": "\U000F12B1",
    "keyboard-f8": "\U000F12B2",
    "keyboard-f9": "\U000F12B3",
    "keyboard-off": "\U000F0310",
    "keyboard-off-outline": "\U000F0E4B",
    "keyboard-outline": "\U000F097B",
    "keyboard-return": "\U000F0311",
    "keyboard-settings": "\U000F09F9",
    "keyboard-settings-outline": "\U000F09FA",
    "keyboard-space": "\U000F1050",
    "keyboard-tab": "\U000F0312",
    "keyboard-tab-reverse": "\U000F0325",
    "keyboard-variant": "\U000F0313",
    "khanda": "\U000F10FD",
    "kickstarter": "\U000F0745",
    "kite": "\U000F1985",
    "kite-outline": "\U000F1986",
    "kitesurfing": "\U000F1744",
    "klingon": "\U000F135B",
    "knife": "\U000F09FB",
    "knife-military": "\U000F09FC",
    "koala": "\U000F173F",
    "kodi": "\U000F0314",
    "kubernetes": "\U000F10FE",
    "label": "\U000F0315",
    "label-multiple": "\U000F1375",
    "label-multiple-outline": "\U000F1376",
    "label-off": "\U000F0ACB",
    "label-off-outline": "\U000F0ACC",
    "label-outline": "\U000F0316",
    "label-percent": "\U000F12EA",
    "label-percent-outline": "\U000F12EB",
    "label-variant": "\U000F0ACD",
    "label-variant-outline": "\U000F0ACE",
    "ladder": "\U000F15A2",
    "ladybug": "\U000F082D",
    "lambda": "\U000F0627",
    "lamp": "\U000F06B5",
    "lamp-outline": "\U000F17D0",
    "lamps": "\U000F1576",
    "lamps-outline": "\U000F17D1",
    "lan": "\U000F0317",
    "lan-check": "\U000F12AA",
    "lan-connect": "\U000F0318",
    "lan-disconnect": "\U000F0319",
    "lan-pending": "\U000F031A",
    "land-fields": "\U000F1AB2",
    "land-plots": "\U000F1AB3",
    "land-plots-circle": "\U000F1AB4",
    "land-plots-circle-variant": "\U000F1AB5",
    "land-rows-horizontal": "\U000F1AB6",
    "land-rows-vertical": "\U000F1AB7",
    "landslide": "\U000F1A48",
    "landslide-outline": "\U000F1A49",
    "language-c": "\U000F0671",
    "language-cpp": "\U000F0672",
    "language-csharp": "\U000F031B",
    "language-css3": "\U000F031C",
    "language-fortran": "\U000F121A",
    "language-go": "\U000F07D3",
    "language-haskell": "\U000F0C92",
    "language-html5": "\U000F031D",
    "language-java": "\U000F0B37",
    "language-javascript": "\U000F031E",
    "language-kotlin": "\U000F1219",
    "language-lua": "\U000F08B1",
    "language-markdown": "\U000F0354",
    "language-markdown-outline": "\U000F0F5B",
    "language-php": "\U000F031F",
    "language-python": "\U000F0320",
    "language-r": "\U000F07D4",
    "language-ruby": "\U000F0D2D",
    "language-ruby-on-rails": "\U000F0ACF",
    "language-rust": "\U000F1617",
    "language-swift": "\U000F06E5",
    "language-typescript": "\U000F06E6",
    "language-xaml": "\U000F0673",
    "laptop": "\U000F0322",
    "laptop-account": "\U000F1A4A",
    "laptop-off": "\U000F06E7",
    "laravel": "\U000F0AD0",
    "laser-pointer": "\U000F1484",
    "lasso": "\U000F0F03",
    "lastpass": "\U000F0446",
    "latitude": "\U000F0F57",
    "launch": "\U000F0327",
    "lava-lamp": "\U000F07D5",
    "layers": "\U000F0328",
    "layers-edit": "\U000F1892",
    "layers-minus": "\U000F0E4C",
    "layers-off": "\U000F0329",
    "layers-off-outline": "\U000F09FD",
    "layers-outline": "\U000F09FE",
    "layers-plus": "\U000F0E4D",
    "layers-remove": "\U000F0E4E",
    "layers-search": "\U000F1206",
    "layers-search-outline": "\U000F1207",
    "layers-triple": "\U000F0F58",
    "layers-triple-outline": "\U000F0F59",
    "lead-pencil": "\U000F064F",
    "leaf": "\U000F032A",
    "leaf-circle": "\U000F1905",
    "leaf-circle-outline": "\U000F1906",
    "leaf-maple": "\U000F0C93",
    "leaf-maple-off": "\U000F12DA",
    "leaf-off": "\U000F12D9",
    "leak": "\U000F0DD7",
    "leak-off": "\U000F0DD8",
    "lecturn": "\U000F1AF0",
    "led-off": "\U000F032B",
    "led-on": "\U000F032C",
    "led-outline": "\U000F032D",
    "led-strip": "\U000F07D6",
    "led-strip-variant": "\U000F1051",
    "led-strip-variant-off": "\U000F1A4B",
    "led-variant-off": "\U000F032E",
    "led-variant-on": "\U000F032F",
    "led-variant-outline": "\U000F0330",
    "leek": "\U000F117D",
    "less-than": "\U000F097C",
    "less-than-or-equal": "\U000F097D",
    "library": "\U000F0331",
    "library-outline": "\U000F1A22",
    "library-shelves": "\U000F0BA9",
    "license": "\U000F0FC3",
    "lifebuoy": "\U000F087E",
    "light-flood-down": "\U000F1987",
    "light-flood-up": "\U000F1988",
    "light-recessed": "\U000F179B",
    "light-switch": "\U000F097E",
    "light-switch-off": "\U000F1A24",
    "lightbulb": "\U000F0335",
    "lightbulb-alert": "\U000F19E1",
    "lightbulb-alert-outline": "\U000F19E2",
    "lightbulb-auto": "\U000F1800",
    "lightbulb-auto-outline": "\U000F1801",
    "lightbulb-cfl": "\U000F1208",
    "lightbulb-cfl-off": "\U000F1209",
    "lightbulb-cfl-spiral": "\U000F1275",
    "lightbulb-cfl-spiral-off": "\U000F12C3",
    "lightbulb-fluorescent-tube": "\U000F1804",
    "lightbulb-fluorescent-tube-outline": "\U000F1805",
    "lightbulb-group": "\U000F1253",
    "lightbulb-group-off": "\U000F12CD",
    "lightbulb-group-off-outline": "\U000F12CE",
    "lightbulb-group-outline": "\U000F1254",
    "lightbulb-multiple": "\U000F1255",
    "lightbulb-multiple-off": "\U000F12CF",
    "lightbulb-multiple-off-outline": "\U000F12D0",
    "lightbulb-multiple-outline": "\U000F1256",
    "lightbulb-night": "\U000F1A4C",
    "lightbulb-night-outline": "\U000F1A4D",
    "lightbulb-off": "\U000F0E4F",
    "lightbulb-off-outline": "\U000F0E50",
    "lightbulb-on": "\U000F06E8",
    "lightbulb-on-10": "\U000F1A4E",
    "lightbulb-on-20": "\U000F1A4F",
    "lightbulb-on-30": "\U000F1A50",
    "lightbulb-on-40": "\U000F1A51",
    "lightbulb-on-50": "\U000F1A52",
    "lightbulb-on-60": "\U000F1A53",
    "lightbulb-on-70": "\U000F1A54",
    "lightbulb-on-80": "\U000F1A55",
    "lightbulb-on-90": "\U000F1A56",
    "lightbulb-on-outline": "\U000F06E9",
    "lightbulb-outline": "\U000F0336",
    "lightbulb-question": "\U000F19E3",
    "lightbulb-question-outline": "\U000F19E4",
    "lightbulb-spot": "\U000F17F4",
    "lightbulb-spot-off": "\U000F17F5",
    "lightbulb-variant": "\U000F1802",
    "lightbulb-variant-outline": "\U000F1803",
    "lighthouse": "\U000F09FF",
    "lighthouse-on": "\U000F0A00",
    "lightning-bolt": "\U000F140B",
    "lightning-bolt-circle": "\U000F0820",
    "lightning-bolt-outline": "\U000F140C",
    "line-scan": "\U000F0624",
    "lingerie": "\U000F1476",
    "link": "\U000F0337",
    "link-box": "\U000F0D1A",
    "link-box-outline": "\U000F0D1B",
    "link-box-variant": "\U000F0D1C",
    "link-box-variant-outline": "\U000F0D1D",
    "link-lock": "\U000F10BA",
    "link-off": "\U000F0338",
    "link-plus": "\U000F0C94",
    "link-variant": "\U000F0339",
    "link-variant-minus": "\U000F10FF",
    "link-variant-off": "\U000F033A",
    "link-variant-plus": "\U000F1100",
    "link-variant-remove": "\U000F1101",
    "linkedin": "\U000F033B",
    "linux": "\U000F033D",
    "linux-mint": "\U000F08ED",
    "lipstick": "\U000F13B5",
    "liquid-spot": "\U000F1826",
    "liquor": "\U000F191E",
    "list-status": "\U000F15AB",
    "litecoin": "\U000F0A61",
    "loading": "\U000F0772",
    "location-enter": "\U000F0FC4",
    "location-exit": "\U000F0FC5",
    "lock": "\U000F033E",
    "lock-alert": "\U000F08EE",
    "lock-alert-outline": "\U000F15D1",
    "lock-check": "\U000F139A",
    "lock-check-outline": "\U000F16A8",
    "lock-clock": "\U000F097F",
    "lock-minus": "\U000F16A9",
    "lock-minus-outline": "\U000F16AA",
    "lock-off": "\U000F1671",
    "lock-off-outline": "\U000F1672",
    "lock-open": "\U000F033F",
    "lock-open-alert": "\U000F139B",
    "lock-open-alert-outline": "\U000F15D2",
    "lock-open-check": "\U000F139C",
    "lock-open-check-outline": "\U000F16AB",
    "lock-open-minus": "\U000F16AC",
    "lock-open-minus-outline": "\U000F16AD",
    "lock-open-outline": "\U000F0340",
    "lock-open-plus": "\U000F16AE",
    "lock-open-plus-outline": "\U000F16AF",
    "lock-open-remove": "\U000F16B0",
    "lock-open-remove-outline": "\U000F16B1",
    "lock-open-variant": "\U000F0FC6",
    "lock-open-variant-outline": "\U000F0FC7",
    "lock-outline": "\U000F0341",
    "lock-pattern": "\U000F06EA",
    "lock-plus": "\U000F05FB",
    "lock-plus-outline": "\U000F16B2",
    "lock-question": "\U000F08EF",
    "lock-remove": "\U000F16B3",
    "lock-remove-outline": "\U000F16B4",
    "lock-reset": "\U000F0773",
    "lock-smart": "\U000F08B2",
    "locker": "\U000F07D7",
    "locker-multiple": "\U000F07D8",
    "login": "\U000F0342",
    "login-variant": "\U000F05FC",
    "logout": "\U000F0343",
    "logout-variant": "\U000F05FD",
    "longitude": "\U000F0F5A",
    "looks": "\U000F0344",
    "lotion": "\U000F1582",
    "lotion-outline": "\U000F1583",
    "lotion-plus": "\U000F1584",
    "lotion-plus-outline": "\U000F1585",
    "loupe": "\U000F0345",
    "lumx": "\U000F0346",
    "lungs": "\U000F1084",
    "mace": "\U000F1843",
    "magazine-pistol": "\U000F0324",
    "magazine-rifle": "\U000F0323",
    "magic-staff": "\U000F1844",
    "magnet": "\U000F0347",
    "magnet-on": "\U000F0348",
    "magnify": "\U000F0349",
    "magnify-close": "\U000F0980",
    "magnify-expand": "\U000F1874",
    "magnify-minus": "\U000F034A",
    "magnify-minus-cursor": "\U000F0A62",
    "magnify-minus-outline": "\U000F06EC",
    "magnify-plus": "\U000F034B",
    "magnify-plus-cursor": "\U000F0A63",
    "magnify-plus-outline": "\U000F06ED",
    "magnify-remove-cursor": "\U000F120C",
    "magnify-remove-outline": "\U000F120D",
    "magnify-scan": "\U000F1276",
    "mail": "\U000F0EBB",
    "mailbox": "\U000F06EE",
    "mailbox-open": "\U000F0D88",
    "mailbox-open-outline": "\U000F0D89",
    "mailbox-open-up": "\U000F0D8A",
    "mailbox-open-up-outline": "\U000F0D8B",
    "mailbox-outline": "\U000F0D8C",
    "mailbox-up": "\U000F0D8D",
    "mailbox-up-outline": "\U000F0D8E",
    "manjaro": "\U000F160A",
    "map": "\U000F034D",
    "map-check": "\U000F0EBC",
    "map-check-outline": "\U000F0EBD",
    "map-clock": "\U000F0D1E",
    "map-clock-outline": "\U000F0D1F",
    "map-legend": "\U000F0A01",
    "map-marker": "\U000F034E",
    "map-marker-account": "\U000F18E3",
    "map-marker-account-outline": "\U000F18E4",
    "map-marker-alert": "\U000F0F05",
    "map-marker-alert-outline": "\U000F0F06",
    "map-marker-check": "\U000F0C95",
    "map-marker-check-outline": "\U000F12FB",
    "map-marker-circle": "\U000F034F",
    "map-marker-distance": "\U000F08F0",
    "map-marker-down": "\U000F1102",
    "map-marker-left": "\U000F12DB",
    "map-marker-left-outline": "\U000F12DD",
    "map-marker-minus": "\U000F0650",
    "map-marker-minus-outline": "\U000F12F9",
    "map-marker-multiple": "\U000F0350",
    "map-marker-multiple-outline": "\U000F1277",
    "map-marker-off": "\U000F0351",
    "map-marker-off-outline": "\U000F12FD",
    "map-marker-outline": "\U000F07D9",
    "map-marker-path": "\U000F0D20",
    "map-marker-plus": "\U000F0651",
    "map-marker-plus-outline": "\U000F12F8",
    "map-marker-question": "\U000F0F07",
    "map-marker-question-outline": "\U000F0F08",
    "map-marker-radius": "\U000F0352",
    "map-marker-radius-outline": "\U000F12FC",
    "map-marker-remove": "\U000F0F09",
    "map-marker-remove-outline": "\U000F12FA",
    "map-marker-remove-variant": "\U000F0F0A",
    "map-marker-right": "\U000F12DC",
    "map-marker-right-outline": "\U000F12DE",
    "map-marker-star": "\U000F1608",
    "map-marker-star-outline": "\U000F1609",
    "map-marker-up": "\U000F1103",
    "map-minus": "\U000F0981",
    "map-outline": "\U000F0982",
    "map-plus": "\U000F0983",
    "map-search": "\U000F0984",
    "map-search-outline": "\U000F0985",
    "mapbox": "\U000F0BAA",
    "margin": "\U000F0353",
    "marker": "\U000F0652",
    "marker-cancel": "\U000F0DD9",
    "marker-check": "\U000F0355",
    "mastodon": "\U000F0AD1",
    "material-design": "\U000F0986",
    "material-ui": "\U000F0357",
    "math-compass": "\U000F0358",
    "math-cos": "\U000F0C96",
    "math-integral": "\U000F0FC8",
    "math-integral-box": "\U000F0FC9",
    "math-log": "\U000F1085",
    "math-norm": "\U000F0FCA",
    "math-norm-box": "\U000F0FCB",
    "math-sin": "\U000F0C97",
    "math-tan": "\U000F0C98",
    "matrix": "\U000F0628",
    "medal": "\U000F0987",
    "medal-outline": "\U000F1326",
    "medical-bag": "\U000F06EF",
    "medical-cotton-swab": "\U000F1AB8",
    "medication": "\U000F1B14",
    "medication-outline": "\U000F1B15",
    "meditation": "\U000F117B",
    "memory": "\U000F035B",
    "menorah": "\U000F17D4",
    "menorah-fire": "\U000F17D5",
    "menu": "\U000F035C",
    "menu-down": "\U000F035D",
    "menu-down-outline": "\U000F06B6",
    "menu-left": "\U000F035E",
    "menu-left-outline": "\U000F0A02",
    "menu-open": "\U000F0BAB",
    "menu-right": "\U000F035F",
    "menu-right-outline": "\U000F0A03",
    "menu-swap": "\U000F0A64",
    "menu-swap-outline": "\U000F0A65",
    "menu-up": "\U000F0360",
    "menu-up-outline": "\U000F06B7",
    "merge": "\U000F0F5C",
    "message": "\U000F0361",
    "message-alert": "\U000F0362",
    "message-alert-outline": "\U000F0A04",
    "message-arrow-left": "\U000F12F2",
    "message-arrow-left-outline": "\U000F12F3",
    "message-arrow-right": "\U000F12F4",
    "message-arrow-right-outline": "\U000F12F5",
    "message-badge": "\U000F1941",
    "message-badge-outline": "\U000F1942",
    "message-bookmark": "\U000F15AC",
    "message-bookmark-outline": "\U000F15AD",
    "message-bulleted": "\U000F06A2",
    "message-bulleted-off": "\U000F06A3",
    "message-cog": "\U000F06F1",
    "message-cog-outline": "\U000F1172",
    "message-draw": "\U000F0363",
    "message-fast": "\U000F19CC",
    "message-fast-outline": "\U000F19CD",
    "message-flash": "\U000F15A9",
    "message-flash-outline": "\U000F15AA",
    "message-image": "\U000F0364",
    "message-image-outline": "\U000F116C",
    "message-lock": "\U000F0FCC",
    "message-lock-outline": "\U000F116D",
    "message-minus": "\U000F116E",
    "message-minus-outline": "\U000F116F",
    "message-off": "\U000F164D",
    "message-off-outline": "\U000F164E",
    "message-outline": "\U000F0365",
    "message-plus": "\U000F0653",
    "message-plus-outline": "\U000F10BB",
    "message-processing": "\U000F0366",
    "message-processing-outline": "\U000F1170",
    "message-question": "\U000F173A",
    "message-question-outline": "\U000F173B",
    "message-reply": "\U000F0367",
    "message-reply-outline": "\U000F173D",
    "message-reply-text": "\U000F0368",
    "message-reply-text-outline": "\U000F173E",
    "message-settings": "\U000F06F0",
    "message-settings-outline": "\U000F1171",
    "message-star": "\U000F069A",
    "message-star-outline": "\U000F1250",
    "message-text": "\U000F0369",
    "message-text-clock": "\U000F1173",
    "message-text-clock-outline": "\U000F1174",
    "message-text-fast": "\U000F19CE",
    "message-text-fast-outline": "\U000F19CF",
    "message-text-lock": "\U000F0FCD",
    "message-text-lock-outline": "\U000F1175",
    "message-text-outline": "\U000F036A",
    "message-video": "\U000F036B",
    "meteor": "\U000F0629",
    "meter-electric": "\U000F1A57",
    "meter-electric-outline": "\U000F1A58",
    "meter-gas": "\U000F1A59",
    "meter-gas-outline": "\U000F1A5A",
    "metronome": "\U000F07DA",
    "metronome-tick": "\U000F07DB",
    "micro-sd": "\U000F07DC",
    "microphone": "\U000F036C",
    "microphone-minus": "\U000F08B3",
    "microphone-off": "\U000F036D",
    "microphone-outline": "\U000F036E",
    "microphone-plus": "\U000F08B4",
    "microphone-question": "\U000F1989",
    "microphone-question-outline": "\U000F198A",
    "microphone-settings": "\U000F036F",
    "microphone-variant": "\U000F0370",
    "microphone-variant-off": "\U000F0371",
    "microscope": "\U000F0654",
    "microsoft": "\U000F0372",
    "microsoft-access": "\U000F138E",
    "microsoft-azure": "\U000F0805",
    "microsoft-azure-devops": "\U000F0FD5",
    "microsoft-bing": "\U000F00A4",
    "microsoft-dynamics-365": "\U000F0988",
    "microsoft-edge": "\U000F01E9",
    "microsoft-excel": "\U000F138F",
    "microsoft-internet-explorer": "\U000F0300",
    "microsoft-office": "\U000F03C6",
    "microsoft-onedrive": "\U000F03CA",
    "microsoft-onenote": "\U000F0747",
    "microsoft-outlook": "\U000F0D22",
    "microsoft-powerpoint": "\U000F1390",
    "microsoft-sharepoint": "\U000F1391",
    "microsoft-teams": "\U000F02BB",
    "microsoft-visual-studio": "\U000F0610",
    "microsoft-visual-studio-code": "\U000F0A1E",
    "microsoft-windows": "\U000F05B3",
    "microsoft-windows-classic": "\U000F0A21",
    "microsoft-word": "\U000F1392",
    "microsoft-xbox": "\U000F05B9",
    "microsoft-xbox-controller": "\U000F05BA",
    "microsoft-xbox-controller-battery-alert": "\U000F074B",
    "microsoft-xbox-controller-battery-charging": "\U000F0A22",
    "microsoft-xbox-controller-battery-empty": "\U000F074C",
    "microsoft-xbox-controller-battery-full": "\U000F074D",
    "microsoft-xbox-controller-battery-low": "\U000F074E",
    "microsoft-xbox-controller-battery-medium": "\U000F074F",
    "microsoft-xbox-controller-battery-unknown": "\U000F0750",
    "microsoft-xbox-controller-menu": "\U000F0E6F",
    "microsoft-xbox-controller-off": "\U000F05BB",
    "microsoft-xbox-controller-view": "\U000F0E70",
    "microwave": "\U000F0C99",
    "microwave-off": "\U000F1423",
    "middleware": "\U000F0F5D",
    "middleware-outline": "\U000F0F5E",
    "midi": "\U000F08F1",
    "midi-port": "\U000F08F2",
    "mine": "\U000F0DDA",
    "minecraft": "\U000F0373",
    "mini-sd": "\U000F0A05",
    "minidisc": "\U000F0A06",
    "minus": "\U000F0374",
    "minus-box": "\U000F0375",
    "minus-box-multiple": "\U000F1141",
    "minus-box-multiple-outline": "\U000F1142",
    "minus-box-outline": "\U000F06F2",
    "minus-circle": "\U000F0376",
    "minus-circle-multiple": "\U000F035A",
    "minus-circle-multiple-outline": "\U000F0AD3",
    "minus-circle-off": "\U000F1459",
    "minus-circle-off-outline": "\U000F145A",
    "minus-circle-outline": "\U000F0377",
    "minus-network": "\U000F0378",
    "minus-network-outline": "\U000F0C9A",
    "minus-thick": "\U000F1639",
    "mirror": "\U000F11FD",
    "mirror-rectangle": "\U000F179F",
    "mirror-variant": "\U000F17A0",
    "mixed-martial-arts": "\U000F0D8F",
    "mixed-reality": "\U000F087F",
    "molecule": "\U000F0BAC",
    "molecule-co": "\U000F12FE",
    "molecule-co2": "\U000F07E4",
    "monitor": "\U000F0379",
    "monitor-account": "\U000F1A5B",
    "monitor-arrow-down": "\U000F19D0",
    "monitor-arrow-down-variant": "\U000F19D1",
    "monitor-cellphone": "\U000F0989",
    "monitor-cellphone-star": "\U000F098A",
    "monitor-dashboard": "\U000F0A07",
    "monitor-edit": "\U000F12C6",
    "monitor-eye": "\U000F13B4",
    "monitor-lock": "\U000F0DDB",
    "monitor-multiple": "\U000F037A",
    "monitor-off": "\U000F0D90",
    "monitor-screenshot": "\U000F0E51",
    "monitor-share": "\U000F1483",
    "monitor-shimmer": "\U000F1104",
    "monitor-small": "\U000F1876",
    "monitor-speaker": "\U000F0F5F",
    "monitor-speaker-off": "\U000F0F60",
    "monitor-star": "\U000F0DDC",
    "moon-first-quarter": "\U000F0F61",
    "moon-full": "\U000F0F62",
    "moon-last-quarter": "\U000F0F63",
    "moon-new": "\U000F0F64",
    "moon-waning-crescent": "\U000F0F65",
    "moon-waning-gibbous": "\U000F0F66",
    "moon-waxing-crescent": "\U000F0F67",
    "moon-waxing-gibbous": "\U000F0F68",
    "moped": "\U000F1086",
    "moped-electric": "\U000F15B7",
    "moped-electric-outline": "\U000F15B8",
    "moped-outline": "\U000F15B9",
    "more": "\U000F037B",
    "mortar-pestle": "\U000F1748",
    "mortar-pestle-plus": "\U000F03F1",
    "mosque": "\U000F1827",
    "mother-heart": "\U000F1314",
    "mother-nurse": "\U000F0D21",
    "motion": "\U000F15B2",
    "motion-outline": "\U000F15B3",
    "motion-pause": "\U000F1590",
    "motion-pause-outline": "\U000F1592",
    "motion-play": "\U000F158F",
    "motion-play-outline": "\U000F1591",
    "motion-sensor": "\U000F0D91",
    "motion-sensor-off": "\U000F1435",
    "motorbike": "\U000F037C",
    "motorbike-electric": "\U000F15BA",
    "motorbike-off": "\U000F1B16",
    "mouse": "\U000F037D",
    "mouse-bluetooth": "\U000F098B",
    "mouse-move-down": "\U000F1550",
    "mouse-move-up": "\U000F1551",
    "mouse-move-vertical": "\U000F1552",
    "mouse-off": "\U000F037E",
    "mouse-variant": "\U000F037F",
    "mouse-variant-off": "\U000F0380",
    "move-resize": "\U000F0655",
    "move-resize-variant": "\U000F0656",
    "movie": "\U000F0381",
    "movie-check": "\U000F16F3",
    "movie-check-outline": "\U000F16F4",
    "movie-cog": "\U000F16F5",
    "movie-cog-outline": "\U000F16F6",
    "movie-edit": "\U000F1122",
    "movie-edit-outline": "\U000F1123",
    "movie-filter": "\U000F1124",
    "movie-filter-outline": "\U000F1125",
    "movie-minus": "\U000F16F7",
    "movie-minus-outline": "\U000F16F8",
    "movie-off": "\U000F16F9",
    "movie-off-outline": "\U000F16FA",
    "movie-open": "\U000F0FCE",
    "movie-open-check": "\U000F16FB",
    "movie-open-check-outline": "\U000F16FC",
    "movie-open-cog": "\U000F16FD",
    "movie-open-cog-outline": "\U000F16FE",
    "movie-open-edit": "\U000F16FF",
    "movie-open-edit-outline": "\U000F1700",
    "movie-open-minus": "\U000F1701",
    "movie-open-minus-outline": "\U000F1702",
    "movie-open-off": "\U000F1703",
    "movie-open-off-outline": "\U000F1704",
    "movie-open-outline": "\U000F0FCF",
    "movie-open-play": "\U000F1705",
    "movie-open-play-outline": "\U000F1706",
    "movie-open-plus": "\U000F1707",
    "movie-open-plus-outline": "\U000F1708",
    "movie-open-remove": "\U000F1709",
    "movie-open-remove-outline": "\U000F170A",
    "movie-open-settings": "\U000F170B",
    "movie-open-settings-outline": "\U000F170C",
    "movie-open-star": "\U000F170D",
    "movie-open-star-outline": "\U000F170E",
    "movie-outline": "\U000F0DDD",
    "movie-play": "\U000F170F",
    "movie-play-outline": "\U000F1710",
    "movie-plus": "\U000F1711",
    "movie-plus-outline": "\U000F1712",
    "movie-remove": "\U000F1713",
    "movie-remove-outline": "\U000F1714",
    "movie-roll": "\U000F07DE",
    "movie-search": "\U000F11D2",
    "movie-search-outline": "\U000F11D3",
    "movie-settings": "\U000F1715",
    "movie-settings-outline": "\U000F1716",
    "movie-star": "\U000F1717",
    "movie-star-outline": "\U000F1718",
    "mower": "\U000F166F",
    "mower-bag": "\U000F1670",
    "muffin": "\U000F098C",
    "multicast": "\U000F1893",
    "multiplication": "\U000F0382",
    "multiplication-box": "\U000F0383",
    "mushroom": "\U000F07DF",
    "mushroom-off": "\U000F13FA",
    "mushroom-off-outline": "\U000F13FB",
    "mushroom-outline": "\U000F07E0",
    "music": "\U000F075A",
    "music-accidental-double-flat": "\U000F0F69",
    "music-accidental-double-sharp": "\U000F0F6A",
    "music-accidental-flat": "\U000F0F6B",
    "music-accidental-natural": "\U000F0F6C",
    "music-accidental-sharp": "\U000F0F6D",
    "music-box": "\U000F0384",
    "music-box-multiple": "\U000F0333",
    "music-box-multiple-outline": "\U000F0F04",
    "music-box-outline": "\U000F0385",
    "music-circle": "\U000F0386",
    "music-circle-outline": "\U000F0AD4",
    "music-clef-alto": "\U000F0F6E",
    "music-clef-bass": "\U000F0F6F",
    "music-clef-treble": "\U000F0F70",
    "music-note": "\U000F0387",
    "music-note-bluetooth": "\U000F05FE",
    "music-note-bluetooth-off": "\U000F05FF",
    "music-note-eighth": "\U000F0388",
    "music-note-eighth-dotted": "\U000F0F71",
    "music-note-half": "\U000F0389",
    "music-note-half-dotted": "\U000F0F72",
    "music-note-off": "\U000F038A",
    "music-note-off-outline": "\U000F0F73",
    "music-note-outline": "\U000F0F74",
    "music-note-plus": "\U000F0DDE",
    "music-note-quarter": "\U000F038B",
    "music-note-quarter-dotted": "\U000F0F75",
    "music-note-sixteenth": "\U000F038C",
    "music-note-sixteenth-dotted": "\U000F0F76",
    "music-note-whole": "\U000F038D",
    "music-note-whole-dotted": "\U000F0F77",
    "music-off": "\U000F075B",
    "music-rest-eighth": "\U000F0F78",
    "music-rest-half": "\U000F0F79",
    "music-rest-quarter": "\U000F0F7A",
    "music-rest-sixteenth": "\U000F0F7B",
    "music-rest-whole": "\U000F0F7C",
    "mustache": "\U000F15DE",
    "nail": "\U000F0DDF",
    "nas": "\U000F08F3",
    "nativescript": "\U000F0880",
    "nature": "\U000F038E",
    "nature-people": "\U000F038F",
    "navigation": "\U000F0390",
    "navigation-outline": "\U000F1607",
    "navigation-variant": "\U000F18F0",
    "navigation-variant-outline": "\U000F18F1",
    "near-me": "\U000F05CD",
    "necklace": "\U000F0F0B",
    "needle": "\U000F0391",
    "needle-off": "\U000F19D2",
    "netflix": "\U000F0746",
    "network": "\U000F06F3",
    "network-off": "\U000F0C9B",
    "network-off-outline": "\U000F0C9C",
    "network-outline": "\U000F0C9D",
    "network-pos": "\U000F1ACB",
    "network-strength-1": "\U000F08F4",
    "network-strength-1-alert": "\U000F08F5",
    "network-strength-2": "\U000F08F6",
    "network-strength-2-alert": "\U000F08F7",
    "network-strength-3": "\U000F08F8",
    "network-strength-3-alert": "\U000F08F9",
    "network-strength-4": "\U000F08FA",
    "network-strength-4-alert": "\U000F08FB",
    "network-strength-4-cog": "\U000F191A",
    "network-strength-off": "\U000F08FC",
    "network-strength-off-outline": "\U000F08FD",
    "network-strength-outline": "\U000F08FE",
    "new-box": "\U000F0394",
    "newspaper": "\U000F0395",
    "newspaper-check": "\U000F1943",
    "newspaper-minus": "\U000F0F0C",
    "newspaper-plus": "\U000F0F0D",
    "newspaper-remove": "\U000F1944",
    "newspaper-variant": "\U000F1001",
    "newspaper-variant-multiple": "\U000F1002",
    "newspaper-variant-multiple-outline": "\U000F1003",
    "newspaper-variant-outline": "\U000F1004",
    "nfc": "\U000F0396",
    "nfc-search-variant": "\U000F0E53",
    "nfc-tap": "\U000F0397",
    "nfc-variant": "\U000F0398",
    "nfc-variant-off": "\U000F0E54",
    "ninja": "\U000F0774",
    "nintendo-game-boy": "\U000F1393",
    "nintendo-switch": "\U000F07E1",
    "nintendo-wii": "\U000F05AB",
    "nintendo-wiiu": "\U000F072D",
    "nix": "\U000F1105",
    "nodejs": "\U000F0399",
    "noodles": "\U000F117E",
    "not-equal": "\U000F098D",
    "not-equal-variant": "\U000F098E",
    "note": "\U000F039A",
    "note-alert": "\U000F177D",
    "note-alert-outline": "\U000F177E",
    "note-check": "\U000F177F",
    "note-check-outline": "\U000F1780",
    "note-edit": "\U000F1781",
    "note-edit-outline": "\U000F1782",
    "note-minus": "\U000F164F",
    "note-minus-outline": "\U000F1650",
    "note-multiple": "\U000F06B8",
    "note-multiple-outline": "\U000F06B9",
    "note-off": "\U000F1783",
    "note-off-outline": "\U000F1784",
    "note-outline": "\U000F039B",
    "note-plus": "\U000F039C",
    "note-plus-outline": "\U000F039D",
    "note-remove": "\U000F1651",
    "note-remove-outline": "\U000F1652",
    "note-search": "\U000F1653",
    "note-search-outline": "\U000F1654",
    "note-text": "\U000F039E",
    "note-text-outline": "\U000F11D7",
    "notebook": "\U000F082E",
    "notebook-check": "\U000F14F5",
    "notebook-check-outline": "\U000F14F6",
    "notebook-edit": "\U000F14E7",
    "notebook-edit-outline": "\U000F14E9",
    "notebook-heart": "\U000F1A0B",
    "notebook-heart-outline": "\U000F1A0C",
    "notebook-minus": "\U000F1610",
    "notebook-minus-outline": "\U000F1611",
    "notebook-multiple": "\U000F0E55",
    "notebook-outline": "\U000F0EBF",
    "notebook-plus": "\U000F1612",
    "notebook-plus-outline": "\U000F1613",
    "notebook-remove": "\U000F1614",
    "notebook-remove-outline": "\U000F1615",
    "notification-clear-all": "\U000F039F",
    "npm": "\U000F06F7",
    "nuke": "\U000F06A4",
    "null": "\U000F07E2",
    "numeric": "\U000F03A0",
    "numeric-0": "\U000F0B39",
    "numeric-0-box": "\U000F03A1",
    "numeric-0-box-multiple": "\U000F0F0E",
    "numeric-0-box-multiple-outline": "\U000F03A2",
    "numeric-0-box-outline": "\U000F03A3",
    "numeric-0-circle": "\U000F0C9E",
    "numeric-0-circle-outline": "\U000F0C9F",
    "numeric-1": "\U000F0B3A",
    "numeric-1-box": "\U000F03A4",
    "numeric-1-box-multiple": "\U000F0F0F",
    "numeric-1-box-multiple-outline": "\U000F03A5",
    "numeric-1-box-outline": "\U000F03A6",
    "numeric-1-circle": "\U000F0CA0",
    "numeric-1-circle-outline": "\U000F0CA1",
    "numeric-10": "\U000F0FE9",
    "numeric-10-box": "\U000F0F7D",
    "numeric-10-box-multiple": "\U000F0FEA",
    "numeric-10-box-multiple-outline": "\U000F0FEB",
    "numeric-10-box-outline": "\U000F0F7E",
    "numeric-10-circle": "\U000F0FEC",
    "numeric-10-circle-outline": "\U000F0FED",
    "numeric-2": "\U000F0B3B",
    "numeric-2-box": "\U000F03A7",
    "numeric-2-box-multiple": "\U000F0F10",
    "numeric-2-box-multiple-outline": "\U000F03A8",
    "numeric-2-box-outline": "\U000F03A9",
    "numeric-2-circle": "\U000F0CA2",
    "numeric-2-circle-outline": "\U000F0CA3",
    "numeric-3": "\U000F0B3C",
    "numeric-3-box": "\U000F03AA",
    "numeric-3-box-multiple": "\U000F0F11",
    "numeric-3-box-multiple-outline": "\U000F03AB",
    "numeric-3-box-outline": "\U000F03AC",
    "numeric-3-circle": "\U000F0CA4",
    "numeric-3-circle-outline": "\U000F0CA5",
    "numeric-4": "\U000F0B3D",
    "numeric-4-box": "\U000F03AD",
    "numeric-4-box-multiple": "\U000F0F12",
    "numeric-4-box-multiple-outline": "\U000F03B2",
    "numeric-4-box-outline": "\U000F03AE",
    "numeric-4-circle": "\U000F0CA6",
    "numeric-4-circle-outline": "\U000F0CA7",
    "numeric-5": "\U000F0B3E",
    "numeric-5-box": "\U000F03B1",
    "numeric-5-box-multiple": "\U000F0F13",
    "numeric-5-box-multiple-outline": "\U000F03AF",
    "numeric-5-box-outline": "\U000F03B0",
    "numeric-5-circle": "\U000F0CA8",
    "numeric-5-circle-outline": "\U000F0CA9",
    "numeric-6": "\U000F0B3F",
    "numeric-6-box": "\U000F03B3",
    "numeric-6-box-multiple": "\U000F0F14",
    "numeric-6-box-multiple-outline": "\U000F03B4",
    "numeric-6-box-outline": "\U000F03B5",
    "numeric-6-circle": "\U000F0CAA",
    "numeric-6-circle-outline": "\U000F0CAB",
    "numeric-7": "\U000F0B40",
    "numeric-7-box": "\U000F03B6",
    "numeric-7-box-multiple": "\U000F0F15",
    "numeric-7-box-multiple-outline": "\U000F03B7",
    "numeric-7-box-outline": "\U000F03B8",
    "numeric-7-circle": "\U000F0CAC",
    "numeric-7-circle-outline": "\U000F0CAD",
    "numeric-8": "\U000F0B41",
    "numeric-8-box": "\U000F03B9",
    "numeric-8-box-multiple": "\U000F0F16",
    "numeric-8-box-multiple-outline": "\U000F03BA",
    "numeric-8-box-outline": "\U000F03BB",
    "numeric-8-circle": "\U000F0CAE",
    "numeric-8-circle-outline": "\U000F0CAF",
    "numeric-9": "\U000F0B42",
    "numeric-9-box": "\U000F03BC",
    "numeric-9-box-multiple": "\U000F0F17",
    "numeric-9-box-multiple-outline": "\U000F03BD",
    "numeric-9-box-outline": "\U000F03BE",
    "numeric-9-circle": "\U000F0CB0",
    "numeric-9-circle-outline": "\U000F0CB1",
    "numeric-9-plus": "\U000F0FEE",
    "numeric-9-plus-box": "\U000F03BF",
    "numeric-9-plus-box-multiple": "\U000F0F18",
    "numeric-9-plus-box-multiple-outline": "\U000F03C0",
    "numeric-9-plus-box-outline": "\U000F03C1",
    "numeric-9-plus-circle": "\U000F0CB2",
    "numeric-9-plus-circle-outline": "\U000F0CB3",
    "numeric-negative-1": "\U000F1052",
    "numeric-off": "\U000F19D3",
    "numeric-positive-1": "\U000F15CB",
    "nut": "\U000F06F8",
    "nutrition": "\U000F03C2",
    "nuxt": "\U000F1106",
    "oar": "\U000F067C",
    "ocarina": "\U000F0DE0",
    "oci": "\U000F12E9",
    "ocr": "\U000F113A",
    "octagon": "\U000F03C3",
    "octagon-outline": "\U000F03C4",
    "octagram": "\U000F06F9",
    "octagram-outline": "\U000F0775",
    "octahedron": "\U000F1950",
    "octahedron-off": "\U000F1951",
    "odnoklassniki": "\U000F03C5",
    "offer": "\U000F121B",
    "office-building": "\U000F0991",
    "office-building-cog": "\U000F1949",
    "office-building-cog-outline": "\U000F194A",
    "office-building-marker": "\U000F1520",
    "office-building-marker-outline": "\U000F1521",
    "office-building-outline": "\U000F151F",
    "oil": "\U000F03C7",
    "oil-lamp": "\U000F0F19",
    "oil-level": "\U000F1053",
    "oil-temperature": "\U000F0FF8",
    "om": "\U000F0973",
    "omega": "\U000F03C9",
    "one-up": "\U000F0BAD",
    "onepassword": "\U000F0881",
    "opacity": "\U000F05CC",
    "open-in-app": "\U000F03CB",
    "open-in-new": "\U000F03CC",
    "open-source-initiative": "\U000F0BAE",
    "openid": "\U000F03CD",
    "opera": "\U000F03CE",
    "orbit": "\U000F0018",
    "orbit-variant": "\U000F15DB",
    "order-alphabetical-ascending": "\U000F020D",
    "order-alphabetical-descending": "\U000F0D07",
    "order-bool-ascending": "\U000F02BE",
    "order-bool-ascending-variant": "\U000F098F",
    "order-bool-descending": "\U000F1384",
    "order-bool-descending-variant": "\U000F0990",
    "order-numeric-ascending": "\U000F0545",
    "order-numeric-descending": "\U000F0546",
    "origin": "\U000F0B43",
    "ornament": "\U000F03CF",
    "ornament-variant": "\U000F03D0",
    "outdoor-lamp": "\U000F1054",
    "overscan": "\U000F1005",
    "owl": "\U000F03D2",
    "pac-man": "\U000F0BAF",
    "package": "\U000F03D3",
    "package-check": "\U000F1B51",
    "package-down": "\U000F03D4",
    "package-up": "\U000F03D5",
    "package-variant": "\U000F03D6",
    "package-variant-closed": "\U000F03D7",
    "package-variant-closed-check": "\U000F1B52",
    "package-variant-closed-minus": "\U000F19D4",
    "package-variant-closed-plus": "\U000F19D5",
    "package-variant-closed-remove": "\U000F19D6",
    "package-variant-minus": "\U000F19D7",
    "package-variant-plus": "\U000F19D8",
    "package-variant-remove": "\U000F19D9",
    "page-first": "\U000F0600",
    "page-last": "\U000F0601",
    "page-layout-body": "\U000F06FA",
    "page-layout-footer": "\U000F06FB",
    "page-layout-header": "\U000F06FC",
    "page-layout-header-footer": "\U000F0F7F",
    "page-layout-sidebar-left": "\U000F06FD",
    "page-layout-sidebar-right": "\U000F06FE",
    "page-next": "\U000F0BB0",
    "page-next-outline": "\U000F0BB1",
    "page-previous": "\U000F0BB2",
    "page-previous-outline": "\U000F0BB3",
    "pail": "\U000F1417",
    "pail-minus": "\U000F1437",
    "pail-minus-outline": "\U000F143C",
    "pail-off": "\U000F1439",
    "pail-off-outline": "\U000F143E",
    "pail-outline": "\U000F143A",
    "pail-plus": "\U000F1436",
    "pail-plus-outline": "\U000F143B",
    "pail-remove": "\U000F1438",
    "pail-remove-outline": "\U000F143D",
    "palette": "\U000F03D8",
    "palette-advanced": "\U000F03D9",
    "palette-outline": "\U000F0E0C",
    "palette-swatch": "\U000F08B5",
    "palette-swatch-outline": "\U000F135C",
    "palette-swatch-variant": "\U000F195A",
    "palm-tree": "\U000F1055",
    "pan": "\U000F0BB4",
    "pan-bottom-left": "\U000F0BB5",
    "pan-bottom-right": "\U000F0BB6",
    "pan-down": "\U000F0BB7",
    "pan-horizontal": "\U000F0BB8",
    "pan-left": "\U000F0BB9",
    "pan-right": "\U000F0BBA",
    "pan-top-left": "\U000F0BBB",
    "pan-top-right": "\U000F0BBC",
    "pan-up": "\U000F0BBD",
    "pan-vertical": "\U000F0BBE",
    "panda": "\U000F03DA",
    "pandora": "\U000F03DB",
    "panorama": "\U000F03DC",
    "panorama-fisheye": "\U000F03DD",
    "panorama-horizontal": "\U000F1928",
    "panorama-horizontal-outline": "\U000F03DE",
    "panorama-outline": "\U000F198C",
    "panorama-sphere": "\U000F198D",
    "panorama-sphere-outline": "\U000F198E",
    "panorama-variant": "\U000F198F",
    "panorama-variant-outline": "\U000F1990",
    "panorama-vertical": "\U000F1929",
    "panorama-vertical-outline": "\U000F03DF",
    "panorama-wide-angle": "\U000F195F",
    "panorama-wide-angle-outline": "\U000F03E0",
    "paper-cut-vertical": "\U000F03E1",
    "paper-roll": "\U000F1157",
    "paper-roll-outline": "\U000F1158",
    "paperclip": "\U000F03E2",
    "paperclip-check": "\U000F1AC6",
    "paperclip-lock": "\U000F19DA",
    "paperclip-minus": "\U000F1AC7",
    "paperclip-off": "\U000F1AC8",
    "paperclip-plus": "\U000F1AC9",
    "paperclip-remove": "\U000F1ACA",
    "parachute": "\U000F0CB4",
    "parachute-outline": "\U000F0CB5",
    "paragliding": "\U000F1745",
    "parking": "\U000F03E3",
    "party-popper": "\U000F1056",
    "passport": "\U000F07E3",
    "passport-biometric": "\U000F0DE1",
    "pasta": "\U000F1160",
    "patio-heater": "\U000F0F80",
    "patreon": "\U000F0882",
    "pause": "\U000F03E4",
    "pause-circle": "\U000F03E5",
    "pause-circle-outline": "\U000F03E6",
    "pause-octagon": "\U000F03E7",
    "pause-octagon-outline": "\U000F03E8",
    "paw": "\U000F03E9",
    "paw-off": "\U000F0657",
    "paw-off-outline": "\U000F1676",
    "paw-outline": "\U000F1675",
    "peace": "\U000F0884",
    "peanut": "\U000F0FFC",
    "peanut-off": "\U000F0FFD",
    "peanut-off-outline": "\U000F0FFF",
    "peanut-outline": "\U000F0FFE",
    "pen": "\U000F03EA",
    "pen-lock": "\U000F0DE2",
    "pen-minus": "\U000F0DE3",
    "pen-off": "\U000F0DE4",
    "pen-plus": "\U000F0DE5",
    "pen-remove": "\U000F0DE6",
    "pencil": "\U000F03EB",
    "pencil-box": "\U000F03EC",
    "pencil-box-multiple": "\U000F1144",
    "pencil-box-multiple-outline": "\U000F1145",
    "pencil-box-outline": "\U000F03ED",
    "pencil-circle": "\U000F06FF",
    "pencil-circle-outline": "\U000F0776",
    "pencil-lock": "\U000F03EE",
    "pencil-lock-outline": "\U000F0DE7",
    "pencil-minus": "\U000F0DE8",
    "pencil-minus-outline": "\U000F0DE9",
    "pencil-off": "\U000F03EF",
    "pencil-off-outline": "\U000F0DEA",
    "pencil-outline": "\U000F0CB6",
    "pencil-plus": "\U000F0DEB",
    "pencil-plus-outline": "\U000F0DEC",
    "pencil-remove": "\U000F0DED",
    "pencil-remove-outline": "\U000F0DEE",
    "pencil-ruler": "\U000F1353",
    "penguin": "\U000F0EC0",
    "pentagon": "\U000F0701",
    "pentagon-outline": "\U000F0700",
    "pentagram": "\U000F1667",
    "percent": "\U000F03F0",
    "percent-box": "\U000F1A02",
    "percent-box-outline": "\U000F1A03",
    "percent-circle": "\U000F1A04",
    "percent-circle-outline": "\U000F1A05",
    "percent-outline": "\U000F1278",
    "periodic-table": "\U000F08B6",
    "perspective-less": "\U000F0D23",
    "perspective-more": "\U000F0D24",
    "ph": "\U000F17C5",
    "phone": "\U000F03F2",
    "phone-alert": "\U000F0F1A",
    "phone-alert-outline": "\U000F118E",
    "phone-bluetooth": "\U000F03F3",
    "phone-bluetooth-outline": "\U000F118F",
    "phone-cancel": "\U000F10BC",
    "phone-cancel-outline": "\U000F1190",
    "phone-check": "\U000F11A9",
    "phone-check-outline": "\U000F11AA",
    "phone-classic": "\U000F0602",
    "phone-classic-off": "\U000F1279",
    "phone-clock": "\U000F19DB",
    "phone-dial": "\U000F1559",
    "phone-dial-outline": "\U000F155A",
    "phone-forward": "\U000F03F4",
    "phone-forward-outline": "\U000F1191",
    "phone-hangup": "\U000F03F5",
    "phone-hangup-outline": "\U000F1192",
    "phone-in-talk": "\U000F03F6",
    "phone-in-talk-outline": "\U000F1182",
    "phone-incoming": "\U000F03F7",
    "phone-incoming-outgoing": "\U000F1B3F",
    "phone-incoming-outgoing-outline": "\U000F1B40",
    "phone-incoming-outline": "\U000F1193",
    "phone-lock": "\U000F03F8",
    "phone-lock-outline": "\U000F1194",
    "phone-log": "\U000F03F9",
    "phone-log-outline": "\U000F1195",
    "phone-message": "\U000F1196",
    "phone-message-outline": "\U000F1197",
    "phone-minus": "\U000F0658",
    "phone-minus-outline": "\U000F1198",
    "phone-missed": "\U000F03FA",
    "phone-missed-outline": "\U000F11A5",
    "phone-off": "\U000F0DEF",
    "phone-off-outline": "\U000F11A6",
    "phone-outgoing": "\U000F03FB",
    "phone-outgoing-outline": "\U000F1199",
    "phone-outline": "\U000F0DF0",
    "phone-paused": "\U000F03FC",
    "phone-paused-outline": "\U000F119A",
    "phone-plus": "\U000F0659",
    "phone-plus-outline": "\U000F119B",
    "phone-refresh": "\U000F1993",
    "phone-refresh-outline": "\U000F1994",
    "phone-remove": "\U000F152F",
    "phone-remove-outline": "\U000F1530",
    "phone-return": "\U000F082F",
    "phone-return-outline": "\U000F119C",
    "phone-ring": "\U000F11AB",
    "phone-ring-outline": "\U000F11AC",
    "phone-rotate-landscape": "\U000F0885",
    "phone-rotate-portrait": "\U000F0886",
    "phone-settings": "\U000F03FD",
    "phone-settings-outline": "\U000F119D",
    "phone-sync": "\U000F1995",
    "phone-sync-outline": "\U000F1996",
    "phone-voip": "\U000F03FE",
    "pi": "\U000F03FF",
    "pi-box": "\U000F0400",
    "pi-hole": "\U000F0DF1",
    "piano": "\U000F067D",
    "piano-off": "\U000F0698",
    "pickaxe": "\U000F08B7",
    "picture-in-picture-bottom-right": "\U000F0E57",
    "picture-in-picture-bottom-right-outline": "\U000F0E58",
    "picture-in-picture-top-right": "\U000F0E59",
    "picture-in-picture-top-right-outline": "\U000F0E5A",
    "pier": "\U000F0887",
    "pier-crane": "\U000F0888",
    "pig": "\U000F0401",
    "pig-variant": "\U000F1006",
    "pig-variant-outline": "\U000F1678",
    "piggy-bank": "\U000F1007",
    "piggy-bank-outline": "\U000F1679",
    "pill": "\U000F0402",
    "pill-multiple": "\U000F1B4C",
    "pill-off": "\U000F1A5C",
    "pillar": "\U000F0702",
    "pin": "\U000F0403",
    "pin-off": "\U000F0404",
    "pin-off-outline": "\U000F0930",
    "pin-outline": "\U000F0931",
    "pine-tree": "\U000F0405",
    "pine-tree-box": "\U000F0406",
    "pine-tree-fire": "\U000F141A",
    "pinterest": "\U000F0407",
    "pinwheel": "\U000F0AD5",
    "pinwheel-outline": "\U000F0AD6",
    "pipe": "\U000F07E5",
    "pipe-disconnected": "\U000F07E6",
    "pipe-leak": "\U000F0889",
    "pipe-valve": "\U000F184D",
    "pipe-wrench": "\U000F1354",
    "pirate": "\U000F0A08",
    "pistol": "\U000F0703",
    "piston": "\U000F088A",
    "pitchfork": "\U000F1553",
    "pizza": "\U000F0409",
    "plane-car": "\U000F1AFF",
    "plane-train": "\U000F1B00",
    "play": "\U000F040A",
    "play-box": "\U000F127A",
    "play-box-lock": "\U000F1A16",
    "play-box-lock-open": "\U000F1A17",
    "play-box-lock-open-outline": "\U000F1A18",
    "play-box-lock-outline": "\U000F1A19",
    "play-box-multiple": "\U000F0D19",
    "play-box-multiple-outline": "\U000F13E6",
    "play-box-outline": "\U000F040B",
    "play-circle": "\U000F040C",
    "play-circle-outline": "\U000F040D",
    "play-network": "\U000F088B",
    "play-network-outline": "\U000F0CB7",
    "play-outline": "\U000F0F1B",
    "play-pause": "\U000F040E",
    "play-protected-content": "\U000F040F",
    "play-speed": "\U000F08FF",
    "playlist-check": "\U000F05C7",
    "playlist-edit": "\U000F0900",
    "playlist-minus": "\U000F0410",
    "playlist-music": "\U000F0CB8",
    "playlist-music-outline": "\U000F0CB9",
    "playlist-play": "\U000F0411",
    "playlist-plus": "\U000F0412",
    "playlist-remove": "\U000F0413",
    "playlist-star": "\U000F0DF2",
    "plex": "\U000F06BA",
    "pliers": "\U000F19A4",
    "plus": "\U000F0415",
    "plus-box": "\U000F0416",
    "plus-box-multiple": "\U000F0334",
    "plus-box-multiple-outline": "\U000F1143",
    "plus-box-outline": "\U000F0704",
    "plus-circle": "\U000F0417",
    "plus-circle-multiple": "\U000F034C",
    "plus-circle-multiple-outline": "\U000F0418",
    "plus-circle-outline": "\U000F0419",
    "plus-lock": "\U000F1A5D",
    "plus-lock-open": "\U000F1A5E",
    "plus-minus": "\U000F0992",
    "plus-minus-box": "\U000F0993",
    "plus-minus-variant": "\U000F14C9",
    "plus-network": "\U000F041A",
    "plus-network-outline": "\U000F0CBA",
    "plus-outline": "\U000F0705",
    "plus-thick": "\U000F11EC",
    "podcast": "\U000F0994",
    "podium": "\U000F0D25",
    "podium-bronze": "\U000F0D26",
    "podium-gold": "\U000F0D27",
    "podium-silver": "\U000F0D28",
    "point-of-sale": "\U000F0D92",
    "pokeball": "\U000F041D",
    "pokemon-go": "\U000F0A09",
    "poker-chip": "\U000F0830",
    "polaroid": "\U000F041E",
    "police-badge": "\U000F1167",
    "police-badge-outline": "\U000F1168",
    "police-station": "\U000F1839",
    "poll": "\U000F041F",
    "polo": "\U000F14C3",
    "polymer": "\U000F0421",
    "pool": "\U000F0606",
    "pool-thermometer": "\U000F1A5F",
    "popcorn": "\U000F0422",
    "post": "\U000F1008",
    "post-lamp": "\U000F1A60",
    "post-outline": "\U000F1009",
    "postage-stamp": "\U000F0CBB",
    "pot": "\U000F02E5",
    "pot-mix": "\U000F065B",
    "pot-mix-outline": "\U000F0677",
    "pot-outline": "\U000F02FF",
    "pot-steam": "\U000F065A",
    "pot-steam-outline": "\U000F0326",
    "pound": "\U000F0423",
    "pound-box": "\U000F0424",
    "pound-box-outline": "\U000F117F",
    "power": "\U000F0425",
    "power-cycle": "\U000F0901",
    "power-off": "\U000F0902",
    "power-on": "\U000F0903",
    "power-plug": "\U000F06A5",
    "power-plug-off": "\U000F06A6",
    "power-plug-off-outline": "\U000F1424",
    "power-plug-outline": "\U000F1425",
    "power-settings": "\U000F0426",
    "power-sleep": "\U000F0904",
    "power-socket": "\U000F0427",
    "power-socket-au": "\U000F0905",
    "power-socket-ch": "\U000F0FB3",
    "power-socket-de": "\U000F1107",
    "power-socket-eu": "\U000F07E7",
    "power-socket-fr": "\U000F1108",
    "power-socket-it": "\U000F14FF",
    "power-socket-jp": "\U000F1109",
    "power-socket-uk": "\U000F07E8",
    "power-socket-us": "\U000F07E9",
    "power-standby": "\U000F0906",
    "powershell": "\U000F0A0A",
    "prescription": "\U000F0706",
    "presentation": "\U000F0428",
    "presentation-play": "\U000F0429",
    "pretzel": "\U000F1562",
    "printer": "\U000F042A",
    "printer-3d": "\U000F042B",
    "printer-3d-nozzle": "\U000F0E5B",
    "printer-3d-nozzle-alert": "\U000F11C0",
    "printer-3d-nozzle-alert-outline": "\U000F11C1",
    "printer-3d-nozzle-heat": "\U000F18B8",
    "printer-3d-nozzle-heat-outline": "\U000F18B9",
    "printer-3d-nozzle-off": "\U000F1B19",
    "printer-3d-nozzle-off-outline": "\U000F1B1A",
    "printer-3d-nozzle-outline": "\U000F0E5C",
    "printer-3d-off": "\U000F1B0E",
    "printer-alert": "\U000F042C",
    "printer-check": "\U000F1146",
    "printer-eye": "\U000F1458",
    "printer-off": "\U000F0E5D",
    "printer-off-outline": "\U000F1785",
    "printer-outline": "\U000F1786",
    "printer-pos": "\U000F1057",
    "printer-search": "\U000F1457",
    "printer-settings": "\U000F0707",
    "printer-wireless": "\U000F0A0B",
    "priority-high": "\U000F0603",
    "priority-low": "\U000F0604",
    "professional-hexagon": "\U000F042D",
    "progress-alert": "\U000F0CBC",
    "progress-check": "\U000F0995",
    "progress-clock": "\U000F0996",
    "progress-close": "\U000F110A",
    "progress-download": "\U000F0997",
    "progress-pencil": "\U000F1787",
    "progress-question": "\U000F1522",
    "progress-star": "\U000F1788",
    "progress-upload": "\U000F0998",
    "progress-wrench": "\U000F0CBD",
    "projector": "\U000F042E",
    "projector-off": "\U000F1A23",
    "projector-screen": "\U000F042F",
    "projector-screen-off": "\U000F180D",
    "projector-screen-off-outline": "\U000F180E",
    "projector-screen-outline": "\U000F1724",
    "projector-screen-variant": "\U000F180F",
    "projector-screen-variant-off": "\U000F1810",
    "projector-screen-variant-off-outline": "\U000F1811",
    "projector-screen-variant-outline": "\U000F1812",
    "propane-tank": "\U000F1357",
    "propane-tank-outline": "\U000F1358",
    "protocol": "\U000F0FD8",
    "publish": "\U000F06A7",
    "publish-off": "\U000F1945",
    "pulse": "\U000F0430",
    "pump": "\U000F1402",
    "pump-off": "\U000F1B22",
    "pumpkin": "\U000F0BBF",
    "purse": "\U000F0F1C",
    "purse-outline": "\U000F0F1D",
    "puzzle": "\U000F0431",
    "puzzle-check": "\U000F1426",
    "puzzle-check-outline": "\U000F1427",
    "puzzle-edit": "\U000F14D3",
    "puzzle-edit-outline": "\U000F14D9",
    "puzzle-heart": "\U000F14D4",
    "puzzle-heart-outline": "\U000F14DA",
    "puzzle-minus": "\U000F14D1",
    "puzzle-minus-outline": "\U000F14D7",
    "puzzle-outline": "\U000F0A66",
    "puzzle-plus": "\U000F14D0",
    "puzzle-plus-outline": "\U000F14D6",
    "puzzle-remove": "\U000F14D2",
    "puzzle-remove-outline": "\U000F14D8",
    "puzzle-star": "\U000F14D5",
    "puzzle-star-outline": "\U000F14DB",
    "pyramid": "\U000F1952",
    "pyramid-off": "\U000F1953",
    "qi": "\U000F0999",
    "qqchat": "\U000F0605",
    "qrcode": "\U000F0432",
    "qrcode-edit": "\U000F08B8",
    "qrcode-minus": "\U000F118C",
    "qrcode-plus": "\U000F118B",
    "qrcode-remove": "\U000F118D",
    "qrcode-scan": "\U000F0433",
    "quadcopter": "\U000F0434",
    "quality-high": "\U000F0435",
    "quality-low": "\U000F0A0C",
    "quality-medium": "\U000F0A0D",
    "quora": "\U000F0D29",
    "rabbit": "\U000F0907",
    "rabbit-variant": "\U000F1A61",
    "rabbit-variant-outline": "\U000F1A62",
    "racing-helmet": "\U000F0D93",
    "racquetball": "\U000F0D94",
    "radar": "\U000F0437",
    "radiator": "\U000F0438",
    "radiator-disabled": "\U000F0AD7",
    "radiator-off": "\U000F0AD8",
    "radio": "\U000F0439",
    "radio-am": "\U000F0CBE",
    "radio-fm": "\U000F0CBF",
    "radio-handheld": "\U000F043A",
    "radio-off": "\U000F121C",
    "radio-tower": "\U000F043B",
    "radioactive": "\U000F043C",
    "radioactive-circle": "\U000F185D",
    "radioactive-circle-outline": "\U000F185E",
    "radioactive-off": "\U000F0EC1",
    "radiobox-blank": "\U000F043D",
    "radiobox-marked": "\U000F043E",
    "radiology-box": "\U000F14C5",
    "radiology-box-outline": "\U000F14C6",
    "radius": "\U000F0CC0",
    "radius-outline": "\U000F0CC1",
    "railroad-light": "\U000F0F1E",
    "rake": "\U000F1544",
    "raspberry-pi": "\U000F043F",
    "raw": "\U000F1A0F",
    "raw-off": "\U000F1A10",
    "ray-end": "\U000F0440",
    "ray-end-arrow": "\U000F0441",
    "ray-start": "\U000F0442",
    "ray-start-arrow": "\U000F0443",
    "ray-start-end": "\U000F0444",
    "ray-start-vertex-end": "\U000F15D8",
    "ray-vertex": "\U000F0445",
    "razor-double-edge": "\U000F1997",
    "razor-single-edge": "\U000F1998",
    "react": "\U000F0708",
    "read": "\U000F0447",
    "receipt": "\U000F0449",
    "receipt-outline": "\U000F19DC",
    "receipt-text-check": "\U000F1A63",
    "receipt-text-check-outline": "\U000F1A64",
    "receipt-text-minus": "\U000F1A65",
    "receipt-text-minus-outline": "\U000F1A66",
    "receipt-text-plus": "\U000F1A67",
    "receipt-text-plus-outline": "\U000F1A68",
    "receipt-text-remove": "\U000F1A69",
    "receipt-text-remove-outline": "\U000F1A6A",
    "record": "\U000F044A",
    "record-circle": "\U000F0EC2",
    "record-circle-outline": "\U000F0EC3",
    "record-player": "\U000F099A",
    "record-rec": "\U000F044B",
    "rectangle": "\U000F0E5E",
    "rectangle-outline": "\U000F0E5F",
    "recycle": "\U000F044C",
    "recycle-variant": "\U000F139D",
    "reddit": "\U000F044D",
    "redhat": "\U000F111B",
    "redo": "\U000F044E",
    "redo-variant": "\U000F044F",
    "reflect-horizontal": "\U000F0A0E",
    "reflect-vertical": "\U000F0A0F",
    "refresh": "\U000F0450",
    "refresh-auto": "\U000F18F2",
    "refresh-circle": "\U000F1377",
    "regex": "\U000F0451",
    "registered-trademark": "\U000F0A67",
    "reiterate": "\U000F1588",
    "relation-many-to-many": "\U000F1496",
    "relation-many-to-one": "\U000F1497",
    "relation-many-to-one-or-many": "\U000F1498",
    "relation-many-to-only-one": "\U000F1499",
    "relation-many-to-zero-or-many": "\U000F149A",
    "relation-many-to-zero-or-one": "\U000F149B",
    "relation-one-or-many-to-many": "\U000F149C",
    "relation-one-or-many-to-one": "\U000F149D",
    "relation-one-or-many-to-one-or-many": "\U000F149E",
    "relation-one-or-many-to-only-one": "\U000F149F",
    "relation-one-or-many-to-zero-or-many": "\U000F14A0",
    "relation-one-or-many-to-zero-or-one": "\U000F14A1",
    "relation-one-to-many": "\U000F14A2",
    "relation-one-to-one": "\U000F14A3",
    "relation-one-to-one-or-many": "\U000F14A4",
    "relation-one-to-only-one": "\U000F14A5",
    "relation-one-to-zero-or-many": "\U000F14A6",
    "relation-one-to-zero-or-one": "\U000F14A7",
    "relation-only-one-to-many": "\U000F14A8",
    "relation-only-one-to-one": "\U000F14A9",
    "relation-only-one-to-one-or-many": "\U000F14AA",
    "relation-only-one-to-only-one": "\U000F14AB",
    "relation-only-one-to-zero-or-many": "\U000F14AC",
    "relation-only-one-to-zero-or-one": "\U000F14AD",
    "relation-zero-or-many-to-many": "\U000F14AE",
    "relation-zero-or-many-to-one": "\U000F14AF",
    "relation-zero-or-many-to-one-or-many": "\U000F14B0",
    "relation-zero-or-many-to-only-one": "\U000F14B1",
    "relation-zero-or-many-to-zero-or-many": "\U000F14B2",
    "relation-zero-or-many-to-zero-or-one": "\U000F14B3",
    "relation-zero-or-one-to-many": "\U000F14B4",
    "relation-zero-or-one-to-one": "\U000F14B5",
    "relation-zero-or-one-to-one-or-many": "\U000F14B6",
    "relation-zero-or-one-to-only-one": "\U000F14B7",
    "relation-zero-or-one-to-zero-or-many": "\U000F14B8",
    "relation-zero-or-one-to-zero-or-one": "\U000F14B9",
    "relative-scale": "\U000F0452",
    "reload": "\U000F0453",
    "reload-alert": "\U000F110B",
    "reminder": "\U000F088C",
    "remote": "\U000F0454",
    "remote-desktop": "\U000F08B9",
    "remote-off": "\U000F0EC4",
    "remote-tv": "\U000F0EC5",
    "remote-tv-off": "\U000F0EC6",
    "rename-box": "\U000F0455",
    "reorder-horizontal": "\U000F0688",
    "reorder-vertical": "\U000F0689",
    "repeat": "\U000F0456",
    "repeat-off": "\U000F0457",
    "repeat-once": "\U000F0458",
    "repeat-variant": "\U000F0547",
    "replay": "\U000F0459",
    "reply": "\U000F045A",
    "reply-all": "\U000F045B",
    "reply-all-outline": "\U000F0F1F",
    "reply-circle": "\U000F11AE",
    "reply-outline": "\U000F0F20",
    "reproduction": "\U000F045C",
    "resistor": "\U000F0B44",
    "resistor-nodes": "\U000F0B45",
    "resize": "\U000F0A68",
    "resize-bottom-right": "\U000F045D",
    "responsive": "\U000F045E",
    "restart": "\U000F0709",
    "restart-alert": "\U000F110C",
    "restart-off": "\U000F0D95",
    "restore": "\U000F099B",
    "restore-alert": "\U000F110D",
    "rewind": "\U000F045F",
    "rewind-10": "\U000F0D2A",
    "rewind-15": "\U000F1946",
    "rewind-30": "\U000F0D96",
    "rewind-45": "\U000F1B13",
    "rewind-5": "\U000F11F9",
    "rewind-60": "\U000F160C",
    "rewind-outline": "\U000F070A",
    "rhombus": "\U000F070B",
    "rhombus-medium": "\U000F0A10",
    "rhombus-medium-outline": "\U000F14DC",
    "rhombus-outline": "\U000F070C",
    "rhombus-split": "\U000F0A11",
    "rhombus-split-outline": "\U000F14DD",
    "ribbon": "\U000F0460",
    "rice": "\U000F07EA",
    "rickshaw": "\U000F15BB",
    "rickshaw-electric": "\U000F15BC",
    "ring": "\U000F07EB",
    "rivet": "\U000F0E60",
    "road": "\U000F0461",
    "road-variant": "\U000F0462",
    "robber": "\U000F1058",
    "robot": "\U000F06A9",
    "robot-angry": "\U000F169D",
    "robot-angry-outline": "\U000F169E",
    "robot-confused": "\U000F169F",
    "robot-confused-outline": "\U000F16A0",
    "robot-dead": "\U000F16A1",
    "robot-dead-outline": "\U000F16A2",
    "robot-excited": "\U000F16A3",
    "robot-excited-outline": "\U000F16A4",
    "robot-happy": "\U000F1719",
    "robot-happy-outline": "\U000F171A",
    "robot-industrial": "\U000F0B46",
    "robot-industrial-outline": "\U000F1A1A",
    "robot-love": "\U000F16A5",
    "robot-love-outline": "\U000F16A6",
    "robot-mower": "\U000F11F7",
    "robot-mower-outline": "\U000F11F3",
    "robot-off": "\U000F16A7",
    "robot-off-outline": "\U000F167B",
    "robot-outline": "\U000F167A",
    "robot-vacuum": "\U000F070D",
    "robot-vacuum-variant": "\U000F0908",
    "rocket": "\U000F0463",
    "rocket-launch": "\U000F14DE",
    "rocket-launch-outline": "\U000F14DF",
    "rocket-outline": "\U000F13AF",
    "rodent": "\U000F1327",
    "roller-shade": "\U000F1A6B",
    "roller-shade-closed": "\U000F1A6C",
    "roller-skate": "\U000F0D2B",
    "roller-skate-off": "\U000F0145",
    "rollerblade": "\U000F0D2C",
    "rollerblade-off": "\U000F002E",
    "rollupjs": "\U000F0BC0",
    "rolodex": "\U000F1AB9",
    "rolodex-outline": "\U000F1ABA",
    "roman-numeral-1": "\U000F1088",
    "roman-numeral-10": "\U000F1091",
    "roman-numeral-2": "\U000F1089",
    "roman-numeral-3": "\U000F108A",
    "roman-numeral-4": "\U000F108B",
    "roman-numeral-5": "\U000F108C",
    "roman-numeral-6": "\U000F108D",
    "roman-numeral-7": "\U000F108E",
    "roman-numeral-8": "\U000F108F",
    "roman-numeral-9": "\U000F1090",
    "room-service": "\U000F088D",
    "room-service-outline": "\U000F0D97",
    "rotate-360": "\U000F1999",
    "rotate-3d": "\U000F0EC7",
    "rotate-3d-variant": "\U000F0464",
    "rotate-left": "\U000F0465",
    "rotate-left-variant": "\U000F0466",
    "rotate-orbit": "\U000F0D98",
    "rotate-right": "\U000F0467",
    "rotate-right-variant": "\U000F0468",
    "rounded-corner": "\U000F0607",
    "router": "\U000F11E2",
    "router-network": "\U000F1087",
    "router-wireless": "\U000F0469",
    "router-wireless-off": "\U000F15A3",
    "router-wireless-settings": "\U000F0A69",
    "routes": "\U000F046A",
    "routes-clock": "\U000F1059",
    "rowing": "\U000F0608",
    "rss": "\U000F046B",
    "rss-box": "\U000F046C",
    "rss-off": "\U000F0F21",
    "rug": "\U000F1475",
    "rugby": "\U000F0D99",
    "ruler": "\U000F046D",
    "ruler-square": "\U000F0CC2",
    "ruler-square-compass": "\U000F0EBE",
    "run": "\U000F070E",
    "run-fast": "\U000F046E",
    "rv-truck": "\U000F11D4",
    "sack": "\U000F0D2E",
    "sack-percent": "\U000F0D2F",
    "safe": "\U000F0A6A",
    "safe-square": "\U000F127C",
    "safe-square-outline": "\U000F127D",
    "safety-goggles": "\U000F0D30",
    "sail-boat": "\U000F0EC8",
    "sail-boat-sink": "\U000F1AEF",
    "sale": "\U000F046F",
    "sale-outline": "\U000F1A06",
    "salesforce": "\U000F088E",
    "sass": "\U000F07EC",
    "satellite": "\U000F0470",
    "satellite-uplink": "\U000F0909",
    "satellite-variant": "\U000F0471",
    "sausage": "\U000F08BA",
    "sausage-off": "\U000F1789",
    "saw-blade": "\U000F0E61",
    "sawtooth-wave": "\U000F147A",
    "saxophone": "\U000F0609",
    "scale": "\U000F0472",
    "scale-balance": "\U000F05D1",
    "scale-bathroom": "\U000F0473",
    "scale-off": "\U000F105A",
    "scale-unbalanced": "\U000F19B8",
    "scan-helper": "\U000F13D8",
    "scanner": "\U000F06AB",
    "scanner-off": "\U000F090A",
    "scatter-plot": "\U000F0EC9",
    "scatter-plot-outline": "\U000F0ECA",
    "scent": "\U000F1958",
    "scent-off": "\U000F1959",
    "school": "\U000F0474",
    "school-outline": "\U000F1180",
    "scissors-cutting": "\U000F0A6B",
    "scooter": "\U000F15BD",
    "scooter-electric": "\U000F15BE",
    "scoreboard": "\U000F127E",
    "scoreboard-outline": "\U000F127F",
    "screen-rotation": "\U000F0475",
    "screen-rotation-lock": "\U000F0478",
    "screw-flat-top": "\U000F0DF3",
    "screw-lag": "\U000F0DF4",
    "screw-machine-flat-top": "\U000F0DF5",
    "screw-machine-round-top": "\U000F0DF6",
    "screw-round-top": "\U000F0DF7",
    "screwdriver": "\U000F0476",
    "script": "\U000F0BC1",
    "script-outline": "\U000F0477",
    "script-text": "\U000F0BC2",
    "script-text-key": "\U000F1725",
    "script-text-key-outline": "\U000F1726",
    "script-text-outline": "\U000F0BC3",
    "script-text-play": "\U000F1727",
    "script-text-play-outline": "\U000F1728",
    "sd": "\U000F0479",
    "seal": "\U000F047A",
    "seal-variant": "\U000F0FD9",
    "search-web": "\U000F070F",
    "seat": "\U000F0CC3",
    "seat-flat": "\U000F047B",
    "seat-flat-angled": "\U000F047C",
    "seat-individual-suite": "\U000F047D",
    "seat-legroom-extra": "\U000F047E",
    "seat-legroom-normal": "\U000F047F",
    "seat-legroom-reduced": "\U000F0480",
    "seat-outline": "\U000F0CC4",
    "seat-passenger": "\U000F1249",
    "seat-recline-extra": "\U000F0481",
    "seat-recline-normal": "\U000F0482",
    "seatbelt": "\U000F0CC5",
    "security": "\U000F0483",
    "security-network": "\U000F0484",
    "seed": "\U000F0E62",
    "seed-off": "\U000F13FD",
    "seed-off-outline": "\U000F13FE",
    "seed-outline": "\U000F0E63",
    "seed-plus": "\U000F1A6D",
    "seed-plus-outline": "\U000F1A6E",
    "seesaw": "\U000F15A4",
    "segment": "\U000F0ECB",
    "select": "\U000F0485",
    "select-all": "\U000F0486",
    "select-color": "\U000F0D31",
    "select-compare": "\U000F0AD9",
    "select-drag": "\U000F0A6C",
    "select-group": "\U000F0F82",
    "select-inverse": "\U000F0487",
    "select-marker": "\U000F1280",
    "select-multiple": "\U000F1281",
    "select-multiple-marker": "\U000F1282",
    "select-off": "\U000F0488",
    "select-place": "\U000F0FDA",
    "select-remove": "\U000F17C1",
    "select-search": "\U000F1204",
    "selection": "\U000F0489",
    "selection-drag": "\U000F0A6D",
    "selection-ellipse": "\U000F0D32",
    "selection-ellipse-arrow-inside": "\U000F0F22",
    "selection-ellipse-remove": "\U000F17C2",
    "selection-marker": "\U000F1283",
    "selection-multiple": "\U000F1285",
    "selection-multiple-marker": "\U000F1284",
    "selection-off": "\U000F0777",
    "selection-remove": "\U000F17C3",
    "selection-search": "\U000F1205",
    "semantic-web": "\U000F1316",
    "send": "\U000F048A",
    "send-check": "\U000F1161",
    "send-check-outline": "\U000F1162",
    "send-circle": "\U000F0DF8",
    "send-circle-outline": "\U000F0DF9",
    "send-clock": "\U000F1163",
    "send-clock-outline": "\U000F1164",
    "send-lock": "\U000F07ED",
    "send-lock-outline": "\U000F1166",
    "send-outline": "\U000F1165",
    "serial-port": "\U000F065C",
    "server": "\U000F048B",
    "server-minus": "\U000F048C",
    "server-network": "\U000F048D",
    "server-network-off": "\U000F048E",
    "server-off": "\U000F048F",
    "server-plus": "\U000F0490",
    "server-remove": "\U000F0491",
    "server-security": "\U000F0492",
    "set-all": "\U000F0778",
    "set-center": "\U000F0779",
    "set-center-right": "\U000F077A",
    "set-left": "\U000F077B",
    "set-left-center": "\U000F077C",
    "set-left-right": "\U000F077D",
    "set-merge": "\U000F14E0",
    "set-none": "\U000F077E",
    "set-right": "\U000F077F",
    "set-split": "\U000F14E1",
    "set-square": "\U000F145D",
    "set-top-box": "\U000F099F",
    "settings-helper": "\U000F0A6E",
    "shaker": "\U000F110E",
    "shaker-outline": "\U000F110F",
    "shape": "\U000F0831",
    "shape-circle-plus": "\U000F065D",
    "shape-outline": "\U000F0832",
    "shape-oval-plus": "\U000F11FA",
    "shape-plus": "\U000F0495",
    "shape-polygon-plus": "\U000F065E",
    "shape-rectangle-plus": "\U000F065F",
    "shape-square-plus": "\U000F0660",
    "shape-square-rounded-plus": "\U000F14FA",
    "share": "\U000F0496",
    "share-all": "\U000F11F4",
    "share-all-outline": "\U000F11F5",
    "share-circle": "\U000F11AD",
    "share-off": "\U000F0F23",
    "share-off-outline": "\U000F0F24",
    "share-outline": "\U000F0932",
    "share-variant": "\U000F0497",
    "share-variant-outline": "\U000F1514",
    "shark": "\U000F18BA",
    "shark-fin": "\U000F1673",
    "shark-fin-outline": "\U000F1674",
    "shark-off": "\U000F18BB",
    "sheep": "\U000F0CC6",
    "shield": "\U000F0498",
    "shield-account": "\U000F088F",
    "shield-account-outline": "\U000F0A12",
    "shield-account-variant": "\U000F15A7",
    "shield-account-variant-outline": "\U000F15A8",
    "shield-airplane": "\U000F06BB",
    "shield-airplane-outline": "\U000F0CC7",
    "shield-alert": "\U000F0ECC",
    "shield-alert-outline": "\U000F0ECD",
    "shield-bug": "\U000F13DA",
    "shield-bug-outline": "\U000F13DB",
    "shield-car": "\U000F0F83",
    "shield-check": "\U000F0565",
    "shield-check-outline": "\U000F0CC8",
    "shield-cross": "\U000F0CC9",
    "shield-cross-outline": "\U000F0CCA",
    "shield-crown": "\U000F18BC",
    "shield-crown-outline": "\U000F18BD",
    "shield-edit": "\U000F11A0",
    "shield-edit-outline": "\U000F11A1",
    "shield-half": "\U000F1360",
    "shield-half-full": "\U000F0780",
    "shield-home": "\U000F068A",
    "shield-home-outline": "\U000F0CCB",
    "shield-key": "\U000F0BC4",
    "shield-key-outline": "\U000F0BC5",
    "shield-link-variant": "\U000F0D33",
    "shield-link-variant-outline": "\U000F0D34",
    "shield-lock": "\U000F099D",
    "shield-lock-open": "\U000F199A",
    "shield-lock-open-outline": "\U000F199B",
    "shield-lock-outline": "\U000F0CCC",
    "shield-moon": "\U000F1828",
    "shield-moon-outline": "\U000F1829",
    "shield-off": "\U000F099E",
    "shield-off-outline": "\U000F099C",
    "shield-outline": "\U000F0499",
    "shield-plus": "\U000F0ADA",
    "shield-plus-outline": "\U000F0ADB",
    "shield-refresh": "\U000F00AA",
    "shield-refresh-outline": "\U000F01E0",
    "shield-remove": "\U000F0ADC",
    "shield-remove-outline": "\U000F0ADD",
    "shield-search": "\U000F0D9A",
    "shield-star": "\U000F113B",
    "shield-star-outline": "\U000F113C",
    "shield-sun": "\U000F105D",
    "shield-sun-outline": "\U000F105E",
    "shield-sword": "\U000F18BE",
    "shield-sword-outline": "\U000F18BF",
    "shield-sync": "\U000F11A2",
    "shield-sync-outline": "\U000F11A3",
    "shimmer": "\U000F1545",
    "ship-wheel": "\U000F0833",
    "shipping-pallet": "\U000F184E",
    "shoe-ballet": "\U000F15CA",
    "shoe-cleat": "\U000F15C7",
    "shoe-formal": "\U000F0B47",
    "shoe-heel": "\U000F0B48",
    "shoe-print": "\U000F0DFA",
    "shoe-sneaker": "\U000F15C8",
    "shopping": "\U000F049A",
    "shopping-music": "\U000F049B",
    "shopping-outline": "\U000F11D5",
    "shopping-search": "\U000F0F84",
    "shopping-search-outline": "\U000F1A6F",
    "shore": "\U000F14F9",
    "shovel": "\U000F0710",
    "shovel-off": "\U000F0711",
    "shower": "\U000F09A0",
    "shower-head": "\U000F09A1",
    "shredder": "\U000F049C",
    "shuffle": "\U000F049D",
    "shuffle-disabled": "\U000F049E",
    "shuffle-variant": "\U000F049F",
    "shuriken": "\U000F137F",
    "sickle": "\U000F18C0",
    "sigma": "\U000F04A0",
    "sigma-lower": "\U000F062B",
    "sign-caution": "\U000F04A1",
    "sign-direction": "\U000F0781",
    "sign-direction-minus": "\U000F1000",
    "sign-direction-plus": "\U000F0FDC",
    "sign-direction-remove": "\U000F0FDD",
    "sign-language": "\U000F1B4D",
    "sign-language-outline": "\U000F1B4E",
    "sign-pole": "\U000F14F8",
    "sign-real-estate": "\U000F1118",
    "sign-text": "\U000F0782",
    "signal": "\U000F04A2",
    "signal-2g": "\U000F0712",
    "signal-3g": "\U000F0713",
    "signal-4g": "\U000F0714",
    "signal-5g": "\U000F0A6F",
    "signal-cellular-1": "\U000F08BC",
    "signal-cellular-2": "\U000F08BD",
    "signal-cellular-3": "\U000F08BE",
    "signal-cellular-outline": "\U000F08BF",
    "signal-distance-variant": "\U000F0E64",
    "signal-hspa": "\U000F0715",
    "signal-hspa-plus": "\U000F0716",
    "signal-off": "\U000F0783",
    "signal-variant": "\U000F060A",
    "signature": "\U000F0DFB",
    "signature-freehand": "\U000F0DFC",
    "signature-image": "\U000F0DFD",
    "signature-text": "\U000F0DFE",
    "silo": "\U000F0B49",
    "silverware": "\U000F04A3",
    "silverware-clean": "\U000F0FDE",
    "silverware-fork": "\U000F04A4",
    "silverware-fork-knife": "\U000F0A70",
    "silverware-spoon": "\U000F04A5",
    "silverware-variant": "\U000F04A6",
    "sim": "\U000F04A7",
    "sim-alert": "\U000F04A8",
    "sim-alert-outline": "\U000F15D3",
    "sim-off": "\U000F04A9",
    "sim-off-outline": "\U000F15D4",
    "sim-outline": "\U000F15D5",
    "simple-icons": "\U000F131D",
    "sina-weibo": "\U000F0ADF",
    "sine-wave": "\U000F095B",
    "sitemap": "\U000F04AA",
    "sitemap-outline": "\U000F199C",
    "size-l": "\U000F13A6",
    "size-m": "\U000F13A5",
    "size-s": "\U000F13A4",
    "size-xl": "\U000F13A7",
    "size-xs": "\U000F13A3",
    "size-xxl": "\U000F13A8",
    "size-xxs": "\U000F13A2",
    "size-xxxl": "\U000F13A9",
    "skate": "\U000F0D35",
    "skate-off": "\U000F0699",
    "skateboard": "\U000F14C2",
    "skateboarding": "\U000F0501",
    "skew-less": "\U000F0D36",
    "skew-more": "\U000F0D37",
    "ski": "\U000F1304",
    "ski-cross-country": "\U000F1305",
    "ski-water": "\U000F1306",
    "skip-backward": "\U000F04AB",
    "skip-backward-outline": "\U000F0F25",
    "skip-forward": "\U000F04AC",
    "skip-forward-outline": "\U000F0F26",
    "skip-next": "\U000F04AD",
    "skip-next-circle": "\U000F0661",
    "skip-next-circle-outline": "\U000F0662",
    "skip-next-outline": "\U000F0F27",
    "skip-previous": "\U000F04AE",
    "skip-previous-circle": "\U000F0663",
    "skip-previous-circle-outline": "\U000F0664",
    "skip-previous-outline": "\U000F0F28",
    "skull": "\U000F068C",
    "skull-crossbones": "\U000F0BC6",
    "skull-crossbones-outline": "\U000F0BC7",
    "skull-outline": "\U000F0BC8",
    "skull-scan": "\U000F14C7",
    "skull-scan-outline": "\U000F14C8",
    "skype": "\U000F04AF",
    "skype-business": "\U000F04B0",
    "slack": "\U000F04B1",
    "slash-forward": "\U000F0FDF",
    "slash-forward-box": "\U000F0FE0",
    "sledding": "\U000F041B",
    "sleep": "\U000F04B2",
    "sleep-off": "\U000F04B3",
    "slide": "\U000F15A5",
    "slope-downhill": "\U000F0DFF",
    "slope-uphill": "\U000F0E00",
    "slot-machine": "\U000F1114",
    "slot-machine-outline": "\U000F1115",
    "smart-card": "\U000F10BD",
    "smart-card-off": "\U000F18F7",
    "smart-card-off-outline": "\U000F18F8",
    "smart-card-outline": "\U000F10BE",
    "smart-card-reader": "\U000F10BF",
    "smart-card-reader-outline": "\U000F10C0",
    "smog": "\U000F0A71",
    "smoke": "\U000F1799",
    "smoke-detector": "\U000F0392",
    "smoke-detector-alert": "\U000F192E",
    "smoke-detector-alert-outline": "\U000F192F",
    "smoke-detector-off": "\U000F1809",
    "smoke-detector-off-outline": "\U000F180A",
    "smoke-detector-outline": "\U000F1808",
    "smoke-detector-variant": "\U000F180B",
    "smoke-detector-variant-alert": "\U000F1930",
    "smoke-detector-variant-off": "\U000F180C",
    "smoking": "\U000F04B4",
    "smoking-off": "\U000F04B5",
    "smoking-pipe": "\U000F140D",
    "smoking-pipe-off": "\U000F1428",
    "snail": "\U000F1677",
    "snake": "\U000F150E",
    "snapchat": "\U000F04B6",
    "snowboard": "\U000F1307",
    "snowflake": "\U000F0717",
    "snowflake-alert": "\U000F0F29",
    "snowflake-check": "\U000F1A70",
    "snowflake-melt": "\U000F12CB",
    "snowflake-off": "\U000F14E3",
    "snowflake-thermometer": "\U000F1A71",
    "snowflake-variant": "\U000F0F2A",
    "snowman": "\U000F04B7",
    "snowmobile": "\U000F06DD",
    "snowshoeing": "\U000F1A72",
    "soccer": "\U000F04B8",
    "soccer-field": "\U000F0834",
    "social-distance-2-meters": "\U000F1579",
    "social-distance-6-feet": "\U000F157A",
    "sofa": "\U000F04B9",
    "sofa-outline": "\U000F156D",
    "sofa-single": "\U000F156E",
    "sofa-single-outline": "\U000F156F",
    "solar-panel": "\U000F0D9B",
    "solar-panel-large": "\U000F0D9C",
    "solar-power": "\U000F0A72",
    "solar-power-variant": "\U000F1A73",
    "solar-power-variant-outline": "\U000F1A74",
    "soldering-iron": "\U000F1092",
    "solid": "\U000F068D",
    "sony-playstation": "\U000F0414",
    "sort": "\U000F04BA",
    "sort-alphabetical-ascending": "\U000F05BD",
    "sort-alphabetical-ascending-variant": "\U000F1148",
    "sort-alphabetical-descending": "\U000F05BF",
    "sort-alphabetical-descending-variant": "\U000F1149",
    "sort-alphabetical-variant": "\U000F04BB",
    "sort-ascending": "\U000F04BC",
    "sort-bool-ascending": "\U000F1385",
    "sort-bool-ascending-variant": "\U000F1386",
    "sort-bool-descending": "\U000F1387",
    "sort-bool-descending-variant": "\U000F1388",
    "sort-calendar-ascending": "\U000F1547",
    "sort-calendar-descending": "\U000F1548",
    "sort-clock-ascending": "\U000F1549",
    "sort-clock-ascending-outline": "\U000F154A",
    "sort-clock-descending": "\U000F154B",
    "sort-clock-descending-outline": "\U000F154C",
    "sort-descending": "\U000F04BD",
    "sort-numeric-ascending": "\U000F1389",
    "sort-numeric-ascending-variant": "\U000F090D",
    "sort-numeric-descending": "\U000F138A",
    "sort-numeric-descending-variant": "\U000F0AD2",
    "sort-numeric-variant": "\U000F04BE",
    "sort-reverse-variant": "\U000F033C",
    "sort-variant": "\U000F04BF",
    "sort-variant-lock": "\U000F0CCD",
    "sort-variant-lock-open": "\U000F0CCE",
    "sort-variant-off": "\U000F1ABB",
    "sort-variant-remove": "\U000F1147",
    "soundbar": "\U000F17DB",
    "soundcloud": "\U000F04C0",
    "source-branch": "\U000F062C",
    "source-branch-check": "\U000F14CF",
    "source-branch-minus": "\U000F14CB",
    "source-branch-plus": "\U000F14CA",
    "source-branch-refresh": "\U000F14CD",
    "source-branch-remove": "\U000F14CC",
    "source-branch-sync": "\U000F14CE",
    "source-commit": "\U000F0718",
    "source-commit-end": "\U000F0719",
    "source-commit-end-local": "\U000F071A",
    "source-commit-local": "\U000F071B",
    "source-commit-next-local": "\U000F071C",
    "source-commit-start": "\U000F071D",
    "source-commit-start-next-local": "\U000F071E",
    "source-fork": "\U000F04C1",
    "source-merge": "\U000F062D",
    "source-pull": "\U000F04C2",
    "source-repository": "\U000F0CCF",
    "source-repository-multiple": "\U000F0CD0",
    "soy-sauce": "\U000F07EE",
    "soy-sauce-off": "\U000F13FC",
    "spa": "\U000F0CD1",
    "spa-outline": "\U000F0CD2",
    "space-invaders": "\U000F0BC9",
    "space-station": "\U000F1383",
    "spade": "\U000F0E65",
    "speaker": "\U000F04C3",
    "speaker-bluetooth": "\U000F09A2",
    "speaker-message": "\U000F1B11",
    "speaker-multiple": "\U000F0D38",
    "speaker-off": "\U000F04C4",
    "speaker-wireless": "\U000F071F",
    "spear": "\U000F1845",
    "speedometer": "\U000F04C5",
    "speedometer-medium": "\U000F0F85",
    "speedometer-slow": "\U000F0F86",
    "spellcheck": "\U000F04C6",
    "sphere": "\U000F1954",
    "sphere-off": "\U000F1955",
    "spider": "\U000F11EA",
    "spider-thread": "\U000F11EB",
    "spider-web": "\U000F0BCA",
    "spirit-level": "\U000F14F1",
    "spoon-sugar": "\U000F1429",
    "spotify": "\U000F04C7",
    "spotlight": "\U000F04C8",
    "spotlight-beam": "\U000F04C9",
    "spray": "\U000F0665",
    "spray-bottle": "\U000F0AE0",
    "sprinkler": "\U000F105F",
    "sprinkler-fire": "\U000F199D",
    "sprinkler-variant": "\U000F1060",
    "sprout": "\U000F0E66",
    "sprout-outline": "\U000F0E67",
    "square": "\U000F0764",
    "square-circle": "\U000F1500",
    "square-edit-outline": "\U000F090C",
    "square-medium": "\U000F0A13",
    "square-medium-outline": "\U000F0A14",
    "square-off": "\U000F12EE",
    "square-off-outline": "\U000F12EF",
    "square-opacity": "\U000F1854",
    "square-outline": "\U000F0763",
    "square-root": "\U000F0784",
    "square-root-box": "\U000F09A3",
    "square-rounded": "\U000F14FB",
    "square-rounded-badge": "\U000F1A07",
    "square-rounded-badge-outline": "\U000F1A08",
    "square-rounded-outline": "\U000F14FC",
    "square-small": "\U000F0A15",
    "square-wave": "\U000F147B",
    "squeegee": "\U000F0AE1",
    "ssh": "\U000F08C0",
    "stack-exchange": "\U000F060B",
    "stack-overflow": "\U000F04CC",
    "stackpath": "\U000F0359",
    "stadium": "\U000F0FF9",
    "stadium-outline": "\U000F1B03",
    "stadium-variant": "\U000F0720",
    "stairs": "\U000F04CD",
    "stairs-box": "\U000F139E",
    "stairs-down": "\U000F12BE",
    "stairs-up": "\U000F12BD",
    "stamper": "\U000F0D39",
    "standard-definition": "\U000F07EF",
    "star": "\U000F04CE",
    "star-box": "\U000F0A73",
    "star-box-multiple": "\U000F1286",
    "star-box-multiple-outline": "\U000F1287",
    "star-box-outline": "\U000F0A74",
    "star-check": "\U000F1566",
    "star-check-outline": "\U000F156A",
    "star-circle": "\U000F04CF",
    "star-circle-outline": "\U000F09A4",
    "star-cog": "\U000F1668",
    "star-cog-outline": "\U000F1669",
    "star-crescent": "\U000F0979",
    "star-david": "\U000F097A",
    "star-face": "\U000F09A5",
    "star-four-points": "\U000F0AE2",
    "star-four-points-outline": "\U000F0AE3",
    "star-half": "\U000F0246",
    "star-half-full": "\U000F04D0",
    "star-minus": "\U000F1564",
    "star-minus-outline": "\U000F1568",
    "star-off": "\U000F04D1",
    "star-off-outline": "\U000F155B",
    "star-outline": "\U000F04D2",
    "star-plus": "\U000F1563",
    "star-plus-outline": "\U000F1567",
    "star-remove": "\U000F1565",
    "star-remove-outline": "\U000F1569",
    "star-settings": "\U000F166A",
    "star-settings-outline": "\U000F166B",
    "star-shooting": "\U000F1741",
    "star-shooting-outline": "\U000F1742",
    "star-three-points": "\U000F0AE4",
    "star-three-points-outline": "\U000F0AE5",
    "state-machine": "\U000F11EF",
    "steam": "\U000F04D3",
    "steering": "\U000F04D4",
    "steering-off": "\U000F090E",
    "step-backward": "\U000F04D5",
    "step-backward-2": "\U000F04D6",
    "step-forward": "\U000F04D7",
    "step-forward-2": "\U000F04D8",
    "stethoscope": "\U000F04D9",
    "sticker": "\U000F1364",
    "sticker-alert": "\U000F1365",
    "sticker-alert-outline": "\U000F1366",
    "sticker-check": "\U000F1367",
    "sticker-check-outline": "\U000F1368",
    "sticker-circle-outline": "\U000F05D0",
    "sticker-emoji": "\U000F0785",
    "sticker-minus": "\U000F1369",
    "sticker-minus-outline": "\U000F136A",
    "sticker-outline": "\U000F136B",
    "sticker-plus": "\U000F136C",
    "sticker-plus-outline": "\U000F136D",
    "sticker-remove": "\U000F136E",
    "sticker-remove-outline": "\U000F136F",
    "sticker-text": "\U000F178E",
    "sticker-text-outline": "\U000F178F",
    "stocking": "\U000F04DA",
    "stomach": "\U000F1093",
    "stool": "\U000F195D",
    "stool-outline": "\U000F195E",
    "stop": "\U000F04DB",
    "stop-circle": "\U000F0666",
    "stop-circle-outline": "\U000F0667",
    "storage-tank": "\U000F1A75",
    "storage-tank-outline": "\U000F1A76",
    "store": "\U000F04DC",
    "store-24-hour": "\U000F04DD",
    "store-alert": "\U000F18C1",
    "store-alert-outline": "\U000F18C2",
    "store-check": "\U000F18C3",
    "store-check-outline": "\U000F18C4",
    "store-clock": "\U000F18C5",
    "store-clock-outline": "\U000F18C6",
    "store-cog": "\U000F18C7",
    "store-cog-outline": "\U000F18C8",
    "store-edit": "\U000F18C9",
    "store-edit-outline": "\U000F18CA",
    "store-marker": "\U000F18CB",
    "store-marker-outline": "\U000F18CC",
    "store-minus": "\U000F165E",
    "store-minus-outline": "\U000F18CD",
    "store-off": "\U000F18CE",
    "store-off-outline": "\U000F18CF",
    "store-outline": "\U000F1361",
    "store-plus": "\U000F165F",
    "store-plus-outline": "\U000F18D0",
    "store-remove": "\U000F1660",
    "store-remove-outline": "\U000F18D1",
    "store-search": "\U000F18D2",
    "store-search-outline": "\U000F18D3",
    "store-settings": "\U000F18D4",
    "store-settings-outline": "\U000F18D5",
    "storefront": "\U000F07C7",
    "storefront-outline": "\U000F10C1",
    "stove": "\U000F04DE",
    "strategy": "\U000F11D6",
    "stretch-to-page": "\U000F0F2B",
    "stretch-to-page-outline": "\U000F0F2C",
    "string-lights": "\U000F12BA",
    "string-lights-off": "\U000F12BB",
    "subdirectory-arrow-left": "\U000F060C",
    "subdirectory-arrow-right": "\U000F060D",
    "submarine": "\U000F156C",
    "subtitles": "\U000F0A16",
    "subtitles-outline": "\U000F0A17",
    "subway": "\U000F06AC",
    "subway-alert-variant": "\U000F0D9D",
    "subway-variant": "\U000F04DF",
    "summit": "\U000F0786",
    "sun-angle": "\U000F1B27",
    "sun-angle-outline": "\U000F1B28",
    "sun-clock": "\U000F1A77",
    "sun-clock-outline": "\U000F1A78",
    "sun-compass": "\U000F19A5",
    "sun-snowflake": "\U000F1796",
    "sun-snowflake-variant": "\U000F1A79",
    "sun-thermometer": "\U000F18D6",
    "sun-thermometer-outline": "\U000F18D7",
    "sun-wireless": "\U000F17FE",
    "sun-wireless-outline": "\U000F17FF",
    "sunglasses": "\U000F04E0",
    "surfing": "\U000F1746",
    "surround-sound": "\U000F05C5",
    "surround-sound-2-0": "\U000F07F0",
    "surround-sound-2-1": "\U000F1729",
    "surround-sound-3-1": "\U000F07F1",
    "surround-sound-5-1": "\U000F07F2",
    "surround-sound-5-1-2": "\U000F172A",
    "surround-sound-7-1": "\U000F07F3",
    "svg": "\U000F0721",
    "swap-horizontal": "\U000F04E1",
    "swap-horizontal-bold": "\U000F0BCD",
    "swap-horizontal-circle": "\U000F0FE1",
    "swap-horizontal-circle-outline": "\U000F0FE2",
    "swap-horizontal-variant": "\U000F08C1",
    "swap-vertical": "\U000F04E2",
    "swap-vertical-bold": "\U000F0BCE",
    "swap-vertical-circle": "\U000F0FE3",
    "swap-vertical-circle-outline": "\U000F0FE4",
    "swap-vertical-variant": "\U000F08C2",
    "swim": "\U000F04E3",
    "switch": "\U000F04E4",
    "sword": "\U000F04E5",
    "sword-cross": "\U000F0787",
    "syllabary-hangul": "\U000F1333",
    "syllabary-hiragana": "\U000F1334",
    "syllabary-katakana": "\U000F1335",
    "syllabary-katakana-halfwidth": "\U000F1336",
    "symbol": "\U000F1501",
    "symfony": "\U000F0AE6",
    "synagogue": "\U000F1B04",
    "synagogue-outline": "\U000F1B05",
    "sync": "\U000F04E6",
    "sync-alert": "\U000F04E7",
    "sync-circle": "\U000F1378",
    "sync-off": "\U000F04E8",
    "tab": "\U000F04E9",
    "tab-minus": "\U000F0B4B",
    "tab-plus": "\U000F075C",
    "tab-remove": "\U000F0B4C",
    "tab-search": "\U000F199E",
    "tab-unselected": "\U000F04EA",
    "table": "\U000F04EB",
    "table-account": "\U000F13B9",
    "table-alert": "\U000F13BA",
    "table-arrow-down": "\U000F13BB",
    "table-arrow-left": "\U000F13BC",
    "table-arrow-right": "\U000F13BD",
    "table-arrow-up": "\U000F13BE",
    "table-border": "\U000F0A18",
    "table-cancel": "\U000F13BF",
    "table-chair": "\U000F1061",
    "table-check": "\U000F13C0",
    "table-clock": "\U000F13C1",
    "table-cog": "\U000F13C2",
    "table-column": "\U000F0835",
    "table-column-plus-after": "\U000F04EC",
    "table-column-plus-before": "\U000F04ED",
    "table-column-remove": "\U000F04EE",
    "table-column-width": "\U000F04EF",
    "table-edit": "\U000F04F0",
    "table-eye": "\U000F1094",
    "table-eye-off": "\U000F13C3",
    "table-furniture": "\U000F05BC",
    "table-headers-eye": "\U000F121D",
    "table-headers-eye-off": "\U000F121E",
    "table-heart": "\U000F13C4",
    "table-key": "\U000F13C5",
    "table-large": "\U000F04F1",
    "table-large-plus": "\U000F0F87",
    "table-large-remove": "\U000F0F88",
    "table-lock": "\U000F13C6",
    "table-merge-cells": "\U000F09A6",
    "table-minus": "\U000F13C7",
    "table-multiple": "\U000F13C8",
    "table-network": "\U000F13C9",
    "table-of-contents": "\U000F0836",
    "table-off": "\U000F13CA",
    "table-picnic": "\U000F1743",
    "table-pivot": "\U000F183C",
    "table-plus": "\U000F0A75",
    "table-question": "\U000F1B21",
    "table-refresh": "\U000F13A0",
    "table-remove": "\U000F0A76",
    "table-row": "\U000F0837",
    "table-row-height": "\U000F04F2",
    "table-row-plus-after": "\U000F04F3",
    "table-row-plus-before": "\U000F04F4",
    "table-row-remove": "\U000F04F5",
    "table-search": "\U000F090F",
    "table-settings": "\U000F0838",
    "table-split-cell": "\U000F142A",
    "table-star": "\U000F13CB",
    "table-sync": "\U000F13A1",
    "table-tennis": "\U000F0E68",
    "tablet": "\U000F04F6",
    "tablet-android": "\U000F04F7",
    "tablet-cellphone": "\U000F09A7",
    "tablet-dashboard": "\U000F0ECE",
    "taco": "\U000F0762",
    "tag": "\U000F04F9",
    "tag-arrow-down": "\U000F172B",
    "tag-arrow-down-outline": "\U000F172C",
    "tag-arrow-left": "\U000F172D",
    "tag-arrow-left-outline": "\U000F172E",
    "tag-arrow-right": "\U000F172F",
    "tag-arrow-right-outline": "\U000F1730",
    "tag-arrow-up": "\U000F1731",
    "tag-arrow-up-outline": "\U000F1732",
    "tag-check": "\U000F1A7A",
    "tag-check-outline": "\U000F1A7B",
    "tag-faces": "\U000F04FA",
    "tag-heart": "\U000F068B",
    "tag-heart-outline": "\U000F0BCF",
    "tag-minus": "\U000F0910",
    "tag-minus-outline": "\U000F121F",
    "tag-multiple": "\U000F04FB",
    "tag-multiple-outline": "\U000F12F7",
    "tag-off": "\U000F1220",
    "tag-off-outline": "\U000F1221",
    "tag-outline": "\U000F04FC",
    "tag-plus": "\U000F0722",
    "tag-plus-outline": "\U000F1222",
    "tag-remove": "\U000F0723",
    "tag-remove-outline": "\U000F1223",
    "tag-search": "\U000F1907",
    "tag-search-outline": "\U000F1908",
    "tag-text": "\U000F1224",
    "tag-text-outline": "\U000F04FD",
    "tailwind": "\U000F13FF",
    "tally-mark-1": "\U000F1ABC",
    "tally-mark-2": "\U000F1ABD",
    "tally-mark-3": "\U000F1ABE",
    "tally-mark-4": "\U000F1ABF",
    "tally-mark-5": "\U000F1AC0",
    "tangram": "\U000F04F8",
    "tank": "\U000F0D3A",
    "tanker-truck": "\U000F0FE5",
    "tape-drive": "\U000F16DF",
    "tape-measure": "\U000F0B4D",
    "target": "\U000F04FE",
    "target-account": "\U000F0BD0",
    "target-variant": "\U000F0A77",
    "taxi": "\U000F04FF",
    "tea": "\U000F0D9E",
    "tea-outline": "\U000F0D9F",
    "teamviewer": "\U000F0500",
    "teddy-bear": "\U000F18FB",
    "telescope": "\U000F0B4E",
    "television": "\U000F0502",
    "television-ambient-light": "\U000F1356",
    "television-box": "\U000F0839",
    "television-classic": "\U000F07F4",
    "television-classic-off": "\U000F083A",
    "television-guide": "\U000F0503",
    "television-off": "\U000F083B",
    "television-pause": "\U000F0F89",
    "television-play": "\U000F0ECF",
    "television-shimmer": "\U000F1110",
    "television-speaker": "\U000F1B1B",
    "television-speaker-off": "\U000F1B1C",
    "television-stop": "\U000F0F8A",
    "temperature-celsius": "\U000F0504",
    "temperature-fahrenheit": "\U000F0505",
    "temperature-kelvin": "\U000F0506",
    "temple-buddhist": "\U000F1B06",
    "temple-buddhist-outline": "\U000F1B07",
    "temple-hindu": "\U000F1B08",
    "temple-hindu-outline": "\U000F1B09",
    "tennis": "\U000F0DA0",
    "tennis-ball": "\U000F0507",
    "tent": "\U000F0508",
    "terraform": "\U000F1062",
    "terrain": "\U000F0509",
    "test-tube": "\U000F0668",
    "test-tube-empty": "\U000F0911",
    "test-tube-off": "\U000F0912",
    "text": "\U000F09A8",
    "text-account": "\U000F1570",
    "text-box": "\U000F021A",
    "text-box-check": "\U000F0EA6",
    "text-box-check-outline": "\U000F0EA7",
    "text-box-edit": "\U000F1A7C",
    "text-box-edit-outline": "\U000F1A7D",
    "text-box-minus": "\U000F0EA8",
    "text-box-minus-outline": "\U000F0EA9",
    "text-box-multiple": "\U000F0AB7",
    "text-box-multiple-outline": "\U000F0AB8",
    "text-box-outline": "\U000F09ED",
    "text-box-plus": "\U000F0EAA",
    "text-box-plus-outline": "\U000F0EAB",
    "text-box-remove": "\U000F0EAC",
    "text-box-remove-outline": "\U000F0EAD",
    "text-box-search": "\U000F0EAE",
    "text-box-search-outline": "\U000F0EAF",
    "text-long": "\U000F09AA",
    "text-recognition": "\U000F113D",
    "text-search": "\U000F13B8",
    "text-search-variant": "\U000F1A7E",
    "text-shadow": "\U000F0669",
    "text-short": "\U000F09A9",
    "text-to-speech": "\U000F050A",
    "text-to-speech-off": "\U000F050B",
    "texture": "\U000F050C",
    "texture-box": "\U000F0FE6",
    "theater": "\U000F050D",
    "theme-light-dark": "\U000F050E",
    "thermometer": "\U000F050F",
    "thermometer-alert": "\U000F0E01",
    "thermometer-auto": "\U000F1B0F",
    "thermometer-bluetooth": "\U000F1895",
    "thermometer-check": "\U000F1A7F",
    "thermometer-chevron-down": "\U000F0E02",
    "thermometer-chevron-up": "\U000F0E03",
    "thermometer-high": "\U000F10C2",
    "thermometer-lines": "\U000F0510",
    "thermometer-low": "\U000F10C3",
    "thermometer-minus": "\U000F0E04",
    "thermometer-off": "\U000F1531",
    "thermometer-plus": "\U000F0E05",
    "thermometer-probe": "\U000F1B2B",
    "thermometer-probe-off": "\U000F1B2C",
    "thermometer-water": "\U000F1A80",
    "thermostat": "\U000F0393",
    "thermostat-auto": "\U000F1B17",
    "thermostat-box": "\U000F0891",
    "thermostat-box-auto": "\U000F1B18",
    "thought-bubble": "\U000F07F6",
    "thought-bubble-outline": "\U000F07F7",
    "thumb-down": "\U000F0511",
    "thumb-down-outline": "\U000F0512",
    "thumb-up": "\U000F0513",
    "thumb-up-outline": "\U000F0514",
    "thumbs-up-down": "\U000F0515",
    "thumbs-up-down-outline": "\U000F1914",
    "ticket": "\U000F0516",
    "ticket-account": "\U000F0517",
    "ticket-confirmation": "\U000F0518",
    "ticket-confirmation-outline": "\U000F13AA",
    "ticket-outline": "\U000F0913",
    "ticket-percent": "\U000F0724",
    "ticket-percent-outline": "\U000F142B",
    "tie": "\U000F0519",
    "tilde": "\U000F0725",
    "tilde-off": "\U000F18F3",
    "timelapse": "\U000F051A",
    "timeline": "\U000F0BD1",
    "timeline-alert": "\U000F0F95",
    "timeline-alert-outline": "\U000F0F98",
    "timeline-check": "\U000F1532",
    "timeline-check-outline": "\U000F1533",
    "timeline-clock": "\U000F11FB",
    "timeline-clock-outline": "\U000F11FC",
    "timeline-help": "\U000F0F99",
    "timeline-help-outline": "\U000F0F9A",
    "timeline-minus": "\U000F1534",
    "timeline-minus-outline": "\U000F1535",
    "timeline-outline": "\U000F0BD2",
    "timeline-plus": "\U000F0F96",
    "timeline-plus-outline": "\U000F0F97",
    "timeline-remove": "\U000F1536",
    "timeline-remove-outline": "\U000F1537",
    "timeline-text": "\U000F0BD3",
    "timeline-text-outline": "\U000F0BD4",
    "timer": "\U000F13AB",
    "timer-10": "\U000F051C",
    "timer-3": "\U000F051D",
    "timer-alert": "\U000F1ACC",
    "timer-alert-outline": "\U000F1ACD",
    "timer-cancel": "\U000F1ACE",
    "timer-cancel-outline": "\U000F1ACF",
    "timer-check": "\U000F1AD0",
    "timer-check-outline": "\U000F1AD1",
    "timer-cog": "\U000F1925",
    "timer-cog-outline": "\U000F1926",
    "timer-edit": "\U000F1AD2",
    "timer-edit-outline": "\U000F1AD3",
    "timer-lock": "\U000F1AD4",
    "timer-lock-open": "\U000F1AD5",
    "timer-lock-open-outline": "\U000F1AD6",
    "timer-lock-outline": "\U000F1AD7",
    "timer-marker": "\U000F1AD8",
    "timer-marker-outline": "\U000F1AD9",
    "timer-minus": "\U000F1ADA",
    "timer-minus-outline": "\U000F1ADB",
    "timer-music": "\U000F1ADC",
    "timer-music-outline": "\U000F1ADD",
    "timer-off": "\U000F13AC",
    "timer-off-outline": "\U000F051E",
    "timer-outline": "\U000F051B",
    "timer-pause": "\U000F1ADE",
    "timer-pause-outline": "\U000F1ADF",
    "timer-play": "\U000F1AE0",
    "timer-play-outline": "\U000F1AE1",
    "timer-plus": "\U000F1AE2",
    "timer-plus-outline": "\U000F1AE3",
    "timer-refresh": "\U000F1AE4",
    "timer-refresh-outline": "\U000F1AE5",
    "timer-remove": "\U000F1AE6",
    "timer-remove-outline": "\U000F1AE7",
    "timer-sand": "\U000F051F",
    "timer-sand-complete": "\U000F199F",
    "timer-sand-empty": "\U000F06AD",
    "timer-sand-full": "\U000F078C",
    "timer-sand-paused": "\U000F19A0",
    "timer-settings": "\U000F1923",
    "timer-settings-outline": "\U000F1924",
    "timer-star": "\U000F1AE8",
    "timer-star-outline": "\U000F1AE9",
    "timer-stop": "\U000F1AEA",
    "timer-stop-outline": "\U000F1AEB",
    "timer-sync": "\U000F1AEC",
    "timer-sync-outline": "\U000F1AED",
    "timetable": "\U000F0520",
    "tire": "\U000F1896",
    "toaster": "\U000F1063",
    "toaster-off": "\U000F11B7",
    "toaster-oven": "\U000F0CD3",
    "toggle-switch": "\U000F0521",
    "toggle-switch-off": "\U000F0522",
    "toggle-switch-off-outline": "\U000F0A19",
    "toggle-switch-outline": "\U000F0A1A",
    "toggle-switch-variant": "\U000F1A25",
    "toggle-switch-variant-off": "\U000F1A26",
    "toilet": "\U000F09AB",
    "toolbox": "\U000F09AC",
    "toolbox-outline": "\U000F09AD",
    "tools": "\U000F1064",
    "tooltip": "\U000F0523",
    "tooltip-account": "\U000F000C",
    "tooltip-cellphone": "\U000F183B",
    "tooltip-check": "\U000F155C",
    "tooltip-check-outline": "\U000F155D",
    "tooltip-edit": "\U000F0524",
    "tooltip-edit-outline": "\U000F12C5",
    "tooltip-image": "\U000F0525",
    "tooltip-image-outline": "\U000F0BD5",
    "tooltip-minus": "\U000F155E",
    "tooltip-minus-outline": "\U000F155F",
    "tooltip-outline": "\U000F0526",
    "tooltip-plus": "\U000F0BD6",
    "tooltip-plus-outline": "\U000F0527",
    "tooltip-remove": "\U000F1560",
    "tooltip-remove-outline": "\U000F1561",
    "tooltip-text": "\U000F0528",
    "tooltip-text-outline": "\U000F0BD7",
    "tooth": "\U000F08C3",
    "tooth-outline": "\U000F0529",
    "toothbrush": "\U000F1129",
    "toothbrush-electric": "\U000F112C",
    "toothbrush-paste": "\U000F112A",
    "torch": "\U000F1606",
    "tortoise": "\U000F0D3B",
    "toslink": "\U000F12B8",
    "tournament": "\U000F09AE",
    "tow-truck": "\U000F083C",
    "tower-beach": "\U000F0681",
    "tower-fire": "\U000F0682",
    "town-hall": "\U000F1875",
    "toy-brick": "\U000F1288",
    "toy-brick-marker": "\U000F1289",
    "toy-brick-marker-outline": "\U000F128A",
    "toy-brick-minus": "\U000F128B",
    "toy-brick-minus-outline": "\U000F128C",
    "toy-brick-outline": "\U000F128D",
    "toy-brick-plus": "\U000F128E",
    "toy-brick-plus-outline": "\U000F128F",
    "toy-brick-remove": "\U000F1290",
    "toy-brick-remove-outline": "\U000F1291",
    "toy-brick-search": "\U000F1292",
    "toy-brick-search-outline": "\U000F1293",
    "track-light": "\U000F0914",
    "track-light-off": "\U000F1B01",
    "trackpad": "\U000F07F8",
    "trackpad-lock": "\U000F0933",
    "tractor": "\U000F0892",
    "tractor-variant": "\U000F14C4",
    "trademark": "\U000F0A78",
    "traffic-cone": "\U000F137C",
    "traffic-light": "\U000F052B",
    "traffic-light-outline": "\U000F182A",
    "train": "\U000F052C",
    "train-car": "\U000F0BD8",
    "train-car-autorack": "\U000F1B2D",
    "train-car-box": "\U000F1B2E",
    "train-car-box-full": "\U000F1B2F",
    "train-car-box-open": "\U000F1B30",
    "train-car-caboose": "\U000F1B31",
    "train-car-centerbeam": "\U000F1B32",
    "train-car-centerbeam-full": "\U000F1B33",
    "train-car-container": "\U000F1B34",
    "train-car-flatbed": "\U000F1B35",
    "train-car-flatbed-car": "\U000F1B36",
    "train-car-flatbed-tank": "\U000F1B37",
    "train-car-gondola": "\U000F1B38",
    "train-car-gondola-full": "\U000F1B39",
    "train-car-hopper": "\U000F1B3A",
    "train-car-hopper-covered": "\U000F1B3B",
    "train-car-hopper-full": "\U000F1B3C",
    "train-car-intermodal": "\U000F1B3D",
    "train-car-passenger": "\U000F1733",
    "train-car-passenger-door": "\U000F1734",
    "train-car-passenger-door-open": "\U000F1735",
    "train-car-passenger-variant": "\U000F1736",
    "train-car-tank": "\U000F1B3E",
    "train-variant": "\U000F08C4",
    "tram": "\U000F052D",
    "tram-side": "\U000F0FE7",
    "transcribe": "\U000F052E",
    "transcribe-close": "\U000F052F",
    "transfer": "\U000F1065",
    "transfer-down": "\U000F0DA1",
    "transfer-left": "\U000F0DA2",
    "transfer-right": "\U000F0530",
    "transfer-up": "\U000F0DA3",
    "transit-connection": "\U000F0D3C",
    "transit-connection-horizontal": "\U000F1546",
    "transit-connection-variant": "\U000F0D3D",
    "transit-detour": "\U000F0F8B",
    "transit-skip": "\U000F1515",
    "transit-transfer": "\U000F06AE",
    "transition": "\U000F0915",
    "transition-masked": "\U000F0916",
    "translate": "\U000F05CA",
    "translate-off": "\U000F0E06",
    "transmission-tower": "\U000F0D3E",
    "transmission-tower-export": "\U000F192C",
    "transmission-tower-import": "\U000F192D",
    "transmission-tower-off": "\U000F19DD",
    "trash-can": "\U000F0A79",
    "trash-can-outline": "\U000F0A7A",
    "tray": "\U000F1294",
    "tray-alert": "\U000F1295",
    "tray-arrow-down": "\U000F0120",
    "tray-arrow-up": "\U000F011D",
    "tray-full": "\U000F1296",
    "tray-minus": "\U000F1297",
    "tray-plus": "\U000F1298",
    "tray-remove": "\U000F1299",
    "treasure-chest": "\U000F0726",
    "tree": "\U000F0531",
    "tree-outline": "\U000F0E69",
    "trello": "\U000F0532",
    "trending-down": "\U000F0533",
    "trending-neutral": "\U000F0534",
    "trending-up": "\U000F0535",
    "triangle": "\U000F0536",
    "triangle-outline": "\U000F0537",
    "triangle-small-down": "\U000F1A09",
    "triangle-small-up": "\U000F1A0A",
    "triangle-wave": "\U000F147C",
    "triforce": "\U000F0BD9",
    "trophy": "\U000F0538",
    "trophy-award": "\U000F0539",
    "trophy-broken": "\U000F0DA4",
    "trophy-outline": "\U000F053A",
    "trophy-variant": "\U000F053B",
    "trophy-variant-outline": "\U000F053C",
    "truck": "\U000F053D",
    "truck-alert": "\U000F19DE",
    "truck-alert-outline": "\U000F19DF",
    "truck-cargo-container": "\U000F18D8",
    "truck-check": "\U000F0CD4",
    "truck-check-outline": "\U000F129A",
    "truck-delivery": "\U000F053E",
    "truck-delivery-outline": "\U000F129B",
    "truck-fast": "\U000F0788",
    "truck-fast-outline": "\U000F129C",
    "truck-flatbed": "\U000F1891",
    "truck-minus": "\U000F19AE",
    "truck-minus-outline": "\U000F19BD",
    "truck-outline": "\U000F129D",
    "truck-plus": "\U000F19AD",
    "truck-plus-outline": "\U000F19BC",
    "truck-remove": "\U000F19AF",
    "truck-remove-outline": "\U000F19BE",
    "truck-snowflake": "\U000F19A6",
    "truck-trailer": "\U000F0727",
    "trumpet": "\U000F1096",
    "tshirt-crew": "\U000F0A7B",
    "tshirt-crew-outline": "\U000F053F",
    "tshirt-v": "\U000F0A7C",
    "tshirt-v-outline": "\U000F0540",
    "tsunami": "\U000F1A81",
    "tumble-dryer": "\U000F0917",
    "tumble-dryer-alert": "\U000F11BA",
    "tumble-dryer-off": "\U000F11BB",
    "tune": "\U000F062E",
    "tune-variant": "\U000F1542",
    "tune-vertical": "\U000F066A",
    "tune-vertical-variant": "\U000F1543",
    "tunnel": "\U000F183D",
    "tunnel-outline": "\U000F183E",
    "turbine": "\U000F1A82",
    "turkey": "\U000F171B",
    "turnstile": "\U000F0CD5",
    "turnstile-outline": "\U000F0CD6",
    "turtle": "\U000F0CD7",
    "twitch": "\U000F0543",
    "twitter": "\U000F0544",
    "two-factor-authentication": "\U000F09AF",
    "typewriter": "\U000F0F2D",
    "ubisoft": "\U000F0BDA",
    "ubuntu": "\U000F0548",
    "ufo": "\U000F10C4",
    "ufo-outline": "\U000F10C5",
    "ultra-high-definition": "\U000F07F9",
    "umbraco": "\U000F0549",
    "umbrella": "\U000F054A",
    "umbrella-beach": "\U000F188A",
    "umbrella-beach-outline": "\U000F188B",
    "umbrella-closed": "\U000F09B0",
    "umbrella-closed-outline": "\U000F13E2",
    "umbrella-closed-variant": "\U000F13E1",
    "umbrella-outline": "\U000F054B",
    "undo": "\U000F054C",
    "undo-variant": "\U000F054D",
    "unfold-less-horizontal": "\U000F054E",
    "unfold-less-vertical": "\U000F0760",
    "unfold-more-horizontal": "\U000F054F",
    "unfold-more-vertical": "\U000F0761",
    "ungroup": "\U000F0550",
    "unicode": "\U000F0ED0",
    "unicorn": "\U000F15C2",
    "unicorn-variant": "\U000F15C3",
    "unicycle": "\U000F15E5",
    "unity": "\U000F06AF",
    "unreal": "\U000F09B1",
    "update": "\U000F06B0",
    "upload": "\U000F0552",
    "upload-lock": "\U000F1373",
    "upload-lock-outline": "\U000F1374",
    "upload-multiple": "\U000F083D",
    "upload-network": "\U000F06F6",
    "upload-network-outline": "\U000F0CD8",
    "upload-off": "\U000F10C6",
    "upload-off-outline": "\U000F10C7",
    "upload-outline": "\U000F0E07",
    "usb": "\U000F0553",
    "usb-flash-drive": "\U000F129E",
    "usb-flash-drive-outline": "\U000F129F",
    "usb-port": "\U000F11F0",
    "vacuum": "\U000F19A1",
    "vacuum-outline": "\U000F19A2",
    "valve": "\U000F1066",
    "valve-closed": "\U000F1067",
    "valve-open": "\U000F1068",
    "van-passenger": "\U000F07FA",
    "van-utility": "\U000F07FB",
    "vanish": "\U000F07FC",
    "vanish-quarter": "\U000F1554",
    "vanity-light": "\U000F11E1",
    "variable": "\U000F0AE7",
    "variable-box": "\U000F1111",
    "vector-arrange-above": "\U000F0554",
    "vector-arrange-below": "\U000F0555",
    "vector-bezier": "\U000F0AE8",
    "vector-circle": "\U000F0556",
    "vector-circle-variant": "\U000F0557",
    "vector-combine": "\U000F0558",
    "vector-curve": "\U000F0559",
    "vector-difference": "\U000F055A",
    "vector-difference-ab": "\U000F055B",
    "vector-difference-ba": "\U000F055C",
    "vector-ellipse": "\U000F0893",
    "vector-intersection": "\U000F055D",
    "vector-line": "\U000F055E",
    "vector-link": "\U000F0FE8",
    "vector-point": "\U000F055F",
    "vector-polygon": "\U000F0560",
    "vector-polygon-variant": "\U000F1856",
    "vector-polyline": "\U000F0561",
    "vector-polyline-edit": "\U000F1225",
    "vector-polyline-minus": "\U000F1226",
    "vector-polyline-plus": "\U000F1227",
    "vector-polyline-remove": "\U000F1228",
    "vector-radius": "\U000F074A",
    "vector-rectangle": "\U000F05C6",
    "vector-selection": "\U000F0562",
    "vector-square": "\U000F0001",
    "vector-square-close": "\U000F1857",
    "vector-square-edit": "\U000F18D9",
    "vector-square-minus": "\U000F18DA",
    "vector-square-open": "\U000F1858",
    "vector-square-plus": "\U000F18DB",
    "vector-square-remove": "\U000F18DC",
    "vector-triangle": "\U000F0563",
    "vector-union": "\U000F0564",
    "vhs": "\U000F0A1B",
    "vibrate": "\U000F0566",
    "vibrate-off": "\U000F0CD9",
    "video": "\U000F0567",
    "video-2d": "\U000F1A1C",
    "video-3d": "\U000F07FD",
    "video-3d-off": "\U000F13D9",
    "video-3d-variant": "\U000F0ED1",
    "video-4k-box": "\U000F083E",
    "video-account": "\U000F0919",
    "video-box": "\U000F00FD",
    "video-box-off": "\U000F00FE",
    "video-check": "\U000F1069",
    "video-check-outline": "\U000F106A",
    "video-high-definition": "\U000F152E",
    "video-image": "\U000F091A",
    "video-input-antenna": "\U000F083F",
    "video-input-component": "\U000F0840",
    "video-input-hdmi": "\U000F0841",
    "video-input-scart": "\U000F0F8C",
    "video-input-svideo": "\U000F0842",
    "video-marker": "\U000F19A9",
    "video-marker-outline": "\U000F19AA",
    "video-minus": "\U000F09B2",
    "video-minus-outline": "\U000F02BA",
    "video-off": "\U000F0568",
    "video-off-outline": "\U000F0BDB",
    "video-outline": "\U000F0BDC",
    "video-plus": "\U000F09B3",
    "video-plus-outline": "\U000F01D3",
    "video-stabilization": "\U000F091B",
    "video-switch": "\U000F0569",
    "video-switch-outline": "\U000F0790",
    "video-vintage": "\U000F0A1C",
    "video-wireless": "\U000F0ED2",
    "video-wireless-outline": "\U000F0ED3",
    "view-agenda": "\U000F056A",
    "view-agenda-outline": "\U000F11D8",
    "view-array": "\U000F056B",
    "view-array-outline": "\U000F1485",
    "view-carousel": "\U000F056C",
    "view-carousel-outline": "\U000F1486",
    "view-column": "\U000F056D",
    "view-column-outline": "\U000F1487",
    "view-comfy": "\U000F0E6A",
    "view-comfy-outline": "\U000F1488",
    "view-compact": "\U000F0E6B",
    "view-compact-outline": "\U000F0E6C",
    "view-dashboard": "\U000F056E",
    "view-dashboard-edit": "\U000F1947",
    "view-dashboard-edit-outline": "\U000F1948",
    "view-dashboard-outline": "\U000F0A1D",
    "view-dashboard-variant": "\U000F0843",
    "view-dashboard-variant-outline": "\U000F1489",
    "view-day": "\U000F056F",
    "view-day-outline": "\U000F148A",
    "view-gallery": "\U000F1888",
    "view-gallery-outline": "\U000F1889",
    "view-grid": "\U000F0570",
    "view-grid-outline": "\U000F11D9",
    "view-grid-plus": "\U000F0F8D",
    "view-grid-plus-outline": "\U000F11DA",
    "view-headline": "\U000F0571",
    "view-list": "\U000F0572",
    "view-list-outline": "\U000F148B",
    "view-module": "\U000F0573",
    "view-module-outline": "\U000F148C",
    "view-parallel": "\U000F0728",
    "view-parallel-outline": "\U000F148D",
    "view-quilt": "\U000F0574",
    "view-quilt-outline": "\U000F148E",
    "view-sequential": "\U000F0729",
    "view-sequential-outline": "\U000F148F",
    "view-split-horizontal": "\U000F0BCB",
    "view-split-vertical": "\U000F0BCC",
    "view-stream": "\U000F0575",
    "view-stream-outline": "\U000F1490",
    "view-week": "\U000F0576",
    "view-week-outline": "\U000F1491",
    "vimeo": "\U000F0577",
    "violin": "\U000F060F",
    "virtual-reality": "\U000F0894",
    "virus": "\U000F13B6",
    "virus-off": "\U000F18E1",
    "virus-off-outline": "\U000F18E2",
    "virus-outline": "\U000F13B7",
    "vlc": "\U000F057C",
    "voicemail": "\U000F057D",
    "volcano": "\U000F1A83",
    "volcano-outline": "\U000F1A84",
    "volleyball": "\U000F09B4",
    "volume-equal": "\U000F1B10",
    "volume-high": "\U000F057E",
    "volume-low": "\U000F057F",
    "volume-medium": "\U000F0580",
    "volume-minus": "\U000F075E",
    "volume-mute": "\U000F075F",
    "volume-off": "\U000F0581",
    "volume-plus": "\U000F075D",
    "volume-source": "\U000F1120",
    "volume-variant-off": "\U000F0E08",
    "volume-vibrate": "\U000F1121",
    "vote": "\U000F0A1F",
    "vote-outline": "\U000F0A20",
    "vpn": "\U000F0582",
    "vuejs": "\U000F0844",
    "vuetify": "\U000F0E6D",
    "walk": "\U000F0583",
    "wall": "\U000F07FE",
    "wall-fire": "\U000F1A11",
    "wall-sconce": "\U000F091C",
    "wall-sconce-flat": "\U000F091D",
    "wall-sconce-flat-outline": "\U000F17C9",
    "wall-sconce-flat-variant": "\U000F041C",
    "wall-sconce-flat-variant-outline": "\U000F17CA",
    "wall-sconce-outline": "\U000F17CB",
    "wall-sconce-round": "\U000F0748",
    "wall-sconce-round-outline": "\U000F17CC",
    "wall-sconce-round-variant": "\U000F091E",
    "wall-sconce-round-variant-outline": "\U000F17CD",
    "wallet": "\U000F0584",
    "wallet-giftcard": "\U000F0585",
    "wallet-membership": "\U000F0586",
    "wallet-outline": "\U000F0BDD",
    "wallet-plus": "\U000F0F8E",
    "wallet-plus-outline": "\U000F0F8F",
    "wallet-travel": "\U000F0587",
    "wallpaper": "\U000F0E09",
    "wan": "\U000F0588",
    "wardrobe": "\U000F0F90",
    "wardrobe-outline": "\U000F0F91",
    "warehouse": "\U000F0F81",
    "washing-machine": "\U000F072A",
    "washing-machine-alert": "\U000F11BC",
    "washing-machine-off": "\U000F11BD",
    "watch": "\U000F0589",
    "watch-export": "\U000F058A",
    "watch-export-variant": "\U000F0895",
    "watch-import": "\U000F058B",
    "watch-import-variant": "\U000F0896",
    "watch-variant": "\U000F0897",
    "watch-vibrate": "\U000F06B1",
    "watch-vibrate-off": "\U000F0CDA",
    "water": "\U000F058C",
    "water-alert": "\U000F1502",
    "water-alert-outline": "\U000F1503",
    "water-boiler": "\U000F0F92",
    "water-boiler-alert": "\U000F11B3",
    "water-boiler-off": "\U000F11B4",
    "water-check": "\U000F1504",
    "water-check-outline": "\U000F1505",
    "water-circle": "\U000F1806",
    "water-minus": "\U000F1506",
    "water-minus-outline": "\U000F1507",
    "water-off": "\U000F058D",
    "water-off-outline": "\U000F1508",
    "water-opacity": "\U000F1855",
    "water-outline": "\U000F0E0A",
    "water-percent": "\U000F058E",
    "water-percent-alert": "\U000F1509",
    "water-plus": "\U000F150A",
    "water-plus-outline": "\U000F150B",
    "water-polo": "\U000F12A0",
    "water-pump": "\U000F058F",
    "water-pump-off": "\U000F0F93",
    "water-remove": "\U000F150C",
    "water-remove-outline": "\U000F150D",
    "water-sync": "\U000F17C6",
    "water-thermometer": "\U000F1A85",
    "water-thermometer-outline": "\U000F1A86",
    "water-well": "\U000F106B",
    "water-well-outline": "\U000F106C",
    "waterfall": "\U000F1849",
    "watering-can": "\U000F1481",
    "watering-can-outline": "\U000F1482",
    "watermark": "\U000F0612",
    "wave": "\U000F0F2E",
    "waveform": "\U000F147D",
    "waves": "\U000F078D",
    "waves-arrow-left": "\U000F1859",
    "waves-arrow-right": "\U000F185A",
    "waves-arrow-up": "\U000F185B",
    "waze": "\U000F0BDE",
    "weather-cloudy": "\U000F0590",
    "weather-cloudy-alert": "\U000F0F2F",
    "weather-cloudy-arrow-right": "\U000F0E6E",
    "weather-cloudy-clock": "\U000F18F6",
    "weather-fog": "\U000F0591",
    "weather-hail": "\U000F0592",
    "weather-hazy": "\U000F0F30",
    "weather-hurricane": "\U000F0898",
    "weather-lightning": "\U000F0593",
    "weather-lightning-rainy": "\U000F067E",
    "weather-night": "\U000F0594",
    "weather-night-partly-cloudy": "\U000F0F31",
    "weather-partly-cloudy": "\U000F0595",
    "weather-partly-lightning": "\U000F0F32",
    "weather-partly-rainy": "\U000F0F33",
    "weather-partly-snowy": "\U000F0F34",
    "weather-partly-snowy-rainy": "\U000F0F35",
    "weather-pouring": "\U000F0596",
    "weather-rainy": "\U000F0597",
    "weather-snowy": "\U000F0598",
    "weather-snowy-heavy": "\U000F0F36",
    "weather-snowy-rainy": "\U000F067F",
    "weather-sunny": "\U000F0599",
    "weather-sunny-alert": "\U000F0F37",
    "weather-sunny-off": "\U000F14E4",
    "weather-sunset": "\U000F059A",
    "weather-sunset-down": "\U000F059B",
    "weather-sunset-up": "\U000F059C",
    "weather-tornado": "\U000F0F38",
    "weather-windy": "\U000F059D",
    "weather-windy-variant": "\U000F059E",
    "web": "\U000F059F",
    "web-box": "\U000F0F94",
    "web-cancel": "\U000F1790",
    "web-check": "\U000F0789",
    "web-clock": "\U000F124A",
    "web-minus": "\U000F10A0",
    "web-off": "\U000F0A8E",
    "web-plus": "\U000F0033",
    "web-refresh": "\U000F1791",
    "web-remove": "\U000F0551",
    "web-sync": "\U000F1792",
    "webcam": "\U000F05A0",
    "webcam-off": "\U000F1737",
    "webhook": "\U000F062F",
    "webpack": "\U000F072B",
    "webrtc": "\U000F1248",
    "wechat": "\U000F0611",
    "weight": "\U000F05A1",
    "weight-gram": "\U000F0D3F",
    "weight-kilogram": "\U000F05A2",
    "weight-lifter": "\U000F115D",
    "weight-pound": "\U000F09B5",
    "whatsapp": "\U000F05A3",
    "wheel-barrow": "\U000F14F2",
    "wheelchair": "\U000F1A87",
    "wheelchair-accessibility": "\U000F05A4",
    "whistle": "\U000F09B6",
    "whistle-outline": "\U000F12BC",
    "white-balance-auto": "\U000F05A5",
    "white-balance-incandescent": "\U000F05A6",
    "white-balance-iridescent": "\U000F05A7",
    "white-balance-sunny": "\U000F05A8",
    "widgets": "\U000F072C",
    "widgets-outline": "\U000F1355",
    "wifi": "\U000F05A9",
    "wifi-alert": "\U000F16B5",
    "wifi-arrow-down": "\U000F16B6",
    "wifi-arrow-left": "\U000F16B7",
    "wifi-arrow-left-right": "\U000F16B8",
    "wifi-arrow-right": "\U000F16B9",
    "wifi-arrow-up": "\U000F16BA",
    "wifi-arrow-up-down": "\U000F16BB",
    "wifi-cancel": "\U000F16BC",
    "wifi-check": "\U000F16BD",
    "wifi-cog": "\U000F16BE",
    "wifi-lock": "\U000F16BF",
    "wifi-lock-open": "\U000F16C0",
    "wifi-marker": "\U000F16C1",
    "wifi-minus": "\U000F16C2",
    "wifi-off": "\U000F05AA",
    "wifi-plus": "\U000F16C3",
    "wifi-refresh": "\U000F16C4",
    "wifi-remove": "\U000F16C5",
    "wifi-settings": "\U000F16C6",
    "wifi-star": "\U000F0E0B",
    "wifi-strength-1": "\U000F091F",
    "wifi-strength-1-alert": "\U000F0920",
    "wifi-strength-1-lock": "\U000F0921",
    "wifi-strength-1-lock-open": "\U000F16CB",
    "wifi-strength-2": "\U000F0922",
    "wifi-strength-2-alert": "\U000F0923",
    "wifi-strength-2-lock": "\U000F0924",
    "wifi-strength-2-lock-open": "\U000F16CC",
    "wifi-strength-3": "\U000F0925",
    "wifi-strength-3-alert": "\U000F0926",
    "wifi-strength-3-lock": "\U000F0927",
    "wifi-strength-3-lock-open": "\U000F16CD",
    "wifi-strength-4": "\U000F0928",
    "wifi-strength-4-alert": "\U000F0929",
    "wifi-strength-4-lock": "\U000F092A",
    "wifi-strength-4-lock-open": "\U000F16CE",
    "wifi-strength-alert-outline": "\U000F092B",
    "wifi-strength-lock-open-outline": "\U000F16CF",
    "wifi-strength-lock-outline": "\U000F092C",
    "wifi-strength-off": "\U000F092D",
    "wifi-strength-off-outline": "\U000F092E",
    "wifi-strength-outline": "\U000F092F",
    "wifi-sync": "\U000F16C7",
    "wikipedia": "\U000F05AC",
    "wind-power": "\U000F1A88",
    "wind-power-outline": "\U000F1A89",
    "wind-turbine": "\U000F0DA5",
    "wind-turbine-alert": "\U000F19AB",
    "wind-turbine-check": "\U000F19AC",
    "window-close": "\U000F05AD",
    "window-closed": "\U000F05AE",
    "window-closed-variant": "\U000F11DB",
    "window-maximize": "\U000F05AF",
    "window-minimize": "\U000F05B0",
    "window-open": "\U000F05B1",
    "window-open-variant": "\U000F11DC",
    "window-restore": "\U000F05B2",
    "window-shutter": "\U000F111C",
    "window-shutter-alert": "\U000F111D",
    "window-shutter-cog": "\U000F1A8A",
    "window-shutter-open": "\U000F111E",
    "window-shutter-settings": "\U000F1A8B",
    "windsock": "\U000F15FA",
    "wiper": "\U000F0AE9",
    "wiper-wash": "\U000F0DA6",
    "wiper-wash-alert": "\U000F18DF",
    "wizard-hat": "\U000F1477",
    "wordpress": "\U000F05B4",
    "wrap": "\U000F05B6",
    "wrap-disabled": "\U000F0BDF",
    "wrench": "\U000F05B7",
    "wrench-clock": "\U000F19A3",
    "wrench-outline": "\U000F0BE0",
    "xamarin": "\U000F0845",
    "xml": "\U000F05C0",
    "xmpp": "\U000F07FF",
    "yahoo": "\U000F0B4F",
    "yeast": "\U000F05C1",
    "yin-yang": "\U000F0680",
    "yoga": "\U000F117C",
    "youtube": "\U000F05C3",
    "youtube-gaming": "\U000F0848",
    "youtube-studio": "\U000F0847",
    "youtube-subscription": "\U000F0D40",
    "youtube-tv": "\U000F0448",
    "yurt": "\U000F1516",
    "z-wave": "\U000F0AEA",
    "zend": "\U000F0AEB",
    "zigbee": "\U000F0D41",
    "zip-box": "\U000F05C4",
    "zip-box-outline": "\U000F0FFA",
    "zip-disk": "\U000F0A23",
    "zodiac-aquarius": "\U000F0A7D",
    "zodiac-aries": "\U000F0A7E",
    "zodiac-cancer": "\U000F0A7F",
    "zodiac-capricorn": "\U000F0A80",
    "zodiac-gemini": "\U000F0A81",
    "zodiac-leo": "\U000F0A82",
    "zodiac-libra": "\U000F0A83",
    "zodiac-pisces": "\U000F0A84",
    "zodiac-sagittarius": "\U000F0A85",
    "zodiac-scorpio": "\U000F0A86",
    "zodiac-taurus": "\U000F0A87",
    "zodiac-virgo": "\U000F0A88",
    "blank": " ",
}
