from __future__ import annotations
from datetime import datetime
from kiota_abstractions.serialization import Parsable, ParseNode, SerializationWriter
from kiota_abstractions.utils import lazy_import
from typing import Any, Callable, Dict, List, Optional, Union

entity = lazy_import('msgraph.generated.models.entity')
windows_malware_category = lazy_import('msgraph.generated.models.windows_malware_category')
windows_malware_execution_state = lazy_import('msgraph.generated.models.windows_malware_execution_state')
windows_malware_severity = lazy_import('msgraph.generated.models.windows_malware_severity')
windows_malware_state = lazy_import('msgraph.generated.models.windows_malware_state')
windows_malware_threat_state = lazy_import('msgraph.generated.models.windows_malware_threat_state')

class WindowsDeviceMalwareState(entity.Entity):
    """
    Malware detection entity.
    """
    @property
    def additional_information_url(self,) -> Optional[str]:
        """
        Gets the additionalInformationUrl property value. Information URL to learn more about the malware
        Returns: Optional[str]
        """
        return self._additional_information_url
    
    @additional_information_url.setter
    def additional_information_url(self,value: Optional[str] = None) -> None:
        """
        Sets the additionalInformationUrl property value. Information URL to learn more about the malware
        Args:
            value: Value to set for the additionalInformationUrl property.
        """
        self._additional_information_url = value
    
    @property
    def category(self,) -> Optional[windows_malware_category.WindowsMalwareCategory]:
        """
        Gets the category property value. Category of the malware. Possible values are: invalid, adware, spyware, passwordStealer, trojanDownloader, worm, backdoor, remoteAccessTrojan, trojan, emailFlooder, keylogger, dialer, monitoringSoftware, browserModifier, cookie, browserPlugin, aolExploit, nuker, securityDisabler, jokeProgram, hostileActiveXControl, softwareBundler, stealthNotifier, settingsModifier, toolBar, remoteControlSoftware, trojanFtp, potentialUnwantedSoftware, icqExploit, trojanTelnet, exploit, filesharingProgram, malwareCreationTool, remote_Control_Software, tool, trojanDenialOfService, trojanDropper, trojanMassMailer, trojanMonitoringSoftware, trojanProxyServer, virus, known, unknown, spp, behavior, vulnerability, policy, enterpriseUnwantedSoftware, ransom, hipsRule.
        Returns: Optional[windows_malware_category.WindowsMalwareCategory]
        """
        return self._category
    
    @category.setter
    def category(self,value: Optional[windows_malware_category.WindowsMalwareCategory] = None) -> None:
        """
        Sets the category property value. Category of the malware. Possible values are: invalid, adware, spyware, passwordStealer, trojanDownloader, worm, backdoor, remoteAccessTrojan, trojan, emailFlooder, keylogger, dialer, monitoringSoftware, browserModifier, cookie, browserPlugin, aolExploit, nuker, securityDisabler, jokeProgram, hostileActiveXControl, softwareBundler, stealthNotifier, settingsModifier, toolBar, remoteControlSoftware, trojanFtp, potentialUnwantedSoftware, icqExploit, trojanTelnet, exploit, filesharingProgram, malwareCreationTool, remote_Control_Software, tool, trojanDenialOfService, trojanDropper, trojanMassMailer, trojanMonitoringSoftware, trojanProxyServer, virus, known, unknown, spp, behavior, vulnerability, policy, enterpriseUnwantedSoftware, ransom, hipsRule.
        Args:
            value: Value to set for the category property.
        """
        self._category = value
    
    def __init__(self,) -> None:
        """
        Instantiates a new windowsDeviceMalwareState and sets the default values.
        """
        super().__init__()
        # Information URL to learn more about the malware
        self._additional_information_url: Optional[str] = None
        # Category of the malware. Possible values are: invalid, adware, spyware, passwordStealer, trojanDownloader, worm, backdoor, remoteAccessTrojan, trojan, emailFlooder, keylogger, dialer, monitoringSoftware, browserModifier, cookie, browserPlugin, aolExploit, nuker, securityDisabler, jokeProgram, hostileActiveXControl, softwareBundler, stealthNotifier, settingsModifier, toolBar, remoteControlSoftware, trojanFtp, potentialUnwantedSoftware, icqExploit, trojanTelnet, exploit, filesharingProgram, malwareCreationTool, remote_Control_Software, tool, trojanDenialOfService, trojanDropper, trojanMassMailer, trojanMonitoringSoftware, trojanProxyServer, virus, known, unknown, spp, behavior, vulnerability, policy, enterpriseUnwantedSoftware, ransom, hipsRule.
        self._category: Optional[windows_malware_category.WindowsMalwareCategory] = None
        # Number of times the malware is detected
        self._detection_count: Optional[int] = None
        # Malware name
        self._display_name: Optional[str] = None
        # Execution status of the malware like blocked/executing etc. Possible values are: unknown, blocked, allowed, running, notRunning.
        self._execution_state: Optional[windows_malware_execution_state.WindowsMalwareExecutionState] = None
        # Initial detection datetime of the malware
        self._initial_detection_date_time: Optional[datetime] = None
        # The last time this particular threat was changed
        self._last_state_change_date_time: Optional[datetime] = None
        # The OdataType property
        self.odata_type: Optional[str] = None
        # Severity of the malware. Possible values are: unknown, low, moderate, high, severe.
        self._severity: Optional[windows_malware_severity.WindowsMalwareSeverity] = None
        # Current status of the malware like cleaned/quarantined/allowed etc. Possible values are: unknown, detected, cleaned, quarantined, removed, allowed, blocked, cleanFailed, quarantineFailed, removeFailed, allowFailed, abandoned, blockFailed.
        self._state: Optional[windows_malware_state.WindowsMalwareState] = None
        # Current status of the malware like cleaned/quarantined/allowed etc. Possible values are: active, actionFailed, manualStepsRequired, fullScanRequired, rebootRequired, remediatedWithNonCriticalFailures, quarantined, removed, cleaned, allowed, noStatusCleared.
        self._threat_state: Optional[windows_malware_threat_state.WindowsMalwareThreatState] = None
    
    @staticmethod
    def create_from_discriminator_value(parse_node: Optional[ParseNode] = None) -> WindowsDeviceMalwareState:
        """
        Creates a new instance of the appropriate class based on discriminator value
        Args:
            parseNode: The parse node to use to read the discriminator value and create the object
        Returns: WindowsDeviceMalwareState
        """
        if parse_node is None:
            raise Exception("parse_node cannot be undefined")
        return WindowsDeviceMalwareState()
    
    @property
    def detection_count(self,) -> Optional[int]:
        """
        Gets the detectionCount property value. Number of times the malware is detected
        Returns: Optional[int]
        """
        return self._detection_count
    
    @detection_count.setter
    def detection_count(self,value: Optional[int] = None) -> None:
        """
        Sets the detectionCount property value. Number of times the malware is detected
        Args:
            value: Value to set for the detectionCount property.
        """
        self._detection_count = value
    
    @property
    def display_name(self,) -> Optional[str]:
        """
        Gets the displayName property value. Malware name
        Returns: Optional[str]
        """
        return self._display_name
    
    @display_name.setter
    def display_name(self,value: Optional[str] = None) -> None:
        """
        Sets the displayName property value. Malware name
        Args:
            value: Value to set for the displayName property.
        """
        self._display_name = value
    
    @property
    def execution_state(self,) -> Optional[windows_malware_execution_state.WindowsMalwareExecutionState]:
        """
        Gets the executionState property value. Execution status of the malware like blocked/executing etc. Possible values are: unknown, blocked, allowed, running, notRunning.
        Returns: Optional[windows_malware_execution_state.WindowsMalwareExecutionState]
        """
        return self._execution_state
    
    @execution_state.setter
    def execution_state(self,value: Optional[windows_malware_execution_state.WindowsMalwareExecutionState] = None) -> None:
        """
        Sets the executionState property value. Execution status of the malware like blocked/executing etc. Possible values are: unknown, blocked, allowed, running, notRunning.
        Args:
            value: Value to set for the executionState property.
        """
        self._execution_state = value
    
    def get_field_deserializers(self,) -> Dict[str, Callable[[ParseNode], None]]:
        """
        The deserialization information for the current model
        Returns: Dict[str, Callable[[ParseNode], None]]
        """
        fields = {
            "additional_information_url": lambda n : setattr(self, 'additional_information_url', n.get_str_value()),
            "category": lambda n : setattr(self, 'category', n.get_enum_value(windows_malware_category.WindowsMalwareCategory)),
            "detection_count": lambda n : setattr(self, 'detection_count', n.get_int_value()),
            "display_name": lambda n : setattr(self, 'display_name', n.get_str_value()),
            "execution_state": lambda n : setattr(self, 'execution_state', n.get_enum_value(windows_malware_execution_state.WindowsMalwareExecutionState)),
            "initial_detection_date_time": lambda n : setattr(self, 'initial_detection_date_time', n.get_datetime_value()),
            "last_state_change_date_time": lambda n : setattr(self, 'last_state_change_date_time', n.get_datetime_value()),
            "severity": lambda n : setattr(self, 'severity', n.get_enum_value(windows_malware_severity.WindowsMalwareSeverity)),
            "state": lambda n : setattr(self, 'state', n.get_enum_value(windows_malware_state.WindowsMalwareState)),
            "threat_state": lambda n : setattr(self, 'threat_state', n.get_enum_value(windows_malware_threat_state.WindowsMalwareThreatState)),
        }
        super_fields = super().get_field_deserializers()
        fields.update(super_fields)
        return fields
    
    @property
    def initial_detection_date_time(self,) -> Optional[datetime]:
        """
        Gets the initialDetectionDateTime property value. Initial detection datetime of the malware
        Returns: Optional[datetime]
        """
        return self._initial_detection_date_time
    
    @initial_detection_date_time.setter
    def initial_detection_date_time(self,value: Optional[datetime] = None) -> None:
        """
        Sets the initialDetectionDateTime property value. Initial detection datetime of the malware
        Args:
            value: Value to set for the initialDetectionDateTime property.
        """
        self._initial_detection_date_time = value
    
    @property
    def last_state_change_date_time(self,) -> Optional[datetime]:
        """
        Gets the lastStateChangeDateTime property value. The last time this particular threat was changed
        Returns: Optional[datetime]
        """
        return self._last_state_change_date_time
    
    @last_state_change_date_time.setter
    def last_state_change_date_time(self,value: Optional[datetime] = None) -> None:
        """
        Sets the lastStateChangeDateTime property value. The last time this particular threat was changed
        Args:
            value: Value to set for the lastStateChangeDateTime property.
        """
        self._last_state_change_date_time = value
    
    def serialize(self,writer: SerializationWriter) -> None:
        """
        Serializes information the current object
        Args:
            writer: Serialization writer to use to serialize this model
        """
        if writer is None:
            raise Exception("writer cannot be undefined")
        super().serialize(writer)
        writer.write_str_value("additionalInformationUrl", self.additional_information_url)
        writer.write_enum_value("category", self.category)
        writer.write_int_value("detectionCount", self.detection_count)
        writer.write_str_value("displayName", self.display_name)
        writer.write_enum_value("executionState", self.execution_state)
        writer.write_datetime_value("initialDetectionDateTime", self.initial_detection_date_time)
        writer.write_datetime_value("lastStateChangeDateTime", self.last_state_change_date_time)
        writer.write_enum_value("severity", self.severity)
        writer.write_enum_value("state", self.state)
        writer.write_enum_value("threatState", self.threat_state)
    
    @property
    def severity(self,) -> Optional[windows_malware_severity.WindowsMalwareSeverity]:
        """
        Gets the severity property value. Severity of the malware. Possible values are: unknown, low, moderate, high, severe.
        Returns: Optional[windows_malware_severity.WindowsMalwareSeverity]
        """
        return self._severity
    
    @severity.setter
    def severity(self,value: Optional[windows_malware_severity.WindowsMalwareSeverity] = None) -> None:
        """
        Sets the severity property value. Severity of the malware. Possible values are: unknown, low, moderate, high, severe.
        Args:
            value: Value to set for the severity property.
        """
        self._severity = value
    
    @property
    def state(self,) -> Optional[windows_malware_state.WindowsMalwareState]:
        """
        Gets the state property value. Current status of the malware like cleaned/quarantined/allowed etc. Possible values are: unknown, detected, cleaned, quarantined, removed, allowed, blocked, cleanFailed, quarantineFailed, removeFailed, allowFailed, abandoned, blockFailed.
        Returns: Optional[windows_malware_state.WindowsMalwareState]
        """
        return self._state
    
    @state.setter
    def state(self,value: Optional[windows_malware_state.WindowsMalwareState] = None) -> None:
        """
        Sets the state property value. Current status of the malware like cleaned/quarantined/allowed etc. Possible values are: unknown, detected, cleaned, quarantined, removed, allowed, blocked, cleanFailed, quarantineFailed, removeFailed, allowFailed, abandoned, blockFailed.
        Args:
            value: Value to set for the state property.
        """
        self._state = value
    
    @property
    def threat_state(self,) -> Optional[windows_malware_threat_state.WindowsMalwareThreatState]:
        """
        Gets the threatState property value. Current status of the malware like cleaned/quarantined/allowed etc. Possible values are: active, actionFailed, manualStepsRequired, fullScanRequired, rebootRequired, remediatedWithNonCriticalFailures, quarantined, removed, cleaned, allowed, noStatusCleared.
        Returns: Optional[windows_malware_threat_state.WindowsMalwareThreatState]
        """
        return self._threat_state
    
    @threat_state.setter
    def threat_state(self,value: Optional[windows_malware_threat_state.WindowsMalwareThreatState] = None) -> None:
        """
        Sets the threatState property value. Current status of the malware like cleaned/quarantined/allowed etc. Possible values are: active, actionFailed, manualStepsRequired, fullScanRequired, rebootRequired, remediatedWithNonCriticalFailures, quarantined, removed, cleaned, allowed, noStatusCleared.
        Args:
            value: Value to set for the threatState property.
        """
        self._threat_state = value
    

