from __future__ import annotations
from datetime import datetime
from kiota_abstractions.serialization import Parsable, ParseNode, SerializationWriter
from kiota_abstractions.utils import lazy_import
from typing import Any, Callable, Dict, List, Optional, Union

entity = lazy_import('msgraph.generated.models.entity')

class AppVulnerabilityMobileApp(entity.Entity):
    """
    An app vulnerability mobile app.
    """
    def __init__(self,) -> None:
        """
        Instantiates a new appVulnerabilityMobileApp and sets the default values.
        """
        super().__init__()
        # The created date.
        self._created_date_time: Optional[datetime] = None
        # The device name.
        self._display_name: Optional[str] = None
        # The last modified date.
        self._last_modified_date_time: Optional[datetime] = None
        # The Intune mobile app ID.
        self._mobile_app_id: Optional[str] = None
        # The app type.
        self._mobile_app_type: Optional[str] = None
        # The OdataType property
        self.odata_type: Optional[str] = None
        # The app version.
        self._version: Optional[str] = None
    
    @property
    def created_date_time(self,) -> Optional[datetime]:
        """
        Gets the createdDateTime property value. The created date.
        Returns: Optional[datetime]
        """
        return self._created_date_time
    
    @created_date_time.setter
    def created_date_time(self,value: Optional[datetime] = None) -> None:
        """
        Sets the createdDateTime property value. The created date.
        Args:
            value: Value to set for the createdDateTime property.
        """
        self._created_date_time = value
    
    @staticmethod
    def create_from_discriminator_value(parse_node: Optional[ParseNode] = None) -> AppVulnerabilityMobileApp:
        """
        Creates a new instance of the appropriate class based on discriminator value
        Args:
            parseNode: The parse node to use to read the discriminator value and create the object
        Returns: AppVulnerabilityMobileApp
        """
        if parse_node is None:
            raise Exception("parse_node cannot be undefined")
        return AppVulnerabilityMobileApp()
    
    @property
    def display_name(self,) -> Optional[str]:
        """
        Gets the displayName property value. The device name.
        Returns: Optional[str]
        """
        return self._display_name
    
    @display_name.setter
    def display_name(self,value: Optional[str] = None) -> None:
        """
        Sets the displayName property value. The device name.
        Args:
            value: Value to set for the displayName property.
        """
        self._display_name = value
    
    def get_field_deserializers(self,) -> Dict[str, Callable[[ParseNode], None]]:
        """
        The deserialization information for the current model
        Returns: Dict[str, Callable[[ParseNode], None]]
        """
        fields = {
            "created_date_time": lambda n : setattr(self, 'created_date_time', n.get_datetime_value()),
            "display_name": lambda n : setattr(self, 'display_name', n.get_str_value()),
            "last_modified_date_time": lambda n : setattr(self, 'last_modified_date_time', n.get_datetime_value()),
            "mobile_app_id": lambda n : setattr(self, 'mobile_app_id', n.get_str_value()),
            "mobile_app_type": lambda n : setattr(self, 'mobile_app_type', n.get_str_value()),
            "version": lambda n : setattr(self, 'version', n.get_str_value()),
        }
        super_fields = super().get_field_deserializers()
        fields.update(super_fields)
        return fields
    
    @property
    def last_modified_date_time(self,) -> Optional[datetime]:
        """
        Gets the lastModifiedDateTime property value. The last modified date.
        Returns: Optional[datetime]
        """
        return self._last_modified_date_time
    
    @last_modified_date_time.setter
    def last_modified_date_time(self,value: Optional[datetime] = None) -> None:
        """
        Sets the lastModifiedDateTime property value. The last modified date.
        Args:
            value: Value to set for the lastModifiedDateTime property.
        """
        self._last_modified_date_time = value
    
    @property
    def mobile_app_id(self,) -> Optional[str]:
        """
        Gets the mobileAppId property value. The Intune mobile app ID.
        Returns: Optional[str]
        """
        return self._mobile_app_id
    
    @mobile_app_id.setter
    def mobile_app_id(self,value: Optional[str] = None) -> None:
        """
        Sets the mobileAppId property value. The Intune mobile app ID.
        Args:
            value: Value to set for the mobileAppId property.
        """
        self._mobile_app_id = value
    
    @property
    def mobile_app_type(self,) -> Optional[str]:
        """
        Gets the mobileAppType property value. The app type.
        Returns: Optional[str]
        """
        return self._mobile_app_type
    
    @mobile_app_type.setter
    def mobile_app_type(self,value: Optional[str] = None) -> None:
        """
        Sets the mobileAppType property value. The app type.
        Args:
            value: Value to set for the mobileAppType property.
        """
        self._mobile_app_type = value
    
    def serialize(self,writer: SerializationWriter) -> None:
        """
        Serializes information the current object
        Args:
            writer: Serialization writer to use to serialize this model
        """
        if writer is None:
            raise Exception("writer cannot be undefined")
        super().serialize(writer)
        writer.write_datetime_value("createdDateTime", self.created_date_time)
        writer.write_str_value("displayName", self.display_name)
        writer.write_datetime_value("lastModifiedDateTime", self.last_modified_date_time)
        writer.write_str_value("mobileAppId", self.mobile_app_id)
        writer.write_str_value("mobileAppType", self.mobile_app_type)
        writer.write_str_value("version", self.version)
    
    @property
    def version(self,) -> Optional[str]:
        """
        Gets the version property value. The app version.
        Returns: Optional[str]
        """
        return self._version
    
    @version.setter
    def version(self,value: Optional[str] = None) -> None:
        """
        Sets the version property value. The app version.
        Args:
            value: Value to set for the version property.
        """
        self._version = value
    

