#  Copyright (C) 2016 The Gvsbuild Authors
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, see <http://www.gnu.org/licenses/>.

from gvsbuild.utils.base_builders import Meson
from gvsbuild.utils.base_expanders import NullExpander
from gvsbuild.utils.base_project import Project, project_add


@project_add
class CheckLibs(NullExpander, Meson):
    def __init__(self):
        Project.__init__(
            self,
            "check-libs",
            dependencies=[
                # Used to build the various tests
                "meson",
                "ninja",
                "pkgconf",
                # libraries to test, hopefully all the one we build!
                "atk",
                "cairo",
                "freetype",
                "gdk-pixbuf",
                "glib",
                "json-glib",
                "libarchive",
                "libcurl",
                "libffi",
                "libjpeg-turbo",
                "libpng",
                "libtiff-4",
                "libxml2",
                "libyuv",
                "pango",
                "zlib",
            ],
            version="0.1.0",
            internal=True,
        )

    def build(self):
        Meson.build(self, make_tests=True)
        self.install(r".\COPYING share\doc\check-libs")
