<!--
    DO NOT MANUALLY EDIT THIS FILE
    THIS FILE IS AUTOMATICALLY GENERATED WITH resilient-sdk codegen
    Generated with resilient-sdk v50.0.0
-->

# Playbook - test_resilient_sdk

### API Name
`test_resilient_sdk`

### Status
`draft`

### Activation Type
`Manual`

### Activation Conditions
`-`

### Activation Form Elements
| Input Field Label | API Name | Element Type | Tooltip | Requirement |
| ----------------- | -------- | ------------ | ------- | ----------- |
| Is Playbook | `schedule_is_playbook` | boolean | Yes - Playbook, No - Rule | Always |
| Schedule Label Prefix | `schedule_label_prefix` | text | name of schedule for future reference | Always |
| Schedule Rule Name | `schedule_rule_name` | text | Name of Rule to schedule | Always |
| Schedule Rule Parameters | `schedule_rule_parameters` | text | field1=value;field2=value format of optional rule parameters | Optional |
| Schedule Type | `schedule_type` | select | - | Optional |
| Schedule Type Value | `schedule_type_value` | text | cron (* 5 * * *); date (yyyy/mm/dd hh:mm:ss) ; interval (10m) | Always |

### Object Type
`incident`

### Description
Schedule a rule/playbook to run in the future for a given incident


---
## Function - Scheduled Rule Create

### API Name
`create_a_scheduled_rule`

### Output Name
`output_scheduled_rule_create`

### Message Destination
`fn_scheduler`

### Function-Input Script
```python
inputs.scheduler_type = getattr(playbook.inputs, "schedule_type", "cron")

if getattr(playbook.inputs, "schedule_type", "cron") == "date":
  # date format converted to use dashes
  inputs.scheduler_type_value = getattr(playbook.inputs, "schedule_type_value", "").replace("/", "-")
else:
  inputs.scheduler_type_value = getattr(playbook.inputs, "schedule_type_value", "")

inputs.scheduler_rule_name = getattr(playbook.inputs, "schedule_rule_name", None)
inputs.scheduler_rule_parameters = getattr(playbook.inputs, "schedule_rule_parameters", None)
inputs.scheduler_label_prefix = getattr(playbook.inputs, "schedule_label_prefix", None)
inputs.incident_id = incident.id
inputs.scheduler_is_playbook = getattr(playbook.inputs, "schedule_is_playbook", False)

```

---
## Function - Scheduled Rule Pause

### API Name
`scheduled_rule_pause`

### Output Name
`output_scheduler_pause`

### Message Destination
`fn_scheduler`

### Function-Input Script
```python
'''



PREPROCESSING FUNCTION




'''
```

---

## Global script - Write scheduled job to DataTable

### Description
Write out scheduled job information to a datatable

### Script Type
`Global script`

### Object Type
`incident`

### Script Content
```python
from datetime import datetime

results = playbook.functions.results.output_scheduled_rule_create
now = datetime.now().strftime("%Y-%m-%d %H:%M:%S") # '2023-03-24 11:28:34'
TYPE_LOOKUP = {
  0: 'Incident',
  1: "Task",
  4: "Artifact",
  5: "Attachment"}

if results.get("success"):
  job = results.get("content")
  row = incident.addRow("scheduler_rules")
  row['reported_on'] = now
  row['schedule_label'] = job['id']
  row['schedule_type'] = job['type']
  row['incident_id'] = job['args'][0]
  row['schedule'] = job['value']
  row['status'] = 'Active'
  row['next_run_time'] = job['next_run_time']
  row['rule_type'] = TYPE_LOOKUP.get(job['args'][6], "Datatable")
  if job['args'][8]:
    row['rule'] = "<a href='#playbooks/designer/{}'>{}</a>".format(job['args'][5], job['args'][4])
  else:
    row['rule'] = "<a href='#customize?tab=actions&id={}'>{}</a>".format(job['args'][5], job['args'][4])
else:
  incident.addNote("Schedule a Rule/Playbook failed: {}".format(result.get("reason")))
```

---
## Local script - limestone_script

### Description
ASCII art : limestone

### Script Type
`Local script`

### Object Type
`incident`

### Script Content
```python
'''
  \/________________        
 /     _____________)
/     /     /   \ |         
\/\/\/     (O) (O)|           
  |           ------, 
  |  _       ______/ 
  | (_      /   \  \
  |        /  ___\_ \       
  |        \      / / 
__|_________\______/
\______________\./__\   
 /     .       | \  |
 \    /_\   .  |  \ |\     
 |`\       /_\ |   \| \
'''
```

---
## Local script - syl_script

### Description
ASCII art : syl

### Script Type
`Local script`

### Object Type
`incident`

### Script Content
```python
'''
               / ,
          /\  \|/  /\
          |\\_;=._//|
           \."   "./
           //^\ /^\\
    .'``",/ |0| |0| \,"``'.
   /   ,  `'\.---./'`  ,   \
  /`  /`\,."(     )".,/`\  `\
  /`     ( '.'-.-'.' )     `\
  /"`     "._  :  _."     `"\
   `/.'`"=.,_``=``_,.="`'.\`
             )   (
'''
```

---
## Global script - workflow_sample_global_Script

### Description


### Script Type
`Global script`

### Object Type
`incident`

### Script Content
```python
'''
  \/________________        
 /     _____________)
/     /     /   \ |         
\/\/\/     (O) (O)|           
  |           ------, 
  |  _       ______/ 
  | (_      /   \  \
  |        /  ___\_ \       
  |        \      / / 
__|_________\______/
\______________\./__\   
 /     .       | \  |
 \    /_\   .  |  \ |\     
 |`\       /_\ |   \| \
'''
```

---

