{
  "action_order" : [ "5e0a9aa8-ebcd-44be-a5e9-576ffd7e84d7", "7e4fde55-675f-4670-a7ae-0953e0c10df3", "db0ba772-68e4-44ba-8d3f-3777bbe6922b", "74fd8a53-d9eb-412f-9f61-648a439bad80", "1a40ade8-928f-4a1f-8c3f-aa2b4b626f21", "675efc08-9a7f-460f-889c-03946bfca4d4", "88e299bd-537a-4694-a9db-64e931cd58f0", "939fb492-e05f-4bf0-a859-7508a217596a", "ec007716-92da-496f-86da-3f4edf7293f2", "60c0b1c3-36bd-4b74-aac6-27c5a954d004", "9869bd4a-9a75-4951-9065-edd6d4fa5b34", "77b1d95d-e075-4726-bf68-cd0b609e6444", "ce68e00b-2539-4da1-8611-d60091e10b6c", "b63091d4-2a67-44df-b117-299061d8f65c" ],
  "actions" : [ {
    "automations" : [ {
      "tasks_to_create" : [ "notify_law_enforcement" ],
      "type" : "create_task",
      "value" : null
    } ],
    "conditions" : [ {
      "evaluation_id" : null,
      "field_name" : "incident.crimestatus_id",
      "method" : "equals",
      "type" : null,
      "value" : "Yes"
    }, {
      "evaluation_id" : null,
      "field_name" : "incident.incident_type_ids",
      "method" : "includes_hierarchical",
      "type" : null,
      "value" : [ "Phishing", "Malware", "TBD / Unknown", "Denial of Service", "System Intrusion" ]
    } ],
    "enabled" : true,
    "export_key" : "Cyber: Criminal",
    "id" : 12,
    "logic_type" : "all",
    "message_destinations" : [ ],
    "name" : "Cyber: Criminal",
    "object_type" : "incident",
    "tags" : [ ],
    "timeout_seconds" : 86400,
    "type" : 0,
    "uuid" : "7e4fde55-675f-4670-a7ae-0953e0c10df3",
    "view_items" : [ ],
    "workflows" : [ ]
  }, {
    "automations" : [ {
      "tasks_to_create" : [ "ensure_appropriate_evidence_collection_and_preservation", "notify_legal_counsel_of_any_illegal_or_inappropriate_activity" ],
      "type" : "create_task",
      "value" : null
    } ],
    "conditions" : [ {
      "evaluation_id" : null,
      "field_name" : "incident.crimestatus_id",
      "method" : "in",
      "type" : null,
      "value" : [ "Yes - Freeze Tasks", "Yes" ]
    }, {
      "evaluation_id" : null,
      "field_name" : "incident.incident_type_ids",
      "method" : "includes_hierarchical",
      "type" : null,
      "value" : [ "Phishing", "Malware", "TBD / Unknown", "Denial of Service", "System Intrusion" ]
    } ],
    "enabled" : true,
    "export_key" : "Cyber: Criminal evidence preservation",
    "id" : 9,
    "logic_type" : "all",
    "message_destinations" : [ ],
    "name" : "Cyber: Criminal evidence preservation",
    "object_type" : "incident",
    "tags" : [ ],
    "timeout_seconds" : 86400,
    "type" : 0,
    "uuid" : "db0ba772-68e4-44ba-8d3f-3777bbe6922b",
    "view_items" : [ ],
    "workflows" : [ ]
  }, {
    "automations" : [ {
      "tasks_to_create" : [ "determine_if_illegal_activity_is_involved" ],
      "type" : "create_task",
      "value" : null
    } ],
    "conditions" : [ {
      "evaluation_id" : null,
      "field_name" : "incident.crimestatus_id",
      "method" : "equals",
      "type" : null,
      "value" : "Unknown"
    }, {
      "evaluation_id" : null,
      "field_name" : "incident.incident_type_ids",
      "method" : "includes_hierarchical",
      "type" : null,
      "value" : [ "Phishing", "Malware", "TBD / Unknown", "Denial of Service", "System Intrusion" ]
    } ],
    "enabled" : true,
    "export_key" : "Cyber: Criminal status unknown",
    "id" : 11,
    "logic_type" : "all",
    "message_destinations" : [ ],
    "name" : "Cyber: Criminal status unknown",
    "object_type" : "incident",
    "tags" : [ ],
    "timeout_seconds" : 86400,
    "type" : 0,
    "uuid" : "74fd8a53-d9eb-412f-9f61-648a439bad80",
    "view_items" : [ ],
    "workflows" : [ ]
  }, {
    "automations" : [ {
      "tasks_to_create" : [ "configure_egress_filters", "contact_owners_of_systems_being_used_to_mount_the_dos_attack", "contact_your_isp", "quantify_the_dos_attack_and_traffic", "review_and_respond_to_contractual_obligations_related_to_intrusion_or_loss_of_service", "review_os_and_application_logs", "switch_to_alternate_sites_or_networks", "terminate_unwanted_dos_connections_or_processes", "throttle_or_block_dos_traffic" ],
      "type" : "create_task",
      "value" : null
    } ],
    "conditions" : [ {
      "evaluation_id" : null,
      "field_name" : "incident.incident_type_ids",
      "method" : "includes_hierarchical",
      "type" : null,
      "value" : [ "Denial of Service" ]
    } ],
    "enabled" : true,
    "export_key" : "Cyber: DoS",
    "id" : 5,
    "logic_type" : "all",
    "message_destinations" : [ ],
    "name" : "Cyber: DoS",
    "object_type" : "incident",
    "tags" : [ ],
    "timeout_seconds" : 86400,
    "type" : 0,
    "uuid" : "1a40ade8-928f-4a1f-8c3f-aa2b4b626f21",
    "view_items" : [ ],
    "workflows" : [ ]
  }, {
    "automations" : [ {
      "tasks_to_create" : [ "determine_if_inappropriate_internal_involvement" ],
      "type" : "create_task",
      "value" : null
    } ],
    "conditions" : [ {
      "evaluation_id" : null,
      "field_name" : "incident.employee_involved",
      "method" : "equals",
      "type" : null,
      "value" : null
    }, {
      "evaluation_id" : null,
      "field_name" : "incident.incident_type_ids",
      "method" : "includes_hierarchical",
      "type" : null,
      "value" : [ "Phishing", "Malware", "TBD / Unknown", "Denial of Service", "System Intrusion" ]
    } ],
    "enabled" : true,
    "export_key" : "Cyber:  Employee involved unknown",
    "id" : 8,
    "logic_type" : "all",
    "message_destinations" : [ ],
    "name" : "Cyber:  Employee involved unknown",
    "object_type" : "incident",
    "tags" : [ ],
    "timeout_seconds" : 86400,
    "type" : 0,
    "uuid" : "5e0a9aa8-ebcd-44be-a5e9-576ffd7e84d7",
    "view_items" : [ ],
    "workflows" : [ ]
  }, {
    "automations" : [ {
      "tasks_to_create" : [ "notify_hr" ],
      "type" : "create_task",
      "value" : null
    } ],
    "conditions" : [ {
      "evaluation_id" : null,
      "field_name" : "incident.employee_involved",
      "method" : "equals",
      "type" : null,
      "value" : true
    }, {
      "evaluation_id" : null,
      "field_name" : "incident.incident_type_ids",
      "method" : "includes_hierarchical",
      "type" : null,
      "value" : [ "Phishing", "Malware", "TBD / Unknown", "Denial of Service", "System Intrusion" ]
    } ],
    "enabled" : true,
    "export_key" : "Cyber: Employee is involved",
    "id" : 10,
    "logic_type" : "all",
    "message_destinations" : [ ],
    "name" : "Cyber: Employee is involved",
    "object_type" : "incident",
    "tags" : [ ],
    "timeout_seconds" : 86400,
    "type" : 0,
    "uuid" : "675efc08-9a7f-460f-889c-03946bfca4d4",
    "view_items" : [ ],
    "workflows" : [ ]
  }, {
    "automations" : [ {
      "tasks_to_create" : [ "generate_incident_report", "initial_triage", "interview_key_individuals", "notify_computer_security_organizations_and_resources", "notify_constituents_resolution", "notify_constituents_status_update", "notify_internal_management_chain_preliminary", "notify_internal_management_chain_resolution", "post_incident_review", "properly_dispose_of_incident_information", "remove_temporary_containment_measures", "research_current_attack_intelligence_and_recent_vulnerabilities", "update_internal_management_team_as_appropriate_assessment", "update_policies_and_procedures" ],
      "type" : "create_task",
      "value" : null
    } ],
    "conditions" : [ {
      "evaluation_id" : null,
      "field_name" : "incident.incident_type_ids",
      "method" : "includes_hierarchical",
      "type" : null,
      "value" : [ "Phishing", "Malware", "TBD / Unknown", "Denial of Service", "System Intrusion" ]
    } ],
    "enabled" : true,
    "export_key" : "Cyber: General",
    "id" : 4,
    "logic_type" : "all",
    "message_destinations" : [ ],
    "name" : "Cyber: General",
    "object_type" : "incident",
    "tags" : [ ],
    "timeout_seconds" : 86400,
    "type" : 0,
    "uuid" : "88e299bd-537a-4694-a9db-64e931cd58f0",
    "view_items" : [ ],
    "workflows" : [ ]
  }, {
    "automations" : [ {
      "tasks_to_create" : [ "harden_andor_patch_all_other_vulnerable_systems", "notify_external_parties_as_appropriate" ],
      "type" : "create_task",
      "value" : null
    } ],
    "conditions" : [ {
      "evaluation_id" : null,
      "field_name" : "incident.incident_type_ids",
      "method" : "includes_hierarchical",
      "type" : null,
      "value" : [ "Denial of Service", "Malware", "System Intrusion" ]
    } ],
    "enabled" : true,
    "export_key" : "Cyber: General Intrusion",
    "id" : 6,
    "logic_type" : "all",
    "message_destinations" : [ ],
    "name" : "Cyber: General Intrusion",
    "object_type" : "incident",
    "tags" : [ ],
    "timeout_seconds" : 86400,
    "type" : 0,
    "uuid" : "939fb492-e05f-4bf0-a859-7508a217596a",
    "view_items" : [ ],
    "workflows" : [ ]
  }, {
    "automations" : [ {
      "tasks_to_create" : [ "analyze_malware_infected_systems", "analyze_network_traffic_for_malware_activity", "apply_type_specific_malware_containment_measures", "define_and_document_malware_eradication_strategy", "disconnect_or_isolate_malware_infected_systems", "ensure_updated_antivirus_signatures_are_deployed", "identify_specific_malware_infected_devices", "recover_each_malware_infected_system", "research_av_vendor_databases", "review_the_output_and_status_of_anti_virus_software", "sandbox_malware_infected_systems" ],
      "type" : "create_task",
      "value" : null
    } ],
    "conditions" : [ {
      "evaluation_id" : null,
      "field_name" : "incident.incident_type_ids",
      "method" : "includes_hierarchical",
      "type" : null,
      "value" : [ "Malware" ]
    } ],
    "enabled" : true,
    "export_key" : "Cyber: Malware",
    "id" : 3,
    "logic_type" : "all",
    "message_destinations" : [ ],
    "name" : "Cyber: Malware",
    "object_type" : "incident",
    "tags" : [ ],
    "timeout_seconds" : 86400,
    "type" : 0,
    "uuid" : "ec007716-92da-496f-86da-3f4edf7293f2",
    "view_items" : [ ],
    "workflows" : [ ]
  }, {
    "automations" : [ {
      "tasks_to_create" : [ "change_deviceapplication_passwords", "notify_carrierisp", "remote_wipelock" ],
      "type" : "create_task",
      "value" : null
    } ],
    "conditions" : [ {
      "evaluation_id" : null,
      "field_name" : "incident.incident_type_ids",
      "method" : "includes_hierarchical",
      "type" : null,
      "value" : [ "Lost PDA / smartphone", "Stolen PC / laptop / tablet", "Stolen PDA / smartphone", "Lost PC / laptop / tablet" ]
    } ],
    "enabled" : true,
    "export_key" : "Cyber: Mobile device lost/stolen",
    "id" : 7,
    "logic_type" : "all",
    "message_destinations" : [ ],
    "name" : "Cyber: Mobile device lost/stolen",
    "object_type" : "incident",
    "tags" : [ ],
    "timeout_seconds" : 86400,
    "type" : 0,
    "uuid" : "60c0b1c3-36bd-4b74-aac6-27c5a954d004",
    "view_items" : [ ],
    "workflows" : [ ]
  }, {
    "automations" : [ {
      "tasks_to_create" : [ "notify_public_relations_department" ],
      "type" : "create_task",
      "value" : null
    } ],
    "conditions" : [ {
      "evaluation_id" : 3,
      "field_name" : "incident.incident_type_ids",
      "method" : "includes_hierarchical",
      "type" : null,
      "value" : [ "Phishing", "Malware", "TBD / Unknown", "Denial of Service", "System Intrusion" ]
    }, {
      "evaluation_id" : 1,
      "field_name" : "incident.negative_pr_likely",
      "method" : "equals",
      "type" : null,
      "value" : true
    }, {
      "evaluation_id" : 2,
      "field_name" : "incident.negative_pr_likely",
      "method" : "equals",
      "type" : null,
      "value" : null
    } ],
    "custom_condition" : "(1 OR 2) AND 3",
    "enabled" : true,
    "export_key" : "Cyber: Negative PR",
    "id" : 13,
    "logic_type" : "advanced",
    "message_destinations" : [ ],
    "name" : "Cyber: Negative PR",
    "object_type" : "incident",
    "tags" : [ ],
    "timeout_seconds" : 86400,
    "type" : 0,
    "uuid" : "9869bd4a-9a75-4951-9065-edd6d4fa5b34",
    "view_items" : [ ],
    "workflows" : [ ]
  }, {
    "automations" : [ {
      "tasks_to_create" : [ "analyze_headers_of_suspected_email_messages", "determine_the_techniques_being_used_to_engage_targets", "file_a_false_whois_complaint_with_icann", "notify_the_owners_of_any_systems_being_used_in_the_phishing_attack", "provide_end_user_remediation_guidance_for_phishing_and_identify_theft", "report_suspicious_activity_to_the_ftc", "take_steps_to_limit_propagation_or_execution_of_the_phishing_attacks" ],
      "type" : "create_task",
      "value" : null
    } ],
    "conditions" : [ {
      "evaluation_id" : null,
      "field_name" : "incident.incident_type_ids",
      "method" : "includes_hierarchical",
      "type" : null,
      "value" : [ "Phishing" ]
    } ],
    "enabled" : true,
    "export_key" : "Cyber: Phishing",
    "id" : 1,
    "logic_type" : "all",
    "message_destinations" : [ ],
    "name" : "Cyber: Phishing",
    "object_type" : "incident",
    "tags" : [ ],
    "timeout_seconds" : 86400,
    "type" : 0,
    "uuid" : "77b1d95d-e075-4726-bf68-cd0b609e6444",
    "view_items" : [ ],
    "workflows" : [ ]
  }, {
    "automations" : [ {
      "tasks_to_create" : [ "analyze_application_data_for_signs_of_intrusion", "analyze_intruded_systems", "analyze_network_traffic_for_signs_of_intrusion", "collect_volatile_system_data", "create_backups_of_affected_systems", "determine_an_appropriate_eradication_or_recovery_strategy", "disconnect_compromised_systems", "look_for_modifications_made_to_system_software_and_configuration_files", "look_for_signs_of_network_sniffers", "look_for_tools_and_data_left_behind_by_the_intruder", "recover_affected_systems", "review_and_respond_to_contractual_obligations_related_to_intrusion_or_loss_of_service", "select_initial_containment_strategy" ],
      "type" : "create_task",
      "value" : null
    } ],
    "conditions" : [ {
      "evaluation_id" : null,
      "field_name" : "incident.incident_type_ids",
      "method" : "includes_hierarchical",
      "type" : null,
      "value" : [ "System Intrusion" ]
    } ],
    "enabled" : true,
    "export_key" : "Cyber: System Intrusion",
    "id" : 2,
    "logic_type" : "all",
    "message_destinations" : [ ],
    "name" : "Cyber: System Intrusion",
    "object_type" : "incident",
    "tags" : [ ],
    "timeout_seconds" : 86400,
    "type" : 0,
    "uuid" : "ce68e00b-2539-4da1-8611-d60091e10b6c",
    "view_items" : [ ],
    "workflows" : [ ]
  }, {
    "automations" : [ ],
    "conditions" : [ {
      "evaluation_id" : null,
      "field_name" : null,
      "method" : "object_added",
      "type" : null,
      "value" : null
    } ],
    "enabled" : true,
    "export_key" : "Mock: Auto Rule",
    "id" : 18,
    "logic_type" : "all",
    "message_destinations" : [ ],
    "name" : "Mock: Auto Rule",
    "object_type" : "incident",
    "tags" : [ {
      "tag_handle" : "fn_main_mock_integration",
      "value" : null
    } ],
    "timeout_seconds" : 86400,
    "type" : 0,
    "uuid" : "b63091d4-2a67-44df-b117-299061d8f65c",
    "view_items" : [ ],
    "workflows" : [ "mock_workflow_one" ]
  }, {
    "automations" : [ ],
    "conditions" : [ ],
    "enabled" : true,
    "export_key" : "Mock Manual Rule",
    "id" : 14,
    "logic_type" : "all",
    "message_destinations" : [ ],
    "name" : "Mock Manual Rule",
    "object_type" : "artifact",
    "tags" : [ {
      "tag_handle" : "fn_main_mock_integration",
      "value" : null
    } ],
    "timeout_seconds" : 86400,
    "type" : 1,
    "uuid" : "7f4830d2-ce93-4d77-8318-1801da57921f",
    "view_items" : [ ],
    "workflows" : [ "mock_workflow_one" ]
  }, {
    "automations" : [ ],
    "conditions" : [ ],
    "enabled" : true,
    "export_key" : "Mock Manual Rule Message Destination",
    "id" : 15,
    "logic_type" : "all",
    "message_destinations" : [ "fn_test_two" ],
    "name" : "Mock Manual Rule Message Destination",
    "object_type" : "incident",
    "tags" : [ {
      "tag_handle" : "fn_main_mock_integration",
      "value" : null
    } ],
    "timeout_seconds" : 86400,
    "type" : 1,
    "uuid" : "32fc2626-bd73-43df-887b-01b21c508ee9",
    "view_items" : [ ],
    "workflows" : [ ]
  }, {
    "automations" : [ {
      "scripts_to_run" : "Mock Incident Script",
      "type" : "run_script",
      "value" : null
    }, {
      "tasks_to_create" : [ "mock_custom_task_one" ],
      "type" : "create_task",
      "value" : null
    }, {
      "field" : "mock_field_number",
      "operation" : "set_field",
      "type" : "modify_field",
      "type_id" : "incident",
      "value" : 123
    }, {
      "tasks_to_create" : [ "mock_cusom_task__________two" ],
      "type" : "create_task",
      "value" : null
    }, {
      "field" : "mock_field_text",
      "operation" : "set_field",
      "type" : "modify_field",
      "type_id" : "incident",
      "value" : "asdf"
    } ],
    "conditions" : [ ],
    "enabled" : true,
    "export_key" : "Mock Script Rule",
    "id" : 16,
    "logic_type" : "all",
    "message_destinations" : [ "fn_test_two" ],
    "name" : "Mock Script Rule",
    "object_type" : "incident",
    "tags" : [ {
      "tag_handle" : "fn_main_mock_integration",
      "value" : null
    } ],
    "timeout_seconds" : 86400,
    "type" : 1,
    "uuid" : "e4a713e4-3017-48d5-9995-ee45e974204e",
    "view_items" : [ ],
    "workflows" : [ "mock_workflow_one" ]
  }, {
    "automations" : [ {
      "tasks_to_create" : [ "initial_triage", "mock_custom_task_one" ],
      "type" : "create_task",
      "value" : null
    } ],
    "conditions" : [ ],
    "enabled" : true,
    "export_key" : "Mock Task Rule",
    "id" : 17,
    "logic_type" : "all",
    "message_destinations" : [ ],
    "name" : "Mock Task Rule",
    "object_type" : "incident",
    "tags" : [ {
      "tag_handle" : "fn_main_mock_integration",
      "value" : null
    } ],
    "timeout_seconds" : 86400,
    "type" : 1,
    "uuid" : "ce687e84-b44d-44ee-a914-8165b50e155e",
    "view_items" : [ ],
    "workflows" : [ ]
  }, {
    "automations" : [ ],
    "conditions" : [ ],
    "enabled" : true,
    "export_key" : "Run Mock Function One",
    "id" : 19,
    "logic_type" : "all",
    "message_destinations" : [ ],
    "name" : "Run Mock Function One",
    "object_type" : "incident",
    "tags" : [ {
      "tag_handle" : "fn_main_mock_integration",
      "value" : null
    } ],
    "timeout_seconds" : 86400,
    "type" : 1,
    "uuid" : "c2d82132-102f-42b9-83fb-fc472e47e6f1",
    "view_items" : [ ],
    "workflows" : [ "mock_workflow_one" ]
  } ],
  "apps" : [ {
    "author" : {
      "icon" : {
        "data" : "iVBORw0KGgoAAAANSUhEUgAAAGQAAABkCAYAAABw4pVUAAAAAXNSR0IArs4c6QAAAAlwSFlzAAAWJQAAFiUBSVIk8AAAAVlpVFh0WE1MOmNvbS5hZG9iZS54bXAAAAAAADx4OnhtcG1ldGEgeG1sbnM6eD0iYWRvYmU6bnM6bWV0YS8iIHg6eG1wdGs9IlhNUCBDb3JlIDUuNC4wIj4KICAgPHJkZjpSREYgeG1sbnM6cmRmPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5LzAyLzIyLXJkZi1zeW50YXgtbnMjIj4KICAgICAgPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJvdXQ9IiIKICAgICAgICAgICAgeG1sbnM6dGlmZj0iaHR0cDovL25zLmFkb2JlLmNvbS90aWZmLzEuMC8iPgogICAgICAgICA8dGlmZjpPcmllbnRhdGlvbj4xPC90aWZmOk9yaWVudGF0aW9uPgogICAgICA8L3JkZjpEZXNjcmlwdGlvbj4KICAgPC9yZGY6UkRGPgo8L3g6eG1wbWV0YT4KTMInWQAAC5ZJREFUeAHtnEeoFEsXx8ucc84ZFDOCAREzoitFDKiYEBUV1IX7txEEl25EEFFRMaGgqKCiLkSMIKiIYsCAAXPO9c7vfO807XxvvD33ttM9vi7o2z093aeq/v86qarmVnLOeTmykhIEKqekHVkz/kEgIyRlQyEjJCMkZQikrDmZhmSEpAyBlDUn05CMkJQhkLLmZBqSEZIyBFLWnExDMkJShkDKmpNpSEZIyhBIWXMyDckISRkCKWtOpiEZISlDIGXNyTQkIyRlCKSsOZmGZISkDIGUNadqytpTcHMqVarkGjRooO+9fv3aeV/au5pKmpDGjRu7+vXru7t37yohHTt2dG/evHEvXrwomNi0vFBJGlJyQ6pRo0auYcOG7s6dO4rjjBkz9Lx9+3Y9d+rUyb169cq9fPlSP5faHwgpiUOI8AJ20NapU6f6EydO+E+fPunBNfesPzzLO/a5RM7pJ+NXRIjP+KlATokTk15CCiHiJ1bkQwkTky5CJGryTZo0yWuacoF/8uSJ37Bhgx5c55Z8xFAHdaXQjKWHkGbNmvkOHToEIIV9RC7QgL9p06bgWQOWe1GJoS7qtHdTck6eEEAJO+u5c+eqH/j48WMuDwp2mIjKlSsriYDLtYGajxhk4mOow56l7hQRkxwhtWrV8pI7BMAsWrTInzt3zn/9+jUSEbxbrVo1JaJu3bq+evXqKi8KMdRBXdRpxCCPNtnnhM7JEFK7du2g40bEt2/fIhMB+ABWpUqVQA6ASqKoJHEdhRjqzCUm3LYESCk+ITYKhwwZ4s+cOeO/f/+uRPz48SMgJNdHAC4gGxEAZU6Z+yNHjgyI6dy5c2RirE7aQFtoE7Ktjf8JQsxeL1++PCDALqIQYSBhprgeN26cf/78uT9y5IgfNWpUuYix+mkTMq2NVlcRz8XXkKZNm2qnly1b5r98+aJY4Gy3bt0agPlvGpELihGCdpict2/f+kOHDvkxY8YEssrSmMePHxsffunSpfqetTG3ziJ8TpYQc+C3bt0KAOzSpctPpikfCEbIiBEjvJkeQzYKMWbykL9u3Tovc2N+xYoV2g7ylHz1/ub76SDk9u3barfr1KkTiQxAwaGbU5eJRS+zvMZHcI5CjMlAZo8ePZSIcEDwmwnIJT49hBjIYcddFhgAZ+B1797d79y5U/1JwMg/F2URQx5TtWpVBSdMUFn1/4bvS5sQA4RIy67LSwwDIWEy6EPpE4KGEKZyhDP+QonhXRLNJDAJ1ZksIRYd4UNoFCO0UJNlnUFLSOoqSkwh9VvdMZ6LT4hFMISYNl9lUVYhhFiU1L59e9+zZ89gZDPSC9WYd+/e+YMHD3q0CnATJCU5QpYsWeLfv3+vbvfmzZsFawgRGeBNmDDBP3r0yO/Zs8d37dq1QsSQGyEzqTwk0X1Zkjs4DmHEydSF4FBYEQ3RFz58+OAEQDd58mR39uxZJ5GWk5Gua+6iga5ly5ZOkj8nWuNEe9z169fdtGnT3NChQ92uXbuCTRG0gyPJkggh1mnOMrmnB8SUt4iZcxwUdqLIOoo7ffp0ZGIGDx7sdu/e7WT6xYlTVznWRv1Q5D+Biku9Rbm2jQcLFizwTFtgvy9fvqx1EzFFtd8WEQkJ/sCBAypHgPypMMdFbmK+gT7m8zF9+/b1HDyDLysWHjn1FIeEcKVGyLx58/y9e/c0kbtw4UJAiAEdfifftSVzfM/8FfNYJIG55VfEEJlBktURlmn3inguPiGyp0o7P2fOHE+4i5aIiSkXIQCFVoUBrQgxCZMBBsUnRLZ+KvgzZ870V69e9bLz0J86dapChNSoUUPXQJjZtT4VSgx5jE3DmIwEzsUnhFU9Ojp9+nR/8eJFL1GPP3r0qN4jtyhklIYBBFD8D/IrQkyC/gMMik9IvXr1FPwpU6boKh0OHadMWwohJJwYGsnIgBj8UCHEMFO8Y8cO36JFC21HIX4sTgwTCXulA1rIPWTqxH3+/NnJuojdjnwWZ6zP9unTx4npc5s3b9bPbL5GNiHw/fv3dUO2aIw7duyYkyTSTZo0yR0+fNhJdBfUJYGGE43VXIabtqM+eKBIF4kQIhGQdo/cQzayKSEQY8W+t8/5zpYYsuO9VatWbvbs2ZoAyhYgTTgLJYZ6xQTmq64o9xOp3QAnKTQNCRMStedGCBm4JYZicpzsuXKyNu+iEjNx4kQn6/H6UwbxX1Gr/y3PJUoIxIRJoYcGcpTeYuoo165dc7JjRLXC3mvevHlkYo4fP+7Gjx+vGb5sCVIR/JwhqaJOTCov2pmZWOpjtwhZ9N69e73Yf9+uXTu9X0iUVbNmzaDdCxcuLNdGO5x/OI9JyqGDSSIaYhOJz549U//BSMd28yMcSiFagg+SUNfJEqyTTddu4MCBqhknT55U2SpQ/pSlMQ8fPnQS/ams8gQYVk9Fz4kQYhOJTOYxUwsAHLKuof2REVpQv3gXQGUvlRKzbds2J1uD1MlHJQYZ1IsvK2RAFNTQCA8nQggaImsZjigIIAEDksRsaJMl647Q9P89gmbhi2RLkOO9Bw8eaLiLLKbWoxKDDH6bSKhsQUfkRsT4IHPWf8UoL7IocghMVbdu3RyRkY1MRjQERS2Ax3oH5o/wF1kQQ/5BbkE4zFQ8OcqNGzdUi7hn0RQDo1+/fm7x4sXaHpnC0bUVNDeJkoiG0FFZKdT+nj9/XhM0yGGUjx07VpM6QtmyiiWGAHrlyhW3Zs0azUPQEkgCbJlNVmLK0hiet4GQpIbQ5yBKKea12GlvERL7adeuXesFUL9y5UptD3NSPPOrNtnOxeHDhwcbtkUL/OrVq4P3WCthzZ35Kab9hZjgO34QJCGv4O/9pUuX9D6RXnh+7Ff1/47vEjNZ0hlN5vAnmA+Zf9IRKiTpyGaZFY35VcKIaeJ7lmtnzZqlzlg2ULhhw4Y5mUlWcyUbFxz/UIAIjigK7eHaTNmWLVtUi8hjZE5Noz2WfZMqLEozMhIrEEDoKquHrm3btmrHMR0y+6sAYZby2XPCXQjB3AD8gAED/q8fmKz9+/c70UL9Dr8CMQQTzFdx2O/dISrJhJAGJqohhh4RFpsQcPAWNRHCPn36VNe5IY2MPregXfgaQCQHwS9BDjmHha4APmjQIDd//nyN4vbt26cag0zIJBggskLbkGPv5dZVrM+JEwIZgMN/XYCMNm3aqOlibgqzgvYwL8VnIysMDkShKTzLfNT69etVo4i2jBicNKPfiME8olFGqCz5aj1huUldJ26yrOOMdGy3/ODG9erVS0cvgBF94U9sjglSGMUQCdBWuAcJkIOZoqxatUp9S+/evfUdnjcNwEyNHj1azZXVbbKSPCeuIdZ5RjrAyIY5BZV9VhDCgd1v3bq1agjZfZgIe58z6xs4cMwW77Dm8W8aw7No08aNG/U5fFQ+mTxbzJIaQug0pGC+ZOODAgSoaAROnmkNbD1EEX3Z8xAWLmgAAGOG0BjeMWJIHInC2EgnPzRVM8Y9tC0tJTUmKwwIDhZThQ/o37+/RkJmviANZwzo+Bc7c59n+I53IZHPgI3GEFoT8lohogt/tvtJn1NJCKCgEZY5k2fgtNEeAAZwgDfwOfMs9/FD9h0k2ehHc4jcyN55hqgujSW1hAAW5ooDYCmMdEBFg+y+kWIahNYYYZCU6xt4j3u597WCFPxJNSGGjy3PAroVtAVi7Ds0wTQFAtMKuLU/37kkCLHGY3YY4YBfqoBbX/KdS4qQcCcsnwjf+xNIKllCwkT8SdeJrYf8SSDG2ZeMkDjRjEFWRkgMIMYpIiMkTjRjkJUREgOIcYrICIkTzRhkZYTEAGKcIjJC4kQzBlkZITGAGKeIjJA40YxBVkZIDCDGKSIjJE40Y5CVERIDiHGKyAiJE80YZGWExABinCIyQuJEMwZZGSExgBiniIyQONGMQVZGSAwgxikiIyRONGOQlRESA4hxisgIiRPNGGT9Db90Oe/+aR5vAAAAAElFTkSuQmCC",
        "media_type" : "image/png"
      },
      "name" : "<<your name here>>",
      "website" : "https://ibm.com/mysupport"
    },
    "current_installation" : {
      "author" : {
        "icon" : {
          "data" : "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",
          "media_type" : "image/png"
        },
        "name" : "<<your name here>>",
        "website" : "https://ibm.com/mysupport"
      },
      "customizations" : [ {
        "display_name" : "Mock Manual Rule",
        "id" : 250,
        "object_id" : 14,
        "type" : "action"
      }, {
        "display_name" : "Mock Manual Rule Message Destination",
        "id" : 251,
        "object_id" : 15,
        "type" : "action"
      }, {
        "display_name" : "Mock Script Rule",
        "id" : 252,
        "object_id" : 16,
        "type" : "action"
      }, {
        "display_name" : "Mock Task Rule",
        "id" : 253,
        "object_id" : 17,
        "type" : "action"
      }, {
        "display_name" : "Mock: Auto Rule",
        "id" : 254,
        "object_id" : 18,
        "type" : "action"
      }, {
        "display_name" : "Run Mock Function One",
        "id" : 255,
        "object_id" : 19,
        "type" : "action"
      }, {
        "display_name" : "Initial Triage",
        "id" : 177,
        "name" : "initial_triage",
        "object_id" : 40,
        "type" : "automatic_task"
      }, {
        "display_name" : "Mock Cusom Task ㌎ ㌏ ㌐ ㌑ ㌒ ㌓ ㌔ ㌕ ㌖ Two",
        "id" : 234,
        "name" : "mock_cusom_task__________two",
        "object_id" : 66,
        "type" : "automatic_task"
      }, {
        "display_name" : "Mock Custom Task One",
        "id" : 235,
        "name" : "mock_custom_task_one",
        "object_id" : 67,
        "type" : "automatic_task"
      }, {
        "display_name" : "Mock: Data Table  ล ฦ ว ศ ษ ส ห ฬ อ",
        "id" : 227,
        "name" : "mock_data_table",
        "object_id" : 1000,
        "type" : "datatable"
      }, {
        "display_name" : "A Mock Function with :: No Unicode Characters !@#$%^&*())))in Name",
        "id" : 244,
        "name" : "a_mock_function_with_no_unicode_characters_in_name",
        "object_id" : 1,
        "type" : "function"
      }, {
        "display_name" : "mock function  ล ฦ ว ศ ษ ส ห ฬ อ two",
        "id" : 247,
        "name" : "mock_function_two",
        "object_id" : 4,
        "type" : "function"
      }, {
        "display_name" : "mock function ล three",
        "id" : 245,
        "name" : "mock_function__three",
        "object_id" : 2,
        "type" : "function"
      }, {
        "display_name" : "mock_function_one",
        "id" : 246,
        "name" : "mock_function_one",
        "object_id" : 3,
        "type" : "function"
      }, {
        "display_name" : "mock_input_boolean",
        "id" : 239,
        "name" : "mock_input_boolean",
        "object_id" : 279,
        "type" : "function_field"
      }, {
        "display_name" : "mock_input_date_picker",
        "id" : 241,
        "name" : "mock_input_date_picker",
        "object_id" : 281,
        "type" : "function_field"
      }, {
        "display_name" : "mock_input_date_time_picker",
        "id" : 237,
        "name" : "mock_input_date_time_picker",
        "object_id" : 277,
        "type" : "function_field"
      }, {
        "display_name" : "mock_input_multiselect",
        "id" : 243,
        "name" : "mock_input_multiselect",
        "object_id" : 283,
        "type" : "function_field"
      }, {
        "display_name" : "mock_input_number",
        "id" : 242,
        "name" : "mock_input_number",
        "object_id" : 282,
        "type" : "function_field"
      }, {
        "display_name" : "mock_input_select",
        "id" : 238,
        "name" : "mock_input_select",
        "object_id" : 278,
        "type" : "function_field"
      }, {
        "display_name" : "mock_input_text",
        "id" : 240,
        "name" : "mock_input_text",
        "object_id" : 280,
        "type" : "function_field"
      }, {
        "display_name" : "mock_input_text_with_value_string",
        "id" : 236,
        "name" : "mock_input_text_with_value_string",
        "object_id" : 276,
        "type" : "function_field"
      }, {
        "display_name" : "Mock Artifact 2 ㌎ ㌏ ㌐ ㌑ ㌒ ㌓ ㌔ ㌕ ㌖",
        "id" : 225,
        "name" : "mock_artifact_2",
        "object_id" : 1040,
        "type" : "incident_artifact_type"
      }, {
        "display_name" : "Mock Artifact Type One",
        "id" : 226,
        "name" : "mock_artifact_type_one",
        "object_id" : 1042,
        "type" : "incident_artifact_type"
      }, {
        "display_name" : "Customizations Field (internal)",
        "id" : 223,
        "name" : "internal_customizations_field",
        "object_id" : 273,
        "type" : "incident_field"
      }, {
        "display_name" : "Mock:  ล ฦ ว ศ ษ ส ห ฬ อ field number",
        "id" : 222,
        "name" : "mock_field_number",
        "object_id" : 272,
        "type" : "incident_field"
      }, {
        "display_name" : "Mock: Field Text",
        "id" : 221,
        "name" : "mock_field_text",
        "object_id" : 271,
        "type" : "incident_field"
      }, {
        "display_name" : "Mock: Field Text Area  ล ฦ ว ศ ษ ส ห ฬ อ",
        "id" : 220,
        "name" : "mock_field_text_area",
        "object_id" : 270,
        "type" : "incident_field"
      }, {
        "display_name" : "fn_main_mock_integration",
        "id" : 230,
        "name" : "fn_main_mock_integration",
        "object_id" : 1,
        "type" : "message_destination"
      }, {
        "display_name" : "fn_test_two",
        "id" : 231,
        "name" : "fn_test_two",
        "object_id" : 2,
        "type" : "message_destination"
      }, {
        "display_name" : "Engage",
        "id" : 3,
        "object_id" : 1002,
        "type" : "phase"
      }, {
        "display_name" : "Mock Custom Phase One",
        "id" : 232,
        "object_id" : 1007,
        "type" : "phase"
      }, {
        "display_name" : "Mock Custom Phase Two",
        "id" : 233,
        "object_id" : 1008,
        "type" : "phase"
      }, {
        "display_name" : "Mock Incident Script",
        "id" : 228,
        "name" : "mock_incident_script",
        "object_id" : 2,
        "type" : "script"
      }, {
        "display_name" : "Mock Script One",
        "id" : 229,
        "name" : "mock_script_one",
        "object_id" : 3,
        "type" : "script"
      }, {
        "display_name" : "mock workflow  ล ฦ ว ศ ษ ส ห ฬ อ two",
        "id" : 248,
        "name" : "mock_workflow_two",
        "object_id" : 1,
        "type" : "workflow"
      }, {
        "display_name" : "Mock Workflow One",
        "id" : 249,
        "name" : "mock_workflow_one",
        "object_id" : 2,
        "type" : "workflow"
      } ],
      "customizations_count" : 37,
      "description" : {
        "format" : "text",
        "content" : "Resilient Circuits Components for 'fn_main_mock_integration'"
      },
      "display_name" : "Main Mock Integration",
      "executables" : [ {
        "apikey_handle" : "8144f36a-6e84-4fa3-b6bb-82a07db997b1",
        "app_handle" : "fn_main_mock_integration",
        "config_string" : "[fn_main_mock_integration]\nusername = <<enter_user_email_here>>\napi_Key=dfghjFGYuy4567890nbvcghj\npassword = GJ^&*(';lkjhgfd567&*()_)\nunicode_entry = ઘ ઙ ચ છ જ ઝ ઞ\n\n# Some random comments here\n# and here\n",
        "id" : 1,
        "image" : "ibmresilient/fn_main_mock_integration:1.0.0",
        "name" : "fn_main_mock_integration",
        "permission_handles" : [ "read_function", "read_data" ],
        "uuid" : "c428f31c-2dad-40f1-b22c-e2b3ae2efc99"
      } ],
      "icon" : {
        "data" : "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",
        "media_type" : "image/png"
      },
      "id" : 1,
      "install_date" : 1644407281663,
      "install_principal" : {
        "display_name" : "Admin User",
        "id" : 1,
        "name" : "admin@example.com",
        "type" : "user"
      },
      "items" : [ {
        "customization_type" : "action",
        "display_name" : "Mock Manual Rule",
        "operation_type" : "created",
        "status" : "accepted",
        "uuid" : "7f4830d2-ce93-4d77-8318-1801da57921f"
      }, {
        "customization_type" : "action",
        "display_name" : "Mock Manual Rule Message Destination",
        "operation_type" : "created",
        "status" : "accepted",
        "uuid" : "32fc2626-bd73-43df-887b-01b21c508ee9"
      }, {
        "customization_type" : "action",
        "display_name" : "Mock Script Rule",
        "operation_type" : "created",
        "status" : "accepted",
        "uuid" : "e4a713e4-3017-48d5-9995-ee45e974204e"
      }, {
        "customization_type" : "action",
        "display_name" : "Mock Task Rule",
        "operation_type" : "created",
        "status" : "accepted",
        "uuid" : "ce687e84-b44d-44ee-a914-8165b50e155e"
      }, {
        "customization_type" : "action",
        "display_name" : "Mock: Auto Rule",
        "operation_type" : "created",
        "status" : "accepted",
        "uuid" : "b63091d4-2a67-44df-b117-299061d8f65c"
      }, {
        "customization_type" : "action",
        "display_name" : "Run Mock Function One",
        "operation_type" : "created",
        "status" : "accepted",
        "uuid" : "c2d82132-102f-42b9-83fb-fc472e47e6f1"
      }, {
        "customization_type" : "automatic_task",
        "display_name" : "Initial Triage",
        "operation_type" : "modified",
        "status" : "accepted",
        "uuid" : "2d261a8a-14c3-4f0f-a237-7c6a76bf82b1"
      }, {
        "customization_type" : "automatic_task",
        "display_name" : "Mock Cusom Task ㌎ ㌏ ㌐ ㌑ ㌒ ㌓ ㌔ ㌕ ㌖ Two",
        "operation_type" : "created",
        "status" : "accepted",
        "uuid" : "3a7c8b57-637b-4598-a729-98140ec71275"
      }, {
        "customization_type" : "automatic_task",
        "display_name" : "Mock Custom Task One",
        "operation_type" : "created",
        "status" : "accepted",
        "uuid" : "df101758-75dd-46d3-b080-1f338fc088a2"
      }, {
        "customization_type" : "datatable",
        "display_name" : "Mock: Data Table  ล ฦ ว ศ ษ ส ห ฬ อ",
        "operation_type" : "created",
        "status" : "accepted",
        "uuid" : "66cc5d9f-7c9a-42e7-991e-d8e5288c01ba"
      }, {
        "customization_type" : "function",
        "display_name" : "A Mock Function with :: No Unicode Characters !@#$%^&*())))in Name",
        "operation_type" : "created",
        "status" : "accepted",
        "uuid" : "acd10fc9-9c81-456b-a141-bb0c2279a721"
      }, {
        "customization_type" : "function",
        "display_name" : "mock function  ล ฦ ว ศ ษ ส ห ฬ อ two",
        "operation_type" : "created",
        "status" : "accepted",
        "uuid" : "90be4dd8-59a0-4791-82e9-df5d7e86edcb"
      }, {
        "customization_type" : "function",
        "display_name" : "mock function ล three",
        "operation_type" : "created",
        "status" : "accepted",
        "uuid" : "0c7fd5a3-b67f-47f5-bda4-76ff3f60dd69"
      }, {
        "customization_type" : "function",
        "display_name" : "mock_function_one",
        "operation_type" : "created",
        "status" : "accepted",
        "uuid" : "9b180887-4ff6-4d13-82a6-cb0a5d8718f1"
      }, {
        "customization_type" : "function_field",
        "display_name" : "mock_input_boolean",
        "operation_type" : "created",
        "status" : "accepted",
        "uuid" : "df7df8ba-cb65-4400-8290-070b155d28d4"
      }, {
        "customization_type" : "function_field",
        "display_name" : "mock_input_date_picker",
        "operation_type" : "created",
        "status" : "accepted",
        "uuid" : "01147ebf-ce3d-4cfb-814b-16145af4e511"
      }, {
        "customization_type" : "function_field",
        "display_name" : "mock_input_date_time_picker",
        "operation_type" : "created",
        "status" : "accepted",
        "uuid" : "92eb3b7a-8859-4846-81a3-2995aec74bdb"
      }, {
        "customization_type" : "function_field",
        "display_name" : "mock_input_multiselect",
        "operation_type" : "created",
        "status" : "accepted",
        "uuid" : "69dc0e78-a74b-4ccc-8d82-33b51780a569"
      }, {
        "customization_type" : "function_field",
        "display_name" : "mock_input_number",
        "operation_type" : "created",
        "status" : "accepted",
        "uuid" : "49f10172-309a-4829-a5fe-1de71cdb4efb"
      }, {
        "customization_type" : "function_field",
        "display_name" : "mock_input_select",
        "operation_type" : "created",
        "status" : "accepted",
        "uuid" : "b6dfde6d-7516-4509-a5a2-54e72df9e0cd"
      }, {
        "customization_type" : "function_field",
        "display_name" : "mock_input_text",
        "operation_type" : "created",
        "status" : "accepted",
        "uuid" : "e40b9d9e-7ca1-45bc-913b-ce2a77e9b687"
      }, {
        "customization_type" : "function_field",
        "display_name" : "mock_input_text_with_value_string",
        "operation_type" : "created",
        "status" : "accepted",
        "uuid" : "866625eb-8b46-4cc9-b713-cdfa548a1189"
      }, {
        "customization_type" : "incident_artifact_type",
        "display_name" : "Mock Artifact 2 ㌎ ㌏ ㌐ ㌑ ㌒ ㌓ ㌔ ㌕ ㌖",
        "operation_type" : "created",
        "status" : "accepted",
        "uuid" : "0405a242-872b-4d85-9e79-70a26a9d7462"
      }, {
        "customization_type" : "incident_artifact_type",
        "display_name" : "Mock Artifact Type One",
        "operation_type" : "created",
        "status" : "accepted",
        "uuid" : "1997c7d5-7c81-49f0-91d3-b0b6cb190ca3"
      }, {
        "customization_type" : "incident_field",
        "display_name" : "Customizations Field (internal)",
        "operation_type" : "created",
        "status" : "accepted",
        "uuid" : "bfeec2d4-3770-11e8-ad39-4a0004044aa1"
      }, {
        "customization_type" : "incident_field",
        "display_name" : "Mock:  ล ฦ ว ศ ษ ส ห ฬ อ field number",
        "operation_type" : "created",
        "status" : "accepted",
        "uuid" : "2653024f-9abb-4440-aa61-cb3f6262f6ee"
      }, {
        "customization_type" : "incident_field",
        "display_name" : "Mock: Field Text",
        "operation_type" : "created",
        "status" : "accepted",
        "uuid" : "f63a85ca-0e50-4504-81ab-c45d16494d0c"
      }, {
        "customization_type" : "incident_field",
        "display_name" : "Mock: Field Text Area  ล ฦ ว ศ ษ ส ห ฬ อ",
        "operation_type" : "created",
        "status" : "accepted",
        "uuid" : "d7cc8d00-1d54-4b3a-af0d-236ef0566751"
      }, {
        "customization_type" : "incident_type",
        "display_name" : "Customization Packages (internal)",
        "operation_type" : "created",
        "status" : "accepted",
        "uuid" : "bfeec2d4-3770-11e8-ad39-4a0004044aa0"
      }, {
        "customization_type" : "message_destination",
        "display_name" : "fn_main_mock_integration",
        "operation_type" : "created",
        "status" : "accepted",
        "uuid" : "f36c49bf-df8c-46f3-a4cd-9a0cba961f92"
      }, {
        "customization_type" : "message_destination",
        "display_name" : "fn_test_two",
        "operation_type" : "created",
        "status" : "accepted",
        "uuid" : "fb3f8e6a-d939-4594-addf-6d69ec2381bf"
      }, {
        "customization_type" : "phase",
        "display_name" : "Engage",
        "operation_type" : "modified",
        "status" : "accepted",
        "uuid" : "ed053e3a-2d6d-47e1-8240-844ed93d4893"
      }, {
        "customization_type" : "phase",
        "display_name" : "Mock Custom Phase One",
        "operation_type" : "created",
        "status" : "accepted",
        "uuid" : "187b290c-19b5-4f29-97e8-16e9ff604a72"
      }, {
        "customization_type" : "phase",
        "display_name" : "Mock Custom Phase Two",
        "operation_type" : "created",
        "status" : "accepted",
        "uuid" : "44bfae00-280d-40db-9e14-124bd86002e5"
      }, {
        "customization_type" : "script",
        "display_name" : "Mock Incident Script",
        "operation_type" : "created",
        "status" : "accepted",
        "uuid" : "52e88afe-0ca8-4bac-823f-980bc8ba2931"
      }, {
        "customization_type" : "script",
        "display_name" : "Mock Script One",
        "operation_type" : "created",
        "status" : "accepted",
        "uuid" : "d73d75f5-d8cf-4c00-8110-c5bf258b51da"
      }, {
        "customization_type" : "workflow",
        "display_name" : "mock workflow  ล ฦ ว ศ ษ ส ห ฬ อ two",
        "operation_type" : "created",
        "status" : "accepted",
        "uuid" : "fef372ed-3410-413b-b01b-9b34e31b8005"
      }, {
        "customization_type" : "workflow",
        "display_name" : "Mock Workflow One",
        "operation_type" : "created",
        "status" : "accepted",
        "uuid" : "127ae053-c26f-43b7-8b5a-198720dbf202"
      } ],
      "long_description" : {
        "format" : "html",
        "content" : "<div>Resilient Circuits Components for 'fn_main_mock_integration'</div>"
      },
      "messages" : [ ],
      "minimum_resilient_version" : {
        "build_number" : 6783,
        "major" : 41,
        "minor" : 0,
        "version" : "41.0.6783"
      },
      "name" : "fn_main_mock_integration",
      "status" : "installed",
      "version" : "1.0.0"
    },
    "description" : {
      "format" : "text",
      "content" : "Resilient Circuits Components for 'fn_main_mock_integration'"
    },
    "display_name" : "Main Mock Integration",
    "export_key" : "fn_main_mock_integration",
    "icon" : {
      "data" : "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",
      "media_type" : "image/png"
    },
    "id" : 1,
    "long_description" : {
      "format" : "html",
      "content" : "<div>Resilient Circuits Components for 'fn_main_mock_integration'</div>"
    },
    "minimum_resilient_version" : {
      "build_number" : 6783,
      "major" : 41,
      "minor" : 0,
      "version" : "41.0.6783"
    },
    "name" : "fn_main_mock_integration",
    "tag" : {
      "display_name" : "fn_main_mock_integration",
      "id" : 1,
      "name" : "fn_main_mock_integration",
      "prefix" : "fn_main_mock_integration",
      "type" : "configuration",
      "uuid" : "6952efe2-4c78-c18c-2779-9f2402ddb574"
    },
    "uuid" : "6952efe2-4c78-c18c-2779-9f2402ddb574",
    "version" : "1.0.0"
  } ],
  "automatic_tasks" : [ {
    "associated_actions" : null,
    "category_id" : null,
    "date_source_handle" : "incident.discovered_date",
    "deleted" : false,
    "due_date_offset" : 0,
    "due_date_units" : null,
    "enabled" : true,
    "export_key" : "analyze_application_data_for_signs_of_intrusion",
    "form" : null,
    "id" : 0,
    "instructions" : "Data on compromised systems is often modified by intruders. Analyze application data of affected applications, or applications that you suspect may have been involved in the incident. Some areas to explore include: <br />\n<ul>\n<li>Configuration settings - Look for unexpected configurations or configurations that might expose a vulnerability</li>\n<li>Authentication logs - Look for unexpected or anomalous login activity</li>\n<li>Operational logs - Look for unusual events, alerts, errors, and so on.</li>\n<li>Application data - Look for unusual or unexpected application data, particularly data timestamped in proximity of expected malicious activity</li>\n<li>Verify the integrity of web pages, ftp archives, files in users' home directories, and any other data files on your system</li>\n<li>Check browser history, caches and cookies</li>\n</ul>",
    "name" : "Analyze application data for signs of intrusion",
    "optional" : false,
    "phase_id" : "Detect/Analyze",
    "programmatic_name" : "analyze_application_data_for_signs_of_intrusion",
    "tags" : [ ],
    "task_layout" : [ ],
    "uuid" : "2d11f9fc-e9bb-484f-8dd0-73c57003281e"
  }, {
    "associated_actions" : null,
    "category_id" : null,
    "date_source_handle" : "incident.discovered_date",
    "deleted" : false,
    "due_date_offset" : 0,
    "due_date_units" : null,
    "enabled" : true,
    "export_key" : "analyze_headers_of_suspected_email_messages",
    "form" : null,
    "id" : 0,
    "instructions" : "Analyze email headers for suspicious characteristics, such as abnormal mail routes or timestamps. A tool to assist in this analysis can be found at <a href=\"http://mxtoolbox.com/EmailHeaders.aspx\">MXToolbox</a>.",
    "name" : "Analyze headers of suspected email messages",
    "optional" : false,
    "phase_id" : "Detect/Analyze",
    "programmatic_name" : "analyze_headers_of_suspected_email_messages",
    "tags" : [ ],
    "task_layout" : [ ],
    "uuid" : "0ad45cc3-74bf-4c0d-9d8f-00a84066d170"
  }, {
    "associated_actions" : null,
    "category_id" : null,
    "date_source_handle" : "incident.discovered_date",
    "deleted" : false,
    "due_date_offset" : 0,
    "due_date_units" : null,
    "enabled" : true,
    "export_key" : "analyze_intruded_systems",
    "form" : null,
    "id" : 0,
    "instructions" : "Analyze all affected systems and make notes of your findings.  Ideally you should leverage a purpose-built forensic workstation to perform this analysis (for example, http://computer-forensics.sans.org/community/downloads). Look for anomalous activity such as excessive CPU, memory or disk utilization, unexpected restarts, unusual or missing processes (refer to system baselines), processes running under unusual or unrecognized accounts, processes running for unusual timeframes or terminating prematurely, repeated failed logins, remote logins from unusual locations or times, attempts to change identity or privilege, attempts to access restricted files, and accounts running unexpected commands. If evidence is needed, the analyst should fully document what is seen on the screen before touching the system. Where possible, use a trusted source for the tools and commands as an intruder may have modified the standard commands on the affected system.<br /><br />\n\nIf you have not already done so, start by collecting volatile system data in the following order: Network connections, login sessions, contents of memory, running processes, open files, network configurations, and operating system time.<br /><br />\n\nAnalyze files on the affected systems. Wherever possible, adhere to the following recommendations when analyzing file data:\n<ul>\n<li>Examine copies of files, not the originals.</li>\n<li>Preserve and verify file integrity (secure hashes).</li>\n<li>Rely on file headers and not file apps to identify file content types.</li>\n<li>Leverage a forensic toolkit for data examination and analysis.</li>\n</ul>\nOperating in single user mode on UNIX systems will prevent users, intruders, and intruder processes from accessing or changing state on the compromised machine while you are going through the recovery process.\n<br /><br />\nDetermine if a review of the physical file system is warranted. Physical file system review consists of looking through information that has been logically deleted from the system to determine if deleted files, slack space or free space contains data fragments or entire files that may be useful to the investigation.  The most common activities performed in this type of review are timestamp reviews and keyword/string searching.<br />\n<br />\nSteps Taken During a Physical File System Review:\n<ul>\n<li>Acquire and Restore the Forensic Duplication.</li>\n<li>Recover Deleted Files.</li>\n<li>Review Unallocated (Free) Space.</li>\n<li>Review Slack Space.</li>\n<li>Generate File Lists Containing MD5 Hash Values and Other Critical File Data.</li>\n<li>Identify Known System Files (Hash Sets).</li>\n<li>Obtain and Review the Time/Date Stamps.</li>\n<li>Perform Keyword Searches.</li>\n<li>Perform File Signature Analysis.</li>\n</ul>\nReview relevant log files for indications of the issue. Correlate logs from various affected systems and applications.\n<br /><br />\n\nInclude suspicious IP addresses, URLs, executables and other files as incident artifacts on the Artifacts tab. The system will correlate this information against several threat intelligence source and provide feedback.<br /><br />\nSome sources include:<br />\n<ul>\n<li>For Linux, see /var/logs/syslog, /var/log/auth.log, /etc/syslog.conf, /var/adm/*, /var/log/*</li>\n<li>For  Apache, see /var/log/apache2 and /var/log/sites//logs//*.log</li>\n</ul>\n<br />\nReferences:<br /><br />\n\nNIST SP 800-86, Guide to integrating Forensic Techniques: http://csrc.nist.gov/publications/nistpubs/800-86/SP800-86.pdf<br />\nSANS Incident Handler's Handbook: http://www.sans.org/reading_room/whitepapers/incident/incident-handlers-handbook_33901<br />\nSANS Intrusion Detection Checklist for Linux: https://www.sans.org/score/checklists/ID_Linux.pdf<br />\nSANS Intrusion Detection Checklist for Windows: https://www.sans.org/score/checklists/ID_Windows.pdf<br />\nSoftware Engineering Institute whitepaper on memory image analysis on Windows: http://www.cert.org/archive/pdf/08tn017.pdf<br />",
    "name" : "Analyze intruded systems",
    "optional" : false,
    "phase_id" : "Detect/Analyze",
    "programmatic_name" : "analyze_intruded_systems",
    "tags" : [ ],
    "task_layout" : [ ],
    "uuid" : "b6746cd0-09fe-49e8-aa3d-17bde93b3072"
  }, {
    "associated_actions" : null,
    "category_id" : null,
    "date_source_handle" : "incident.discovered_date",
    "deleted" : false,
    "due_date_offset" : 0,
    "due_date_units" : null,
    "enabled" : true,
    "export_key" : "analyze_malware_infected_systems",
    "form" : null,
    "id" : 0,
    "instructions" : "Look for attributes of the malware.  Ideally you should leverage a purpose-built forensic workstation to perform this analysis (for example, http://computer-forensics.sans.org/community/downloads). Determine the type of malware, how it is being transported, how it infects the system, and so on. Look for specific attributes that can be used to identify, contain and eradicate it. Try to determine a vector common to all systems experiencing anomalous behavior or having been rendered unavailable, from which a malicious payload could have been delivered. Examples include centralized enterprise applications, centralized file shares (for which the identified systems were mapped or had access), privileged user account common to the identified systems, network segment or boundary, or a common DNS server for name resolution. It is important not to trust software and utilities on the infected system as they may be compromised. Rather, collect trusted versions on a read-only media and execute them from there.<br /><br />\n\nAnalyzing malware should only be done by someone qualified or trained to do so. If you have located a file you believe to be malicious, you can upload it to a sandbox service for detailed information on its characteristics. Here are some sandbox services that offer this intelligence:\n<ul>\n<li>Anubis - http://anubis.iseclab.org/ </li>\n<li>Malwr - https://malwr.com/ </li>\n<li>Threat Expert - http://www.threatexpert.com/submit.aspx </li>\n</ul>\n\nWhen identifying malware, record the following characteristics if possible:\n<ul>\n<li>Malware category (for example, virus, worm, or Trojan horse)</li>\n<li>Services, ports, protocols, and similar items that are attacked</li>\n<li>Vulnerabilities that are exploited, such as software flaws, misconfigurations, and social engineering.</li>\n<li>Malicious file names, sizes, content, and other metadata (such as email subjects and web URLs).</li>\n<li>Which versions of operating systems, devices, applications, and so on, may be affected.</li>\n<li>How the malware affects the infected host, including the names and locations of affected files, altered configuration settings, installed backdoor ports, and so on.</li>\n<li>How the malware propagates and how to approach containment.</li>\n<li>How to remove the malware from the host.</li>\n</ul>\n\nOne goal is to identify suspicious network activity or connections. To look at local connections on Windows 2000 and greater, you can use the netstat -on command. This will list all connections along with the associated process ID. From this listing, identify suspicious connections and record their process ID. Next, run a trusted version of taskmgr. If the process ID's are being displayed, go to View&gt;Selected Columns and select PID. Map the PID in question to the process or services. By right-clicking on a process entry, you can get its properties including the full path to the executable file on disk as well as its signature and signing chain.<br /><br />\n\nAnother useful exercise is to execute whois lookups on suspect IP addresses to get a sense of their credibility and purpose. This can be done at whois.net.<br /><br />\n\nCollect suspicious IP addresses, emails, documents and executables and attach them to the incident as artifacts. The system will correlate these against several threat intelligence sources and provide feedback. <br /><br />\n\nOther options:<br />\nRun Microsoft's Safety Scanner, http://www.microsoft.com/security/scanner/en-us/default.aspx<br />\nSee tools provided at http://www.mcafee.com/us/downloads/free-tools/index.aspx<br />",
    "name" : "Analyze malware-infected systems",
    "optional" : false,
    "phase_id" : "Detect/Analyze",
    "programmatic_name" : "analyze_malware_infected_systems",
    "tags" : [ ],
    "task_layout" : [ ],
    "uuid" : "028e31be-e704-4858-b897-c5a5c7dccb1f"
  }, {
    "associated_actions" : null,
    "category_id" : null,
    "date_source_handle" : "incident.discovered_date",
    "deleted" : false,
    "due_date_offset" : 0,
    "due_date_units" : null,
    "enabled" : true,
    "export_key" : "analyze_network_traffic_for_malware_activity",
    "form" : null,
    "id" : 0,
    "instructions" : "<p>Analyze network traffic for network activity related to the malware. Include suspicious IP addresses or URLs as incident artifacts on the Artifacts tab. The system will correlate this information against several threat intelligence sources and provide feedback. Other tools to help in your analysis include <a href=\"https://www.robtex.com/\">https://www.robtex.com/</a> and <a href=\"http://www.whois.net/\">http://www.whois.net/</a>.Compare suspicious artifacts against other threat intelligence and known bad IP addresses (black lists).</p>\n\nCare must be taken when handling recorded network traffic data as it may hold sensitive data such as user names and passwords. In many cases, approval by management or legal counsel is required by company policy prior to capturing network traffic due to the sensitive nature of the information it can contain.",
    "name" : "Analyze network traffic for malware activity",
    "optional" : false,
    "phase_id" : "Detect/Analyze",
    "programmatic_name" : "analyze_network_traffic_for_malware_activity",
    "tags" : [ ],
    "task_layout" : [ ],
    "uuid" : "bf027650-3d2e-4c9c-a524-7e22380b930a"
  }, {
    "associated_actions" : null,
    "category_id" : null,
    "date_source_handle" : "incident.discovered_date",
    "deleted" : false,
    "due_date_offset" : 0,
    "due_date_units" : null,
    "enabled" : true,
    "export_key" : "analyze_network_traffic_for_signs_of_intrusion",
    "form" : null,
    "id" : 0,
    "instructions" : "Analyze network traffic and the network interfaces of suspected systems looking for anomalies and other signs of intrusion. Sources include:<br />\n<ul>\n<li>Affected systems - Active connections and local network activity.</li>\n<li>Firewalls and routers - Network activity logs and alerts.</li>\n<li>Packet sniffers - Highly detailed network information coupled with protocol analyzers which can display or recreate specific connection activity.</li>\n<li>Intrusion detection systems - Identified malicious network activity and other useful data which can be correlated with other data sources.</li>\n<li>Remote access systems - Can be used to determine the entry point of an attack.</li>\n<li>SIEM tools - Automated correlation of events across multiple data sources.</li>\n<li>Network forensic analysis tools (NFATs) - A variety of network information coupled with analysis and visualization.</li>\n<li>DHCP servers - Mapping of IP addresses to physical addresses and ultimately to specific computers.</li>\n<li>ISP records - Assistance in tracking malicious traffic back to its source as well as correlating malicious activity across multiple targets or past occurrences.</li>\n</ul>\n\nInclude suspicious IP addresses or URLs as incident artifacts on the Artifacts tab. The system will correlate this information against several threat intelligence source and provide feedback. Other tools to help in your analysis include <a href=\"https://www.robtex.com/\">https://www.robtex.com/</a> and <a href=\"http://www.whois.net/\">http://www.whois.net/</a>.<br /><br />\n\nCare must be taken when handling recorded network traffic data as it may hold sensitive data such as user names and passwords. In many cases, approval by management or legal counsel is required by company policy prior to capturing network traffic due to the sensitive nature of the information it can contain.",
    "name" : "Analyze network traffic for signs of intrusion",
    "optional" : false,
    "phase_id" : "Detect/Analyze",
    "programmatic_name" : "analyze_network_traffic_for_signs_of_intrusion",
    "tags" : [ ],
    "task_layout" : [ ],
    "uuid" : "dcc7c458-153d-4296-be66-04f0cc777f04"
  }, {
    "associated_actions" : null,
    "category_id" : null,
    "date_source_handle" : "incident.discovered_date",
    "deleted" : false,
    "due_date_offset" : 0,
    "due_date_units" : null,
    "enabled" : true,
    "export_key" : "apply_type_specific_malware_containment_measures",
    "form" : null,
    "id" : 0,
    "instructions" : "Ensure all available software and operating system patches are up to date. Use any intelligence discovered during the Analyze Malware phase to block the spread of malware and stop connections to remote servers.\n<p>\nProvide any undetected suspicious samples to your anti-virus vendor for examination and signature creation. Some options include:<br /><br />\n\nMicrosoft: https://www.microsoft.com/security/portal/submission/submit.aspx <br />\nSymantec: http://www.symantec.com/security_response/submitsamples.jsp<br />\nKaspersky: Zip and password protect your sample (with a password of &quot;infected&quot;) and then send it to newvirus@kaspersky.com<br />\nMcAfee: http://www.mcafee.com/us/mcafee-labs/resources/how-to-submit-sample.aspx <br />\nSophos: https://secure2.sophos.com/en-us/support/contact-support/sample-submission.aspx<br /><br />\n\nBased upon the determination of a likely distribution vector, additional mitigation controls can be enforced to further minimize impact:\n</p><ul>\n<li>Implement network-based access-control lists to deny the identified applications the capability to directly communicate with additional systems. This provides an immediate capability to isolate and sandbox specific systems or resources.</li>\n<li>Implement null network routes for specific IP addresses (or IP ranges), from which the payload may be distributed. An organization's internal DNS can also be leveraged for this task, such as a null pointer record could be added within a DNS zone for an identified server or application.</li>\n<li>Readily disable access for suspected user or service accounts.</li>\n<li>For suspect file shares (which may be hosting the infection vector), remove access or disable the share path from being accessed by additional systems.</li>\n</ul>\n\nAlso, apply containment measures most appropriate to the type of malware involved:\n<ul>\n<li>Drive-by Downloads - These infections take place when a web site is visited. Ensure browser patches are up to date, as well as any plug-ins and 3rd party tools such as Java and Adobe Reader.</li>\n<li>Trojans, worms, rootkits - Inspect anti-virus logs for malware detection names then perform research on infection data. Follow specific guidelines provided by your anti-virus provider or their website to block suspicious URL's, associated services, and proceed with infection-specific clean up guidelines. </li>\n<li>Backdoors - Examine local and network firewall logs for connections from untrusted or blacklisted URL's. Research your anti-virus vendor's detection name for specifics around connection types. Update firewall and network block lists to prevent future attempts at connections.</li>\n<li>Botnets - Attempt to identify command and control server locations and configure network control points to prevent further communications with malicious IP's or URL's.</li>\n<li>Spam servers - configure email server, spam filters, firewalls and any other network technology to block transmissions of email. Enable the use of spam block lists on your email server.</li>\n<li>Network attacks - Configure DNS servers to use and update DNS block lists (DNSBL) to prevent connections to and from malicious URL's. Configure firewalls and other network mitigation technology to block connections to malicious URL's or IP's. </li>\n<li>Mobile malware - Research infection name in anti-virus logs. Perform clean up routines, or fully wipe the mobile device per vendor specification after data collection is complete. If a malicious file such as an .apk is discovered on the device, use the Artifacts tab for review and further detail.</li>\n</ul>",
    "name" : "Apply type-specific malware containment measures",
    "optional" : false,
    "phase_id" : "Respond",
    "programmatic_name" : "apply_type_specific_malware_containment_measures",
    "tags" : [ ],
    "task_layout" : [ ],
    "uuid" : "c63a44d3-10e2-420d-b170-a71fff76e4e7"
  }, {
    "associated_actions" : null,
    "category_id" : null,
    "date_source_handle" : "incident.discovered_date",
    "deleted" : false,
    "due_date_offset" : 0,
    "due_date_units" : null,
    "enabled" : true,
    "export_key" : "change_deviceapplication_passwords",
    "form" : null,
    "id" : 0,
    "instructions" : "Immediately change any associated app or device passwords to company directory services, bank accounts, email, social networks, and so on, to prevent unauthorized access to personal or company data and any password reset functionality.",
    "name" : "Change device/application passwords",
    "optional" : false,
    "phase_id" : "Respond",
    "programmatic_name" : "change_deviceapplication_passwords",
    "tags" : [ ],
    "task_layout" : [ ],
    "uuid" : "befdf0a7-c3b1-44ac-9442-e166675acf04"
  }, {
    "associated_actions" : null,
    "category_id" : null,
    "date_source_handle" : "incident.discovered_date",
    "deleted" : false,
    "due_date_offset" : 0,
    "due_date_units" : null,
    "enabled" : true,
    "export_key" : "collect_volatile_system_data",
    "form" : null,
    "id" : 0,
    "instructions" : "Start by collecting volatile system data for each affected system in the following order: \n<ul>\n<li>Photo of the current monitor contents, </li>\n<li>network connections, </li>\n<li>login sessions, </li>\n<li>contents of memory,</li> \n<li>running processes, </li>\n<li>open files, </li>\n<li>network configurations, </li>\n<li>operating system time.</li>\n</ul>\nFollow appropriate procedures for collection and preservation of evidence if legal action is foreseeable.",
    "name" : "Collect volatile system data",
    "optional" : false,
    "phase_id" : "Detect/Analyze",
    "programmatic_name" : "collect_volatile_system_data",
    "tags" : [ ],
    "task_layout" : [ ],
    "uuid" : "d0b4df39-6eff-4bb1-afa9-47f6e3fabff1"
  }, {
    "associated_actions" : null,
    "category_id" : null,
    "date_source_handle" : "incident.discovered_date",
    "deleted" : false,
    "due_date_offset" : 0,
    "due_date_units" : null,
    "enabled" : true,
    "export_key" : "configure_egress_filters",
    "form" : null,
    "id" : 0,
    "instructions" : "Configure egress filters to block the traffic your systems may send in response to DoS traffic, to avoid adding unnecessary packets to the network.",
    "name" : "Configure egress filters",
    "optional" : false,
    "phase_id" : "Respond",
    "programmatic_name" : "configure_egress_filters",
    "tags" : [ ],
    "task_layout" : [ ],
    "uuid" : "7f3a1ba2-88c6-4231-9db3-f0fb24d66067"
  }, {
    "associated_actions" : null,
    "category_id" : null,
    "date_source_handle" : "incident.discovered_date",
    "deleted" : false,
    "due_date_offset" : 0,
    "due_date_units" : null,
    "enabled" : true,
    "export_key" : "contact_owners_of_systems_being_used_to_mount_the_dos_attack",
    "form" : null,
    "id" : 0,
    "instructions" : "Contact owners of systems being used to mount the DoS attack, if appropriate. <br /><br />\n\nIf you need contact information for a .COM, .EDU, .NET, or .ORG top-level domain, use the InterNIC's whois database: <br /> http://www.internic.net/whois.html <br /><br />\n\nTo find contact information from the appropriate registrar, use the InterNIC's Registrar Directory: <br /> http://www.internic.net/origin.html <br /><br />\n\nTo find contact information for the Asia-pacific region and Australia, respectively: <br />\nhttp://www.apnic.net/apnic-bin/whois.pl <br />\nhttp://whois.ausregistry.net.au/whois/whois_local.jsp?<br /><br />\n\nDocument all communication with outside parties for liability and evidentiary purposes.",
    "name" : "Contact owners of systems being used to mount the DoS attack",
    "optional" : false,
    "phase_id" : "Respond",
    "programmatic_name" : "contact_owners_of_systems_being_used_to_mount_the_dos_attack",
    "tags" : [ ],
    "task_layout" : [ ],
    "uuid" : "90c21467-b8a4-478e-b4eb-3e9fdd02cd9e"
  }, {
    "associated_actions" : null,
    "category_id" : null,
    "date_source_handle" : "incident.discovered_date",
    "deleted" : false,
    "due_date_offset" : 0,
    "due_date_units" : null,
    "enabled" : true,
    "export_key" : "contact_your_isp",
    "form" : null,
    "id" : 0,
    "instructions" : "Contact your ISP for assistance in identifying, isolating and blocking DoS traffic.",
    "name" : "Contact your ISP",
    "optional" : false,
    "phase_id" : "Respond",
    "programmatic_name" : "contact_your_isp",
    "tags" : [ ],
    "task_layout" : [ ],
    "uuid" : "90f3859c-d2ad-41d4-9f73-8ad0e34cc493"
  }, {
    "associated_actions" : null,
    "category_id" : null,
    "date_source_handle" : "incident.discovered_date",
    "deleted" : false,
    "due_date_offset" : 0,
    "due_date_units" : null,
    "enabled" : true,
    "export_key" : "create_backups_of_affected_systems",
    "form" : null,
    "id" : 0,
    "instructions" : "Before delving deeply into analyzing the intrusion, you should create a backup of each affected system. This provides a &quot;snapshot&quot; of the file system at the time that the compromise was first discovered. You may need to refer to this backup in the future. During data collection, the analyst should make multiple copies of the relevant files or file systems, typically a master copy and a working copy. The analyst can then use the working copy without affecting the original files or the master copy. It is often important to collect not only the files, but also significant timestamps for the files, such as when the files were last modified or accessed (refer to <a href=\"http://csrc.nist.gov/publications/nistpubs/800-86/SP800-86.pdf\">NIST SP 800-86: Guide to Integrating Forensic Techniques into Incident Response</a>, section 4, for guidance). If legal or disciplinary action is a possibility, make a disk image or bit stream image, and remove the disk drive, handling it using accepted evidence preservation procedures. Otherwise, a logical backup may be sufficient.\n<br /><br />\nIf you have an available disk which is the same size and model as the disk in the compromised system, you can use the dd command in UNIX to make an exact copy of the compromised system.\n<br /><br />\nFor example, on a Linux system with two SCSI disks, the following command would make an exact replica of the compromised system (/dev/sda) to the disk of the same size and model (/dev/sdb).\n<br /><br />\n\t   # dd if=/dev/sda of=/dev/sdb\n<br /><br />\nRead the dd man page for more information.\n<br /><br />\nThere are many other ways to create a backup of your system. On Windows systems, there is no built-in command like dd, but there are a number of third party applications that can make an image copy of an entire hard drive.\n<br /><br />\nCreating a low level backup is important in case you ever need to restore the state of the compromised machine when it was first discovered. Also, files may be needed for a legal investigation. Label, sign, and date the backup and keep the backup in a secure location to maintain integrity of the data. Verify integrity of the copy using hashes and record them. Clearly document all steps taken to generate and secure the backup and it's chain of custody.",
    "name" : "Create backups of affected systems",
    "optional" : false,
    "phase_id" : "Detect/Analyze",
    "programmatic_name" : "create_backups_of_affected_systems",
    "tags" : [ ],
    "task_layout" : [ ],
    "uuid" : "6547c4ea-bf23-499d-b3f6-918c3a05dbcb"
  }, {
    "associated_actions" : null,
    "category_id" : null,
    "date_source_handle" : "incident.discovered_date",
    "deleted" : false,
    "due_date_offset" : 0,
    "due_date_units" : null,
    "enabled" : true,
    "export_key" : "define_and_document_malware_eradication_strategy",
    "form" : null,
    "id" : 0,
    "instructions" : "In some cases, the eradication activity may be integrated with the containment activity of identifying infected devices. Carefully determine if sufficient eradication can be achieved without completely wiping and reinstalling systems. Generate and assign appropriate eradication tasks. Plan on completely rebuilding any system that has any of the following characteristics: <br /><br />\n<ul>\n<li>One or more attackers gained administrator-level access to the system.</li>\n<li>Unauthorized administrator-level access to the system was available to anyone through a backdoor, an unprotected share created by a worm, or other means.</li>\n<li>System files were replaced by a Trojan horse, backdoor, rootkit, attacker tools, or other means.</li>\n<li>The system is unstable or does not function properly after the malware has been eradicated by antivirus software., spyware detection and removal utilities, or other programs or techniques. This indicates that either the malware has not been eradicated completely or that it has caused damage to important system or application files or settings.</li></ul>",
    "name" : "Define and document malware eradication strategy",
    "optional" : false,
    "phase_id" : "Respond",
    "programmatic_name" : "define_and_document_malware_eradication_strategy",
    "tags" : [ ],
    "task_layout" : [ ],
    "uuid" : "e72f27fc-4507-49fd-ad84-1924bec0c8c9"
  }, {
    "associated_actions" : null,
    "category_id" : null,
    "date_source_handle" : "incident.discovered_date",
    "deleted" : false,
    "due_date_offset" : 0,
    "due_date_units" : null,
    "enabled" : true,
    "export_key" : "determine_an_appropriate_eradication_or_recovery_strategy",
    "form" : null,
    "id" : 0,
    "instructions" : "Determine an appropriate eradication or recovery strategy for each affected system based on the nature of its compromise. This could include applying patches, replacing compromised files or passwords, reimaging it from backup, rebuilding it from scratch, and tightening network perimeter security. Create specific tasks in this system and assign them to appropriate individuals.",
    "name" : "Determine an appropriate eradication or recovery strategy",
    "optional" : false,
    "phase_id" : "Detect/Analyze",
    "programmatic_name" : "determine_an_appropriate_eradication_or_recovery_strategy",
    "tags" : [ ],
    "task_layout" : [ ],
    "uuid" : "476c7c0f-8bc7-45cd-877d-347e1173aa84"
  }, {
    "associated_actions" : null,
    "category_id" : null,
    "date_source_handle" : "incident.discovered_date",
    "deleted" : false,
    "due_date_offset" : 0,
    "due_date_units" : null,
    "enabled" : true,
    "export_key" : "determine_if_illegal_activity_is_involved",
    "form" : null,
    "id" : 0,
    "instructions" : "Determine if illegal activity is involved",
    "name" : "Determine if illegal activity is involved",
    "optional" : false,
    "phase_id" : "Engage",
    "programmatic_name" : "determine_if_illegal_activity_is_involved",
    "tags" : [ ],
    "task_layout" : [ {
      "content" : "crimestatus_id",
      "element" : "field",
      "field_type" : "incident",
      "show_if" : null,
      "show_link_header" : false,
      "step_label" : null
    } ],
    "uuid" : "d4568234-4400-4850-885b-a1be97adb253"
  }, {
    "associated_actions" : null,
    "category_id" : null,
    "date_source_handle" : "incident.discovered_date",
    "deleted" : false,
    "due_date_offset" : 0,
    "due_date_units" : null,
    "enabled" : true,
    "export_key" : "determine_if_inappropriate_internal_involvement",
    "form" : null,
    "id" : 0,
    "instructions" : "Determine if internal employees or contractors were inappropriately involved. This could range from intentional nefarious activity to simple disregard for company policy. Update the value for Employee Involved above or on the Details tab of the incident. Add notes to this task capturing all of your activities and findings.",
    "name" : "Determine if inappropriate internal involvement",
    "optional" : false,
    "phase_id" : "Engage",
    "programmatic_name" : "determine_if_inappropriate_internal_involvement",
    "tags" : [ ],
    "task_layout" : [ {
      "content" : "employee_involved",
      "element" : "field",
      "field_type" : "incident",
      "show_if" : null,
      "show_link_header" : false,
      "step_label" : null
    } ],
    "uuid" : "78b62efd-56f9-4deb-8566-135417d03efa"
  }, {
    "associated_actions" : null,
    "category_id" : null,
    "date_source_handle" : "incident.discovered_date",
    "deleted" : false,
    "due_date_offset" : 0,
    "due_date_units" : null,
    "enabled" : true,
    "export_key" : "determine_the_techniques_being_used_to_engage_targets",
    "form" : null,
    "id" : 0,
    "instructions" : "Determine the techniques being used to engage targets and ways to uniquely identify them. This can be used to construct countermeasures. For example, does the attack utilize a particular and identifiable email subject or body? Does it come from a specific email address or from a particular SMTP server? Does it contain a link to a particular website? Does it involve a phone call where the user is asked to navigate to a particular website?<br /><br />\n\nInclude suspicious IP addresses or URLs, email characteristics or attachments as incident artifacts on the Artifacts tab. The system will correlate this information against several threat intelligence source and provide feedback.<br /><br />",
    "name" : "Determine the techniques being used to engage targets",
    "optional" : false,
    "phase_id" : "Detect/Analyze",
    "programmatic_name" : "determine_the_techniques_being_used_to_engage_targets",
    "tags" : [ ],
    "task_layout" : [ ],
    "uuid" : "8ce1d4d7-9831-4c9e-88c3-1fc2bdb339d1"
  }, {
    "associated_actions" : null,
    "category_id" : null,
    "date_source_handle" : "incident.discovered_date",
    "deleted" : false,
    "due_date_offset" : 0,
    "due_date_units" : null,
    "enabled" : true,
    "export_key" : "disconnect_compromised_systems",
    "form" : null,
    "id" : 0,
    "instructions" : "To regain control, you may need to disconnect compromised machines from your network, including dial-in connections. If you do not disconnect the compromised machine from the network, you run the risk that the intruder may be connected to your machine and may be undoing your steps as you try to recover the machine. However, disconnecting the system can destroy some critical information (such as active connections). Determine which, if any, forensic information needs to be collected before disconnecting the system and balance that against the risk of keeping the affected system connected to the network.\n\nYou may wish to operate in single user mode on UNIX or as the local administrator on Windows to ensure that you have complete control of the machine; however, by rebooting or changing to single user/local administrator mode, you may lose some useful information, because all processes executing at the time of discovery will be killed.",
    "name" : "Disconnect compromised systems",
    "optional" : false,
    "phase_id" : "Detect/Analyze",
    "programmatic_name" : "disconnect_compromised_systems",
    "tags" : [ ],
    "task_layout" : [ ],
    "uuid" : "b6059f4d-e178-4727-9857-232f6d162579"
  }, {
    "associated_actions" : null,
    "category_id" : null,
    "date_source_handle" : "incident.discovered_date",
    "deleted" : false,
    "due_date_offset" : 0,
    "due_date_units" : null,
    "enabled" : true,
    "export_key" : "disconnect_or_isolate_malware_infected_systems",
    "form" : null,
    "id" : 0,
    "instructions" : "Disconnect or isolate affected systems if feasible and create backups as appropriate. If the infection seems to be too large to individually isolate specific systems, consider blocking all outbound traffic to prevent contact with controllers. In the case of malware on mobile devices, acquire and isolate the mobile device for further analysis, using proper methods such as a Faraday Bag. Keep the device powered on and charged as appropriate.",
    "name" : "Disconnect or isolate malware-infected systems",
    "optional" : false,
    "phase_id" : "Detect/Analyze",
    "programmatic_name" : "disconnect_or_isolate_malware_infected_systems",
    "tags" : [ ],
    "task_layout" : [ ],
    "uuid" : "3f1e013c-833b-44bd-aebe-d005cbbd333d"
  }, {
    "associated_actions" : null,
    "category_id" : null,
    "date_source_handle" : "incident.discovered_date",
    "deleted" : false,
    "due_date_offset" : 0,
    "due_date_units" : null,
    "enabled" : true,
    "export_key" : "ensure_appropriate_evidence_collection_and_preservation",
    "form" : null,
    "id" : 0,
    "instructions" : "Ensure appropriate steps are taken for evidence collection, preservation and documentation. A clearly defined chain of custody should be followed to avoid allegations of mishandling or tampering of evidence. This typically involves assigning an evidence custodian to receive, secure and document all items of evidence. They should keep a log of every person who had physical custody of, or electronic access to, the evidence, documenting the actions that they performed on the evidence and at what time, storing the evidence in a secure location when it is not being used, making copies of the evidence and performing examination and analysis using only the copied evidence, and verifying the integrity of the original and copied evidence. A detailed log should be kept for all evidence including:\n\n<ul>\n<li>Initial state of affected computer systems. Photograph and/or fully document what is seen on the screen before touching the system.</li>\n<li>Identifying information, such as the location, serial number, model number, host name, media access control (MAC) addresses, and IP addresses of a computer. </li>\n<li>Chain of custody including the name, title and phone number of each individual who collected or handled the evidence during the investigation and when.</li>\n<li>Time and date (including time zone) of each occurrence of evidence handling.</li>\n<li>Locations where the evidence was stored, and safeguards taken to ensure its integrity for use in prosecution.</li>\n<li>Capture volatile data from systems: network connections, login sessions, open files, network interface configuration, memory contents, and so on.</li>\n</ul>\nThe Best Evidence Rule is a long-standing description of what rules must be followed to ensure that writings or recordings that are used in court have integrity and can be relied upon as evidence.  The Federal Rules of Evidence (United States) (http://federalevidence.com/rules-of-evidence) addresses how the best evidence rule applies to electronic evidence.  Rule 1001(3) provides &quot;[if] data are stored in a computer or similar device, any printout or other output readable by sight, shown to reflect the data accurately, is an 'original'&quot;.  Under this rule, multiple copies of electronic files may each constitute an &quot;original&quot;.\n<br /><br /><br />\nOther References: <br />\nCanada's Uniform Electronic Evidence Act: http://cryptome.org/jya/eueea.htm",
    "name" : "Ensure appropriate evidence collection and preservation",
    "optional" : false,
    "phase_id" : "Engage",
    "programmatic_name" : "ensure_appropriate_evidence_collection_and_preservation",
    "tags" : [ ],
    "task_layout" : [ ],
    "uuid" : "64418f24-1925-4054-a8c4-8c891790d9a8"
  }, {
    "associated_actions" : null,
    "category_id" : null,
    "date_source_handle" : "incident.discovered_date",
    "deleted" : false,
    "due_date_offset" : 0,
    "due_date_units" : null,
    "enabled" : true,
    "export_key" : "ensure_updated_antivirus_signatures_are_deployed",
    "form" : null,
    "id" : 0,
    "instructions" : "Ensure updated antivirus signatures are deployed for host and network-based AV products and install AV software wherever it is absent.",
    "name" : "Ensure updated antivirus signatures are deployed",
    "optional" : false,
    "phase_id" : "Respond",
    "programmatic_name" : "ensure_updated_antivirus_signatures_are_deployed",
    "tags" : [ ],
    "task_layout" : [ ],
    "uuid" : "2659fdda-c6f2-48b8-b033-140ae5a3ab24"
  }, {
    "associated_actions" : null,
    "category_id" : null,
    "date_source_handle" : "incident.discovered_date",
    "deleted" : false,
    "due_date_offset" : 0,
    "due_date_units" : null,
    "enabled" : true,
    "export_key" : "file_a_false_whois_complaint_with_icann",
    "form" : null,
    "id" : 0,
    "instructions" : "File a false Whois complaint with ICANN to have any nefarious phishing domain name involved cancelled. The complaint can be filed at: http://reports.internic.net/cgi/registrars/problem-report.cgi",
    "name" : "File a false Whois complaint with ICANN",
    "optional" : false,
    "phase_id" : "Respond",
    "programmatic_name" : "file_a_false_whois_complaint_with_icann",
    "tags" : [ ],
    "task_layout" : [ ],
    "uuid" : "6b77ae71-cb3d-4b84-a745-32a1db274ae9"
  }, {
    "associated_actions" : null,
    "category_id" : null,
    "date_source_handle" : "incident.discovered_date",
    "deleted" : false,
    "due_date_offset" : 0,
    "due_date_units" : null,
    "enabled" : true,
    "export_key" : "generate_incident_report",
    "form" : null,
    "id" : 0,
    "instructions" : "<p>Generate an incident report that documents the findings and action items which came out of your post-incident review. Creating a formal chronology of events (including time-stamped information such as log data from systems) is important for legal reasons, as is creating a monetary estimate of the amount of damage the incident caused. This estimate may become the basis for subsequent prosecution activity by entities such as the U.S. Attorney General's office. Follow-up reports should be kept for a period of time as specified in record retention policies.</p>\n\n<p>The report may contain the following sections:</p>\n<h5>Executive Summary</h5>\nThis section contains a concise but complete high level overview of the incident. \n\n<h5>Findings</h5>\nThis section contains a bulleted list of findings from the incident response investigation. These findings should focus on facts and avoid opinions or speculations. This section gives executives a concise view of the facts surrounding the incident investigations and should include resource and financial costs where quantifiable.\n \n<h5>Recommendations</h5>\nThis section contains a bulleted list of recommendations from the incident response investigation. These recommendations are usually collated and refined by the IR team members and approved by the incident leader. They define all actions recommended as a result of an investigation, including but not limited to, legal action, administrative action, policy changes, acquisition of new tools, configuration changes, and personnel changes.\n\n<h5>Incident Background</h5>\nThis section contains a more detailed description of the event. It is designed to provide a more technical overview of the incident than provided in the Executive Overview. It can cover the current understanding or speculation of items such as scope, motive, and actors.\n\n<h5>Incident Timeline</h5>\nAll investigative reports will include an incident timeline. This section of the report is usually in a table or spreadsheet format. A good timeline gives a precise chronological timeline of all events surrounding the incident.\n\n<h5>Appendix</h5>\nThe appendix section contains relevant charts, photos, diagrams, and other documents related to the investigations. This section provides a recap of the incident investigation.",
    "name" : "Generate incident report",
    "optional" : false,
    "phase_id" : "Post-Incident",
    "programmatic_name" : "generate_incident_report",
    "tags" : [ ],
    "task_layout" : [ ],
    "uuid" : "ae0ce92b-6395-431d-bfd5-dc6f373882ed"
  }, {
    "associated_actions" : null,
    "category_id" : null,
    "date_source_handle" : "incident.discovered_date",
    "deleted" : false,
    "due_date_offset" : 0,
    "due_date_units" : null,
    "enabled" : true,
    "export_key" : "harden_andor_patch_all_other_vulnerable_systems",
    "form" : null,
    "id" : 0,
    "instructions" : "Determine the vulnerabilities or techniques being leveraged in the attack and assess other similar systems to determine if they may also be vulnerable. Create tasks and take action to address any possible vulnerabilities.",
    "name" : "Harden and/or patch all other vulnerable systems",
    "optional" : false,
    "phase_id" : "Respond",
    "programmatic_name" : "harden_andor_patch_all_other_vulnerable_systems",
    "tags" : [ ],
    "task_layout" : [ ],
    "uuid" : "2b861827-78d5-4254-bf94-f731dc67339d"
  }, {
    "associated_actions" : null,
    "category_id" : null,
    "date_source_handle" : "incident.discovered_date",
    "deleted" : false,
    "due_date_offset" : 0,
    "due_date_units" : null,
    "enabled" : true,
    "export_key" : "identify_specific_malware_infected_devices",
    "form" : null,
    "id" : 0,
    "instructions" : "Identify specific malware-infected devices using forensic techniques, login scripts, custom IPS and IDS signatures, packet sniffers, port scans (looking for ports the malware listens on), AV console output, SEIM, desktop management systems (look for files/folders), netflow data, DLP tools or by providing instructions to end users for self-diagnoses. Generate specific tasks appropriate for leveraging multiple approaches simultaneously.",
    "name" : "Identify specific malware-infected devices",
    "optional" : false,
    "phase_id" : "Respond",
    "programmatic_name" : "identify_specific_malware_infected_devices",
    "tags" : [ ],
    "task_layout" : [ ],
    "uuid" : "0368d5c4-1d88-4d25-b1e4-e8e4bb05adee"
  }, {
    "associated_actions" : null,
    "category_id" : null,
    "date_source_handle" : "incident.discovered_date",
    "deleted" : false,
    "due_date_offset" : 0,
    "due_date_units" : null,
    "enabled" : true,
    "export_key" : "initial_triage",
    "form" : null,
    "id" : 0,
    "instructions" : "Execute an initial triage of the incident. Focus on determining information such as \n<ul>\n<li>is this an actual incident or false alarm, </li>\n<li>the scope and impact, </li>\n<li> systems involved including applications, operating systems, and business and technical owners,</li>\n<li>is the incident still ongoing, </li>\n<li>has confidential or personal data possibly been exposed or exfiltrated, </li>\n<li>has there been illegal activity, </li>\n<li>are employees involved, </li>\n<li>have your communication systems been compromised. </li>\n</ul>\nAdd notes to this task capturing all of your activities and initial findings. Adjust the incident team membership to include the necessary individuals and add details to the incident description including logistics around regularly scheduled meetings, etc.\n<br /><br />\nNote: If criminal or inappropriate employee activity is involved you should consider ensuring that the appropriate evidence collection and preservation procedures are followed.",
    "name" : "Initial Triage",
    "optional" : false,
    "phase_id" : "Engage",
    "programmatic_name" : "initial_triage",
    "tags" : [ {
      "tag_handle" : "fn_main_mock_integration",
      "value" : null
    } ],
    "task_layout" : [ ],
    "uuid" : "2d261a8a-14c3-4f0f-a237-7c6a76bf82b1"
  }, {
    "associated_actions" : null,
    "category_id" : null,
    "date_source_handle" : "incident.discovered_date",
    "deleted" : false,
    "due_date_offset" : 0,
    "due_date_units" : null,
    "enabled" : true,
    "export_key" : "interview_key_individuals",
    "form" : null,
    "id" : 0,
    "instructions" : "Interview key individuals such as end users, system administrators and affected system/application owners. Determine: \n<ul>\n<li>Any recent unusual activities noted?</li>\n<li>Who has administrator access to the affected systems involved?</li>\n<li>Any recent configuration changes or patches applied?</li>\n<li>Any recent suspicious emails or documents received and/or opened?</li>\n<li>Any recent suspicious web browsing activity?</li>\n<li>What logging is provided by the affected systems/applications?</li>\n<li>Do the affected systems contain any sensitive personal or confidential information?</li>\n</ul>\nAdd notes to this task, or attach interview notes, that capture all of your activities and findings.",
    "name" : "Interview key individuals",
    "optional" : false,
    "phase_id" : "Engage",
    "programmatic_name" : "interview_key_individuals",
    "tags" : [ ],
    "task_layout" : [ ],
    "uuid" : "2e05bff9-8d15-4424-91c1-9e50d2c78bae"
  }, {
    "associated_actions" : null,
    "category_id" : null,
    "date_source_handle" : "incident.discovered_date",
    "deleted" : false,
    "due_date_offset" : 0,
    "due_date_units" : null,
    "enabled" : true,
    "export_key" : "look_for_modifications_made_to_system_software_and_configuration_files",
    "form" : null,
    "id" : 0,
    "instructions" : "<p>When looking for modifications of system software and configuration files, keep in mind that any tool you are using on the compromised system to verify the integrity of binaries and configuration files could itself be modified. Also keep in mind that the kernel (operating system) itself could be modified. Because of this, boot from a trusted kernel and obtain a known clean copy of any tool you intend to use in analyzing the intrusion. On UNIX systems, you can create a boot disk and make it write protected to obtain a trustworthy kernel.</p>\n\n<p>Check all of your system binaries thoroughly against distribution media or recent hashes. There is historically an extensive range of Trojan horse binaries that have been installed by intruders.</p>\n\n<p>Some of the binaries that are commonly replaced by Trojan horses on UNIX systems are: telnet, in.telnetd, login, su, ftp, ls, ps, netstat, ifconfig, find, du, df, libc, sync, inetd, and syslogd. Also check any binaries referenced in /etc/inetd.conf, critical network and system programs, and shared object libraries.</p>\n\n<p>On Windows systems, Trojan horses commonly introduce computer viruses or &quot;remote administration&quot; programs such as Back Orifice and NetBus. There have been cases where the system file that handles internet connectivity was replaced with a Trojan horse.</p>\n\n<p>Because some Trojan horse programs could have the same timestamps as the original binaries and give the correct sum values, we recommend you use cmp on UNIX systems to make a direct comparison of the binaries and the original distribution media.</p>\n\n<p>Alternatively, you can check the MD5 results for either UNIX or NT on suspect binaries against a list of MD5 checksums from known good binaries. Ask your vendor if they make MD5 checksums available for their distribution binaries.</p>\n\n<p>Additionally, verify your configuration files against copies that you know to be unchanged.</p>\n\n<p>When inspecting your configuration files on UNIX systems, you may want to: perform the following\n</p><ul>\n<li>Check your /etc/passwd file for entries that do not belong.\n</li><li>Check to see if /etc/inetd.conf has been modified.\n</li><li>If you allow the &quot;r-commands&quot; (rlogin, rsh, rexec), ensure that there is nothing that does not belong in /etc/hosts.equiv or in any of the .rhosts files.\n</li><li>Check for new SUID and SGID files. The following command prints out all SUID and SGID files within your file system.\n</li><li> # find / \\( -perm -004000 -o -perm -002000 \\) -type f -print\n</li></ul><p></p>\n\n<p>When inspecting Windows systems, you may want to:\n</p><ul>\n<li>Check for odd users or group memberships.\n</li><li>Check for changes to registry entries that start programs at logon or services.\n</li><li>Check for unauthorized hidden shares with the 'net share' command or Server Manager tool.\n</li><li>Check for processes that you do not identify using the pulist.exe or comparable tool from the Windows resource kit or Task Manager.\n</li></ul><p></p>",
    "name" : "Look for modifications made to system software and configuration files",
    "optional" : false,
    "phase_id" : "Detect/Analyze",
    "programmatic_name" : "look_for_modifications_made_to_system_software_and_configuration_files",
    "tags" : [ ],
    "task_layout" : [ ],
    "uuid" : "14db6e8a-ad39-48cc-a98d-758f7523d808"
  }, {
    "associated_actions" : null,
    "category_id" : null,
    "date_source_handle" : "incident.discovered_date",
    "deleted" : false,
    "due_date_offset" : 0,
    "due_date_units" : null,
    "enabled" : true,
    "export_key" : "look_for_signs_of_network_sniffers",
    "form" : null,
    "id" : 0,
    "instructions" : "<p>Look for signs of a network sniffer. When a system compromise occurs, intruders could potentially install a network monitoring program on UNIX systems or a packet sniffer to capture user account and password information. For Windows systems, remote administration programs would be more commonly used for the same purpose.</p>\n\n<p>The first step to take in determining if a sniffer is installed on your system is to see if any process currently has any of your network interfaces in promiscuous mode. If any interface is in promiscuous mode, then a sniffer could be installed on your system. Note that detecting promiscuous interfaces will not be possible if you have rebooted your machine or are operating in single user mode since your discovery of this intrusion.</p>\n\n<p>There are a couple of tools designed for this purpose.</p>\n\n<p>cpm - available for download from ftp://coast.cs.purdue.edu/pub/tools/unix/sysutils/cpm/ </p>\n\n<p>ifstatus - available for download from ftp://coast.cs.purdue.edu/pub/tools/unix/sysutils/ifstatus/ </p>\n\n<p>Keep in mind that some legitimate network monitors and protocol analyzers will set a network interface in promiscuous mode. Detecting an interface in promiscuous mode does not necessarily mean that an intruder's sniffer is running on a system.</p>\n\n<p>Another issue to consider is that sniffer log files tend to grow quickly in size. You may want to use utilities, such as df, to determine if part of the file system is larger than expected. Remember that df is often replaced by a Trojan horse program when sniffers are installed; therefore, be sure to obtain a known clean copy of that utility if you do use it.</p>\n\n<p>If you find that a packet sniffer has been installed on your systems, you should consider examining the output file from the sniffer to determine what other machines are at risk. Machines at risk are those that appear in the destination field of a captured packet, but if passwords across systems are common or if the source and destination machines trust each other, the source machine will also be at further risk.</p>\n\n<p>Many common sniffers will log each connection as follows:</p><br />\n\n     -- TCP/IP LOG -- TM: Tue Nov 15 15:12:29 --\n     PATH: not_at_risk.domain.com(1567) =&gt; at_risk.domain.com(telnet)\n<br />\n<p>For sniffer logs of this particular format, you can obtain a list of affected machines by executing the following command:</p><br />\n\n     % grep PATH: $sniffer_log_file | awk '{print $4}' | \\\n       awk -F\\( '{print $1}'| sort -u\n<br />\n<p>You may need to adjust the command for your particular case. Also, some sniffers encrypt their logs so they may not be obvious. Because of this, check for files that grow quickly.</p>\n\n<p>You should be aware that there may be other machines at risk in addition to the ones that appear in the sniffer log.</p>",
    "name" : "Look for signs of network sniffers",
    "optional" : false,
    "phase_id" : "Detect/Analyze",
    "programmatic_name" : "look_for_signs_of_network_sniffers",
    "tags" : [ ],
    "task_layout" : [ ],
    "uuid" : "3e2aff73-af1f-471c-afab-692c5b1c0f39"
  }, {
    "associated_actions" : null,
    "category_id" : null,
    "date_source_handle" : "incident.discovered_date",
    "deleted" : false,
    "due_date_offset" : 0,
    "due_date_units" : null,
    "enabled" : true,
    "export_key" : "look_for_tools_and_data_left_behind_by_the_intruder",
    "form" : null,
    "id" : 0,
    "instructions" : "<p>Intruders will commonly install custom-made tools for continued monitoring of, or access to, a compromised system.\nThe common classes of files left behind by intruders are:</p>\n\n<h5>Trojan Horse Programs</h5>\n\nTrojan horse programs are programs that appear to perform one function while actually performing a different function. Intruders use Trojan horse programs to hide their activity, capture user name and password data, and create backdoors for future access to a compromised system.\n\n<h5>Backdoors</h5>\n\nBackdoor programs are designed to hide themselves inside a target host. The backdoor allows the user that installed it to access the system without using normal authorization or vulnerability exploitation. These tools are often left behind on the system in &quot;hidden&quot; directories.\n\n<h5>Other Intruder Tools</h5>\n\nSome of the other types of tools you may find are tools to:\n<ul>\n<li>probe systems for vulnerabilities</li>\n<li>launch widespread probes of many other sites</li>\n<li>launch denial of service attacks</li>\n<li>use your computing and networking resources.</li>\n</ul>\n\n<h5>Intruder Tool Output</h5>\n\nYou may find log files from any number of intruder tools. These log files may contain information about other sites involved, vulnerabilities of your compromised machines, and vulnerabilities at other sites.\nSearch thoroughly for such tools and output files. Be sure to use a known clean copy of any tool that you use to search for intruder tools.\n\n<p>When searching for intruder tools on a compromised system:</p>\n<ul>\n<li>Look for unexpected ASCII files in the /dev directory on UNIX systems. Some of the Trojan binaries rely on configuration files which are often found in /dev.</li> \n<li>Look very carefully for hidden files or directories. If an intruder has created a new account and home directory then there may be hidden files or directories. </li>\n<li>Look for files or directories with strange names such as &quot;...&quot; (three dots) or &quot;..&quot; (two dots and some white space). Intruders often try and hide files within such directories. On Windows systems, look for files and directories that closely match what may appear as a system file (EXPLORE.EXE, UMGR32.EXE, and so on).</li>\n</ul>",
    "name" : "Look for tools and data left behind by the intruder",
    "optional" : false,
    "phase_id" : "Detect/Analyze",
    "programmatic_name" : "look_for_tools_and_data_left_behind_by_the_intruder",
    "tags" : [ ],
    "task_layout" : [ ],
    "uuid" : "2d370310-f153-4560-9da6-03e2e7c6716b"
  }, {
    "associated_actions" : null,
    "category_id" : null,
    "date_source_handle" : "incident.discovered_date",
    "deleted" : false,
    "due_date_offset" : 0,
    "due_date_units" : null,
    "enabled" : true,
    "export_key" : "mock_cusom_task__________two",
    "form" : null,
    "id" : 0,
    "instructions" : "<div class=\"rte\"><div>Sample instruction s ㌎ ㌏ ㌐ ㌑ ㌒ ㌓ ㌔ ㌕ ㌖ here now ㌎ ㌏ ㌐ ㌑ ㌒ ㌓ ㌔ ㌕ ㌖</div></div>",
    "name" : "Mock Cusom Task ㌎ ㌏ ㌐ ㌑ ㌒ ㌓ ㌔ ㌕ ㌖ Two",
    "optional" : false,
    "phase_id" : "Mock Custom Phase Two",
    "programmatic_name" : "mock_cusom_task__________two",
    "tags" : [ {
      "tag_handle" : "fn_main_mock_integration",
      "value" : null
    } ],
    "task_layout" : [ {
      "content" : "mock_field_number",
      "element" : "field",
      "field_type" : "incident",
      "show_if" : null,
      "show_link_header" : false,
      "step_label" : null
    }, {
      "content" : "mock_field_text",
      "element" : "field",
      "field_type" : "incident",
      "show_if" : null,
      "show_link_header" : false,
      "step_label" : null
    }, {
      "content" : "mock_field_text_area",
      "element" : "field",
      "field_type" : "incident",
      "show_if" : null,
      "show_link_header" : false,
      "step_label" : null
    } ],
    "uuid" : "3a7c8b57-637b-4598-a729-98140ec71275"
  }, {
    "associated_actions" : null,
    "category_id" : null,
    "date_source_handle" : "incident.discovered_date",
    "deleted" : false,
    "due_date_offset" : 0,
    "due_date_units" : null,
    "enabled" : true,
    "export_key" : "mock_custom_task_one",
    "form" : null,
    "id" : 0,
    "instructions" : "<div class=\"rte\"><div>Sample instructions ㌎ ㌏ ㌐ ㌑ ㌒ ㌓ ㌔ ㌕ ㌖ ㌎ ㌏ ㌐ ㌑ ㌒ ㌓ ㌔ ㌕ ㌖ ㌎ ㌏ ㌐ ㌑ ㌒ ㌓ ㌔ ㌕ ㌖</div></div>",
    "name" : "Mock Custom Task One",
    "optional" : false,
    "phase_id" : "Mock Custom Phase One",
    "programmatic_name" : "mock_custom_task_one",
    "tags" : [ {
      "tag_handle" : "fn_main_mock_integration",
      "value" : null
    } ],
    "task_layout" : [ {
      "content" : "mock_field_number",
      "element" : "field",
      "field_type" : "incident",
      "show_if" : null,
      "show_link_header" : false,
      "step_label" : null
    } ],
    "uuid" : "df101758-75dd-46d3-b080-1f338fc088a2"
  }, {
    "associated_actions" : null,
    "category_id" : null,
    "date_source_handle" : "incident.discovered_date",
    "deleted" : false,
    "due_date_offset" : 0,
    "due_date_units" : null,
    "enabled" : true,
    "export_key" : "notify_carrierisp",
    "form" : null,
    "id" : 0,
    "instructions" : "If the lost or stolen device has cellular access, call the device service provider and notify them of the device loss.",
    "name" : "Notify carrier/ISP",
    "optional" : false,
    "phase_id" : "Respond",
    "programmatic_name" : "notify_carrierisp",
    "tags" : [ ],
    "task_layout" : [ ],
    "uuid" : "7d1be376-330b-432c-9080-dbc525a3adc3"
  }, {
    "associated_actions" : null,
    "category_id" : null,
    "date_source_handle" : "incident.discovered_date",
    "deleted" : false,
    "due_date_offset" : 0,
    "due_date_units" : null,
    "enabled" : true,
    "export_key" : "notify_computer_security_organizations_and_resources",
    "form" : null,
    "id" : 0,
    "instructions" : "<p>Notify US-CERT, your ISAC or other CSIRTs of any significant computer security incidents. </p>\n\n<p>US-CERT contact information:<br />\nE-mail: soc@us-cert.gov<br />\nVoice: 1-888-282-0870 <br />\nPGP/GPG key: 0x79E4184E<br />\nFingerprint: 057D D916 EA26 6B06 168B 3365 4A20 1BD8 79E4 184E<br />\nPGP Key: http://www.us-cert.gov/pgp/info.asc<br />\nIncident Reporting Form: https://www.us-cert.gov/forms/report<br />\n</p>\n\n<p>CERT Coordination Center <br />\nSoftware Engineering Institute <br />\nCarnegie Mellon University <br />\nPittsburgh, PA USA 15213-3890 <br />\n</p>\n<p>CERT contact information is as follows: <br />\nEmail: cert@cert.org (monitored during business hours) <br />\nTelephone: +1-412-268-7090 24-hour hotline<br />\nFax: +1-412-268-6989 <br />\n</p>\n<p>CERT Coordination Center personnel answer during business days (Monday-Friday) 08:30-17:00 EST/EDT (GMT-5)/(GMT-4), and are on call for emergencies during other hours. </p>\n\n<p>To find contact information for other incident response teams, you may also want to check the contact list of the Forum of Incident Response and Security Teams (FIRST), available at: http://www.first.org </p>\n\n<p>More information about finding site contacts is available from: \nhttp://www.cert.org/tech_tips/finding_site_contacts.html </p>\n\n<p>Document all communication with outside parties for liability and evidentiary purposes.</p>",
    "name" : "Notify computer security organizations and resources",
    "optional" : false,
    "phase_id" : "Respond",
    "programmatic_name" : "notify_computer_security_organizations_and_resources",
    "tags" : [ ],
    "task_layout" : [ ],
    "uuid" : "050e0082-2850-440a-9ab6-2ef9e44c94e3"
  }, {
    "associated_actions" : null,
    "category_id" : null,
    "date_source_handle" : "incident.discovered_date",
    "deleted" : false,
    "due_date_offset" : 0,
    "due_date_units" : null,
    "enabled" : true,
    "export_key" : "notify_constituents_resolution",
    "form" : null,
    "id" : 0,
    "instructions" : "Notify constituents when the incident has been resolved. Consider providing a summary of the incident, what was done to address it, what is being done to prevent similar issues in the future, and so on. Provide guidance for any actions that they should take as a result of the incident, such as changing passwords which may have been compromised. Include information on anything the constituents can do to help prevent similar incidents going forward.",
    "name" : "Notify constituents (resolution)",
    "optional" : false,
    "phase_id" : "Post-Incident",
    "programmatic_name" : "notify_constituents_resolution",
    "tags" : [ ],
    "task_layout" : [ ],
    "uuid" : "1304b070-4b68-4ef8-83f2-436e45efee8d"
  }, {
    "associated_actions" : null,
    "category_id" : null,
    "date_source_handle" : "incident.discovered_date",
    "deleted" : false,
    "due_date_offset" : 0,
    "due_date_units" : null,
    "enabled" : true,
    "export_key" : "notify_constituents_status_update",
    "form" : null,
    "id" : 0,
    "instructions" : "Notify constituents as appropriate, such as local IT security rep, other IR teams, compromised internal system owners, users, and customers. Provide a general description of the issue, steps the end user population can do to assist, and an estimate (if possible) of how long it will take to resolve the issue.",
    "name" : "Notify constituents (status update)",
    "optional" : false,
    "phase_id" : "Respond",
    "programmatic_name" : "notify_constituents_status_update",
    "tags" : [ ],
    "task_layout" : [ ],
    "uuid" : "d1490d7e-62bf-4ee0-881b-05459dc8c497"
  }, {
    "associated_actions" : null,
    "category_id" : null,
    "date_source_handle" : "incident.discovered_date",
    "deleted" : false,
    "due_date_offset" : 0,
    "due_date_units" : null,
    "enabled" : true,
    "export_key" : "notify_external_parties_as_appropriate",
    "form" : null,
    "id" : 0,
    "instructions" : "Notify your ISP and other external parties as appropriate. Possibilities include owners of external systems/networks involved in the incident, AV vendors, software vendors, and other affected external parties. Generate and assign tasks for each notification activity. Note that external communication may need management and legal involvement.<br /><br />\n\nIf you need contact information for a .COM, .EDU, .NET, or .ORG top-level domain, use the InterNIC's whois database:<br />\nhttp://www.internic.net/whois.html<br /><br />\n\nTo find contact information from the appropriate registrar, use the InterNIC's Registrar Directory:<br />\nhttp://www.internic.net/origin.html<br /><br />\n\nTo find contact information for the Asia-pacific region and Australia, respectively:<br />\nhttp://www.apnic.net/apnic-bin/whois.pl<br />\nhttp://www.auda.org.au/whois/whois-overview/<br /><br />\n\nDocument all communication with outside parties for liability and evidentiary purposes.",
    "name" : "Notify external parties as appropriate",
    "optional" : false,
    "phase_id" : "Respond",
    "programmatic_name" : "notify_external_parties_as_appropriate",
    "tags" : [ ],
    "task_layout" : [ ],
    "uuid" : "919a1a73-3590-4fa4-a934-0b7e5100aa72"
  }, {
    "associated_actions" : null,
    "category_id" : null,
    "date_source_handle" : "incident.discovered_date",
    "deleted" : false,
    "due_date_offset" : 0,
    "due_date_units" : null,
    "enabled" : true,
    "export_key" : "notify_hr",
    "form" : null,
    "id" : 0,
    "instructions" : "If the incident involved the inappropriate behavior of an employee or contractor, notify their direct manager and the HR department.",
    "name" : "Notify HR",
    "optional" : false,
    "phase_id" : "Respond",
    "programmatic_name" : "notify_hr",
    "tags" : [ ],
    "task_layout" : [ ],
    "uuid" : "34a55898-0b6e-49f4-9836-965aecaed3df"
  }, {
    "associated_actions" : null,
    "category_id" : null,
    "date_source_handle" : "incident.discovered_date",
    "deleted" : false,
    "due_date_offset" : 0,
    "due_date_units" : null,
    "enabled" : true,
    "export_key" : "notify_internal_management_chain_preliminary",
    "form" : null,
    "id" : 0,
    "instructions" : "Based on the severity and scope of the incident, determine if a preliminary internal notification is appropriate and to whom. Document and execute as appropriate.",
    "name" : "Notify internal management chain (preliminary)",
    "optional" : true,
    "phase_id" : "Engage",
    "programmatic_name" : "notify_internal_management_chain_preliminary",
    "tags" : [ ],
    "task_layout" : [ ],
    "uuid" : "e799edeb-7bf2-4b9b-9802-4befb16c1ed7"
  }, {
    "associated_actions" : null,
    "category_id" : null,
    "date_source_handle" : "incident.discovered_date",
    "deleted" : false,
    "due_date_offset" : 0,
    "due_date_units" : null,
    "enabled" : true,
    "export_key" : "notify_internal_management_chain_resolution",
    "form" : null,
    "id" : 0,
    "instructions" : "Update the internal management chain as appropriate regarding the resolution of the incident. Consider including the following information:\n<ul>\n<li>Final summary of the incident including scale and root cause.</li>\n<li>Timeline of the attack and the response.</li>\n<li>Any exposure related to personal or confidential information.</li>\n<li>Current understanding of impact to the business.</li>\n<li>Direct and indirect costs associated with the incident.</li>\n<li>Initial learnings and steps taken to avoid future incidents.</li>\n<li>Timeframe for producing a formal incident report.</li>\n</ul>",
    "name" : "Notify internal management chain (resolution)",
    "optional" : false,
    "phase_id" : "Post-Incident",
    "programmatic_name" : "notify_internal_management_chain_resolution",
    "tags" : [ ],
    "task_layout" : [ ],
    "uuid" : "e3891eb4-f0c9-4a04-bfab-1d3380c0bf2f"
  }, {
    "associated_actions" : null,
    "category_id" : null,
    "date_source_handle" : "incident.discovered_date",
    "deleted" : false,
    "due_date_offset" : 0,
    "due_date_units" : null,
    "enabled" : true,
    "export_key" : "notify_law_enforcement",
    "form" : null,
    "id" : 0,
    "instructions" : "Consider notifying law enforcement including the FBI (http://www.fbi.gov/contact/fo/fo.htm), the Internet Crime Complaint Center (http://www.ic3.gov/complaint/default.aspx ) or the US Secret Service (http://www.secretservice.gov/field_offices.shtml ). The Department of Justice website provides further guidance on reporting various types of cyber crimes (http://www.justice.gov/criminal/cybercrime/reporting.html). Document all communication with outside parties for liability and evidentiary purposes.\n\n<h4>Contact Information</h4>\nTo initiate an investigation, contact your local FBI office or another appropriate federal, state, or local law enforcement agency. To report an incident to the FBI, you can submit a tip report at http://ibm.biz/ic3-gov. Be prepared to provide incident documentation, share information about the intruder, and share any ideas about possible motives.",
    "name" : "Notify law enforcement",
    "optional" : true,
    "phase_id" : "Respond",
    "programmatic_name" : "notify_law_enforcement",
    "tags" : [ ],
    "task_layout" : [ ],
    "uuid" : "6fb8cdcb-ce5b-44fa-bbc8-b7d19899ae60"
  }, {
    "associated_actions" : null,
    "category_id" : null,
    "date_source_handle" : "incident.discovered_date",
    "deleted" : false,
    "due_date_offset" : 0,
    "due_date_units" : null,
    "enabled" : true,
    "export_key" : "notify_legal_counsel_of_any_illegal_or_inappropriate_activity",
    "form" : null,
    "id" : 0,
    "instructions" : "If any illegal activity or inappropriate involvement by internal employees or contractors is suspected, legal counsel may require that particular evidence be captured or other actions be taken.",
    "name" : "Notify legal counsel of any illegal or inappropriate activity",
    "optional" : false,
    "phase_id" : "Respond",
    "programmatic_name" : "notify_legal_counsel_of_any_illegal_or_inappropriate_activity",
    "tags" : [ ],
    "task_layout" : [ ],
    "uuid" : "27104944-0c7d-407c-bdfe-d80bc1270d59"
  }, {
    "associated_actions" : null,
    "category_id" : null,
    "date_source_handle" : "incident.discovered_date",
    "deleted" : false,
    "due_date_offset" : 0,
    "due_date_units" : null,
    "enabled" : true,
    "export_key" : "notify_public_relations_department",
    "form" : null,
    "id" : 0,
    "instructions" : "Notify the public/media relations department if there is a risk of negative PR or customer dissatisfaction as a result of this incident.",
    "name" : "Notify public relations department",
    "optional" : false,
    "phase_id" : "Respond",
    "programmatic_name" : "notify_public_relations_department",
    "tags" : [ ],
    "task_layout" : [ ],
    "uuid" : "3d4e77fb-5512-4c9b-9b3e-47a188fadc39"
  }, {
    "associated_actions" : null,
    "category_id" : null,
    "date_source_handle" : "incident.discovered_date",
    "deleted" : false,
    "due_date_offset" : 0,
    "due_date_units" : null,
    "enabled" : true,
    "export_key" : "notify_the_owners_of_any_systems_being_used_in_the_phishing_attack",
    "form" : null,
    "id" : 0,
    "instructions" : "Notify the owners of any systems being used or impersonated in the phishing attack. For example, if the attack involves a server masquerading as a bank website, notify the bank involved so they can take steps to help protect their constituents and consider other actions. Because most phishing sites violate both copyright and trademark laws, it usually is proper to reference, in correspondence to the host, the Lanham Act and the Digital Millennium Copyright Act, as well as the statutory language required under the laws.",
    "name" : "Notify the owners of any systems being used in the phishing attack",
    "optional" : false,
    "phase_id" : "Respond",
    "programmatic_name" : "notify_the_owners_of_any_systems_being_used_in_the_phishing_attack",
    "tags" : [ ],
    "task_layout" : [ ],
    "uuid" : "5bfe4544-2891-46ef-96f4-6989532cdcae"
  }, {
    "associated_actions" : null,
    "category_id" : null,
    "date_source_handle" : "incident.discovered_date",
    "deleted" : false,
    "due_date_offset" : 0,
    "due_date_units" : null,
    "enabled" : true,
    "export_key" : "post_incident_review",
    "form" : null,
    "id" : 0,
    "instructions" : "Conduct a meeting discussing and analyzing the root cause and effectiveness of the team's response. Identify areas of improvement and preventative steps, such as policy updates, training, and new IT system recommendations. This activity should be executed shortly after the incident has been resolved. Topics include:<br />\n<ul>\n<li>Exactly what happened, and at what times? </li>\n<li>How well did the staff and management perform in dealing with the incident? Were the documented procedures followed? Were they adequate? </li>\n<li>What information was needed sooner? </li>\n<li>Were any steps or actions taken that might have inhibited the recovery? </li>\n<li>What would the staff and management do differently the next time a similar incident occurs? </li>\n<li>How could information sharing with other organizations have been improved? </li>\n<li>What corrective actions can prevent similar incidents in the future? </li>\n<li>What additional tools or resources are needed to detect, analyze, and mitigate future incidents? </li>\n<li>Are policy changes appropriate?</li>\n<li>Is additional end-user training appropriate?</li>\n<li>Is additional defensive software or reconfiguration appropriate?</li>\n</ul>",
    "name" : "Post-incident review",
    "optional" : false,
    "phase_id" : "Post-Incident",
    "programmatic_name" : "post_incident_review",
    "tags" : [ ],
    "task_layout" : [ ],
    "uuid" : "1ddec417-2afa-49ae-9b3d-c4a000d1e96a"
  }, {
    "associated_actions" : null,
    "category_id" : null,
    "date_source_handle" : "incident.discovered_date",
    "deleted" : false,
    "due_date_offset" : 0,
    "due_date_units" : null,
    "enabled" : true,
    "export_key" : "properly_dispose_of_incident_information",
    "form" : null,
    "id" : 0,
    "instructions" : "Any sensitive information, such as account credentials, confidential documents or data, or personally identifiable or personal health information, which was collected as a result of analyzing and responding to the incident, must be properly disposed of once no longer needed.",
    "name" : "Properly dispose of incident information",
    "optional" : false,
    "phase_id" : "Post-Incident",
    "programmatic_name" : "properly_dispose_of_incident_information",
    "tags" : [ ],
    "task_layout" : [ ],
    "uuid" : "2edd936a-86a5-47af-b592-ae6a0f611232"
  }, {
    "associated_actions" : null,
    "category_id" : null,
    "date_source_handle" : "incident.discovered_date",
    "deleted" : false,
    "due_date_offset" : 0,
    "due_date_units" : null,
    "enabled" : true,
    "export_key" : "provide_end_user_remediation_guidance_for_phishing_and_identify_theft",
    "form" : null,
    "id" : 0,
    "instructions" : "Establish and communicate procedures to users who believe they have already fallen victim to the phishing attack. Items to consider include changing passwords, establishing credit monitoring, and reviewing financial records for suspicious activities. Affected consumers should review and follow instructions provided by the FTC at: http://www.consumer.gov/articles/1016-recovering-identity-theft",
    "name" : "Provide end-user remediation guidance for phishing and identify theft",
    "optional" : false,
    "phase_id" : "Respond",
    "programmatic_name" : "provide_end_user_remediation_guidance_for_phishing_and_identify_theft",
    "tags" : [ ],
    "task_layout" : [ ],
    "uuid" : "65e31859-158d-4c78-9d84-589904c14994"
  }, {
    "associated_actions" : null,
    "category_id" : null,
    "date_source_handle" : "incident.discovered_date",
    "deleted" : false,
    "due_date_offset" : 0,
    "due_date_units" : null,
    "enabled" : true,
    "export_key" : "quantify_the_dos_attack_and_traffic",
    "form" : null,
    "id" : 0,
    "instructions" : "Determine the point of attack or failure. Is the problem associated with upstream network equipment or routing issues, or is the attack targeting an endpoint system such as a web server or a machine hosting a specific application? <br /><br />\n\nQuantify the DoS network traffic using a network analyzer or packet sniffer, such as tcpdump -w, tcpdstat, or tcptrace. Look for large volumes of a particular packet type in the traffic (TCP, UDP, ICMP). Compare the network traffic to baseline data collected prior to the attack. Try to determine how the DoS traffic can be differentiated from other normal traffic; for example, specific source IPs, destination ports, URLs, TCP flags, and DNS floods. Try to understand the flow of the DoS attack and understand the infrastructure components affected. Consider if the attack is targeting particular functionality or resources; for example, computationally expensive components such as report or pdf generation.<br /><br />\n\nInclude suspicious IP addresses or URLs as incident artifacts on the Artifacts tab. The system will correlate this information against several threat intelligence source and provide feedback.<br /><br />\nResources: <br />\nUS CERT DDoS Quick Guide - http://www.us-cert.gov/sites/default/files/publications/DDoS%20Quick%20Guide.pdf",
    "name" : "Quantify the DoS attack and traffic",
    "optional" : false,
    "phase_id" : "Detect/Analyze",
    "programmatic_name" : "quantify_the_dos_attack_and_traffic",
    "tags" : [ ],
    "task_layout" : [ ],
    "uuid" : "8afc8d86-1f2f-4d2d-820c-c6e0ac9f5226"
  }, {
    "associated_actions" : null,
    "category_id" : null,
    "date_source_handle" : "incident.discovered_date",
    "deleted" : false,
    "due_date_offset" : 0,
    "due_date_units" : null,
    "enabled" : true,
    "export_key" : "recover_affected_systems",
    "form" : null,
    "id" : 0,
    "instructions" : "<p>Create and assign specific tasks for recovering each affected system. Depending on the severity of the intrusion, consider reformatting disks and reimaging systems from a trusted source. Apply all applicable OS and application patches.</p>\n\n<p>Test and qualify any major systems that were rebuilt as part of the eradication process or that underwent major changes. The organization should have automated tests in place for rapid and thorough qualification of critical systems. Return the recovered systems into production once fully qualified. </p>",
    "name" : "Recover affected systems",
    "optional" : false,
    "phase_id" : "Respond",
    "programmatic_name" : "recover_affected_systems",
    "tags" : [ ],
    "task_layout" : [ ],
    "uuid" : "461d4694-da30-4141-9127-31ebba1417a0"
  }, {
    "associated_actions" : null,
    "category_id" : null,
    "date_source_handle" : "incident.discovered_date",
    "deleted" : false,
    "due_date_offset" : 0,
    "due_date_units" : null,
    "enabled" : true,
    "export_key" : "recover_each_malware_infected_system",
    "form" : null,
    "id" : 0,
    "instructions" : "If there is indication or a possibility that a rootkit was installed on a given system then take necessary backups, reformat the drive and rebuild it from a trusted source. Ensure all patches, AV and IPS software are installed before reconnecting to the network.",
    "name" : "Recover each malware-infected system",
    "optional" : false,
    "phase_id" : "Respond",
    "programmatic_name" : "recover_each_malware_infected_system",
    "tags" : [ ],
    "task_layout" : [ ],
    "uuid" : "f362737f-2bbf-41ab-9897-8c1c1a69eb65"
  }, {
    "associated_actions" : null,
    "category_id" : null,
    "date_source_handle" : "incident.discovered_date",
    "deleted" : false,
    "due_date_offset" : 0,
    "due_date_units" : null,
    "enabled" : true,
    "export_key" : "remote_wipelock",
    "form" : null,
    "id" : 0,
    "instructions" : "If the device or your email server, such as Exchange, provides the ability, execute a remote lock or wipe of the device to remove all device and company data.",
    "name" : "Remote wipe/lock",
    "optional" : false,
    "phase_id" : "Respond",
    "programmatic_name" : "remote_wipelock",
    "tags" : [ ],
    "task_layout" : [ ],
    "uuid" : "56bcdcf3-3ca7-4c8f-a673-301e8a1193e4"
  }, {
    "associated_actions" : null,
    "category_id" : null,
    "date_source_handle" : "incident.discovered_date",
    "deleted" : false,
    "due_date_offset" : 0,
    "due_date_units" : null,
    "enabled" : true,
    "export_key" : "remove_temporary_containment_measures",
    "form" : null,
    "id" : 0,
    "instructions" : "Containment measures should be maintained until most infected or vulnerable systems have been patched or until you are confident that releasing the containment measures will not expose you to another attack.",
    "name" : "Remove temporary containment measures",
    "optional" : false,
    "phase_id" : "Respond",
    "programmatic_name" : "remove_temporary_containment_measures",
    "tags" : [ ],
    "task_layout" : [ ],
    "uuid" : "c6b7f90e-969c-4259-992c-2f2bfbc2420f"
  }, {
    "associated_actions" : null,
    "category_id" : null,
    "date_source_handle" : "incident.discovered_date",
    "deleted" : false,
    "due_date_offset" : 0,
    "due_date_units" : null,
    "enabled" : true,
    "export_key" : "report_suspicious_activity_to_the_ftc",
    "form" : null,
    "id" : 0,
    "instructions" : "Report suspicious activity to the FTC.  Send actual phishing emails to spam@uce.gov. If you believe constituents have been defrauded, they should file a complaint at http://www.ftc.gov, and then visit the FTC's Identity Theft website at http://www.ftc.gov/idtheft to learn how to minimize the financial damage from identity theft.",
    "name" : "Report suspicious activity to the FTC",
    "optional" : false,
    "phase_id" : "Respond",
    "programmatic_name" : "report_suspicious_activity_to_the_ftc",
    "tags" : [ ],
    "task_layout" : [ ],
    "uuid" : "8f9d25d1-b7e1-457b-a3f4-b4abdb901229"
  }, {
    "associated_actions" : null,
    "category_id" : null,
    "date_source_handle" : "incident.discovered_date",
    "deleted" : false,
    "due_date_offset" : 0,
    "due_date_units" : null,
    "enabled" : true,
    "export_key" : "research_av_vendor_databases",
    "form" : null,
    "id" : 0,
    "instructions" : "Research AV vendor databases for recent outbreaks, symptoms and remediation guidance based on observed symptoms and findings. Possible source for intelligence include the following.\n<ul>\n<li>Kaspersky: http://www.securelist.com/en/threats/detect </li>\n<li>Microsoft: http://www.microsoft.com/security/portal/threat/threats.aspx </li>\n<li>Symantec:  http://www.symantec.com/security_response/landing/azlisting.jsp</li>\n<li>Trend Micro: http://about-threats.trendmicro.com/us/threatencyclopedia#malware </li>\n</ul>",
    "name" : "Research AV vendor databases",
    "optional" : false,
    "phase_id" : "Detect/Analyze",
    "programmatic_name" : "research_av_vendor_databases",
    "tags" : [ ],
    "task_layout" : [ ],
    "uuid" : "d374567f-f363-431a-8d42-69aa8adb3c4a"
  }, {
    "associated_actions" : null,
    "category_id" : null,
    "date_source_handle" : "incident.discovered_date",
    "deleted" : false,
    "due_date_offset" : 0,
    "due_date_units" : null,
    "enabled" : true,
    "export_key" : "research_current_attack_intelligence_and_recent_vulnerabilities",
    "form" : null,
    "id" : 0,
    "instructions" : "Research current cyber threat intelligence and recently published vulnerability alerts to help focus your analysis. Sources include the US-CERT National Cyber Awareness System accessible at https://www.us-cert.gov/ncas, the CERT vulnerability database at http://www.kb.cert.org/vuls/ or the NIST National Vulnerability Database at http://nvd.nist.gov/",
    "name" : "Research current attack intelligence and recent vulnerabilities",
    "optional" : false,
    "phase_id" : "Detect/Analyze",
    "programmatic_name" : "research_current_attack_intelligence_and_recent_vulnerabilities",
    "tags" : [ ],
    "task_layout" : [ ],
    "uuid" : "7455332e-5c0f-40cf-ab1d-b3de9862d84d"
  }, {
    "associated_actions" : null,
    "category_id" : null,
    "date_source_handle" : "incident.discovered_date",
    "deleted" : false,
    "due_date_offset" : 0,
    "due_date_units" : null,
    "enabled" : true,
    "export_key" : "review_and_respond_to_contractual_obligations_related_to_intrusion_or_loss_of_service",
    "form" : null,
    "id" : 0,
    "instructions" : "Review any contractual obligations related to system intrusion or loss of service which may be triggered by this incident, and take action accordingly.",
    "name" : "Review and respond to contractual obligations related to intrusion or loss of service",
    "optional" : false,
    "phase_id" : "Respond",
    "programmatic_name" : "review_and_respond_to_contractual_obligations_related_to_intrusion_or_loss_of_service",
    "tags" : [ ],
    "task_layout" : [ ],
    "uuid" : "cf40eb97-373b-4bfc-932a-6ce0f974c9f0"
  }, {
    "associated_actions" : null,
    "category_id" : null,
    "date_source_handle" : "incident.discovered_date",
    "deleted" : false,
    "due_date_offset" : 0,
    "due_date_units" : null,
    "enabled" : true,
    "export_key" : "review_os_and_application_logs",
    "form" : null,
    "id" : 0,
    "instructions" : "Review the OS and application logs of servers and systems affected by the attack or in the path of the attack. Look for specific aspects of the traffic that can be useful in blocking or redirecting it.",
    "name" : "Review OS and application logs",
    "optional" : false,
    "phase_id" : "Detect/Analyze",
    "programmatic_name" : "review_os_and_application_logs",
    "tags" : [ ],
    "task_layout" : [ ],
    "uuid" : "20c9ffd2-1183-4202-9c27-261d1c935fdc"
  }, {
    "associated_actions" : null,
    "category_id" : null,
    "date_source_handle" : "incident.discovered_date",
    "deleted" : false,
    "due_date_offset" : 0,
    "due_date_units" : null,
    "enabled" : true,
    "export_key" : "review_the_output_and_status_of_anti_virus_software",
    "form" : null,
    "id" : 0,
    "instructions" : "Review the output and status of anti-virus software, IPS and IDS systems, firewall and router logs (blocked connection attempts), email servers (suspicious attachment names), and network forensic tools. Use symptoms to determine the type and scope of the outbreak (refer to NIST 800-83, Guide to Malware Incident Prevention and Handling, table 4-2, http://csrc.nist.gov/publications/nistpubs/800-83/SP800-83.pdf). Try to identify the first system infected and what the attack vector was. Try to determine if infected systems successfully connected to an external site and what information, if any, was exposed.",
    "name" : "Review the output and status of anti-virus software",
    "optional" : false,
    "phase_id" : "Detect/Analyze",
    "programmatic_name" : "review_the_output_and_status_of_anti_virus_software",
    "tags" : [ ],
    "task_layout" : [ ],
    "uuid" : "db93c9f7-0149-47cf-b2f8-ece02389d2a3"
  }, {
    "associated_actions" : null,
    "category_id" : null,
    "date_source_handle" : "incident.discovered_date",
    "deleted" : false,
    "due_date_offset" : 0,
    "due_date_units" : null,
    "enabled" : true,
    "export_key" : "sandbox_malware_infected_systems",
    "form" : null,
    "id" : 0,
    "instructions" : "Sandbox infected systems and monitor behavior (e.g. BotNet C&amp;C communication). If you would like guidance on analyzing malware, http://zeltser.com/malware-analysis-toolkit/ offers a guide on building a malware analysis lab. In the case of mobile devices, you can leverage a sandbox and reverse engineering tool such as the Android Reverse Engineering Tool:\nhttps://redmine.honeynet.org/projects/are/wiki",
    "name" : "Sandbox malware-infected systems",
    "optional" : false,
    "phase_id" : "Detect/Analyze",
    "programmatic_name" : "sandbox_malware_infected_systems",
    "tags" : [ ],
    "task_layout" : [ ],
    "uuid" : "ffa16d3e-4e03-47eb-bb29-06f57750b807"
  }, {
    "associated_actions" : null,
    "category_id" : null,
    "date_source_handle" : "incident.discovered_date",
    "deleted" : false,
    "due_date_offset" : 0,
    "due_date_units" : null,
    "enabled" : true,
    "export_key" : "select_initial_containment_strategy",
    "form" : null,
    "id" : 0,
    "instructions" : "Select, document and implement an initial containment strategy for each affected system based on the current understanding of the issue (for example, disconnecting network cables, unplugging power, increasing physical security measures, and gracefully shutting down a host). This decision should be based on existing policies and procedures regarding incident containment, as well as the team's assessment of the risk posed by the incident, so that the chosen containment strategy or combination of strategies sufficiently mitigates risk while maintaining the integrity of potential evidence whenever possible. Add adhoc tasks to the response plan to describe details and assign accountability.",
    "name" : "Select initial containment strategy",
    "optional" : false,
    "phase_id" : "Detect/Analyze",
    "programmatic_name" : "select_initial_containment_strategy",
    "tags" : [ ],
    "task_layout" : [ ],
    "uuid" : "6220ee1c-9b90-4ddd-b09b-0df6a0542ad1"
  }, {
    "associated_actions" : null,
    "category_id" : null,
    "date_source_handle" : "incident.discovered_date",
    "deleted" : false,
    "due_date_offset" : 0,
    "due_date_units" : null,
    "enabled" : true,
    "export_key" : "switch_to_alternate_sites_or_networks",
    "form" : null,
    "id" : 0,
    "instructions" : "If possible, switch to alternate sites or networks using DNS or another mechanism, and blackhole DoS traffic targeting the original IPs. Or, if possible, add servers or network bandwidth to handle the DoS load, or try to take advantage of distributed cached distribution networks such as Akamai.",
    "name" : "Switch to alternate sites or networks",
    "optional" : false,
    "phase_id" : "Respond",
    "programmatic_name" : "switch_to_alternate_sites_or_networks",
    "tags" : [ ],
    "task_layout" : [ ],
    "uuid" : "66f85d2b-0cf3-4abf-aa42-0b36dfe185e7"
  }, {
    "associated_actions" : null,
    "category_id" : null,
    "date_source_handle" : "incident.discovered_date",
    "deleted" : false,
    "due_date_offset" : 0,
    "due_date_units" : null,
    "enabled" : true,
    "export_key" : "take_steps_to_limit_propagation_or_execution_of_the_phishing_attacks",
    "form" : null,
    "id" : 0,
    "instructions" : "Take steps to limit propagation. For example, configure mail servers to block phishing emails, and configure firewalls to prevent access to spoofed servers.",
    "name" : "Take steps to limit propagation or execution of the phishing attacks",
    "optional" : false,
    "phase_id" : "Respond",
    "programmatic_name" : "take_steps_to_limit_propagation_or_execution_of_the_phishing_attacks",
    "tags" : [ ],
    "task_layout" : [ ],
    "uuid" : "dcdd05b3-4ad8-4204-acbc-2f5d0ba4fdd0"
  }, {
    "associated_actions" : null,
    "category_id" : null,
    "date_source_handle" : "incident.discovered_date",
    "deleted" : false,
    "due_date_offset" : 0,
    "due_date_units" : null,
    "enabled" : true,
    "export_key" : "terminate_unwanted_dos_connections_or_processes",
    "form" : null,
    "id" : 0,
    "instructions" : "Terminate unwanted connections or processes on servers and routers, and tune their TCP/IP settings. Scripts can sometimes be generated to identify and terminate attack connections. If the bottleneck is a particular feature of an application, consider temporarily disabling that feature.",
    "name" : "Terminate unwanted DoS connections or processes",
    "optional" : false,
    "phase_id" : "Respond",
    "programmatic_name" : "terminate_unwanted_dos_connections_or_processes",
    "tags" : [ ],
    "task_layout" : [ ],
    "uuid" : "4e5a6607-3238-4ad8-a0c3-cf3cb2069da7"
  }, {
    "associated_actions" : null,
    "category_id" : null,
    "date_source_handle" : "incident.discovered_date",
    "deleted" : false,
    "due_date_offset" : 0,
    "due_date_units" : null,
    "enabled" : true,
    "export_key" : "throttle_or_block_dos_traffic",
    "form" : null,
    "id" : 0,
    "instructions" : "Attempt to throttle or block DoS traffic as close to the network's &quot;cloud&quot; as possible via a router, firewall, load balancer, or other specialized device. Throttling can be accomplished using rate limiting for certain types of traffic on routers, or using black hole filtering. However, this may not be feasible if you cannot distinguish valid traffic from attack traffic. If possible, route traffic through a traffic-scrubbing service or product via DNS or routing changes.\n<br /><br />\nReference - http://www.symantec.com/connect/articles/closing-floodgates-ddos-mitigation-techniques",
    "name" : "Throttle or block DoS traffic",
    "optional" : false,
    "phase_id" : "Respond",
    "programmatic_name" : "throttle_or_block_dos_traffic",
    "tags" : [ ],
    "task_layout" : [ ],
    "uuid" : "0671ec70-3186-46ac-88d7-2663d9a0c4b6"
  }, {
    "associated_actions" : null,
    "category_id" : null,
    "date_source_handle" : "incident.discovered_date",
    "deleted" : false,
    "due_date_offset" : 0,
    "due_date_units" : null,
    "enabled" : true,
    "export_key" : "update_internal_management_team_as_appropriate_assessment",
    "form" : null,
    "id" : 0,
    "instructions" : "Provide and update the internal management chain regarding the results of the analysis. Include details regarding the nature and scope of the incident as you understand it, the likelihood that confidential or personal information was exposed, and any other major impact. Outline the proposed recovery plan and estimated timeline.",
    "name" : "Update internal management team as appropriate (assessment)",
    "optional" : false,
    "phase_id" : "Detect/Analyze",
    "programmatic_name" : "update_internal_management_team_as_appropriate_assessment",
    "tags" : [ ],
    "task_layout" : [ ],
    "uuid" : "7cfccfc4-4e93-456f-9a2f-ed4c31834cec"
  }, {
    "associated_actions" : null,
    "category_id" : null,
    "date_source_handle" : "incident.discovered_date",
    "deleted" : false,
    "due_date_offset" : 0,
    "due_date_units" : null,
    "enabled" : true,
    "export_key" : "update_policies_and_procedures",
    "form" : null,
    "id" : 0,
    "instructions" : "If changes are appropriate to prevent recurrence of this type of incident, update all the appropriate internal policies and procedures to reflect the changes.  Changes should be clearly documented and communicated to employees, and additional training should be provided as appropriate.",
    "name" : "Update policies and procedures",
    "optional" : false,
    "phase_id" : "Post-Incident",
    "programmatic_name" : "update_policies_and_procedures",
    "tags" : [ ],
    "task_layout" : [ ],
    "uuid" : "b709b36c-15e4-4f4e-93bb-2a7b094e587f"
  } ],
  "export_date" : 1644407392612,
  "export_format_version" : 2,
  "export_type" : "ORG",
  "fields" : [ {
    "allow_default_value" : false,
    "blank_option" : false,
    "calculated" : false,
    "changeable" : true,
    "chosen" : false,
    "default_chosen_by_server" : false,
    "deprecated" : false,
    "export_key" : "__function/mock_input_text_with_value_string",
    "hide_notification" : false,
    "id" : 276,
    "input_type" : "textarea",
    "internal" : false,
    "is_tracked" : false,
    "name" : "mock_input_text_with_value_string",
    "operation_perms" : { },
    "operations" : [ ],
    "placeholder" : "",
    "prefix" : null,
    "read_only" : false,
    "rich_text" : false,
    "tags" : [ {
      "tag_handle" : "fn_main_mock_integration",
      "value" : null
    } ],
    "templates" : [ {
      "id" : 1,
      "name" : "display_value_one",
      "template" : {
        "format" : "text",
        "content" : "data value one  ล ฦ ว ศ ษ ส ห ฬ อ"
      },
      "uuid" : "7b2ca17d-c591-4454-a0b8-5b65b97a441f"
    }, {
      "id" : 2,
      "name" : "display_value_two",
      "template" : {
        "format" : "text",
        "content" : "data value two  ล ฦ ว ศ ษ ส ห ฬ อ"
      },
      "uuid" : "250a905e-e620-4e25-b2b8-77d123a1f21c"
    } ],
    "text" : "mock_input_text_with_value_string",
    "tooltip" : "a mock tooltip  ล ฦ ว ศ ษ ส ห ฬ อ",
    "type_id" : 11,
    "uuid" : "866625eb-8b46-4cc9-b713-cdfa548a1189",
    "values" : [ ]
  }, {
    "allow_default_value" : false,
    "blank_option" : false,
    "calculated" : false,
    "changeable" : true,
    "chosen" : false,
    "default_chosen_by_server" : false,
    "deprecated" : false,
    "export_key" : "__function/mock_input_date_time_picker",
    "hide_notification" : false,
    "id" : 277,
    "input_type" : "datetimepicker",
    "internal" : false,
    "is_tracked" : false,
    "name" : "mock_input_date_time_picker",
    "operation_perms" : { },
    "operations" : [ ],
    "placeholder" : "",
    "prefix" : null,
    "read_only" : false,
    "rich_text" : false,
    "tags" : [ {
      "tag_handle" : "fn_main_mock_integration",
      "value" : null
    } ],
    "templates" : [ ],
    "text" : "mock_input_date_time_picker",
    "tooltip" : "a mock tooltip  ล ฦ ว ศ ษ ส ห ฬ อ",
    "type_id" : 11,
    "uuid" : "92eb3b7a-8859-4846-81a3-2995aec74bdb",
    "values" : [ ]
  }, {
    "allow_default_value" : false,
    "blank_option" : false,
    "calculated" : false,
    "changeable" : true,
    "chosen" : false,
    "default_chosen_by_server" : false,
    "deprecated" : false,
    "export_key" : "__function/mock_input_select",
    "hide_notification" : false,
    "id" : 278,
    "input_type" : "select",
    "internal" : false,
    "is_tracked" : false,
    "name" : "mock_input_select",
    "operation_perms" : { },
    "operations" : [ ],
    "placeholder" : "",
    "prefix" : null,
    "read_only" : false,
    "rich_text" : false,
    "tags" : [ {
      "tag_handle" : "fn_main_mock_integration",
      "value" : null
    } ],
    "templates" : [ ],
    "text" : "mock_input_select",
    "tooltip" : "mock tooltip  ล ฦ ว ศ ษ ส ห ฬ อ",
    "type_id" : 11,
    "uuid" : "b6dfde6d-7516-4509-a5a2-54e72df9e0cd",
    "values" : [ {
      "default" : true,
      "enabled" : true,
      "hidden" : false,
      "label" : "select one",
      "properties" : null,
      "uuid" : "0a30d6ad-914a-47b1-83bf-c5667dbee974",
      "value" : 52
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "select two",
      "properties" : null,
      "uuid" : "7522822e-67bc-478e-b91d-7116b14ce2a5",
      "value" : 53
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "select  ล ฦ ว ศ ษ ส ห ฬ อ",
      "properties" : null,
      "uuid" : "9f40a2b2-2318-4d73-8e48-4a447c70890c",
      "value" : 54
    } ]
  }, {
    "allow_default_value" : false,
    "blank_option" : false,
    "calculated" : false,
    "changeable" : true,
    "chosen" : false,
    "default_chosen_by_server" : false,
    "deprecated" : false,
    "export_key" : "__function/mock_input_boolean",
    "hide_notification" : false,
    "id" : 279,
    "input_type" : "boolean",
    "internal" : false,
    "is_tracked" : false,
    "name" : "mock_input_boolean",
    "operation_perms" : { },
    "operations" : [ ],
    "placeholder" : "",
    "prefix" : null,
    "read_only" : false,
    "rich_text" : false,
    "tags" : [ {
      "tag_handle" : "fn_main_mock_integration",
      "value" : null
    } ],
    "templates" : [ ],
    "text" : "mock_input_boolean",
    "tooltip" : "a mock tooltip  ล ฦ ว ศ ษ ส ห ฬ อ",
    "type_id" : 11,
    "uuid" : "df7df8ba-cb65-4400-8290-070b155d28d4",
    "values" : [ ]
  }, {
    "allow_default_value" : false,
    "blank_option" : false,
    "calculated" : false,
    "changeable" : true,
    "chosen" : false,
    "default_chosen_by_server" : false,
    "deprecated" : false,
    "export_key" : "__function/mock_input_text",
    "hide_notification" : false,
    "id" : 280,
    "input_type" : "text",
    "internal" : false,
    "is_tracked" : false,
    "name" : "mock_input_text",
    "operation_perms" : { },
    "operations" : [ ],
    "placeholder" : "",
    "prefix" : null,
    "read_only" : false,
    "rich_text" : false,
    "tags" : [ {
      "tag_handle" : "fn_main_mock_integration",
      "value" : null
    } ],
    "templates" : [ ],
    "text" : "mock_input_text",
    "tooltip" : "a mock tooltip  ล ฦ ว ศ ษ ส ห ฬ อ",
    "type_id" : 11,
    "uuid" : "e40b9d9e-7ca1-45bc-913b-ce2a77e9b687",
    "values" : [ ]
  }, {
    "allow_default_value" : false,
    "blank_option" : false,
    "calculated" : false,
    "changeable" : true,
    "chosen" : false,
    "default_chosen_by_server" : false,
    "deprecated" : false,
    "export_key" : "__function/mock_input_date_picker",
    "hide_notification" : false,
    "id" : 281,
    "input_type" : "datepicker",
    "internal" : false,
    "is_tracked" : false,
    "name" : "mock_input_date_picker",
    "operation_perms" : { },
    "operations" : [ ],
    "placeholder" : "",
    "prefix" : null,
    "read_only" : false,
    "rich_text" : false,
    "tags" : [ {
      "tag_handle" : "fn_main_mock_integration",
      "value" : null
    } ],
    "templates" : [ ],
    "text" : "mock_input_date_picker",
    "tooltip" : "a mock tooltip ล ฦ ว ศ ษ ส ห ฬ อ",
    "type_id" : 11,
    "uuid" : "01147ebf-ce3d-4cfb-814b-16145af4e511",
    "values" : [ ]
  }, {
    "allow_default_value" : false,
    "blank_option" : false,
    "calculated" : false,
    "changeable" : true,
    "chosen" : false,
    "default_chosen_by_server" : false,
    "deprecated" : false,
    "export_key" : "__function/mock_input_number",
    "hide_notification" : false,
    "id" : 282,
    "input_type" : "number",
    "internal" : false,
    "is_tracked" : false,
    "name" : "mock_input_number",
    "operation_perms" : { },
    "operations" : [ ],
    "placeholder" : "",
    "prefix" : null,
    "read_only" : false,
    "required" : "always",
    "rich_text" : false,
    "tags" : [ {
      "tag_handle" : "fn_main_mock_integration",
      "value" : null
    } ],
    "templates" : [ ],
    "text" : "mock_input_number",
    "tooltip" : "a mock tooltip  ล ฦ ว ศ ษ ส ห ฬ อ",
    "type_id" : 11,
    "uuid" : "49f10172-309a-4829-a5fe-1de71cdb4efb",
    "values" : [ ]
  }, {
    "allow_default_value" : false,
    "blank_option" : false,
    "calculated" : false,
    "changeable" : true,
    "chosen" : false,
    "default_chosen_by_server" : false,
    "deprecated" : false,
    "export_key" : "__function/mock_input_multiselect",
    "hide_notification" : false,
    "id" : 283,
    "input_type" : "multiselect",
    "internal" : false,
    "is_tracked" : false,
    "name" : "mock_input_multiselect",
    "operation_perms" : { },
    "operations" : [ ],
    "placeholder" : "",
    "prefix" : null,
    "read_only" : false,
    "rich_text" : false,
    "tags" : [ {
      "tag_handle" : "fn_main_mock_integration",
      "value" : null
    } ],
    "templates" : [ ],
    "text" : "mock_input_multiselect",
    "tooltip" : "a mock input tooltip  ล ฦ ว ศ ษ ส ห ฬ อ",
    "type_id" : 11,
    "uuid" : "69dc0e78-a74b-4ccc-8d82-33b51780a569",
    "values" : [ {
      "default" : true,
      "enabled" : true,
      "hidden" : false,
      "label" : "value one",
      "properties" : null,
      "uuid" : "8b8b22d4-b20c-4d10-abac-a65211a5b9cd",
      "value" : 55
    }, {
      "default" : true,
      "enabled" : true,
      "hidden" : false,
      "label" : "value two",
      "properties" : null,
      "uuid" : "bf8e34a8-79aa-4ec4-b4c9-b8f1f0f7135e",
      "value" : 56
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "value  ล ฦ ว ศ ษ ส ห ฬ อ",
      "properties" : null,
      "uuid" : "c0e1c417-00b8-4146-8ca9-248215be0efa",
      "value" : 57
    } ]
  }, {
    "allow_default_value" : false,
    "blank_option" : false,
    "calculated" : false,
    "changeable" : true,
    "chosen" : false,
    "default_chosen_by_server" : false,
    "deprecated" : false,
    "export_key" : "incident/start_date",
    "hide_notification" : true,
    "id" : 61,
    "input_type" : "datetimepicker",
    "internal" : false,
    "is_tracked" : false,
    "name" : "start_date",
    "operation_perms" : { },
    "operations" : [ ],
    "prefix" : null,
    "read_only" : false,
    "rich_text" : false,
    "tags" : [ ],
    "templates" : [ ],
    "text" : "Date Occurred",
    "tooltip" : "Date the incident occurred",
    "type_id" : 0,
    "uuid" : "90f5a419-e126-48db-888c-80fe09444cfe",
    "values" : [ ]
  }, {
    "allow_default_value" : false,
    "blank_option" : false,
    "calculated" : false,
    "changeable" : true,
    "chosen" : true,
    "default_chosen_by_server" : false,
    "deprecated" : false,
    "export_key" : "incident/creator_id",
    "hide_notification" : false,
    "id" : 68,
    "input_type" : "select_owner",
    "internal" : false,
    "is_tracked" : false,
    "name" : "creator_id",
    "operation_perms" : { },
    "operations" : [ ],
    "prefix" : null,
    "read_only" : true,
    "rich_text" : false,
    "tags" : [ ],
    "templates" : [ ],
    "text" : "Created By",
    "type_id" : 0,
    "uuid" : "91f2b232-bb43-4007-ab91-aacfd02d9e7a",
    "values" : [ ]
  }, {
    "allow_default_value" : false,
    "blank_option" : false,
    "calculated" : false,
    "changeable" : true,
    "chosen" : false,
    "default_chosen_by_server" : false,
    "deprecated" : false,
    "export_key" : "incident/reporter",
    "hide_notification" : false,
    "id" : 10,
    "input_type" : "text",
    "internal" : false,
    "is_tracked" : false,
    "name" : "reporter",
    "operation_perms" : { },
    "operations" : [ ],
    "placeholder" : "Employee name",
    "prefix" : null,
    "read_only" : false,
    "rich_text" : false,
    "tags" : [ ],
    "templates" : [ ],
    "text" : "Reporting Individual",
    "tooltip" : "Name of person who reported the event, such as a device owner or his/her manager",
    "type_id" : 0,
    "uuid" : "931afc2e-e09d-48e1-8b71-c1cc50e1eba6",
    "values" : [ ]
  }, {
    "allow_default_value" : false,
    "blank_option" : false,
    "calculated" : false,
    "changeable" : true,
    "chosen" : false,
    "default_chosen_by_server" : false,
    "deprecated" : false,
    "export_key" : "incident/negative_pr_likely",
    "hide_notification" : false,
    "id" : 57,
    "input_type" : "boolean",
    "internal" : false,
    "is_tracked" : false,
    "name" : "negative_pr_likely",
    "operation_perms" : { },
    "operations" : [ ],
    "prefix" : null,
    "read_only" : false,
    "rich_text" : false,
    "tags" : [ ],
    "templates" : [ ],
    "text" : "Negative PR",
    "tooltip" : "If it is foreseeable that the incident might generate any negative public image or publicity for your company or organization.",
    "type_id" : 0,
    "uuid" : "94dbbd0e-3c82-4650-bd17-bddb3003a7e6",
    "values" : [ ]
  }, {
    "allow_default_value" : false,
    "blank_option" : false,
    "calculated" : false,
    "changeable" : true,
    "chosen" : false,
    "default_chosen_by_server" : false,
    "deprecated" : false,
    "export_key" : "incident/addr",
    "hide_notification" : false,
    "id" : 6,
    "input_type" : "text",
    "internal" : false,
    "is_tracked" : false,
    "name" : "addr",
    "operation_perms" : { },
    "operations" : [ ],
    "prefix" : null,
    "read_only" : false,
    "rich_text" : false,
    "tags" : [ ],
    "templates" : [ ],
    "text" : "Address",
    "tooltip" : "Physical location of the incident, if applicable",
    "type_id" : 0,
    "uuid" : "9540d9b0-2cd9-4347-b013-a1c84b6605b7",
    "values" : [ ]
  }, {
    "allow_default_value" : false,
    "blank_option" : false,
    "calculated" : false,
    "changeable" : true,
    "chosen" : true,
    "default_chosen_by_server" : false,
    "deprecated" : false,
    "export_key" : "incident/owner_id",
    "hide_notification" : false,
    "id" : 58,
    "input_type" : "select_owner",
    "internal" : false,
    "is_tracked" : true,
    "name" : "owner_id",
    "operation_perms" : { },
    "operations" : [ ],
    "prefix" : null,
    "read_only" : false,
    "rich_text" : false,
    "tags" : [ ],
    "templates" : [ ],
    "text" : "Owner",
    "type_id" : 0,
    "uuid" : "97d1d2a1-d25e-4279-9d29-7bc60fd321ce",
    "values" : [ ]
  }, {
    "allow_default_value" : false,
    "blank_option" : false,
    "calculated" : false,
    "changeable" : true,
    "chosen" : false,
    "default_chosen_by_server" : false,
    "deprecated" : false,
    "export_key" : "incident/crimestatus_id",
    "hide_notification" : false,
    "id" : 60,
    "input_type" : "select",
    "internal" : false,
    "is_tracked" : false,
    "name" : "crimestatus_id",
    "operation_perms" : { },
    "operations" : [ ],
    "prefix" : null,
    "read_only" : false,
    "rich_text" : false,
    "tags" : [ ],
    "templates" : [ ],
    "text" : "Criminal Activity",
    "type_id" : 0,
    "uuid" : "994180bf-ee21-488e-9b99-3a3159642851",
    "values" : [ ]
  }, {
    "allow_default_value" : false,
    "blank_option" : false,
    "calculated" : false,
    "changeable" : true,
    "chosen" : false,
    "default_chosen_by_server" : false,
    "deprecated" : false,
    "export_key" : "incident/confirmed",
    "hide_notification" : false,
    "id" : 14,
    "input_type" : "boolean",
    "internal" : false,
    "is_tracked" : false,
    "label_false" : "Unconfirmed",
    "label_true" : "Confirmed",
    "name" : "confirmed",
    "operation_perms" : { },
    "operations" : [ ],
    "prefix" : null,
    "read_only" : false,
    "rich_text" : false,
    "tags" : [ ],
    "templates" : [ ],
    "text" : "Incident Disposition",
    "tooltip" : "Tag an issue as an unconfirmed (event) vs. a confirmed incident.",
    "type_id" : 0,
    "uuid" : "9b531f7c-d112-4444-8a91-9ea2d5e47162",
    "values" : [ ]
  }, {
    "allow_default_value" : false,
    "blank_option" : false,
    "calculated" : true,
    "changeable" : true,
    "chosen" : false,
    "default_chosen_by_server" : false,
    "deprecated" : false,
    "export_key" : "incident/inc_last_modified_date",
    "hide_notification" : true,
    "id" : 52,
    "input_type" : "datetimepicker",
    "internal" : false,
    "is_tracked" : false,
    "name" : "inc_last_modified_date",
    "operation_perms" : { },
    "operations" : [ ],
    "prefix" : null,
    "read_only" : true,
    "rich_text" : false,
    "tags" : [ ],
    "templates" : [ ],
    "text" : "Last Modified",
    "tooltip" : "The date the incident was last modified.This field is read only.",
    "type_id" : 0,
    "uuid" : "a75e8d1d-d940-4c8a-82f1-8839ab60d583",
    "values" : [ ]
  }, {
    "allow_default_value" : false,
    "blank_option" : false,
    "calculated" : false,
    "changeable" : true,
    "chosen" : false,
    "default_chosen_by_server" : false,
    "deprecated" : false,
    "export_key" : "incident/dc_impact_likely",
    "hide_notification" : false,
    "id" : 49,
    "input_type" : "boolean",
    "internal" : false,
    "is_tracked" : false,
    "name" : "dc_impact_likely",
    "operation_perms" : { },
    "operations" : [ ],
    "prefix" : "pii",
    "read_only" : false,
    "rich_text" : false,
    "tags" : [ ],
    "templates" : [ ],
    "text" : "Impact Likely for District of Columbia",
    "type_id" : 0,
    "uuid" : "a97ce7c1-a7ec-4efe-822d-e32443392924",
    "values" : [ ]
  }, {
    "allow_default_value" : false,
    "blank_option" : false,
    "calculated" : false,
    "changeable" : true,
    "chosen" : false,
    "default_chosen_by_server" : false,
    "deprecated" : false,
    "export_key" : "incident/determined_date",
    "hide_notification" : true,
    "id" : 51,
    "input_type" : "datetimepicker",
    "internal" : false,
    "is_tracked" : false,
    "name" : "determined_date",
    "operation_perms" : { },
    "operations" : [ ],
    "prefix" : "pii",
    "read_only" : false,
    "rich_text" : false,
    "tags" : [ ],
    "templates" : [ ],
    "text" : "Date Determined",
    "tooltip" : "Date you determined whether or not the incident involved a breach of personal information or personal data. Regulatory task timelines will be derived from this date and time.",
    "type_id" : 0,
    "uuid" : "aa86ae29-5d3c-4c70-8497-93598a9dc959",
    "values" : [ ]
  }, {
    "allow_default_value" : false,
    "blank_option" : false,
    "calculated" : false,
    "changeable" : true,
    "chosen" : false,
    "default_chosen_by_server" : false,
    "deprecated" : false,
    "export_key" : "incident/data_contained",
    "hide_notification" : false,
    "id" : 44,
    "input_type" : "boolean",
    "internal" : false,
    "is_tracked" : false,
    "name" : "data_contained",
    "operation_perms" : { },
    "operations" : [ ],
    "prefix" : "pii",
    "read_only" : false,
    "rich_text" : false,
    "tags" : [ ],
    "templates" : [ ],
    "text" : "Exposure Resolved",
    "tooltip" : "Whether the exposure has been addressed and rectified.",
    "type_id" : 0,
    "uuid" : "ac1398bd-350d-4072-9754-7f8262119ec0",
    "values" : [ ]
  }, {
    "allow_default_value" : false,
    "blank_option" : false,
    "calculated" : false,
    "changeable" : true,
    "chosen" : false,
    "default_chosen_by_server" : false,
    "deprecated" : false,
    "export_key" : "incident/name",
    "hide_notification" : false,
    "id" : 17,
    "input_type" : "text",
    "internal" : false,
    "is_tracked" : false,
    "name" : "name",
    "operation_perms" : { },
    "operations" : [ ],
    "prefix" : null,
    "read_only" : false,
    "required" : "always",
    "rich_text" : false,
    "tags" : [ ],
    "templates" : [ ],
    "text" : "Name",
    "tooltip" : "A unique name to identify this particular incident.",
    "type_id" : 0,
    "uuid" : "ad6ed4f2-8d87-4ba2-81fa-03568a9326cc",
    "values" : [ ]
  }, {
    "allow_default_value" : false,
    "blank_option" : true,
    "calculated" : false,
    "changeable" : true,
    "chosen" : false,
    "default_chosen_by_server" : false,
    "deprecated" : false,
    "export_key" : "incident/data_format",
    "hide_notification" : false,
    "id" : 20,
    "input_type" : "select",
    "internal" : false,
    "is_tracked" : false,
    "name" : "data_format",
    "operation_perms" : { },
    "operations" : [ ],
    "prefix" : "pii",
    "read_only" : false,
    "rich_text" : false,
    "tags" : [ ],
    "templates" : [ ],
    "text" : "Data Format",
    "tooltip" : "Specify the format of the personal information involved.",
    "type_id" : 0,
    "uuid" : "af9cd3c2-ca43-48ab-b37e-e9d7ede15c15",
    "values" : [ ]
  }, {
    "allow_default_value" : false,
    "blank_option" : false,
    "calculated" : false,
    "changeable" : true,
    "chosen" : false,
    "default_chosen_by_server" : false,
    "deprecated" : false,
    "export_key" : "incident/employee_involved",
    "hide_notification" : false,
    "id" : 59,
    "input_type" : "boolean",
    "internal" : false,
    "is_tracked" : false,
    "name" : "employee_involved",
    "operation_perms" : { },
    "operations" : [ ],
    "prefix" : null,
    "read_only" : false,
    "rich_text" : false,
    "tags" : [ ],
    "templates" : [ ],
    "text" : "Employee Involved",
    "type_id" : 0,
    "uuid" : "b37923eb-1ade-48d9-a067-c15a313d3264",
    "values" : [ ]
  }, {
    "allow_default_value" : false,
    "blank_option" : true,
    "calculated" : false,
    "changeable" : true,
    "chosen" : false,
    "default_chosen_by_server" : false,
    "deprecated" : false,
    "export_key" : "incident/pipeda_probability_of_misuse_comment",
    "hide_notification" : false,
    "id" : 23,
    "input_type" : "textarea",
    "internal" : false,
    "is_tracked" : false,
    "name" : "pipeda_probability_of_misuse_comment",
    "operation_perms" : { },
    "operations" : [ ],
    "prefix" : "regulator_risk",
    "read_only" : false,
    "rich_text" : false,
    "tags" : [ ],
    "templates" : [ ],
    "text" : "PIPEDA Probability of Misuse Comment",
    "type_id" : 0,
    "uuid" : "b49e6381-2a11-473e-ac9c-c798805cf039",
    "values" : [ ]
  }, {
    "allow_default_value" : false,
    "blank_option" : false,
    "calculated" : false,
    "changeable" : true,
    "chosen" : false,
    "default_chosen_by_server" : false,
    "deprecated" : false,
    "export_key" : "incident/create_date",
    "hide_notification" : false,
    "id" : 66,
    "input_type" : "datetimepicker",
    "internal" : false,
    "is_tracked" : false,
    "name" : "create_date",
    "operation_perms" : { },
    "operations" : [ ],
    "prefix" : null,
    "read_only" : true,
    "rich_text" : false,
    "tags" : [ ],
    "templates" : [ ],
    "text" : "Date Created",
    "tooltip" : "The date the incident was created. This field is read-only.",
    "type_id" : 0,
    "uuid" : "b4faf728-881a-4e8b-bf0b-d39b720392a1",
    "values" : [ ]
  }, {
    "allow_default_value" : false,
    "blank_option" : false,
    "calculated" : false,
    "changeable" : true,
    "chosen" : false,
    "default_chosen_by_server" : false,
    "deprecated" : false,
    "export_key" : "incident/internal_customizations_field",
    "hide_notification" : false,
    "id" : 273,
    "input_type" : "text",
    "internal" : false,
    "is_tracked" : false,
    "name" : "internal_customizations_field",
    "operation_perms" : { },
    "operations" : [ ],
    "prefix" : "properties",
    "read_only" : false,
    "rich_text" : false,
    "tags" : [ {
      "tag_handle" : "fn_main_mock_integration",
      "value" : null
    } ],
    "templates" : [ ],
    "text" : "Customizations Field (internal)",
    "type_id" : 0,
    "uuid" : "bfeec2d4-3770-11e8-ad39-4a0004044aa1",
    "values" : [ ]
  }, {
    "allow_default_value" : false,
    "blank_option" : false,
    "calculated" : false,
    "changeable" : true,
    "chosen" : false,
    "default_chosen_by_server" : false,
    "deprecated" : false,
    "export_key" : "incident/inc_training",
    "hide_notification" : false,
    "id" : 65,
    "input_type" : "boolean",
    "internal" : false,
    "is_tracked" : false,
    "name" : "inc_training",
    "operation_perms" : { },
    "operations" : [ ],
    "prefix" : null,
    "read_only" : true,
    "rich_text" : false,
    "tags" : [ ],
    "templates" : [ ],
    "text" : "Simulation",
    "tooltip" : "Whether the incident is a simulation or a regular incident. This field is read-only.",
    "type_id" : 0,
    "uuid" : "c3f0e3ed-21e1-4d53-affb-fe5ca3308cca",
    "values" : [ ]
  }, {
    "allow_default_value" : false,
    "blank_option" : true,
    "calculated" : false,
    "changeable" : true,
    "chosen" : false,
    "default_chosen_by_server" : false,
    "deprecated" : false,
    "export_key" : "incident/exposure_vendor_id",
    "hide_notification" : false,
    "id" : 13,
    "input_type" : "select",
    "internal" : false,
    "is_tracked" : false,
    "name" : "exposure_vendor_id",
    "operation_perms" : { },
    "operations" : [ ],
    "prefix" : null,
    "read_only" : false,
    "rich_text" : false,
    "tags" : [ ],
    "templates" : [ ],
    "text" : "Vendor",
    "type_id" : 0,
    "uuid" : "c8f2d2c8-c44b-45c7-b4ff-783a8702b074",
    "values" : [ ]
  }, {
    "allow_default_value" : false,
    "blank_option" : false,
    "calculated" : false,
    "changeable" : true,
    "chosen" : true,
    "default_chosen_by_server" : false,
    "deprecated" : false,
    "export_key" : "incident/members",
    "hide_notification" : false,
    "id" : 43,
    "input_type" : "multiselect_members",
    "internal" : false,
    "is_tracked" : false,
    "name" : "members",
    "operation_perms" : { },
    "operations" : [ ],
    "prefix" : null,
    "read_only" : false,
    "rich_text" : false,
    "tags" : [ ],
    "templates" : [ ],
    "text" : "Members",
    "type_id" : 0,
    "uuid" : "cf473808-ea3b-4e47-833b-3507891bea5e",
    "values" : [ ]
  }, {
    "allow_default_value" : false,
    "blank_option" : true,
    "calculated" : false,
    "changeable" : true,
    "chosen" : false,
    "default_chosen_by_server" : false,
    "deprecated" : false,
    "export_key" : "incident/gdpr_consequences",
    "hide_notification" : false,
    "id" : 36,
    "input_type" : "select",
    "internal" : false,
    "is_tracked" : false,
    "name" : "gdpr_consequences",
    "operation_perms" : { },
    "operations" : [ ],
    "prefix" : "gdpr",
    "read_only" : false,
    "rich_text" : false,
    "tags" : [ ],
    "templates" : [ ],
    "text" : "GDPR Consequences",
    "type_id" : 0,
    "uuid" : "d49ba8aa-3311-49e9-bfc9-440b768f0b19",
    "values" : [ ]
  }, {
    "allow_default_value" : false,
    "blank_option" : true,
    "calculated" : false,
    "changeable" : true,
    "chosen" : false,
    "default_chosen_by_server" : false,
    "deprecated" : false,
    "export_key" : "incident/pipeda_other_factors",
    "hide_notification" : false,
    "id" : 26,
    "input_type" : "select",
    "internal" : false,
    "is_tracked" : false,
    "name" : "pipeda_other_factors",
    "operation_perms" : { },
    "operations" : [ ],
    "prefix" : "regulator_risk",
    "read_only" : false,
    "rich_text" : false,
    "tags" : [ ],
    "templates" : [ ],
    "text" : "PIPEDA Other Factors",
    "type_id" : 0,
    "uuid" : "d74446c8-2c14-4302-a3e0-694b43440f5b",
    "values" : [ ]
  }, {
    "allow_default_value" : false,
    "blank_option" : false,
    "calculated" : false,
    "changeable" : true,
    "chosen" : false,
    "default_chosen_by_server" : false,
    "deprecated" : false,
    "export_key" : "incident/mock_field_text_area",
    "hide_notification" : false,
    "id" : 270,
    "input_type" : "textarea",
    "internal" : false,
    "is_tracked" : false,
    "name" : "mock_field_text_area",
    "operation_perms" : { },
    "operations" : [ ],
    "placeholder" : "",
    "prefix" : "properties",
    "read_only" : false,
    "required" : "close",
    "rich_text" : true,
    "tags" : [ {
      "tag_handle" : "fn_main_mock_integration",
      "value" : null
    } ],
    "templates" : [ ],
    "text" : "Mock: Field Text Area  ล ฦ ว ศ ษ ส ห ฬ อ",
    "tooltip" : "a tooltip  ล ฦ ว ศ ษ ส ห ฬ อ",
    "type_id" : 0,
    "uuid" : "d7cc8d00-1d54-4b3a-af0d-236ef0566751",
    "values" : [ ]
  }, {
    "allow_default_value" : false,
    "blank_option" : true,
    "calculated" : false,
    "changeable" : true,
    "chosen" : false,
    "default_chosen_by_server" : false,
    "deprecated" : false,
    "export_key" : "incident/gdpr_final_assessment",
    "hide_notification" : false,
    "id" : 38,
    "input_type" : "select",
    "internal" : false,
    "is_tracked" : false,
    "name" : "gdpr_final_assessment",
    "operation_perms" : { },
    "operations" : [ ],
    "prefix" : "gdpr",
    "read_only" : false,
    "rich_text" : false,
    "tags" : [ ],
    "templates" : [ ],
    "text" : "GDPR Final Assessment",
    "type_id" : 0,
    "uuid" : "df05d513-b972-4201-8bbb-050ce1db5cb3",
    "values" : [ ]
  }, {
    "allow_default_value" : false,
    "blank_option" : false,
    "calculated" : false,
    "changeable" : true,
    "chosen" : false,
    "default_chosen_by_server" : false,
    "deprecated" : false,
    "export_key" : "incident/zip",
    "hide_notification" : true,
    "id" : 53,
    "input_type" : "text",
    "internal" : false,
    "is_tracked" : false,
    "name" : "zip",
    "operation_perms" : { },
    "operations" : [ ],
    "prefix" : null,
    "read_only" : false,
    "rich_text" : false,
    "tags" : [ ],
    "templates" : [ ],
    "text" : "Zip",
    "type_id" : 0,
    "uuid" : "e486619d-b212-43fd-bb1d-785f4cd312ce",
    "values" : [ ]
  }, {
    "allow_default_value" : false,
    "blank_option" : false,
    "calculated" : false,
    "changeable" : true,
    "chosen" : true,
    "default_chosen_by_server" : false,
    "deprecated" : false,
    "export_key" : "incident/data_source_ids",
    "hide_notification" : false,
    "id" : 12,
    "input_type" : "multiselect",
    "internal" : false,
    "is_tracked" : false,
    "name" : "data_source_ids",
    "operation_perms" : { },
    "operations" : [ ],
    "prefix" : "pii",
    "read_only" : false,
    "rich_text" : false,
    "tags" : [ ],
    "templates" : [ ],
    "text" : "Source of Data",
    "tooltip" : "Original source of the data, such as the name of the database.",
    "type_id" : 0,
    "uuid" : "e4d65b3a-9dca-492b-acb7-d2b33e3d5913",
    "values" : [ ]
  }, {
    "allow_default_value" : false,
    "blank_option" : true,
    "calculated" : false,
    "changeable" : true,
    "chosen" : false,
    "default_chosen_by_server" : false,
    "deprecated" : false,
    "export_key" : "incident/pipeda_sensitivity_of_pi",
    "hide_notification" : false,
    "id" : 22,
    "input_type" : "select",
    "internal" : false,
    "is_tracked" : false,
    "name" : "pipeda_sensitivity_of_pi",
    "operation_perms" : { },
    "operations" : [ ],
    "prefix" : "regulator_risk",
    "read_only" : false,
    "rich_text" : false,
    "tags" : [ ],
    "templates" : [ ],
    "text" : "PIPEDA Sensitivity of PI",
    "type_id" : 0,
    "uuid" : "e6185fbe-85a6-4485-bca9-a36866b77df0",
    "values" : [ ]
  }, {
    "allow_default_value" : false,
    "blank_option" : false,
    "calculated" : false,
    "changeable" : true,
    "chosen" : false,
    "default_chosen_by_server" : false,
    "deprecated" : false,
    "export_key" : "incident/singapore_risk_assessment",
    "hide_notification" : false,
    "id" : 222,
    "input_type" : "boolean",
    "internal" : false,
    "is_tracked" : false,
    "name" : "singapore_risk_assessment",
    "operation_perms" : { },
    "operations" : [ ],
    "prefix" : "pii",
    "read_only" : false,
    "rich_text" : false,
    "tags" : [ ],
    "templates" : [ ],
    "text" : "Singapore Risk Assessment",
    "type_id" : 0,
    "uuid" : "ea1802d6-008b-4b88-a7d6-fb1fbbd3f839",
    "values" : [ ]
  }, {
    "allow_default_value" : false,
    "blank_option" : false,
    "calculated" : false,
    "changeable" : true,
    "chosen" : false,
    "default_chosen_by_server" : false,
    "deprecated" : false,
    "export_key" : "incident/phase_id",
    "hide_notification" : false,
    "id" : 19,
    "input_type" : "select",
    "internal" : false,
    "is_tracked" : true,
    "name" : "phase_id",
    "operation_perms" : { },
    "operations" : [ ],
    "prefix" : null,
    "read_only" : true,
    "rich_text" : false,
    "tags" : [ ],
    "templates" : [ ],
    "text" : "Phase",
    "tooltip" : "The phase of the incident.",
    "type_id" : 0,
    "uuid" : "ea47a365-620d-4419-a767-f1b08f2685d7",
    "values" : [ ]
  }, {
    "allow_default_value" : false,
    "blank_option" : false,
    "calculated" : false,
    "changeable" : true,
    "chosen" : false,
    "default_chosen_by_server" : true,
    "deprecated" : false,
    "export_key" : "incident/workspace",
    "hide_notification" : false,
    "id" : 9,
    "input_type" : "select",
    "internal" : false,
    "is_tracked" : false,
    "name" : "workspace",
    "operation_perms" : { },
    "operations" : [ ],
    "prefix" : null,
    "read_only" : false,
    "required" : "always",
    "rich_text" : false,
    "tags" : [ ],
    "templates" : [ ],
    "text" : "Workspace",
    "type_id" : 0,
    "uuid" : "eeab7544-25d3-4189-84fc-8988a6ab1abf",
    "values" : [ ]
  }, {
    "allow_default_value" : false,
    "blank_option" : true,
    "calculated" : false,
    "changeable" : true,
    "chosen" : false,
    "default_chosen_by_server" : false,
    "deprecated" : false,
    "export_key" : "incident/pipeda_overall_assessment",
    "hide_notification" : false,
    "id" : 28,
    "input_type" : "select",
    "internal" : false,
    "is_tracked" : false,
    "name" : "pipeda_overall_assessment",
    "operation_perms" : { },
    "operations" : [ ],
    "prefix" : "regulator_risk",
    "read_only" : false,
    "rich_text" : false,
    "tags" : [ ],
    "templates" : [ ],
    "text" : "PIPEDA Overall Assessment",
    "type_id" : 0,
    "uuid" : "f3121d96-903a-4e4f-8d44-ccab00e9081f",
    "values" : [ ]
  }, {
    "allow_default_value" : false,
    "blank_option" : false,
    "calculated" : false,
    "changeable" : true,
    "chosen" : false,
    "default_chosen_by_server" : false,
    "deprecated" : false,
    "export_key" : "incident/due_date",
    "hide_notification" : false,
    "id" : 70,
    "input_type" : "datetimepicker",
    "internal" : false,
    "is_tracked" : false,
    "name" : "due_date",
    "operation_perms" : { },
    "operations" : [ ],
    "prefix" : null,
    "read_only" : true,
    "rich_text" : false,
    "tags" : [ ],
    "templates" : [ ],
    "text" : "Next Due Date",
    "tooltip" : "The nearest date for the next task due. This field is read-only.",
    "type_id" : 0,
    "uuid" : "f549afb8-eb80-4fbf-96f1-63eac60412c8",
    "values" : [ ]
  }, {
    "allow_default_value" : false,
    "blank_option" : false,
    "calculated" : false,
    "changeable" : true,
    "chosen" : false,
    "default_chosen_by_server" : false,
    "deprecated" : false,
    "export_key" : "incident/resolution_summary",
    "hide_notification" : false,
    "id" : 64,
    "input_type" : "textarea",
    "internal" : false,
    "is_tracked" : false,
    "name" : "resolution_summary",
    "operation_perms" : { },
    "operations" : [ ],
    "prefix" : null,
    "read_only" : false,
    "required" : "close",
    "rich_text" : true,
    "tags" : [ ],
    "templates" : [ ],
    "text" : "Resolution Summary",
    "tooltip" : "Enter a summary that describes how this incident was resolved.",
    "type_id" : 0,
    "uuid" : "f5d18473-03f6-4149-b0d9-1ce9006b4a99",
    "values" : [ ]
  }, {
    "allow_default_value" : false,
    "blank_option" : false,
    "calculated" : false,
    "changeable" : true,
    "chosen" : false,
    "default_chosen_by_server" : false,
    "deprecated" : false,
    "export_key" : "incident/mock_field_text",
    "hide_notification" : false,
    "id" : 271,
    "input_type" : "text",
    "internal" : false,
    "is_tracked" : false,
    "name" : "mock_field_text",
    "operation_perms" : { },
    "operations" : [ ],
    "placeholder" : "",
    "prefix" : "properties",
    "read_only" : false,
    "rich_text" : false,
    "tags" : [ {
      "tag_handle" : "fn_main_mock_integration",
      "value" : null
    } ],
    "templates" : [ ],
    "text" : "Mock: Field Text",
    "tooltip" : "a mock tooltip",
    "type_id" : 0,
    "uuid" : "f63a85ca-0e50-4504-81ab-c45d16494d0c",
    "values" : [ ]
  }, {
    "allow_default_value" : true,
    "blank_option" : true,
    "calculated" : false,
    "changeable" : true,
    "chosen" : true,
    "default_chosen_by_server" : false,
    "deprecated" : false,
    "export_key" : "incident/country",
    "hide_notification" : false,
    "id" : 55,
    "input_type" : "select",
    "internal" : false,
    "is_tracked" : false,
    "name" : "country",
    "operation_perms" : { },
    "operations" : [ ],
    "prefix" : null,
    "read_only" : false,
    "rich_text" : false,
    "tags" : [ ],
    "templates" : [ ],
    "text" : "Country/Region",
    "type_id" : 0,
    "uuid" : "f9e3d12e-43b4-43c0-a8ae-89b5df9a5add",
    "values" : [ {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Afghanistan",
      "properties" : null,
      "uuid" : null,
      "value" : 1017
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Åland Islands",
      "properties" : null,
      "uuid" : null,
      "value" : 1261
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Albania",
      "properties" : null,
      "uuid" : null,
      "value" : 1018
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Algeria",
      "properties" : null,
      "uuid" : null,
      "value" : 1019
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "American Samoa",
      "properties" : null,
      "uuid" : null,
      "value" : 1020
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Andorra",
      "properties" : null,
      "uuid" : null,
      "value" : 1021
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Angola",
      "properties" : null,
      "uuid" : null,
      "value" : 1022
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Anguilla",
      "properties" : null,
      "uuid" : null,
      "value" : 1023
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Antarctica",
      "properties" : null,
      "uuid" : null,
      "value" : 1024
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Antigua and Barbuda",
      "properties" : null,
      "uuid" : null,
      "value" : 1025
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Argentina",
      "properties" : null,
      "uuid" : null,
      "value" : 1026
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Armenia",
      "properties" : null,
      "uuid" : null,
      "value" : 1027
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Aruba",
      "properties" : null,
      "uuid" : null,
      "value" : 1028
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Ascension and Tristan Da Cunha Saint Helena",
      "properties" : null,
      "uuid" : null,
      "value" : 1029
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Australia",
      "properties" : null,
      "uuid" : null,
      "value" : 1030
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Austria",
      "properties" : null,
      "uuid" : null,
      "value" : 1031
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Azerbaijan",
      "properties" : null,
      "uuid" : null,
      "value" : 1032
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Bahamas",
      "properties" : null,
      "uuid" : null,
      "value" : 1033
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Bahrain",
      "properties" : null,
      "uuid" : null,
      "value" : 1034
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Bangladesh",
      "properties" : null,
      "uuid" : null,
      "value" : 1035
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Barbados",
      "properties" : null,
      "uuid" : null,
      "value" : 1036
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Belarus",
      "properties" : null,
      "uuid" : null,
      "value" : 1037
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Belgium",
      "properties" : null,
      "uuid" : null,
      "value" : 1038
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Belize",
      "properties" : null,
      "uuid" : null,
      "value" : 1039
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Benin",
      "properties" : null,
      "uuid" : null,
      "value" : 1040
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Bermuda",
      "properties" : null,
      "uuid" : null,
      "value" : 1041
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Bhutan",
      "properties" : null,
      "uuid" : null,
      "value" : 1042
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Bolivarian Republic of Venezuela",
      "properties" : null,
      "uuid" : null,
      "value" : 1043
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Bosnia and Herzegovina",
      "properties" : null,
      "uuid" : null,
      "value" : 1044
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Botswana",
      "properties" : null,
      "uuid" : null,
      "value" : 1045
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Bouvet Island",
      "properties" : null,
      "uuid" : null,
      "value" : 1046
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Brazil",
      "properties" : null,
      "uuid" : null,
      "value" : 1047
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "British Indian Ocean Territory",
      "properties" : null,
      "uuid" : null,
      "value" : 1048
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "British Virgin Islands",
      "properties" : null,
      "uuid" : null,
      "value" : 1049
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Brunei Darussalam",
      "properties" : null,
      "uuid" : null,
      "value" : 1050
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Bulgaria",
      "properties" : null,
      "uuid" : null,
      "value" : 1051
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Burkina Faso",
      "properties" : null,
      "uuid" : null,
      "value" : 1052
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Burundi",
      "properties" : null,
      "uuid" : null,
      "value" : 1053
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Cambodia",
      "properties" : null,
      "uuid" : null,
      "value" : 1054
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Cameroon",
      "properties" : null,
      "uuid" : null,
      "value" : 1055
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Canada",
      "properties" : null,
      "uuid" : null,
      "value" : 1001
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Cape Verde",
      "properties" : null,
      "uuid" : null,
      "value" : 1056
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Cayman Islands",
      "properties" : null,
      "uuid" : null,
      "value" : 1057
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Central African Republic",
      "properties" : null,
      "uuid" : null,
      "value" : 1058
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Chad",
      "properties" : null,
      "uuid" : null,
      "value" : 1059
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Chile",
      "properties" : null,
      "uuid" : null,
      "value" : 1060
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "China",
      "properties" : null,
      "uuid" : null,
      "value" : 1061
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Christmas Island",
      "properties" : null,
      "uuid" : null,
      "value" : 1062
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Cocos (Keeling) Islands",
      "properties" : null,
      "uuid" : null,
      "value" : 1063
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Colombia",
      "properties" : null,
      "uuid" : null,
      "value" : 1064
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Comoros",
      "properties" : null,
      "uuid" : null,
      "value" : 1065
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Congo",
      "properties" : null,
      "uuid" : null,
      "value" : 1066
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Cook Islands",
      "properties" : null,
      "uuid" : null,
      "value" : 1067
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Costa Rica",
      "properties" : null,
      "uuid" : null,
      "value" : 1068
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Croatia",
      "properties" : null,
      "uuid" : null,
      "value" : 1069
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Cuba",
      "properties" : null,
      "uuid" : null,
      "value" : 1070
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Curaçao",
      "properties" : null,
      "uuid" : null,
      "value" : 1071
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Cyprus",
      "properties" : null,
      "uuid" : null,
      "value" : 1072
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Czech Republic",
      "properties" : null,
      "uuid" : null,
      "value" : 1073
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Democratic People's Republic of Korea",
      "properties" : null,
      "uuid" : null,
      "value" : 1075
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Denmark",
      "properties" : null,
      "uuid" : null,
      "value" : 1076
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Djibouti",
      "properties" : null,
      "uuid" : null,
      "value" : 1077
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Dominica",
      "properties" : null,
      "uuid" : null,
      "value" : 1078
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Dominican Republic",
      "properties" : null,
      "uuid" : null,
      "value" : 1079
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Ecuador",
      "properties" : null,
      "uuid" : null,
      "value" : 1080
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Egypt",
      "properties" : null,
      "uuid" : null,
      "value" : 1081
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "El Salvador",
      "properties" : null,
      "uuid" : null,
      "value" : 1082
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Equatorial Guinea",
      "properties" : null,
      "uuid" : null,
      "value" : 1083
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Eritrea",
      "properties" : null,
      "uuid" : null,
      "value" : 1084
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Estonia",
      "properties" : null,
      "uuid" : null,
      "value" : 1085
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Ethiopia",
      "properties" : null,
      "uuid" : null,
      "value" : 1086
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Falkland Islands (Malvinas)",
      "properties" : null,
      "uuid" : null,
      "value" : 1087
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Faroe Islands",
      "properties" : null,
      "uuid" : null,
      "value" : 1088
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Federated States of Micronesia",
      "properties" : null,
      "uuid" : null,
      "value" : 1089
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Fiji",
      "properties" : null,
      "uuid" : null,
      "value" : 1090
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Finland",
      "properties" : null,
      "uuid" : null,
      "value" : 1091
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "France",
      "properties" : null,
      "uuid" : null,
      "value" : 1092
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "French Guiana",
      "properties" : null,
      "uuid" : null,
      "value" : 1093
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "French Polynesia",
      "properties" : null,
      "uuid" : null,
      "value" : 1094
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "French Southern Territories",
      "properties" : null,
      "uuid" : null,
      "value" : 1095
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Gabon",
      "properties" : null,
      "uuid" : null,
      "value" : 1096
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Gambia",
      "properties" : null,
      "uuid" : null,
      "value" : 1097
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Georgia (Country)",
      "properties" : null,
      "uuid" : null,
      "value" : 1098
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Germany",
      "properties" : null,
      "uuid" : null,
      "value" : 1099
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Ghana",
      "properties" : null,
      "uuid" : null,
      "value" : 1100
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Gibraltar",
      "properties" : null,
      "uuid" : null,
      "value" : 1101
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Greece",
      "properties" : null,
      "uuid" : null,
      "value" : 1102
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Greenland",
      "properties" : null,
      "uuid" : null,
      "value" : 1103
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Grenada",
      "properties" : null,
      "uuid" : null,
      "value" : 1104
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Guadeloupe",
      "properties" : null,
      "uuid" : null,
      "value" : 1105
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Guatemala",
      "properties" : null,
      "uuid" : null,
      "value" : 1107
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Guernsey",
      "properties" : null,
      "uuid" : null,
      "value" : 1108
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Guinea",
      "properties" : null,
      "uuid" : null,
      "value" : 1109
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Guinea-Bissau",
      "properties" : null,
      "uuid" : null,
      "value" : 1110
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Guyana",
      "properties" : null,
      "uuid" : null,
      "value" : 1111
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Haiti",
      "properties" : null,
      "uuid" : null,
      "value" : 1112
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Heard Island and Mcdonald Islands",
      "properties" : null,
      "uuid" : null,
      "value" : 1113
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Holy See (Vatican City State)",
      "properties" : null,
      "uuid" : null,
      "value" : 1114
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Honduras",
      "properties" : null,
      "uuid" : null,
      "value" : 1115
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Hong Kong S.A.R. of the PRC",
      "properties" : null,
      "uuid" : null,
      "value" : 1116
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Hungary",
      "properties" : null,
      "uuid" : null,
      "value" : 1117
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Iceland",
      "properties" : null,
      "uuid" : null,
      "value" : 1118
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "India",
      "properties" : null,
      "uuid" : null,
      "value" : 1119
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Indonesia",
      "properties" : null,
      "uuid" : null,
      "value" : 1120
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Iraq",
      "properties" : null,
      "uuid" : null,
      "value" : 1121
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Ireland",
      "properties" : null,
      "uuid" : null,
      "value" : 1122
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Islamic Republic of Iran",
      "properties" : null,
      "uuid" : null,
      "value" : 1123
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Isle of Man",
      "properties" : null,
      "uuid" : null,
      "value" : 1124
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Israel",
      "properties" : null,
      "uuid" : null,
      "value" : 1125
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Italy",
      "properties" : null,
      "uuid" : null,
      "value" : 1126
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Jamaica",
      "properties" : null,
      "uuid" : null,
      "value" : 1127
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Japan",
      "properties" : null,
      "uuid" : null,
      "value" : 1128
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Jersey",
      "properties" : null,
      "uuid" : null,
      "value" : 1129
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Jordan",
      "properties" : null,
      "uuid" : null,
      "value" : 1130
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Kazakhstan",
      "properties" : null,
      "uuid" : null,
      "value" : 1131
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Kenya",
      "properties" : null,
      "uuid" : null,
      "value" : 1132
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Kiribati",
      "properties" : null,
      "uuid" : null,
      "value" : 1133
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Kuwait",
      "properties" : null,
      "uuid" : null,
      "value" : 1134
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Kyrgyzstan",
      "properties" : null,
      "uuid" : null,
      "value" : 1135
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Lao People's Democratic Republic",
      "properties" : null,
      "uuid" : null,
      "value" : 1136
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Latvia",
      "properties" : null,
      "uuid" : null,
      "value" : 1137
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Lebanon",
      "properties" : null,
      "uuid" : null,
      "value" : 1138
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Lesotho",
      "properties" : null,
      "uuid" : null,
      "value" : 1139
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Liberia",
      "properties" : null,
      "uuid" : null,
      "value" : 1140
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Libya",
      "properties" : null,
      "uuid" : null,
      "value" : 1141
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Liechtenstein",
      "properties" : null,
      "uuid" : null,
      "value" : 1142
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Lithuania",
      "properties" : null,
      "uuid" : null,
      "value" : 1143
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Luxembourg",
      "properties" : null,
      "uuid" : null,
      "value" : 1144
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Macao S.A.R. of the PRC",
      "properties" : null,
      "uuid" : null,
      "value" : 1145
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Madagascar",
      "properties" : null,
      "uuid" : null,
      "value" : 1146
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Malawi",
      "properties" : null,
      "uuid" : null,
      "value" : 1147
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Malaysia",
      "properties" : null,
      "uuid" : null,
      "value" : 1148
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Maldives",
      "properties" : null,
      "uuid" : null,
      "value" : 1149
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Mali",
      "properties" : null,
      "uuid" : null,
      "value" : 1150
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Malta",
      "properties" : null,
      "uuid" : null,
      "value" : 1151
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Marshall Islands",
      "properties" : null,
      "uuid" : null,
      "value" : 1152
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Martinique",
      "properties" : null,
      "uuid" : null,
      "value" : 1153
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Mauritania",
      "properties" : null,
      "uuid" : null,
      "value" : 1154
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Mauritius",
      "properties" : null,
      "uuid" : null,
      "value" : 1155
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Mayotte",
      "properties" : null,
      "uuid" : null,
      "value" : 1156
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Mexico",
      "properties" : null,
      "uuid" : null,
      "value" : 1157
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Monaco",
      "properties" : null,
      "uuid" : null,
      "value" : 1158
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Mongolia",
      "properties" : null,
      "uuid" : null,
      "value" : 1159
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Montenegro",
      "properties" : null,
      "uuid" : null,
      "value" : 1160
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Montserrat",
      "properties" : null,
      "uuid" : null,
      "value" : 1161
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Morocco",
      "properties" : null,
      "uuid" : null,
      "value" : 1162
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Mozambique",
      "properties" : null,
      "uuid" : null,
      "value" : 1163
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Myanmar",
      "properties" : null,
      "uuid" : null,
      "value" : 1164
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Namibia",
      "properties" : null,
      "uuid" : null,
      "value" : 1165
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Nauru",
      "properties" : null,
      "uuid" : null,
      "value" : 1166
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Nepal",
      "properties" : null,
      "uuid" : null,
      "value" : 1167
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Netherlands",
      "properties" : null,
      "uuid" : null,
      "value" : 1168
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "New Caledonia",
      "properties" : null,
      "uuid" : null,
      "value" : 1169
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "New Zealand",
      "properties" : null,
      "uuid" : null,
      "value" : 1170
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Nicaragua",
      "properties" : null,
      "uuid" : null,
      "value" : 1171
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Niger",
      "properties" : null,
      "uuid" : null,
      "value" : 1172
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Nigeria",
      "properties" : null,
      "uuid" : null,
      "value" : 1173
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Niue",
      "properties" : null,
      "uuid" : null,
      "value" : 1174
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Norfolk Island",
      "properties" : null,
      "uuid" : null,
      "value" : 1175
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Norway",
      "properties" : null,
      "uuid" : null,
      "value" : 1177
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Oman",
      "properties" : null,
      "uuid" : null,
      "value" : 1178
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Pakistan",
      "properties" : null,
      "uuid" : null,
      "value" : 1179
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Palau",
      "properties" : null,
      "uuid" : null,
      "value" : 1180
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Panama",
      "properties" : null,
      "uuid" : null,
      "value" : 1181
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Papua New Guinea",
      "properties" : null,
      "uuid" : null,
      "value" : 1182
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Paraguay",
      "properties" : null,
      "uuid" : null,
      "value" : 1183
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Peru",
      "properties" : null,
      "uuid" : null,
      "value" : 1184
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Philippines",
      "properties" : null,
      "uuid" : null,
      "value" : 1185
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Pitcairn",
      "properties" : null,
      "uuid" : null,
      "value" : 1186
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Plurinational State of Bolivia",
      "properties" : null,
      "uuid" : null,
      "value" : 1187
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Poland",
      "properties" : null,
      "uuid" : null,
      "value" : 1188
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Portugal",
      "properties" : null,
      "uuid" : null,
      "value" : 1189
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Qatar",
      "properties" : null,
      "uuid" : null,
      "value" : 1191
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Republic of Korea",
      "properties" : null,
      "uuid" : null,
      "value" : 1192
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Republic of Moldova",
      "properties" : null,
      "uuid" : null,
      "value" : 1193
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Republic of North Macedonia",
      "properties" : null,
      "uuid" : null,
      "value" : 1235
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Réunion",
      "properties" : null,
      "uuid" : null,
      "value" : 1197
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Romania",
      "properties" : null,
      "uuid" : null,
      "value" : 1194
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Russian Federation",
      "properties" : null,
      "uuid" : null,
      "value" : 1195
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Rwanda",
      "properties" : null,
      "uuid" : null,
      "value" : 1196
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Saint Barthélemy",
      "properties" : null,
      "uuid" : null,
      "value" : 1198
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Saint Kitts and Nevis",
      "properties" : null,
      "uuid" : null,
      "value" : 1199
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Saint Lucia",
      "properties" : null,
      "uuid" : null,
      "value" : 1200
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Saint Martin (French Part)",
      "properties" : null,
      "uuid" : null,
      "value" : 1201
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Saint Pierre and Miquelon",
      "properties" : null,
      "uuid" : null,
      "value" : 1202
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Saint Vincent and the Grenadines",
      "properties" : null,
      "uuid" : null,
      "value" : 1203
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Samoa",
      "properties" : null,
      "uuid" : null,
      "value" : 1204
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "San Marino",
      "properties" : null,
      "uuid" : null,
      "value" : 1205
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Sao Tome and Principe",
      "properties" : null,
      "uuid" : null,
      "value" : 1206
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Saudi Arabia",
      "properties" : null,
      "uuid" : null,
      "value" : 1207
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Senegal",
      "properties" : null,
      "uuid" : null,
      "value" : 1208
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Serbia",
      "properties" : null,
      "uuid" : null,
      "value" : 1209
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Seychelles",
      "properties" : null,
      "uuid" : null,
      "value" : 1210
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Sierra Leone",
      "properties" : null,
      "uuid" : null,
      "value" : 1211
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Singapore",
      "properties" : null,
      "uuid" : null,
      "value" : 1212
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Sint Eustatius and Saba Bonaire",
      "properties" : null,
      "uuid" : null,
      "value" : 1213
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Sint Maarten (Dutch Part)",
      "properties" : null,
      "uuid" : null,
      "value" : 1214
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Slovakia",
      "properties" : null,
      "uuid" : null,
      "value" : 1215
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Slovenia",
      "properties" : null,
      "uuid" : null,
      "value" : 1216
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Solomon Islands",
      "properties" : null,
      "uuid" : null,
      "value" : 1217
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Somalia",
      "properties" : null,
      "uuid" : null,
      "value" : 1218
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "South Africa",
      "properties" : null,
      "uuid" : null,
      "value" : 1219
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "South Georgia and the South Sandwich Islands",
      "properties" : null,
      "uuid" : null,
      "value" : 1220
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "South Sudan",
      "properties" : null,
      "uuid" : null,
      "value" : 1221
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Spain",
      "properties" : null,
      "uuid" : null,
      "value" : 1222
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Sri Lanka",
      "properties" : null,
      "uuid" : null,
      "value" : 1223
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "State of Palestine",
      "properties" : null,
      "uuid" : null,
      "value" : 1224
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Sudan",
      "properties" : null,
      "uuid" : null,
      "value" : 1225
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Suriname",
      "properties" : null,
      "uuid" : null,
      "value" : 1226
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Svalbard and Jan Mayen",
      "properties" : null,
      "uuid" : null,
      "value" : 1227
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Swaziland",
      "properties" : null,
      "uuid" : null,
      "value" : 1228
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Sweden",
      "properties" : null,
      "uuid" : null,
      "value" : 1229
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Switzerland",
      "properties" : null,
      "uuid" : null,
      "value" : 1230
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Syrian Arab Republic",
      "properties" : null,
      "uuid" : null,
      "value" : 1231
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Taiwan",
      "properties" : null,
      "uuid" : null,
      "value" : 1190
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Tajikistan",
      "properties" : null,
      "uuid" : null,
      "value" : 1232
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Thailand",
      "properties" : null,
      "uuid" : null,
      "value" : 1233
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "The Democratic Republic of the Congo",
      "properties" : null,
      "uuid" : null,
      "value" : 1234
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "The Republic of Côte d'Ivoire",
      "properties" : null,
      "uuid" : null,
      "value" : 1074
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Timor-Leste",
      "properties" : null,
      "uuid" : null,
      "value" : 1236
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Togo",
      "properties" : null,
      "uuid" : null,
      "value" : 1237
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Tokelau",
      "properties" : null,
      "uuid" : null,
      "value" : 1238
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Tonga",
      "properties" : null,
      "uuid" : null,
      "value" : 1239
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Trinidad and Tobago",
      "properties" : null,
      "uuid" : null,
      "value" : 1240
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Tunisia",
      "properties" : null,
      "uuid" : null,
      "value" : 1241
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Turkey",
      "properties" : null,
      "uuid" : null,
      "value" : 1242
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Turkmenistan",
      "properties" : null,
      "uuid" : null,
      "value" : 1243
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Turks and Caicos Islands",
      "properties" : null,
      "uuid" : null,
      "value" : 1244
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Tuvalu",
      "properties" : null,
      "uuid" : null,
      "value" : 1245
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Uganda",
      "properties" : null,
      "uuid" : null,
      "value" : 1246
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Ukraine",
      "properties" : null,
      "uuid" : null,
      "value" : 1247
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "United Arab Emirates",
      "properties" : null,
      "uuid" : null,
      "value" : 1248
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "United Kingdom",
      "properties" : null,
      "uuid" : null,
      "value" : 1249
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "United Republic of Tanzania",
      "properties" : null,
      "uuid" : null,
      "value" : 1250
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "United States",
      "properties" : null,
      "uuid" : null,
      "value" : 1000
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "United States Minor Outlying Islands",
      "properties" : null,
      "uuid" : null,
      "value" : 1251
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Uruguay",
      "properties" : null,
      "uuid" : null,
      "value" : 1252
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Uzbekistan",
      "properties" : null,
      "uuid" : null,
      "value" : 1253
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Vanuatu",
      "properties" : null,
      "uuid" : null,
      "value" : 1254
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Viet Nam",
      "properties" : null,
      "uuid" : null,
      "value" : 1255
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Wallis and Futuna",
      "properties" : null,
      "uuid" : null,
      "value" : 1256
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Western Sahara",
      "properties" : null,
      "uuid" : null,
      "value" : 1257
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Yemen",
      "properties" : null,
      "uuid" : null,
      "value" : 1258
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Zambia",
      "properties" : null,
      "uuid" : null,
      "value" : 1259
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Zimbabwe",
      "properties" : null,
      "uuid" : null,
      "value" : 1260
    } ]
  }, {
    "allow_default_value" : false,
    "blank_option" : false,
    "calculated" : false,
    "changeable" : true,
    "chosen" : false,
    "default_chosen_by_server" : false,
    "deprecated" : false,
    "export_key" : "incident/gdpr_final_assessment_comment",
    "hide_notification" : false,
    "id" : 39,
    "input_type" : "textarea",
    "internal" : false,
    "is_tracked" : false,
    "name" : "gdpr_final_assessment_comment",
    "operation_perms" : { },
    "operations" : [ ],
    "prefix" : "gdpr",
    "read_only" : false,
    "rich_text" : false,
    "tags" : [ ],
    "templates" : [ ],
    "text" : "GDPR Final Assessment Comment",
    "type_id" : 0,
    "uuid" : "fa91a9b6-6b12-42d6-bd40-68461d2948af",
    "values" : [ ]
  }, {
    "allow_default_value" : false,
    "blank_option" : true,
    "calculated" : false,
    "changeable" : true,
    "chosen" : false,
    "default_chosen_by_server" : false,
    "deprecated" : false,
    "export_key" : "incident/pipeda_probability_of_misuse",
    "hide_notification" : false,
    "id" : 24,
    "input_type" : "select",
    "internal" : false,
    "is_tracked" : false,
    "name" : "pipeda_probability_of_misuse",
    "operation_perms" : { },
    "operations" : [ ],
    "prefix" : "regulator_risk",
    "read_only" : false,
    "rich_text" : false,
    "tags" : [ ],
    "templates" : [ ],
    "text" : "PIPEDA Probability of Misuse",
    "type_id" : 0,
    "uuid" : "fdefcc18-b394-4550-a713-ab744ef4419a",
    "values" : [ ]
  }, {
    "allow_default_value" : false,
    "blank_option" : false,
    "calculated" : false,
    "changeable" : true,
    "chosen" : true,
    "default_chosen_by_server" : false,
    "deprecated" : false,
    "export_key" : "incident/gdpr_lawful_data_processing_categories",
    "hide_notification" : false,
    "id" : 72,
    "input_type" : "multiselect",
    "internal" : false,
    "is_tracked" : false,
    "name" : "gdpr_lawful_data_processing_categories",
    "operation_perms" : { },
    "operations" : [ ],
    "placeholder" : "Choose Some Categories",
    "prefix" : "pii",
    "read_only" : false,
    "rich_text" : false,
    "tags" : [ ],
    "templates" : [ ],
    "text" : "Lawful Data Processing Categories",
    "tooltip" : "Under the GDPR, processing of personal or sensitive data is only lawful if one or more of these categories applies.",
    "type_id" : 0,
    "uuid" : "000fa89b-0570-4162-a720-b4b188b06ad3",
    "values" : [ {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Consent by data subject",
      "properties" : null,
      "uuid" : "b31ffbc5-7e24-4a54-8c8d-e26caf7a96c7",
      "value" : 14
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Performance of contract",
      "properties" : null,
      "uuid" : "447b6e53-ca8a-4cde-ab2c-f529132a1948",
      "value" : 15
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Compliance with legal obligation",
      "properties" : null,
      "uuid" : "82817a05-c4ae-453b-a0ea-52be2fd43d7c",
      "value" : 16
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Protection of vital interests of data subject",
      "properties" : null,
      "uuid" : "4ce0da31-4f52-4308-985a-7a56194617d0",
      "value" : 17
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Public interest or official authority",
      "properties" : null,
      "uuid" : "e1dcd2f7-4a42-4f87-add6-58d74dee7b58",
      "value" : 18
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Legitimate interests of data controller or third party",
      "properties" : null,
      "uuid" : "c34f95d3-23a9-46ef-b67c-f795b4928ce5",
      "value" : 19
    } ]
  }, {
    "allow_default_value" : false,
    "blank_option" : false,
    "calculated" : false,
    "changeable" : true,
    "chosen" : false,
    "default_chosen_by_server" : false,
    "deprecated" : false,
    "export_key" : "incident/gdpr_consequences_comment",
    "hide_notification" : false,
    "id" : 37,
    "input_type" : "textarea",
    "internal" : false,
    "is_tracked" : false,
    "name" : "gdpr_consequences_comment",
    "operation_perms" : { },
    "operations" : [ ],
    "prefix" : "gdpr",
    "read_only" : false,
    "rich_text" : false,
    "tags" : [ ],
    "templates" : [ ],
    "text" : "GDPR Consequences Comment",
    "type_id" : 0,
    "uuid" : "0064f82d-2ccb-4a5f-8f57-27d1ef95193e",
    "values" : [ ]
  }, {
    "allow_default_value" : false,
    "blank_option" : false,
    "calculated" : false,
    "changeable" : true,
    "chosen" : false,
    "default_chosen_by_server" : false,
    "deprecated" : false,
    "export_key" : "incident/gdpr_subsequent_notification",
    "hide_notification" : false,
    "id" : 40,
    "input_type" : "boolean",
    "internal" : false,
    "is_tracked" : false,
    "name" : "gdpr_subsequent_notification",
    "operation_perms" : { },
    "operations" : [ ],
    "prefix" : "gdpr",
    "read_only" : false,
    "rich_text" : false,
    "tags" : [ ],
    "templates" : [ ],
    "text" : "GDPR Subsequent Notification",
    "type_id" : 0,
    "uuid" : "09f66a71-8c7a-4279-a669-cc6542d124ef",
    "values" : [ ]
  }, {
    "allow_default_value" : false,
    "blank_option" : false,
    "calculated" : false,
    "changeable" : true,
    "chosen" : true,
    "default_chosen_by_server" : false,
    "deprecated" : false,
    "export_key" : "incident/incident_type_ids",
    "hide_notification" : false,
    "id" : 16,
    "input_type" : "multiselect",
    "internal" : false,
    "is_tracked" : false,
    "name" : "incident_type_ids",
    "operation_perms" : { },
    "operations" : [ ],
    "placeholder" : "Choose Some Types",
    "prefix" : null,
    "read_only" : false,
    "rich_text" : false,
    "tags" : [ ],
    "templates" : [ ],
    "text" : "Incident Type",
    "tooltip" : "The type of incident",
    "type_id" : 0,
    "uuid" : "11ed8b8a-8ffc-4dea-9699-28a351b4f212",
    "values" : [ ]
  }, {
    "allow_default_value" : false,
    "blank_option" : false,
    "calculated" : false,
    "changeable" : true,
    "chosen" : false,
    "default_chosen_by_server" : false,
    "deprecated" : false,
    "export_key" : "incident/severity_code",
    "hide_notification" : false,
    "id" : 62,
    "input_type" : "select",
    "internal" : false,
    "is_tracked" : true,
    "name" : "severity_code",
    "operation_perms" : { },
    "operations" : [ ],
    "prefix" : null,
    "read_only" : false,
    "rich_text" : false,
    "tags" : [ ],
    "templates" : [ ],
    "text" : "Severity",
    "tooltip" : "Your impression of the events relative severity vs. other events that may be entered into the system.",
    "type_id" : 0,
    "uuid" : "153e9e55-d7ba-43b8-8894-e3340935ba99",
    "values" : [ {
      "default" : true,
      "enabled" : true,
      "hidden" : false,
      "label" : "Low",
      "properties" : null,
      "uuid" : "97cae239-963d-4e36-be34-07e47ef2cc86",
      "value" : 4
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Medium",
      "properties" : null,
      "uuid" : "c2c354c9-6d1e-4a48-82e5-bd5dc5068339",
      "value" : 5
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "High",
      "properties" : null,
      "uuid" : "93e5c99c-563b-48b9-80a3-9572307622d8",
      "value" : 6
    } ]
  }, {
    "allow_default_value" : false,
    "blank_option" : true,
    "calculated" : false,
    "changeable" : true,
    "chosen" : false,
    "default_chosen_by_server" : false,
    "deprecated" : false,
    "export_key" : "incident/exposure_dept_id",
    "hide_notification" : false,
    "id" : 8,
    "input_type" : "select",
    "internal" : false,
    "is_tracked" : false,
    "name" : "exposure_dept_id",
    "operation_perms" : { },
    "operations" : [ ],
    "prefix" : null,
    "read_only" : false,
    "rich_text" : false,
    "tags" : [ ],
    "templates" : [ ],
    "text" : "Department",
    "type_id" : 0,
    "uuid" : "15c23dae-1d17-49ff-aae0-8cb457e27867",
    "values" : [ ]
  }, {
    "allow_default_value" : false,
    "blank_option" : false,
    "calculated" : false,
    "changeable" : true,
    "chosen" : false,
    "default_chosen_by_server" : false,
    "deprecated" : false,
    "export_key" : "incident/new_zealand_risk_assessment",
    "hide_notification" : false,
    "id" : 211,
    "input_type" : "boolean",
    "internal" : false,
    "is_tracked" : false,
    "name" : "new_zealand_risk_assessment",
    "operation_perms" : { },
    "operations" : [ ],
    "prefix" : "pii",
    "read_only" : false,
    "rich_text" : false,
    "tags" : [ ],
    "templates" : [ ],
    "text" : "New Zealand Risk Assessment",
    "type_id" : 0,
    "uuid" : "19d1232b-f78e-4514-88c6-5133a51bc8b1",
    "values" : [ ]
  }, {
    "allow_default_value" : false,
    "blank_option" : true,
    "calculated" : false,
    "changeable" : true,
    "chosen" : false,
    "default_chosen_by_server" : false,
    "deprecated" : false,
    "export_key" : "incident/gdpr_breach_type",
    "hide_notification" : false,
    "id" : 30,
    "input_type" : "select",
    "internal" : false,
    "is_tracked" : false,
    "name" : "gdpr_breach_type",
    "operation_perms" : { },
    "operations" : [ ],
    "prefix" : "gdpr",
    "read_only" : false,
    "rich_text" : false,
    "tags" : [ ],
    "templates" : [ ],
    "text" : "GDPR Breach Type",
    "type_id" : 0,
    "uuid" : "1a287fef-4b99-4a96-a8b4-7ccc3c6366fb",
    "values" : [ ]
  }, {
    "allow_default_value" : false,
    "blank_option" : false,
    "calculated" : false,
    "changeable" : true,
    "chosen" : false,
    "default_chosen_by_server" : false,
    "deprecated" : false,
    "export_key" : "incident/or_impact_likely",
    "hide_notification" : false,
    "id" : 47,
    "input_type" : "boolean",
    "internal" : false,
    "is_tracked" : false,
    "name" : "or_impact_likely",
    "operation_perms" : { },
    "operations" : [ ],
    "prefix" : "pii",
    "read_only" : false,
    "rich_text" : false,
    "tags" : [ ],
    "templates" : [ ],
    "text" : "Impact Likely for Oregon",
    "type_id" : 0,
    "uuid" : "2203d24c-b5b4-48cb-811c-d27fac5ef09a",
    "values" : [ ]
  }, {
    "allow_default_value" : false,
    "blank_option" : false,
    "calculated" : false,
    "changeable" : true,
    "chosen" : false,
    "default_chosen_by_server" : false,
    "deprecated" : false,
    "export_key" : "incident/mock_field_number",
    "hide_notification" : false,
    "id" : 272,
    "input_type" : "number",
    "internal" : false,
    "is_tracked" : false,
    "name" : "mock_field_number",
    "operation_perms" : { },
    "operations" : [ ],
    "placeholder" : "",
    "prefix" : "properties",
    "read_only" : false,
    "rich_text" : false,
    "tags" : [ {
      "tag_handle" : "fn_main_mock_integration",
      "value" : null
    } ],
    "templates" : [ ],
    "text" : "Mock:  ล ฦ ว ศ ษ ส ห ฬ อ field number",
    "tooltip" : "a mock tooltip  ล ฦ ว ศ ษ ส ห ฬ อ",
    "type_id" : 0,
    "uuid" : "2653024f-9abb-4440-aa61-cb3f6262f6ee",
    "values" : [ ]
  }, {
    "allow_default_value" : false,
    "blank_option" : false,
    "calculated" : false,
    "changeable" : true,
    "chosen" : false,
    "default_chosen_by_server" : false,
    "deprecated" : false,
    "export_key" : "incident/discovered_date",
    "hide_notification" : true,
    "id" : 50,
    "input_type" : "datetimepicker",
    "internal" : false,
    "is_tracked" : false,
    "name" : "discovered_date",
    "operation_perms" : { },
    "operations" : [ ],
    "prefix" : null,
    "read_only" : false,
    "required" : "always",
    "rich_text" : false,
    "tags" : [ ],
    "templates" : [ ],
    "text" : "Date Discovered",
    "tooltip" : "Date the incident was discovered/reported.",
    "type_id" : 0,
    "uuid" : "26cb8fa6-32e2-410d-b8e5-c23af0d09263",
    "values" : [ ]
  }, {
    "allow_default_value" : false,
    "blank_option" : false,
    "calculated" : false,
    "changeable" : true,
    "chosen" : false,
    "default_chosen_by_server" : false,
    "deprecated" : false,
    "export_key" : "incident/plan_status",
    "hide_notification" : false,
    "id" : 11,
    "input_type" : "select",
    "internal" : false,
    "is_tracked" : false,
    "name" : "plan_status",
    "operation_perms" : { },
    "operations" : [ ],
    "prefix" : null,
    "read_only" : false,
    "rich_text" : false,
    "tags" : [ ],
    "templates" : [ ],
    "text" : "Status",
    "type_id" : 0,
    "uuid" : "2df00085-f5f2-4289-844b-6ea014f77ac3",
    "values" : [ ]
  }, {
    "allow_default_value" : false,
    "blank_option" : false,
    "calculated" : false,
    "changeable" : true,
    "chosen" : false,
    "default_chosen_by_server" : false,
    "deprecated" : false,
    "export_key" : "incident/california_health_risk_assessment",
    "hide_notification" : false,
    "id" : 263,
    "input_type" : "boolean",
    "internal" : false,
    "is_tracked" : false,
    "name" : "california_health_risk_assessment",
    "operation_perms" : { },
    "operations" : [ ],
    "prefix" : "pii",
    "read_only" : false,
    "rich_text" : false,
    "tags" : [ ],
    "templates" : [ ],
    "text" : "California Health Risk Assessment",
    "type_id" : 0,
    "uuid" : "35868ab2-564c-43e1-94bc-a3f5676bc25a",
    "values" : [ ]
  }, {
    "allow_default_value" : false,
    "blank_option" : true,
    "calculated" : false,
    "changeable" : true,
    "chosen" : true,
    "default_chosen_by_server" : false,
    "deprecated" : false,
    "export_key" : "incident/state",
    "hide_notification" : true,
    "id" : 4,
    "input_type" : "select",
    "internal" : false,
    "is_tracked" : false,
    "name" : "state",
    "operation_perms" : { },
    "operations" : [ ],
    "prefix" : null,
    "read_only" : false,
    "rich_text" : false,
    "tags" : [ ],
    "templates" : [ ],
    "text" : "State",
    "type_id" : 0,
    "uuid" : "37a7f680-9ea3-4703-8e86-3846ef14397f",
    "values" : [ ]
  }, {
    "allow_default_value" : false,
    "blank_option" : false,
    "calculated" : false,
    "changeable" : true,
    "chosen" : false,
    "default_chosen_by_server" : false,
    "deprecated" : false,
    "export_key" : "incident/data_encrypted",
    "hide_notification" : false,
    "id" : 42,
    "input_type" : "boolean",
    "internal" : false,
    "is_tracked" : false,
    "name" : "data_encrypted",
    "operation_perms" : { },
    "operations" : [ ],
    "prefix" : "pii",
    "read_only" : false,
    "rich_text" : false,
    "tags" : [ ],
    "templates" : [ ],
    "text" : "Data Encrypted",
    "tooltip" : "Whether the data in question was encrypted. Data should not be considered encrypted if the encryption keys were also breached.",
    "type_id" : 0,
    "uuid" : "392851a9-1b28-4913-91cb-2915db7f9d6b",
    "values" : [ ]
  }, {
    "allow_default_value" : false,
    "blank_option" : false,
    "calculated" : false,
    "changeable" : true,
    "chosen" : false,
    "default_chosen_by_server" : false,
    "deprecated" : false,
    "export_key" : "incident/org_handle",
    "hide_notification" : false,
    "id" : 73,
    "input_type" : "select",
    "internal" : false,
    "is_tracked" : false,
    "name" : "org_handle",
    "operation_perms" : { },
    "operations" : [ ],
    "prefix" : null,
    "read_only" : true,
    "rich_text" : false,
    "tags" : [ ],
    "templates" : [ ],
    "text" : "Organization",
    "type_id" : 0,
    "uuid" : "3cff6aa4-b7a1-4f52-9109-69f75996edbd",
    "values" : [ ]
  }, {
    "allow_default_value" : false,
    "blank_option" : false,
    "calculated" : false,
    "changeable" : true,
    "chosen" : false,
    "default_chosen_by_server" : false,
    "deprecated" : false,
    "export_key" : "incident/impact_likely",
    "hide_notification" : false,
    "id" : 45,
    "input_type" : "boolean",
    "internal" : false,
    "is_tracked" : false,
    "name" : "impact_likely",
    "operation_perms" : { },
    "operations" : [ ],
    "prefix" : "pii",
    "read_only" : false,
    "rich_text" : false,
    "tags" : [ ],
    "templates" : [ ],
    "text" : "Impact Likely",
    "type_id" : 0,
    "uuid" : "4137fbca-9ec7-42e9-9e39-9ef61197cc9b",
    "values" : [ ]
  }, {
    "allow_default_value" : false,
    "blank_option" : false,
    "calculated" : false,
    "changeable" : true,
    "chosen" : false,
    "default_chosen_by_server" : false,
    "deprecated" : false,
    "export_key" : "incident/description",
    "hide_notification" : false,
    "id" : 15,
    "input_type" : "textarea",
    "internal" : false,
    "is_tracked" : false,
    "name" : "description",
    "operation_perms" : { },
    "operations" : [ ],
    "prefix" : null,
    "read_only" : false,
    "rich_text" : true,
    "tags" : [ ],
    "templates" : [ ],
    "text" : "Description",
    "tooltip" : "A free form text description of the incident.",
    "type_id" : 0,
    "uuid" : "420d70b1-98f9-4681-a20b-84f36a9e5e48",
    "values" : [ ]
  }, {
    "allow_default_value" : false,
    "blank_option" : true,
    "calculated" : false,
    "changeable" : true,
    "chosen" : false,
    "default_chosen_by_server" : false,
    "deprecated" : false,
    "export_key" : "incident/gdpr_harm_risk",
    "hide_notification" : false,
    "id" : 71,
    "input_type" : "select",
    "internal" : false,
    "is_tracked" : false,
    "name" : "gdpr_harm_risk",
    "operation_perms" : { },
    "operations" : [ ],
    "prefix" : "pii",
    "read_only" : false,
    "rich_text" : false,
    "tags" : [ ],
    "templates" : [ ],
    "text" : "Risk of Harm",
    "tooltip" : "Likelihood and severity of the risk to the rights and freedoms of the data subject, as defined by the GDPR.",
    "type_id" : 0,
    "uuid" : "43b88739-e201-460d-a2f3-ef2073f386d3",
    "values" : [ {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Low Risk",
      "properties" : null,
      "uuid" : "0c5a0656-e0df-422a-8fa3-78c5a79b472d",
      "value" : 11
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Risk",
      "properties" : null,
      "uuid" : "44f4b385-6c51-4ee3-aba8-79fb19a1b1bb",
      "value" : 12
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "High Risk",
      "properties" : null,
      "uuid" : "46306313-31c4-4549-9aa3-966b986429af",
      "value" : 13
    } ]
  }, {
    "allow_default_value" : false,
    "blank_option" : false,
    "calculated" : false,
    "changeable" : true,
    "chosen" : false,
    "default_chosen_by_server" : false,
    "deprecated" : false,
    "export_key" : "incident/id",
    "hide_notification" : true,
    "id" : 69,
    "input_type" : "number",
    "internal" : false,
    "is_tracked" : false,
    "name" : "id",
    "operation_perms" : { },
    "operations" : [ ],
    "prefix" : null,
    "read_only" : true,
    "rich_text" : false,
    "tags" : [ ],
    "templates" : [ ],
    "text" : "ID",
    "type_id" : 0,
    "uuid" : "44d6a6ac-886f-46ff-9683-90a13765862a",
    "values" : [ ]
  }, {
    "allow_default_value" : false,
    "blank_option" : false,
    "calculated" : false,
    "changeable" : true,
    "chosen" : false,
    "default_chosen_by_server" : false,
    "deprecated" : false,
    "export_key" : "incident/city",
    "hide_notification" : false,
    "id" : 7,
    "input_type" : "text",
    "internal" : false,
    "is_tracked" : false,
    "name" : "city",
    "operation_perms" : { },
    "operations" : [ ],
    "prefix" : null,
    "read_only" : false,
    "rich_text" : false,
    "tags" : [ ],
    "templates" : [ ],
    "text" : "City",
    "type_id" : 0,
    "uuid" : "488c24db-25a1-4cda-91d1-3865d3639732",
    "values" : [ ]
  }, {
    "allow_default_value" : false,
    "blank_option" : true,
    "calculated" : false,
    "changeable" : true,
    "chosen" : false,
    "default_chosen_by_server" : false,
    "deprecated" : false,
    "export_key" : "incident/pipeda_other_factors_comment",
    "hide_notification" : false,
    "id" : 25,
    "input_type" : "textarea",
    "internal" : false,
    "is_tracked" : false,
    "name" : "pipeda_other_factors_comment",
    "operation_perms" : { },
    "operations" : [ ],
    "prefix" : "regulator_risk",
    "read_only" : false,
    "rich_text" : false,
    "tags" : [ ],
    "templates" : [ ],
    "text" : "PIPEDA Other Factors Comment",
    "type_id" : 0,
    "uuid" : "4b493998-e1a3-447c-aa74-d3fa8b0bcfe3",
    "values" : [ ]
  }, {
    "allow_default_value" : false,
    "blank_option" : true,
    "calculated" : false,
    "changeable" : true,
    "chosen" : false,
    "default_chosen_by_server" : false,
    "deprecated" : false,
    "export_key" : "incident/resolution_id",
    "hide_notification" : false,
    "id" : 63,
    "input_type" : "select",
    "internal" : false,
    "is_tracked" : false,
    "name" : "resolution_id",
    "operation_perms" : { },
    "operations" : [ ],
    "prefix" : null,
    "read_only" : false,
    "required" : "close",
    "rich_text" : false,
    "tags" : [ ],
    "templates" : [ ],
    "text" : "Resolution",
    "tooltip" : "Select an option that accurately describes the reason for closing this incident.",
    "type_id" : 0,
    "uuid" : "4f9589d1-4828-4841-951e-16179198c518",
    "values" : [ {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Unresolved",
      "properties" : null,
      "uuid" : "9b7e136e-c79a-4481-9a93-175ce36d9778",
      "value" : 7
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Duplicate",
      "properties" : null,
      "uuid" : "5cf3ca21-0afe-40e3-9198-ba88ed7d26da",
      "value" : 8
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Not an Issue",
      "properties" : null,
      "uuid" : "e81e412c-96f7-4223-815c-64d1310c8bb7",
      "value" : 9
    }, {
      "default" : false,
      "enabled" : true,
      "hidden" : false,
      "label" : "Resolved",
      "properties" : null,
      "uuid" : "86ba01c3-aad7-4363-b170-085b7cbf8bc0",
      "value" : 10
    } ]
  }, {
    "allow_default_value" : false,
    "blank_option" : true,
    "calculated" : false,
    "changeable" : true,
    "chosen" : false,
    "default_chosen_by_server" : false,
    "deprecated" : false,
    "export_key" : "incident/gdpr_identification",
    "hide_notification" : false,
    "id" : 34,
    "input_type" : "select",
    "internal" : false,
    "is_tracked" : false,
    "name" : "gdpr_identification",
    "operation_perms" : { },
    "operations" : [ ],
    "prefix" : "gdpr",
    "read_only" : false,
    "rich_text" : false,
    "tags" : [ ],
    "templates" : [ ],
    "text" : "GDPR Identification",
    "type_id" : 0,
    "uuid" : "518e9d3a-d9d2-4211-af19-5c87049af157",
    "values" : [ ]
  }, {
    "allow_default_value" : false,
    "blank_option" : false,
    "calculated" : false,
    "changeable" : true,
    "chosen" : false,
    "default_chosen_by_server" : false,
    "deprecated" : false,
    "export_key" : "incident/gdpr_identification_comment",
    "hide_notification" : false,
    "id" : 35,
    "input_type" : "textarea",
    "internal" : false,
    "is_tracked" : false,
    "name" : "gdpr_identification_comment",
    "operation_perms" : { },
    "operations" : [ ],
    "prefix" : "gdpr",
    "read_only" : false,
    "rich_text" : false,
    "tags" : [ ],
    "templates" : [ ],
    "text" : "GDPR Identification Comment",
    "type_id" : 0,
    "uuid" : "519cf3ae-c02a-4197-a6f3-b944fe36052c",
    "values" : [ ]
  }, {
    "allow_default_value" : false,
    "blank_option" : false,
    "calculated" : false,
    "changeable" : true,
    "chosen" : false,
    "default_chosen_by_server" : false,
    "deprecated" : false,
    "export_key" : "incident/harmstatus_id",
    "hide_notification" : false,
    "id" : 56,
    "input_type" : "select",
    "internal" : false,
    "is_tracked" : false,
    "name" : "harmstatus_id",
    "operation_perms" : { },
    "operations" : [ ],
    "prefix" : "pii",
    "read_only" : false,
    "rich_text" : false,
    "tags" : [ ],
    "templates" : [ ],
    "text" : "Is harm/risk/misuse foreseeable?",
    "tooltip" : "Different jurisdictions use harm, risk, misuse, ID theft, and other standards as safe harbors from notification. Interpretation of these terms has frequently been the subject of litigation.",
    "type_id" : 0,
    "uuid" : "549e822b-37ac-43c0-8e93-ddcebf533189",
    "values" : [ ]
  }, {
    "allow_default_value" : false,
    "blank_option" : true,
    "calculated" : false,
    "changeable" : true,
    "chosen" : false,
    "default_chosen_by_server" : false,
    "deprecated" : false,
    "export_key" : "incident/gdpr_personal_data",
    "hide_notification" : false,
    "id" : 32,
    "input_type" : "select",
    "internal" : false,
    "is_tracked" : false,
    "name" : "gdpr_personal_data",
    "operation_perms" : { },
    "operations" : [ ],
    "prefix" : "gdpr",
    "read_only" : false,
    "rich_text" : false,
    "tags" : [ ],
    "templates" : [ ],
    "text" : "GDPR Personal Data",
    "type_id" : 0,
    "uuid" : "55066e35-1ec8-4466-954c-0a4386971a73",
    "values" : [ ]
  }, {
    "allow_default_value" : false,
    "blank_option" : false,
    "calculated" : false,
    "changeable" : true,
    "chosen" : false,
    "default_chosen_by_server" : false,
    "deprecated" : false,
    "export_key" : "incident/exposure_type_id",
    "hide_notification" : false,
    "id" : 5,
    "input_type" : "select",
    "internal" : false,
    "is_tracked" : false,
    "name" : "exposure_type_id",
    "operation_perms" : { },
    "operations" : [ ],
    "prefix" : null,
    "read_only" : false,
    "rich_text" : false,
    "tags" : [ ],
    "templates" : [ ],
    "text" : "Exposure Type",
    "tooltip" : "Origin source of the exposure",
    "type_id" : 0,
    "uuid" : "5d88cef9-ce77-4618-b946-e547607a777f",
    "values" : [ ]
  }, {
    "allow_default_value" : false,
    "blank_option" : false,
    "calculated" : false,
    "changeable" : true,
    "chosen" : true,
    "default_chosen_by_server" : false,
    "deprecated" : false,
    "export_key" : "incident/gdpr_breach_circumstances",
    "hide_notification" : false,
    "id" : 29,
    "input_type" : "multiselect",
    "internal" : false,
    "is_tracked" : false,
    "name" : "gdpr_breach_circumstances",
    "operation_perms" : { },
    "operations" : [ ],
    "prefix" : "gdpr",
    "read_only" : false,
    "rich_text" : false,
    "tags" : [ ],
    "templates" : [ ],
    "text" : "GDPR Breach Circumstances",
    "type_id" : 0,
    "uuid" : "5fb35a45-855f-4acc-8cea-c3d620094c2d",
    "values" : [ ]
  }, {
    "allow_default_value" : false,
    "blank_option" : false,
    "calculated" : false,
    "changeable" : true,
    "chosen" : true,
    "default_chosen_by_server" : false,
    "deprecated" : false,
    "export_key" : "incident/jurisdiction_name",
    "hide_notification" : false,
    "id" : 1,
    "input_type" : "text",
    "internal" : false,
    "is_tracked" : false,
    "name" : "jurisdiction_name",
    "operation_perms" : { },
    "operations" : [ ],
    "prefix" : null,
    "read_only" : false,
    "rich_text" : false,
    "tags" : [ ],
    "templates" : [ ],
    "text" : "Jurisdiction",
    "type_id" : 0,
    "uuid" : "658354fe-3bcd-429e-aa08-5998799cc6d2",
    "values" : [ ]
  }, {
    "allow_default_value" : false,
    "blank_option" : true,
    "calculated" : false,
    "changeable" : true,
    "chosen" : false,
    "default_chosen_by_server" : false,
    "deprecated" : false,
    "export_key" : "incident/pipeda_sensitivity_of_pi_comment",
    "hide_notification" : false,
    "id" : 21,
    "input_type" : "textarea",
    "internal" : false,
    "is_tracked" : false,
    "name" : "pipeda_sensitivity_of_pi_comment",
    "operation_perms" : { },
    "operations" : [ ],
    "prefix" : "regulator_risk",
    "read_only" : false,
    "rich_text" : false,
    "tags" : [ ],
    "templates" : [ ],
    "text" : "PIPEDA Sensitivity of PI Comment",
    "type_id" : 0,
    "uuid" : "65beb4ea-420e-40e3-b43a-37dee8c1675d",
    "values" : [ ]
  }, {
    "allow_default_value" : false,
    "blank_option" : false,
    "calculated" : false,
    "changeable" : true,
    "chosen" : false,
    "default_chosen_by_server" : false,
    "deprecated" : false,
    "export_key" : "incident/ny_impact_likely",
    "hide_notification" : false,
    "id" : 46,
    "input_type" : "boolean",
    "internal" : false,
    "is_tracked" : false,
    "name" : "ny_impact_likely",
    "operation_perms" : { },
    "operations" : [ ],
    "prefix" : "pii",
    "read_only" : false,
    "rich_text" : false,
    "tags" : [ ],
    "templates" : [ ],
    "text" : "Impact Likely for New York",
    "type_id" : 0,
    "uuid" : "688a9bc2-cd38-4a45-b7ff-9344b76597fb",
    "values" : [ ]
  }, {
    "allow_default_value" : false,
    "blank_option" : true,
    "calculated" : false,
    "changeable" : true,
    "chosen" : false,
    "default_chosen_by_server" : false,
    "deprecated" : false,
    "export_key" : "incident/pipeda_overall_assessment_comment",
    "hide_notification" : false,
    "id" : 27,
    "input_type" : "textarea",
    "internal" : false,
    "is_tracked" : false,
    "name" : "pipeda_overall_assessment_comment",
    "operation_perms" : { },
    "operations" : [ ],
    "prefix" : "regulator_risk",
    "read_only" : false,
    "rich_text" : false,
    "tags" : [ ],
    "templates" : [ ],
    "text" : "PIPEDA Overall Assessment Comment",
    "type_id" : 0,
    "uuid" : "69fca6b3-c00c-496a-a333-123513ef89e6",
    "values" : [ ]
  }, {
    "allow_default_value" : false,
    "blank_option" : false,
    "calculated" : false,
    "changeable" : true,
    "chosen" : false,
    "default_chosen_by_server" : false,
    "deprecated" : false,
    "export_key" : "incident/alberta_health_risk_assessment",
    "hide_notification" : false,
    "id" : 41,
    "input_type" : "boolean",
    "internal" : false,
    "is_tracked" : false,
    "name" : "alberta_health_risk_assessment",
    "operation_perms" : { },
    "operations" : [ ],
    "prefix" : "pii",
    "read_only" : false,
    "rich_text" : false,
    "tags" : [ ],
    "templates" : [ ],
    "text" : "Alberta Health Risk Assessment",
    "type_id" : 0,
    "uuid" : "6dd01276-c322-4095-b33c-15d3b33c3540",
    "values" : [ ]
  }, {
    "allow_default_value" : false,
    "blank_option" : false,
    "calculated" : false,
    "changeable" : true,
    "chosen" : true,
    "default_chosen_by_server" : false,
    "deprecated" : false,
    "export_key" : "incident/nist_attack_vectors",
    "hide_notification" : false,
    "id" : 2,
    "input_type" : "multiselect",
    "internal" : false,
    "is_tracked" : false,
    "name" : "nist_attack_vectors",
    "operation_perms" : { },
    "operations" : [ ],
    "placeholder" : "Choose Applicable Vectors",
    "prefix" : null,
    "read_only" : false,
    "rich_text" : false,
    "tags" : [ ],
    "templates" : [ ],
    "text" : "NIST Attack Vectors",
    "tooltip" : "NIST Attack Vectors the incident falls under, if applicable.",
    "type_id" : 0,
    "uuid" : "6fd423e6-2817-407f-b950-f66cb2e58d2c",
    "values" : [ ]
  }, {
    "allow_default_value" : false,
    "blank_option" : false,
    "calculated" : false,
    "changeable" : true,
    "chosen" : false,
    "default_chosen_by_server" : false,
    "deprecated" : false,
    "export_key" : "incident/end_date",
    "hide_notification" : false,
    "id" : 67,
    "input_type" : "datetimepicker",
    "internal" : false,
    "is_tracked" : false,
    "name" : "end_date",
    "operation_perms" : { },
    "operations" : [ ],
    "prefix" : null,
    "read_only" : true,
    "rich_text" : false,
    "tags" : [ ],
    "templates" : [ ],
    "text" : "Date Closed",
    "tooltip" : "The date the incident was closed. This field is read-only.",
    "type_id" : 0,
    "uuid" : "719d52c7-42a5-4cd6-8ce5-e8cf9317d2d1",
    "values" : [ ]
  }, {
    "allow_default_value" : false,
    "blank_option" : false,
    "calculated" : false,
    "changeable" : true,
    "chosen" : false,
    "default_chosen_by_server" : false,
    "deprecated" : false,
    "export_key" : "incident/hard_liability",
    "hide_notification" : false,
    "id" : 18,
    "input_type" : "number",
    "internal" : false,
    "is_tracked" : false,
    "name" : "hard_liability",
    "operation_perms" : { },
    "operations" : [ ],
    "prefix" : null,
    "read_only" : true,
    "rich_text" : false,
    "tags" : [ ],
    "templates" : [ ],
    "text" : "Assessed Liability",
    "type_id" : 0,
    "uuid" : "72c2c73f-620a-4bb6-900a-705a0bdf912d",
    "values" : [ ]
  }, {
    "allow_default_value" : false,
    "blank_option" : false,
    "calculated" : false,
    "changeable" : true,
    "chosen" : false,
    "default_chosen_by_server" : false,
    "deprecated" : false,
    "export_key" : "incident/gdpr_breach_type_comment",
    "hide_notification" : false,
    "id" : 31,
    "input_type" : "textarea",
    "internal" : false,
    "is_tracked" : false,
    "name" : "gdpr_breach_type_comment",
    "operation_perms" : { },
    "operations" : [ ],
    "prefix" : "gdpr",
    "read_only" : false,
    "rich_text" : false,
    "tags" : [ ],
    "templates" : [ ],
    "text" : "GDPR Breach Type Comment",
    "type_id" : 0,
    "uuid" : "7354ee21-c548-44de-b179-2d45f119f228",
    "values" : [ ]
  }, {
    "allow_default_value" : false,
    "blank_option" : false,
    "calculated" : false,
    "changeable" : true,
    "chosen" : false,
    "default_chosen_by_server" : false,
    "deprecated" : false,
    "export_key" : "incident/sequence_code",
    "hide_notification" : false,
    "id" : 74,
    "input_type" : "text",
    "internal" : false,
    "is_tracked" : false,
    "name" : "sequence_code",
    "operation_perms" : { },
    "operations" : [ ],
    "prefix" : null,
    "read_only" : true,
    "rich_text" : false,
    "tags" : [ ],
    "templates" : [ ],
    "text" : "Sequence Code",
    "tooltip" : "The Unique Incident Sequence Code.",
    "type_id" : 0,
    "uuid" : "7662e73c-9e92-11e9-bd1f-2745873db71d",
    "values" : [ ]
  }, {
    "allow_default_value" : false,
    "blank_option" : false,
    "calculated" : false,
    "changeable" : true,
    "chosen" : false,
    "default_chosen_by_server" : false,
    "deprecated" : false,
    "export_key" : "incident/exposure_individual_name",
    "hide_notification" : false,
    "id" : 54,
    "input_type" : "text",
    "internal" : false,
    "is_tracked" : false,
    "name" : "exposure_individual_name",
    "operation_perms" : { },
    "operations" : [ ],
    "placeholder" : "Employee name",
    "prefix" : null,
    "read_only" : false,
    "rich_text" : false,
    "tags" : [ ],
    "templates" : [ ],
    "text" : "Individual Name",
    "type_id" : 0,
    "uuid" : "77618fd8-ecd9-40e5-b86f-b42eee53498f",
    "values" : [ ]
  }, {
    "allow_default_value" : false,
    "blank_option" : false,
    "calculated" : false,
    "changeable" : true,
    "chosen" : false,
    "default_chosen_by_server" : false,
    "deprecated" : false,
    "export_key" : "incident/gdpr_personal_data_comment",
    "hide_notification" : false,
    "id" : 33,
    "input_type" : "textarea",
    "internal" : false,
    "is_tracked" : false,
    "name" : "gdpr_personal_data_comment",
    "operation_perms" : { },
    "operations" : [ ],
    "prefix" : "gdpr",
    "read_only" : false,
    "rich_text" : false,
    "tags" : [ ],
    "templates" : [ ],
    "text" : "GDPR Personal Data Comment",
    "type_id" : 0,
    "uuid" : "77b2b8cb-ed5c-427f-a9cc-161b13859cbb",
    "values" : [ ]
  }, {
    "allow_default_value" : false,
    "blank_option" : false,
    "calculated" : false,
    "changeable" : true,
    "chosen" : false,
    "default_chosen_by_server" : false,
    "deprecated" : false,
    "export_key" : "incident/wa_impact_likely",
    "hide_notification" : false,
    "id" : 48,
    "input_type" : "boolean",
    "internal" : false,
    "is_tracked" : false,
    "name" : "wa_impact_likely",
    "operation_perms" : { },
    "operations" : [ ],
    "prefix" : "pii",
    "read_only" : false,
    "rich_text" : false,
    "tags" : [ ],
    "templates" : [ ],
    "text" : "Impact Likely for Washington",
    "type_id" : 0,
    "uuid" : "7808b829-23a1-4d99-987c-701602a05069",
    "values" : [ ]
  }, {
    "allow_default_value" : false,
    "blank_option" : false,
    "calculated" : false,
    "changeable" : true,
    "chosen" : false,
    "default_chosen_by_server" : false,
    "deprecated" : false,
    "export_key" : "incident/data_compromised",
    "hide_notification" : false,
    "id" : 3,
    "input_type" : "boolean",
    "internal" : false,
    "is_tracked" : false,
    "name" : "data_compromised",
    "operation_perms" : { },
    "operations" : [ ],
    "prefix" : "pii",
    "read_only" : false,
    "rich_text" : false,
    "tags" : [ ],
    "templates" : [ ],
    "text" : "Was personal information or personal data involved?",
    "tooltip" : "Determine whether personal information/data was foreseeably involved, disclosed, compromised, accessed, altered, destroyed, damaged, lost or inaccessible.",
    "type_id" : 0,
    "uuid" : "793e1363-79f5-45af-91e2-0e93356cad82",
    "values" : [ ]
  } ],
  "functions" : [ {
    "created_date" : 1644407280245,
    "creator" : {
      "display_name" : "Admin User",
      "id" : 1,
      "name" : "admin@example.com",
      "type" : "user"
    },
    "description" : {
      "format" : "text",
      "content" : "A mock description of 'A Mock Function with No Unicode Characters in Name' with unicode:  ล ฦ ว ศ ษ ส ห ฬ อ"
    },
    "destination_handle" : "fn_main_mock_integration",
    "display_name" : "A Mock Function with :: No Unicode Characters !@#$%^&*())))in Name",
    "export_key" : "a_mock_function_with_no_unicode_characters_in_name",
    "id" : 1,
    "last_modified_by" : {
      "display_name" : "Admin User",
      "id" : 1,
      "name" : "admin@example.com",
      "type" : "user"
    },
    "last_modified_time" : 1644407280288,
    "name" : "a_mock_function_with_no_unicode_characters_in_name",
    "tags" : [ {
      "tag_handle" : "fn_main_mock_integration",
      "value" : null
    } ],
    "uuid" : "acd10fc9-9c81-456b-a141-bb0c2279a721",
    "version" : 1,
    "view_items" : [ {
      "content" : "e40b9d9e-7ca1-45bc-913b-ce2a77e9b687",
      "element" : "field_uuid",
      "field_type" : "__function",
      "show_if" : null,
      "show_link_header" : false,
      "step_label" : null
    } ],
    "workflows" : [ ]
  }, {
    "created_date" : 1644407280308,
    "creator" : {
      "display_name" : "Admin User",
      "id" : 1,
      "name" : "admin@example.com",
      "type" : "user"
    },
    "description" : {
      "format" : "text",
      "content" : "mock function ล ฦ ว ศ ษ ส ห ฬ อ three description"
    },
    "destination_handle" : "fn_main_mock_integration",
    "display_name" : "mock function ล three",
    "export_key" : "mock_function__three",
    "id" : 2,
    "last_modified_by" : {
      "display_name" : "Admin User",
      "id" : 1,
      "name" : "admin@example.com",
      "type" : "user"
    },
    "last_modified_time" : 1644407280344,
    "name" : "mock_function__three",
    "tags" : [ {
      "tag_handle" : "fn_main_mock_integration",
      "value" : null
    } ],
    "uuid" : "0c7fd5a3-b67f-47f5-bda4-76ff3f60dd69",
    "version" : 1,
    "view_items" : [ {
      "content" : "df7df8ba-cb65-4400-8290-070b155d28d4",
      "element" : "field_uuid",
      "field_type" : "__function",
      "show_if" : null,
      "show_link_header" : false,
      "step_label" : null
    } ],
    "workflows" : [ ]
  }, {
    "created_date" : 1644407280362,
    "creator" : {
      "display_name" : "Admin User",
      "id" : 1,
      "name" : "admin@example.com",
      "type" : "user"
    },
    "description" : {
      "format" : "text",
      "content" : "A mock description of mock_function_one with unicode:  ล ฦ ว ศ ษ ส ห ฬ อ"
    },
    "destination_handle" : "fn_main_mock_integration",
    "display_name" : "mock_function_one",
    "export_key" : "mock_function_one",
    "id" : 3,
    "last_modified_by" : {
      "display_name" : "Admin User",
      "id" : 1,
      "name" : "admin@example.com",
      "type" : "user"
    },
    "last_modified_time" : 1644407372681,
    "name" : "mock_function_one",
    "tags" : [ {
      "tag_handle" : "fn_main_mock_integration",
      "value" : null
    } ],
    "uuid" : "9b180887-4ff6-4d13-82a6-cb0a5d8718f1",
    "version" : 2,
    "view_items" : [ {
      "content" : "01147ebf-ce3d-4cfb-814b-16145af4e511",
      "element" : "field_uuid",
      "field_type" : "__function",
      "show_if" : null,
      "show_link_header" : false,
      "step_label" : null
    }, {
      "content" : "92eb3b7a-8859-4846-81a3-2995aec74bdb",
      "element" : "field_uuid",
      "field_type" : "__function",
      "show_if" : null,
      "show_link_header" : false,
      "step_label" : null
    }, {
      "content" : "49f10172-309a-4829-a5fe-1de71cdb4efb",
      "element" : "field_uuid",
      "field_type" : "__function",
      "show_if" : null,
      "show_link_header" : false,
      "step_label" : null
    }, {
      "content" : "e40b9d9e-7ca1-45bc-913b-ce2a77e9b687",
      "element" : "field_uuid",
      "field_type" : "__function",
      "show_if" : null,
      "show_link_header" : false,
      "step_label" : null
    }, {
      "content" : "866625eb-8b46-4cc9-b713-cdfa548a1189",
      "element" : "field_uuid",
      "field_type" : "__function",
      "show_if" : null,
      "show_link_header" : false,
      "step_label" : null
    }, {
      "content" : "b6dfde6d-7516-4509-a5a2-54e72df9e0cd",
      "element" : "field_uuid",
      "field_type" : "__function",
      "show_if" : null,
      "show_link_header" : false,
      "step_label" : null
    }, {
      "content" : "df7df8ba-cb65-4400-8290-070b155d28d4",
      "element" : "field_uuid",
      "field_type" : "__function",
      "show_if" : null,
      "show_link_header" : false,
      "step_label" : null
    }, {
      "content" : "69dc0e78-a74b-4ccc-8d82-33b51780a569",
      "element" : "field_uuid",
      "field_type" : "__function",
      "show_if" : null,
      "show_link_header" : false,
      "step_label" : null
    } ],
    "workflows" : [ {
      "actions" : [ ],
      "description" : null,
      "name" : "mock workflow  ล ฦ ว ศ ษ ส ห ฬ อ two",
      "object_type" : "artifact",
      "programmatic_name" : "mock_workflow_two",
      "tags" : [ {
        "tag_handle" : "fn_main_mock_integration",
        "value" : null
      } ],
      "uuid" : null,
      "workflow_id" : 1
    }, {
      "actions" : [ ],
      "description" : null,
      "name" : "Mock Workflow One",
      "object_type" : "incident",
      "programmatic_name" : "mock_workflow_one",
      "tags" : [ {
        "tag_handle" : "fn_main_mock_integration",
        "value" : null
      } ],
      "uuid" : null,
      "workflow_id" : 2
    } ]
  }, {
    "created_date" : 1644407280417,
    "creator" : {
      "display_name" : "Admin User",
      "id" : 1,
      "name" : "admin@example.com",
      "type" : "user"
    },
    "description" : {
      "format" : "text",
      "content" : "a  ล ฦ ว ศ ษ ส ห ฬ อ description of  ล ฦ ว ศ ษ ส ห ฬ อ mock function two"
    },
    "destination_handle" : "fn_main_mock_integration",
    "display_name" : "mock function  ล ฦ ว ศ ษ ส ห ฬ อ two",
    "export_key" : "mock_function_two",
    "id" : 4,
    "last_modified_by" : {
      "display_name" : "Admin User",
      "id" : 1,
      "name" : "admin@example.com",
      "type" : "user"
    },
    "last_modified_time" : 1644407280449,
    "name" : "mock_function_two",
    "tags" : [ {
      "tag_handle" : "fn_main_mock_integration",
      "value" : null
    } ],
    "uuid" : "90be4dd8-59a0-4791-82e9-df5d7e86edcb",
    "version" : 1,
    "view_items" : [ {
      "content" : "df7df8ba-cb65-4400-8290-070b155d28d4",
      "element" : "field_uuid",
      "field_type" : "__function",
      "show_if" : null,
      "show_link_header" : false,
      "step_label" : null
    }, {
      "content" : "49f10172-309a-4829-a5fe-1de71cdb4efb",
      "element" : "field_uuid",
      "field_type" : "__function",
      "show_if" : null,
      "show_link_header" : false,
      "step_label" : null
    }, {
      "content" : "e40b9d9e-7ca1-45bc-913b-ce2a77e9b687",
      "element" : "field_uuid",
      "field_type" : "__function",
      "show_if" : null,
      "show_link_header" : false,
      "step_label" : null
    } ],
    "workflows" : [ {
      "actions" : [ ],
      "description" : null,
      "name" : "mock workflow  ล ฦ ว ศ ษ ส ห ฬ อ two",
      "object_type" : "artifact",
      "programmatic_name" : "mock_workflow_two",
      "tags" : [ {
        "tag_handle" : "fn_main_mock_integration",
        "value" : null
      } ],
      "uuid" : null,
      "workflow_id" : 1
    } ]
  } ],
  "geos" : null,
  "groups" : null,
  "id" : 1,
  "inbound_destinations" : [ ],
  "inbound_mailboxes" : null,
  "incident_artifact_types" : [ {
    "default_scan_option" : "on",
    "desc" : "Suspicious DNS name",
    "enabled" : true,
    "export_key" : "DNS Name",
    "file" : false,
    "id" : 0,
    "multi_aware" : true,
    "name" : "DNS Name",
    "parse_as_csv" : false,
    "programmatic_name" : "DNS Name",
    "reg_exp" : "[_a-zA-Z0-9\\-.]+",
    "system" : true,
    "tags" : [ ],
    "use_for_relationships" : true,
    "uuid" : "5b48edb6-786b-46b8-a619-3da03a8adb0d",
    "version" : 1
  }, {
    "default_scan_option" : "unsupported",
    "desc" : "Suspicious email attachment",
    "enabled" : true,
    "export_key" : "Email Attachment",
    "file" : true,
    "id" : 0,
    "multi_aware" : false,
    "name" : "Email Attachment",
    "parse_as_csv" : false,
    "programmatic_name" : "Email Attachment",
    "reg_exp" : null,
    "system" : true,
    "tags" : [ ],
    "use_for_relationships" : true,
    "uuid" : "310e4f8d-1a55-4cea-b28e-2aa73c1758c5",
    "version" : 0
  }, {
    "default_scan_option" : "on",
    "desc" : "Suspicious email attachment name",
    "enabled" : true,
    "export_key" : "Email Attachment Name",
    "file" : false,
    "id" : 0,
    "multi_aware" : false,
    "name" : "Email Attachment Name",
    "parse_as_csv" : false,
    "programmatic_name" : "Email Attachment Name",
    "reg_exp" : null,
    "system" : true,
    "tags" : [ ],
    "use_for_relationships" : true,
    "uuid" : "1a085796-7dd9-4e68-b689-32ea6d6c2c42",
    "version" : 0
  }, {
    "default_scan_option" : "unsupported",
    "desc" : "Suspicious email body",
    "enabled" : true,
    "export_key" : "Email Body",
    "file" : false,
    "id" : 0,
    "multi_aware" : false,
    "name" : "Email Body",
    "parse_as_csv" : false,
    "programmatic_name" : "Email Body",
    "reg_exp" : null,
    "system" : true,
    "tags" : [ ],
    "use_for_relationships" : true,
    "uuid" : "a8f07db2-65d3-4f81-b0d1-c0d564af84ff",
    "version" : 0
  }, {
    "default_scan_option" : "on",
    "desc" : "Suspicious email recipient",
    "enabled" : true,
    "export_key" : "Email Recipient",
    "file" : false,
    "id" : 0,
    "multi_aware" : false,
    "name" : "Email Recipient",
    "parse_as_csv" : false,
    "programmatic_name" : "Email Recipient",
    "reg_exp" : null,
    "system" : true,
    "tags" : [ ],
    "use_for_relationships" : true,
    "uuid" : "3517c291-ab54-4c23-b55d-b677b2d9be2f",
    "version" : 0
  }, {
    "default_scan_option" : "on",
    "desc" : "Suspicious email sender",
    "enabled" : true,
    "export_key" : "Email Sender",
    "file" : false,
    "id" : 0,
    "multi_aware" : false,
    "name" : "Email Sender",
    "parse_as_csv" : false,
    "programmatic_name" : "Email Sender",
    "reg_exp" : null,
    "system" : true,
    "tags" : [ ],
    "use_for_relationships" : true,
    "uuid" : "94def29c-cf7e-4bd6-af96-d1e14133de67",
    "version" : 0
  }, {
    "default_scan_option" : "on",
    "desc" : "Name of suspicious email sender",
    "enabled" : true,
    "export_key" : "Email Sender Name",
    "file" : false,
    "id" : 0,
    "multi_aware" : false,
    "name" : "Email Sender Name",
    "parse_as_csv" : false,
    "programmatic_name" : "Email Sender Name",
    "reg_exp" : null,
    "system" : true,
    "tags" : [ ],
    "use_for_relationships" : true,
    "uuid" : "9b9d155f-2459-4724-9cb3-dc64f9347b41",
    "version" : 0
  }, {
    "default_scan_option" : "on",
    "desc" : "Suspicious email subject",
    "enabled" : true,
    "export_key" : "Email Subject",
    "file" : false,
    "id" : 0,
    "multi_aware" : false,
    "name" : "Email Subject",
    "parse_as_csv" : false,
    "programmatic_name" : "Email Subject",
    "reg_exp" : null,
    "system" : true,
    "tags" : [ ],
    "use_for_relationships" : true,
    "uuid" : "9423920e-aaa4-469a-8b19-c60c081e25a1",
    "version" : 0
  }, {
    "default_scan_option" : "on",
    "desc" : "Name of a suspect file",
    "enabled" : true,
    "export_key" : "File Name",
    "file" : false,
    "id" : 0,
    "multi_aware" : false,
    "name" : "File Name",
    "parse_as_csv" : false,
    "programmatic_name" : "File Name",
    "reg_exp" : null,
    "system" : true,
    "tags" : [ ],
    "use_for_relationships" : true,
    "uuid" : "7cea41a7-d0e0-4f3a-922a-f8bb2dec5918",
    "version" : 0
  }, {
    "default_scan_option" : "unsupported",
    "desc" : "A full path name; for example: C:\\dir\\evil.com",
    "enabled" : true,
    "export_key" : "File Path",
    "file" : false,
    "id" : 0,
    "multi_aware" : false,
    "name" : "File Path",
    "parse_as_csv" : false,
    "programmatic_name" : "File Path",
    "reg_exp" : null,
    "system" : true,
    "tags" : [ ],
    "use_for_relationships" : true,
    "uuid" : "2146c562-af15-4f18-9951-41221327738c",
    "version" : 0
  }, {
    "default_scan_option" : "unsupported",
    "desc" : "A general HTTP request header",
    "enabled" : true,
    "export_key" : "HTTP Request Header",
    "file" : false,
    "id" : 0,
    "multi_aware" : true,
    "name" : "HTTP Request Header",
    "parse_as_csv" : false,
    "programmatic_name" : "HTTP Request Header",
    "reg_exp" : "[^:]*:.*",
    "split_on" : "\r?\n",
    "system" : true,
    "tags" : [ ],
    "use_for_relationships" : true,
    "uuid" : "0c7addee-88ef-4c7a-a648-57864fdd75b9",
    "version" : 0
  }, {
    "default_scan_option" : "unsupported",
    "desc" : "A general HTTP response header",
    "enabled" : true,
    "export_key" : "HTTP Response Header",
    "file" : false,
    "id" : 0,
    "multi_aware" : true,
    "name" : "HTTP Response Header",
    "parse_as_csv" : false,
    "programmatic_name" : "HTTP Response Header",
    "reg_exp" : "[^:]*:.*",
    "split_on" : "\r?\n",
    "system" : true,
    "tags" : [ ],
    "use_for_relationships" : true,
    "uuid" : "7e91455b-0c82-433f-a6ea-55f159cc67a8",
    "version" : 0
  }, {
    "default_scan_option" : "on",
    "desc" : "Suspicious IP Address",
    "enabled" : true,
    "export_key" : "IP Address",
    "file" : false,
    "id" : 0,
    "multi_aware" : true,
    "name" : "IP Address",
    "parse_as_csv" : false,
    "programmatic_name" : "IP Address",
    "reg_exp" : "((^\\s*((0*([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\\.){3}0*([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5]))\\s*$)|(^\\s*((([0-9A-Fa-f]{1,4}:){7}([0-9A-Fa-f]{1,4}|:))|(([0-9A-Fa-f]{1,4}:){6}(:[0-9A-Fa-f]{1,4}|((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){5}(((:[0-9A-Fa-f]{1,4}){1,2})|:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){4}(((:[0-9A-Fa-f]{1,4}){1,3})|((:[0-9A-Fa-f]{1,4})?:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){3}(((:[0-9A-Fa-f]{1,4}){1,4})|((:[0-9A-Fa-f]{1,4}){0,2}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){2}(((:[0-9A-Fa-f]{1,4}){1,5})|((:[0-9A-Fa-f]{1,4}){0,3}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){1}(((:[0-9A-Fa-f]{1,4}){1,6})|((:[0-9A-Fa-f]{1,4}){0,4}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(:(((:[0-9A-Fa-f]{1,4}){1,7})|((:[0-9A-Fa-f]{1,4}){0,5}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:)))(%.+)?\\s*$))",
    "system" : true,
    "tags" : [ ],
    "use_for_relationships" : true,
    "uuid" : "cfd8139b-e238-4447-b857-6f1047ddbac3",
    "version" : 0
  }, {
    "default_scan_option" : "unsupported",
    "desc" : "File that contains log information",
    "enabled" : true,
    "export_key" : "Log File",
    "file" : true,
    "id" : 0,
    "multi_aware" : false,
    "name" : "Log File",
    "parse_as_csv" : false,
    "programmatic_name" : "Log File",
    "reg_exp" : null,
    "system" : true,
    "tags" : [ ],
    "use_for_relationships" : true,
    "uuid" : "e3e2b702-31f5-4a6c-a1c7-83da91d5f47d",
    "version" : 0
  }, {
    "default_scan_option" : "unsupported",
    "desc" : "A unique identifier assigned to network interfaces for communications on the physical network segment",
    "enabled" : true,
    "export_key" : "MAC Address",
    "file" : false,
    "id" : 0,
    "multi_aware" : true,
    "name" : "MAC Address",
    "parse_as_csv" : false,
    "programmatic_name" : "MAC Address",
    "reg_exp" : "([0-9A-Fa-f]{2}[:-]){5}(?:([0-9A-Fa-f]{2}[:-]){2})?([0-9A-Fa-f]{2})|[0-9A-Fa-f]{4}(\\.[0-9A-Fa-f]{4}){2}",
    "system" : true,
    "tags" : [ ],
    "use_for_relationships" : true,
    "uuid" : "9d08fbd9-e3b8-46c3-974c-9ffcc215232c",
    "version" : 0
  }, {
    "default_scan_option" : "unsupported",
    "desc" : "The malware's family or variant",
    "enabled" : true,
    "export_key" : "Malware Family/Variant",
    "file" : false,
    "id" : 0,
    "multi_aware" : false,
    "name" : "Malware Family/Variant",
    "parse_as_csv" : false,
    "programmatic_name" : "Malware Family/Variant",
    "reg_exp" : null,
    "system" : true,
    "tags" : [ ],
    "use_for_relationships" : true,
    "uuid" : "0e28d76d-14cc-45bb-afc8-871753f455f3",
    "version" : 0
  }, {
    "default_scan_option" : "on",
    "desc" : "MD5 hash of potential malware file",
    "enabled" : true,
    "export_key" : "Malware MD5 Hash",
    "file" : false,
    "id" : 0,
    "multi_aware" : false,
    "name" : "Malware MD5 Hash",
    "parse_as_csv" : false,
    "programmatic_name" : "Malware MD5 Hash",
    "reg_exp" : "(0x)?[a-fA-F0-9]{32}",
    "system" : true,
    "tags" : [ ],
    "use_for_relationships" : true,
    "uuid" : "b3c08b46-52a7-4e6f-8d6d-d999350252a6",
    "version" : 0
  }, {
    "default_scan_option" : "on",
    "desc" : "File that contains potential malware",
    "enabled" : true,
    "export_key" : "Malware Sample",
    "file" : true,
    "id" : 0,
    "multi_aware" : false,
    "name" : "Malware Sample",
    "parse_as_csv" : false,
    "programmatic_name" : "Malware Sample",
    "reg_exp" : null,
    "system" : true,
    "tags" : [ ],
    "use_for_relationships" : true,
    "uuid" : "c97dee7e-4098-46fe-866e-5d67ea7eb17a",
    "version" : 0
  }, {
    "default_scan_option" : "on",
    "desc" : "Fuzzy hash of a malware sample",
    "enabled" : true,
    "export_key" : "Malware Sample Fuzzy Hash",
    "file" : false,
    "id" : 0,
    "multi_aware" : false,
    "name" : "Malware Sample Fuzzy Hash",
    "parse_as_csv" : false,
    "programmatic_name" : "Malware Sample Fuzzy Hash",
    "reg_exp" : null,
    "system" : true,
    "tags" : [ ],
    "use_for_relationships" : true,
    "uuid" : "8bd99af1-6434-4c80-bdfc-4a4f9c22fef0",
    "version" : 0
  }, {
    "default_scan_option" : "on",
    "desc" : "SHA-1 hash of potential malware file",
    "enabled" : true,
    "export_key" : "Malware SHA-1 Hash",
    "file" : false,
    "id" : 0,
    "multi_aware" : false,
    "name" : "Malware SHA-1 Hash",
    "parse_as_csv" : false,
    "programmatic_name" : "Malware SHA-1 Hash",
    "reg_exp" : "(0x)?[a-fA-F0-9]{40}",
    "system" : true,
    "tags" : [ ],
    "use_for_relationships" : true,
    "uuid" : "961f185a-76aa-46e5-8c05-83246c860be7",
    "version" : 0
  }, {
    "default_scan_option" : "on",
    "desc" : "SHA-256 hash of potential malware file",
    "enabled" : true,
    "export_key" : "Malware SHA-256 Hash",
    "file" : false,
    "id" : 0,
    "multi_aware" : false,
    "name" : "Malware SHA-256 Hash",
    "parse_as_csv" : false,
    "programmatic_name" : "Malware SHA-256 Hash",
    "reg_exp" : "(0x)?[a-fA-F0-9]{64}",
    "system" : true,
    "tags" : [ ],
    "use_for_relationships" : true,
    "uuid" : "bc24bc52-eca2-4cd1-9488-2818fc0aa5e9",
    "version" : 0
  }, {
    "default_scan_option" : "unsupported",
    "desc" : "㌎ ㌏ ㌐ ㌑ ㌒ ㌓ ㌔ ㌕ ㌖ ㌎ ㌏ ㌐ ㌑ ㌒ ㌓ ㌔ ㌕ ㌖asdf ㌎ ㌏ ㌐ ㌑ ㌒ ㌓ ㌔ ㌕ ㌖",
    "enabled" : true,
    "export_key" : "mock_artifact_2",
    "file" : false,
    "id" : 0,
    "multi_aware" : true,
    "name" : "Mock Artifact 2 ㌎ ㌏ ㌐ ㌑ ㌒ ㌓ ㌔ ㌕ ㌖",
    "parse_as_csv" : false,
    "programmatic_name" : "mock_artifact_2",
    "reg_exp" : null,
    "system" : false,
    "tags" : [ {
      "tag_handle" : "fn_main_mock_integration",
      "value" : null
    } ],
    "use_for_relationships" : true,
    "uuid" : "0405a242-872b-4d85-9e79-70a26a9d7462",
    "version" : 0
  }, {
    "default_scan_option" : "unsupported",
    "desc" : "A mock description of this Artifact type",
    "enabled" : true,
    "export_key" : "mock_artifact_type_one",
    "file" : false,
    "id" : 0,
    "multi_aware" : true,
    "name" : "Mock Artifact Type One",
    "parse_as_csv" : false,
    "programmatic_name" : "mock_artifact_type_one",
    "reg_exp" : null,
    "system" : false,
    "tags" : [ {
      "tag_handle" : "fn_main_mock_integration",
      "value" : null
    } ],
    "use_for_relationships" : true,
    "uuid" : "1997c7d5-7c81-49f0-91d3-b0b6cb190ca3",
    "version" : 0
  }, {
    "default_scan_option" : "on",
    "desc" : "A mutex name",
    "enabled" : true,
    "export_key" : "Mutex",
    "file" : false,
    "id" : 0,
    "multi_aware" : false,
    "name" : "Mutex",
    "parse_as_csv" : false,
    "programmatic_name" : "Mutex",
    "reg_exp" : null,
    "system" : true,
    "tags" : [ ],
    "use_for_relationships" : true,
    "uuid" : "433ea6b1-a30a-4738-9ee6-5c29c84c7d63",
    "version" : 0
  }, {
    "default_scan_option" : "unsupported",
    "desc" : "A block of IP addresses sharing the same initial bits",
    "enabled" : true,
    "export_key" : "Network CIDR Range",
    "file" : false,
    "id" : 0,
    "multi_aware" : true,
    "name" : "Network CIDR Range",
    "parse_as_csv" : false,
    "programmatic_name" : "Network CIDR Range",
    "reg_exp" : "((^\\s*((([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5]))(\\/([0-9]|[1-2][0-9]|3[0-2]))?\\s*$)|(^\\s*((([0-9A-Fa-f]{1,4}:){7}([0-9A-Fa-f]{1,4}|:))|(([0-9A-Fa-f]{1,4}:){6}(:[0-9A-Fa-f]{1,4}|((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){5}(((:[0-9A-Fa-f]{1,4}){1,2})|:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){4}(((:[0-9A-Fa-f]{1,4}){1,3})|((:[0-9A-Fa-f]{1,4})?:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){3}(((:[0-9A-Fa-f]{1,4}){1,4})|((:[0-9A-Fa-f]{1,4}){0,2}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){2}(((:[0-9A-Fa-f]{1,4}){1,5})|((:[0-9A-Fa-f]{1,4}){0,3}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){1}(((:[0-9A-Fa-f]{1,4}){1,6})|((:[0-9A-Fa-f]{1,4}){0,4}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(:(((:[0-9A-Fa-f]{1,4}){1,7})|((:[0-9A-Fa-f]{1,4}){0,5}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:)))(%.+)?(\\/([1-9]|[1-9][0-9]|1[0-2][0-8]))?\\s*$))",
    "system" : true,
    "tags" : [ ],
    "use_for_relationships" : true,
    "uuid" : "45f86562-ad6d-4db6-aa35-6cca238bf949",
    "version" : 0
  }, {
    "default_scan_option" : "unsupported",
    "desc" : "Observed data event",
    "enabled" : true,
    "export_key" : "observed_data",
    "file" : false,
    "id" : 0,
    "multi_aware" : false,
    "name" : "Observed Data",
    "parse_as_csv" : false,
    "programmatic_name" : "observed_data",
    "reg_exp" : null,
    "system" : true,
    "tags" : [ ],
    "use_for_relationships" : true,
    "uuid" : "6070290a-5cb8-11ea-bc55-0242ac130003",
    "version" : 0
  }, {
    "default_scan_option" : "unsupported",
    "desc" : "Generic file",
    "enabled" : true,
    "export_key" : "Other File",
    "file" : true,
    "id" : 0,
    "multi_aware" : false,
    "name" : "Other File",
    "parse_as_csv" : false,
    "programmatic_name" : "Other File",
    "reg_exp" : null,
    "system" : true,
    "tags" : [ ],
    "use_for_relationships" : true,
    "uuid" : "ccaef8b6-a97a-40ce-9583-34972ff8adb6",
    "version" : 0
  }, {
    "default_scan_option" : "unsupported",
    "desc" : "A password related to the incident",
    "enabled" : true,
    "export_key" : "Password",
    "file" : false,
    "id" : 0,
    "multi_aware" : false,
    "name" : "Password",
    "parse_as_csv" : false,
    "programmatic_name" : "Password",
    "reg_exp" : null,
    "system" : true,
    "tags" : [ ],
    "use_for_relationships" : true,
    "uuid" : "42c74133-2744-4f0e-a8b5-db5da359f54c",
    "version" : 0
  }, {
    "default_scan_option" : "unsupported",
    "desc" : "Suspect open port",
    "enabled" : true,
    "export_key" : "Port",
    "file" : false,
    "id" : 0,
    "multi_aware" : false,
    "name" : "Port",
    "parse_as_csv" : false,
    "programmatic_name" : "Port",
    "reg_exp" : null,
    "system" : true,
    "tags" : [ ],
    "use_for_relationships" : true,
    "uuid" : "29ddb871-05a9-4059-aacc-fd41771b773a",
    "version" : 0
  }, {
    "default_scan_option" : "unsupported",
    "desc" : "Name of a suspect running process",
    "enabled" : true,
    "export_key" : "Process Name",
    "file" : false,
    "id" : 0,
    "multi_aware" : false,
    "name" : "Process Name",
    "parse_as_csv" : false,
    "programmatic_name" : "Process Name",
    "reg_exp" : null,
    "system" : true,
    "tags" : [ ],
    "use_for_relationships" : true,
    "uuid" : "521e33db-2baf-43aa-8c6d-4fd59a0deb3d",
    "version" : 0
  }, {
    "default_scan_option" : "unsupported",
    "desc" : "Name and value of a suspect registry key",
    "enabled" : true,
    "export_key" : "Registry Key",
    "file" : false,
    "id" : 0,
    "multi_aware" : false,
    "name" : "Registry Key",
    "parse_as_csv" : false,
    "programmatic_name" : "Registry Key",
    "reg_exp" : "(hklm|hkcc|hkcr|hkcu|hku|hkpd|hkdd|hkey_local_machine|hkey_current_config|hkey_classes_root|hkey_current_user|hkey_users|hkey_performance_data|hkey_dyn_data)[\\\\/][\\p{Print}]+",
    "system" : true,
    "tags" : [ ],
    "use_for_relationships" : true,
    "uuid" : "ba483ed2-3efb-4112-bb4f-fdce5f4557cc",
    "version" : 0
  }, {
    "default_scan_option" : "unsupported",
    "desc" : "Suspicious email stored as RFC 822 message file",
    "enabled" : true,
    "export_key" : "RFC 822 Email Message File",
    "file" : true,
    "id" : 0,
    "multi_aware" : false,
    "name" : "RFC 822 Email Message File",
    "parse_as_csv" : false,
    "programmatic_name" : "RFC 822 Email Message File",
    "reg_exp" : null,
    "system" : true,
    "tags" : [ ],
    "use_for_relationships" : true,
    "uuid" : "0097498b-4f19-41f7-9e13-267de362dbe5",
    "version" : 0
  }, {
    "default_scan_option" : "unsupported",
    "desc" : "Name of suspect running service",
    "enabled" : true,
    "export_key" : "Service",
    "file" : false,
    "id" : 0,
    "multi_aware" : false,
    "name" : "Service",
    "parse_as_csv" : false,
    "programmatic_name" : "Service",
    "reg_exp" : null,
    "system" : true,
    "tags" : [ ],
    "use_for_relationships" : true,
    "uuid" : "a4e95d95-de57-4fc9-96db-2098230fce77",
    "version" : 0
  }, {
    "default_scan_option" : "unsupported",
    "desc" : "A string value",
    "enabled" : true,
    "export_key" : "String",
    "file" : false,
    "id" : 0,
    "multi_aware" : false,
    "name" : "String",
    "parse_as_csv" : false,
    "programmatic_name" : "String",
    "reg_exp" : null,
    "system" : true,
    "tags" : [ ],
    "use_for_relationships" : true,
    "uuid" : "5d84b420-24ac-431f-b383-ae4b12039371",
    "version" : 0
  }, {
    "default_scan_option" : "unsupported",
    "desc" : "Name of the compromised computer",
    "enabled" : true,
    "export_key" : "System Name",
    "file" : false,
    "id" : 0,
    "multi_aware" : false,
    "name" : "System Name",
    "parse_as_csv" : false,
    "programmatic_name" : "System Name",
    "reg_exp" : null,
    "system" : true,
    "tags" : [ ],
    "use_for_relationships" : true,
    "uuid" : "023e705f-efe2-4fe1-acd9-10d75f701b28",
    "version" : 0
  }, {
    "default_scan_option" : "unsupported",
    "desc" : "The common vulnerabilities and exposures ID",
    "enabled" : true,
    "export_key" : "Threat CVE ID",
    "file" : false,
    "id" : 0,
    "multi_aware" : true,
    "name" : "Threat CVE ID",
    "parse_as_csv" : false,
    "programmatic_name" : "Threat CVE ID",
    "reg_exp" : "(CVE|cve)-[0-9]{4}-[0-9]+",
    "system" : true,
    "tags" : [ ],
    "use_for_relationships" : true,
    "uuid" : "dc9b914b-d7b3-42aa-ac35-0ce047082bd0",
    "version" : 0
  }, {
    "default_scan_option" : "unsupported",
    "desc" : "Path component of the URI",
    "enabled" : true,
    "export_key" : "URI Path",
    "file" : false,
    "id" : 0,
    "multi_aware" : false,
    "name" : "URI Path",
    "parse_as_csv" : false,
    "programmatic_name" : "URI Path",
    "reg_exp" : null,
    "system" : true,
    "tags" : [ ],
    "use_for_relationships" : true,
    "uuid" : "498431b8-cc8b-445e-9aa9-b2a4715bbf66",
    "version" : 0
  }, {
    "default_scan_option" : "on",
    "desc" : "Suspicious URL",
    "enabled" : true,
    "export_key" : "URL",
    "file" : false,
    "id" : 0,
    "multi_aware" : true,
    "name" : "URL",
    "parse_as_csv" : false,
    "programmatic_name" : "URL",
    "reg_exp" : "(http|https|file|gopher|ftp):\\/\\/[^\\s]+",
    "split_on" : "\r?\n|\\s",
    "system" : true,
    "tags" : [ ],
    "use_for_relationships" : true,
    "uuid" : "ee907a44-acbc-4769-83f3-f1f4097b74c2",
    "version" : 0
  }, {
    "default_scan_option" : "unsupported",
    "desc" : "Resource that redirected the request to the current URL",
    "enabled" : true,
    "export_key" : "URL Referer",
    "file" : false,
    "id" : 0,
    "multi_aware" : false,
    "name" : "URL Referer",
    "parse_as_csv" : false,
    "programmatic_name" : "URL Referer",
    "reg_exp" : "(http|https|file|gopher|ftp):\\/\\/[^\\s]+",
    "system" : true,
    "tags" : [ ],
    "use_for_relationships" : true,
    "uuid" : "ac729a57-2f4a-48f9-a476-c0e0c76c0f38",
    "version" : 0
  }, {
    "default_scan_option" : "unsupported",
    "desc" : "Name of the compromised user account",
    "enabled" : true,
    "export_key" : "User Account",
    "file" : false,
    "id" : 0,
    "multi_aware" : false,
    "name" : "User Account",
    "parse_as_csv" : false,
    "programmatic_name" : "User Account",
    "reg_exp" : null,
    "system" : true,
    "tags" : [ ],
    "use_for_relationships" : true,
    "uuid" : "4bce2b51-2784-4f2a-8d9d-185d8c32fef5",
    "version" : 0
  }, {
    "default_scan_option" : "unsupported",
    "desc" : "Web browser's user agent string",
    "enabled" : true,
    "export_key" : "User Agent",
    "file" : false,
    "id" : 0,
    "multi_aware" : false,
    "name" : "User Agent",
    "parse_as_csv" : false,
    "programmatic_name" : "User Agent",
    "reg_exp" : null,
    "system" : true,
    "tags" : [ ],
    "use_for_relationships" : true,
    "uuid" : "4a2ee4d6-71f4-4958-9964-818e0b159554",
    "version" : 0
  }, {
    "default_scan_option" : "unsupported",
    "desc" : "An X.509 certificate file",
    "enabled" : true,
    "export_key" : "X509 Certificate File",
    "file" : true,
    "id" : 0,
    "multi_aware" : false,
    "name" : "X509 Certificate File",
    "parse_as_csv" : false,
    "programmatic_name" : "X509 Certificate File",
    "reg_exp" : null,
    "system" : true,
    "tags" : [ ],
    "use_for_relationships" : true,
    "uuid" : "0a76fa64-b3a3-40a2-9b16-0d4f52abfb2e",
    "version" : 0
  } ],
  "incident_types" : [ {
    "create_date" : 1296778427539,
    "description" : null,
    "enabled" : true,
    "export_key" : "Communication error (fax; email)",
    "hidden" : false,
    "id" : 0,
    "name" : "Communication error (fax; email)",
    "parent_id" : null,
    "system" : true,
    "tags" : [ ],
    "update_date" : null,
    "uuid" : "4a8d22f7-d89e-4403-85c7-2bafe3b7f2ae"
  }, {
    "create_date" : 1644407278968,
    "description" : "Customization Packages (internal)",
    "enabled" : true,
    "export_key" : "Customization Packages (internal)",
    "hidden" : false,
    "id" : 0,
    "name" : "Customization Packages (internal)",
    "parent_id" : null,
    "system" : false,
    "tags" : [ ],
    "update_date" : 1644407278999,
    "uuid" : "bfeec2d4-3770-11e8-ad39-4a0004044aa0"
  }, {
    "create_date" : null,
    "description" : null,
    "enabled" : true,
    "export_key" : "Denial of Service",
    "hidden" : false,
    "id" : 0,
    "name" : "Denial of Service",
    "parent_id" : null,
    "system" : true,
    "tags" : [ ],
    "update_date" : null,
    "uuid" : "e1b10c0c-21f8-4e3f-9f0f-40668ddd2a01"
  }, {
    "create_date" : 1296777481499,
    "description" : null,
    "enabled" : true,
    "export_key" : "Improper disposal: digital asset(s)",
    "hidden" : false,
    "id" : 0,
    "name" : "Improper disposal: digital asset(s)",
    "parent_id" : null,
    "system" : true,
    "tags" : [ ],
    "update_date" : 1296777592295,
    "uuid" : "a468d23f-960f-44ca-8918-4429a5aa4fa1"
  }, {
    "create_date" : 1296778141605,
    "description" : null,
    "enabled" : true,
    "export_key" : "Improper disposal: documents / files",
    "hidden" : false,
    "id" : 0,
    "name" : "Improper disposal: documents / files",
    "parent_id" : null,
    "system" : true,
    "tags" : [ ],
    "update_date" : null,
    "uuid" : "5b190a80-c960-4040-bcae-15565f8c77ae"
  }, {
    "create_date" : null,
    "description" : null,
    "enabled" : true,
    "export_key" : "Lost documents / files / records",
    "hidden" : false,
    "id" : 0,
    "name" : "Lost documents / files / records",
    "parent_id" : null,
    "system" : true,
    "tags" : [ ],
    "update_date" : 1296777581756,
    "uuid" : "ee9b74ff-52ea-4a5d-9267-6648c8996950"
  }, {
    "create_date" : null,
    "description" : null,
    "enabled" : true,
    "export_key" : "Lost PC / laptop / tablet",
    "hidden" : false,
    "id" : 0,
    "name" : "Lost PC / laptop / tablet",
    "parent_id" : null,
    "system" : true,
    "tags" : [ ],
    "update_date" : 1296777546848,
    "uuid" : "9235ae9f-bfb1-4c34-8022-96a86c79e677"
  }, {
    "create_date" : null,
    "description" : null,
    "enabled" : true,
    "export_key" : "Lost PDA / smartphone",
    "hidden" : false,
    "id" : 0,
    "name" : "Lost PDA / smartphone",
    "parent_id" : null,
    "system" : true,
    "tags" : [ ],
    "update_date" : 1296777343194,
    "uuid" : "b038d098-837c-4c0d-8f3d-ea639f42a1bf"
  }, {
    "create_date" : 1296777437386,
    "description" : null,
    "enabled" : true,
    "export_key" : "Lost storage device / media",
    "hidden" : false,
    "id" : 0,
    "name" : "Lost storage device / media",
    "parent_id" : null,
    "system" : true,
    "tags" : [ ],
    "update_date" : 1296778436991,
    "uuid" : "8bbfc278-f58b-453d-874f-8dcad1ba3253"
  }, {
    "create_date" : 1305153213937,
    "description" : null,
    "enabled" : true,
    "export_key" : "Malware",
    "hidden" : false,
    "id" : 0,
    "name" : "Malware",
    "parent_id" : null,
    "system" : true,
    "tags" : [ ],
    "update_date" : null,
    "uuid" : "f441538a-2f23-48ca-9af6-45ce7b3971f1"
  }, {
    "create_date" : null,
    "description" : null,
    "enabled" : true,
    "export_key" : "Not an Issue",
    "hidden" : false,
    "id" : 0,
    "name" : "Not an Issue",
    "parent_id" : null,
    "system" : true,
    "tags" : [ ],
    "update_date" : null,
    "uuid" : "c8a80794-47ba-4708-983f-d6e56905b587"
  }, {
    "create_date" : 1296778872265,
    "description" : null,
    "enabled" : true,
    "export_key" : "Other",
    "hidden" : false,
    "id" : 0,
    "name" : "Other",
    "parent_id" : null,
    "system" : true,
    "tags" : [ ],
    "update_date" : 1296779808337,
    "uuid" : "48e1b3b6-e5a6-44a5-a5d1-dd9c6bfdfa9e"
  }, {
    "create_date" : null,
    "description" : null,
    "enabled" : true,
    "export_key" : "Phishing",
    "hidden" : false,
    "id" : 0,
    "name" : "Phishing",
    "parent_id" : null,
    "system" : true,
    "tags" : [ ],
    "update_date" : null,
    "uuid" : "bbb113d4-86f3-4cbf-94e0-931aa693e62a"
  }, {
    "create_date" : 1296778208935,
    "description" : null,
    "enabled" : true,
    "export_key" : "Stolen documents / files / records",
    "hidden" : false,
    "id" : 0,
    "name" : "Stolen documents / files / records",
    "parent_id" : null,
    "system" : true,
    "tags" : [ ],
    "update_date" : null,
    "uuid" : "e7105d3b-f7bc-4680-8c2d-55d32e6787bb"
  }, {
    "create_date" : 1296777832483,
    "description" : null,
    "enabled" : true,
    "export_key" : "Stolen PC / laptop / tablet",
    "hidden" : false,
    "id" : 0,
    "name" : "Stolen PC / laptop / tablet",
    "parent_id" : null,
    "system" : true,
    "tags" : [ ],
    "update_date" : null,
    "uuid" : "2b25f669-82a1-4138-9371-0843f5b674b4"
  }, {
    "create_date" : 1296777660632,
    "description" : null,
    "enabled" : true,
    "export_key" : "Stolen PDA / smartphone",
    "hidden" : false,
    "id" : 0,
    "name" : "Stolen PDA / smartphone",
    "parent_id" : null,
    "system" : true,
    "tags" : [ ],
    "update_date" : null,
    "uuid" : "21b6cc0d-fb98-47cd-9882-cb854ebe641a"
  }, {
    "create_date" : 1296778278265,
    "description" : null,
    "enabled" : true,
    "export_key" : "Stolen storage device / media",
    "hidden" : false,
    "id" : 0,
    "name" : "Stolen storage device / media",
    "parent_id" : null,
    "system" : true,
    "tags" : [ ],
    "update_date" : 1296778717127,
    "uuid" : "da239c99-f0c6-4e61-99aa-b968eda85434"
  }, {
    "create_date" : null,
    "description" : null,
    "enabled" : true,
    "export_key" : "System Intrusion",
    "hidden" : false,
    "id" : 0,
    "name" : "System Intrusion",
    "parent_id" : null,
    "system" : true,
    "tags" : [ ],
    "update_date" : null,
    "uuid" : "2caf1eca-2463-4e9c-8885-16637fc91f3f"
  }, {
    "create_date" : 1296777784379,
    "description" : null,
    "enabled" : true,
    "export_key" : "TBD / Unknown",
    "hidden" : false,
    "id" : 0,
    "name" : "TBD / Unknown",
    "parent_id" : null,
    "system" : true,
    "tags" : [ ],
    "update_date" : 1296777903604,
    "uuid" : "8a506ca3-b848-4019-8c20-203543d907fe"
  }, {
    "create_date" : 1296778565815,
    "description" : null,
    "enabled" : true,
    "export_key" : "Vendor / 3rd party error",
    "hidden" : false,
    "id" : 0,
    "name" : "Vendor / 3rd party error",
    "parent_id" : null,
    "system" : true,
    "tags" : [ ],
    "update_date" : null,
    "uuid" : "afd3e485-178f-496d-8cd8-639b791ca0a6"
  } ],
  "industries" : null,
  "layouts" : [ {
    "content" : [ {
      "element" : "tab",
      "field_type" : "incident",
      "fields" : [ {
        "content" : "task:list",
        "element" : "view",
        "field_type" : null,
        "show_if" : null,
        "show_link_header" : false,
        "step_label" : null
      } ],
      "predefined_uuid" : "81fcccb8-abc7-45fd-b7e9-2e494e7be849",
      "show_if" : [ ],
      "show_link_header" : false,
      "step_label" : "Tasks"
    }, {
      "element" : "tab",
      "field_type" : "incident",
      "fields" : [ {
        "content" : "Basic Details",
        "element" : "header",
        "field_type" : null,
        "show_if" : null,
        "show_link_header" : false,
        "step_label" : null
      }, {
        "content" : "name",
        "element" : "field",
        "field_type" : "incident",
        "show_if" : null,
        "show_link_header" : false,
        "step_label" : null
      }, {
        "content" : "description",
        "element" : "field",
        "field_type" : "incident",
        "show_if" : null,
        "show_link_header" : false,
        "step_label" : null
      }, {
        "content" : "incident_type_ids",
        "element" : "field",
        "field_type" : "incident",
        "show_if" : null,
        "show_link_header" : false,
        "step_label" : null
      }, {
        "content" : "nist_attack_vectors",
        "element" : "field",
        "field_type" : "incident",
        "show_if" : null,
        "show_link_header" : false,
        "step_label" : null
      }, {
        "content" : "confirmed",
        "element" : "field",
        "field_type" : "incident",
        "show_if" : null,
        "show_link_header" : false,
        "step_label" : null
      }, {
        "content" : "phase_id",
        "element" : "field",
        "field_type" : "incident",
        "show_if" : null,
        "show_link_header" : false,
        "step_label" : null
      }, {
        "content" : "resolution_id",
        "element" : "field",
        "field_type" : "incident",
        "show_if" : null,
        "show_link_header" : false,
        "step_label" : null
      }, {
        "content" : "resolution_summary",
        "element" : "field",
        "field_type" : "incident",
        "show_if" : null,
        "show_link_header" : false,
        "step_label" : null
      }, {
        "content" : "owner_id",
        "element" : "field",
        "field_type" : "incident",
        "show_if" : null,
        "show_link_header" : false,
        "step_label" : null
      }, {
        "content" : "Co3.Views.IncidentsShowCreatorField",
        "element" : "view",
        "field_type" : null,
        "show_if" : null,
        "show_link_header" : false,
        "step_label" : null
      }, {
        "content" : "Date and Location",
        "element" : "header",
        "field_type" : null,
        "show_if" : null,
        "show_link_header" : false,
        "step_label" : null
      }, {
        "content" : "Co3.Views.IncidentsShowCreateDateField",
        "element" : "view",
        "field_type" : null,
        "show_if" : null,
        "show_link_header" : false,
        "step_label" : null
      }, {
        "content" : "start_date",
        "element" : "field",
        "field_type" : "incident",
        "show_if" : null,
        "show_link_header" : false,
        "step_label" : null
      }, {
        "content" : "discovered_date",
        "element" : "field",
        "field_type" : "incident",
        "show_if" : null,
        "show_link_header" : false,
        "step_label" : null
      }, {
        "content" : "<hr />",
        "element" : "html",
        "field_type" : null,
        "show_if" : null,
        "show_link_header" : false,
        "step_label" : null
      }, {
        "content" : "Co3.Widgets.Form.Address",
        "element" : "view",
        "field_type" : null,
        "show_if" : null,
        "show_link_header" : false,
        "step_label" : null
      }, {
        "content" : "Implications",
        "element" : "header",
        "field_type" : null,
        "show_if" : null,
        "show_link_header" : false,
        "step_label" : null
      }, {
        "content" : "Co3.Widgets.Form.Crimstatus",
        "element" : "view",
        "field_type" : null,
        "show_if" : null,
        "show_link_header" : false,
        "step_label" : null
      }, {
        "content" : "Co3.Widgets.Form.EmployeeInvolvement",
        "element" : "view",
        "field_type" : null,
        "show_if" : null,
        "show_link_header" : false,
        "step_label" : null
      }, {
        "content" : "exposure_dept_id",
        "element" : "field",
        "field_type" : "incident",
        "show_if" : null,
        "show_link_header" : false,
        "step_label" : null
      }, {
        "content" : "negative_pr_likely",
        "element" : "field",
        "field_type" : "incident",
        "show_if" : null,
        "show_link_header" : false,
        "step_label" : null
      }, {
        "content" : "reporter",
        "element" : "field",
        "field_type" : "incident",
        "show_if" : null,
        "show_link_header" : false,
        "step_label" : null
      }, {
        "content" : "severity_code",
        "element" : "field",
        "field_type" : "incident",
        "show_if" : null,
        "show_link_header" : false,
        "step_label" : null
      } ],
      "predefined_uuid" : "ccf4e648-5af4-4dc0-8f6a-19aff3a7eeb6",
      "show_if" : [ ],
      "show_link_header" : false,
      "step_label" : "Details"
    }, {
      "element" : "tab",
      "field_type" : "incident",
      "fields" : [ {
        "content" : "Privacy",
        "element" : "header",
        "field_type" : null,
        "show_if" : null,
        "show_link_header" : false,
        "step_label" : null
      }, {
        "content" : "data_compromised",
        "element" : "field",
        "field_type" : "incident",
        "show_if" : null,
        "show_link_header" : false,
        "step_label" : null
      }, {
        "content" : "determined_date",
        "element" : "field",
        "field_type" : "incident",
        "show_if" : null,
        "show_link_header" : false,
        "step_label" : null
      }, {
        "content" : "harmstatus_id",
        "element" : "field",
        "field_type" : "incident",
        "show_if" : null,
        "show_link_header" : false,
        "step_label" : null
      }, {
        "content" : "data_encrypted",
        "element" : "field",
        "field_type" : "incident",
        "show_if" : null,
        "show_link_header" : false,
        "step_label" : null
      }, {
        "content" : "data_contained",
        "element" : "field",
        "field_type" : "incident",
        "show_if" : null,
        "show_link_header" : false,
        "step_label" : null
      }, {
        "content" : "data_source_ids",
        "element" : "field",
        "field_type" : "incident",
        "show_if" : null,
        "show_link_header" : false,
        "step_label" : null
      }, {
        "content" : "data_format",
        "element" : "field",
        "field_type" : "incident",
        "show_if" : null,
        "show_link_header" : false,
        "step_label" : null
      }, {
        "content" : "Data Types",
        "element" : "header",
        "field_type" : null,
        "show_if" : null,
        "show_link_header" : false,
        "step_label" : null
      }, {
        "content" : "Co3.Views.EventsShowData",
        "element" : "view",
        "field_type" : null,
        "show_if" : null,
        "show_link_header" : false,
        "step_label" : null
      }, {
        "content" : "Record Distribution",
        "element" : "header",
        "field_type" : null,
        "show_if" : null,
        "show_link_header" : false,
        "step_label" : null
      }, {
        "content" : "Co3.Views.EventsShowRecord",
        "element" : "view",
        "field_type" : null,
        "show_if" : null,
        "show_link_header" : false,
        "step_label" : null
      }, {
        "content" : "Regulators",
        "element" : "header",
        "field_type" : null,
        "show_if" : null,
        "show_link_header" : false,
        "step_label" : null
      }, {
        "content" : "Co3.Views.EventsShowRegulators",
        "element" : "view",
        "field_type" : null,
        "show_if" : null,
        "show_link_header" : false,
        "step_label" : null
      }, {
        "element" : "section",
        "field_type" : null,
        "fields" : [ {
          "content" : "HIPAA",
          "element" : "header",
          "field_type" : null,
          "show_if" : null,
          "show_link_header" : false,
          "step_label" : null
        }, {
          "content" : "Co3.Widgets.Form.HIPAA",
          "element" : "view",
          "field_type" : null,
          "show_if" : null,
          "show_link_header" : false,
          "step_label" : null
        } ],
        "show_if" : [ {
          "condition" : "equals",
          "field" : "incident.data_compromised",
          "value" : true
        }, {
          "condition" : "has_regulators",
          "field" : "has_regulators",
          "value" : [ "HIPAA/HITECH Act" ]
        } ],
        "show_link_header" : false,
        "step_label" : null
      }, {
        "element" : "section",
        "field_type" : null,
        "fields" : [ {
          "content" : "Europe Breach Risk Assessment",
          "element" : "header",
          "field_type" : null,
          "show_if" : null,
          "show_link_header" : false,
          "step_label" : null
        }, {
          "content" : "Co3.Widgets.Form.GDPR",
          "element" : "view",
          "field_type" : null,
          "show_if" : null,
          "show_link_header" : false,
          "step_label" : null
        } ],
        "show_if" : [ {
          "condition" : "equals",
          "field" : "incident.data_compromised",
          "value" : true
        }, {
          "condition" : "has_regulators",
          "field" : "has_regulators",
          "value" : [ "Austria", "Belgium", "Bulgaria", "Croatia", "Cyprus", "Czech Republic", "Denmark", "Estonia", "Finland", "France", "Germany", "Gibraltar", "Greece", "Guernsey", "Hungary", "Iceland", "Ireland", "Isle of Man", "Italy", "Jersey", "Latvia", "Liechtenstein", "Lithuania", "Luxembourg", "Malta", "Netherlands", "Norway", "Poland", "Portugal", "Romania", "Slovakia", "Slovenia", "Spain", "Sweden", "United Kingdom" ]
        } ],
        "show_link_header" : false,
        "step_label" : null
      }, {
        "element" : "section",
        "field_type" : null,
        "fields" : [ {
          "content" : "PIPEDA Breach Risk Assessment",
          "element" : "header",
          "field_type" : null,
          "show_if" : null,
          "show_link_header" : false,
          "step_label" : null
        }, {
          "content" : "Co3.Widgets.Form.PIPEDA",
          "element" : "view",
          "field_type" : null,
          "show_if" : null,
          "show_link_header" : false,
          "step_label" : null
        } ],
        "show_if" : [ {
          "condition" : "equals",
          "field" : "incident.data_compromised",
          "value" : true
        }, {
          "condition" : "has_regulators",
          "field" : "has_regulators",
          "value" : [ "PIPEDA" ]
        } ],
        "show_link_header" : false,
        "step_label" : null
      }, {
        "content" : "Assessment",
        "element" : "header",
        "field_type" : null,
        "show_if" : null,
        "show_link_header" : false,
        "step_label" : null
      }, {
        "content" : "Co3.Views.IncidentsShowAssess",
        "element" : "view",
        "field_type" : null,
        "show_if" : null,
        "show_link_header" : false,
        "step_label" : null
      } ],
      "predefined_uuid" : "bcb30c12-c739-4b1e-b9ab-4cf65a4730ce",
      "show_if" : [ ],
      "show_link_header" : false,
      "step_label" : "Breach"
    }, {
      "element" : "tab",
      "field_type" : "incident",
      "fields" : [ {
        "content" : "Co3.Views.IncidentsComments",
        "element" : "view",
        "field_type" : null,
        "show_if" : null,
        "show_link_header" : false,
        "step_label" : null
      } ],
      "predefined_uuid" : "bdf6a0ac-afd4-4542-a6e4-9ddccd265bc3",
      "show_if" : [ ],
      "show_link_header" : false,
      "step_label" : "Notes"
    }, {
      "element" : "tab",
      "field_type" : "incident",
      "fields" : [ {
        "content" : "Co3.Views.IncidentsShowMembership",
        "element" : "view",
        "field_type" : null,
        "show_if" : null,
        "show_link_header" : false,
        "step_label" : null
      } ],
      "predefined_uuid" : "d702e365-e684-465f-b628-6903c34a0940",
      "show_if" : [ ],
      "show_link_header" : false,
      "step_label" : "Members"
    }, {
      "element" : "tab",
      "field_type" : "incident",
      "fields" : [ {
        "content" : "timeline:show",
        "element" : "view",
        "field_type" : null,
        "show_if" : null,
        "show_link_header" : false,
        "step_label" : null
      } ],
      "predefined_uuid" : "9537537e-1c51-4179-9a08-b510da74076e",
      "show_if" : [ ],
      "show_link_header" : false,
      "step_label" : "News Feed"
    }, {
      "element" : "tab",
      "field_type" : "incident",
      "fields" : [ {
        "content" : "attachment:list",
        "element" : "view",
        "field_type" : null,
        "show_if" : null,
        "show_link_header" : false,
        "step_label" : null
      } ],
      "predefined_uuid" : "82dfc42c-d6a0-4f26-b42e-ae5e0b282962",
      "show_if" : [ ],
      "show_link_header" : false,
      "step_label" : "Attachments"
    }, {
      "element" : "tab",
      "field_type" : "incident",
      "fields" : [ {
        "content" : "Co3.Views.IncidentsAnalytics",
        "element" : "view",
        "field_type" : null,
        "show_if" : null,
        "show_link_header" : false,
        "step_label" : null
      } ],
      "predefined_uuid" : "60d44f55-ba15-466e-9183-46e1eabed0a4",
      "show_if" : [ ],
      "show_link_header" : false,
      "step_label" : "Stats"
    }, {
      "element" : "tab",
      "field_type" : "incident",
      "fields" : [ {
        "content" : "Co3.Views.IncidentsGraphs",
        "element" : "view",
        "field_type" : null,
        "show_if" : null,
        "show_link_header" : false,
        "step_label" : null
      } ],
      "predefined_uuid" : "2bf00a1d-084b-4faf-8849-097aeb6e1012",
      "show_if" : [ ],
      "show_link_header" : false,
      "step_label" : "Timeline"
    }, {
      "element" : "tab",
      "field_type" : "incident",
      "fields" : [ {
        "content" : "artifact:list",
        "element" : "view",
        "field_type" : null,
        "show_if" : null,
        "show_link_header" : false,
        "step_label" : null
      } ],
      "predefined_uuid" : "c7f85eb4-f9dd-4414-a1d8-f6c114dbd236",
      "show_if" : [ ],
      "show_link_header" : false,
      "step_label" : "Artifacts"
    }, {
      "element" : "tab",
      "field_type" : "incident",
      "fields" : [ {
        "content" : "email:inbox:incident",
        "element" : "view",
        "field_type" : null,
        "show_if" : null,
        "show_link_header" : false,
        "step_label" : null
      } ],
      "predefined_uuid" : "c9e6ef5a-4dd1-4fa3-a7a9-19e2c5ccda36",
      "show_if" : [ ],
      "show_link_header" : false,
      "step_label" : "Email"
    } ],
    "description" : null,
    "export_key" : "INCIDENT_TABS/incident/null",
    "id" : 1,
    "name" : "incident",
    "owner_id" : null,
    "perms" : null,
    "public" : true,
    "type" : 7,
    "uuid" : "a1537221-dbac-4320-9d59-52e3bd2590a0"
  }, {
    "content" : [ ],
    "description" : null,
    "export_key" : "INCIDENT_CLOSED/incident.close/null",
    "id" : 3,
    "name" : "incident.close",
    "owner_id" : null,
    "perms" : null,
    "public" : true,
    "type" : 5,
    "uuid" : "7b012197-5999-4fc4-9a39-98b767427e1d"
  }, {
    "content" : [ {
      "content" : "Summary",
      "element" : "header",
      "field_type" : null,
      "predefined_uuid" : "de187582-422a-46f0-889d-9e191b871ece",
      "show_if" : null,
      "show_link_header" : false,
      "step_label" : null
    }, {
      "content" : "id",
      "element" : "field",
      "field_type" : "incident",
      "predefined_uuid" : "bf882c37-e398-475c-a8aa-68770d9aeec2",
      "show_if" : null,
      "show_link_header" : false,
      "step_label" : null
    }, {
      "content" : "phase_id",
      "element" : "field",
      "field_type" : "incident",
      "predefined_uuid" : "10cb781c-4f3b-4863-8231-f7ad39559054",
      "show_if" : null,
      "show_link_header" : false,
      "step_label" : null
    }, {
      "content" : "severity_code",
      "element" : "field",
      "field_type" : "incident",
      "predefined_uuid" : "f2d4fad2-ced4-4622-b8cb-138abebc07d9",
      "show_if" : null,
      "show_link_header" : false,
      "step_label" : null
    }, {
      "content" : "create_date",
      "element" : "field",
      "field_type" : "incident",
      "predefined_uuid" : "d1c7159b-c341-4703-93eb-d4b8f2c4c449",
      "show_if" : null,
      "show_link_header" : false,
      "step_label" : null
    }, {
      "content" : "start_date",
      "element" : "field",
      "field_type" : "incident",
      "predefined_uuid" : "92fa8409-05e7-4db6-8637-d4e11d853b6f",
      "show_if" : null,
      "show_link_header" : false,
      "step_label" : null
    }, {
      "content" : "discovered_date",
      "element" : "field",
      "field_type" : "incident",
      "predefined_uuid" : "3ee4756e-8058-4425-aec2-b3fdb744c4be",
      "show_if" : null,
      "show_link_header" : false,
      "step_label" : null
    }, {
      "content" : "determined_date",
      "element" : "field",
      "field_type" : "incident",
      "predefined_uuid" : "21a51482-2200-45f2-9969-7d52c14a8d01",
      "show_if" : null,
      "show_link_header" : false,
      "step_label" : null
    }, {
      "content" : "data_compromised",
      "element" : "field",
      "field_type" : "incident",
      "predefined_uuid" : "31d28bb2-df53-4df1-bd02-3ead04c35ff8",
      "show_if" : null,
      "show_link_header" : false,
      "step_label" : null
    }, {
      "content" : "incident_type_ids",
      "element" : "field",
      "field_type" : "incident",
      "predefined_uuid" : "5f715f1f-c9f4-4674-bde8-9bc12409a2b8",
      "show_if" : null,
      "show_link_header" : false,
      "step_label" : null
    }, {
      "content" : "People",
      "element" : "header",
      "field_type" : null,
      "predefined_uuid" : "4d5b3e80-4b61-418f-aba9-bedc0a4daeb9",
      "show_if" : null,
      "show_link_header" : false,
      "step_label" : null
    }, {
      "content" : "creator_id",
      "element" : "field",
      "field_type" : "incident",
      "predefined_uuid" : "7c17c740-e5d6-4672-b386-4653b6551b53",
      "show_if" : null,
      "show_link_header" : false,
      "step_label" : null
    }, {
      "content" : "owner_id",
      "element" : "field",
      "field_type" : "incident",
      "predefined_uuid" : "9bbc5761-0f45-4eb2-87b8-d6cb6dda0de2",
      "show_if" : null,
      "show_link_header" : false,
      "step_label" : null
    }, {
      "content" : "members",
      "element" : "field",
      "field_type" : "incident",
      "predefined_uuid" : "b3e8664a-4681-4f26-a119-d424b5fe8f9c",
      "show_if" : null,
      "show_link_header" : false,
      "step_label" : null
    }, {
      "content" : "Related Incidents",
      "element" : "header",
      "field_type" : null,
      "predefined_uuid" : "13b7043f-3093-4048-9bb8-228e7f244232",
      "show_if" : null,
      "show_link_header" : false,
      "step_label" : null
    }, {
      "content" : "incident:related:list",
      "element" : "view",
      "field_type" : null,
      "predefined_uuid" : "72d449ee-8ce7-4776-b0d4-078f24cb7f7c",
      "show_if" : null,
      "show_link_header" : false,
      "step_label" : null
    }, {
      "content" : "Attachments",
      "element" : "header",
      "field_type" : null,
      "predefined_uuid" : "f51ac133-022a-411b-889c-dd200d292d56",
      "show_if" : null,
      "show_link_header" : false,
      "step_label" : null
    }, {
      "content" : "attachment:list",
      "element" : "view",
      "field_type" : null,
      "predefined_uuid" : "8793bb58-53e7-483f-bed6-919d12e641b4",
      "show_if" : null,
      "show_link_header" : false,
      "step_label" : null
    }, {
      "content" : "Newsfeed",
      "element" : "header",
      "field_type" : null,
      "predefined_uuid" : "8ff7ba3f-7c5e-4bb8-80fe-2fdd1f499e2e",
      "show_if" : null,
      "show_link_header" : false,
      "step_label" : null
    }, {
      "content" : "timeline:show",
      "element" : "view",
      "field_type" : null,
      "predefined_uuid" : "fbd29157-105f-4638-9d99-04205926889e",
      "show_if" : null,
      "show_link_header" : false,
      "step_label" : null
    } ],
    "description" : null,
    "export_key" : "INCIDENT_SUMMARY/incident.summary/null",
    "id" : 4,
    "name" : "incident.summary",
    "owner_id" : null,
    "perms" : null,
    "public" : true,
    "type" : 8,
    "uuid" : "c5399d25-13a6-4a39-a829-8a8a04cfee49"
  }, {
    "content" : [ {
      "field_type" : null,
      "fields" : [ {
        "content" : "Describe and Name the Incident",
        "element" : "header",
        "field_type" : null,
        "show_if" : null,
        "show_link_header" : false,
        "step_label" : null
      }, {
        "content" : "incident_type_ids",
        "element" : "field",
        "field_type" : "incident",
        "show_if" : null,
        "show_link_header" : false,
        "step_label" : null
      }, {
        "content" : "nist_attack_vectors",
        "element" : "field",
        "field_type" : "incident",
        "show_if" : null,
        "show_link_header" : false,
        "step_label" : null
      }, {
        "content" : "confirmed",
        "element" : "field",
        "field_type" : "incident",
        "show_if" : null,
        "show_link_header" : false,
        "step_label" : null
      }, {
        "content" : "description",
        "element" : "field",
        "field_type" : "incident",
        "show_if" : null,
        "show_link_header" : false,
        "step_label" : null
      }, {
        "content" : "name",
        "element" : "field",
        "field_type" : "incident",
        "show_if" : null,
        "show_link_header" : false,
        "step_label" : null
      } ],
      "predefined_uuid" : "522c2ccc-c899-4344-aa28-959474e4ef49",
      "show_if" : [ ],
      "show_link_header" : false,
      "step_label" : "Describe the Incident"
    }, {
      "field_type" : null,
      "fields" : [ {
        "content" : "Date and Location",
        "element" : "header",
        "field_type" : null,
        "show_if" : null,
        "show_link_header" : false,
        "step_label" : null
      }, {
        "content" : "start_date",
        "element" : "field",
        "field_type" : "incident",
        "show_if" : null,
        "show_link_header" : false,
        "step_label" : null
      }, {
        "content" : "discovered_date",
        "element" : "field",
        "field_type" : "incident",
        "show_if" : null,
        "show_link_header" : false,
        "step_label" : null
      }, {
        "content" : "<hr />",
        "element" : "html",
        "field_type" : null,
        "show_if" : null,
        "show_link_header" : false,
        "step_label" : null
      }, {
        "content" : "Co3.Widgets.Form.Address",
        "element" : "view",
        "field_type" : null,
        "show_if" : null,
        "show_link_header" : false,
        "step_label" : null
      } ],
      "predefined_uuid" : "3d24361d-6e56-458e-ae95-be4b67c0e108",
      "show_if" : [ ],
      "show_link_header" : false,
      "step_label" : "Date and Location"
    }, {
      "field_type" : null,
      "fields" : [ {
        "content" : "Implications",
        "element" : "header",
        "field_type" : null,
        "show_if" : null,
        "show_link_header" : false,
        "step_label" : null
      }, {
        "content" : "Co3.Widgets.Form.Crimstatus",
        "element" : "view",
        "field_type" : null,
        "show_if" : null,
        "show_link_header" : false,
        "step_label" : null
      }, {
        "content" : "Co3.Widgets.Form.EmployeeInvolvement",
        "element" : "view",
        "field_type" : null,
        "show_if" : null,
        "show_link_header" : false,
        "step_label" : null
      }, {
        "content" : "exposure_dept_id",
        "element" : "field",
        "field_type" : "incident",
        "show_if" : null,
        "show_link_header" : false,
        "step_label" : null
      }, {
        "content" : "negative_pr_likely",
        "element" : "field",
        "field_type" : "incident",
        "show_if" : null,
        "show_link_header" : false,
        "step_label" : null
      }, {
        "content" : "reporter",
        "element" : "field",
        "field_type" : "incident",
        "show_if" : null,
        "show_link_header" : false,
        "step_label" : null
      }, {
        "content" : "severity_code",
        "element" : "field",
        "field_type" : "incident",
        "show_if" : null,
        "show_link_header" : false,
        "step_label" : null
      } ],
      "predefined_uuid" : "031ddbb1-26f0-48e8-be79-f14885f5832c",
      "show_if" : [ ],
      "show_link_header" : false,
      "step_label" : "Implications"
    }, {
      "field_type" : null,
      "fields" : [ {
        "content" : "Privacy",
        "element" : "header",
        "field_type" : null,
        "show_if" : null,
        "show_link_header" : false,
        "step_label" : null
      }, {
        "content" : "Co3.Widgets.Form.PII",
        "element" : "view",
        "field_type" : null,
        "show_if" : null,
        "show_link_header" : false,
        "step_label" : null
      } ],
      "predefined_uuid" : "6bffda4a-4b01-4077-9765-053b310322b7",
      "show_if" : [ ],
      "show_link_header" : false,
      "step_label" : "Privacy"
    }, {
      "field_type" : null,
      "fields" : [ {
        "content" : "Team Formation",
        "element" : "header",
        "field_type" : null,
        "show_if" : null,
        "show_link_header" : false,
        "step_label" : null
      }, {
        "content" : "owner_id",
        "element" : "field",
        "field_type" : "incident",
        "show_if" : null,
        "show_link_header" : false,
        "step_label" : null
      }, {
        "content" : "Co3.Views.IncidentsNewMemberPicker",
        "element" : "view",
        "field_type" : null,
        "show_if" : null,
        "show_link_header" : false,
        "step_label" : null
      } ],
      "predefined_uuid" : "b55d78ac-10fc-4637-bc78-c802940bd47d",
      "show_if" : [ ],
      "show_link_header" : false,
      "step_label" : "Team Formation "
    }, {
      "field_type" : null,
      "fields" : [ {
        "content" : "Regulators",
        "element" : "header",
        "field_type" : null,
        "show_if" : null,
        "show_link_header" : false,
        "step_label" : null
      }, {
        "content" : "Co3.Views.IncidentsNewRegulators",
        "element" : "view",
        "field_type" : null,
        "show_if" : null,
        "show_link_header" : false,
        "step_label" : null
      } ],
      "predefined_uuid" : "6f930c0e-f045-4ef9-b6f2-4f864791ce92",
      "show_if" : [ {
        "condition" : "equal_to",
        "field" : "incident.data_compromised",
        "value" : true
      } ],
      "show_link_header" : false,
      "step_label" : "Regulators"
    }, {
      "field_type" : null,
      "fields" : [ {
        "content" : "Record Count",
        "element" : "header",
        "field_type" : null,
        "show_if" : null,
        "show_link_header" : false,
        "step_label" : null
      }, {
        "content" : "Co3.Views.IncidentsNewRecordcount",
        "element" : "view",
        "field_type" : null,
        "show_if" : null,
        "show_link_header" : false,
        "step_label" : null
      } ],
      "predefined_uuid" : "37627c88-4bd5-4d1c-829b-1d987109b02f",
      "show_if" : [ {
        "condition" : "equal_to",
        "field" : "incident.data_compromised",
        "value" : true
      } ],
      "show_link_header" : false,
      "step_label" : "Record Count"
    }, {
      "field_type" : null,
      "fields" : [ {
        "content" : "Data Types",
        "element" : "header",
        "field_type" : null,
        "show_if" : null,
        "show_link_header" : false,
        "step_label" : null
      }, {
        "content" : "Co3.Views.IncidentsNewDatatypes",
        "element" : "view",
        "field_type" : null,
        "show_if" : null,
        "show_link_header" : false,
        "step_label" : null
      } ],
      "predefined_uuid" : "5adb13bc-8d59-431e-bacd-ae6fb0b35ccb",
      "show_if" : [ {
        "condition" : "equal_to",
        "field" : "incident.data_compromised",
        "value" : true
      } ],
      "show_link_header" : false,
      "step_label" : "Data Types"
    }, {
      "field_type" : null,
      "fields" : [ {
        "content" : "HIPAA",
        "element" : "header",
        "field_type" : null,
        "show_if" : null,
        "show_link_header" : false,
        "step_label" : null
      }, {
        "content" : "Co3.Views.IncidentsNewHipaa",
        "element" : "view",
        "field_type" : null,
        "show_if" : null,
        "show_link_header" : false,
        "step_label" : null
      } ],
      "predefined_uuid" : "332d15a7-5512-4cfd-a343-dcffd59e7aff",
      "show_if" : [ {
        "condition" : "equal_to",
        "field" : "incident.data_compromised",
        "value" : true
      }, {
        "condition" : "has_regulators",
        "field" : "has_regulators",
        "value" : [ "HIPAA/HITECH Act" ]
      } ],
      "show_link_header" : false,
      "step_label" : "HIPAA"
    }, {
      "field_type" : null,
      "fields" : [ {
        "content" : "Europe Breach Risk Assessment",
        "element" : "header",
        "field_type" : null,
        "show_if" : null,
        "show_link_header" : false,
        "step_label" : null
      }, {
        "content" : "Co3.Views.IncidentsNewGDPR",
        "element" : "view",
        "field_type" : null,
        "show_if" : null,
        "show_link_header" : false,
        "step_label" : null
      } ],
      "predefined_uuid" : "89ac6f8b-9dba-4482-8ae9-4477464857e3",
      "show_if" : [ {
        "condition" : "equal_to",
        "field" : "incident.data_compromised",
        "value" : true
      }, {
        "condition" : "has_regulators",
        "field" : "has_regulators",
        "value" : [ "Austria", "Belgium", "Bulgaria", "Croatia", "Cyprus", "Czech Republic", "Denmark", "Estonia", "Finland", "France", "Germany", "Gibraltar", "Greece", "Guernsey", "Hungary", "Iceland", "Ireland", "Isle of Man", "Italy", "Jersey", "Latvia", "Liechtenstein", "Lithuania", "Luxembourg", "Malta", "Netherlands", "Norway", "Poland", "Portugal", "Romania", "Slovakia", "Slovenia", "Spain", "Sweden", "United Kingdom" ]
      } ],
      "show_link_header" : false,
      "step_label" : "Europe Breach Risk Assessment"
    }, {
      "field_type" : null,
      "fields" : [ {
        "content" : "PIPEDA Breach Risk Assessment",
        "element" : "header",
        "field_type" : null,
        "show_if" : null,
        "show_link_header" : false,
        "step_label" : null
      }, {
        "content" : "Co3.Views.IncidentCanadaPipeda",
        "element" : "view",
        "field_type" : null,
        "show_if" : null,
        "show_link_header" : false,
        "step_label" : null
      } ],
      "predefined_uuid" : "254cfeb0-ff6d-4369-b678-d7b39ab569cd",
      "show_if" : [ {
        "condition" : "equal_to",
        "field" : "incident.data_compromised",
        "value" : true
      }, {
        "condition" : "has_regulators",
        "field" : "has_regulators",
        "value" : [ "PIPEDA" ]
      } ],
      "show_link_header" : false,
      "step_label" : "PIPEDA Breach Risk Assessment"
    } ],
    "description" : null,
    "export_key" : "INCIDENT_WIZARD/wizard/null",
    "id" : 2,
    "name" : "wizard",
    "owner_id" : null,
    "perms" : null,
    "public" : true,
    "type" : 2,
    "uuid" : "e6c2d3f4-194b-4dc5-84da-1756a63ca6c1"
  } ],
  "locale" : "en",
  "message_destinations" : [ {
    "api_keys" : [ "8144f36a-6e84-4fa3-b6bb-82a07db997b1" ],
    "destination_type" : 0,
    "expect_ack" : true,
    "export_key" : "fn_main_mock_integration",
    "name" : "fn_main_mock_integration",
    "programmatic_name" : "fn_main_mock_integration",
    "tags" : [ {
      "tag_handle" : "fn_main_mock_integration",
      "value" : null
    } ],
    "users" : [ ],
    "uuid" : "f36c49bf-df8c-46f3-a4cd-9a0cba961f92"
  }, {
    "api_keys" : [ "8144f36a-6e84-4fa3-b6bb-82a07db997b1" ],
    "destination_type" : 0,
    "expect_ack" : true,
    "export_key" : "fn_test_two",
    "name" : "fn_test_two",
    "programmatic_name" : "fn_test_two",
    "tags" : [ {
      "tag_handle" : "fn_main_mock_integration",
      "value" : null
    } ],
    "users" : [ ],
    "uuid" : "fb3f8e6a-d939-4594-addf-6d69ec2381bf"
  } ],
  "notifications" : null,
  "overrides" : [ ],
  "phases" : [ {
    "enabled" : true,
    "export_key" : "Initial",
    "id" : 0,
    "name" : "Initial",
    "order" : 0,
    "perms" : null,
    "tags" : [ ],
    "uuid" : "5558dfa9-3c70-498b-aa39-c1538c1ae671"
  }, {
    "enabled" : true,
    "export_key" : "Engage",
    "id" : 0,
    "name" : "Engage",
    "order" : 1,
    "perms" : null,
    "tags" : [ {
      "tag_handle" : "fn_main_mock_integration",
      "value" : null
    } ],
    "uuid" : "ed053e3a-2d6d-47e1-8240-844ed93d4893"
  }, {
    "enabled" : true,
    "export_key" : "Detect/Analyze",
    "id" : 0,
    "name" : "Detect/Analyze",
    "order" : 2,
    "perms" : null,
    "tags" : [ ],
    "uuid" : "44868c86-246e-4e6e-8636-fa2848b2f279"
  }, {
    "enabled" : true,
    "export_key" : "Respond",
    "id" : 0,
    "name" : "Respond",
    "order" : 3,
    "perms" : null,
    "tags" : [ ],
    "uuid" : "ebad851d-5b5e-4d19-af79-fae53cc1f659"
  }, {
    "enabled" : true,
    "export_key" : "Post-Incident",
    "id" : 0,
    "name" : "Post-Incident",
    "order" : 4,
    "perms" : null,
    "tags" : [ ],
    "uuid" : "280a7bbe-3d93-4191-973f-2723b282a7e0"
  }, {
    "enabled" : true,
    "export_key" : "Custom",
    "id" : 0,
    "name" : "Custom",
    "order" : 5,
    "perms" : null,
    "tags" : [ ],
    "uuid" : "247d4b79-1762-4d70-bb95-67d83b104eff"
  }, {
    "enabled" : true,
    "export_key" : "Mock Custom Phase One",
    "id" : 0,
    "name" : "Mock Custom Phase One",
    "order" : 6,
    "perms" : null,
    "tags" : [ {
      "tag_handle" : "fn_main_mock_integration",
      "value" : null
    } ],
    "uuid" : "187b290c-19b5-4f29-97e8-16e9ff604a72"
  }, {
    "enabled" : true,
    "export_key" : "Mock Custom Phase Two",
    "id" : 0,
    "name" : "Mock Custom Phase Two",
    "order" : 7,
    "perms" : null,
    "tags" : [ {
      "tag_handle" : "fn_main_mock_integration",
      "value" : null
    } ],
    "uuid" : "44bfae00-280d-40db-9e14-124bd86002e5"
  }, {
    "enabled" : true,
    "export_key" : "Complete",
    "id" : 0,
    "name" : "Complete",
    "order" : 8,
    "perms" : null,
    "tags" : [ ],
    "uuid" : "d057ec97-587e-44c0-ae84-c4fadd6d7e40"
  } ],
  "playbooks" : [ {
    "activation_type" : "manual",
    "content" : {
      "content_version" : 1,
      "xml" : "<?xml version=\"1.0\" encoding=\"UTF-8\"?><definitions xmlns=\"http://www.omg.org/spec/BPMN/20100524/MODEL\" xmlns:bpmndi=\"http://www.omg.org/spec/BPMN/20100524/DI\" xmlns:omgdc=\"http://www.omg.org/spec/DD/20100524/DC\" xmlns:omgdi=\"http://www.omg.org/spec/DD/20100524/DI\" xmlns:resilient=\"http://resilient.ibm.com/bpmn\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" targetNamespace=\"http://www.camunda.org/test\"><process id=\"playbook_37b4be7a_9d54_442f_84f7_5add53d2c464\" isExecutable=\"true\" name=\"playbook_37b4be7a_9d54_442f_84f7_5add53d2c464\"><documentation/><startEvent id=\"StartEvent_155asxm\"><outgoing>Flow_13v2j0a</outgoing></startEvent><serviceTask id=\"ServiceTask_1\" name=\"mock_function_one\" resilient:type=\"function\"><extensionElements><resilient:function uuid=\"9b180887-4ff6-4d13-82a6-cb0a5d8718f1\">{\"inputs\":{\"49f10172-309a-4829-a5fe-1de71cdb4efb\":{\"input_type\":\"static\",\"static_input\":{\"multiselect_value\":[]}},\"01147ebf-ce3d-4cfb-814b-16145af4e511\":{\"input_type\":\"static\",\"static_input\":{\"multiselect_value\":[]}},\"92eb3b7a-8859-4846-81a3-2995aec74bdb\":{\"input_type\":\"static\",\"static_input\":{\"multiselect_value\":[]}},\"e40b9d9e-7ca1-45bc-913b-ce2a77e9b687\":{\"input_type\":\"static\",\"static_input\":{\"multiselect_value\":[],\"text_value\":\"\"}},\"866625eb-8b46-4cc9-b713-cdfa548a1189\":{\"input_type\":\"static\",\"static_input\":{\"multiselect_value\":[],\"text_content_value\":{\"format\":\"unknown\",\"content\":\"\"}}},\"b6dfde6d-7516-4509-a5a2-54e72df9e0cd\":{\"input_type\":\"static\",\"static_input\":{\"multiselect_value\":[],\"select_value\":\"0a30d6ad-914a-47b1-83bf-c5667dbee974\"}},\"df7df8ba-cb65-4400-8290-070b155d28d4\":{\"input_type\":\"static\",\"static_input\":{\"multiselect_value\":[]}},\"69dc0e78-a74b-4ccc-8d82-33b51780a569\":{\"input_type\":\"static\",\"static_input\":{\"multiselect_value\":[\"8b8b22d4-b20c-4d10-abac-a65211a5b9cd\",\"bf8e34a8-79aa-4ec4-b4c9-b8f1f0f7135e\"]}}},\"pre_processing_script\":\"inputs.mock_input_number = incident.id\\ninputs.mock_input_text = \\\"ड ढ ण त थ द ध न ऩ प फ ब some unicode text ड ढ ण त थ द ध न ऩ प फ ब\\\"\",\"pre_processing_script_language\":\"python3\",\"result_name\":\"mock_fn1_output\"}</resilient:function></extensionElements><incoming>Flow_13v2j0a</incoming><outgoing>Flow_0b3gwmq</outgoing></serviceTask><endEvent id=\"EndPoint_2\" resilient:documentation=\"End point\"><incoming>Flow_0b3gwmq</incoming></endEvent><sequenceFlow id=\"Flow_13v2j0a\" sourceRef=\"StartEvent_155asxm\" targetRef=\"ServiceTask_1\"/><sequenceFlow id=\"Flow_0b3gwmq\" sourceRef=\"ServiceTask_1\" targetRef=\"EndPoint_2\"/></process><bpmndi:BPMNDiagram id=\"BPMNDiagram_1\"><bpmndi:BPMNPlane bpmnElement=\"playbook_37b4be7a_9d54_442f_84f7_5add53d2c464\" id=\"BPMNPlane_1\"><bpmndi:BPMNEdge bpmnElement=\"Flow_0b3gwmq\" id=\"Flow_0b3gwmq_di\"><omgdi:waypoint x=\"721\" y=\"272\"/><omgdi:waypoint x=\"721\" y=\"444\"/></bpmndi:BPMNEdge><bpmndi:BPMNEdge bpmnElement=\"Flow_13v2j0a\" id=\"Flow_13v2j0a_di\"><omgdi:waypoint x=\"721\" y=\"117\"/><omgdi:waypoint x=\"721\" y=\"188\"/></bpmndi:BPMNEdge><bpmndi:BPMNShape bpmnElement=\"StartEvent_155asxm\" id=\"StartEvent_155asxm_di\"><omgdc:Bounds height=\"52\" width=\"187.083\" x=\"627\" y=\"65\"/><bpmndi:BPMNLabel><omgdc:Bounds height=\"0\" width=\"90\" x=\"616\" y=\"100\"/></bpmndi:BPMNLabel></bpmndi:BPMNShape><bpmndi:BPMNShape bpmnElement=\"ServiceTask_1\" id=\"ServiceTask_1_di\"><omgdc:Bounds height=\"84\" width=\"196\" x=\"623\" y=\"188\"/></bpmndi:BPMNShape><bpmndi:BPMNShape bpmnElement=\"EndPoint_2\" id=\"EndPoint_2_di\"><omgdc:Bounds height=\"52\" width=\"132.15\" x=\"655\" y=\"444\"/></bpmndi:BPMNShape></bpmndi:BPMNPlane></bpmndi:BPMNDiagram></definitions>"
    },
    "create_date" : 1644407372803,
    "creator_principal" : {
      "display_name" : "Admin User",
      "id" : 1,
      "name" : "admin@example.com",
      "type" : "user"
    },
    "description" : {
      "format" : "text",
      "content" : "A description with some unicode  Ʋ Ƴ ƴ Ƶ ƶ Ʒ Ƹ ƹ ƺ ƻ and \nmore\nhere\nड ढ ण त थ द ध न ऩ प फ ब"
    },
    "display_name" : "Main Mock Playbook",
    "export_key" : "main_mock_playbook",
    "field_type_handle" : "playbook_37b4be7a_9d54_442f_84f7_5add53d2c464",
    "fields_type" : {
      "actions" : [ ],
      "display_name" : "Main Mock Playbook",
      "export_key" : "playbook_37b4be7a_9d54_442f_84f7_5add53d2c464",
      "fields" : { },
      "for_actions" : false,
      "for_custom_fields" : false,
      "for_notifications" : false,
      "for_workflows" : false,
      "id" : null,
      "parent_types" : [ "__playbook" ],
      "properties" : {
        "can_create" : false,
        "can_destroy" : false,
        "for_who" : [ ]
      },
      "scripts" : [ ],
      "tags" : [ ],
      "type_id" : 28,
      "type_name" : "playbook_37b4be7a_9d54_442f_84f7_5add53d2c464",
      "uuid" : "bb2fbe0d-5f76-4379-b1b9-adb36143e158"
    },
    "id" : 1,
    "is_deleted" : false,
    "is_locked" : false,
    "last_modified_principal" : {
      "display_name" : "Admin User",
      "id" : 1,
      "name" : "admin@example.com",
      "type" : "user"
    },
    "last_modified_time" : 1644407373174,
    "local_scripts" : [ ],
    "manual_settings" : {
      "activation_conditions" : {
        "conditions" : [ {
          "evaluation_id" : null,
          "field_name" : "incident.incident_type_ids",
          "method" : "in",
          "type" : null,
          "value" : [ "Malware", "Phishing" ]
        } ],
        "logic_type" : "all"
      },
      "view_items" : [ ]
    },
    "name" : "main_mock_playbook",
    "object_type" : "incident",
    "status" : "enabled",
    "tags" : [ ],
    "uuid" : "37b4be7a-9d54-442f-84f7-5add53d2c464",
    "version" : 5
  } ],
  "regulators" : null,
  "roles" : [ {
    "description" : "Manage all incidents and run simulations.",
    "display_name" : "Administrator",
    "export_key" : "administrator",
    "id" : 0,
    "last_modified_by" : {
      "display_name" : "System User",
      "id" : 0,
      "name" : "System User",
      "type" : "system"
    },
    "last_modified_time" : 1595863802292,
    "name" : "administrator",
    "permissions" : [ "create_incident", "create_simulation", "delete_all_incidents", "download_incident_emails", "edit_all_incident_notes", "edit_all_incidents_fields", "edit_all_incidents_members", "edit_all_incidents_owner", "edit_all_incidents_status", "edit_all_incidents_workspaces", "edit_all_private_task_notes", "edit_all_private_tasks", "edit_all_public_task_notes", "edit_all_public_tasks", "edit_task_header", "manage_org_wikis", "read_all_action_invocations", "read_all_incidents", "read_all_private_tasks" ],
    "tags" : [ ],
    "type_id" : "organization",
    "uuid" : "0a4f569e-df7e-448b-8e55-417d5a75dd23",
    "version" : 0
  }, {
    "description" : "Create incidents.",
    "display_name" : "Incident Creator",
    "export_key" : "incident_creator",
    "id" : 0,
    "last_modified_by" : {
      "display_name" : "System User",
      "id" : 0,
      "name" : "System User",
      "type" : "system"
    },
    "last_modified_time" : 1595863802304,
    "name" : "incident_creator",
    "permissions" : [ "create_incident", "edit_task_header" ],
    "tags" : [ ],
    "type_id" : "organization",
    "uuid" : "7663c73f-2431-4eda-84bf-03c20153d4f1",
    "version" : 0
  }, {
    "description" : "Access all incidents and administration functions.",
    "display_name" : "Master Administrator",
    "export_key" : "master_administrator",
    "id" : 0,
    "last_modified_by" : {
      "display_name" : "System User",
      "id" : 0,
      "name" : "System User",
      "type" : "system"
    },
    "last_modified_time" : 1595863802254,
    "name" : "master_administrator",
    "permissions" : [ "admin_all_dashboards_filters", "admin_all_groups", "admin_all_roles", "admin_all_users", "admin_all_workspaces", "admin_apikeys", "admin_organization", "create_incident", "create_simulation", "delete_all_incidents", "delete_inbox_emails", "download_inbox_emails", "download_incident_emails", "edit_all_incident_notes", "edit_all_incidents_fields", "edit_all_incidents_members", "edit_all_incidents_owner", "edit_all_incidents_status", "edit_all_incidents_workspaces", "edit_all_private_task_notes", "edit_all_private_tasks", "edit_all_public_task_notes", "edit_all_public_tasks", "edit_privacy_data", "edit_task_header", "manage_apps", "manage_org_wikis", "read_all_action_invocations", "read_all_incidents", "read_all_private_tasks", "read_inbox_emails" ],
    "tags" : [ ],
    "type_id" : "organization",
    "uuid" : "64564876-d460-4915-8264-98d7a33c74e8",
    "version" : 0
  }, {
    "description" : "Access all incidents and update when a member.",
    "display_name" : "Observer",
    "export_key" : "observer",
    "id" : 0,
    "last_modified_by" : {
      "display_name" : "System User",
      "id" : 0,
      "name" : "System User",
      "type" : "system"
    },
    "last_modified_time" : 1595863802308,
    "name" : "observer",
    "permissions" : [ "edit_all_incident_notes", "edit_all_private_task_notes", "edit_all_public_task_notes", "edit_task_header", "read_all_incidents", "read_all_private_tasks" ],
    "tags" : [ ],
    "type_id" : "organization",
    "uuid" : "241684e8-eea4-42f9-bb02-8a75e875b476",
    "version" : 0
  } ],
  "scripts" : [ {
    "actions" : [ ],
    "created_date" : 1644407279321,
    "creator_id" : "admin@example.com",
    "description" : "",
    "enabled" : false,
    "export_key" : "Mock Incident Script",
    "id" : 2,
    "language" : "python",
    "last_modified_by" : "admin@example.com",
    "last_modified_time" : 1644407279342,
    "name" : "Mock Incident Script",
    "object_type" : "incident",
    "playbook_handle" : null,
    "programmatic_name" : "mock_incident_script",
    "script_text" : "log.info(\"Run this\")",
    "tags" : [ {
      "tag_handle" : "fn_main_mock_integration",
      "value" : null
    } ],
    "uuid" : "52e88afe-0ca8-4bac-823f-980bc8ba2931"
  }, {
    "actions" : [ ],
    "created_date" : 1644407279363,
    "creator_id" : "admin@example.com",
    "description" : "a sample Artifact script",
    "enabled" : false,
    "export_key" : "Mock Script One",
    "id" : 3,
    "language" : "python",
    "last_modified_by" : "admin@example.com",
    "last_modified_time" : 1644407279380,
    "name" : "Mock Script One",
    "object_type" : "artifact",
    "playbook_handle" : null,
    "programmatic_name" : "mock_script_one",
    "script_text" : "log.info(\"Print this message\")",
    "tags" : [ {
      "tag_handle" : "fn_main_mock_integration",
      "value" : null
    } ],
    "uuid" : "d73d75f5-d8cf-4c00-8110-c5bf258b51da"
  }, {
    "actions" : [ ],
    "created_date" : 1595863805123,
    "creator_id" : "System User",
    "description" : "This script processes inbound emails. Change the new incident owner value on line 8 before running. The script creates an incident from an email message, adds artifacts to the incident, based on information in the body of the message, and adds any email attachments to the incident.",
    "enabled" : false,
    "export_key" : "Sample script: process inbound email (v35)",
    "id" : 1,
    "language" : "python",
    "last_modified_by" : "System User",
    "last_modified_time" : 1595863805123,
    "name" : "Sample script: process inbound email (v35)",
    "object_type" : "__emailmessage",
    "playbook_handle" : null,
    "programmatic_name" : "sample_script_process_inbound_email_v35",
    "script_text" : "import re\n\n# A script to create an incident from an email message, add artifacts to the incident based on information\n# present in the body of the message, and add any email attachments to the incident.\n\n# The new incident owner - the email address of a user or the name of a group and cannot be blank.\n# Change this value to reflect who will be the owner of the incident before running the script.\nnewIncidentOwner = \"\"\n\n# Whitelist for IP V4 addresses\nipV4WhiteList = [\n  #\"127.0.0.0/8\",                # Loopback\n  #\"192.168.0.0/16\",             # Class B private network local communication (RFC 1918)\n  #\"198.18.0.0/15\",              # Testing of inter-network communications between subnets (RFC 2544)\n  #\"169.254.0.0/16\",             # Link-local (APIPA)\n  #\"224.0.0.0/4\",                # Multicast\n  #\"192.88.99.0/24\",             # 6to4 anycast relays (RFC 3068)\n  #\"0.0.0.0/8\",                  # Broadcast message (RFC 1700)\n  #\"192.0.2.0/24\",               # TEST-NET examples and documentation (RFC 5737)\n  #\"240.0.0.0/4\",                # Reserved for  multicast assignments (RFC 5771)\n  #\"198.51.100.0/24\",            # TEST-NET-2 examples and documentation (RFC 5737)\n  #\"203.0.113.0/24\",             # TEST-NET-3 examples and documentation (RFC 5737)\n  #\"233.252.0.0/24\",             # Multicast test network\n  #\"225.0.0.0-231.255.255.255\",  # Reserved (RFC5771)\n  #\"234.0.0.0-238.255.255.255\",  # Unicast-prefix-based\n  #\"239.0.0.0-239.255.255.255\"   # Administrative Multicast\n]\n\n# Whitelist for IP V6 addresses\nipV6WhiteList = [\n  #\"::/8\",                       # Reserved by IETF [RFC3513][RFC4291]\n  #\"0100::/8\",                   # Reserved by IETF [RFC3513][RFC4291]\n  #\"0200::/7\",                   # Reserved by IETF [RFC4048]\n  #\"0400::/6\",                   # Reserved by IETF [RFC3513][RFC4291]\n  #\"0800::/5\",                   # Reserved by IETF [RFC3513][RFC4291]\n  #\"1000::/4\",                   # Reserved by IETF [RFC3513][RFC4291]\n  #\"4000::/3\",                   # Reserved by IETF [RFC3513][RFC4291]\n  #\"6000::/3\",                   # Reserved by IETF [RFC3513][RFC4291]\n  #\"8000::/3\",                   # Reserved by IETF [RFC3513][RFC4291]\n  #\"A000::/3\",                   # Reserved by IETF [RFC3513][RFC4291]\n  #\"C000::/3\",                   # Reserved by IETF [RFC3513][RFC4291]\n  #\"E000::/4\",                   # Reserved by IETF [RFC3513][RFC4291]\n  #\"F000::/5\",                   # Reserved by IETF [RFC3513][RFC4291]\n  #\"F800::/6\",                   # Reserved by IETF [RFC3513][RFC4291]\n  #\"FC00::/7\",                   # Unique Local Addresses (ULA)\n  #\"FE00::/9\",                   # Reserved by IETF [RFC3513][RFC4291]\n  #\"FEC0::/1                     # Reserved by IETF [RFC3879]\n]\n\n# Domain whitelist\ndomainWhiteList = [\n  #\"*.ibm.com\"\n]\n\nclass Utils:\n  \"\"\" A class to collect some utilities used by the rest of the script. \"\"\"\n\n  @staticmethod\n  def convertIPv4ToInt(address):\n    \"\"\" A static method that converts a IPv4 address to a binary representation. \"\"\"\n    addressAsBinary = 0\n    #split into octets\n    octets = address.split(\".\")\n    #startFromLeft\n    lpos = 32 - 8\n    for octet in octets:\n      octetAsInt = int(octet)\n      addressAsBinary = addressAsBinary + (octetAsInt << lpos)\n      lpos = lpos - 8\n    return addressAsBinary\n\n  @staticmethod\n  def convertIPV4v6ToInt(address):\n    \"\"\" A static method that converts a IPv4 and IPv6 address to a binary representation. \"\"\"\n    addressAsBinary = 0\n    # Split into hextets\n    hextets = address.split(\":\")\n    # It might be a V4 IP address in a V6 envelope\n    if \".\" in hextets[-1]:\n      return Utils.convertIPv4ToInt(hextets[-1])\n    else:\n      # Start from Left\n      lpos = 128 - 16\n      for hextet in hextets:\n        if len(hextet) == 0:\n          break\n        hextetAsInt = int(hextet,16)\n        addressAsBinary = addressAsBinary + (hextetAsInt << lpos)\n        lpos = lpos - 16\n      # If the previous loop has exited without covering all the hextets then it means there is a \"::\" present,\n      # so we have to process the reamining hextets from the right\n      if lpos > 0:\n        rpos = 0\n        for hextet in hextets[::-1]:\n          if len(hextet) == 0:\n            break\n          hextetAsInt = int(hextet,16)\n          addressAsBinary = addressAsBinary + (hextetAsInt << rpos)\n          rpos = rpos + 16\n      return addressAsBinary\n\n\nclass WhiteListElement(object):\n  \"\"\" A class that represents a domain, IP address range or network segment that has been verified as not being suspicious. \"\"\"\n\n  # A text representation of the element\n  asString = None\n\n  def __init__(self, elementAsString):\n    \"\"\" The constructor that takes one parameter - the textual representation of the element. \"\"\"\n    self.asString = elementAsString\n\n  def __str__(self):\n    \"\"\"Method to return the text representation of the object.\"\"\"\n    return self.asString\n\n  def __repr__(self):\n    \"\"\"Method to return the text representation of the object.\"\"\"\n    return u\"WhiteListElement(\\\"{0}\\\")\".format(self.asString)\n\n  def test(self, other):\n    \"\"\" A function intended to be inherited but overrided by subclasses. It should return True if the \"other\" object\n    would be matched by this white list element.\n    \"\"\"\n    return False\n\n\nclass IPAddress:\n  \"\"\" A class for IP addresses, both IPv4 and IPv6. \"\"\"\n\n  # The IP address as a String, as originally presented to the constructor\n  addressAsString = None\n\n  # The IP Address as a binary representation\n  addressAsBinary = None\n\n  def __init__(self, newAddressAsString):\n    \"\"\" The constructor, which takes one parameter - the string representation to be used to create the addressAsBinary. \"\"\"\n    self.addressAsString = newAddressAsString.strip()\n    self.addressAsBinary = Utils.convertIPV4v6ToInt(self.addressAsString)\n\n  def __str__(self):\n    \"\"\"Method to return the text representation of the object.\"\"\"\n    return self.addressAsString\n\n  def __repr__(self):\n    \"\"\"Method to return the text representation of the object.\"\"\"\n    return \"IPAddress(\\\"{0}\\\")\".format(self.addressAsString)\n\n\nclass CIDR(WhiteListElement):\n  \"\"\" A CIDR (Classless Inter-Domain Routing) is one of the possible types of white list element, representing either an explicit IP Address or\n  a subnet in the form of an IP Address and a subnet mask suffix. E.G.\n  127.0.0.1\n  10.0.0.0/8\n  fc00::/7\n  \"\"\"\n\n  # The suffix/subnet mask (defaults to 0 when not present)\n  cidrSuffix = 0\n  # Width of the address in bits (32 for IPv4, 128 for IPv6)\n  width = 32\n  # The address as a binary number\n  addressAsBinary = 0\n\n  def __init__(self, newCIDR):\n    \"\"\" CIDR constructor. This takes one parameter which is the textual representation of the CIDR. \"\"\"\n    # Store the textual representation in the base class\n    super(CIDR, self).__init__(newCIDR)\n    # Split at the subnet separator character (if present)\n    cidrParts = self.asString.split(\"/\")\n    # The first part is interpreted the IP address\n    self.addressAsBinary = Utils.convertIPV4v6ToInt(cidrParts[0])\n\n    self.width = 128 if \":\" in newCIDR else 32\n\n    # If there is a suffix, interpret it correctly\n    if len(cidrParts) > 1:\n      self.cidrSuffix = int(cidrParts[1])\n    else:\n      self.cidrSuffix = self.width\n\n  def test(self, anIPAddress):\n    \"\"\" An IP address matches the CIDR if both of them have the same binary value when both are shifted right by the\n    CIDR subnet mask suffix.\n    \"\"\"\n    log.debug(\"Going to filter IPAddress {0} against {1}\".format(anIPAddress, self))\n    return (anIPAddress.addressAsBinary >> (self.width - self.cidrSuffix) == self.addressAsBinary >> (self.width - self.cidrSuffix))\n\n\nclass IPRange(WhiteListElement):\n  \"\"\" A type of WhiteListElement that represents a range, from a lower bound to an upper bound, inclusive. \"\"\"\n  lowest = None\n  highest = None\n\n  def __init__(self, stringRepresentation):\n    \"\"\" IPRange constructor that takes two parameters.\n    Parameter \"lowestAsText\" - the lowest IP address in the range.\n    Parameter \"highestAsText\" - the highest IP address in the range.\n    \"\"\"\n    lowestAsText, highestAsText = stringRepresentation.split(\"-\")\n    super(IPRange, self).__init__(stringRepresentation)\n    self.lowest = IPAddress(lowestAsText)\n    self.highest = IPAddress(highestAsText)\n\n  def test(self, anIPAddress):\n    \"\"\" A method that returns true if anIPAddress is not below self.lowest and not above self.highest. \"\"\"\n    return self.highest.addressAsBinary >= anIPAddress.addressAsBinary and self.lowest.addressAsBinary <= anIPAddress.addressAsBinary\n\n  def __str__(self):\n    \"\"\"Method to return the text representation of the object.\"\"\"\n    return \"{0}-{1}\".format(self.lowest, self.highest)\n\n  def __repr__(self):\n    \"\"\"Method to return the text representation of the object.\"\"\"\n    return \"IPRange(\\\"{0}-{1}\\\")\".format(self.lowest, self.highest)\n\n\nclass Domain(WhiteListElement):\n  \"\"\" A type of WhiteListElement that represents a domain or domain pattern. E.G.\n  *.ibm.com\n  mailserver.knowngood.com\n  \"\"\"\n\n  # A regular expression to match the domain. Domains of the form \"*.example.com\" are converted to \".*.example.com\"\n  processedRegEx = None\n\n  def __init__(self, stringRepresentation):\n    \"\"\" Constructor for the Domain class. This takes one parameter - the domain pattern as a String. \"\"\"\n    # Save the string representation in the superclass\n    super(Domain, self).__init__(unicode(stringRepresentation))\n    # \"ibm.com\" and \"*.ibm.com\" are synonymous\n    if (stringRepresentation.startswith(\"*.\")):\n      stringRepresentation = stringRepresentation[2:]\n    self.processedRegEx = u\"\\A(?:\\\\S*\\\\.)*({0})\\\\Z\".format(stringRepresentation.replace(\".\",\"\\.\"))\n\n  def test(self, urlString):\n    \"\"\" A method that returns true if the value passed in urlString matches the regex in self.processedRegEx. \"\"\"\n    # Extract domain from urlString\n    domain = re.sub(\".*://([^/:|~`\\s<>\\\"'{}]*)(?:[/:|~`\\s<>\\\"'{}]|\\Z).*\", r\"\\1\", urlString, re.IGNORECASE | re.UNICODE)\n    # Match regex of this Domain object against extracted domain string\n    matches = re.findall(self.processedRegEx, domain, re.IGNORECASE | re.UNICODE)\n    return (matches != None) and (len(matches) > 0)\n\n  def __str__(self):\n    \"\"\"Method to return the text representation of the object.\"\"\"\n    return u\"{0}\".format(self.asString)\n\n  def __repr__(self):\n    \"\"\"Method to return the text representation of the object.\"\"\"\n    return u\"Domain(\\\"{0}\\\")\".format(self.asString)\n\n\nclass WhiteList(list):\n  \"\"\" A class that extends the list class to support the white list facility. \"\"\"\n\n  def checkIsItemNotOnWhiteList(self, anItem):\n    \"\"\" A method that checks if an item should be removed from the artifact list because if matches a whitelist element.\n    Parameter \"anItem\" - the item in question.\n    Return value: The item if it should be kept, None if it should be removed.\n    \"\"\"\n    for whiteListEntry in self:\n      if whiteListEntry.test(anItem):\n        log.info(u\"Filtering out {0} because it matched with whitelist entry {1}\".format(anItem, self))\n        return None\n    return anItem\n\n  @staticmethod\n  def createFromIPv4Collection(theList):\n    \"\"\" A static method to create a list of IPv4 WhiteListElements based on a list of strings.\n    Parameter \"theList\" - the list of string representations of WhiteListElements suitable for IPv4.\n    Return value: A WhiteList that can be used against IPv4 addresses.\n    \"\"\"\n    completedList = WhiteList()\n    for element in theList:\n      if \"-\" in element:\n        completedList.append(IPRange(element))\n      else:\n        completedList.append(CIDR(element))\n    return completedList\n\n  @staticmethod\n  def createFromCollection(theList, constructor):\n    \"\"\" A static method to create a list of WhiteListElements based on a list of strings.\n    Parameter \"theList\" - the list of string representations of WhiteListElements.\n    Parameter \"constructor\" - the class for objects that will populate the return value.\n    Return value: A WhiteList that can be used against IPv4 addresses.\n    \"\"\"\n    completedList = WhiteList()\n    for element in theList:\n      completedList.append(constructor(element))\n    return completedList\n\n\nclass EmailProcessor(object):\n  \"\"\" A class that facilitates processing the body contents of an email message.\n  Once the EmailProcessor class has been instanciated, the other methods can be used to add artifacts to the\n  incident.\n  \"\"\"\n\n  # The body of the email - the plaintext and html versions of the same email, if present\n  emailContents = []\n\n  # The set of already-added artifacts. If an artifact is in the set then it will not be added to the incident\n  # a second time.\n  addedArtifacts = set()\n\n  # Create Whitelist for IP V4 addresses from string representations\n  ipV4WhiteListConverted = WhiteList.createFromIPv4Collection(ipV4WhiteList)\n\n  # Create Whitelist for IP V6 addresses from string representations\n  ipV6WhiteListConverted = WhiteList.createFromCollection(ipV6WhiteList, CIDR)\n\n  # Create Whitelist domains from string representations\n  domainWhiteListConverted = WhiteList.createFromCollection(domainWhiteList, Domain)\n\n  def __init__(self):\n    \"\"\"The EmailProcessor constructor.\n    As initilization it retrieves the email body as both text and HTML.\n    \"\"\"\n    if (emailmessage.body.content is not None):\n      self.emailContents.append(unicode(emailmessage.body.content))\n    if (emailmessage.getBodyHtmlRaw() is not None):\n      self.emailContents.append(unicode(emailmessage.getBodyHtmlRaw()))\n    if (len(self.emailContents) == 0):\n      log.error(\"Email message has no contents!\")\n\n  def addUniqueArtifact(self, theArtifact, artifactType, description):\n    \"\"\"This method adds a new unique artifact to the incident. Previously added artifacts are added to the\n    \"addedArtifacts\" set. If the new artifact has already been added to the list then it is not added to the\n    incident a second time.\n    Parameter \"theArtifact\" - the value of the artifact to create.\n    Parameter \"artifactType\" - the type of the artifact.\n    Parameter \"description\" - the description of the artifact.\n    No return value.\n    \"\"\"\n    if (theArtifact, artifactType) in self.addedArtifacts:\n      log.debug(u\"Skipping previously added artifact {0} of type {1}, description {2}\".format(theArtifact, artifactType, description))\n    else:\n      log.info(u\"Adding artifact {0} of type {1}, description {2}\".format(theArtifact, artifactType, description))\n      incident.addArtifact(artifactType, theArtifact, description)\n      self.addedArtifacts.add((theArtifact, artifactType))\n\n  @staticmethod\n  def printList(name, list):\n    \"\"\"A convenience method to log the contents of a list. The method will log each element in a list, along with\n    its name and ordinal in the list.\n    Parameter \"name\" - the name of the elements in the list e.g. \"IP Address\".\n    Parameter \"list\" - the list to iterate through.\n    No return value.\n    \"\"\"\n    for num, value in enumerate(list):\n      log.debug(u\"{0} {1} {2}\".format(name, num, value))\n\n  @staticmethod\n  def makeUrlPattern():\n    \"\"\"A method to return a regex pattern that includes a full URL including scheme, domain, path, hash and\n    query string. It starts the match from the scheme name with optional \"s\", followed by \"://\" and continues until\n    it finds a character that is not permitted in a URL. Because of the expectation that potentially harmful URLs\n    are being modified for safety, the URL-invalid characters \"[\" and \"]\" will not terminate the match.\n    Returns the requested pattern as a string.\n    \"\"\"\n    return \"((?:https?://[^^|~`\\\\s<>\\\"'{}]+)|(?:href=\\\"(?:[^^|~`\\\\s<>\\\"'{}]+)))\"\n\n  @staticmethod\n  def fixURL(theURL):\n    \"\"\"Method to fix a list of bowdlerized URLs. Many systems attempts to make potentially dangerous URLs into\n    unopenable but human-readible strings. Resilient will reject URL artifacts that do not conform to spec.\n    In this case we are converting \"www[.]dangerous[.]nasty\" to \"www.dangerous.nasty\".\n    If a URL is discovered in HTML anchor it will have href=\" before it.\n    If the URL does not contain :// then http:// is presumed.\n    Parameter \"list\" - the list of URLs to fix.\n    Returns a new list containing fixed versions of the original list.\n    \"\"\"\n    retVal = re.sub(r\"\\[\\.\\]\",\".\", theURL)\n    retVal = re.sub(r\"href=\\\"\",\"\", retVal)\n    if (\"://\" not in retVal):\n      retVal = \"http://\" + retVal\n    return retVal\n\n  @staticmethod\n  def makeIPv4Pattern():\n    \"\"\"A method to return a pattern that matches valid IPv4 addresses.\n    Returns a string containing a pattern that matches 4 instances of 1-3 decimal digits, separated by \".\".\n    \"\"\"\n    return \"(?:[\\d]{1,3}\\.){3}[\\d]{1,3}\"\n\n  @staticmethod\n  def cleanIPv4(anAddress):\n    \"\"\"A method to filter out impossible IP4 addresses from a list of strings that have been matched by the pattern\n    from makeIPv4Pattern().\n    First each address is split into its component octets. If the maximum int value of an octet in an address is\n    less than 256 then the address is valid. The return value is a set, to avoid unnecessary duplication.\n    Parameter \"addressList\" - the list of addresses to filter.\n    Returns a new set of valid addresses.\n    \"\"\"\n    octets = anAddress.split(\".\")\n    octetsAsIntArray = map(int, octets)\n    if (len(octets) != 4) or max(octetsAsIntArray) > 255:\n      return None\n    else:\n      return \".\".join(map(str, octetsAsIntArray)) # eliminate leading zeros.\n\n  @staticmethod\n  def makeIPv6Pattern():\n    \"\"\"A method to return a pattern that will match IPv6 addresses.\n    The pattern will match strings of the form:\n    abcd:abcd:1234:abcd:abcd:abcd:abcd:abcd:abcd\n    abcd:abcd::abcd:abcd:abcd:abcd:abcd\n    abcd:abcd:abcd:abcd:abcd:abcd::abcd\n    ::1\n    ::ffff:192.0.1.1\n    but it will also match strings such as\n    16:38:37\n    This necessitates a second cleaning stage, performed by cleanIPv6().\n    \"\"\"\n    return \"((?:(?:[A-Fa-f0-9]){0,4}:){1,7}(?:[A-Fa-f0-9]){1,4}(?:\\\\.[0-9]{1,3}){0,3})\"\n\n  @staticmethod\n  def cleanIP(anAddress):\n    \"\"\"A method to filter invalid IP addresses from the addressList parameter. The list is presumed to derive\n    from matching text based on the output of makeIPv6Pattern() or makeIPv4Pattern().\n    If the method discovers that the address is encapsulated IPv4 then the method will return the result from calling\n    cleanIPv4() on the IPv4 section. If the address is IPv6 the method will reject strings with more than 7 \":\"s or\n    more than one instance of \"::\". If there is no \"::\" then there must be 7 \":\"s.\n    \"\"\"\n    log.debug(\"Going to clean IP address {0}\".format(anAddress))\n    hextets = anAddress.split(\":\")\n    # It might be a V4 IP address in a V6 envelope\n    if \".\" in hextets[-1]:\n      return EmailProcessor.cleanIPv4(hextets[-1])\n    # At most 7 \":\"\n    if anAddress.count(\":\") < 8:\n      # At most one instance of \"::\"\n      if anAddress.count(\"::\") < 2:\n        if anAddress.count(\"::\") == 1 or anAddress.count(\":\") == 7:\n          return anAddress\n    return None\n\n  @staticmethod\n  def makeHexPattern(length):\n    \"\"\"A method that returns a regex pattern that matches a case-insensitive hexadecimal number of exactly a specified\n    length.\n    Parameter \"length\" - the length of the pattern in digits/characters/nibbles\n    Returns the corresponding pattern.\n    \"\"\"\n    return \"(?:\\A|[^0-9a-zA-Z])([0-9a-fA-F]{\" + str(length) + \"})(?:[^0-9a-zA-Z]|\\Z)\"\n\n  def processArtifactCategory(self, regex, artifactType, description, *optionalListModifierFn):\n    \"\"\"A method to process a category of artifact, based on a regular expression. Each match of the regex in the\n    email message contents is added as an artifact of the same type and description. The optional list modifier\n    function, if present, is run against the list of matches before the artifact addition takes place.\n    Parameter \"regex\" - the regular expression to use to pick out the text to interpret as an artifact\n    Parameter \"artifactType\" - the type of the artifact\n    Parameter \"description\" - the description of the artifact\n    Parameter \"optionalListModifierFn\" - a function to run across the list of matches to filter inappropriate values\n    No return value.\n    \"\"\"\n    for theText in self.emailContents:\n      dataList = re.findall(regex, theText, re.UNICODE)\n      if dataList is not None and len(dataList) > 0 :\n        if optionalListModifierFn is not None:\n          for aFunction in optionalListModifierFn:\n            dataList = map(aFunction, dataList)\n            dataList = [x for x in dataList if x is not None]\n\n        self.printList(u\"Found {0} ( {1} )\".format(artifactType,description), dataList)\n        map(lambda theArtifact: self.addUniqueArtifact(theArtifact, artifactType, description), dataList)\n      else:\n        log.debug(u\"Could not find artifact {0} for regex {1}\".format(artifactType,regex))\n\n  def checkIPWhiteList(self, anAddress):\n    \"\"\" A method to check a list of IP Addresses aginst the whitelist. \"\"\"\n    whiteList = self.ipV4WhiteListConverted if \".\" in anAddress.addressAsString else self.ipV6WhiteListConverted\n    log.debug(u\"Going to filter {0} against whitelist {1}\".format(anAddress, whiteList))\n    return whiteList.checkIsItemNotOnWhiteList(anAddress)\n\n  def checkDomainWhiteList(self, aURL):\n    \"\"\" A method to check a list of URLs aginst a whitelist. \"\"\"\n    log.debug(u\"Going to filter {0} against whitelist {1}\".format(aURL, self.domainWhiteListConverted))\n    return self.domainWhiteListConverted.checkIsItemNotOnWhiteList(aURL)\n\n  def processIPFully(self, theAddressAsString):\n    \"\"\" A method to filter inadvertantly matched IP strings and then filter out IP addresses that appear on the whitelist.\n    Parameter \"theAddressAsString\" - The address in question as a string\n    Return value - if the address passes the tests then it is returned, otherwise None.\n    \"\"\"\n    theAddressAsString = self.cleanIP(theAddressAsString)    # Remove invalid address matches\n    if theAddressAsString is not None:\n      theAddressAsObj = IPAddress(theAddressAsString)      # Convert to IPAddress object\n      if theAddressAsObj is not None:\n        theAddressAsObj = self.checkIPWhiteList(theAddressAsObj) # Check against whitelist\n        if theAddressAsObj is not None:\n          return theAddressAsObj.addressAsString         # Convert back to String\n    return None                          # The address was filtered out\n\n  def processAttachments(self):\n    \"\"\" A method to process the email attachments, if present. Each non-inline email attachment is added as an\n    attachment to the incident, and its name is added as an artifact. Inline attachments are assumed to be unimportant.\n    No return value.\n    \"\"\"\n    for attachment in emailmessage.attachments:\n      if not attachment.inline:\n        incident.addEmailAttachment(attachment.id)\n        incident.addArtifact(\"Email Attachment Name\", attachment.suggested_filename, \"\")\n\n  def addBasicInfoToIncident(self):\n    \"\"\"A method to perform basic information extraction from the email message.\n    The email message sender address, including personal name if present, is set as the reporter field\n    in the incident. An artifact is created from the email message subject with the type \"Email Subject\".\n    No return value.\n    \"\"\"\n    newReporterInfo = emailmessage.from.address\n    if emailmessage.from.name is not None:\n      newReporterInfo = u\"{0} <{1}>\".format(emailmessage.from.name, emailmessage.from.address)\n      log.info(u\"Adding reporter field \\\"{0}\\\"\".format(newReporterInfo))\n      incident.reporter = newReporterInfo\n\n      if emailmessage.subject is not None:\n        self.addUniqueArtifact(u\"{0}\".format(emailmessage.subject), \"Email Subject\", \"Suspicious email subject\")\n\n###\n# Mainline starts here\n###\n\n# Create the email processor object, loading it with the email message body content.\nprocessor = EmailProcessor()\n\n# Create a suitable title for an incident based on the email\nnewIncidentTitle = u\"Incident generated from email \\\"{0}\\\" via mailbox {1}\".format(emailmessage.subject, emailmessage.inbound_mailbox)\n\n# Check to see if a similar incident already exists\n# We will search for an incident which has the same name as we would give a new incident\nquery_builder.equals(fields.incident.name, newIncidentTitle)\nquery_builder.equals(fields.incident.plan_status, \"Active\")\nquery = query_builder.build()\nincidents = helper.findIncidents(query)\n\nif len(incidents) == 0:\n  # A similar incident does not already exist. Create a new incident and associate the email with it.\n  log.info(u\"Creating new incident {0}\".format(newIncidentTitle))\n\n  # Create an incident with a title based on the email subject, owned identified by variable newIncidentOwner\n  emailmessage.createAssociatedIncident(newIncidentTitle, newIncidentOwner)\n\n  # Add the subject to the incident as an artifact, and set the incident reporter.\n  # This does not need to be done for an existing incident.\n  processor.addBasicInfoToIncident()\n\nelse:\n  # A similar incident already exists. Associate the email with this preexisting incident.\n  log.info(u\"Associating with existing incident {0}\".format(incidents[0].id))\n  emailmessage.associateWithIncident(incidents[0])\n\n# Capture any URLs present in the email body text and add them as artifacts\nprocessor.processArtifactCategory(processor.makeUrlPattern(), \"URL\", \"Suspicious URL\", processor.fixURL, processor.checkDomainWhiteList)\n\n# Capture any IPv4 addresses present in the email body text and add them as artifacts\nprocessor.processArtifactCategory(processor.makeIPv4Pattern(), \"IP Address\", \"Suspicious IP Address\", processor.processIPFully)\n\n# Capture any IPv6 addresses present in the email body text and add them as artifacts\nprocessor.processArtifactCategory(processor.makeIPv6Pattern(), \"IP Address\", \"Suspicious IP Address\", processor.processIPFully)\n\n# Capture 32-character hexadecimal substrings in the email body text and add them as MD5 hash artifacts\nprocessor.processArtifactCategory(processor.makeHexPattern(32), \"Malware MD5 Hash\", \"MD5 hash of potential malware file\")\n\n# Capture 40-character hexadecimal substrings in the email body text and add them as SHA-1 hash artifacts\nprocessor.processArtifactCategory(processor.makeHexPattern(40), \"Malware SHA-1 Hash\", \"SHA-1 hash of potential malware file\")\n\n# Capture 64-character hexadecimal substrings in the email body text and add them as SHA-256 hash artifacts\nprocessor.processArtifactCategory(processor.makeHexPattern(64), \"Malware SHA-256 Hash\", \"SHA-256 hash of potential malware file\")\n\n# Add email message attachments to incident\nprocessor.processAttachments()",
    "tags" : [ ],
    "uuid" : "66ab02f1-d4ab-4239-98ce-312daebf8197"
  } ],
  "server_version" : {
    "build_number" : 49,
    "major" : 43,
    "minor" : 1,
    "version" : "43.1.49"
  },
  "tags" : [ {
    "created" : 1644407261998,
    "creator" : {
      "display_name" : "Admin User",
      "id" : 1,
      "name" : "admin@example.com",
      "type" : "user"
    },
    "display_name" : "fn_main_mock_integration",
    "export_key" : "fn_main_mock_integration",
    "id" : 1,
    "last_modified_by" : {
      "display_name" : "Admin User",
      "id" : 1,
      "name" : "admin@example.com",
      "type" : "user"
    },
    "last_modified_time" : 1644407278788,
    "name" : "fn_main_mock_integration",
    "prefix" : "fn_main_mock_integration",
    "type" : "configuration",
    "uuid" : "6952efe2-4c78-c18c-2779-9f2402ddb574",
    "version" : 1
  } ],
  "task_order" : [ "f35d43af-7656-4693-89ba-1554ebcbc36d", "d4d3a7e8-8c5d-4166-9902-5847acde272a", "eb516d12-701f-4442-8219-cf38584fb204", "a68bfa69-15bb-46b7-a180-ad2ac49ffa03", "2d261a8a-14c3-4f0f-a237-7c6a76bf82b1", "2e05bff9-8d15-4424-91c1-9e50d2c78bae", "e799edeb-7bf2-4b9b-9802-4befb16c1ed7", "d4568234-4400-4850-885b-a1be97adb253", "78b62efd-56f9-4deb-8566-135417d03efa", "64418f24-1925-4054-a8c4-8c891790d9a8", "d0b4df39-6eff-4bb1-afa9-47f6e3fabff1", "6220ee1c-9b90-4ddd-b09b-0df6a0542ad1", "6547c4ea-bf23-499d-b3f6-918c3a05dbcb", "b6059f4d-e178-4727-9857-232f6d162579", "3f1e013c-833b-44bd-aebe-d005cbbd333d", "b6746cd0-09fe-49e8-aa3d-17bde93b3072", "028e31be-e704-4858-b897-c5a5c7dccb1f", "8afc8d86-1f2f-4d2d-820c-c6e0ac9f5226", "dcc7c458-153d-4296-be66-04f0cc777f04", "2d11f9fc-e9bb-484f-8dd0-73c57003281e", "20c9ffd2-1183-4202-9c27-261d1c935fdc", "db93c9f7-0149-47cf-b2f8-ece02389d2a3", "d374567f-f363-431a-8d42-69aa8adb3c4a", "0ad45cc3-74bf-4c0d-9d8f-00a84066d170", "bf027650-3d2e-4c9c-a524-7e22380b930a", "8ce1d4d7-9831-4c9e-88c3-1fc2bdb339d1", "7455332e-5c0f-40cf-ab1d-b3de9862d84d", "3e2aff73-af1f-471c-afab-692c5b1c0f39", "14db6e8a-ad39-48cc-a98d-758f7523d808", "2d370310-f153-4560-9da6-03e2e7c6716b", "ffa16d3e-4e03-47eb-bb29-06f57750b807", "476c7c0f-8bc7-45cd-877d-347e1173aa84", "7cfccfc4-4e93-456f-9a2f-ed4c31834cec", "1c287c54-4ad2-4acb-a5f6-c3cb6ab6c058", "ef06f3d8-4a6a-4145-8c5a-212c7f91c30b", "7113a0de-db0b-4a9d-a847-7d27760e7e13", "a3bd2d94-9c72-419a-8929-fa92e473e8ab", "90f3859c-d2ad-41d4-9f73-8ad0e34cc493", "57aae35a-dee7-4322-9d38-969fbc4cafc0", "27104944-0c7d-407c-bdfe-d80bc1270d59", "90c21467-b8a4-478e-b4eb-3e9fdd02cd9e", "d1490d7e-62bf-4ee0-881b-05459dc8c497", "c63a44d3-10e2-420d-b170-a71fff76e4e7", "e0f08788-eb38-463c-b2fd-03c475bdceab", "2659fdda-c6f2-48b8-b033-140ae5a3ab24", "7d5cd450-7f24-4101-a3ba-27022ee8fd91", "ce77e9e2-1951-4152-8308-28ca69294912", "aef5be47-3cf6-4d10-868a-bd1f47ec0466", "919a1a73-3590-4fa4-a934-0b7e5100aa72", "23674647-4b4f-4737-91b0-ea3de0f27a96", "6fb8cdcb-ce5b-44fa-bbc8-b7d19899ae60", "7b0884c8-7f56-4f9a-a718-4f238a3640c7", "fc11ff81-6405-4bb9-846e-7596666c6d8f", "899003f6-1ea0-4d8b-917a-d242dd08c0ab", "0368d5c4-1d88-4d25-b1e4-e8e4bb05adee", "dcdd05b3-4ad8-4204-acbc-2f5d0ba4fdd0", "0671ec70-3186-46ac-88d7-2663d9a0c4b6", "f9245bf2-e832-4afb-8f72-e5c09e766cb1", "e72f27fc-4507-49fd-ad84-1924bec0c8c9", "4e5a6607-3238-4ad8-a0c3-cf3cb2069da7", "461d4694-da30-4141-9127-31ebba1417a0", "f091574d-4964-48a4-9287-6f6b2dfbeaee", "f362737f-2bbf-41ab-9897-8c1c1a69eb65", "66f85d2b-0cf3-4abf-aa42-0b36dfe185e7", "7f3a1ba2-88c6-4231-9db3-f0fb24d66067", "5eecdb29-26e2-49d9-83c3-cad48f8cf085", "53456faa-7851-4114-98b1-e088800eb479", "b7233a7b-83ce-40cf-8cdf-2f104cbe7090", "c14385e7-9e92-41e8-a8a4-85ec54d91ac2", "49588280-9df5-4657-9c8c-3292ce9006f0", "9cc50e91-6b55-4792-be78-525433ddd7c6", "2b861827-78d5-4254-bf94-f731dc67339d", "5bfe4544-2891-46ef-96f4-6989532cdcae", "c26040f3-de60-4440-8be9-bc5693638ea3", "6b77ae71-cb3d-4b84-a745-32a1db274ae9", "c6b7f90e-969c-4259-992c-2f2bfbc2420f", "050e0082-2850-440a-9ab6-2ef9e44c94e3", "8f9d25d1-b7e1-457b-a3f4-b4abdb901229", "34a55898-0b6e-49f4-9836-965aecaed3df", "65e31859-158d-4c78-9d84-589904c14994", "3d4e77fb-5512-4c9b-9b3e-47a188fadc39", "cf40eb97-373b-4bfc-932a-6ce0f974c9f0", "9211f5bc-80f2-489e-b86d-2b71dfd66516", "bb05b826-2aff-4778-94e2-2bd560da15a9", "0f291d45-53cb-4a8e-8e4a-20d7e9aba79d", "8a1701c3-c8cd-4f38-8d29-f78db454fec6", "ef5d5d9c-02fb-4c60-afe2-63b501d45fdf", "00a87d31-e94f-4183-8a32-cdc354519251", "7be78c9b-1935-4ac7-ad2a-4b4622095957", "25e64575-f7d5-44e8-915c-748368831f86", "1f1f46f5-e331-4283-9a9f-052e3330084e", "2a58fa9c-8856-4039-b661-4db12b1a1152", "16d6825e-e972-48b7-b060-d0dd9447efe8", "8a64d2ff-2d3d-4ed4-97f8-bbd753720652", "c6c24d34-dee6-4362-851f-e12e6fa51501", "e419526e-5b7a-4210-9aa2-38d086450651", "d218eb63-9484-4184-abc6-529bc15edd6c", "589292ef-503c-41e4-9d40-aa9d978df3d6", "a6d5a78f-6c26-4d30-9e0f-476954a4317b", "376e39ec-d46d-49c7-aa50-218ea68d1564", "d26a9023-9ff6-47c5-86c3-128d64724b00", "15e2b344-0838-40ff-9a6c-54547d5c48f3", "9401e652-f4ab-4151-a960-72f6fada63fe", "3c45928b-40f6-4b6b-b506-7dd368e050f9", "98dbfe6c-e345-4cb4-acf0-c27f6499d54c", "2bd79e99-6b8a-4a20-8273-21d4b64d3ee1", "befdf0a7-c3b1-44ac-9442-e166675acf04", "2cf4e678-39c2-4e41-a1b8-5ab238dbafd3", "3e507496-a569-49bd-bbae-f8ebdfe251ba", "caba1caa-be2f-4772-b080-91fa161b6cd5", "31ec86ee-ece0-4369-bb10-1299455ddf94", "7b8f0a62-21cc-49c3-95f3-94e1d403c07d", "e4feafa5-8f49-42b5-9c8c-58291d9ed97b", "d1c42d8f-e4c6-4bf4-9dfb-20180ace1815", "210edc44-c129-4391-a16e-3ec20b318a4a", "3cc70c17-41f9-4508-9361-f1f65151dac7", "41ac527a-36d5-4ad6-8eb8-ac8556fac507", "26151b8f-5188-495e-bee0-c31deb23ba57", "74dd0055-e8b1-4278-b3b8-9a1aedf88797", "721a06a9-53b2-4130-b65d-6c55137047cf", "40d9300d-f4d8-4573-a1cb-4bc7e8d7bd26", "cdd2fadd-fda7-4d55-8ecb-4b884fdd66ad", "ccba6611-3085-4318-a661-ba642cf328fd", "e8ae5c06-bcaf-42b9-8980-157f1541c1ce", "5b51e667-1fe3-4a57-8abf-aaf3b82649a3", "fa2b9b33-4c2a-4462-af74-30b6053d07b5", "fe631a72-262b-4722-b7c5-97fe6f3b2ec4", "2a39f4c8-4cd0-4109-a07a-d5c22817c4e8", "69f410e9-df1d-4629-9caf-25a44bbfc570", "0995d850-df9e-45c2-926f-6c9589bc1a53", "e53cb213-0f92-4e08-96ab-2d4ef64a308d", "79225c54-66d6-4b15-bd7a-c8a4a6b5b4d4", "dcf4eb54-299c-410a-932d-a464dbbae0a5", "8636c858-ed9d-4288-8f98-96e05391e925", "9d33f9b4-17f2-4393-8df6-a8eaf6f4abe2", "c2aba4c8-cede-4a48-8156-3b8b768a3401", "e33f3bd5-e1a6-49a5-abb2-8b90594ef27b", "e1e19a50-8b28-4005-ab10-18e80db69ce5", "0f0b916f-fa50-4361-bb13-f20b0103613a", "0a3de35f-aa8c-40b8-b94a-9dbc942298c9", "1ba62020-aa06-4e20-9b59-9eab99b206bf", "9219ec43-b25d-4565-be4e-cd6aa6b0570f", "6608467f-5ff0-4935-b1d1-80f3eb67848b", "bc38e3f4-3172-4e4a-b991-755d57a4b282", "e6ce0857-4b70-4751-ba7e-f49bba457f92", "a1b1da38-5161-4b27-9b55-58778bb551a7", "692554c6-6d2e-4dc4-af78-103786c1cc81", "14acbefb-191e-4987-9490-e851fbab34b6", "4e5ef680-1877-4f2b-89fc-07421cc54c37", "35c903a7-774c-41f5-9a59-a6713f1797bd", "5de270fd-b402-4343-a77f-0dca7e5c7478", "b0148f16-cd3b-4506-99d7-afb5e4e1929d", "5d65ee76-5e69-42b1-b760-e73a5f14d60e", "42d1e651-9a23-41e4-bb77-9f44408162aa", "d9eaa92e-b809-4d6f-a1e3-a88a1408c67c", "f34b8fa2-c865-4580-b1ce-acbe6bf12a77", "7c98fa2e-a3a1-40fc-9403-7fa1d9373bc5", "5ed27332-d56f-4b78-b718-416130e38bbd", "a0fb9473-bff0-4b44-a991-8043b68e4929", "4b8a3ce8-f16a-49b1-96a5-5cac616b73ed", "1256e055-b537-4512-acf0-357a8a4c35c5", "3f6c41c4-78db-4f31-889f-5b040a6a8b5e", "7240164c-1e7f-48eb-8485-13d78d428f84", "77924f60-e59a-4e31-b818-31ee925f3c2c", "287f5fc0-9303-4821-bacc-ec748631ebd8", "4661a38d-2f46-470c-9082-7bad19d4da39", "e69a41fa-28bf-4aa0-9c26-caa28497edbe", "cbf81e35-7711-4834-886e-91dd2f9a7b62", "e1556450-0af1-4559-8915-aa13c5d52b29", "b6e64134-77cd-4965-9f50-68471fe453aa", "32275e27-2818-4ffd-80b7-5154b7ab613f", "a85ed195-933e-41bd-b09e-6a82996249ed", "c9340bd8-48cb-4df5-94c8-a28ac531cd82", "589e3c9d-de6f-420a-a4cd-a882b0c2785a", "ab965b13-13e0-454c-9185-8be721ac2380", "1203f52f-df99-444b-99c0-5f7f2de511b8", "847e3896-6edf-4e95-a93f-24279aed1e6c", "ba0e93c0-bb43-40ea-b30b-65b9c1c78a56", "7b2dbf1e-5cc8-4d2c-8df7-18198a4b08aa", "54efb935-944b-4114-b21c-e42db989bca0", "f716154e-ad7f-4575-a708-6754ea4884c7", "3e073423-0904-4e7d-983f-f442372e401f", "a2313d2a-ee61-4094-af6c-ea42b7760b36", "d8f7eb7b-f6bb-4bc2-bf75-c2ac2ce949dd", "f974c5e2-ec88-483b-b731-842f48243789", "9b4a4601-74ce-4809-a3b8-f38ef1ce01a7", "a6613b23-ec21-4aca-929e-1d7f4956e99d", "b1cbdae5-f193-4a80-a1dd-b22007f467bb", "ba09587b-b926-42e3-8d70-4302b4b7ea2d", "ad46dbc5-318a-46b2-b78c-f00a904e4dce", "f27ca088-0d6a-4f69-bc48-899f0ae3747d", "e0ddfbb7-a7d8-4478-a92d-4ccb7152f3fe", "d03b2c91-d412-4e90-9860-31a7696c4138", "32c0ebd4-0a2d-4477-975b-0f323e067b72", "48e730ab-e4e0-46b2-a0b0-f03f5417dbe8", "dfed12dd-4a98-496b-bfd8-bcdf49fc92d7", "ddf6b35e-55e3-40df-afcf-9126a28efd0e", "387c553d-604b-44a2-a23e-466063fd0173", "b31c9c60-e8a9-4590-b652-5a5ae7dadf90", "8707cb64-ac52-43a0-8471-3d1a165e1add", "b075977b-7942-4e90-93d8-1ad0f7b20998", "449a9041-9d9a-450a-86f7-34b7c656a254", "0bd86c16-d378-406f-bede-a6addf9a568a", "50173a20-a459-4bdf-b7de-5891b9f0ae31", "0a969469-839c-4bc7-bf16-008445a3f87d", "4a4a5161-9b4f-4d0e-9bdf-edc6b94aadca", "255c135e-d059-4e6c-9a7a-897b2a176790", "6a1d2b02-2c42-46d5-83b3-34f49dcd96be", "e9cf095e-0777-45cf-bc9d-65fbc8b89a9b", "09b50490-8f18-4804-b26d-09bd2063487c", "06964efb-11de-40a2-8afa-4824bf0eb8dd", "97833b16-ff0a-4fd1-982d-8d07f50864b7", "7b3defb5-79a5-4b72-9c28-cc216b0ed569", "2ae1f38e-98ed-4fc9-a03f-ae357bbde14b", "62672a73-9d68-4966-a732-f569859a442e", "a338f171-a666-4da3-a250-1f235383a7a6", "e21760b5-2004-412f-80c2-b446d73b5ea7", "b6fedcb1-444d-4a9f-9edc-e1a261ef06ce", "47158469-09eb-45e8-a32b-ce102280e32b", "65a51ae7-fc4e-47f8-bd36-e7b013483f5c", "dab8310c-c82d-410b-9784-680be47fd8b7", "1fb42f8b-94fa-496e-9b45-ba89d8e29d06", "9251a5ad-15a7-4642-975d-03fd325cce43", "c7b9a13f-484b-4786-bd69-629b27d2ebc4", "44552c36-a8e5-4cf6-8331-e2d0b932db0c", "51174d21-8cf4-4118-971c-c92203f5bba5", "4a6b88b0-1df1-43eb-8e61-6b688d2c6364", "4f417dd8-4148-4bc3-8276-79fb959ae9d2", "ce515437-7ea4-4315-a23b-e295d578c33b", "44b1d461-29d6-4379-805b-411920ba88dc", "f102e860-0837-4175-9ae1-0884783887c2", "10578326-e12b-4218-bf66-f27d9f691287", "fe25d7bd-5066-4003-82fd-e66ccb8b7e84", "d3764229-6e7f-49a2-9aed-fd8c7082c254", "997bb16a-e1ba-4cec-ad75-8fc0ddb6650c", "6a5fd6de-981a-410e-8556-5a8c56dd29ee", "bfbb27ed-793e-408a-946a-1bdb44dfeb74", "a0a8c13f-f9b6-48a8-82d4-0ed35fdaf05b", "e947a2ab-ee0f-40a4-8cd7-ce3e03274653", "8763cf51-bdfc-468b-ad49-c6ad592852c4", "43418603-2437-46a7-8d17-eb81b0775427", "771a270d-699e-4919-9909-afbb2944767b", "4b3336be-de3d-4c31-b0e1-528ad40cb808", "dc9110c8-308e-44c1-be1b-91ca75d856ae", "83c566ca-738f-4dcf-920b-3ce62ccccaca", "2790ebb0-260d-4e34-8ea4-34b603c31cda", "ad4a9bb0-3de8-4d85-9b26-f54d7bf1bbb4", "30c107b1-0fca-45cc-bd1a-c101babfdbdb", "59702755-e7f7-4178-8b0f-f033837468dd", "8fbfd3a9-dc59-4550-9b6e-e2e8f47804f6", "82199ba7-ecc2-4fab-be57-dab7d89ca012", "03fce205-f1b4-4819-912d-703288fa5e8c", "4cb99978-e399-4705-926f-2180bc764f80", "975ab500-3516-43df-95d0-494b96fb2a3b", "53737643-047c-48f6-a114-a5ae78546232", "0a249add-5db4-4220-9481-d30df2c60354", "fce4abe9-d152-41e2-84d8-dc31336c298c", "734cea95-1189-4498-8bac-7d5f334215f6", "de783dcd-449a-4fb4-bd64-939303c6499a", "bfda6e96-d9c1-44b6-9528-1592562e97f0", "ff6cc0fd-4cea-4e15-81ff-f2a0eb84b3a1", "8728132d-bd67-4e5a-b9c6-12e2ffb4f77d", "5c838c70-242e-4b57-999d-bbb4f45c2b55", "8dd15966-df43-498b-b2d0-b36bd5159389", "7d873925-eb70-4d3f-9a3e-f224df697e0a", "4d6f489e-1e30-44fd-bcc8-a80c9102b622", "ee3e206c-a5e9-43b9-a28e-058ff3a76551", "492cf115-e9a8-4e72-be5c-e66048b9420c", "8f93561b-2dfa-40b3-a318-28bc5545e76a", "f6dbe9c1-d619-409e-8313-9d13cb871255", "aa060a46-d936-41a0-8df1-6a1704e937cb", "f59c42fc-9f28-4352-8a15-5c806e83ec91", "fb7812ae-d011-447e-8beb-24423f039c0d", "1776266b-1470-449f-bd48-0ccdbe658bdb", "4949ee27-1dc9-4fd9-9aad-f5fb57277ad1", "ac3e3014-a6a0-4968-8ff3-36385c6de219", "8f3424f9-63b9-4eac-ac50-d4a6381e6b4c", "91b59249-ac3b-4c94-8c30-a62cb6086ad2", "730f385d-4dd9-4c80-a52d-7544003ad01a", "6a812b89-e78b-438b-bd84-920765bb4c92", "caf0abc8-5310-4c75-a08a-fdc9f593be71", "93de9661-4818-4a96-8e01-931dd4da95b2", "ada502a6-46f0-45ca-a972-ba0f08c3527d", "789f809f-4821-462e-a6ad-b154649480b4", "424eec2f-923a-4e84-adfb-7c6b47e1045d", "a0322bf2-8758-4647-8074-9f7c08369e85", "e2d119af-415f-464e-8b54-cdfd593dd068", "fc6da139-45bc-4a18-8a61-85209ad9ddfb", "2b969b9b-4743-4337-b9bf-7ec33c1d6a52", "af6156a0-73ee-43a1-9317-3ee6928cf561", "74defa00-d9ae-4527-b685-afdf0d2ee188", "75266443-b7c2-48f4-8b48-b9fcdd1de966", "b9d551ba-3c8c-4945-9955-e4b23b2866bc", "a0df90d9-afd4-41b6-bed3-893c1df8bb53", "bcda6646-0730-4200-a434-07a085d31bc0", "f5a80270-3b69-40be-a1a3-9732ca544447", "9a741263-aa64-4c45-ae67-d83ea46ff13d", "1d123aa6-930b-4443-887f-df9fe9de5240", "f7ec2c1a-1932-47b6-ac02-252e767c2d99", "f6e35887-1ccb-44aa-ae9c-b56ec6c50f6c", "6b1444f5-d6c0-4e94-8825-9dbb8cf5f400", "317e49f6-dccf-4dc0-98a3-423cd5a29ca0", "08aad815-59aa-4a18-908b-82ef944e79e9", "fd63871b-1924-49d6-b1d0-cd1f2af4e653", "5661426d-c61d-4a2a-90e8-629f06c44b33", "0e8a2197-5f64-4cdc-b2fd-7fe2f55689a0", "7e737b67-e474-46c4-8689-68700dc9e55c", "c88680be-4a47-41bf-91d7-64588040c1a2", "899d758b-dde0-431c-98be-f3918244d527", "34c8e169-482d-4ab7-9bcc-a92218248cd7", "baeaa80c-0c26-4773-83b8-4e9c46828e07", "6cf0ef19-6ff6-4d5c-9a8a-c7bde8685088", "52723bea-ca38-430c-b91f-d276625a54ad", "0f48d5cc-56e4-4ddf-b2d1-1db3c9068840", "dc529b78-4c7c-4550-a776-de3ec0e1a551", "0f099ed5-8b43-4f69-8214-7c3882d6c2f5", "918961ec-119a-4945-872c-2d618cbadc37", "0d43a9fe-93dd-4554-8b7c-445d29270b0a", "b4790ff1-f0af-492b-9d86-3bd1614897ae", "20611b9f-c166-4384-9f9e-1463516ba362", "42029b02-2e4f-4186-8660-6ee47d7c57fc", "e0eafd45-39fc-44fe-877a-a1bf070e6981", "4d85ee0f-5417-4668-9c72-d4e3022fd0ad", "3fc28f49-4a23-48b6-b6a3-d43fd300be14", "e0c8c5b6-3b7f-4ddc-8f5b-42eda5b028ce", "1c01acff-8dec-48f1-bd08-daded9e34a13", "f32c2b7b-8cbf-4944-9db4-a6fd205d4667", "8c5813e1-ae86-419c-840b-4dfcf134e82f", "6039bacf-e45e-41c1-a648-8811af96b136", "a8a0ddb3-0b46-445c-9e7d-98c1de4c4093", "420cca75-bd92-4641-8264-85f6116bf009", "d2f7b6af-f6a9-4b56-ac4d-435c44500709", "470f0828-0742-4814-b7f8-7bf3b40a95cc", "a493f272-47ca-4586-8b1b-df9767dbaa42", "080962c7-0bfd-42aa-b8df-b2da341acc04", "a121b959-b6a7-4ff8-8957-c43dbdaece8a", "0ddefceb-9e44-4acd-acfa-edc0976e6d20", "cc96ecfe-7d95-4e49-a32e-d7246935e7ff", "8ac8b37e-848f-412e-920d-c7b05be4515e", "c2bce5fa-e209-4ad0-bd38-459396079591", "208f3010-df47-4173-ae61-4e91b757f4b4", "cc985ce7-91ba-4149-a481-e169ca434ebd", "03988ed7-1983-4c59-bf2e-a63404249309", "692bdfbb-c3c5-4cf5-aed3-8dcf5555aa2e", "10508b6c-aed3-422e-a9bb-84d64aa13b60", "94121b44-0f2d-4d1e-93a4-1712e794787b", "c4d1f6ee-fe7c-493b-928a-5f6c3ee0d76e", "a40cfd12-a7a5-470c-a13c-8e2e95ff31d4", "daea4c38-e02a-4656-9dfc-39dffa98ea97", "fa404f40-ed27-4061-ac7f-77df4fdd74b8", "a3bda600-f0bf-4b37-826b-12dc52dc435a", "2d434d25-42de-4309-8fd1-08c3afc9ab1d", "079f91f5-6952-4ef0-865d-9237f31562ea", "bb645513-8ef6-422a-b601-ebe30f215421", "94cadee0-a11d-4649-b2c4-39d841dfa92b", "c9b2f197-da6f-4078-bc96-1875ede198fa", "f1270c87-2ad7-492a-842f-c38c5b7942d9", "56599dc3-cc3f-4610-9131-12b0da704664", "dbbcd55b-148c-4788-bc17-ff269ac2b8fb", "3b2c2baf-a729-45cb-a823-b5d5ce6d3e82", "825df2a2-c49e-44b4-9e7a-deb01d1cddba", "9ee6525c-de77-46bc-8f29-81a65aecb4c9", "d4d20434-a1b2-4db8-a8b3-5a5191b8b807", "bdfa4078-3baa-47cd-877d-f8c0fe16196e", "70d79453-c6c7-4be5-8879-987a0290340d", "07287e4c-acb5-4f2b-bb20-9f3da2793133", "97a51ed7-304a-42d5-ba7e-83a8cf553232", "031b84c1-7253-4f4e-928b-7742318d60fc", "d3662cbf-9db9-45b0-b24d-dbfb13cd5604", "54df8ace-8082-48db-a2f8-7d321b8aaa27", "d0a289ef-30fe-422c-a786-1b547e93c793", "d2e9495c-799e-48a5-b745-35365568ee29", "7dddb49a-81e0-493f-b4a2-1bb40e54c7b5", "3e210509-520c-4550-bba9-360f0d571bf3", "556e9bee-ea26-4bb8-b12c-5e8c02d4cdce", "a7d93321-77e8-4b1f-b37b-e1b99a886a6d", "361df1cc-b8f0-4779-bb80-a3ed5c92b6f5", "8e6ab8c5-80bf-4d37-99b4-ea0d613c5ff0", "db0fcdbb-ad67-4f57-9085-50bbf774e8c4", "01df68b7-cb39-400b-9676-1e7ca1e30d71", "4c2f3aee-402a-444e-be34-2290bccd1be9", "7a6f15cd-73d2-441b-84b2-70ac151973e2", "07d4bb01-7e55-4780-9be9-38f216e770fe", "abb26c86-2ff9-42a4-96d5-b0d92faf4a1c", "8b63b6bb-7fa1-445b-b3ce-88f66010f905", "b44c0774-a1ed-4951-a824-1f7634326e9e", "64eb219d-401c-463b-837e-a13575920c94", "0fd099d3-7970-4158-b4f4-72a602e0806b", "263beba3-8fb2-4dfc-bbdb-4c846ba46a32", "c0037460-3d49-49c5-a36e-88a83e2be3f6", "6a93ce51-6e77-4227-ae32-a9c712c78800", "d3833e9d-101e-43e8-bfd5-9928bdde922f", "b16dcd84-2830-4041-939f-afe41d4d8c50", "25679590-b687-43c1-a15f-bb095afb25d3", "9147c93d-b65f-4ce7-9601-c9c3a25b5527", "d6550313-d420-401b-922d-ddbe1cb4fae6", "a057d86c-7a85-4ab4-b2dc-f2bb57a4e7cc", "e6c08676-a361-426d-9c96-81539a4fa94c", "526a7593-d991-43f2-9f29-484568985d9a", "63be96ff-10e5-4e6c-98ce-9b4cc03b576e", "da4e934d-7e13-4b95-89c1-137be20f4dda", "eb79beb2-6fb1-4b26-af5b-ca51f64c7be6", "34f9bd2e-d346-4786-be92-f7b91132d5d7", "1e9b2203-2dcd-4b12-bf7b-dbe71058730f", "a11dea39-2a6a-451c-8436-e86d2ff90bcf", "1e34a627-bdbb-4ecc-aabd-8794779e06bb", "c5fa6117-27ba-429e-b794-7c7aea07ff71", "bf3e9d25-10c1-463c-92b6-873a3a3b865e", "eaaa2b33-c505-40b0-ad82-99a5f5c210f7", "2de8fb87-dd0e-43a7-b951-46db07344335", "5f2aa64a-7cad-406e-8391-79930e701f8b", "5e4849b5-4773-4126-9085-01bae49c44f8", "28cc365e-9679-4fc2-aee3-82781a258723", "59705e9c-20c5-477f-9de0-d032aedd0593", "fc26e08d-7d2f-4211-a643-2aab3a4b64ca", "73da98d7-a3ad-45b2-83f2-51505d11f375", "9ab8dee0-b9e6-4509-a2c0-ff467b7d0c56", "b919610c-a8f6-4ef4-b389-952decee30e6", "ca585dfb-8fcc-4806-b4db-caf78defb5de", "8d3920ac-9ae1-44a1-b563-289f1379d37e", "f49c8cfb-4b70-4962-88e6-4bc4880bbf76", "757395c3-8748-4b91-8124-677130ec7850", "c49c3bcc-cbd4-498b-b16c-9eae6bf65a59", "6abb6146-79a7-4e62-8457-57cbbaa8911e", "02d62eec-d655-4114-8377-cdef653ab104", "dab16e5b-ac8f-45f8-b504-3f49333fa2e1", "81100c81-7b3d-45c6-8393-8c9213d1c5f4", "95ac77dc-9be1-4440-9576-1533c591e741", "237c94e4-3792-4510-93b1-06811bbb8906", "1f47c874-bf8e-4c8c-a1cf-e165e328e581", "ee410f27-33ff-4353-a60e-73f14cf0f323", "08ce8aee-6051-48d0-b453-8a30ae127343", "0a6b5500-c86d-408d-ac6a-cc74bc755860", "e29ee5cc-504e-4a82-ba1f-2e2766326b2b", "2fdc6e8c-b761-418e-a50e-9a8741f1ae31", "b3fccdd2-9f25-4538-b828-3847df6d79de", "c3d90d49-74d7-42c4-81ee-997ba9857712", "28d32e87-7b2b-4552-ba89-23da2c2cfe66", "ae2f01cd-76d4-4fdb-9dc3-c839aeb5db0f", "4d41e9b8-62e2-46e6-96c6-66402b7da453", "c9390cb4-e6af-413b-9e87-d1cd539c51d0", "6ea453b7-a553-454d-99d5-0fbf180af59e", "42bbe773-ce3f-4fe5-920e-ba7b0f8a723f", "aed682be-d19e-46d9-b8b4-9c8a668eefab", "5820da3a-cdab-49a8-aa92-266cc51a9d34", "a8e930e7-9f61-48cc-a1cf-7a691951db31", "1fa8667a-f8e3-43b3-849c-0a8d536741cb", "6213f30b-4a49-4583-98c9-e176fab4e2de", "3ef52375-3ea3-4845-a475-417abc8ee591", "54010b6c-20e2-4073-8ba6-0b38afe9d59e", "55a7073d-a6b1-4d0f-a2c4-335c39e0c954", "e1d16215-80fb-4526-ae8b-2338add196c5", "86db9861-564b-42c3-9ec0-1c0b62966df8", "056e262c-c27d-44aa-bf92-c781fbf49519", "d71e30de-a86d-46d9-a6b4-891cb65ea5bc", "23c6983c-d29d-429a-b513-a00442bd8b12", "af372e53-d990-4255-9a9d-54481336b3ca", "e410530a-7e1a-4efb-afb2-4d86f1646a91", "96d6f705-1dfe-49ab-98be-ec2b591cfe52", "ef345ed5-9543-4807-9d1b-a097b9c3ccd7", "0dc677f8-17d0-4597-8cd2-5425eec905c9", "4bd8f1c1-3364-429b-81ab-f66d1f441b59", "b490e0ad-8f2c-4941-9525-c27ca1b70381", "1fcde9c9-5be4-4f9f-9efa-b662c148344b", "abde8b56-df97-401e-9447-89b9b141b2af", "3f1cf7cd-b303-4fee-bb92-acd33b396cb4", "8b6a9900-6326-4e7c-8842-9d5e2e624658", "8c6b92b9-2237-448f-a08f-e95716e979ce", "509472c4-1388-4f8d-bc12-84e1d5ea8897", "b08953c2-f045-4078-a917-862254c34b42", "ab3dd3c1-1cb4-4eec-b48d-238df5c5c0ca", "5851f4d1-4b38-4907-a46e-d5a4eb888c26", "a4fe52f2-2037-4a95-8001-266cfbe492be", "612fd035-f3e0-4a78-829a-a3086dadd009", "1ae09e2a-796b-46bf-9252-ae968ebf3c94", "2ccd0e40-e087-434c-a2d1-bd015f4a1dca", "7fe37f10-163c-4eb8-b515-7023a2e2e35b", "56fa2b6a-f80a-4b45-b850-3e5b55b88e12", "283a5b09-c0a4-429f-8aab-67fbc302eb54", "f44cb7e7-7226-49c1-9371-c9f9f0ada294", "24db28b7-6b5e-4424-bbd1-caaaad888e82", "433884ed-36c9-46a0-aa49-34dd9e7a3c6e", "6483be88-7f32-41cf-ad50-56a2090f1028", "e66ea5f5-926d-47c7-a6cb-5304ce4a5b3d", "20f73a73-6d57-42d8-911b-1511bc8b18d9", "398f06f0-20cb-42e1-bb2b-d5bf9e58ce60", "f77b86ea-e345-4ca7-9aff-16726ba40599", "65e9fb3c-d29d-46ef-ae83-7507b32c5d80", "64f6c771-0d51-4dec-9875-16db498870cc", "8ad818a6-c215-4ba9-b337-85c51566c898", "c1d0e58d-bf31-4fb0-8535-eeffa44169ee", "06414e60-5a42-4855-947c-03398e63c6bf", "7f4be5e6-81f6-42a7-8401-9c3f452faec9", "00cb7540-5e27-410d-85e1-609ab08f799c", "b5c8a3e4-af3c-4712-88cc-753dc52abb61", "23ab2380-a97b-425f-829b-46cd328d843d", "f21a12b7-2921-46fd-b6c4-900d3c46ee22", "f98e09d2-58a1-4817-afa5-b356c22b618d", "a76c4b27-3239-497b-9066-8b74d8aac399", "ec90a287-2cdc-4f32-ba0e-27ba74c65c74", "7e0ff12c-d995-493a-adf9-58eedea39c9c", "b83e6e23-a939-45e2-b4bd-3495688c7e80", "436acb16-e2ee-46bf-b144-ae5e954be025", "c723a12b-4778-412b-8a65-04975acecf0c", "ab3cfc0f-b38b-4e46-8703-860db2ba659e", "445f352e-a03b-4a8d-a4a8-f5a51a26985d", "2297d203-2cd2-4819-b31d-d013e15de510", "710dba2d-9fc2-4732-8e01-ac96d529840b", "c6d4c3e2-fd78-4e8e-9231-693876c631ae", "6c0a72e0-dd23-40d8-a324-e0315608e554", "9ea7cd16-b13e-4416-aec9-30ec89f6445a", "8882b576-208c-4773-9a65-34a4924b6f13", "e8bac6aa-b6ca-47fe-bbfd-913ebfaad884", "71522fd4-ff11-42cf-8ce3-f3a8c3ece94f", "345a2c93-8ccd-4653-a08e-396f14c836d0", "d8cfcb9c-9166-42ba-9a09-9eac6791baa1", "f2413e9d-631f-48b8-9d40-a6872d40d617", "efd6838c-cb4d-4dff-9f79-c98fe75662a9", "9be99bcf-3a5c-450b-9814-eb084c62d6be", "adcacfe1-4c0a-45d9-a9b6-87682cde5f1d", "65f5fc64-aa8d-468a-9942-15b8a36072f1", "b37fd31e-d4e7-4452-8732-2c855d5c3b04", "31e1c03e-4948-4edb-bc20-dafc4ee92bbf", "7d1be376-330b-432c-9080-dbc525a3adc3", "aceb614b-7c11-43e3-85b9-f17f4c1fddc6", "807782fd-a2f7-4615-aca2-1353e66f9178", "f37cf12a-e37e-43aa-b552-da8ac9e4eccb", "c2e3232d-aa46-467e-a590-dfa836ee5df7", "f8bf1083-0567-4e20-9292-4ff6edc0d349", "89e09d87-33a3-49c3-a056-6e96ce4e7158", "08043177-9348-4e41-b4a2-25363bf1e10d", "c250a0ed-ac3c-47f6-8993-25a253e59e21", "739b4a17-f293-4a2c-bdc2-79da910b014a", "6e7a418e-b3a6-4004-990d-0bb686abc4dd", "692d3403-d97a-469c-bfd8-e7b4a0b79302", "e19cf23b-ffa5-4c49-890e-c4862ea7edb6", "c64c4cc2-f4f1-47e3-aa2b-ccfb3b11a44c", "43b11b7d-f378-489d-b64d-284382161d72", "9654dfd9-2602-43a5-8fdd-374a77d3087d", "1652ccd5-0c04-4961-9edb-f650f794498d", "ebc86939-187d-404c-a444-5e5c708e7418", "66eb0ea2-d4db-44ac-8f45-9e0c87df350a", "fd321f2f-3ce1-4c3f-82d3-a77bf71f39ab", "93ff717c-94dd-44bb-a3ab-6dc5026dafc0", "90069d30-e5ba-48ef-ad6e-fd5943a772a9", "f60740f6-d68b-4773-be29-c7235bc789c9", "4a978c83-c4f1-4c6a-9827-520590129b01", "30f0385a-8660-481f-a62e-779193730d77", "b5792771-fe20-45f8-b101-0ed61c21c054", "916a890d-0e5e-4156-94cc-b7696b5b9c0d", "bb827aee-6e01-434c-becd-2a9450477938", "dfd981e8-cfa0-49e9-b1d8-7daf647c7c7d", "82682f89-4d45-4c05-8c31-d79ff460df9e", "a61739b3-1c47-445f-80d9-4809bcdfd06d", "ed7b5ea2-1292-41b3-8566-9e413723e9e2", "e4467960-6dd3-4f73-aee1-298b3d0f89a4", "35eb9f21-1a91-4059-ab31-070d0d33894a", "55a1630d-d476-4519-887f-749d4075cf86", "a3b2c918-622f-4a6a-bd06-b188610d9558", "3788c7d0-9306-4f13-bf7e-9ff1557b4730", "a66a2fdf-c65a-4740-b8f3-912ee76067b5", "d228278e-238d-406e-8a33-3d4705951a92", "1f7a64ea-5b96-4068-b949-ce5e3471af2b", "f1e729fc-dc4d-4e0f-b76d-181ccd12dab4", "303b3aa4-af4d-42e9-8fb0-a823fa171b6a", "4ca32ac6-0c6c-48c1-a7f1-06971248e7a4", "0fdff8cf-e458-4794-a4c3-2fb7128e6d1f", "e110db24-6528-4aa1-a6e7-e77688142b5e", "1478a431-265c-42ac-9233-d98ef10a53bc", "98e43f7d-3907-4c37-bf77-62396f699ea0", "d71c4586-6485-48c3-a28a-bd6ac48059ab", "4a04d86f-0004-4639-903f-b0b36508b01e", "18af4c9b-105c-4ca8-809a-6a7e56b70c3a", "d486b343-03b3-4719-8c36-8249b98fecf5", "c4dc8b85-e22b-4806-b9cd-7f7d5629e262", "a4a03924-8d12-41e6-b36d-1d9ca737ea0e", "cccb22da-cebd-40d8-996f-16dd0f8d17f7", "c7be9d74-e066-4fed-b8d9-bb49ebf7997a", "f1d3cf30-5559-4514-bd1c-7d46acd92f59", "56bcdcf3-3ca7-4c8f-a673-301e8a1193e4", "eed3c024-2a41-43ab-b5c0-6c7200934db8", "0f822c00-61e0-4fb0-b60e-84d7273d6289", "1bbad1f4-9c99-4a00-afe4-f289833899f0", "13ae6b10-f580-47d8-8878-88e6458bb905", "1b78d5fa-cb14-4b55-9f98-d88b12bd2127", "791d0573-cf73-45b7-98a4-2f8edba4c45a", "603b3032-ea11-4055-a594-cd519203dc13", "1b345968-8482-4f70-bcaf-9cec45512f69", "fa1c7038-6ed7-4df5-8dbe-72b7008473f5", "a5b41fb4-bd42-44c4-9dfa-583ef6519f73", "81d88380-a3d1-4449-8706-39a9f4a48a10", "68a006f0-2753-42bf-844b-27403f839fd2", "d6472c86-5eff-4b8d-b7e7-02a894c64e01", "20687553-cb1b-4fa9-bb10-22499596003d", "fcefeec2-ee55-4300-b156-405b09a13858", "f35df892-936e-48a2-a965-7f5a92be7ca7", "f992cf03-c6d7-4ef4-b6c4-4f546a91fc05", "fe7d6987-cca2-4b81-918e-ca088974c0fb", "89638d25-ee08-4cac-bf64-b58eb1191c3b", "6ff68d60-51e9-4ada-ba16-950336dc4182", "07e2fc5c-19fc-4e80-ba6c-ac8ff7df6d4f", "0bf08fca-0769-4725-89b0-61a68fb06157", "1cf2c3db-510e-44c7-be77-bba9df12d54b", "f18518e1-4b8b-4a03-9c65-67f54ed2a433", "4087ae1b-b315-492f-a601-2d2fde41d307", "7607b230-8e6e-48af-81c8-b951f7f8b932", "c11f194e-2566-4a53-b56b-6c5a26732310", "b85e0939-feb8-4523-9e17-2a32b67a0ff6", "76df531f-de64-449a-94dc-89e0b1928035", "f09244d5-a110-4535-8a66-cf226dfb2900", "0e1f84b9-0d96-40ff-bda7-461f8d8b90da", "a476f64f-b427-4218-b304-e712cc105f3e", "2997abb3-0a91-43f6-88fe-4a13f23f7cf2", "b2b261ac-83a0-4349-bb92-d943728feadb", "d528dc31-c841-4b2b-9519-4f16add5427f", "f9789cf3-a649-47d9-bb13-6e60eb95c9fa", "15101b93-02ee-477b-904c-a4d2256fff38", "78d8abb7-fd98-4cf0-bbf8-05607bea7f02", "73f90486-77b7-45b7-9839-fa3fd2936eb0", "f09d2557-127f-4ad3-8bde-698d0ae6d7ff", "fb3a3d29-444e-4cf5-a79d-d3c98513b310", "ac23bceb-6fff-4c36-b078-c9d6fc4d47fb", "e731a8b8-c3e6-418a-bdfe-bb22cb16db6e", "997247b8-69bd-4be3-8d9f-bd8e182c6f13", "c590a6f4-26a0-4247-bc65-e109c0c12d81", "7ac4e1f3-0c61-4b04-b452-e141ef357d56", "e3891eb4-f0c9-4a04-bfab-1d3380c0bf2f", "1304b070-4b68-4ef8-83f2-436e45efee8d", "2edd936a-86a5-47af-b592-ae6a0f611232", "88c1ed0f-6a18-45d1-8f82-68d840c201a8", "1ddec417-2afa-49ae-9b3d-c4a000d1e96a", "ae0ce92b-6395-431d-bfd5-dc6f373882ed", "b709b36c-15e4-4f4e-93bb-2a7b094e587f", "9fb5ae3c-5465-4eb6-a417-2874fb18c0d2", "df101758-75dd-46d3-b080-1f338fc088a2", "3a7c8b57-637b-4598-a729-98140ec71275" ],
  "timeframes" : null,
  "types" : [ {
    "actions" : [ ],
    "display_name" : "Mock: Data Table  ล ฦ ว ศ ษ ส ห ฬ อ",
    "export_key" : "mock_data_table",
    "fields" : {
      "mock_col_one" : {
        "allow_default_value" : false,
        "blank_option" : false,
        "calculated" : false,
        "changeable" : true,
        "chosen" : false,
        "default_chosen_by_server" : false,
        "deprecated" : false,
        "export_key" : "mock_data_table/mock_col_one",
        "hide_notification" : false,
        "id" : 274,
        "input_type" : "text",
        "internal" : false,
        "is_tracked" : false,
        "name" : "mock_col_one",
        "operation_perms" : { },
        "operations" : [ ],
        "order" : 0,
        "placeholder" : "",
        "prefix" : null,
        "read_only" : false,
        "rich_text" : false,
        "tags" : [ ],
        "templates" : [ ],
        "text" : "mock col one",
        "tooltip" : "a tooltip  ล ฦ ว ศ ษ ส ห ฬ อ",
        "type_id" : 1000,
        "uuid" : "83a3fea3-ddfd-46ee-82df-a0070e2476d9",
        "values" : [ ],
        "width" : 246
      },
      "mok_col_two" : {
        "allow_default_value" : false,
        "blank_option" : false,
        "calculated" : false,
        "changeable" : true,
        "chosen" : false,
        "default_chosen_by_server" : false,
        "deprecated" : false,
        "export_key" : "mock_data_table/mok_col_two",
        "hide_notification" : false,
        "id" : 275,
        "input_type" : "number",
        "internal" : false,
        "is_tracked" : false,
        "name" : "mok_col_two",
        "operation_perms" : { },
        "operations" : [ ],
        "order" : 1,
        "placeholder" : "",
        "prefix" : null,
        "read_only" : false,
        "rich_text" : false,
        "tags" : [ ],
        "templates" : [ ],
        "text" : "mock  ล ฦ ว ศ ษ ส ห ฬ อ col two",
        "tooltip" : "tooltip  ล ฦ ว ศ ษ ส ห ฬ อ",
        "type_id" : 1000,
        "uuid" : "b364709b-b804-4ce2-8c04-d451966b0a7f",
        "values" : [ ],
        "width" : 456
      }
    },
    "for_actions" : false,
    "for_custom_fields" : false,
    "for_notifications" : false,
    "for_workflows" : false,
    "id" : null,
    "parent_types" : [ "incident" ],
    "properties" : {
      "can_create" : false,
      "can_destroy" : false,
      "for_who" : [ ]
    },
    "scripts" : [ ],
    "tags" : [ {
      "tag_handle" : "fn_main_mock_integration",
      "value" : null
    } ],
    "type_id" : 8,
    "type_name" : "mock_data_table",
    "uuid" : "66cc5d9f-7c9a-42e7-991e-d8e5288c01ba"
  } ],
  "workflows" : [ {
    "actions" : [ ],
    "content" : {
      "version" : 1,
      "workflow_id" : "mock_workflow_one",
      "xml" : "<?xml version=\"1.0\" encoding=\"UTF-8\"?><definitions xmlns=\"http://www.omg.org/spec/BPMN/20100524/MODEL\" xmlns:bpmndi=\"http://www.omg.org/spec/BPMN/20100524/DI\" xmlns:omgdc=\"http://www.omg.org/spec/DD/20100524/DC\" xmlns:omgdi=\"http://www.omg.org/spec/DD/20100524/DI\" xmlns:resilient=\"http://resilient.ibm.com/bpmn\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" targetNamespace=\"http://www.camunda.org/test\"><process id=\"mock_workflow_one\" isExecutable=\"true\" name=\"Mock Workflow One\"><documentation>a description of mock workflow one  ล ฦ ว ศ ษ ส ห ฬ อ ล ฦ ว ศ ษ ส ห ฬ อ ล ฦ ว ศ ษ ส ห ฬ อ</documentation><startEvent id=\"StartEvent_155asxm\"><outgoing>SequenceFlow_1q8wygd</outgoing></startEvent><serviceTask id=\"ServiceTask_1cpn7cb\" name=\"mock_function_one\" resilient:type=\"function\"><extensionElements><resilient:function uuid=\"9b180887-4ff6-4d13-82a6-cb0a5d8718f1\">{\"inputs\":{\"866625eb-8b46-4cc9-b713-cdfa548a1189\":{\"input_type\":\"static\",\"static_input\":{\"multiselect_value\":[],\"text_content_value\":{\"format\":\"text\",\"content\":\"data value one  ล ฦ ว ศ ษ ส ห ฬ อ\"}}},\"b6dfde6d-7516-4509-a5a2-54e72df9e0cd\":{\"input_type\":\"static\",\"static_input\":{\"multiselect_value\":[],\"select_value\":\"7522822e-67bc-478e-b91d-7116b14ce2a5\"}},\"df7df8ba-cb65-4400-8290-070b155d28d4\":{\"input_type\":\"static\",\"static_input\":{\"boolean_value\":true,\"multiselect_value\":[]}},\"69dc0e78-a74b-4ccc-8d82-33b51780a569\":{\"input_type\":\"static\",\"static_input\":{\"multiselect_value\":[\"8b8b22d4-b20c-4d10-abac-a65211a5b9cd\",\"bf8e34a8-79aa-4ec4-b4c9-b8f1f0f7135e\"]}}},\"post_processing_script\":\"# post process of mock  ล ฦ ว ศ ษ ส ห ฬ อ workflow two\\n\\nincident.addNote(u\\\" ล ฦ ว ศ ษ ส ห ฬ อ\\\")\",\"pre_processing_script\":\"# A mock pre-process script for mock_workflow_one\\n\\ninputs.mock_input_number = 123\\ninputs.mock_input_boolean = True\\ninputs.mock_input_text = \\\"abc  ล ฦ ว ศ ษ ส ห ฬ อ abc\\\"\",\"pre_processing_script_language\":\"python\",\"result_name\":\"output_of_mock_function_one\"}</resilient:function></extensionElements><incoming>SequenceFlow_1q8wygd</incoming><outgoing>SequenceFlow_0zyh9xo</outgoing></serviceTask><sequenceFlow id=\"SequenceFlow_1q8wygd\" sourceRef=\"StartEvent_155asxm\" targetRef=\"ServiceTask_1cpn7cb\"/><endEvent id=\"EndEvent_09pyeky\"><incoming>SequenceFlow_0zyh9xo</incoming></endEvent><sequenceFlow id=\"SequenceFlow_0zyh9xo\" sourceRef=\"ServiceTask_1cpn7cb\" targetRef=\"EndEvent_09pyeky\"/><textAnnotation id=\"TextAnnotation_1kxxiyt\"><text>Start your workflow here</text></textAnnotation><association id=\"Association_1seuj48\" sourceRef=\"StartEvent_155asxm\" targetRef=\"TextAnnotation_1kxxiyt\"/></process><bpmndi:BPMNDiagram id=\"BPMNDiagram_1\"><bpmndi:BPMNPlane bpmnElement=\"undefined\" id=\"BPMNPlane_1\"><bpmndi:BPMNShape bpmnElement=\"StartEvent_155asxm\" id=\"StartEvent_155asxm_di\"><omgdc:Bounds height=\"36\" width=\"36\" x=\"162\" y=\"188\"/><bpmndi:BPMNLabel><omgdc:Bounds height=\"0\" width=\"90\" x=\"157\" y=\"223\"/></bpmndi:BPMNLabel></bpmndi:BPMNShape><bpmndi:BPMNShape bpmnElement=\"TextAnnotation_1kxxiyt\" id=\"TextAnnotation_1kxxiyt_di\"><omgdc:Bounds height=\"30\" width=\"100\" x=\"99\" y=\"254\"/></bpmndi:BPMNShape><bpmndi:BPMNEdge bpmnElement=\"Association_1seuj48\" id=\"Association_1seuj48_di\"><omgdi:waypoint x=\"169\" xsi:type=\"omgdc:Point\" y=\"220\"/><omgdi:waypoint x=\"153\" xsi:type=\"omgdc:Point\" y=\"254\"/></bpmndi:BPMNEdge><bpmndi:BPMNShape bpmnElement=\"ServiceTask_1cpn7cb\" id=\"ServiceTask_1cpn7cb_di\"><omgdc:Bounds height=\"80\" width=\"100\" x=\"514\" y=\"166\"/></bpmndi:BPMNShape><bpmndi:BPMNEdge bpmnElement=\"SequenceFlow_1q8wygd\" id=\"SequenceFlow_1q8wygd_di\"><omgdi:waypoint x=\"198\" xsi:type=\"omgdc:Point\" y=\"206\"/><omgdi:waypoint x=\"514\" xsi:type=\"omgdc:Point\" y=\"206\"/><bpmndi:BPMNLabel><omgdc:Bounds height=\"13\" width=\"90\" x=\"311\" y=\"184.5\"/></bpmndi:BPMNLabel></bpmndi:BPMNEdge><bpmndi:BPMNShape bpmnElement=\"EndEvent_09pyeky\" id=\"EndEvent_09pyeky_di\"><omgdc:Bounds height=\"36\" width=\"36\" x=\"940\" y=\"188\"/><bpmndi:BPMNLabel><omgdc:Bounds height=\"13\" width=\"90\" x=\"913\" y=\"227\"/></bpmndi:BPMNLabel></bpmndi:BPMNShape><bpmndi:BPMNEdge bpmnElement=\"SequenceFlow_0zyh9xo\" id=\"SequenceFlow_0zyh9xo_di\"><omgdi:waypoint x=\"614\" xsi:type=\"omgdc:Point\" y=\"206\"/><omgdi:waypoint x=\"940\" xsi:type=\"omgdc:Point\" y=\"206\"/><bpmndi:BPMNLabel><omgdc:Bounds height=\"13\" width=\"90\" x=\"732\" y=\"184.5\"/></bpmndi:BPMNLabel></bpmndi:BPMNEdge></bpmndi:BPMNPlane></bpmndi:BPMNDiagram></definitions>"
    },
    "content_version" : 1,
    "creator_id" : "admin@example.com",
    "description" : "a description of mock workflow one  ล ฦ ว ศ ษ ส ห ฬ อ ล ฦ ว ศ ษ ส ห ฬ อ ล ฦ ว ศ ษ ส ห ฬ อ",
    "export_key" : "mock_workflow_one",
    "last_modified_by" : "admin@example.com",
    "last_modified_time" : 1644407281055,
    "name" : "Mock Workflow One",
    "object_type" : "incident",
    "programmatic_name" : "mock_workflow_one",
    "tags" : [ {
      "tag_handle" : "fn_main_mock_integration",
      "value" : null
    } ],
    "uuid" : "127ae053-c26f-43b7-8b5a-198720dbf202",
    "workflow_id" : 2
  }, {
    "actions" : [ ],
    "content" : {
      "version" : 1,
      "workflow_id" : "mock_workflow_two",
      "xml" : "<?xml version=\"1.0\" encoding=\"UTF-8\"?><definitions xmlns=\"http://www.omg.org/spec/BPMN/20100524/MODEL\" xmlns:bpmndi=\"http://www.omg.org/spec/BPMN/20100524/DI\" xmlns:omgdc=\"http://www.omg.org/spec/DD/20100524/DC\" xmlns:omgdi=\"http://www.omg.org/spec/DD/20100524/DI\" xmlns:resilient=\"http://resilient.ibm.com/bpmn\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" targetNamespace=\"http://www.camunda.org/test\"><process id=\"mock_workflow_two\" isExecutable=\"true\" name=\"mock workflow  ล ฦ ว ศ ษ ส ห ฬ อ two\"><documentation>a descirption of  ล ฦ ว ศ ษ ส ห ฬ อ mock workflow  ล ฦ ว ศ ษ ส ห ฬ อ two</documentation><startEvent id=\"StartEvent_155asxm\"><outgoing>SequenceFlow_0qvmb7u</outgoing></startEvent><serviceTask id=\"ServiceTask_1gf1ya4\" name=\"mock_function_one\" resilient:type=\"function\"><extensionElements><resilient:function uuid=\"9b180887-4ff6-4d13-82a6-cb0a5d8718f1\">{\"inputs\":{\"b6dfde6d-7516-4509-a5a2-54e72df9e0cd\":{\"input_type\":\"static\",\"static_input\":{\"multiselect_value\":[],\"select_value\":\"0a30d6ad-914a-47b1-83bf-c5667dbee974\"}},\"69dc0e78-a74b-4ccc-8d82-33b51780a569\":{\"input_type\":\"static\",\"static_input\":{\"multiselect_value\":[\"8b8b22d4-b20c-4d10-abac-a65211a5b9cd\",\"bf8e34a8-79aa-4ec4-b4c9-b8f1f0f7135e\"]}}},\"post_processing_script\":\"# a mock post  ล ฦ ว ศ ษ ส ห ฬ อ script of  ล ฦ ว ศ ษ ส ห ฬ อ function one\\n\\nif True:\\n  incident.addNote(\\\"this note was added \\\")\",\"result_name\":\"mock_output_of_function_one\"}</resilient:function></extensionElements><incoming>SequenceFlow_0qvmb7u</incoming><outgoing>SequenceFlow_1efekzp</outgoing></serviceTask><serviceTask id=\"ServiceTask_0uxjjuo\" name=\"mock function  ล ฦ ว ศ ษ ส ห ฬ อ ...\" resilient:type=\"function\"><extensionElements><resilient:function uuid=\"90be4dd8-59a0-4791-82e9-df5d7e86edcb\">{\"inputs\":{},\"pre_processing_script\":\"# mock pre script of function  ล ฦ ว ศ ษ ส ห ฬ อ ล ฦ ว ศ ษ ส ห ฬ อ ล ฦ ว ศ ษ ส ห ฬ อ two:\\n\\ninputs.mock_input_boolean = False\\ninputs.mock_input_number = 1001\\ninputs.mock_input_text = u\\\" ล ฦ ว ศ ษ ส ห ฬ อ ล ฦ ว ศ ษ ส ห ฬ อ ramdom text\\\"\"}</resilient:function></extensionElements><incoming>SequenceFlow_1efekzp</incoming><outgoing>SequenceFlow_0a5l4on</outgoing></serviceTask><sequenceFlow id=\"SequenceFlow_0qvmb7u\" sourceRef=\"StartEvent_155asxm\" targetRef=\"ServiceTask_1gf1ya4\"/><sequenceFlow id=\"SequenceFlow_1efekzp\" sourceRef=\"ServiceTask_1gf1ya4\" targetRef=\"ServiceTask_0uxjjuo\"/><endEvent id=\"EndEvent_0s81h2i\"><incoming>SequenceFlow_0a5l4on</incoming></endEvent><sequenceFlow id=\"SequenceFlow_0a5l4on\" sourceRef=\"ServiceTask_0uxjjuo\" targetRef=\"EndEvent_0s81h2i\"/></process><bpmndi:BPMNDiagram id=\"BPMNDiagram_1\"><bpmndi:BPMNPlane bpmnElement=\"undefined\" id=\"BPMNPlane_1\"><bpmndi:BPMNShape bpmnElement=\"StartEvent_155asxm\" id=\"StartEvent_155asxm_di\"><omgdc:Bounds height=\"36\" width=\"36\" x=\"74\" y=\"188\"/><bpmndi:BPMNLabel><omgdc:Bounds height=\"0\" width=\"90\" x=\"69\" y=\"223\"/></bpmndi:BPMNLabel></bpmndi:BPMNShape><bpmndi:BPMNShape bpmnElement=\"ServiceTask_1gf1ya4\" id=\"ServiceTask_1gf1ya4_di\"><omgdc:Bounds height=\"80\" width=\"100\" x=\"241\" y=\"166\"/></bpmndi:BPMNShape><bpmndi:BPMNShape bpmnElement=\"ServiceTask_0uxjjuo\" id=\"ServiceTask_0uxjjuo_di\"><omgdc:Bounds height=\"80\" width=\"100\" x=\"479\" y=\"166\"/></bpmndi:BPMNShape><bpmndi:BPMNEdge bpmnElement=\"SequenceFlow_0qvmb7u\" id=\"SequenceFlow_0qvmb7u_di\"><omgdi:waypoint x=\"110\" xsi:type=\"omgdc:Point\" y=\"206\"/><omgdi:waypoint x=\"241\" xsi:type=\"omgdc:Point\" y=\"206\"/><bpmndi:BPMNLabel><omgdc:Bounds height=\"13\" width=\"0\" x=\"175.5\" y=\"184.5\"/></bpmndi:BPMNLabel></bpmndi:BPMNEdge><bpmndi:BPMNEdge bpmnElement=\"SequenceFlow_1efekzp\" id=\"SequenceFlow_1efekzp_di\"><omgdi:waypoint x=\"341\" xsi:type=\"omgdc:Point\" y=\"206\"/><omgdi:waypoint x=\"479\" xsi:type=\"omgdc:Point\" y=\"206\"/><bpmndi:BPMNLabel><omgdc:Bounds height=\"13\" width=\"0\" x=\"410\" y=\"184.5\"/></bpmndi:BPMNLabel></bpmndi:BPMNEdge><bpmndi:BPMNShape bpmnElement=\"EndEvent_0s81h2i\" id=\"EndEvent_0s81h2i_di\"><omgdc:Bounds height=\"36\" width=\"36\" x=\"726\" y=\"188\"/><bpmndi:BPMNLabel><omgdc:Bounds height=\"13\" width=\"0\" x=\"744\" y=\"227\"/></bpmndi:BPMNLabel></bpmndi:BPMNShape><bpmndi:BPMNEdge bpmnElement=\"SequenceFlow_0a5l4on\" id=\"SequenceFlow_0a5l4on_di\"><omgdi:waypoint x=\"579\" xsi:type=\"omgdc:Point\" y=\"206\"/><omgdi:waypoint x=\"726\" xsi:type=\"omgdc:Point\" y=\"206\"/><bpmndi:BPMNLabel><omgdc:Bounds height=\"13\" width=\"0\" x=\"652.5\" y=\"184.5\"/></bpmndi:BPMNLabel></bpmndi:BPMNEdge></bpmndi:BPMNPlane></bpmndi:BPMNDiagram></definitions>"
    },
    "content_version" : 1,
    "creator_id" : "admin@example.com",
    "description" : "a descirption of  ล ฦ ว ศ ษ ส ห ฬ อ mock workflow  ล ฦ ว ศ ษ ส ห ฬ อ two",
    "export_key" : "mock_workflow_two",
    "last_modified_by" : "admin@example.com",
    "last_modified_time" : 1644407280896,
    "name" : "mock workflow  ล ฦ ว ศ ษ ส ห ฬ อ two",
    "object_type" : "artifact",
    "programmatic_name" : "mock_workflow_two",
    "tags" : [ {
      "tag_handle" : "fn_main_mock_integration",
      "value" : null
    } ],
    "uuid" : "fef372ed-3410-413b-b01b-9b34e31b8005",
    "workflow_id" : 1
  } ],
  "workspaces" : [ {
    "description" : "Default workspace",
    "display_name" : "Default workspace",
    "export_key" : "default_workspace",
    "id" : 0,
    "is_default" : true,
    "name" : "default_workspace",
    "tags" : [ ],
    "uuid" : "47350579-3795-4d7f-907f-c2d1fd329816",
    "version" : 0
  } ]
}