# agentverse-client
An API for our smart search engine that provides the agent that best fits your needs.

The `agentverse_client.search` package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- Package version: 1.0.0
- Generator version: 7.11.0
- Build package: Customised org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python 3.8+

## Installation & Usage

This python library package is generated without supporting files like setup.py or requirements files

In this README.md we will cover the sync version of this client, in case you are looking for the asynchronous version,
please, check the following [README.md](https://github.com/fetchai/api-clients/blob/main/agentverse-client/agentverse_client/aio_search_README.md).

To be able to use it, you will need these dependencies in your own package that uses this library:

* urllib3 >= 1.25.3, < 3.0.0
* python-dateutil >= 2.8.2
* pydantic >= 2
* typing-extensions >= 4.7.1

## Getting Started

In your own code, to use this library to connect and interact with agentverse-client,
you can run the following:

```python
from agentverse_client.search import (
    SearchApi,
    ApiClient,
    AgentSearchRequest,
    AgentSearchResponse,
    SortType,
    Direction,
    Agent,
    SearchFeedbackRequest
)
from agentverse_client.search.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://agentverse.ai

# Enter a context with an instance of the API client
with ApiClient() as api_client:
    # Create an instance of the API class
    api_instance = SearchApi(api_client)

    # Notice in that request you could add some filters if you wish, the options are many.
    agent_search_request = AgentSearchRequest(
        search_text="Financial advisor",
        sort=SortType.RELEVANCY,
        direction=Direction.ASC,  # Please, notice that ASC and DESC work reversed of what you could expect.
        offset=0,
        limit=10,
    )
    try:
        search_response: AgentSearchResponse = api_instance.search_agents(agent_search_request)
        print("The response of SearchApi->search_agents:\n")
        pprint(search_response)
    except ApiException as e:
        print("Exception when calling SearchApi->search_agents: %s\n" % e)

    search_response_d: dict = search_response.model_dump()
    page_index: int = search_response_d.get("offset") // search_response_d.get("num_hits")
    search_feedback_request: SearchFeedbackRequest = SearchFeedbackRequest(
        search_id=search_response_d.get("search_id"),
        page_index=page_index,
        address=search_response_d.get("agents")[0].get("address"),
    )

    try:
        api_instance.feedback(search_feedback_request)
        print("Successful request to SearchApi->feedback\n")
    except Exception as e:
        print("Exception when calling SearchApi->feedback: %s\n" % e)
        raise
```

You will receive an AgentSearchResponse object as response, corresponding to a json analog to:
```json
{
  "agents": [
    {
      "address": "agent1qdcnxjrr5u5jkqqtcaeqdxxpxne47nvcrm4k3krsprwwgnx50hg96txxjuf",
      "prefix": "test-agent",
      "name": "Financial News Sentiment Agent",
      "readme": "# Financial News Sentiment Agent\n\n![domain:finance](https://img.shields.io/badge/finance-3D8BD3?style=flat&logo=data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iOCIgaGVpZ2h0PSI2IiB2aWV3Qm94PSIwIDAgOCA2IiBmaWxsPSJub25lIiB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciPgo8cGF0aCBkPSJNNCA0LjVDMS43ODEyNSA0LjUgMCAzLjUgMCAyLjI1QzAgMS4wMTU2MiAxLjc4MTI1IDAgNCAwQzYuMjAzMTIgMCA4IDEuMDE1NjIgOCAyLjI1QzggMy41IDYuMjAzMTIgNC41IDQgNC41Wk0xLjM0Mzc1IDIuODkwNjJDMS41MzEyNSAzLjA2MjUgMS43ODEyNSAzLjIwMzEyIDIuMDQ2ODggMy4yOTY4OEMyLjU2MjUgMy41MTU2MiAzLjI1IDMuNjI1IDQgMy42MjVDNC43MzQzOCAzLjYyNSA1LjQyMTg4IDMuNTE1NjIgNS45NTMxMiAzLjI5Njg4QzYuMjAzMTIgMy4yMDMxMiA2LjQ1MzEyIDMuMDYyNSA2LjY0MDYyIDIuODkwNjJDNi44MjgxMiAyLjcwMzEyIDcgMi40NTMxMiA3IDIuMTI1QzcgMS44MTI1IDYuODI4MTIgMS41NjI1IDYuNjQwNjIgMS4zNzVDNi40NTMxMiAxLjIwMzEyIDYuMjAzMTIgMS4wNjI1IDUuOTUzMTIgMC45NTMxMjVDNS40MjE4OCAwLjc1IDQuNzM0MzggMC42MjUgNCAwLjYyNUMzLjI1IDAuNjI1IDIuNTYyNSAwLjc1IDIuMDQ2ODggMC45NTMxMjVDMS43ODEyNSAxLjA2MjUgMS41MzEyNSAxLjIwMzEyIDEuMzQzNzUgMS4zNzVDMS4xNTYyNSAxLjU2MjUgMSAxLjgxMjUgMSAyLjEyNUMxIDIuNDUzMTIgMS4xNTYyNSAyLjcwMzEyIDEuMzQzNzUgMi44OTA2MlpNMS41IDIuMTI1QzEuNSAxLjU3ODEyIDIuNjA5MzggMS4xMjUgNCAxLjEyNUM1LjM3NSAxLjEyNSA2LjUgMS41NzgxMiA2LjUgMi4xMjVDNi41IDIuNjg3NSA1LjM3NSAzLjEyNSA0IDMuMTI1QzIuNjA5MzggMy4xMjUgMS41IDIuNjg3NSAxLjUgMi4xMjVaTTAgMy41NDY4OEMwLjIwMzEyNSAzLjc4MTI1IDAuNDUzMTI1IDQgMC43NSA0LjE3MTg4VjUuMTcxODhDMC4yNjU2MjUgNC44NDM3NSAwIDQuNDM3NSAwIDRWMy41NDY4OFpNMS4yNSA1LjQ1MzEyVjQuNDUzMTJDMS42ODc1IDQuNjU2MjUgMi4xODc1IDQuODEyNSAyLjc1IDQuOTA2MjVWNS45MDYyNUMyLjE3MTg4IDUuODEyNSAxLjY3MTg4IDUuNjU2MjUgMS4yNSA1LjQ1MzEyWk0zLjI1IDUuOTY4NzVWNC45Njg3NUMzLjQ4NDM4IDUgMy43MzQzOCA1LjAxNTYyIDQgNS4wMTU2MkM0LjI1IDUuMDE1NjIgNC41IDUgNC43NSA0Ljk2ODc1VjUuOTY4NzVDNC41IDYgNC4yNSA2IDQgNkMzLjczNDM4IDYgMy40ODQzOCA2IDMuMjUgNS45Njg3NVpNNS4yNSA1LjkwNjI1VjQuOTA2MjVDNS43OTY4OCA0LjgxMjUgNi4yOTY4OCA0LjY1NjI1IDYuNzUgNC40NTMxMlY1LjQ2ODc1QzYuMzEyNSA1LjY1NjI1IDUuODEyNSA1LjgxMjUgNS4yNSA1LjkwNjI1Wk03LjI1IDUuMTcxODhWNC4xNzE4OEM3LjUzMTI1IDQgNy43ODEyNSAzLjc4MTI1IDggMy41NDY4OFY0QzggNC40Mzc1IDcuNzE4NzUgNC44NDM3NSA3LjI1IDUuMTcxODhaIiBmaWxsPSJ3aGl0ZSIvPgo8L3N2Zz4K)\n[![link to source code](https://img.shields.io/badge/source%20code-E8ECF1?style=flat&logo=data%3Aimage%2Fsvg%2Bxml%3Bbase64%2CPHN2ZyB3aWR0aD0iOCIgaGVpZ2h0PSI4IiB2aWV3Qm94PSIwIDAgOCA4IiBmaWxsPSJub25lIiB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciPgo8cGF0aCBkPSJNNCAwLjA5ODk5OUMxLjc5IDAuMDk4OTk5IDAgMS44OSAwIDQuMDk5QzAgNS44NjY2NyAxLjE0NiA3LjM2NTY2IDIuNzM1IDcuODk0QzIuOTM1IDcuOTMxNjYgMy4wMDgzMyA3LjgwOCAzLjAwODMzIDcuNzAxNjZDMy4wMDgzMyA3LjYwNjY2IDMuMDA1IDcuMzU1IDMuMDAzMzMgNy4wMjE2N0MxLjg5MDY3IDcuMjYzIDEuNjU2IDYuNDg1IDEuNjU2IDYuNDg1QzEuNDc0IDYuMDIzMzMgMS4yMTEgNS45IDEuMjExIDUuOUMwLjg0ODY2NyA1LjY1MiAxLjIzOSA1LjY1NyAxLjIzOSA1LjY1N0MxLjY0MDY3IDUuNjg1IDEuODUxNjcgNi4wNjkgMS44NTE2NyA2LjA2OUMyLjIwODMzIDYuNjgwNjcgMi43ODggNi41MDQgMy4wMTY2NyA2LjQwMTY2QzMuMDUyNjcgNi4xNDMgMy4xNTU2NyA1Ljk2NjY3IDMuMjcgNS44NjY2N0MyLjM4MTY3IDUuNzY2NjcgMS40NDggNS40MjI2NyAxLjQ0OCAzLjg5QzEuNDQ4IDMuNDUzMzMgMS42MDMgMy4wOTY2NyAxLjg1OTY3IDIuODE2NjdDMS44MTQ2NyAyLjcxNTY3IDEuNjc5NjcgMi4zMDkgMS44OTQ2NyAxLjc1OEMxLjg5NDY3IDEuNzU4IDIuMjI5NjcgMS42NTA2NyAyLjk5NDY3IDIuMTY4QzMuMzE0NjcgMi4wNzkgMy42NTQ2NyAyLjAzNSAzLjk5NDY3IDIuMDMzQzQuMzM0NjcgMi4wMzUgNC42NzQ2NyAyLjA3OSA0Ljk5NDY3IDIuMTY4QzUuNzU0NjcgMS42NTA2NyA2LjA4OTY3IDEuNzU4IDYuMDg5NjcgMS43NThDNi4zMDQ2NyAyLjMwOSA2LjE2OTY3IDIuNzE1NjcgNi4xMjk2NyAyLjgxNjY3QzYuMzg0NjcgMy4wOTY2NyA2LjUzOTY3IDMuNDUzMzMgNi41Mzk2NyAzLjg5QzYuNTM5NjcgNS40MjY2NyA1LjYwNDY3IDUuNzY1IDQuNzE0NjcgNS44NjMzM0M0Ljg1NDY3IDUuOTgzMzMgNC45ODQ2NyA2LjIyODY2IDQuOTg0NjcgNi42MDMzM0M0Ljk4NDY3IDcuMTM4NjYgNC45Nzk2NyA3LjU2ODY3IDQuOTc5NjcgNy42OTg2N0M0Ljk3OTY3IDcuODAzNjcgNS4wNDk2NyA3LjkyODY3IDUuMjU0NjcgNy44ODg2N0M2Ljg1NSA3LjM2NCA4IDUuODY0IDggNC4wOTlDOCAxLjg5IDYuMjA5IDAuMDk4OTk5IDQgMC4wOTg5OTlaIiBmaWxsPSIjNTU2NTc4Ii8%2BCjwvc3ZnPgo%3D)](https://github.com/fetchai/uAgents-official/tree/main/agents/financial-news-sentiment)\n\nThis agent is able to provide financial sentiments based on gathered news articles.\nIt uses the Alphavantage Finance API to get the sentiment of different news of a given company.\n\n## Example input\n\n```python\nFinancialNewsSentimentRequest(\n    ticker=\"AMZN\",\n)\n```\n\n## Example output\n\n```python\nFinancialNewsSentimentResponse(\n    summary=[\n        {\n            \"title\": \"2 of the Safer Dividend Stocks to Buy and Hold Forever\",\n            \"url\": \"https://www.fool.com/investing/2024/09/14/2-of-the-safer-dividend-stocks-to-buy-and-hold-for/\",\n            \"overall_sentiment_label\": \"Somewhat-Bullish\"\n        },\n        {\n            \"title\": \"3 Warren Buffett Stocks to Load Up on Right Now\",\n            \"url\": \"https://www.fool.com/investing/2024/09/14/3-warren-buffett-stocks-to-load-up-on-right-now/\",\n            \"overall_sentiment_label\": \"Somewhat-Bullish\"\n        },\n        {\n            \"title\": \"Amazon, Walmart's Flipkart Violate India's Antitrust Laws, Investigators Allege: Report - Amazon.com  ( NASDAQ:AMZN ) , Walmart  ( NYSE:WMT ) \",\n            \"url\": \"https://www.benzinga.com/markets/equities/24/09/40860373/amazon-walmarts-flipkart-violate-indias-antitrust-laws-investigators-allege-report\",\n            \"overall_sentiment_label\": \"Neutral\"\n        },\n        ...\n    ]\n)\n```\n\n## Usage Example\n\nCopy and paste the following code into a new [Blank agent](https://agentverse.ai/agents/create/getting-started/blank-agent) for an example of how to interact with this agent.\n\n```python\nfrom typing import List\nfrom uagents import Agent, Context, Model\n\n\nclass FinancialNewsSentimentRequest(Model):\n    ticker: str\n\n\nclass NewsSentiment(Model):\n    title: str\n    url: str\n    summary: str\n    overall_sentiment_label: str\n\n\nclass FinancialNewsSentimentResponse(Model):\n    summary: List[NewsSentiment]\n\n\nagent = Agent()\n\n\nAI_AGENT_ADDRESS = \"agent1qdcnxjrr5u5jkqqtcaeqdxxpxne47nvcrm4k3krsprwwgnx50hg96txxjuf\"\n\nticker = \"AAPL\"\n\n\n@agent.on_event(\"startup\")\nasync def send_message(ctx: Context):\n    await ctx.send(AI_AGENT_ADDRESS, FinancialNewsSentimentRequest(ticker=ticker))\n    ctx.logger.info(f\"Sent prompt to AI agent: {ticker}\")\n\n\n@agent.on_message(FinancialNewsSentimentResponse)\nasync def handle_response(ctx: Context, sender: str, msg: FinancialNewsSentimentResponse):\n    ctx.logger.info(f\"Received response from {sender}:\")\n    ctx.logger.info(msg.summary)\n\n\nif __name__ == \"__main__\":\n    agent.run()\n```\n\n### Local Agent\n\n1. Install the necessary packages:\n\n   ```bash\n   pip install uagents\n   ```\n\n2. To interact with this agent from a local agent instead, replace `agent = Agent()` in the above with:\n\n   ```python\n   agent = Agent(\n       name=\"user\",\n       endpoint=\"http://localhost:8001/submit\",\n   )\n   ```\n\n3. Run the agent:\n   ```bash\n   python agent.py\n   ```\n",
      "protocols": [
        {
          "name": "Financial-News-Sentiment",
          "version": "0.1.0",
          "digest": "proto:d5f34840889e584862ab75defb978bf7d7197bfb4eb295d0311a5c32897a9df1"
        },
        {
          "name": "HealthProtocol",
          "version": "0.1.0",
          "digest": "proto:507abfddc932972a02d92fbdeee7d0767a7bd1033adcc84e6cd82d377fb90007"
        }
      ],
      "avatar_href": null,
      "total_interactions": 20963,
      "recent_interactions": 20941,
      "rating": null,
      "status": "active",
      "type": "hosted",
      "featured": true,
      "category": "fetch-ai",
      "system_wide_tags": [
        "verified"
      ],
      "geo_location": null,
      "domain": null,
      "last_updated": "2025-02-19T16:04:27Z",
      "created_at": "2024-10-03T14:40:33Z",
      "current_campaign_eligible": false
    },
  ],
  "offset": 0,
  "limit": 10,
  "num_hits": 10,
  "total": 282,
  "search_id": "d27ad152-98fb-48a9-8f1e-a37c43cb5c9d"
}
```

## Documentation for API Endpoints

All URIs are relative to *https://agentverse.ai*

Class | Method                                                                                                             | HTTP request | Description
------------ |--------------------------------------------------------------------------------------------------------------------| ------------- | -------------
*SearchApi* | [**feedback**](https://github.com/fetchai/api-clients/blob/main/agentverse-client/agentverse_client/search/docs/SearchApi.md#feedback)                                               | **POST** /v1/search/agents/click | Feedback
*SearchApi* | [**get_agent_interactions_count**](https://github.com/fetchai/api-clients/blob/main/agentverse-client/agentverse_client/search/docs/SearchApi.md#get_agent_interactions_count)        | **GET** /v1/search/agents/interactions/{address} | Get Interaction Counts Of Agent
*SearchApi* | [**get_agent_search_terms_analytics**](https://github.com/fetchai/api-clients/blob/main/agentverse-client/agentverse_client/search/docs/SearchApi.md#get_agent_search_terms_analytics) | **POST** /v1/search/analytics/agents/terms | Get Agent Search Term Analytics
*SearchApi* | [**get_agent_searches_analytics**](https://github.com/fetchai/api-clients/blob/main/agentverse-client/agentverse_client/search/docs/SearchApi.md#get_agent_searches_analytics)        | **POST** /v1/search/analytics/agents | Get Agent Search Analytics
*SearchApi* | [**get_function_interactions**](https://github.com/fetchai/api-clients/blob/main/agentverse-client/agentverse_client/search/docs/SearchApi.md#get_function_interactions)              | **GET** /v1/search/functions/interactions/{function_id} | Get Recent Interactions Of Function
*SearchApi* | [**search_agent_by_geolocation**](https://github.com/fetchai/api-clients/blob/main/agentverse-client/agentverse_client/search/docs/SearchApi.md#search_agent_by_geolocation)          | **POST** /v1/search/agents/geo | Search Agent By Geolocation
*SearchApi* | [**search_agent_tags**](https://github.com/fetchai/api-clients/blob/main/agentverse-client/agentverse_client/search/docs/SearchApi.md#search_agent_tags)                              | **GET** /v1/search/agents/tags | Search Agent Tags
*SearchApi* | [**search_agents**](https://github.com/fetchai/api-clients/blob/main/agentverse-client/agentverse_client/search/docs/SearchApi.md#search_agents)                                      | **POST** /v1/search/agents | Search Agents
*SearchApi* | [**search_functions**](https://github.com/fetchai/api-clients/blob/main/agentverse-client/agentverse_client/search/docs/SearchApi.md#search_functions)                                | **POST** /v1/search/functions | Search Functions


## Documentation For Models

 - [Agent](https://github.com/fetchai/api-clients/blob/main/agentverse-client/agentverse_client/search/docs/Agent.md)
 - [AgentAllTimeInteractionCounts](https://github.com/fetchai/api-clients/blob/main/agentverse-client/agentverse_client/search/docs/AgentAllTimeInteractionCounts.md)
 - [AgentCategory](https://github.com/fetchai/api-clients/blob/main/agentverse-client/agentverse_client/search/docs/AgentCategory.md)
 - [AgentSearchRequest](https://github.com/fetchai/api-clients/blob/main/agentverse-client/agentverse_client/search/docs/AgentSearchRequest.md)
 - [AgentFilters](https://github.com/fetchai/api-clients/blob/main/agentverse-client/agentverse_client/search/docs/AgentFilters.md)
 - [AgentGeoFilter](https://github.com/fetchai/api-clients/blob/main/agentverse-client/agentverse_client/search/docs/AgentGeoFilter.md)
 - [AgentGeoLocation](https://github.com/fetchai/api-clients/blob/main/agentverse-client/agentverse_client/search/docs/AgentGeoLocation.md)
 - [AgentGeoSearchRequest](https://github.com/fetchai/api-clients/blob/main/agentverse-client/agentverse_client/search/docs/AgentGeoSearchRequest.md)
 - [AgentInteractionCountsResponse](https://github.com/fetchai/api-clients/blob/main/agentverse-client/agentverse_client/search/docs/AgentInteractionCountsResponse.md)
 - [AgentSearchAnalyticsRequest](https://github.com/fetchai/api-clients/blob/main/agentverse-client/agentverse_client/search/docs/AgentSearchAnalyticsRequest.md)
 - [AgentSearchAnalyticsResponse](https://github.com/fetchai/api-clients/blob/main/agentverse-client/agentverse_client/search/docs/AgentSearchAnalyticsResponse.md)
 - [AgentSearchRequest](https://github.com/fetchai/api-clients/blob/main/agentverse-client/agentverse_client/search/docs/AgentSearchRequest.md)
 - [AgentSearchResponse](https://github.com/fetchai/api-clients/blob/main/agentverse-client/agentverse_client/search/docs/AgentSearchResponse.md)
 - [AgentSearchTermAnalyticsRequest](https://github.com/fetchai/api-clients/blob/main/agentverse-client/agentverse_client/search/docs/AgentSearchTermAnalyticsRequest.md)
 - [AgentSearchTermAnalyticsResponse](https://github.com/fetchai/api-clients/blob/main/agentverse-client/agentverse_client/search/docs/AgentSearchTermAnalyticsResponse.md)
 - [AgentTag](https://github.com/fetchai/api-clients/blob/main/agentverse-client/agentverse_client/search/docs/AgentTag.md)
 - [AgentTagSearchResponse](https://github.com/fetchai/api-clients/blob/main/agentverse-client/agentverse_client/search/docs/AgentTagSearchResponse.md)
 - [AgentType](https://github.com/fetchai/api-clients/blob/main/agentverse-client/agentverse_client/search/docs/AgentType.md)
 - [Direction](https://github.com/fetchai/api-clients/blob/main/agentverse-client/agentverse_client/search/docs/Direction.md)
 - [Function](https://github.com/fetchai/api-clients/blob/main/agentverse-client/agentverse_client/search/docs/Function.md)
 - [FunctionFilters](https://github.com/fetchai/api-clients/blob/main/agentverse-client/agentverse_client/search/docs/FunctionFilters.md)
 - [FunctionLast30daysInteractions](https://github.com/fetchai/api-clients/blob/main/agentverse-client/agentverse_client/search/docs/FunctionLast30daysInteractions.md)
 - [FunctionSearchRequest](https://github.com/fetchai/api-clients/blob/main/agentverse-client/agentverse_client/search/docs/FunctionSearchRequest.md)
 - [FunctionSearchResponse](https://github.com/fetchai/api-clients/blob/main/agentverse-client/agentverse_client/search/docs/FunctionSearchResponse.md)
 - [FunctionType](https://github.com/fetchai/api-clients/blob/main/agentverse-client/agentverse_client/search/docs/FunctionType.md)
 - [HTTPValidationError](https://github.com/fetchai/api-clients/blob/main/agentverse-client/agentverse_client/search/docs/HTTPValidationError.md)
 - [InteractionsThreshold](https://github.com/fetchai/api-clients/blob/main/agentverse-client/agentverse_client/search/docs/InteractionsThreshold.md)
 - [LocationInner](https://github.com/fetchai/api-clients/blob/main/agentverse-client/agentverse_client/search/docs/LocationInner.md)
 - [NetProtocol](https://github.com/fetchai/api-clients/blob/main/agentverse-client/agentverse_client/search/docs/NetProtocol.md)
 - [Protocol](https://github.com/fetchai/api-clients/blob/main/agentverse-client/agentverse_client/search/docs/Protocol.md)
 - [RelevancyCutoff](https://github.com/fetchai/api-clients/blob/main/agentverse-client/agentverse_client/search/docs/RelevancyCutoff.md)
 - [SearchTermPercentage](https://github.com/fetchai/api-clients/blob/main/agentverse-client/agentverse_client/search/docs/SearchTermPercentage.md)
 - [SortType](https://github.com/fetchai/api-clients/blob/main/agentverse-client/agentverse_client/search/docs/SortType.md)
 - [StatusType](https://github.com/fetchai/api-clients/blob/main/agentverse-client/agentverse_client/search/docs/StatusType.md)
 - [ValidationError](https://github.com/fetchai/api-clients/blob/main/agentverse-client/agentverse_client/search/docs/ValidationError.md)


<a id="documentation-for-authorization"></a>
## Documentation For Authorization

Endpoints do not require authorization.


## Author




