# coding: utf-8

"""
    FastAPI

    An API for our smart search engine that provides the agent that best fits your needs.

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from agentverse_client.search.aio.models.direction import Direction
from agentverse_client.search.aio.models.function_filters import FunctionFilters
from agentverse_client.search.aio.models.sort_type import SortType
from typing import Optional, Set
from typing_extensions import Self

class FunctionSearchRequest(BaseModel):
    """
    The function search request object
    """ # noqa: E501
    filters: Optional[FunctionFilters] = None
    sort: Optional[SortType] = Field(default=None, description="The type of sorting that should be applied to the search results, relevancy is the default and should be")
    direction: Optional[Direction] = Field(default=None, description="The direction of the sorting, ascending or descending")
    search_text: Optional[StrictStr] = None
    offset: Optional[StrictInt] = Field(default=0, description="The offset of the search results for pagination")
    limit: Optional[StrictInt] = Field(default=30, description="The limit of the search results for pagination")
    __properties: ClassVar[List[str]] = ["filters", "sort", "direction", "search_text", "offset", "limit"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of FunctionSearchRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of filters
        if self.filters:
            _dict['filters'] = self.filters.to_dict()
        # set to None if search_text (nullable) is None
        # and model_fields_set contains the field
        if self.search_text is None and "search_text" in self.model_fields_set:
            _dict['search_text'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of FunctionSearchRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "filters": FunctionFilters.from_dict(obj["filters"]) if obj.get("filters") is not None else None,
            "sort": obj.get("sort"),
            "direction": obj.get("direction"),
            "search_text": obj.get("search_text"),
            "offset": obj.get("offset") if obj.get("offset") is not None else 0,
            "limit": obj.get("limit") if obj.get("limit") is not None else 30
        })
        return _obj


