# mailbox
The Mailbox API handles agent message delivery, registration, storage quotas, and usage tracking within the Agentverse platform. It supports secure agent communication through cryptographic authentication

The `agentverse_client.mailbox` package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 1.0.0
- Package version: 1.0.0
- Generator version: 7.11.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python 3.8+

## Installation & Usage

This python library package is generated without supporting files like setup.py or requirements files

To be able to use it, you will need these dependencies in your own package that uses this library:

* urllib3 >= 1.25.3, < 3.0.0
* python-dateutil >= 2.8.2
* pydantic >= 2
* typing-extensions >= 4.7.1

## Getting Started

In your own code, to use this library to connect and interact with mailbox,
you can run the following:

```python

import agentverse_client.mailbox
from agentverse_client.mailbox.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://agentverse.ai
# See configuration.py for a list of all supported configuration parameters.
configuration = agentverse_client.mailbox.Configuration(
    host = "https://agentverse.ai"
)



# Enter a context with an instance of the API client
with agentverse_client.mailbox.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = agentverse_client.mailbox.MailboxApi(api_client)
    authorization = 'authorization_example' # str |  (optional)

    try:
        # Delete All Mailbox Messages
        api_response = api_instance.delete_all_mailbox_messages(authorization=authorization)
        print("The response of MailboxApi->delete_all_mailbox_messages:\n")
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling MailboxApi->delete_all_mailbox_messages: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *http://localhost*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*MailboxApi* | [**delete_all_mailbox_messages**](agentverse_client/mailbox/docs/MailboxApi.md#delete_all_mailbox_messages) | **DELETE** /v1/mailbox | Delete All Mailbox Messages
*MailboxApi* | [**delete_specific_envelope**](agentverse_client/mailbox/docs/MailboxApi.md#delete_specific_envelope) | **DELETE** /v1/mailbox/{uuid} | Delete Specific Envelope
*MailboxApi* | [**get_specific_envelope**](agentverse_client/mailbox/docs/MailboxApi.md#get_specific_envelope) | **GET** /v1/mailbox/{uuid} | Get Specific Envelope
*MailboxApi* | [**list_mailbox_messages**](agentverse_client/mailbox/docs/MailboxApi.md#list_mailbox_messages) | **GET** /v1/mailbox | List Mailbox Messages


## Documentation For Models

 - [Agent](agentverse_client/mailbox/docs/Agent.md)
 - [AgentUpdates](agentverse_client/mailbox/docs/AgentUpdates.md)
 - [ApiKeyUpdate](agentverse_client/mailbox/docs/ApiKeyUpdate.md)
 - [ChallengeRequest](agentverse_client/mailbox/docs/ChallengeRequest.md)
 - [ChallengeResponse](agentverse_client/mailbox/docs/ChallengeResponse.md)
 - [Envelope](agentverse_client/mailbox/docs/Envelope.md)
 - [Feedback](agentverse_client/mailbox/docs/Feedback.md)
 - [FeedbackAnon](agentverse_client/mailbox/docs/FeedbackAnon.md)
 - [HTTPValidationError](agentverse_client/mailbox/docs/HTTPValidationError.md)
 - [LocationInner](agentverse_client/mailbox/docs/LocationInner.md)
 - [MailboxQuotaSetEvent](agentverse_client/mailbox/docs/MailboxQuotaSetEvent.md)
 - [MailboxQuotaTopUpEvent](agentverse_client/mailbox/docs/MailboxQuotaTopUpEvent.md)
 - [MailboxQuotas](agentverse_client/mailbox/docs/MailboxQuotas.md)
 - [NewApiKey](agentverse_client/mailbox/docs/NewApiKey.md)
 - [PageAgent](agentverse_client/mailbox/docs/PageAgent.md)
 - [PageLeaf](agentverse_client/mailbox/docs/PageLeaf.md)
 - [PageStoredEnvelope](agentverse_client/mailbox/docs/PageStoredEnvelope.md)
 - [ProofRequest](agentverse_client/mailbox/docs/ProofRequest.md)
 - [ProofResponse](agentverse_client/mailbox/docs/ProofResponse.md)
 - [PublicAgent](agentverse_client/mailbox/docs/PublicAgent.md)
 - [RegistrationRequest](agentverse_client/mailbox/docs/RegistrationRequest.md)
 - [RegistrationResponse](agentverse_client/mailbox/docs/RegistrationResponse.md)
 - [StoredEnvelope](agentverse_client/mailbox/docs/StoredEnvelope.md)
 - [TortoiseContribPydanticCreatorRelayDbModelsDbApiKeyLeaf](agentverse_client/mailbox/docs/TortoiseContribPydanticCreatorRelayDbModelsDbApiKeyLeaf.md)
 - [TortoiseContribPydanticCreatorRelayDbModelsDbUserLeaf](agentverse_client/mailbox/docs/TortoiseContribPydanticCreatorRelayDbModelsDbUserLeaf.md)
 - [UserMailUpdate](agentverse_client/mailbox/docs/UserMailUpdate.md)
 - [UserUpdate](agentverse_client/mailbox/docs/UserUpdate.md)
 - [UserUsage](agentverse_client/mailbox/docs/UserUsage.md)
 - [ValidationError](agentverse_client/mailbox/docs/ValidationError.md)


<a id="documentation-for-authorization"></a>
## Documentation For Authorization


Authentication schemes defined for the API:
<a id="FaunaAuthorizationScheme"></a>
### FaunaAuthorizationScheme

- **Type**: OAuth
- **Flow**: accessCode
- **Authorization URL**: 
- **Scopes**: N/A


## Author




