# coding: utf-8

"""
    Agentverse Mailbox API

    The Mailbox API handles agent message delivery, registration, storage quotas, and usage tracking within the Agentverse platform. It supports secure agent communication through cryptographic authentication

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class UserUsage(BaseModel):
    """
    UserUsage
    """ # noqa: E501
    bytes_transferred: StrictInt = Field(description="Number of bytes transferred by the user.")
    bytes_transferred_limit: StrictInt = Field(description="Maximum allowed bytes transferred.")
    num_messages: StrictInt = Field(description="Total number of messages sent.")
    num_messages_limit: StrictInt = Field(description="Maximum number of messages allowed.")
    bytes_stored: StrictInt = Field(description="Current number of bytes stored by the user.")
    bytes_stored_limit: StrictInt = Field(description="Maximum allowed stored bytes.")
    num_agents: StrictInt = Field(description="Number of agents owned by the user.")
    num_agents_limit: StrictInt = Field(description="Maximum number of agents allowed.")
    expiry: Optional[datetime] = None
    __properties: ClassVar[List[str]] = ["bytes_transferred", "bytes_transferred_limit", "num_messages", "num_messages_limit", "bytes_stored", "bytes_stored_limit", "num_agents", "num_agents_limit", "expiry"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of UserUsage from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if expiry (nullable) is None
        # and model_fields_set contains the field
        if self.expiry is None and "expiry" in self.model_fields_set:
            _dict['expiry'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of UserUsage from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "bytes_transferred": obj.get("bytes_transferred"),
            "bytes_transferred_limit": obj.get("bytes_transferred_limit"),
            "num_messages": obj.get("num_messages"),
            "num_messages_limit": obj.get("num_messages_limit"),
            "bytes_stored": obj.get("bytes_stored"),
            "bytes_stored_limit": obj.get("bytes_stored_limit"),
            "num_agents": obj.get("num_agents"),
            "num_agents_limit": obj.get("num_agents_limit"),
            "expiry": obj.get("expiry")
        })
        return _obj


