# coding: utf-8

"""
    Agentverse Mailbox API

    The Mailbox API handles agent message delivery, registration, storage quotas, and usage tracking within the Agentverse platform. It supports secure agent communication through cryptographic authentication

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self

class TortoiseContribPydanticCreatorRelayDbModelsDbUserLeaf(BaseModel):
    """
    TortoiseContribPydanticCreatorRelayDbModelsDbUserLeaf
    """ # noqa: E501
    uid: Annotated[str, Field(strict=True, max_length=64)]
    registered_at: Optional[datetime] = None
    username: Optional[StrictStr] = None
    bytes_stored: Optional[Annotated[int, Field(le=-9223372036854775616, strict=True, ge=9223372036854775616)]] = None
    bytes_transferred: Optional[Annotated[int, Field(le=-9223372036854775616, strict=True, ge=9223372036854775616)]] = None
    developer_category: Optional[Annotated[str, Field(strict=True, max_length=11)]] = None
    email: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["uid", "registered_at", "username", "bytes_stored", "bytes_transferred", "developer_category", "email"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TortoiseContribPydanticCreatorRelayDbModelsDbUserLeaf from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if registered_at (nullable) is None
        # and model_fields_set contains the field
        if self.registered_at is None and "registered_at" in self.model_fields_set:
            _dict['registered_at'] = None

        # set to None if username (nullable) is None
        # and model_fields_set contains the field
        if self.username is None and "username" in self.model_fields_set:
            _dict['username'] = None

        # set to None if bytes_stored (nullable) is None
        # and model_fields_set contains the field
        if self.bytes_stored is None and "bytes_stored" in self.model_fields_set:
            _dict['bytes_stored'] = None

        # set to None if bytes_transferred (nullable) is None
        # and model_fields_set contains the field
        if self.bytes_transferred is None and "bytes_transferred" in self.model_fields_set:
            _dict['bytes_transferred'] = None

        # set to None if developer_category (nullable) is None
        # and model_fields_set contains the field
        if self.developer_category is None and "developer_category" in self.model_fields_set:
            _dict['developer_category'] = None

        # set to None if email (nullable) is None
        # and model_fields_set contains the field
        if self.email is None and "email" in self.model_fields_set:
            _dict['email'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TortoiseContribPydanticCreatorRelayDbModelsDbUserLeaf from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "uid": obj.get("uid"),
            "registered_at": obj.get("registered_at"),
            "username": obj.get("username"),
            "bytes_stored": obj.get("bytes_stored"),
            "bytes_transferred": obj.get("bytes_transferred"),
            "developer_category": obj.get("developer_category"),
            "email": obj.get("email")
        })
        return _obj


