# coding: utf-8

"""
    Agent Hosting API

      ## Overview  The Agent Hosting API helps users deploy agents to the cloud  ## Authentication  The entire API requires that the user authenticate with the ecosystem first before accessing the api 

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class Agent(BaseModel):
    """
    Agent
    """ # noqa: E501
    name: StrictStr = Field(description="Name of the agent.")
    address: StrictStr = Field(description="Bech32 address of the agent.")
    domain: Optional[StrictStr] = None
    prefix: Optional[StrictStr] = None
    running: StrictBool = Field(description="Whether the agent is currently running.")
    compiled: Optional[StrictBool] = None
    code_digest: Optional[StrictStr] = None
    wallet_address: Optional[StrictStr] = None
    code_update_timestamp: Optional[datetime] = None
    creation_timestamp: Optional[datetime] = None
    avatar_url: Optional[StrictStr] = None
    maintainer_id: Optional[StrictStr] = None
    revision: StrictInt = Field(description="Revision number of the agent.")
    readme: Optional[StrictStr] = None
    short_description: Optional[StrictStr] = None
    wallet_messaging_enabled: Optional[StrictBool] = None
    fire_hosting_enabled: Optional[StrictBool] = None
    total_interactions: Optional[StrictInt] = None
    __properties: ClassVar[List[str]] = ["name", "address", "domain", "prefix", "running", "compiled", "code_digest", "wallet_address", "code_update_timestamp", "creation_timestamp", "avatar_url", "maintainer_id", "revision", "readme", "short_description", "wallet_messaging_enabled", "fire_hosting_enabled", "total_interactions"]

    @field_validator('prefix')
    def prefix_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['agent', 'test-agent']):
            raise ValueError("must be one of enum values ('agent', 'test-agent')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Agent from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if domain (nullable) is None
        # and model_fields_set contains the field
        if self.domain is None and "domain" in self.model_fields_set:
            _dict['domain'] = None

        # set to None if prefix (nullable) is None
        # and model_fields_set contains the field
        if self.prefix is None and "prefix" in self.model_fields_set:
            _dict['prefix'] = None

        # set to None if compiled (nullable) is None
        # and model_fields_set contains the field
        if self.compiled is None and "compiled" in self.model_fields_set:
            _dict['compiled'] = None

        # set to None if code_digest (nullable) is None
        # and model_fields_set contains the field
        if self.code_digest is None and "code_digest" in self.model_fields_set:
            _dict['code_digest'] = None

        # set to None if wallet_address (nullable) is None
        # and model_fields_set contains the field
        if self.wallet_address is None and "wallet_address" in self.model_fields_set:
            _dict['wallet_address'] = None

        # set to None if code_update_timestamp (nullable) is None
        # and model_fields_set contains the field
        if self.code_update_timestamp is None and "code_update_timestamp" in self.model_fields_set:
            _dict['code_update_timestamp'] = None

        # set to None if creation_timestamp (nullable) is None
        # and model_fields_set contains the field
        if self.creation_timestamp is None and "creation_timestamp" in self.model_fields_set:
            _dict['creation_timestamp'] = None

        # set to None if avatar_url (nullable) is None
        # and model_fields_set contains the field
        if self.avatar_url is None and "avatar_url" in self.model_fields_set:
            _dict['avatar_url'] = None

        # set to None if maintainer_id (nullable) is None
        # and model_fields_set contains the field
        if self.maintainer_id is None and "maintainer_id" in self.model_fields_set:
            _dict['maintainer_id'] = None

        # set to None if readme (nullable) is None
        # and model_fields_set contains the field
        if self.readme is None and "readme" in self.model_fields_set:
            _dict['readme'] = None

        # set to None if short_description (nullable) is None
        # and model_fields_set contains the field
        if self.short_description is None and "short_description" in self.model_fields_set:
            _dict['short_description'] = None

        # set to None if wallet_messaging_enabled (nullable) is None
        # and model_fields_set contains the field
        if self.wallet_messaging_enabled is None and "wallet_messaging_enabled" in self.model_fields_set:
            _dict['wallet_messaging_enabled'] = None

        # set to None if fire_hosting_enabled (nullable) is None
        # and model_fields_set contains the field
        if self.fire_hosting_enabled is None and "fire_hosting_enabled" in self.model_fields_set:
            _dict['fire_hosting_enabled'] = None

        # set to None if total_interactions (nullable) is None
        # and model_fields_set contains the field
        if self.total_interactions is None and "total_interactions" in self.model_fields_set:
            _dict['total_interactions'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Agent from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "address": obj.get("address"),
            "domain": obj.get("domain"),
            "prefix": obj.get("prefix"),
            "running": obj.get("running"),
            "compiled": obj.get("compiled"),
            "code_digest": obj.get("code_digest"),
            "wallet_address": obj.get("wallet_address"),
            "code_update_timestamp": obj.get("code_update_timestamp"),
            "creation_timestamp": obj.get("creation_timestamp"),
            "avatar_url": obj.get("avatar_url"),
            "maintainer_id": obj.get("maintainer_id"),
            "revision": obj.get("revision"),
            "readme": obj.get("readme"),
            "short_description": obj.get("short_description"),
            "wallet_messaging_enabled": obj.get("wallet_messaging_enabled"),
            "fire_hosting_enabled": obj.get("fire_hosting_enabled"),
            "total_interactions": obj.get("total_interactions")
        })
        return _obj


