# coding: utf-8

"""
    Agent Hosting API

      ## Overview  The Agent Hosting API helps users deploy agents to the cloud  ## Authentication  The entire API requires that the user authenticate with the ecosystem first before accessing the api 

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class Envelope(BaseModel):
    """
    Represents an envelope for message communication between agents.  Attributes:  version (int): The envelope version.  sender (str): The sender's address.  target (str): The target's address.  session (UUID4): The session UUID that persists for back-and-forth  dialogues between agents.  schema_digest (str): The schema digest for the enclosed message.  protocol_digest (str | None): The digest of the protocol associated with the message  (optional).  payload (str | None): The encoded message payload of the envelope (optional).  expires (int | None): The expiration timestamp (optional).  nonce (int | None): The nonce value (optional).  signature (str | None): The envelope signature (optional).
    """ # noqa: E501
    version: StrictInt
    sender: StrictStr
    target: StrictStr
    session: StrictStr
    schema_digest: StrictStr
    protocol_digest: Optional[StrictStr] = None
    payload: Optional[StrictStr] = None
    expires: Optional[StrictInt] = None
    nonce: Optional[StrictInt] = None
    signature: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["version", "sender", "target", "session", "schema_digest", "protocol_digest", "payload", "expires", "nonce", "signature"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Envelope from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if protocol_digest (nullable) is None
        # and model_fields_set contains the field
        if self.protocol_digest is None and "protocol_digest" in self.model_fields_set:
            _dict['protocol_digest'] = None

        # set to None if payload (nullable) is None
        # and model_fields_set contains the field
        if self.payload is None and "payload" in self.model_fields_set:
            _dict['payload'] = None

        # set to None if expires (nullable) is None
        # and model_fields_set contains the field
        if self.expires is None and "expires" in self.model_fields_set:
            _dict['expires'] = None

        # set to None if nonce (nullable) is None
        # and model_fields_set contains the field
        if self.nonce is None and "nonce" in self.model_fields_set:
            _dict['nonce'] = None

        # set to None if signature (nullable) is None
        # and model_fields_set contains the field
        if self.signature is None and "signature" in self.model_fields_set:
            _dict['signature'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Envelope from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "version": obj.get("version"),
            "sender": obj.get("sender"),
            "target": obj.get("target"),
            "session": obj.get("session"),
            "schema_digest": obj.get("schema_digest"),
            "protocol_digest": obj.get("protocol_digest"),
            "payload": obj.get("payload"),
            "expires": obj.get("expires"),
            "nonce": obj.get("nonce"),
            "signature": obj.get("signature")
        })
        return _obj


