# coding: utf-8

"""
    FastAPI

    A simple fastapi application that services registered agents information

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, StrictInt
from typing import Any, ClassVar, Dict, List, Optional
from agentverse_client.almanac.models.agent import Agent
from typing import Optional, Set
from typing_extensions import Self

class WithPaginationListAgent(BaseModel):
    """
    WithPaginationListAgent
    """ # noqa: E501
    objects: List[Agent]
    total: StrictInt
    page_size: StrictInt
    tracker_last_update: Optional[datetime] = None
    __properties: ClassVar[List[str]] = ["objects", "total", "page_size", "tracker_last_update"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of WithPaginationListAgent from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in objects (list)
        _items = []
        if self.objects:
            for _item_objects in self.objects:
                if _item_objects:
                    _items.append(_item_objects.to_dict())
            _dict['objects'] = _items
        # set to None if tracker_last_update (nullable) is None
        # and model_fields_set contains the field
        if self.tracker_last_update is None and "tracker_last_update" in self.model_fields_set:
            _dict['tracker_last_update'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of WithPaginationListAgent from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "objects": [Agent.from_dict(_item) for _item in obj["objects"]] if obj.get("objects") is not None else None,
            "total": obj.get("total"),
            "page_size": obj.get("page_size"),
            "tracker_last_update": obj.get("tracker_last_update")
        })
        return _obj


