#!/usr/bin/env python
# -*- coding: utf-8 -*-
# Copyright 2012 Rackspace

# All Rights Reserved.
#
#    Licensed under the Apache License, Version 2.0 (the "License"); you may
#    not use this file except in compliance with the License. You may obtain
#    a copy of the License at
#
#         http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#    WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#    License for the specific language governing permissions and limitations
#    under the License.

import os
import sys

import pyrax

creds_file = os.path.expanduser("~/.rackspace_cloud_credentials")
pyrax.set_credential_file(creds_file)
clb = pyrax.cloud_loadbalancers

try:
    lb = clb.list()[0]
except IndexError:
    "You do not have any load balancers yet. Please create one and then re-run this script."
    sys.exit()

print "Load Balancer:", lb
orig = lb.session_persistence
print "Current setting of session persistence:", orig or '""'
print
if orig:
    print "Clearing..."
    lb.session_persistence = ""
else:
    print "Setting persistence to HTTP_COOKIE..."
    lb.session_persistence = "HTTP_COOKIE"
print "New setting of session persistence:", lb.session_persistence or '""'
