# coding: utf-8

"""
    Pulp 3 API

    Fetch, Upload, Organize, and Distribute Software Packages  # noqa: E501

    The version of the OpenAPI document: v3
    Contact: pulp-list@redhat.com
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from pulpcore.client.pulp_ansible.api_client import ApiClient
from pulpcore.client.pulp_ansible.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class PulpAnsibleArtifactsCollectionsV3Api(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create(self, path, file, **kwargs):  # noqa: E501
        """Upload a collection  # noqa: E501

        Create an artifact and trigger an asynchronous task to create Collection content from it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create(path, file, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str path: (required)
        :param file file: The Collection tarball. (required)
        :param str sha256: An optional sha256 checksum of the uploaded file.
        :param str expected_namespace: The expected 'namespace' of the Collection to be verified against the metadata during import.
        :param str expected_name: The expected 'name' of the Collection to be verified against the metadata during import.
        :param str expected_version: The expected version of the Collection to be verified against the metadata during import.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: AsyncOperationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.create_with_http_info(path, file, **kwargs)  # noqa: E501

    def create_with_http_info(self, path, file, **kwargs):  # noqa: E501
        """Upload a collection  # noqa: E501

        Create an artifact and trigger an asynchronous task to create Collection content from it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_with_http_info(path, file, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str path: (required)
        :param file file: The Collection tarball. (required)
        :param str sha256: An optional sha256 checksum of the uploaded file.
        :param str expected_namespace: The expected 'namespace' of the Collection to be verified against the metadata during import.
        :param str expected_name: The expected 'name' of the Collection to be verified against the metadata during import.
        :param str expected_version: The expected version of the Collection to be verified against the metadata during import.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(AsyncOperationResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'path',
            'file',
            'sha256',
            'expected_namespace',
            'expected_name',
            'expected_version'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'path' is set
        if self.api_client.client_side_validation and ('path' not in local_var_params or  # noqa: E501
                                                        local_var_params['path'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `path` when calling `create`")  # noqa: E501
        # verify the required parameter 'file' is set
        if self.api_client.client_side_validation and ('file' not in local_var_params or  # noqa: E501
                                                        local_var_params['file'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `file` when calling `create`")  # noqa: E501

        if self.api_client.client_side_validation and ('sha256' in local_var_params and  # noqa: E501
                                                        len(local_var_params['sha256']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `sha256` when calling `create`, length must be greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and ('expected_namespace' in local_var_params and  # noqa: E501
                                                        len(local_var_params['expected_namespace']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `expected_namespace` when calling `create`, length must be greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and ('expected_name' in local_var_params and  # noqa: E501
                                                        len(local_var_params['expected_name']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `expected_name` when calling `create`, length must be greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and ('expected_version' in local_var_params and  # noqa: E501
                                                        len(local_var_params['expected_version']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `expected_version` when calling `create`, length must be greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'path' in local_var_params:
            path_params['path'] = local_var_params['path']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'file' in local_var_params:
            local_var_files['file'] = local_var_params['file']  # noqa: E501
        if 'sha256' in local_var_params:
            form_params.append(('sha256', local_var_params['sha256']))  # noqa: E501
        if 'expected_namespace' in local_var_params:
            form_params.append(('expected_namespace', local_var_params['expected_namespace']))  # noqa: E501
        if 'expected_name' in local_var_params:
            form_params.append(('expected_name', local_var_params['expected_name']))  # noqa: E501
        if 'expected_version' in local_var_params:
            form_params.append(('expected_version', local_var_params['expected_version']))  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data', 'application/x-www-form-urlencoded'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth', 'cookieAuth']  # noqa: E501

        return self.api_client.call_api(
            '/pulp_ansible/galaxy/{path}/api/v3/artifacts/collections/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AsyncOperationResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_0(self, distro_base_path, path, file, **kwargs):  # noqa: E501
        """Upload a collection  # noqa: E501

        Create an artifact and trigger an asynchronous task to create Collection content from it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_0(distro_base_path, path, file, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str distro_base_path: (required)
        :param str path: (required)
        :param file file: The Collection tarball. (required)
        :param str sha256: An optional sha256 checksum of the uploaded file.
        :param str expected_namespace: The expected 'namespace' of the Collection to be verified against the metadata during import.
        :param str expected_name: The expected 'name' of the Collection to be verified against the metadata during import.
        :param str expected_version: The expected version of the Collection to be verified against the metadata during import.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: AsyncOperationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.create_0_with_http_info(distro_base_path, path, file, **kwargs)  # noqa: E501

    def create_0_with_http_info(self, distro_base_path, path, file, **kwargs):  # noqa: E501
        """Upload a collection  # noqa: E501

        Create an artifact and trigger an asynchronous task to create Collection content from it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_0_with_http_info(distro_base_path, path, file, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str distro_base_path: (required)
        :param str path: (required)
        :param file file: The Collection tarball. (required)
        :param str sha256: An optional sha256 checksum of the uploaded file.
        :param str expected_namespace: The expected 'namespace' of the Collection to be verified against the metadata during import.
        :param str expected_name: The expected 'name' of the Collection to be verified against the metadata during import.
        :param str expected_version: The expected version of the Collection to be verified against the metadata during import.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(AsyncOperationResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'distro_base_path',
            'path',
            'file',
            'sha256',
            'expected_namespace',
            'expected_name',
            'expected_version'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_0" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'distro_base_path' is set
        if self.api_client.client_side_validation and ('distro_base_path' not in local_var_params or  # noqa: E501
                                                        local_var_params['distro_base_path'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `distro_base_path` when calling `create_0`")  # noqa: E501
        # verify the required parameter 'path' is set
        if self.api_client.client_side_validation and ('path' not in local_var_params or  # noqa: E501
                                                        local_var_params['path'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `path` when calling `create_0`")  # noqa: E501
        # verify the required parameter 'file' is set
        if self.api_client.client_side_validation and ('file' not in local_var_params or  # noqa: E501
                                                        local_var_params['file'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `file` when calling `create_0`")  # noqa: E501

        if self.api_client.client_side_validation and ('sha256' in local_var_params and  # noqa: E501
                                                        len(local_var_params['sha256']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `sha256` when calling `create_0`, length must be greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and ('expected_namespace' in local_var_params and  # noqa: E501
                                                        len(local_var_params['expected_namespace']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `expected_namespace` when calling `create_0`, length must be greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and ('expected_name' in local_var_params and  # noqa: E501
                                                        len(local_var_params['expected_name']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `expected_name` when calling `create_0`, length must be greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and ('expected_version' in local_var_params and  # noqa: E501
                                                        len(local_var_params['expected_version']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `expected_version` when calling `create_0`, length must be greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'distro_base_path' in local_var_params:
            path_params['distro_base_path'] = local_var_params['distro_base_path']  # noqa: E501
        if 'path' in local_var_params:
            path_params['path'] = local_var_params['path']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'file' in local_var_params:
            local_var_files['file'] = local_var_params['file']  # noqa: E501
        if 'sha256' in local_var_params:
            form_params.append(('sha256', local_var_params['sha256']))  # noqa: E501
        if 'expected_namespace' in local_var_params:
            form_params.append(('expected_namespace', local_var_params['expected_namespace']))  # noqa: E501
        if 'expected_name' in local_var_params:
            form_params.append(('expected_name', local_var_params['expected_name']))  # noqa: E501
        if 'expected_version' in local_var_params:
            form_params.append(('expected_version', local_var_params['expected_version']))  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data', 'application/x-www-form-urlencoded'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth', 'cookieAuth']  # noqa: E501

        return self.api_client.call_api(
            '/pulp_ansible/galaxy/{path}/api/v3/plugin/ansible/content/{distro_base_path}/collections/artifacts/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AsyncOperationResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_1(self, file, **kwargs):  # noqa: E501
        """Upload a collection  # noqa: E501

        Create an artifact and trigger an asynchronous task to create Collection content from it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_1(file, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param file file: The Collection tarball. (required)
        :param str sha256: An optional sha256 checksum of the uploaded file.
        :param str expected_namespace: The expected 'namespace' of the Collection to be verified against the metadata during import.
        :param str expected_name: The expected 'name' of the Collection to be verified against the metadata during import.
        :param str expected_version: The expected version of the Collection to be verified against the metadata during import.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: AsyncOperationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.create_1_with_http_info(file, **kwargs)  # noqa: E501

    def create_1_with_http_info(self, file, **kwargs):  # noqa: E501
        """Upload a collection  # noqa: E501

        Create an artifact and trigger an asynchronous task to create Collection content from it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_1_with_http_info(file, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param file file: The Collection tarball. (required)
        :param str sha256: An optional sha256 checksum of the uploaded file.
        :param str expected_namespace: The expected 'namespace' of the Collection to be verified against the metadata during import.
        :param str expected_name: The expected 'name' of the Collection to be verified against the metadata during import.
        :param str expected_version: The expected version of the Collection to be verified against the metadata during import.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(AsyncOperationResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'file',
            'sha256',
            'expected_namespace',
            'expected_name',
            'expected_version'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_1" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'file' is set
        if self.api_client.client_side_validation and ('file' not in local_var_params or  # noqa: E501
                                                        local_var_params['file'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `file` when calling `create_1`")  # noqa: E501

        if self.api_client.client_side_validation and ('sha256' in local_var_params and  # noqa: E501
                                                        len(local_var_params['sha256']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `sha256` when calling `create_1`, length must be greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and ('expected_namespace' in local_var_params and  # noqa: E501
                                                        len(local_var_params['expected_namespace']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `expected_namespace` when calling `create_1`, length must be greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and ('expected_name' in local_var_params and  # noqa: E501
                                                        len(local_var_params['expected_name']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `expected_name` when calling `create_1`, length must be greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and ('expected_version' in local_var_params and  # noqa: E501
                                                        len(local_var_params['expected_version']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `expected_version` when calling `create_1`, length must be greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'file' in local_var_params:
            local_var_files['file'] = local_var_params['file']  # noqa: E501
        if 'sha256' in local_var_params:
            form_params.append(('sha256', local_var_params['sha256']))  # noqa: E501
        if 'expected_namespace' in local_var_params:
            form_params.append(('expected_namespace', local_var_params['expected_namespace']))  # noqa: E501
        if 'expected_name' in local_var_params:
            form_params.append(('expected_name', local_var_params['expected_name']))  # noqa: E501
        if 'expected_version' in local_var_params:
            form_params.append(('expected_version', local_var_params['expected_version']))  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data', 'application/x-www-form-urlencoded'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth', 'cookieAuth']  # noqa: E501

        return self.api_client.call_api(
            '/pulp_ansible/galaxy/default/api/v3/artifacts/collections/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AsyncOperationResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_2(self, distro_base_path, file, **kwargs):  # noqa: E501
        """Upload a collection  # noqa: E501

        Create an artifact and trigger an asynchronous task to create Collection content from it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_2(distro_base_path, file, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str distro_base_path: (required)
        :param file file: The Collection tarball. (required)
        :param str sha256: An optional sha256 checksum of the uploaded file.
        :param str expected_namespace: The expected 'namespace' of the Collection to be verified against the metadata during import.
        :param str expected_name: The expected 'name' of the Collection to be verified against the metadata during import.
        :param str expected_version: The expected version of the Collection to be verified against the metadata during import.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: AsyncOperationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.create_2_with_http_info(distro_base_path, file, **kwargs)  # noqa: E501

    def create_2_with_http_info(self, distro_base_path, file, **kwargs):  # noqa: E501
        """Upload a collection  # noqa: E501

        Create an artifact and trigger an asynchronous task to create Collection content from it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_2_with_http_info(distro_base_path, file, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str distro_base_path: (required)
        :param file file: The Collection tarball. (required)
        :param str sha256: An optional sha256 checksum of the uploaded file.
        :param str expected_namespace: The expected 'namespace' of the Collection to be verified against the metadata during import.
        :param str expected_name: The expected 'name' of the Collection to be verified against the metadata during import.
        :param str expected_version: The expected version of the Collection to be verified against the metadata during import.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(AsyncOperationResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'distro_base_path',
            'file',
            'sha256',
            'expected_namespace',
            'expected_name',
            'expected_version'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_2" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'distro_base_path' is set
        if self.api_client.client_side_validation and ('distro_base_path' not in local_var_params or  # noqa: E501
                                                        local_var_params['distro_base_path'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `distro_base_path` when calling `create_2`")  # noqa: E501
        # verify the required parameter 'file' is set
        if self.api_client.client_side_validation and ('file' not in local_var_params or  # noqa: E501
                                                        local_var_params['file'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `file` when calling `create_2`")  # noqa: E501

        if self.api_client.client_side_validation and ('sha256' in local_var_params and  # noqa: E501
                                                        len(local_var_params['sha256']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `sha256` when calling `create_2`, length must be greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and ('expected_namespace' in local_var_params and  # noqa: E501
                                                        len(local_var_params['expected_namespace']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `expected_namespace` when calling `create_2`, length must be greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and ('expected_name' in local_var_params and  # noqa: E501
                                                        len(local_var_params['expected_name']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `expected_name` when calling `create_2`, length must be greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and ('expected_version' in local_var_params and  # noqa: E501
                                                        len(local_var_params['expected_version']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `expected_version` when calling `create_2`, length must be greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'distro_base_path' in local_var_params:
            path_params['distro_base_path'] = local_var_params['distro_base_path']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'file' in local_var_params:
            local_var_files['file'] = local_var_params['file']  # noqa: E501
        if 'sha256' in local_var_params:
            form_params.append(('sha256', local_var_params['sha256']))  # noqa: E501
        if 'expected_namespace' in local_var_params:
            form_params.append(('expected_namespace', local_var_params['expected_namespace']))  # noqa: E501
        if 'expected_name' in local_var_params:
            form_params.append(('expected_name', local_var_params['expected_name']))  # noqa: E501
        if 'expected_version' in local_var_params:
            form_params.append(('expected_version', local_var_params['expected_version']))  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data', 'application/x-www-form-urlencoded'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth', 'cookieAuth']  # noqa: E501

        return self.api_client.call_api(
            '/pulp_ansible/galaxy/default/api/v3/plugin/ansible/content/{distro_base_path}/collections/artifacts/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AsyncOperationResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
