# CellOracle
[![Build Status](https://app.travis-ci.com/morris-lab/CellOracle.svg?branch=master)](https://app.travis-ci.com/morris-lab/CellOracle)

CellOracle is a python library for in silico gene perturbation analyses using single-cell omics data and Gene Regulatory Network models.

For more information, please read our bioRxiv preprint: [CellOracle: Dissecting cell identity via network inference and in silico gene perturbation](https://www.biorxiv.org/content/10.1101/2020.02.17.947416v3).


### Documentation, Codes, and Tutorials
CellOracle documentation is available through the links below.

[Web documentation](https://morris-lab.github.io/CellOracle.documentation/)


### Questions and errors
If you have a question, error, bug, or problem, please use the [Github issue page](https://github.com/morris-lab/CellOracle/issues).

### Supported Species and reference genomes

- Human: ['hg38', 'hg19']
- Mouse: ['mm10', 'mm9']
- S.cerevisiae: ["sacCer2", "sacCer3"]
- Zebrafish: ["danRer7", "danRer10", "danRer11"]
- Xenopus: ["xenTro2", "xenTro3"]
- Rat: ["rn4", "rn5", "rn6"]
- Drosophila: ["dm3", "dm6"]
- C.elegans: ["ce6", "ce10"]
- Arabidopsis: ["TAIR10"]
- Chicken: ["galGal4", "galGal5", "galGal6"]
- Guinea Pig: ["Cavpor3.0"]

Please let us know through [Github issue page](https://github.com/morris-lab/CellOracle/issues) if you have a request for another reference genome.

### Changelog

Please go to [this page](https://morris-lab.github.io/CellOracle.documentation/changelog/index.html).
