# Generated by Django 2.2.4 on 2019-08-07 18:26

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import uuid


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='SupportRequest',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(auto_now_add=True, verbose_name='date created')),
                ('updated', models.DateTimeField(auto_now=True, verbose_name='last updated')),
                ('subject', models.CharField(max_length=120, verbose_name='Subject')),
                ('description', models.TextField(verbose_name='Description')),
                ('uuid', models.UUIDField(default=uuid.uuid4, editable=False, unique=True)),
                ('name', models.CharField(blank=True, max_length=50, verbose_name='Name')),
                ('email', models.EmailField(blank=True, max_length=254, verbose_name='Email')),
                ('url', models.URLField(blank=True, help_text='Where the URL from which it was initiate from.', verbose_name='URL')),
                ('app_version', models.CharField(blank=True, max_length=12, verbose_name='Project Version')),
                ('category', models.IntegerField(choices=[(1, 'Comment'), (2, 'Help'), (3, 'Bug')], default=10, verbose_name='Category')),
                ('status', models.IntegerField(choices=[(1, 'Open'), (10, 'Active'), (20, 'Closed')], default=1, verbose_name='Status')),
                ('assignees', models.ManyToManyField(blank=True, related_name='assignees', to=settings.AUTH_USER_MODEL, verbose_name='Asignees')),
                ('user', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='user', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': 'Support Request',
                'verbose_name_plural': 'Support Requests',
            },
        ),
    ]
