

class SignifyError(Exception):
    """Base class for all errors generated by Signify"""
    pass


class ParseError(SignifyError):
    pass


class SignedPEParseError(ParseError):
    pass


class SignerInfoParseError(ParseError):
    pass


class AuthenticodeParseError(ParseError):
    """Raised when any exception regarding parsing Authenticode structures occurs."""
    pass


class VerificationError(SignifyError):
    pass


class CertificateVerificationError(VerificationError):
    pass


class CertificateNotTrustedVerificationError(CertificateVerificationError):
    pass


class SignerInfoVerificationError(VerificationError):
    pass


class AuthenticodeVerificationError(VerificationError):
    """Raised when any exception regarding verifying Authenticode structures occurs."""
    pass


class AuthenticodeNotSignedError(AuthenticodeVerificationError):
    pass


class AuthenticodeInconsistentDigestAlgorithmError(AuthenticodeVerificationError):
    pass


class AuthenticodeInvalidDigestError(AuthenticodeVerificationError):
    pass


class AuthenticodeCounterSignerError(AuthenticodeVerificationError):
    pass


class CertificateTrustListParseError(SignifyError):
    pass


class CTLCertificateVerificationError(CertificateVerificationError):
    pass
