from .....Internal.Core import Core
from .....Internal.CommandsGroup import CommandsGroup
from .....Internal import Conversions


# noinspection PyPep8Naming,PyAttributeOutsideInit,SpellCheckingInspection
class Noise:
	"""Noise commands group definition. 2 total commands, 0 Sub-groups, 2 group commands"""

	def __init__(self, core: Core, parent):
		self._core = core
		self._base = CommandsGroup("noise", core, parent)

	def get_total(self) -> float:
		"""SCPI: CONFigure:CDMA:SIGNaling<Instance>:FADing:POWer:NOISe:TOTal \n
		Snippet: value: float = driver.configure.fading.power.noise.get_total() \n
		Queries the total noise power. \n
			:return: noise_power: Range: -500 dBm to 500 dBm, Unit: dBm
		"""
		response = self._core.io.query_str('CONFigure:CDMA:SIGNaling<Instance>:FADing:POWer:NOISe:TOTal?')
		return Conversions.str_to_float(response)

	def get_value(self) -> float:
		"""SCPI: CONFigure:CDMA:SIGNaling<Instance>:FADing:POWer:NOISe \n
		Snippet: value: float = driver.configure.fading.power.noise.get_value() \n
		Queries the calculated system bandwidth noise power on the forward link. \n
			:return: noise_power: Range: -500 dBm to 500 dBm, Unit: dBm
		"""
		response = self._core.io.query_str('CONFigure:CDMA:SIGNaling<Instance>:FADing:POWer:NOISe?')
		return Conversions.str_to_float(response)
