"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnDynamoDb = exports.CustomFieldType = exports.SecurityTier = exports.toJson_User = exports.toJson_CustomField = exports.AuthenticationMethod = exports.toJson_CfnDynamoDbProps = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Generated by cdk-import
const cdk = require("aws-cdk-lib");
/**
 * Converts an object of type 'CfnDynamoDbProps' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_CfnDynamoDbProps(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'Name': obj.name,
        'Enabled': obj.enabled,
        'FriendlyName': obj.friendlyName,
        'Description': obj.description,
        'AuthenticationMethod': obj.authenticationMethod,
        'AwsAccessKey': obj.awsAccessKey,
        'AwsSecretKey': obj.awsSecretKey,
        'AwsSessionToken': obj.awsSessionToken,
        'CredentialId': obj.credentialId,
        'DynamodbTableNames': obj.dynamodbTableNames?.map(y => y),
        'AwsRegion': obj.awsRegion,
        'ScannerGroup': obj.scannerGroup,
        'TestConnectionTimeoutInSeconds': obj.testConnectionTimeoutInSeconds,
        'CustomFields': obj.customFields?.map(y => toJson_CustomField(y)),
        'BusinessOwners': obj.businessOwners?.map(y => toJson_User(y)),
        'ItOwners': obj.itOwners?.map(y => toJson_User(y)),
        'Location': obj.location,
        'Scope': obj.scope,
        'SecurityTier': obj.securityTier,
        'Comments': obj.comments,
        'ScanTimeoutInSeconds': obj.scanTimeoutInSeconds,
        'NumberOfParsingThreads': obj.numberOfParsingThreads,
        'EnableStructuredClustering': obj.enableStructuredClustering,
        'EnableClassifiers': obj.enableClassifiers,
        'SampleScanOnly': obj.sampleScanOnly,
        'EnableAdvanceClassifiers': obj.enableAdvanceClassifiers,
        'RdbSampleDataMaxSize': obj.rdbSampleDataMaxSize,
        'ScanWindowName': obj.scanWindowName,
        'IsCorrelationSetSupported': obj.isCorrelationSetSupported,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_CfnDynamoDbProps = toJson_CfnDynamoDbProps;
/* eslint-enable max-len, quote-props */
/**
 * Authentication Method
 *
 * @schema AuthenticationMethod
 */
var AuthenticationMethod;
(function (AuthenticationMethod) {
    /** Default */
    AuthenticationMethod["DEFAULT"] = "Default";
    /** BigID */
    AuthenticationMethod["BIG_ID"] = "BigID";
    /** IAMRole */
    AuthenticationMethod["IAM_ROLE"] = "IAMRole";
})(AuthenticationMethod = exports.AuthenticationMethod || (exports.AuthenticationMethod = {}));
/**
 * Converts an object of type 'CustomField' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_CustomField(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'Name': obj.name,
        'Value': obj.value,
        'Type': obj.type,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_CustomField = toJson_CustomField;
/**
 * Converts an object of type 'User' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_User(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'Id': obj.id,
        'Origin': obj.origin,
        'Email': obj.email,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_User = toJson_User;
/* eslint-enable max-len, quote-props */
/**
 * Security Tier
 *
 * @schema SecurityTier
 */
var SecurityTier;
(function (SecurityTier) {
    /** 1 */
    SecurityTier["VALUE_1"] = "1";
    /** 2 */
    SecurityTier["VALUE_2"] = "2";
    /** 3 */
    SecurityTier["VALUE_3"] = "3";
    /** 4 */
    SecurityTier["VALUE_4"] = "4";
    /** 5 */
    SecurityTier["VALUE_5"] = "5";
})(SecurityTier = exports.SecurityTier || (exports.SecurityTier = {}));
/**
 * @schema CustomFieldType
 */
var CustomFieldType;
(function (CustomFieldType) {
    /** clear */
    CustomFieldType["CLEAR"] = "clear";
    /** encrypted */
    CustomFieldType["ENCRYPTED"] = "encrypted";
})(CustomFieldType = exports.CustomFieldType || (exports.CustomFieldType = {}));
/**
 * A CloudFormation `BigID::DataSource::DynamoDB`
 *
 * @cloudformationResource BigID::DataSource::DynamoDB
 * @stability external
 * @link https://github.com/aws-cloudformation/aws-cloudformation-rpdk.git
 */
class CfnDynamoDb extends cdk.CfnResource {
    /**
     * Create a new `BigID::DataSource::DynamoDB`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnDynamoDb.CFN_RESOURCE_TYPE_NAME, properties: toJson_CfnDynamoDbProps(props) });
        this.props = props;
    }
}
exports.CfnDynamoDb = CfnDynamoDb;
_a = JSII_RTTI_SYMBOL_1;
CfnDynamoDb[_a] = { fqn: "@cdk-cloudformation/bigid-datasource-dynamodb.CfnDynamoDb", version: "1.0.0-alpha.5" };
/**
* The CloudFormation resource type name for this resource class.
*/
CfnDynamoDb.CFN_RESOURCE_TYPE_NAME = "BigID::DataSource::DynamoDB";
//# sourceMappingURL=data:application/json;base64,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