import * as cdk from 'aws-cdk-lib';
import * as constructs from 'constructs';
/**
 * Manage a BigID DynamoDB data source.
 *
 * @schema CfnDynamoDbProps
 */
export interface CfnDynamoDbProps {
    /**
     * @schema CfnDynamoDbProps#Name
     */
    readonly name: string;
    /**
     * @schema CfnDynamoDbProps#Enabled
     */
    readonly enabled?: boolean;
    /**
     * @schema CfnDynamoDbProps#FriendlyName
     */
    readonly friendlyName?: string;
    /**
     * @schema CfnDynamoDbProps#Description
     */
    readonly description?: string;
    /**
     * @schema CfnDynamoDbProps#AuthenticationMethod
     */
    readonly authenticationMethod?: AuthenticationMethod;
    /**
     * @schema CfnDynamoDbProps#AwsAccessKey
     */
    readonly awsAccessKey?: string;
    /**
     * @schema CfnDynamoDbProps#AwsSecretKey
     */
    readonly awsSecretKey?: string;
    /**
     * @schema CfnDynamoDbProps#AwsSessionToken
     */
    readonly awsSessionToken?: string;
    /**
     * @schema CfnDynamoDbProps#CredentialId
     */
    readonly credentialId?: string;
    /**
     * @schema CfnDynamoDbProps#DynamodbTableNames
     */
    readonly dynamodbTableNames?: string[];
    /**
     * @schema CfnDynamoDbProps#AwsRegion
     */
    readonly awsRegion?: string;
    /**
     * @schema CfnDynamoDbProps#ScannerGroup
     */
    readonly scannerGroup?: string;
    /**
     * @schema CfnDynamoDbProps#TestConnectionTimeoutInSeconds
     */
    readonly testConnectionTimeoutInSeconds?: number;
    /**
     * @schema CfnDynamoDbProps#CustomFields
     */
    readonly customFields?: CustomField[];
    /**
     * @schema CfnDynamoDbProps#BusinessOwners
     */
    readonly businessOwners?: User[];
    /**
     * @schema CfnDynamoDbProps#ItOwners
     */
    readonly itOwners?: User[];
    /**
     * @schema CfnDynamoDbProps#Location
     */
    readonly location?: string;
    /**
     * @schema CfnDynamoDbProps#Scope
     */
    readonly scope?: string;
    /**
     * @schema CfnDynamoDbProps#SecurityTier
     */
    readonly securityTier?: SecurityTier;
    /**
     * @schema CfnDynamoDbProps#Comments
     */
    readonly comments?: string;
    /**
     * @schema CfnDynamoDbProps#ScanTimeoutInSeconds
     */
    readonly scanTimeoutInSeconds?: number;
    /**
     * @schema CfnDynamoDbProps#NumberOfParsingThreads
     */
    readonly numberOfParsingThreads?: string;
    /**
     * @schema CfnDynamoDbProps#EnableStructuredClustering
     */
    readonly enableStructuredClustering?: boolean;
    /**
     * @schema CfnDynamoDbProps#EnableClassifiers
     */
    readonly enableClassifiers?: boolean;
    /**
     * @schema CfnDynamoDbProps#SampleScanOnly
     */
    readonly sampleScanOnly?: boolean;
    /**
     * @schema CfnDynamoDbProps#EnableAdvanceClassifiers
     */
    readonly enableAdvanceClassifiers?: boolean;
    /**
     * @schema CfnDynamoDbProps#RdbSampleDataMaxSize
     */
    readonly rdbSampleDataMaxSize?: string;
    /**
     * @schema CfnDynamoDbProps#ScanWindowName
     */
    readonly scanWindowName?: string;
    /**
     * @schema CfnDynamoDbProps#IsCorrelationSetSupported
     */
    readonly isCorrelationSetSupported?: boolean;
}
/**
 * Converts an object of type 'CfnDynamoDbProps' to JSON representation.
 */
export declare function toJson_CfnDynamoDbProps(obj: CfnDynamoDbProps | undefined): Record<string, any> | undefined;
/**
 * Authentication Method
 *
 * @schema AuthenticationMethod
 */
export declare enum AuthenticationMethod {
    /** Default */
    DEFAULT = "Default",
    /** BigID */
    BIG_ID = "BigID",
    /** IAMRole */
    IAM_ROLE = "IAMRole"
}
/**
 * @schema CustomField
 */
export interface CustomField {
    /**
     * @schema CustomField#Name
     */
    readonly name?: string;
    /**
     * @schema CustomField#Value
     */
    readonly value?: string;
    /**
     * @schema CustomField#Type
     */
    readonly type?: CustomFieldType;
}
/**
 * Converts an object of type 'CustomField' to JSON representation.
 */
export declare function toJson_CustomField(obj: CustomField | undefined): Record<string, any> | undefined;
/**
 * @schema User
 */
export interface User {
    /**
     * @schema User#Id
     */
    readonly id?: string;
    /**
     * @schema User#Origin
     */
    readonly origin?: string;
    /**
     * @schema User#Email
     */
    readonly email?: string;
}
/**
 * Converts an object of type 'User' to JSON representation.
 */
export declare function toJson_User(obj: User | undefined): Record<string, any> | undefined;
/**
 * Security Tier
 *
 * @schema SecurityTier
 */
export declare enum SecurityTier {
    /** 1 */
    VALUE_1 = "1",
    /** 2 */
    VALUE_2 = "2",
    /** 3 */
    VALUE_3 = "3",
    /** 4 */
    VALUE_4 = "4",
    /** 5 */
    VALUE_5 = "5"
}
/**
 * @schema CustomFieldType
 */
export declare enum CustomFieldType {
    /** clear */
    CLEAR = "clear",
    /** encrypted */
    ENCRYPTED = "encrypted"
}
/**
 * A CloudFormation `BigID::DataSource::DynamoDB`
 *
 * @cloudformationResource BigID::DataSource::DynamoDB
 * @stability external
 * @link https://github.com/aws-cloudformation/aws-cloudformation-rpdk.git
 */
export declare class CfnDynamoDb extends cdk.CfnResource {
    /**
    * The CloudFormation resource type name for this resource class.
    */
    static readonly CFN_RESOURCE_TYPE_NAME = "BigID::DataSource::DynamoDB";
    /**
     * Resource props.
     */
    readonly props: CfnDynamoDbProps;
    /**
     * Create a new `BigID::DataSource::DynamoDB`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: constructs.Construct, id: string, props: CfnDynamoDbProps);
}
