from typing import Any, IO

def get_root_path(relative_path: str, go_up: int = 0) -> str:
    """ Get the absolute path of the directory.
\tUsually used to get the root path of the project using the __file__ variable.

\tArgs:
\t\trelative_path   (str): The path to get the absolute directory path from
\t\tgo_up           (int): Number of parent directories to go up (default: 0)
\tReturns:
\t\tstr: The absolute path of the directory

\tExamples:

\t\t.. code-block:: python

\t\t\t> get_root_path(__file__)
\t\t\t'C:/Users/Alexandre-PC/AppData/Local/Programs/Python/Python310/lib/site-packages/stouputils'

\t\t\t> get_root_path(__file__, 3)
\t\t\t'C:/Users/Alexandre-PC/AppData/Local/Programs/Python/Python310'
\t"""
def relative_path(file_path: str, relative_to: str = '') -> str:
    ''' Get the relative path of a file relative to a given directory.

\tArgs:
\t\tfile_path     (str): The path to get the relative path from
\t\trelative_to   (str): The path to get the relative path to (default: current working directory -> os.getcwd())
\tReturns:
\t\tstr: The relative path of the file
\tExamples:

\t\t>>> relative_path("D:/some/random/path/stouputils/io.py", "D:\\\\some")
\t\t\'random/path/stouputils/io.py\'
\t\t>>> relative_path("D:/some/random/path/stouputils/io.py", "D:\\\\some\\\\")
\t\t\'random/path/stouputils/io.py\'
\t'''
def super_json_dump(data: Any, file: IO[Any] | None = None, max_level: int = 2, indent: str | int = '\t', suffix: str = '\n') -> str:
    ''' Writes the provided data to a JSON file with a specified indentation depth.
\tFor instance, setting max_level to 2 will limit the indentation to 2 levels.

\tArgs:
\t\tdata (Any): \t\t\t\tThe data to dump (usually a dict or a list)
\t\tfile (IO[Any]): \t\t\tThe file to dump the data to, if None, the data is returned as a string
\t\tmax_level (int):\t\t\tThe depth of indentation to stop at (-1 for infinite)
\t\tindent (str | int):\t\t\tThe indentation character (default: \'\\t\')
\t\tsuffix (str):\t\t\t\tThe suffix to add at the end of the string (default: \'\\n\')
\tReturns:
\t\tstr: The content of the file in every case

\t>>> super_json_dump({"a": [[1,2,3]], "b": 2}, max_level = 0)
\t\'{"a": [[1,2,3]],"b": 2}\\n\'
\t>>> super_json_dump({"a": [[1,2,3]], "b": 2}, max_level = 1)
\t\'{\\n\\t"a": [[1,2,3]],\\n\\t"b": 2\\n}\\n\'
\t>>> super_json_dump({"a": [[1,2,3]], "b": 2}, max_level = 2)
\t\'{\\n\\t"a": [\\n\\t\\t[1,2,3]\\n\\t],\\n\\t"b": 2\\n}\\n\'
\t>>> super_json_dump({"a": [[1,2,3]], "b": 2}, max_level = 3)
\t\'{\\n\\t"a": [\\n\\t\\t[\\n\\t\\t\\t1,\\n\\t\\t\\t2,\\n\\t\\t\\t3\\n\\t\\t]\\n\\t],\\n\\t"b": 2\\n}\\n\'
\t'''
def super_json_load(file_path: str) -> Any:
    """ Load a JSON file from the given path

\tArgs:
\t\tfile_path (str): The path to the JSON file
\tReturns:
\t\tAny: The content of the JSON file
\t"""
def super_copy(src: str, dst: str, create_dir: bool = True, symlink: bool = False) -> str:
    """ Copy a file (or a folder) from the source to the destination

\tArgs:
\t\tsrc         (str):  The source path
\t\tdst         (str):  The destination path
\t\tcreate_dir  (bool): Whether to create the directory if it doesn't exist (default: True)
\t\tsymlink     (bool): Whether to create a symlink instead of copying (Linux only, default: True)
\tReturns:
\t\tstr: The destination path
\t"""
def super_open(file_path: str, mode: str, encoding: str = 'utf-8') -> IO[Any]:
    ''' Open a file with the given mode, creating the directory if it doesn\'t exist (only if writing)

\tArgs:
\t\tfile_path\t(str): The path to the file
\t\tmode\t\t(str): The mode to open the file with, ex: "w", "r", "a", "wb", "rb", "ab"
\t\tencoding\t(str): The encoding to use when opening the file (default: "utf-8")
\tReturns:
\t\topen: The file object, ready to be used
\t'''
def read_file(file_path: str, encoding: str = 'utf-8') -> str:
    ''' Read the content of a file and return it as a string

\tArgs:
\t\tfile_path (str): The path to the file
\t\tencoding  (str): The encoding to use when opening the file (default: "utf-8")
\tReturns:
\t\tstr: The content of the file
\t'''
def replace_tilde(path: str) -> str:
    ''' Replace the "~" by the user\'s home directory

\tArgs:
\t\tpath (str): The path to replace the "~" by the user\'s home directory
\tReturns:
\t\tstr: The path with the "~" replaced by the user\'s home directory
\tExamples:

\t\t.. code-block:: python

\t\t\t> replace_tilde("~/Documents/test.txt")
\t\t\t\'/home/user/Documents/test.txt\'
\t'''
def clean_path(file_path: str, trailing_slash: bool = True) -> str:
    ''' Clean the path by replacing backslashes with forward slashes and simplifying the path

\tArgs:
\t\tfile_path (str): The path to clean
\t\ttrailing_slash (bool): Whether to keep the trailing slash, ex: "test/" -> "test/"
\tReturns:
\t\tstr: The cleaned path
\tExamples:
\t\t>>> clean_path("C:\\\\Users\\\\Stoupy\\\\Documents\\\\test.txt")
\t\t\'C:/Users/Stoupy/Documents/test.txt\'

\t\t>>> clean_path("Some Folder////")
\t\t\'Some Folder/\'

\t\t>>> clean_path("test/uwu/1/../../")
\t\t\'test/\'

\t\t>>> clean_path("some/./folder/../")
\t\t\'some/\'

\t\t>>> clean_path("folder1/folder2/../../folder3")
\t\t\'folder3\'

\t\t>>> clean_path("./test/./folder/")
\t\t\'test/folder/\'

\t\t>>> clean_path("C:/folder1\\\\folder2")
\t\t\'C:/folder1/folder2\'
\t'''
