import requests
from ..decorators import handle_error as handle_error
from ..io import clean_path as clean_path, super_json_load as super_json_load
from ..print import warning as warning
from typing import Any

def load_credentials(credentials_path: str) -> dict[str, Any]:
    ''' Load credentials from a JSON or YAML file into a dictionary.

\tLoads credentials from either a JSON or YAML file and returns them as a dictionary.
\tThe file must contain the required credentials in the appropriate format.

\tArgs:
\t\tcredentials_path (str): Path to the credentials file (.json or .yml)
\tReturns:
\t\tdict[str, Any]: Dictionary containing the credentials

\tExample JSON format:

\t.. code-block:: json

\t\t{
\t\t\t"github": {
\t\t\t\t"username": "Stoupy51",
\t\t\t\t"api_key": "ghp_XXXXXXXXXXXXXXXXXXXXXXXXXX"
\t\t\t}
\t\t}

\tExample YAML format:

\t.. code-block:: yaml

\t\tgithub:
\t\t\tusername: "Stoupy51"
\t\t\tapi_key: "ghp_XXXXXXXXXXXXXXXXXXXXXXXXXX"
\t'''
def handle_response(response: requests.Response, error_message: str) -> None:
    """ Handle a response from the API by raising an error if the response is not successful (status code not in 200-299).

\tArgs:
\t\tresponse\t\t(requests.Response): The response from the API
\t\terror_message\t(str): The error message to raise if the response is not successful
\t"""
def clean_version(version: str, keep: str = '') -> str:
    ''' Clean a version string

\tArgs:
\t\tversion\t(str): The version string to clean
\t\tkeep\t(str): The characters to keep in the version string
\tReturns:
\t\tstr: The cleaned version string

\t>>> clean_version("v1.e0.zfezf0.1.2.3zefz")
\t\'1.0.0.1.2.3\'
\t>>> clean_version("v1.e0.zfezf0.1.2.3zefz", keep="v")
\t\'v1.0.0.1.2.3\'
\t>>> clean_version("v1.2.3b", keep="ab")
\t\'1.2.3b\'
\t'''
def version_to_float(version: str) -> float:
    ''' Converts a version string into a float for comparison purposes.
\tThe version string is expected to follow the format of major.minor.patch.something_else....,
\twhere each part is separated by a dot and can be extended indefinitely.

\tArgs:
\t\tversion (str): The version string to convert. (e.g. "v1.0.0.1.2.3")
\tReturns:
\t\tfloat: The float representation of the version. (e.g. 0)

\t>>> version_to_float("v1.0.0")
\t1.0
\t>>> version_to_float("v1.0.0.1")
\t1.000000001
\t>>> version_to_float("v2.3.7")
\t2.003007
\t>>> version_to_float("v1.0.0.1.2.3")
\t1.0000000010020031
\t>>> version_to_float("v2.0") > version_to_float("v1.0.0.1")
\tTrue
\t'''
