'''This module implements specialized container datatypes providing
alternatives to Python's general purpose built-in containers, dict,
list, set, and tuple.

* namedtuple   factory function for creating tuple subclasses with named fields
* deque        list-like container with fast appends and pops on either end
* ChainMap     dict-like class for creating a single view of multiple mappings
* Counter      dict subclass for counting hashable objects
* OrderedDict  dict subclass that remembers the order entries were added
* defaultdict  dict subclass that calls a factory function to supply missing values
* UserDict     wrapper around dictionary objects for easier dict subclassing
* UserList     wrapper around list objects for easier list subclassing
* UserString   wrapper around string objects for easier string subclassing

'''

__version__ = '0.0.3'
__all__ = [
    'workers'
    'ChainMap',
    'Counter',
    'OrderedDict',
    'UserDict',
    'UserList',
    'UserString',
    'defaultdict',
    'deque',
    'namedtuple',
]
__author__ = 'Ramón Hernández León <rhdezl05@gmail.com>'

import workers as workers
import cli as cli
import gui as gui
import utilities as utilities

# try:
#     from _collections import deque
# except ImportError:
#     pass
# else:
#     _collections_abc.MutableSequence.register(deque)

# def ChainMap():
#     pass