"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ServiceCatalogDeployAction = void 0;
const codepipeline = require("@aws-cdk/aws-codepipeline");
const iam = require("@aws-cdk/aws-iam");
const action_1 = require("../action");
/**
 * CodePipeline action to connect to an existing ServiceCatalog product.
 *
 * **Note**: this class is still experimental, and may have breaking changes in the future!
 *
 * @experimental
 */
class ServiceCatalogDeployAction extends action_1.Action {
    constructor(props) {
        super({
            ...props,
            provider: 'ServiceCatalog',
            category: codepipeline.ActionCategory.DEPLOY,
            artifactBounds: {
                minInputs: 1,
                maxInputs: 1,
                minOutputs: 0,
                maxOutputs: 0,
            },
            inputs: [props.templatePath.artifact],
        });
        this.templatePath = props.templatePath.location;
        this.productVersionName = props.productVersionName;
        this.productVersionDescription = props.productVersionDescription;
        this.productId = props.productId;
        this.productType = 'CLOUD_FORMATION_TEMPLATE';
    }
    bound(_scope, _stage, options) {
        options.role.addManagedPolicy(iam.ManagedPolicy.fromAwsManagedPolicyName('AWSServiceCatalogAdminFullAccess'));
        // Attempt at least privilege; using this alone fails with "invalid template".
        // Should construct ARN: 'arn:aws:catalog:<region>:<accountID>:product/' + this.scProductId
        // options.role.addToPolicy(new PolicyStatement({
        //   resources: ['*'],
        //   actions: ['servicecatalog:UpdateProduct', 'servicecatalog:ListProvisioningArtifacts', 'servicecatalog:CreateProvisioningArtifact'],
        // }));
        // the Action's Role needs to read from the Bucket to get artifacts
        options.bucket.grantRead(options.role);
        return {
            configuration: {
                TemplateFilePath: this.templatePath,
                ProductVersionName: this.productVersionName,
                ProductVersionDescription: this.productVersionDescription,
                ProductType: this.productType,
                ProductId: this.productId,
            },
        };
    }
}
exports.ServiceCatalogDeployAction = ServiceCatalogDeployAction;
//# sourceMappingURL=data:application/json;base64,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