"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CustomActionRegistration = void 0;
const codepipeline = require("@aws-cdk/aws-codepipeline");
const cdk = require("@aws-cdk/core");
/**
 * The resource representing registering a custom Action with CodePipeline.
 * For the Action to be usable, it has to be registered for every region and every account it's used in.
 * In addition to this class, you should most likely also provide your clients a class
 * representing your custom Action, extending the Action class,
 * and taking the `actionProperties` as properly typed, construction properties.
 */
class CustomActionRegistration extends cdk.Construct {
    constructor(parent, id, props) {
        super(parent, id);
        new codepipeline.CfnCustomActionType(this, 'Resource', {
            category: props.category,
            inputArtifactDetails: {
                minimumCount: props.artifactBounds.minInputs,
                maximumCount: props.artifactBounds.maxInputs,
            },
            outputArtifactDetails: {
                minimumCount: props.artifactBounds.minOutputs,
                maximumCount: props.artifactBounds.maxOutputs,
            },
            provider: props.provider,
            version: props.version || '1',
            settings: {
                entityUrlTemplate: props.entityUrl,
                executionUrlTemplate: props.executionUrl,
            },
            configurationProperties: props.actionProperties === undefined ? undefined : props.actionProperties.map((ap) => {
                return {
                    key: ap.key || false,
                    secret: ap.secret || false,
                    ...ap,
                };
            }),
        });
    }
}
exports.CustomActionRegistration = CustomActionRegistration;
//# sourceMappingURL=data:application/json;base64,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