LaPros
================

<!-- WARNING: THIS FILE WAS AUTOGENERATED! DO NOT EDIT! -->

## Install

`pip install lapros`

## How to use

LaPros works with classifiers. It ranks the suspicious labels given
probabilies by some classification model. You can use normal Python
lists, Numpy arrays or Pandas data. Return values are in a Numpy array
or a Pandas series, the larger the value, the more suspicious are the
coresponding labels.

``` python
from lapros import suspect
```

``` python
labels = [1, 0, 0, 1, 1];
```

``` python
probas = [
    #
    [0.5, 0.6, 0.7, 0.8, 0.9],
    [0.5, 0.4, 0.3, 0.2, 0.1],
];
```

``` python
suspect(
    probas,
    labels=labels,
)
```

    DEBUG lapros.api.suspect:68 Normal Python lists
    DEBUG lapros.api.suspect:30 Numpy arrays labels and probas must have same length 5 vs 2
    DEBUG lapros.api.suspect:34 Trying to reshape probas
    DEBUG lapros.api.suspect:36 Shape of labels and probas: (5,) vs (5, 2)
    DEBUG lapros.alg.avg_confidence:26 [0.8        0.33333333]
    DEBUG lapros.alg.find_likely_label:44 [1 1 1 1 1]
    DEBUG lapros.alg.rank_suspicious:70          err
    id          
    1   0.566667
    2   0.066667

<div>
<style scoped>
    .dataframe tbody tr th:only-of-type {
        vertical-align: middle;
    }

    .dataframe tbody tr th {
        vertical-align: top;
    }

    .dataframe thead th {
        text-align: right;
    }
</style>
<table border="1" class="dataframe">
  <thead>
    <tr style="text-align: right;">
      <th></th>
      <th>err</th>
    </tr>
    <tr>
      <th>id</th>
      <th></th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <th>1</th>
      <td>0.566667</td>
    </tr>
    <tr>
      <th>2</th>
      <td>0.066667</td>
    </tr>
  </tbody>
</table>
</div>
