# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/10_api.ipynb.

# %% auto 0
__all__ = ['suspect']

# %% ../nbs/10_api.ipynb 2
import numpy as np
import pandas as pd
from plum import dispatch
from lapros.util import set_logger

logger = set_logger();

# %% ../nbs/10_api.ipynb 11
@dispatch
def suspect(
    probas: np.ndarray,
    *,
    labels: np.ndarray,
) -> pd.DataFrame:
    """Rank the suspicious labels given probas from a classifier.

    Params:
        labels: Numpy Array of shape n x 1, label 0 for negative, 1 for positive cases.
        probas: Numpy Array of shape n x m, probabilites for possible classes.

    Return:
        ranks: Pandas DataFrame of one column, the magnitude of suspicious labels, valued between [0, 1], the larger the more suspicious. The index of the DataFrame indicates the index of suspicious samples.
    """
    logger.debug(
        f"Numpy arrays labels and probas must have same length {len(labels)} vs {len(probas)}"
    )
    if len(labels) != len(probas):
        logger.debug("Trying to reshape probas")
        probas = probas.reshape((len(labels), -1))
    logger.debug(f"Shape of labels and probas: {labels.shape} vs {probas.shape}")
    from lapros.alg import suspect

    ranks = suspect(ys=labels, ps=probas)

    return ranks

# %% ../nbs/10_api.ipynb 16
@dispatch
def suspect(
    probas: pd.DataFrame,
    *,
    labels: pd.Series,
) -> pd.DataFrame:
    """Rank the suspicious using Pandas series and dataframes"""
    logger.debug(
        f"Pandas series labels and dataframe probas must have same length {len(labels)} vs {len(probas)}"
    )
    ranks = suspect(
        probas.to_numpy(),
        labels=labels.to_numpy(),
    )
    return ranks

# %% ../nbs/10_api.ipynb 19
@dispatch
def suspect(
    probas: list,
    *,
    labels: list,
) -> pd.DataFrame:
    """Rank the  suspicious using normal Python lists"""
    logger.debug("Normal Python lists")
    ranks = suspect(
        np.array(probas),
        labels=np.array(labels),
    )
    return ranks
